/* Drawing on Territory
 * This file is part of YY-server of YYonX (1.3 Distribution)
 * $Id: com_draw.c,v 3.0 1992/10/08 04:59:44 keisuke Exp $
 */

#ifndef lint
static char *RcsId
    = "$Id: com_draw.c,v 3.0 1992/10/08 04:59:44 keisuke Exp $";
#endif

/****************************************************************************
%%%COPYRIGHT%%%
;;; Authors:
;;;   Version 1.0 90/02/28 by Keisuke 'Keiko' Tanaka
;;;				(keisuke@csrl.aoyama.ac.jp)
;;;   Version 2.0 90/08/27 by Keisuke 'Keiko' Tanaka
;;;			Page Mode Territory is supported
;;;   Version 2.2 90/11/05 by Keisuke 'Keiko' Tanaka
;;;			Copyright Notice is rewritten
;;;   Version 2.10 90/01/31 by Keisuke 'Keiko' Tanaka
;;;			Support YY-Image
;;;
****************************************************************************/

/****************************************************************************
  $Revision: 3.0 $ Written by Keisuke 'Keiko' Tanaka
  $Date: 1992/10/08 04:59:44 $
****************************************************************************/

#include <stdio.h>
#include <sys/types.h>
#include "yydefs.h"
#include "yypacket.h"
#include "xwindow.h"
#include "territory.h"

/*
 * Drawing on Territory
 */


/* int set_int_on_gcv(pkt, mask, val_p, min, max)
 *
 * ѥå pkt ҤȤɤ߽Фơ*val_p ˥åȤ
 * åȤ mask Ϳ줿֤ͤ
 */
static int set_int_on_gcv(pkt, mask, val_p, min, max)
    yy_packet *pkt;	/* ѥå */
    u_long mask;	/* δؿ */
    int *val_p;		/* ꤹ륢ɥ쥹 */
    int min, max;	/* ꤹ٤ϰ */
{
    register int val = read_packet_entry_integer(pkt);
    if ((min >= 0 && val < min) || (max > 0 && val > max))
	return 0;
    *val_p = val;
    return mask;
}
    

void yy_gc_setoperation(disp, gc, operation)
    Display *disp;
    GC gc;
    int operation;
{
    XGCValues gcv;
    DebugSetFunc("xwindow", "yy_gc_setoperation");
    gcv.function = operation;
    XChangeGC(disp, gc, GCFunction, &gcv);
    DebugEndFunc("xwindow", "yy_gc_setoperation");
}


void yy_gc_setdefaultoperation(disp, gc)
    Display *disp;
    GC gc;
{
    yy_gc_setoperation(disp, gc, GXcopy);
}

void yy_gc_setcolor(disp, gc, color)
    Display *disp;
    GC gc;
    register x_color color;
{
    XGCValues gcv;
    DebugSetFunc("xwindow", "yy_gc_setcolor");
    gcv.foreground = color;
    XChangeGC(disp, gc, GCForeground, &gcv);
    DebugEndFunc("xwindow", "yy_gc_setcolor");
}

void yy_gc_setdefaultcolor(disp, gc)
    Display *disp;
    GC gc;
{
    yy_gc_setcolor(disp, gc, BlackPixel(disp, DefaultScreen(disp)));
}

/*
 */
void change_gc(disp, gc, pkt, mask, yygc, gcon)
    Display *disp;
    GC gc;
    yy_packet *pkt;
    int mask;
    YYGC *yygc;
    YYGCONTEXT *gcon;
{
    u_long xmask = 0;
    XGCValues gcv;

    DebugSetFunc("xwindow", "change_gc");
    if (gcon != (YYGCONTEXT *)NULL) bzero(gcon,sizeof(YYGCONTEXT));

    /* ǥեȾ */
    xmask = (GCLineStyle|GCFillStyle);
    gcv.line_style = LineSolid;
    gcv.fill_style = FillSolid;
    if (mask & YYGC_LINWIDTH) {
	xmask |= set_int_on_gcv(pkt, GCLineWidth, &gcv.line_width, 0, -1);
	DebugPrint1(5, "XChangeGC(GCLineWidth, %d)\n", gcv.line_width);
	if ((xmask & GCLineWidth) && yygc != (YYGC *)NULL)
	    yygc->yygcLineWidth = MAX(gcv.line_width, 1);
	if (gcon != (YYGCONTEXT *)NULL) gcon->ygLineWidth = gcv.line_width;
    }
    if (mask & YYGC_OPERATION) {
	xmask |= set_int_on_gcv(pkt, GCFunction, &gcv.function,
				GXclear, GXset);
	if (gcon != (YYGCONTEXT *)NULL) gcon->ygFunction = gcv.function;
    }
    if (mask & YYGC_EDGE) {
	xmask |= set_int_on_gcv(pkt, GCCapStyle, &gcv.cap_style,
				CapNotLast, CapProjecting);
	if (gcon != (YYGCONTEXT *)NULL) gcon->ygCapStyle = gcv.cap_style;
    }
    if (mask & YYGC_CONNECT)
	xmask |= set_int_on_gcv(pkt, GCJoinStyle, &gcv.join_style,
				JoinMiter, JoinBevel);
    if (mask & YYGC_COLOR) {
	register x_color color;
	color = read_packet_entry_color(pkt);
	DebugPrint1(5, "XChangeGC(GCForeground, %lu)\n", color);
	xmask |= GCForeground;
	gcv.foreground = color;
	if (gcon != (YYGCONTEXT *)NULL) gcon->ygColor = color;
    }
    if (mask & YYGC_DASH) {
	int leng = read_packet_entry_integer(pkt);
	if (gcon != (YYGCONTEXT *)NULL) gcon->ygDash = leng;
	if (leng > 0) {
	    u_char dash_pattern1[8];
	    u_char dash_pattern2[8];
	    u_char c, cur;
	    register u_char *s;
	    register int loop = 8;
	    register int len;
	    read_packet_entry_string(pkt, 1, dash_pattern1);
	    c = dash_pattern1[0];
	    s = dash_pattern2;
	    for (len = 0, cur = 0; loop-- > 0 ; c <<= 1) {
		if ((c & 0200) == cur) {
		    len++;
		} else {
		    if (len > 0) { *s++ = len; len = 0; }
		    cur = (c & 0200);
		}
	    }
	    if (s == dash_pattern2) {
		*s++ = 4; *s++ = 4;
	    }
	    xmask |= GCLineStyle;
	    gcv.line_style = LineOnOffDash;
	    XSetDashes(disp, gc, 0, dash_pattern2, (s - dash_pattern2));
	}
    }
    if (mask & YYGC_FILL)
	xmask |= set_int_on_gcv(pkt, GCFillRule, &gcv.fill_rule,
				EvenOddRule, WindingRule);
    if (mask & YYGC_PATTERN) {
	int tr_id = read_packet_entry_integer(pkt);
	register territory_entry *ttr;
	if (tr_id > 0 &&
	    (ttr = search_territory(tr_id)) != (TERRITORY *)NULL) {
	    xmask |= (GCFillStyle|GCTile);
	    gcv.fill_style = FillTiled;
	    gcv.tile = ttr->teXEnt.txPixmap;
	}
    }
    if (mask & YYGC_ARCMODE)
	xmask |= set_int_on_gcv(pkt, GCArcMode, &gcv.arc_mode,
				ArcChord, ArcPieSlice);
    if (xmask)
	XChangeGC(disp, gc, xmask, &gcv);
    DebugEndFunc("xwindow", "change_gc");
}


/***************************************************************************
 ***** Command 20
 *****
 *****  Draw Point
 *****
 ***************************************************************************/
yy_packet *yycom_draw_point(CH, pkt)
    yy_comm_channel *CH;
    yy_packet *pkt;
{
    x_private *xp = XPRIVATE(CH);
    TERRITORY *tr;
    TERRITORY_X_ENTRY *tx;
    yy_packet *err;
    int x, y;

    DebugSetFunc("draw", "yycom_draw_point");
    if ((tr = catch_territory(pkt, TR_DRAWABLE, &err)) == (TERRITORY *)NULL)
	goto send_reply;
    err = (yy_packet *)NULL;
    tx = GetTerritoryXEntry(tr);

    /* draw_point(tr,x,y,ope,color) */
    x = read_packet_entry_integer(pkt);
    y = read_packet_entry_integer(pkt);
    change_gc(xp->xDisp, tx->txGC, pkt, (YYGC_OPERATION|YYGC_COLOR),
			  (YYGC *)NULL, (YYGCONTEXT *)NULL);
    if(tr->teTRType != TR_SPLITE) {
	DebugPrint3(1, "draw_point(%d,%d,%d)\n", tr->teID, x, y);
	XDrawPoint(xp->xDisp, tx->txPixmap, tx->txGC, x, y);
	if (IsVisibleTerritory(tr)) {
	    XDrawPoint(xp->xDisp, tx->txWindow, tx->txGC, x, y);
	    CH->ccXNeedFlush = TRUE;
	}
    } else {
	/* ץ饤ȥƥȥ */
	make_splite_draw_point(CH, tr, x, y);
	CH->ccXNeedFlush = TRUE;
    }
 send_reply:
    DebugEndFunc("draw", "yycom_draw_point");
    return err;
}


/***************************************************************************
 ***** Command 21
 *****
 *****  Draw Line
 *****
 ***************************************************************************/

yy_packet *yycom_draw_line(CH, pkt)
    yy_comm_channel *CH;
    yy_packet *pkt;
{
    x_private *xp = XPRIVATE(CH);
    TERRITORY *tr;
    TERRITORY_X_ENTRY *tx;
    yy_packet *err;
    int x1, y1, x2, y2;
    YYGCONTEXT yygcon;

    DebugSetFunc("draw", "yycom_draw_line");
    if ((tr = catch_territory(pkt, TR_DRAWABLE, &err)) == (TERRITORY *)NULL)
	goto send_reply;
    err = (yy_packet *)NULL;
    tx = GetTerritoryXEntry(tr);
    /* draw_line(tr, x1, y1, x2, y2, wid, ope, edge, color, dash) */
#ifdef SHIOTACG
    if (tr->teTRType != TR_SPLITE) {
	x1 = read_packet_entry_integer(pkt);
	y1 = read_packet_entry_integer(pkt);
	x2 = read_packet_entry_integer(pkt);
	y2 = read_packet_entry_integer(pkt);
	change_gc(xp->xDisp, tx->txGC, pkt,
		  (YYGC_LINWIDTH|YYGC_OPERATION|YYGC_EDGE|
		   YYGC_COLOR|YYGC_DASH),
		  (YYGC *)NULL, (YYGCONTEXT *)NULL);
	if (tr->teTRType != TR_SPLITE) {
	    XDrawLine(xp->xDisp, tx->txPixmap, tx->txGC, x1, y1, x2, y2);
	    if (IsVisibleTerritory(tr)) {
		XDrawLine(xp->xDisp, tx->txWindow, tx->txGC, x1, y1, x2, y2);
		CH->ccXNeedFlush = TRUE;
	    }
	}
    } else {
	struct shioshio {
	    int x1, y1, x2, y2;
	    YYGCONTEXT gcop;
	} *lin;
	YYGCONTEXT *gp;
	lin = (struct shioshio *)(pkt->pktRWPtr);
	/* GC  */
	if ((gp = &lin->gcop)->ygDash != 0) {
	    register int x;
	    read_packet_entry_integer(pkt);
	    read_packet_entry_integer(pkt);
	    read_packet_entry_integer(pkt);
	    read_packet_entry_integer(pkt);
	    change_gc(xp->xDisp, tx->txGC, pkt,
		      (YYGC_LINWIDTH|YYGC_OPERATION|YYGC_EDGE|
		       YYGC_COLOR|YYGC_DASH),
		      (YYGC *)NULL, (YYGCONTEXT *)NULL);

	} else {
	    XGCValues gcv;
	    gcv.line_width = lin->gcop.ygLineWidth;
	    gcv.function = lin->gcop.ygFunction;
	    gcv.cap_style = lin->gcop.ygCapStyle;
	    gcv.foreground = lin->gcop.ygColor;
    	    gcv.line_style = LineSolid;
    	    gcv.fill_style = FillSolid;
	    XChangeGC(xp->xDisp, tx->txGC,
			(GCLineStyle|GCFillStyle|GCLineWidth|GCFunction|GCCapStyle|GCForeground), &gcv);
	}
	make_splite_draw_line(CH,tr,lin->x1,lin->y1,lin->x2,lin->y2,
			      &lin->gcop);
    }
#else /*!SHIOTACG*/
    x1 = read_packet_entry_integer(pkt); y1 = read_packet_entry_integer(pkt);
    x2 = read_packet_entry_integer(pkt); y2 = read_packet_entry_integer(pkt);
    change_gc(xp->xDisp, tx->txGC, pkt,
	      (YYGC_LINWIDTH|YYGC_OPERATION|YYGC_EDGE|YYGC_COLOR|YYGC_DASH),
	      (YYGC *)NULL, (YYGCONTEXT *)&yygcon);

    if (tr->teTRType != TR_SPLITE) {
	XDrawLine(xp->xDisp, tx->txPixmap, tx->txGC, x1, y1, x2, y2);
	if (IsVisibleTerritory(tr)) {
	    XDrawLine(xp->xDisp, tx->txWindow, tx->txGC, x1, y1, x2, y2);
	    CH->ccXNeedFlush = TRUE;
	}
    } else {
	make_splite_draw_line(CH,tr,x1,y1,x2,y2,yygcon);
	CH->ccXNeedFlush = TRUE;
    }
#endif /*!SHIOTACG*/
 send_reply:
    DebugEndFunc("draw", "yycom_draw_line");
    return err;
}


/***************************************************************************
 ***** Command 26
 *****
 *****  Draw Rectangle
 *****
 ***************************************************************************/

yy_packet *yycom_draw_rectangle(CH, pkt)
    yy_comm_channel *CH;
    yy_packet *pkt;
{
    x_private *xp = XPRIVATE(CH);
    TERRITORY *tr;
    TERRITORY_X_ENTRY *tx;
    yy_packet *err;
    int x, y, w, h;
    YYGC yygc_val;

    DebugSetFunc("draw", "yycom_draw_rectangle");
    if ((tr = catch_territory(pkt, TR_DRAWABLE, &err)) == (TERRITORY *)NULL) {
	DebugEndFunc("draw", "yycom_draw_rectangle");
	return err;
    }
    tx = GetTerritoryXEntry(tr);
    /* draw_rectangle(tr,x,y,w,h,wid,ope,color,dash) */
    x = read_packet_entry_integer(pkt);
    y = read_packet_entry_integer(pkt);
    w = read_packet_entry_integer(pkt);
    h = read_packet_entry_integer(pkt);
    change_gc(xp->xDisp, tx->txGC, pkt,
	      (YYGC_LINWIDTH|YYGC_OPERATION|YYGC_COLOR|YYGC_DASH),
	      &yygc_val, (YYGCONTEXT *)NULL);
    x += (yygc_val.yygcLineWidth >> 1);
    y += (yygc_val.yygcLineWidth >> 1);
    w -= yygc_val.yygcLineWidth;
    h -= yygc_val.yygcLineWidth;
    DebugPrint5(1, " Draw Rectangle (%d,%d)[%d,%d] on Territory#%d\n",
		x, y, w, h, tr->teID);
    if (tr->teTRType != TR_SPLITE) {
	XDrawRectangle(xp->xDisp, tx->txPixmap, tx->txGC, x, y, w, h);
	if (IsVisibleTerritory(tr)) {
	    CH->ccXNeedFlush = TRUE;
	    XDrawRectangle(xp->xDisp, tx->txWindow, tx->txGC, x, y, w, h);
	}
    } else {
	make_splite_draw_rectangle(CH,tr, x, y, w, h, 0);
	CH->ccXNeedFlush = TRUE;
    }
    DebugEndFunc("draw", "yycom_draw_rectangle");
    return (yy_packet *)NULL;
}


static yy_packet *do_draw_lines(CH, pkt, polygon)
    yy_comm_channel *CH;
    yy_packet *pkt;
    bool polygon;
{
    x_private *xp = XPRIVATE(CH);
    TERRITORY *tr;
    TERRITORY_X_ENTRY *tx;
    yy_packet *err;
    XPoint *points, *p;
    int n, l;

    DebugSetFunc("draw", "do_draw_lines");
    if ((tr = catch_territory(pkt, TR_DRAWABLE, &err)) == (TERRITORY *)NULL) {
	DebugPrint0(1, "> Can't find Territory for drawing lines\n");
	DebugEndFunc("draw", "do_draw_lines");
	return err;
    }
    tx = GetTerritoryXEntry(tr);
    /* draw_lines(n, pointes, points, ..) */
    n = read_packet_entry_integer(pkt);
    DebugPrint1(7, "> Will Draw Lines with %d points\n", n);

    points = (XPoint *)memCALLOC(n+1, sizeof(XPoint));
    for (p = points, l = n; l > 0; p++, l--) {
	p->x = read_packet_entry_integer(pkt);
	p->y = read_packet_entry_integer(pkt);
	DebugPrint2(7, "> point (%d,%d)\n", p->x, p->y);
    }

    if (polygon) {
	p->x = points->x; p->y = points->y; n++;
	change_gc(xp->xDisp, tx->txGC, pkt,
		  (YYGC_LINWIDTH|YYGC_OPERATION|
		   YYGC_CONNECT|YYGC_COLOR|YYGC_DASH), (YYGC *)NULL,
		  (YYGCONTEXT *)NULL);
    } else
	change_gc(xp->xDisp, tx->txGC, pkt,
		  (YYGC_LINWIDTH|YYGC_OPERATION|YYGC_EDGE|
		   YYGC_CONNECT|YYGC_COLOR|YYGC_DASH), (YYGC *)NULL,
		  (YYGCONTEXT *)NULL);
    
    if(tr->teTRType != TR_SPLITE) {
	XDrawLines(xp->xDisp, tx->txPixmap, tx->txGC, points, n, 
		   CoordModeOrigin);
	if (IsVisibleTerritory(tr)) {
	    XDrawLines(xp->xDisp, tx->txWindow, tx->txGC,
		       points, n, CoordModeOrigin);
	    CH->ccXNeedFlush = TRUE;
	}
    } else {
	make_splite_draw_polygon(CH,tr,n,points,0);
	CH->ccXNeedFlush = TRUE;
    }
    free(points);
    DebugEndFunc("draw", "do_draw_lines");
    return (yy_packet *)NULL;
}


/***************************************************************************
 ***** Command 23
 *****
 *****  Draw Lines
 *****
 ***************************************************************************/

yy_packet *yycom_draw_lines(ch, pkt)
    yy_comm_channel *ch;
    yy_packet *pkt;
{
    return do_draw_lines(ch, pkt, FALSE);
}

/***************************************************************************
 ***** Command 24
 *****
 *****  Draw Polygon
 *****
 ***************************************************************************/

yy_packet *yycom_draw_polygon(ch, pkt)
    yy_comm_channel *ch;
    yy_packet *pkt;
{
    return do_draw_lines(ch, pkt, TRUE);
}


/***************************************************************************
 ***** Command 22
 *****
 *****  Draw Circle
 *****
 ***************************************************************************/

yy_packet *yycom_draw_circle(ch, pkt)
    yy_comm_channel *ch;
    yy_packet *pkt;
{
    x_private *xp = XPRIVATE(ch);
    TERRITORY *tr;
    TERRITORY_X_ENTRY *tx;
    yy_packet *err;
    int x, y, r;

    DebugSetFunc("draw", "yycom_draw_circle");
    if ((tr = catch_territory(pkt, TR_DRAWABLE, &err)) == (TERRITORY *)NULL) {
	DebugEndFunc("draw", "yycom_draw_circle");
	return err;
    }
    tx = GetTerritoryXEntry(tr);
    /* draw_circle(tr,x,y,r) */
    x = read_packet_entry_integer(pkt);
    y = read_packet_entry_integer(pkt);
    r = read_packet_entry_integer(pkt);
    x -= r;
    y -= r;
    r <<= 1;
    change_gc(xp->xDisp, tx->txGC, pkt,
	      (YYGC_LINWIDTH|YYGC_OPERATION|YYGC_COLOR|YYGC_DASH),
	      (YYGC *)NULL, (YYGCONTEXT *)NULL);
    if(tr->teTRType != TR_SPLITE) {
	XDrawArc(xp->xDisp, tx->txPixmap, tx->txGC, x, y, r, r, 0, YYPI2);
	if (IsVisibleTerritory(tr)) {
	    XDrawArc(xp->xDisp, tx->txWindow, tx->txGC, x, y, r, r, 0, YYPI2);
	    ch->ccXNeedFlush = TRUE;
	}
    } else {
	make_splite_draw_arc(ch,tr,x,y,r,r,0,YYPI2,0);
	ch->ccXNeedFlush = TRUE;
    }
    DebugEndFunc("draw", "yycom_draw_circle");
    return (yy_packet *)NULL;
}


/***************************************************************************
 ***** Command 25
 *****
 *****  Draw Arc
 *****
 ***************************************************************************/

yy_packet *yycom_draw_arc(ch, pkt)
    yy_comm_channel *ch;
    yy_packet *pkt;
{
    x_private *xp = XPRIVATE(ch);
    TERRITORY *tr;
    TERRITORY_X_ENTRY *tx;
    yy_packet *err;
    int x, y, r; int a1, a2, a0, a_diff;

    DebugSetFunc("draw", "yycom_draw_arc");
    if ((tr = catch_territory(pkt, TR_DRAWABLE, &err)) == (TERRITORY *)NULL) {
	DebugEndFunc("draw", "yycom_draw_arc");
	return err;
    }
    tx = GetTerritoryXEntry(tr);
    /* draw_arc(tr,x,y,r,a1,a2,wid,ope,color,dash) */
    x = read_packet_entry_integer(pkt);
    y = read_packet_entry_integer(pkt);
    r = read_packet_entry_integer(pkt);
    x -= r; y -= r; r <<= 1;
    a1 = (read_packet_entry_integer(pkt) % YYPI2);
    a2 = (read_packet_entry_integer(pkt) % YYPI2);
#ifndef NOIPAPATCH
    /* źˤ뽤 1991.12.12 */
    if (a1 < a2) { a0 = a1; a_diff = a2 - a1; }
    else	 { a0 = a1; a_diff = YYPI2 + a2 - a1; }
#else /*NOIPAPATCH*/
    /* ꥸʥΥ -> Ϥ */
    if (a1 < 0) a1 += YYPI2;
    if (a2 < 0) a2 += YYPI2;
    a1 = YYPI2 - a1; a2 = YYPI2 - a2;
    if (a1 < a2) { a0 = a1; a_diff = a2 - a1; }
    else	{ a0 = a2; a_diff = a1 - a2; }
#endif /*NOIPAPATCH*/
    change_gc(xp->xDisp, tx->txGC, pkt,
	      (YYGC_LINWIDTH|YYGC_OPERATION|YYGC_COLOR|YYGC_DASH),
	      (YYGC *)NULL, (YYGCONTEXT *)NULL);

    if (tr->teTRType != TR_SPLITE) {
	XDrawArc(xp->xDisp, tx->txPixmap, tx->txGC, x, y, r, r, a0, a_diff);
	if (IsVisibleTerritory(tr)) {
	    XDrawArc(xp->xDisp, tx->txWindow, tx->txGC, x, y, r, r, a0,a_diff);
	    ch->ccXNeedFlush = TRUE;
	}
    } else {
	make_splite_draw_arc(ch,tr,x,y,r,r,a0,a_diff,0);
	ch->ccXNeedFlush = TRUE;
    }
    DebugEndFunc("draw", "yycom_draw_arc");
    return (yy_packet *)NULL;
}


/*****************************
 *****                   *****
 *****   Fill Commands   *****
 *****                   *****
 *****************************/

/***************************************************************************
 ***** Command 27
 *****
 *****  Draw Filled Polygon
 *****
 ***************************************************************************/

yy_packet *yycom_fill_polygon(ch, pkt)
    yy_comm_channel *ch;
    yy_packet *pkt;
{
    x_private *xp = XPRIVATE(ch);
    TERRITORY *tr;
    TERRITORY_X_ENTRY *tx;
    yy_packet *err;
    XPoint *points, *p;
    int n, l;
    DebugSetFunc("fill", "yycom_fill_polygon");
    if ((tr = catch_territory(pkt, TR_DRAWABLE, &err)) == (TERRITORY *)NULL) {
	DebugEndFunc("fill", "yycom_fill_polygon");
	return err;
    }
    tx = GetTerritoryXEntry(tr);
    /* draw_lines(n, pointes, points, ..) */
    n = read_packet_entry_integer(pkt);
    points = (XPoint *)calloc(n+1, sizeof(XPoint));
    for (p = points, l = n; l > 0; p++, l--) {
	p->x = read_packet_entry_integer(pkt);
	p->y = read_packet_entry_integer(pkt);
    }
    p->x = points->x; p->y = points->y; n++;
    change_gc(xp->xDisp, tx->txGC, pkt,
	      (YYGC_OPERATION|YYGC_CONNECT|YYGC_COLOR|YYGC_FILL|YYGC_PATTERN),
	      (YYGC *)NULL, (YYGCONTEXT *)NULL);
#ifndef NOIPAPATH
    if(tr->teTRType != TR_SPLITE) {
	XFillPolygon(xp->xDisp, tx->txPixmap, tx->txGC, points, n,
		     Complex, CoordModeOrigin);
	if (IsVisibleTerritory(tr)) {
	    XFillPolygon(xp->xDisp, tx->txWindow, tx->txGC,
			 points, n, Complex, CoordModeOrigin);
	    ch->ccXNeedFlush = TRUE;
	}
    } else {
	make_splite_draw_polygon(ch,tr,n,points,1);
	ch->ccXNeedFlush = TRUE;
    }
#else /*NOIPAPATH*/
    /* ꥸʥΥ -> ʤ */
    XFillPolygon(xp->xDisp, tx->txPixmap, tx->txGC, points, n,
		 Convex, CoordModeOrigin);
    if (IsVisibleTerritory(tr)) {
	XFillPolygon(xp->xDisp, tx->txWindow, tx->txGC,
		     points, n, Convex, CoordModeOrigin);
	ch->ccXNeedFlush = TRUE;
    }
#endif /*NOIPAPATH*/

    DebugEndFunc("fill", "yycom_fill_polygon");
    return (yy_packet *)NULL;
}


/***************************************************************************
 ***** Command 28
 *****
 *****  Draw Filled Rectangle
 *****
 ***************************************************************************/

yy_packet *yycom_fill_rectangle(ch, pkt)
    yy_comm_channel *ch;
    yy_packet *pkt;
{
    x_private *xp = XPRIVATE(ch);
    TERRITORY *tr;
    TERRITORY_X_ENTRY *tx;
    yy_packet *err;
    int x, y; int w, h;
    YYGC yygc_val;
    DebugSetFunc("fill", "yycom_fill_rectangle");
    if ((tr = catch_territory(pkt, TR_DRAWABLE, &err)) == (TERRITORY *)NULL) {
	DebugEndFunc("fill", "yycom_fill_rectangle");
	return err;
    }
    tx = GetTerritoryXEntry(tr);
    /* fill_rectangle(x,y,w,h,ope,color) */
    x = read_packet_entry_integer(pkt);
    y = read_packet_entry_integer(pkt);
    w = read_packet_entry_integer(pkt);
    h = read_packet_entry_integer(pkt);
    change_gc(xp->xDisp, tx->txGC, pkt,
	      (YYGC_OPERATION|YYGC_COLOR|YYGC_PATTERN), &yygc_val,
	      (YYGCONTEXT *)NULL);
	
    if (tr->teTRType != TR_SPLITE) {
	XFillRectangle(xp->xDisp, tx->txPixmap, tx->txGC, x, y, w, h);
	if (IsVisibleTerritory(tr)) {
	    XFillRectangle(xp->xDisp, tx->txWindow, tx->txGC, x, y, w, h);
	    ch->ccXNeedFlush = TRUE;
	}
    } else {
	make_splite_draw_rectangle(ch,tr,x,y,w,h,1);
	ch->ccXNeedFlush = TRUE;
    }
    DebugEndFunc("fill", "yycom_fill_rectangle");
    return (yy_packet *)NULL;
}

/***************************************************************************
 ***** Command 29
 *****
 *****  Draw Filled Circle
 *****
 ***************************************************************************/

yy_packet *yycom_fill_circle(ch, pkt)
    yy_comm_channel *ch;
    yy_packet *pkt;
{
    x_private *xp = XPRIVATE(ch);
    TERRITORY *tr;
    TERRITORY_X_ENTRY *tx;
    yy_packet *err;
    int x, y, r;

    DebugSetFunc("fill", "yycom_fill_circle");
    if ((tr = catch_territory(pkt, TR_DRAWABLE, &err)) == (TERRITORY *)NULL) {
	DebugEndFunc("fill", "yycom_fill_circle");
	return err;
    }
    tx = GetTerritoryXEntry(tr);
    /* fill_circle(x,y,r,ope,color) */
    x = read_packet_entry_integer(pkt);
    y = read_packet_entry_integer(pkt);
    r = read_packet_entry_integer(pkt);
    x -= r; y -= r;
    r <<= 1;
    change_gc(xp->xDisp, tx->txGC, pkt,
	      (YYGC_OPERATION|YYGC_COLOR|YYGC_PATTERN), (YYGC *)NULL,
	      (YYGCONTEXT *)NULL);

    if (tr->teTRType != TR_SPLITE) {
	XFillArc(xp->xDisp, tx->txPixmap, tx->txGC, x, y, r, r, 0, YYPI2);
	if (IsVisibleTerritory(tr)) {
	    XFillArc(xp->xDisp, tx->txWindow, tx->txGC, x, y, r, r, 0, YYPI2);
	    ch->ccXNeedFlush = TRUE;
	}
    } else {
	make_splite_draw_arc(ch,tr,x, y, r, r, 0, YYPI2,1);
	ch->ccXNeedFlush = TRUE;
    }
    DebugEndFunc("fill", "yycom_fill_circle");
    return (yy_packet *)NULL;
}


/***************************************************************************
 ***** Command 30
 *****
 *****  Draw Filled Arc
 *****
 ***************************************************************************/

yy_packet *yycom_fill_arc(ch, pkt)
    yy_comm_channel *ch;
    yy_packet *pkt;
{
    x_private *xp = XPRIVATE(ch);
    TERRITORY *tr;
    TERRITORY_X_ENTRY *tx;
    yy_packet *err;
    int x, y, r; int a1, a2, a0, a_diff;
    DebugSetFunc("fill", "yycom_fill_arc");
    if ((tr = catch_territory(pkt, TR_DRAWABLE, &err)) == (TERRITORY *)NULL) {
	DebugEndFunc("fill", "yycom_fill_arc");
	return err;
    }
    tx = GetTerritoryXEntry(tr);
    /* draw_arc(tr,x,y,r,a1,a2,wid,ope,color,dash) */
    x = read_packet_entry_integer(pkt);
    y = read_packet_entry_integer(pkt);
    r = read_packet_entry_integer(pkt);
    x -= r; y -= r; r <<= 1;
    a1 = (read_packet_entry_integer(pkt) % YYPI2);
    a2 = (read_packet_entry_integer(pkt) % YYPI2);
#ifndef NOIPAPATCH
    /* źˤ뽤 1991.12.12 */
    if (a1 < a2) { a0 = a1; a_diff = a2 - a1; }
    else	 { a0 = a1; a_diff = YYPI2 + a2 - a1; }
#else /*NOIPAPATCH*/
    /* ꥸʥΥ -> ʤ */
    if (a1 < 0) a1 += YYPI2;
    if (a2 < 0) a2 += YYPI2;
    a1 = YYPI2 - a1; a2 = YYPI2 - a2;
    if (a1 < a2) { a0 = a1; a_diff = a2 - a1; }
    else	{ a0 = a2; a_diff = a1 - a2; }
#endif /*NOIPAPATCH*/
    change_gc(xp->xDisp, tx->txGC, pkt,
	      (YYGC_OPERATION|YYGC_COLOR|YYGC_PATTERN|YYGC_ARCMODE),
	      (YYGC *)NULL, (YYGCONTEXT *)NULL);

    if (tr->teTRType != TR_SPLITE) {
	XFillArc(xp->xDisp, tx->txPixmap, tx->txGC, x, y, r, r, a0, a_diff);
	if (IsVisibleTerritory(tr)) {
	    XFillArc(xp->xDisp, tx->txWindow,tx->txGC, x, y, r, r, a0, a_diff);
	    ch->ccXNeedFlush = TRUE;
	}
    } else {
	make_splite_draw_arc(ch,tr,x,y,r,r,a0,a_diff,1);
	ch->ccXNeedFlush = TRUE;
    }
    DebugEndFunc("fill", "yycom_fill_arc");
    return (yy_packet *)NULL;
}


/***************************************************************************
 ***** Command 41
 *****
 *****  Draw Oval
 *****
 ***************************************************************************/

yy_packet *yycom_draw_oval(ch, pkt)
    yy_comm_channel *ch;
    yy_packet *pkt;
{
    x_private *xp = XPRIVATE(ch);
    TERRITORY *tr;
    TERRITORY_X_ENTRY *tx;
    yy_packet *err;
    int x, y, w, h; int a1, a2, a0, a_diff;
    DebugSetFunc("draw", "yycom_draw_oval");
    if ((tr = catch_territory(pkt, TR_DRAWABLE, &err)) == (TERRITORY *)NULL) {
	DebugEndFunc("draw", "yycom_draw_oval");
	return err;
    }
    tx = GetTerritoryXEntry(tr);
    /* draw_arc(tr,x,y,r,a1,a2,wid,ope,color,dash) */
    x = read_packet_entry_integer(pkt);
    y = read_packet_entry_integer(pkt);
    w = read_packet_entry_integer(pkt);
    h = read_packet_entry_integer(pkt);
    x -= (w >> 1); y -= (h >> 1);
    a1 = (read_packet_entry_integer(pkt) % YYPI2);
    a2 = (read_packet_entry_integer(pkt) % YYPI2);
#ifndef NOIPAPATCH
    /* źˤ뽤 1991.12.12 */
    if (a1 < a2) { a0 = a1; a_diff = a2 - a1; }
    else	 { a0 = a1; a_diff = YYPI2 + a2 - a1; }
#else /*NOIPAPATCH*/
    /* ꥸʥΥ -> Ϥ */
    if (a1 < 0) a1 += YYPI2;
    if (a2 < 0) a2 += YYPI2;
    a1 = YYPI2 - a1; a2 = YYPI2 - a2;
    if (a1 < a2) { a0 = a1; a_diff = a2 - a1; }
    else	{ a0 = a2; a_diff = a1 - a2; }
#endif /*NOIPAPATCH*/
    change_gc(xp->xDisp, tx->txGC, pkt,
	      (YYGC_LINWIDTH|YYGC_OPERATION|YYGC_COLOR|YYGC_DASH),
	      (YYGC *)NULL, (YYGCONTEXT *)NULL);
    if (tr->teTRType != TR_SPLITE) {
	XDrawArc(xp->xDisp, tx->txPixmap, tx->txGC, x, y, w, h, a0, a_diff);
	if (IsVisibleTerritory(tr)) {
	    XDrawArc(xp->xDisp, tx->txWindow,tx->txGC, x, y, w, h, a0, a_diff);
	    
	    ch->ccXNeedFlush = TRUE;
	}
    } else {
	make_splite_draw_arc(ch,tr,x,y,w,h,a0, a_diff,0);
	ch->ccXNeedFlush = TRUE;
    }
    DebugEndFunc("draw", "yycom_draw_oval");
    return (yy_packet *)NULL;
}


/***************************************************************************
 ***** Command 42
 *****
 *****  Draw Filled Oval
 *****
 ***************************************************************************/

yy_packet *yycom_fill_oval(ch, pkt)
    yy_comm_channel *ch;
    yy_packet *pkt;
{
    x_private *xp = XPRIVATE(ch);
    TERRITORY *tr;
    TERRITORY_X_ENTRY *tx;
    yy_packet *err;
    int x, y, w, h; int a1, a2, a0, a_diff;
    DebugSetFunc("fill", "yycom_fill_oval");
    if ((tr = catch_territory(pkt, TR_DRAWABLE, &err)) == (TERRITORY *)NULL) {
	DebugEndFunc("fill", "yycom_fill_oval");
	return err;
    }
    tx = GetTerritoryXEntry(tr);
    x = read_packet_entry_integer(pkt);
    y = read_packet_entry_integer(pkt);
    w = read_packet_entry_integer(pkt);
    h = read_packet_entry_integer(pkt);
    x -= (w >> 1); y -= (h >> 1);
    a1 = (read_packet_entry_integer(pkt) % YYPI2);
    a2 = (read_packet_entry_integer(pkt) % YYPI2);
#ifndef NOIPAPATCH
    /* źˤ뽤 1991.12.12 */
    if (a1 < a2) { a0 = a1; a_diff = a2 - a1; }
    else	 { a0 = a1; a_diff = YYPI2 + a2 - a1; }
#else /*NOIPAPATCH*/
    /* ꥸʥΥ -> Ϥ */
    if (a1 < 0) a1 += YYPI2;
    if (a2 < 0) a2 += YYPI2;
    a1 = YYPI2 - a1; a2 = YYPI2 - a2;
    if (a1 < a2) { a0 = a1; a_diff = a2 - a1; }
    else	{ a0 = a2; a_diff = a1 - a2; }
#endif /*NOIPAPATCH*/
    change_gc(xp->xDisp, tx->txGC, pkt,
	      (YYGC_OPERATION|YYGC_COLOR|YYGC_PATTERN|YYGC_ARCMODE),
	      (YYGC *)NULL, (YYGCONTEXT *)NULL);
    if (tr->teTRType != TR_SPLITE) {
	XFillArc(xp->xDisp, tx->txPixmap, tx->txGC, x, y, w, h, a0, a_diff);
	if (IsVisibleTerritory(tr)) {
	    XFillArc(xp->xDisp, tx->txWindow, tx->txGC, x, y, w, h, a0,a_diff);
	    ch->ccXNeedFlush = TRUE;
	}
    } else {
	make_splite_draw_arc(ch,tr,x,y,w,h,a0,a_diff,1);
	ch->ccXNeedFlush = TRUE;
    }
		
    DebugEndFunc("fill", "yycom_fill_oval");
    return (yy_packet *)NULL;
}

/***************************************************************************
 ***** Command XX
 *****
 *****  Draw Filled Inner Polygon
 *****
 ***************************************************************************/

yy_packet *yycom_fill_inner_polygon(ch, pkt)
    yy_comm_channel *ch;
    yy_packet *pkt;
{
    x_private *xp = XPRIVATE(ch);
    TERRITORY *tr;
    TERRITORY_X_ENTRY *tx;
    yy_packet *err;
    XPoint *points, *p;
    int n, l;
    YYGCONTEXT yygcon;

    DebugSetFunc("fill", "yycom_fill_inner_polygon");
    if ((tr = catch_territory(pkt, TR_DRAWABLE, &err)) == (TERRITORY *)NULL) {
	DebugEndFunc("fill", "yycom_fill_inner_polygon");
	return err;
    }
    tx = GetTerritoryXEntry(tr);
    /* draw_lines(n, pointes, points, ..) */
    n = read_packet_entry_integer(pkt);
    points = (XPoint *)calloc(n+1, sizeof(XPoint));
    for (p = points, l = n; l > 0; p++, l--) {
	p->x = read_packet_entry_integer(pkt);
	p->y = read_packet_entry_integer(pkt);
    }
    p->x = points->x; p->y = points->y; n++;
    change_gc(xp->xDisp, tx->txGC, pkt,
	      (YYGC_LINWIDTH|YYGC_OPERATION|YYGC_CONNECT|YYGC_COLOR
	       |YYGC_FILL|YYGC_PATTERN),
	      (YYGC *)NULL, (YYGCONTEXT *)&yygcon);
    if(tr->teTRType != TR_SPLITE) {
	Pixmap wkpix;
	GC wkgc;
	XGCValues gcv;

	/* ޥѥ wkpix ˤȤꡢ뤿
	 *  GC  wlgc Ȥ
	 */
	wkpix = XCreatePixmap(xp->xDisp, tx->txPixmap,
			      tr->teWidth, tr->teHeight, 1);
	wkgc = XCreateGC(xp->xDisp, wkpix, 0, 0);
	XSetForeground(xp->xDisp, wkgc, 0);
	XFillRectangle(xp->xDisp, wkpix, wkgc,
		       0, 0, tr->teWidth, tr->teHeight);
	/* 1  FILL, 0 ǳ褹 */
	gcv.function = GXcopy;
	gcv.line_style = LineSolid;
	gcv.line_width = 0;
	gcv.fill_style = FillSolid;
	gcv.foreground = 1;
	gcv.background = 0;
	XChangeGC(xp->xDisp, wkgc,
		  (GCFunction|GCLineStyle|GCLineWidth|GCFillStyle|
		   GCForeground|GCBackground), &gcv);
	/*XCopyGC(xp->xDisp, tx->txGC, GCJoinStyle, wkgc);*/
	XFillPolygon(xp->xDisp, wkpix, wkgc, points, n,
		     Complex, CoordModeOrigin);
	gcv.line_width = yygcon.ygLineWidth;
	gcv.foreground = 0;
	XChangeGC(xp->xDisp, wkgc, (GCLineWidth|GCForeground), &gcv);
	XDrawLines(xp->xDisp, wkpix, wkgc, points, n, CoordModeOrigin);
	/*
	 * wkpix ˥ޥѥƤ
	 * ޥȤ FillPolygon Ԥʤ
	 */
	XSetClipMask(xp->xDisp, tx->txGC, wkpix);
	XSetClipOrigin(xp->xDisp, tx->txGC, 0, 0);
	XFillPolygon(xp->xDisp, tx->txPixmap, tx->txGC, points, n,
		     Complex, CoordModeOrigin);
	if (IsVisibleTerritory(tr)) {
	    XFillPolygon(xp->xDisp, tx->txWindow, tx->txGC,
			 points, n, Complex, CoordModeOrigin);
	    ch->ccXNeedFlush = TRUE;
	}
	XSetClipMask(xp->xDisp, tx->txGC, None);
	XFreePixmap(xp->xDisp, wkpix);
	XFreeGC(xp->xDisp, wkgc);
    } else {
	make_splite_draw_polygon(ch,tr,n,points,2,&yygcon);
	ch->ccXNeedFlush = TRUE;
    }

    DebugEndFunc("fill", "yycom_fill_inner_polygon");
    return (yy_packet *)NULL;
}


/***
 * Bitmap Operation
 */

yy_packet *yycom_create_bitmap(ch, pkt)
    yy_comm_channel *ch;
    yy_packet *pkt;
{
    x_private *xp = XPRIVATE(ch);
    TERRITORY *tr;
    TERRITORY_X_ENTRY *tx;
    yy_packet *err;
    yy_packet *repl;
    DebugSetFunc("bitmap", "yycom_create_bitmap");
    DebugEndFunc("bitmap", "yycom_create_bitmap");
    return (yy_packet *)NULL;
}


yy_packet *yycom_operate_bitblt(ch, pkt)
    yy_comm_channel *ch;
    yy_packet *pkt;
{
    x_private *xp = XPRIVATE(ch);
    TERRITORY *tr;
    TERRITORY_X_ENTRY *tx;
    yy_packet *err;
    yy_packet *repl;
    DebugSetFunc("bitmap", "yycom_operate_bitblt");
    DebugEndFunc("bitmap", "yycom_operate_bitblt");
    return (yy_packet *)NULL;
}


yy_packet *yycom_save_picture(ch, pkt)
    yy_comm_channel *ch;
    yy_packet *pkt;
{
    x_private *xp = XPRIVATE(ch);
    TERRITORY *tr;
    TERRITORY_X_ENTRY *tx;
    yy_packet *err;
    yy_packet *repl;
    DebugSetFunc("bitmap", "yycom_save_picture");
    DebugEndFunc("bitmap", "yycom_save_picture");
    return (yy_packet *)NULL;
}


yy_packet *yycom_load_picture(ch, pkt)
    yy_comm_channel *ch;
    yy_packet *pkt;
{
    x_private *xp = XPRIVATE(ch);
    TERRITORY *tr;
    TERRITORY_X_ENTRY *tx;
    yy_packet *err;
    yy_packet *repl;
    DebugSetFunc("bitmap", "yycom_load_picture");
    DebugEndFunc("bitmap", "yycom_load_picture");
    return (yy_packet *)NULL;
}


yy_packet *yycom_translate_picture(ch, pkt)
    yy_comm_channel *ch;
    yy_packet *pkt;
{
    x_private *xp = XPRIVATE(ch);
    TERRITORY *tr;
    TERRITORY_X_ENTRY *tx;
    yy_packet *err;
    yy_packet *repl;
    DebugSetFunc("bitmap", "yycom_translate_picture");
    DebugEndFunc("bitmap", "yycom_translate_picture");
    return (yy_packet *)NULL;
}


yy_packet *yycom_rotate_picture(ch, pkt)
    yy_comm_channel *ch;
    yy_packet *pkt;
{
    x_private *xp = XPRIVATE(ch);
    TERRITORY *tr;
    TERRITORY_X_ENTRY *tx;
    yy_packet *err;
    yy_packet *repl;
    DebugSetFunc("bitmap", "yycom_rotate_picture");
    DebugEndFunc("bitmap", "yycom_rotate_picture");
    return (yy_packet *)NULL;
}


yy_packet *yycom_get_image(ch, pkt)
    yy_comm_channel *ch;
    yy_packet *pkt;
{
    x_private *xp = XPRIVATE(ch);
    TERRITORY *tr;
    TERRITORY_X_ENTRY *tx;
    yy_packet *err;
    yy_packet *repl;
    int x, y, w, h;
    int lt_x, lt_y, rb_x, rb_y;
    int format;
    XImage *im;
    DebugSetFunc("image", "yycom_get_image");

    if ((tr = catch_territory(pkt, TR_DRAWABLE, &err)) == (TERRITORY *)NULL) {
	DebugEndFunc("image", "yycom_get_image");
	return err;
    }
    tx = GetTerritoryXEntry(tr);
    /* x, y, w, h */
    x = read_packet_entry_integer(pkt);
    y = read_packet_entry_integer(pkt);
    w = read_packet_entry_integer(pkt);
    h = read_packet_entry_integer(pkt);
    format = read_packet_entry_integer(pkt);
    if (format != YYIMAGEFORM_YY) {
	err = ALLOC_ERRPACKET(pkt);
	SETYYERRORCODE(err, 0);
	SETYYERRORCODE(err, YYERROR_TYPEMISMATCH);
	DebugEndFunc("image", "yycom_get_image");
	return err;
    }
    lt_x = MAX(x, 0); lt_y = MAX(y, 0);
    rb_x = MIN((x+w),tr->teWidth); rb_y = MIN((y+h),tr->teHeight);
    /* Get Image */
    DebugPrint9(5, "GetImage on TR#%d (%d,%d)[%d,%d] -> (%d,%d)[%d,%d]\n",
		tr->teID, x, y, w, h, lt_x, lt_y, (rb_x-lt_x), (rb_y-lt_y));
    im = XGetImage(xp->xDisp, tx->txPixmap,
		   lt_x, lt_y, (rb_x-lt_x), (rb_y-lt_y), AllPlanes, ZPixmap);
    repl = ALLOC_ACKPACKET(pkt);
    append_packet_entry_integer(repl, tr->teID);
    append_packet_entry_integer(repl, w);
    append_packet_entry_integer(repl, h);
    if (DefaultDepth(xp->xDisp, xp->xScreen) > 1) {
		/* Color */
		int wx, wy, lx, ly;
		append_packet_entry_integer(repl, (YYIMAGEFORM_COLOR|YYIMAGEFORM_YY));
		append_packet_entry_integer(repl, w*h*4);
		for (wy = y, ly = h; ly > 0 ; wy++, ly--) {
			if (wy >= lt_y && wy < rb_y) {
				for (wx = x, lx = w; lx > 0 ; wx++, lx--) {
					if (wx >= lt_x && wx < rb_x) {
						u_long pixel = XGetPixel(im, (wx-lt_x), (wy-lt_y));
						append_packet_entry_integer(repl, pixel);
					} else
						append_packet_entry_integer(repl, 0);
				}
			} else {
				for (lx = w; lx > 0 ; lx--)
					append_packet_entry_integer(repl, 0);
			}
		}
    } else { /* B&W */
		int wx, wy, lx, ly, ll;
		u_long cc;
		append_packet_entry_integer(repl, (YYIMAGEFORM_BW|YYIMAGEFORM_YY));
		append_packet_entry_integer(repl, (w*h+3)>>2);
		ll = 16; cc = 0;
		for (wy = y, ly = h; ly > 0 ; wy++, ly--) {
			for (wx = x, lx = w; lx > 0 ; wx++, lx--) {
				cc <<= 2;
				if (wy >= lt_y && wy < rb_y && wx >= lt_x && wx < rb_x) {
					u_long pixel = XGetPixel(im, (wx-lt_x), (wy-lt_y));
					cc |= (pixel & 1);
				}
				ll--;
				if (ll <= 0) {
					append_packet_entry_integer(repl, cc);
					ll = 16; cc = 0;
				}
			}
		}
		if (ll < 16) {
			cc <<= (ll>>1);
			append_packet_entry_integer(repl, cc);
		}
    }
    XDestroyImage(im);
    DebugEndFunc("image", "yycom_get_image");
    return (yy_packet *)repl;
}

yy_packet *yycom_put_image(ch, pkt)
    yy_comm_channel *ch;
    yy_packet *pkt;
{
    x_private *xp = XPRIVATE(ch);
    TERRITORY *tr;
    TERRITORY_X_ENTRY *tx;
    yy_packet *err;
    yy_packet *repl;
    int x, y, w, h;
    int lt_x, lt_y, rb_x, rb_y;
    int format, bytes;
    XImage *im;
    XImage *mask_im;  /* Kosaka Add */
    GC   temp_gc;
    Pixmap temp_P;

    DebugSetFunc("image", "yycom_put_image");

    if ((tr = catch_territory(pkt, TR_DRAWABLE, &err)) == (TERRITORY *)NULL) {
	DebugEndFunc("image", "yycom_put_image");
	return err;
    }
    tx = GetTerritoryXEntry(tr);
    /* x, y, w, h */
    x = read_packet_entry_integer(pkt);
    y = read_packet_entry_integer(pkt);
    w = read_packet_entry_integer(pkt);
    h = read_packet_entry_integer(pkt);
    format = read_packet_entry_integer(pkt);
    bytes = read_packet_entry_integer(pkt);
    if ((format & 0377) != YYIMAGEFORM_YY) {
	err = ALLOC_ERRPACKET(pkt);
	SETYYERRORCODE(err, 0);
	SETYYERRORCODE(err, YYERROR_TYPEMISMATCH);
	DebugEndFunc("image", "yycom_put_image");
	return err;
    }
    if (x >= tr->teWidth || y >= tr->teHeight || (x+w) < 0 || (y+h) < 0)
		goto send_reply;
    lt_x = MAX(x, 0); lt_y = MAX(y, 0);
    rb_x = MIN((x+w),tr->teWidth); rb_y = MIN((y+h),tr->teHeight);

    im = XGetImage(xp->xDisp, tx->txPixmap,
		   lt_x, lt_y, (rb_x-lt_x), (rb_y-lt_y), AllPlanes, ZPixmap);

    temp_P =  XCreatePixmap(xp->xDisp,tx->txWindow,
			    (rb_x-lt_x), (rb_y-lt_y),1);
    mask_im = XGetImage(xp->xDisp, temp_P,
			0, 0, (rb_x-lt_x), (rb_y-lt_y), 1, XYPixmap);
    temp_gc = XCreateGC(xp->xDisp,temp_P, 0, 0);

    DebugPrint8(5, "PutImage on (%d,%d)[%d,%d] from (%d,%d)[%d,%d]\n",
		x, y, w, h, lt_x, lt_y, (rb_x-lt_x), (rb_y-lt_y));
    if (format & YYIMAGEFORM_COLOR) {
	/* color */
	int wx, wy, lx, ly;
	DebugPrint0(7, "Color Image\n");
	for (wy = y, ly = h; ly > 0 ; wy++, ly--) {
	    for (wx = x, lx = w; lx > 0 ; wx++, lx--) {
		u_long pixel = read_packet_entry_integer(pkt);
		/* Add Kosaka */
		if(pixel != (u_long) -1) {
		    /* End Add */
		    XPutPixel(im, (wx-lt_x), (wy-lt_y),
			      (wy >= lt_y && wy < rb_y && wx >= lt_x && 
			       wx < rb_x?
			   pixel: BlackPixel(xp->xDisp, xp->xScreen)));
		    XPutPixel(mask_im, (wx-lt_x), (wy-lt_y),1);
		}
		else {
		    XPutPixel(mask_im, (wx-lt_x), (wy-lt_y),0);
		}
	    }
	}
    } else if (format & YYIMAGEFORM_GRAY) {
	/* Gray */ 
	DebugPrint0(7, "Gray Image\n");
    } else {
	/* B&W */
	int wx, wy, lx, ly, ll;
	u_long cc;
	DebugPrint0(7, "B&W Image\n");
	cc = read_packet_entry_integer(pkt); ll = 16;
	for (wy = y, ly = h; ly > 0 ; wy++, ly--) {
	    for (wx = x, lx = w; lx > 0 ; wx++, lx--) {
		if (wy >= lt_y && wy < rb_y && wx >= lt_x && wx < rb_x) {
		    u_long pixel;
		    pixel = ((cc >> 30) & 3);
		    XPutPixel(im, (wx-lt_x), (wy-lt_y), pixel);
		    XPutPixel(mask_im, (wx-lt_x), (wy-lt_y), pixel);
		}
		ll--;
		if (ll > 0) {
		    cc <<= 2;
		} else {
		    cc = read_packet_entry_integer(pkt); ll = 16;
		}
	    }
	}
    }
    XSetFunction(xp->xDisp, tx->txGC, GXcopy);
    XSetFunction(xp->xDisp, temp_gc, GXcopy);

    XPutImage(xp->xDisp,temp_P,temp_gc,mask_im, 0, 0,
	      0, 0, (rb_x-lt_x), (rb_y-lt_y));
    XSetClipMask(xp->xDisp, tx->txGC,temp_P);
    if (tr->teTRType != TR_SPLITE) {
	XPutImage(xp->xDisp, tx->txPixmap, tx->txGC, im, 0, 0,
		  lt_x, lt_y, (rb_x-lt_x), (rb_y-lt_y));
	
	if (IsVisibleTerritory(tr)) {
	    XPutImage(xp->xDisp, tx->txWindow, tx->txGC, im, 0, 0,
		      lt_x, lt_y, (rb_x-lt_x), (rb_y-lt_y));
	    ch->ccXNeedFlush = TRUE;
	}
    }
#ifdef SPLITEBUGBUG
    else {
	make_splite_draw_image(ch,tr,lt_x,lt_y,
			       rb_x-lt_x,rb_y-lt_y,im,temp_P);
	ch->ccXNeedFlush = TRUE;
    }
#endif /*SPLITEBUGBUG*/
    XSetClipMask(xp->xDisp, tx->txGC, None);
    XDestroyImage(im);
    XDestroyImage(mask_im);
    XFreeGC(xp->xDisp,temp_gc);
    XFreePixmap(xp->xDisp,temp_P);
 send_reply:
    DebugEndFunc("image", "yycom_put_image");
    return (yy_packet *)NULL;
}

/*
 * Local variables:
 * eval: (set-kanji-fileio-code 'EUC)
 * end:
 */
