;;;-*-Mode: LISP; Package: yy-defsystem; Base:10; Syntax:Common-lisp; -*-

(in-package :yy-defsystem)

;(export '(defsystem operate-on-system))

;;;
;;; Various hacks to get people's *features* into better shape.
;;; 
(eval-when (compile load eval)

  #+(and Symbolics Lispm)
  (multiple-value-bind 
    (major minor) 
      (sct:get-release-version)
    (pushnew :genera *features*)
    (ecase major
      ((6)
       (pushnew :genera-release-6 *features*))
      ((7)
       (pushnew :genera-release-7 *features*)
       (ecase (etypecase minor
		(integer minor)
		(string (digit-char-p (char minor 0))))
	 ((0 1) (pushnew :genera-release-7-1 *features*))
	 ((2)   (pushnew :genera-release-7-2  *features*))
	 ((3)   (pushnew :genera-release-7-3  *features*))
	 ((4)   (pushnew :genera-release-7-4  *features*))
	 ((5)   (pushnew :genera-release-7-5  *features*))))
      ((8)
       (pushnew :genera-release-8 *features*)
       (ecase (etypecase minor
		(integer minor)
		(string (digit-char-p (char minor 0))))
	 ((0) (pushnew :genera-release-8-0 *features*))
	 ((1) (pushnew :genera-release-8-1 *features*))))
      ))

  (dolist (feature *features*)
    (when (and (symbolp feature)                ;3600!!
               (equal (symbol-name feature) "CMU"))
      (pushnew :CMU *features*)))
  
  #+ExCL
  (cond ((search "sun4" (lisp-implementation-version))
	 (push :sun4 *features*)))

;;;
;;; For KCL and IBCL, push the symbol :turbo-closure on the list *features*
;;; if you have installed turbo-closure patch.  See the file kcl-mods.text
;;; for details.
;;;
;;; The xkcl version of KCL has this fixed already.
;;; 

  #+xkcl(pushnew :turbo-closure *features*)

  )



;;; Yet Another Sort Of General System Facility and friends.
;;;
;;; The entry points are defsystem and operate-on-system.  defsystem is used
;;; to define a new system and the files with their load/compile constraints.
;;; Operate-on-system is used to operate on a system defined that has been
;;; defined by defsystem.  For example:
#||

(defsystem my-very-own-system
	   "/usr/myname/lisp/"
  ((classes   (precom)           ()                ())
   (methods   (precom classes)   (classes)         ())
   (precom    ()                 (classes methods) (classes methods))))

This defsystem should be read as follows:

* Define a system named MY-VERY-OWN-SYSTEM, the sources and binaries
  should be in the directory "/usr/me/lisp/".  There are three files
  in the system, there are named classes, methods and precom.  (The
  extension the filenames have depends on the lisp you are running in.)
  
* For the first file, classes, the (precom) in the line means that
  the file precom should be loaded before this file is loaded.  The
  first () means that no other files need to be loaded before this
  file is compiled.  The second () means that changes in other files
  don't force this file to be recompiled.

* For the second file, methods, the (precom classes) means that both
  of the files precom and classes must be loaded before this file
  can be loaded.  The (classes) means that the file classes must be
  loaded before this file can be compiled.  The () means that changes
  in other files don't force this file to be recompiled.

* For the third file, precom, the first () means that no other files
  need to be loaded before this file is loaded.  The first use of
  (classes methods)  means that both classes and methods must be
  loaded before this file can be compiled.  The second use of (classes
  methods) mean that whenever either classes or methods changes precom
  must be recompiled.

Then you can compile your system with:

 (operate-on-system 'my-very-own-system :compile)

and load your system with:

 (operate-on-system 'my-very-own-system :load)

||#

;;; 
(defvar *system-directory*)

;;;
;;; *port* is a list of symbols (in the DEFSYSTEM package) which represent the
;;; Common Lisp in which we are now running.  Many of the facilities in
;;; defsys use the value of *port* rather than #+ and #- to conditionalize
;;; the way they work.
;;; 
(defvar *port*
        '(#+Genera               :Genera
          #+Genera-Release-7-2   :Rel-7
	  #+Genera-Release-7-3   :Rel-7
          #+Genera-Release-7-1   :Rel-7-1
          #+Genera-Release-7-2   :Rel-7-2
	  #+Genera-Release-7-3   :Rel-7-2	;OK for now
	  #+Genera-Release-7-4   :Rel-7-2	;OK for now
	  #+imach                :Ivory
          #+Lucid                :Lucid
          #+KCL                  :KCL
          #+excl                 :excl
          #+:CMU                 :CMU
	  ))

;;;
;;; When you get a copy of YYonX (by tape or by FTP), the sources files will
;;; have extensions of ".lisp" in particular, this file will be
;;; yy-system-definition.lisp.
;;; The preferred way to install YYonX is to rename these files to have the
;;; extension which your lisp likes to use for its files.  Alternately, it
;;; is possible not to rename the files.  If the files are not renamed to
;;; the proper convention, the second line of the following defvar should
;;; be changed to:
;;;     (let ((files-renamed-p nil)
;;;
;;; Note: Something people installing YYonX on a machine running Unix
;;;       might find useful.  If you want to change the extensions
;;;       of the source files from ".lisp" to ".lsp", *all* you have
;;;       to do is the following:
;;;
;;;       % foreach i (*.lisp)
;;;       ? mv $i $i:r.lsp
;;;       ? end
;;;       %
;;;
;;;       I am sure that a lot of people already know that, and some
;;;       Unix hackers may say, "jeez who doesn't know that".  Those
;;;       same Unix hackers are invited to fix mv so that I can type
;;;       "mv *.lisp *.lsp".
;;;
(defvar *pathname-extensions*
  (let ((files-renamed-p nil)
        (proper-extensions
          (car
           '(#+(and Genera (not imach))          ("lisp"  . "bin")
	     #+(and Genera imach)                ("lisp"  . "ibin")
             #+KCL                               ("lsp"   . "o")
             #+(and Lucid MC68000)               ("lisp"  . "lbin")
             #+(and Lucid VAX)                   ("lisp"  . "vbin")
             #+(and Lucid Prime)                 ("lisp"  . "pbin")
	     #+(and Lucid SUNRise)               ("lisp"  . "sbin")
	     #+(and Lucid SPARC)                 ("lisp"  . "sbin")
             #+(and Lucid MIPS)                  ("lisp"  . "mbin")
             #+(and Lucid PRISM)                 ("lisp"  . "abin")
	     #+excl                              ("cl"    . "fasl")
		 #+CMU                              ("lisp" . "sparcf")
             ))))
    (cond ((null proper-extensions) '("l" . "lbin"))
          ((null files-renamed-p) (cons "lisp" (cdr proper-extensions)))
          (t proper-extensions))))

;;;
;;; Foreign Function Modules' Pathname-type
;;;
(defvar *foreign-pathname-type* "o")

;(eval-when (compile load eval)

(defun get-system (name)
  (get name 'system-definition))

(defun set-system (name new-value)
  (setf (get name 'system-definition) new-value))

(defmacro defsystem (name directory files &optional aliens)
  `(set-system ',name (list #'(lambda () ,directory)
			    (make-modules ',files ',aliens)
			    ',(mapcar #'car files)
			    (make-aliens ',aliens))))

;)


;;;
;;; The internal datastructure used when operating on a system.
;;; 
(defstruct (module (:constructor make-module (name))
                   (:print-function
                     (lambda (m s d)
                       (declare (ignore d))
                       (format s "#<Module ~A>" (module-name m)))))
  name
  load-env
  comp-env
  recomp-reasons
  alien-p					;foreign language module-p.
  loaded-p)					;if t, the newer module is loaded.

(defstruct (alien (:print-function
		    (lambda (m s d)
		      (declare (ignore d))
		      (format s "#<Alien ~a>" (alien-name m)))))
  name
  files
  libraries
  invaded-p)

(defun make-modules (system-description &optional aliens)
  (let ((modules ()))
    (labels ((get-module (name)
               (or (find name modules :key #'module-name)
                   (progn (setq modules (cons (make-module name) modules))
                          (car modules))))
             (parse-spec (spec)
               (if (eq spec 't)
                   (reverse (cdr modules))
		   (case (car spec)
		     (+ (append (reverse (cdr modules)) (mapcar #'get-module (cdr spec))))
		     (- (let ((rem (mapcar #'get-module (cdr spec))))
			  (remove-if #'(lambda (m) (member m rem)) (reverse (cdr modules)))))
		     (otherwise (mapcar #'get-module spec))))))
      (dolist (file system-description)
        (let* ((name (car file))
               (port (car (cddddr file)))
               (module nil)
	       (type nil))
          (when (or (null port)
		    (and (symbolp port)
			 (member port *port*))
		    (and (consp port)
			 (intersection port *port*)))
            (setq module (get-module name))
            (setf (module-load-env module) (parse-spec (cadr file))
                  (module-comp-env module) (parse-spec (caddr file))
                  (module-recomp-reasons module) (parse-spec
                                                   (cadddr file))
		  (module-alien-p module) (dolist (alien aliens)
					    (if (eql (car alien) name)
						(return t)))))))
      (let ((filenames (mapcar #'car system-description)))
	(sort modules #'(lambda (name1 name2)
			  (member name2 (member name1 filenames)))
	      :key #'module-name)))))

(defun make-aliens (fleet)
  (mapcar 
   #'(lambda (ship)
	   (let (
			 #-CMU
			 (files (getf (cdr ship) :files))
			 #+CMU
			 (files (cdr (member :files (cdr ship))))
			 #-CMU
			 (libs (getf (cdr ship) :libraries))
			 #+CMU
			 (libs (cdr (member :libraries (cdr ship))))
			 )
		 (make-alien :name (first ship)
							:files (if (listp files) files (list files))
							:libraries (if (listp libs) libs (list libs)))))
		  fleet))

(defun make-transformations (modules filter make-transform)
  (let ((transforms (list nil)))
    (dolist (m modules)
      (when (funcall filter m transforms) (funcall make-transform m transforms)))
    (reverse (cdr transforms))))

(defun make-compile-transformation (module transforms)
  (unless (dolist (trans transforms)
	    (and (eq (car trans) ':compile)
		 (eq (cadr trans) module)
		 (return t)))
    (dolist (c (module-comp-env module)) (make-load-transformation c transforms))
    (setf (cdr transforms)
	  (remove-if #'(lambda (trans) (and (eq (car trans) :load) (eq (cadr trans) module)))
		     (cdr transforms)))
    (push `(:compile ,module) (cdr transforms))))

(defvar *being-loaded* ())

(defun make-load-transformation (module transforms)
  (if (assoc module *being-loaded*)
      (throw module (setf (cdr transforms) (cdr (assoc module *being-loaded*))))
      (let ((*being-loaded* (cons (cons module (cdr transforms)) *being-loaded*)))
	(catch module
	  (unless (module-loaded-p module)
	    (unless (dolist (trans transforms)
		      (when (and (eq (car trans) ':load)
				 (eq (cadr trans) module))
			(return t)))
	      (dolist (l (module-load-env module)) (make-load-transformation l transforms))
	      (push `(:load ,module) (cdr transforms))))))))

(defun make-load-without-dependencies-transformation (module transforms)
  (unless (dolist (trans transforms)
            (and (eq (car trans) ':load)
                 (eq (cadr trans) module)
                 (return trans)))
    (push `(:load ,module) (cdr transforms))))

(defun compile-filter (module transforms)
  ;;Never compile external language source file.
  (unless (module-alien-p module)
    ;;
    (and
     (or (dolist (r (module-recomp-reasons module))
	   (when (dolist (transform transforms)
		   (when (and (eq (car transform) ':compile)
			      (eq (cadr transform) r))
		     (return t)))
	     (return t)))
	 (null (probe-file (make-binary-pathname (module-name module))))
	 (> (file-write-date (make-source-pathname (module-name module)))
	    (file-write-date (make-binary-pathname (module-name module)))))
     ;;to be reloadable file after compilation.
     (not (setf (module-loaded-p module) nil)))))

(defun load-filter (module transforms)
  (or (dolist (trans transforms)
	(when (and (eq (car trans) ':compile)
		   (eq (cadr trans) module))
	  (return 't)))
      (not (module-loaded-p module))))

(defun operate-on-system (name mode &optional arg print-only)
  (let ((system (get-system name)))
    (unless system (error "Can't find system with name ~S." name))
    (let ((*system-directory* (funcall (car system)))
	  (modules (cadr system))
	  (aliens (cadddr system))
	  (transformations ()))
      (labels ((load-source (name pathname)
		 (format t "~&Loading source of ~A..." name)
		 (or print-only (load pathname))
		 (format t "...done!"))
	       (load-binary (name pathname)
		 (format t "~&Loading binary of ~A..." name)
		 (or print-only (load pathname))
		 (format t "...done!"))
	       (load-alien (name)
		 (let ((alien (dolist (a aliens)
				 (if (eql (alien-name a) name)
				     (return a)))))
		   (format t "~&Loading foreign of ~A..." name)
		   (if alien
		     (or print-only
			 (when (alien-invaded-p alien)
			   (format t "...Oops! it's loaded.")
			   t)
			 (progn
			 #+Lucid
			 (lucid::load-foreign-files
			  (mapcar #'make-alien-pathname (alien-files alien))
			  (alien-libraries alien))
			 #+ExCL
			 (if (alien-libraries alien)
			     (load "" :foreign-files
				   (mapcar #'make-alien-pathname (alien-files alien)))
			   (load "" :foreign-files
				 (mapcar #'make-alien-pathname (alien-files alien))
				 :system-libraries (alien-libraries alien)))
			 #+CMU
			 (extensions:load-foreign
			  (namestring
			   (car (mapcar #'make-alien-pathname (alien-files alien)))))
			 (format t "...done!")
			 (setf (alien-invaded-p alien) t)))
		     (format t "...Can't find file."))))
		     
	       (load-module (m)
		 (let* ((name (module-name m))
			(*load-verbose* nil))
		   (if (module-alien-p m)
		       (load-alien name)
		     (load-binary name (make-binary-pathname name)))
		   (or print-only (setf (module-loaded-p m) t))))
	       (compile-module (m)
		 (format t "~&Compiling ~A..." (module-name m))
		 (unless print-only
		   (let  ((name (module-name m)))
		     (compile-file (make-source-pathname name)
				   :output-file
				   (make-pathname :defaults
						  (make-binary-pathname name)
						  :version :newest))
		     (setf (module-loaded-p m) nil))))
;	       (true (&rest ignore) (declare (ignore ignore)) 't)
	       (true (module transforms) (declare (ignore transforms))
		 (setf (module-loaded-p module) nil)
		 t)
	       )
	
	(setq transformations
	      (ecase mode
		(:compile
		  ;; Compile any files that have changed and any other files
		  ;; that require recompilation when another file has been
		  ;; recompiled.
		  (make-transformations
		    modules
		    #'compile-filter
		    #'make-compile-transformation))
		(:recompile
		  ;; Force recompilation of all files.
		  (make-transformations
		    modules
		    #'true
		    #'make-compile-transformation))
		(:recompile-some
		  ;; Force recompilation of some files.  Also compile the
		  ;; files that require recompilation when another file has
		  ;; been recompiled.
		  (make-transformations
		    modules
		    #'(lambda (m transforms)
			(or (member (module-name m) arg)
			    (compile-filter m transforms)))
		    #'make-compile-transformation))
		(:query-compile
		  ;; Ask the user which files to compile.  Compile those
		  ;; and any other files which must be recompiled when
		  ;; another file has been recompiled.
		  (make-transformations
		    modules
		    #'(lambda (m transforms)
			(or (compile-filter m transforms)
			    (y-or-n-p "Compile ~A?"
				      (module-name m))))
		    #'make-compile-transformation))
		(:confirm-compile
		  ;; Offer the user a chance to prevent a file from being
		  ;; recompiled.
		  (make-transformations
		    modules
		    #'(lambda (m transforms)
			(and (compile-filter m transforms)
			     (y-or-n-p "Go ahead and compile ~A?"
				       (module-name m))))
		    #'make-compile-transformation))
		(:load
		  ;; load any files that have changed
		  (make-transformations
		    modules
		    #'load-filter
		    #'make-load-transformation))
		(:reload
		  ;; Load the whole system.
		  (make-transformations
		    modules
		    #'true
		    #'make-load-transformation))
		(:query-load
		  ;; Load only those files the user says to load.
		  (make-transformations
		    modules
		    #'(lambda (m transforms)
			(declare (ignore transforms))
			(y-or-n-p "Load ~A?" (module-name m)))
		    #'make-load-without-dependencies-transformation))))
	
	(#+Genera
	 compiler:compiler-warnings-context-bind
	 #+:LCL3.0
	 lucid-common-lisp:with-deferred-warnings
	 #-(or Genera TI :LCL3.0)
	 progn
	 (loop (when (null transformations) (return t))
	       (let ((transform (pop transformations)))
		 (ecase (car transform)
		   (:compile (compile-module (cadr transform)))
		   (:load (load-module (cadr transform)))))))))))


(defun make-source-pathname (name) (make-pathname-internal name :source))
(defun make-binary-pathname (name) (make-pathname-internal name :binary))
(defun make-alien-pathname  (name) (make-pathname-internal name :alien))

(defun make-pathname-internal (name type)
  (let* ((extension (ecase type
                      (:source (car *pathname-extensions*))
                      (:binary (cdr *pathname-extensions*))
					  (:alien ;*foreign-pathname-type*
					   nil)))
         (directory 
		  (pathname
		   (etypecase *system-directory*
					  (string *system-directory*)
					  (pathname *system-directory*)
					  (cons (ecase type
								   (:source (car *system-directory*))
								   (:binary (cdr *system-directory*))
								   (:alien (cdr *system-directory*)))))))
         (pathname
		  (make-pathname
		   :name (string-downcase (string name))
		   :type extension
		   :defaults directory)))

    #+Genera
    (setq pathname (zl:send pathname :new-raw-name (pathname-name pathname))
          pathname (zl:send pathname :new-raw-type (pathname-type pathname)))
	pathname
    ))
