;;; -*- Mode: LISP; Syntax: Common-lisp; Package: USER; Base: 10 -*-

(in-package :user)

(yy-defsystem:defsystem YY
			*yy-directory*
  ;;
  ;; file         load           compile      files which       port
  ;;              environment    environment  force the of
  ;;                                          recompilation
  ;;                                          of this file
  ;;                                          
  (
;;   (defpackage		t		t	())
   (version		t		t	())
   (global-variables	t		t	())
   (macro-func	t		t	())
   (macros		t		t	())
   #-CMU
   (yyprotocol	()		()	()		(:Lucid :ExCL))
   (lisp-depend 	t		t	(macros))
;   #+CMU
 ;  (define-foreign  nil     t)
   (primitive-class	t		t 	())
   (primitive		t		t	(macros primitive-class))
   #+(OR Lucid EXCL SYMBOLICS)
   (prtclif-ohta	t		t	(lisp-depend macros))
   #+CMU
   (prtclif-ohta	t		t	(macros))
   ;; Foreign function module.
   (yy-protocol    	t		t	(macros))
   (territory		t	 	t	(macros))
   (yy-color-class	t		t	(macros))
   (yy-color		t		t	(macros yy-color-class))
   (graphic-primitive-class	t	t	(macros))
   (graphic-primitive	t		t 	(macros graphic-primitive-class))
   (text-font-class	t 		t	(macros))
   (text-font		t		t	(macros text-font-class))
   (yy-image-class	t		t	(macros))
   (yy-image		t	 	t	(macros yy-image-class))
   (bitmap-class	t 		t	(macros))
   (bitmap	 	t		t	(macros bitmap-class))
   (yy-input-stream-class	t	t	(macros))
   (yy-input-stream	t		t	(macros yy-input-stream-class))
   (parts-primitive-class	t	t	(macros))
   (parts-primitive	t		t	(macros parts-primitive-class))
   (window-parts-class	t		t	(macros))
   (window-parts	t		t	(macros window-parts-class 
							parts-primitive))
   (bitmap-stream-class	t		t	(macros))
   (bitmap-stream	t		t	(macros bitmap-stream-class))
   (mouse-cursor-class	t		t	(macros))
   (mouse-cursor	t		t	(macros mouse-cursor-class))
   (yy-stream-class	t		t	(macros))
   (yy-stream		t		t	(macros parts-primitive yy-stream-class))
   (window-parts-method t	 	t	(macros)) 
   (window-method	t		t	(macros parts-primitive))
   (text-output		t		t	(macros))
   (graphic-method	t		t	(macros))
   (x3j13-streams-class	t		t	(macros))
   (x3j13-streams	t		t	(macros x3j13-streams-class))
   (edit-text-macro	t		t	(macros))
   (edit-text 		t		t	(macros edit-text-macro))
   (graphic-image	t		t	(macros))
   (active-region-class t		t	(macros))
   (active-region	t		t	(macros active-region-class))
   (accessry	 	t		t	(macros))
   (popup-menu	 	t		t	(macros))
   (default-pop-up-menu-euc	t	t	(macros))
   (extended-graphics-class 	t	t	(macros))
   (extended-graphics	t		t	(macros extended-graphics-class))
   (server-dependent-class	t	t	(macros))
   (server-dependent	t		t	(macros server-dependent-class))
   (sample-window-class t		t	(macros))
   (sample-window 	t		t	(macros parts-primitive 
							sample-window-class))
   (presentation-macro	t		t	(macros))
   (presentation-class	t		t	(macros presentation-macro))
   (present-mark        t       t   (macros))
   (presentation	t		t	(macros presentation-macro))
   (presentation-method	t		t	(macros presentation-macro))
   (graphic-test-class	t		t	(macros))
; (graphic-test-exec	t		t	(macros graphic-test-class))
   (graphic-test	t		t	(macros graphic-test-class))
   (sample-animation-class	t		t (macros))
   (sample-animation	t	t	(macros sample-animation-class))
   (vtr-class	        t	t	(macros))
   (vtr-window	        t	t	(macros))
   (vtr-control	        t	t	(macros))
   )
  ;; Foreign Modules
  #+ (OR :LUCID EXCL CMU)
  (
   (yyprotocol :files "prtclif.o"
			   :libraries  #+Lucid "-lc"
			   #+ExCL "c")
   )
  )


(defun compile-yy (&optional m)
  (let (#+Lucid (lcl:*redefinition-action* nil)
	#+excl  (excl::*redefinition-warnings* nil)
	)
    (cond ((null m)        (yy-defsystem:operate-on-system 'yy :compile))
	  ((eq m :print)   (yy-defsystem:operate-on-system 'yy :compile () t))
	  ((eq m :query)   (yy-defsystem:operate-on-system 'yy :query-compile))
	  ((eq m :confirm) (yy-defsystem:operate-on-system 'yy :confirm-compile))
	  ((eq m 't)       (yy-defsystem:operate-on-system 'yy :recompile)) 
	  ((listp m)       (yy-defsystem:operate-on-system 'yy :compile-from m))
	  ((symbolp m)     (yy-defsystem:operate-on-system 'yy :recompile-some 
							   `(,m))))))

(defun load-yy (&optional m)
  (let (#+Lucid (lcl:*redefinition-action* nil)
	#+excl  (excl::*redefinition-warnings* nil)
	)
    (cond ((null m)      (yy-defsystem:operate-on-system 'yy :load))
	  ((eq m :query) (yy-defsystem:operate-on-system 'yy :query-load)))
    (pushnew :YY *features*)))





