;;; -*- Mode: LISP; Syntax: Common-lisp; Package: YY; Base: 10 -*-
;;;
;;;  Copyright (C) 1989,1990,1991 Aoyama Gakuin University
;;;
;;;		All Rights Reserved
;;;
;;; This software is developed for the YY project of Aoyama Gakuin University.
;;; Permission to use, copy, modify, and distribute this software
;;; and its documentation for any purpose and without fee is hereby granted,
;;; provided that the above copyright notices appear in all copies and that
;;; both that copyright notice and this permission notice appear in 
;;; supporting documentation, and that the name of Aoyama Gakuin
;;; not be used in advertising or publicity pertaining to distribution of
;;; the software without specific, written prior permission.
;;;
;;; This software is made available AS IS, and Aoyama Gakuin makes no
;;; warranty about the software, its performance or its conformity to
;;; any specification. 
;;;
;;; To make a contact: Send E-mail to ida@csrl.aoyama.ac.jp for overall
;;; issues. To ask specific questions, send to the individual authors at
;;; csrl.aoyama.ac.jp. To request a mailing list, send E-mail to 
;;; yyonx-request@csrl.aoyama.ac.jp.
;;;
;;; Authors:
;;;   version 1.0 90/03/05 by Masayuki Ida  (ida@csrl.aoyama.ac.jp)
;;;   update      90/03/23 by Takashi Kosaka (kosaka@csrl.aoyama.ac.jp)
;;;   version 1.1 90/07/31 by t.kosaka
;;;   update 1.11 90/09/14 by t.kosaka
;;;   version 1.2 90/11/05 by t.kosaka

;;;  Version 1.0 Written by Masayuki Ida  90-03-05
;;; ----------------------------------------------------------
;;; This file is completely brought from the David Gray's 
;;; Proposal to X3J13.
;;; ----------------------------------------------------------
;;; Version 1.0   Updated by t.kosaka 1990-3-23
;;; update	  report-eof is added symbolics code
;;;		  clear-input is added symbolics code
;;;		  read-char-no-hang added symbolics code
;;;		  finish-output,clear-output,stream-read-char,yy-edit-read

(in-package :yy)

;;; Input method

#| Not use YY
  (defmethod STREAM-PEEK-CHAR ((stream fundamental-character-input-stream))
    (let ((character (stream-read-char stream)))
      (unless (eq character :eof)
	(stream-unread-char stream character))
      character))
|#
  ;;; YY STREAM-PEEK-CHAR  By T.kosaka
  (defmethod STREAM-PEEK-CHAR ((stream fundamental-character-input-stream))
  (declare (optimize (compilation-speed 0) (speed 3) (safety 0)))
    (let ((ret nil))
      (loop 
       (wait-process 'STREAM-LISTEN stream)
       (with-slots (input-string ) stream
			 (setf ret (elt input-string 0))
			 
			 (if (null (assoc (char-code ret) (input-mask-table stream)))
			     (return ret))))))
    

   ;;; LISP PEEK$@!<(JCHAR   T.kosaka
   (defmethod STREAM-PEEK-CHAR (stream)
     (lisp::peek-char stream))

#| Not use YY
  (defmethod STREAM-LISTEN ((stream fundamental-character-input-stream))
    (let ((char (stream-read-char-no-hang stream)))
      (and (not (null char))
	   (not (eq char :eof))
	   (progn (stream-unread-char stream char) t))))
|#

   ;;; YY STREAM-LISTEN T.kosaka
(defmethod STREAM-LISTEN ((stream fundamental-character-input-stream))
  (declare (optimize (compilation-speed 0) (speed 3) (safety 0)))
     (loop 
       (with-slots (input-string ) stream
			 (if (zerop (length input-string))
			     (return nil)
			 (if (null (assoc (char-code (elt input-string 0)) 
					  (input-mask-table stream)))
			     (return T)
			   (return nil))))))

   ;;;; LISP LISTEN T.kosaka
 (defmethod STREAM-LISTEN (stream)
     (lisp::listen stream))

   ;;; YY Window edit listen
(defun STREAM-EDIT-LIsten (stream)
     (let ((string (stream-input-string-internal (first stream))))
      (if (zerop (length string))
	       nil
	     T)))
     

#| Not use YY
  (defmethod STREAM-READ-LINE ((stream fundamental-character-input-stream))
    (let ((line (make-array 64 :element-type 'string-char 
			    :fill-ponter 0 :adjustable t)))
      (loop (let ((character (stream-read-char stream)))
	      (if (eq character :eof)
		  (return (values line t))
		(if (eql character #\newline)
		    (return (values line nil))
		  (vector-push-extend character line)))))))
|#
  ;;; YY stream STREAM-READ-LINE
  (defmethod STREAM-READ-LINE ((stream fundamental-character-input-stream))
    (yy-edit-read-line stream))
    

   ;;;; LISP READ-LINE      T.kosaka
   (defmethod STREAM-READ-LINE (stream)
     (lisp::READ-LINE stream))

  ;;; YY stream READ T.kosaka
(defmethod STREAM-READ ((stream fundamental-character-input-stream))
  (yy-edit-read stream))

  ;;; LISP READ T.kosaka
(defmethod STREAM-READ (stream)
  (lisp::read stream))

;;;; OUTPUT Method
(defmethod STREAM-START-LINE-P ((stream fundamental-character-output-stream))
  (equal (stream-line-column stream) 0))

(defmethod STREAM-WRITE-STRING ((stream fundamental-character-output-stream)
				string &optional (start 0) end)
  (if (null end)
      (setf end (length string)))
  
  (do ((i start (1+ i)))
      ((>= i end) string)
      (stream-write-char stream (char string i))))

   ;;;; LISP WRITE-STRING T.kosaka
(defmethod STREAM-WRITE-STRING (stream string &optional (start 0) end)
  (lisp::WRITE-STRING string stream :start start :end end))


;;; YY  Drawing text to graphic stream T.kosaka
(defmethod STREAM-FORCE-OUTPUT ((stream fundamental-character-output-stream))
  (declare (optimize (compilation-speed 0) (speed 3) (safety 0)))
  (with-slots (string ) stream
	  ;;; YY Graphic stream
	      (if (graphic-stream-p stream)
		  (drawing-text stream (if (null string)
					   ""
					 (coerce (prog1 string (setq string nil)) 'simple-string))))
	      nil))

;;; LISP force output T.kosaka
(defmethod STREAM-FORCE-OUTPUT (stream)
  (lisp::FORCE-OUTPUT stream))


(defmethod STREAM-TERPRI ((stream fundamental-character-output-stream))
  (declare (optimize (compilation-speed 0) (speed 3) (safety 0)))
  (stream-write-char stream #\Newline)
  (with-slots (endp) stream
	      (setf endp 0))
  nil)

  ;;;; LISP TERPRI  T.kosaka
(defmethod STREAM-TERPRI (stream)
  (lisp::TERPRI stream))

(defmethod STREAM-FRESH-LINE ((stream fundamental-character-output-stream))
  (declare (optimize (compilation-speed 0) (speed 3) (safety 0)))
  (if (stream-start-line-p stream)
      nil
    (progn (stream-terpri stream) t)))

   ;;; LISP FRESH-LINE T.kosaka
(defmethod STREAM-FRESH-LINE (stream)
  (lisp::FRESH-LINE stream))


#|    Now Not Use !!!! T.kosaka
  (defmethod STREAM-ADVANCE-TO-COLUMN ((stream fundamental-character-output-stream) 
				       column)

(declare (optimize (compilation-speed 0) (speed 3) (safety 0)))
    (let ((current (stream-line-column stream)))
      (unless (null current)
	(dotimes (i (- current column) t)
	  (stream-write-char stream #\space)))))


  (defmethod INPUT-STREAM-P ((stream fundamental-input-stream)) t)
  (defmethod INPUT-STREAM-P ((stream fundamental-output-stream))
    ;; allow the two classes to be mixed in either order
    (typep stream 'fundamental-input-stream
     (drawing-text stream (if string
			      string
			    "")))
))
|#

(defmethod OUTPUT-STREAM-P ((stream fundamental-character-output-stream)) t)

  ;;; Lisp OUTPUT-STREAM-P
(defmethod OUTPUT-STREAM-P (stream)
  (lisp::OUTPUT-STREAM-P stream))

  ;;; Add T.kosaka 
(defmethod STREAMP ((stream fundamental-character-output-stream)) t)

(defmethod STREAMP (stream)
  (lisp::streamp stream))



#|
  (defmethod OUTPUT-STREAM-P ((stream fundamental-input-stream))
    (typep stream 'fundamental-output-stream))
|#

  ;;;; Following is an example of how the existing I/O Methods could
  ;;;; be implemented using standard Common Lisp and the generic
  ;;;; Methods specified above.  The standard Methods being defined
  ;;;; are in upper case.

;;  Internal helper Methods

;(proclaim '(inline decode-read-arg decode-print-arg check-for-eof))

(defun decode-read-arg (arg)
  (cond ((null arg) *standard-input*)
	((eq arg t) *terminal-io*)
	(t arg)))

(defun decode-print-arg (arg)
  (cond ((null arg) *standard-output*)
	((eq arg t) *terminal-io*)
	(t arg)))

(defun check-for-eof (value stream eof-errorp eof-value)
  (if (eq value :eof)
      (report-eof stream eof-errorp eof-value)
    value))

;;; added symbolics code 31.Oct.90
(defun report-eof (stream eof-errorp eof-value)
  (if eof-errorp
      #-symbolics
      (error 'end-of-file :stream stream)
      #+symbolics
      (error "~% End of File :stream ~a" stream)
    eof-value))

  ;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
  ;;;  Common Lisp input Methods ;;;
  ;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
(defun READ-CHAR (&optional input-stream (eof-errorp t) eof-value recursive-p)
  (declare (ignore recursive-p)) ; a mistake in CLtL?
  (let ((stream (decode-read-arg input-stream)))
    (check-for-eof (stream-read-char stream) stream eof-errorp eof-value)))

(defun PEEK-CHAR (&optional peek-type input-stream (eof-errorp t) 
			    eof-value recursive-p)
  (declare (ignore recursive-p)
	   (optimize (compilation-speed 0) (speed 3) (safety 0)))
  (let ((stream (decode-read-arg input-stream)))
    (if (null peek-type)
	(check-for-eof (stream-peek-char stream) stream eof-errorp eof-value)
      (loop
       (let ((value (stream-peek-char stream)))
	 (if (eq value :eof)
	     (return (report-eof stream eof-errorp eof-value))
	   (if (if (eq peek-type t)
		   (not (member value '(#\space #\tab #\newline
					#\page #\return #\linefeed)))
		 (char= peek-type value))
	       (return value)
	     (stream-read-char stream))))))))

(defun UNREAD-CHAR (character &optional input-stream)
  (stream-unread-char (decode-read-arg input-stream) character))

(defun LISTEN (&optional input-stream)
  (stream-listen (decode-read-arg input-stream)))

(defun READ-LINE (&optional input-stream (eof-error-p t) 
			    eof-value recursive-p)
  (declare (ignore recursive-p))
  (let ((stream (decode-read-arg input-stream)))
    (multiple-value-bind (string eofp)
			 (stream-read-line stream)
			 (if eofp
			     (if (= (length string) 0)
				 (report-eof stream eof-error-p eof-value)
			       (values string t))
			   (values string nil)))))

(defun READ (&optional input-stream (eof-error-p t) 
		       eof-value recursive-p)
  (declare (ignore recursive-p))
  (let ((stream (decode-read-arg input-stream)))
    (multiple-value-bind (val eofp)
			 (stream-read stream)
			 (if eofp
			     (if (= (length (format nil "~a" val)) 0)
					 (report-eof stream eof-error-p eof-value)
			       (values val t))
			   (values val nil)))))

;;; added symbolics code 31.Oct.90
(defun CLEAR-INPUT (&optional input-stream)
;  #-symbolics
  (stream-clear-input (decode-read-arg input-stream))
;  #+symbolics
;  (cl:CLEAR-INPUT (decode-read-arg input-stream))
  )

;;; added symbolics code 31.Oct.90
(defun READ-CHAR-NO-HANG (&optional input-stream (eof-errorp t) 
				    eof-value recursive-p)
  (declare (ignore recursive-p))
  (let ((stream (decode-read-arg input-stream)))
    (check-for-eof
;     #-symbolics
     (stream-read-char-no-hang stream)
;     #+symbolics
;     (cl:read-char-no-hang stream)
      stream eof-errorp eof-value)))

  ;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
  ;;;  Common Lisp output Methods  ;;;
  ;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
(defun WRITE-CHAR (character &optional output-stream)
  (stream-write-char (decode-print-arg output-stream) character))

(defun FRESH-LINE (&optional output-stream)
  (stream-fresh-line (decode-print-arg output-stream)))

(defun TERPRI (&optional output-stream)
  (stream-terpri (decode-print-arg output-stream)))

(defun yy::WRITE-STRING (string &optional output-stream &key (start 0) end)
  (stream-write-string (decode-print-arg output-stream) string start end))

(defun WRITE-LINE (string &optional output-stream &key (start 0) end)
  (let ((stream (decode-print-arg output-stream)))
    (stream-write-string stream string start end)
    (stream-terpri stream)
    string))

(defun FORCE-OUTPUT (&optional stream)
  (stream-force-output (decode-print-arg stream)))

;;; added Symbolics code 31.Oct.90
(defun FINISH-OUTPUT (&optional stream)
;  #-symbolics
  (stream-finish-output (decode-print-arg stream))
;  #+symbolics
;  (cl:finish-output (decode-print-arg stream))
  )

;;; added Symbolics code 31.Oct.90
(defun yy::CLEAR-OUTPUT (&optional stream)
;  #-symbolics
  (stream-clear-output (decode-print-arg stream))
;  #+symbolics
;  (cl:clear-output (decode-print-arg stream))
  )


  ;;;  Binary streams
#|
  (defun READ-BYTE (binary-input-stream &optional (eof-errorp t) eof-value)
    (check-for-eof (stream-read-byte binary-input-stream) 
		   binary-input-stream eof-errorp eof-value))
  
  (defun WRITE-BYTE (integer binary-output-stream)
    (stream-write-byte binary-output-stream integer))
|#
  ;;;  String streams



(defun MAKE-STRING-INPUT-STREAM (string &optional (start 0) end)
  (make-instance 'string-input-stream :string string 
		 :start start :end (or end (length string))))

(defmethod stream-read-char ((stream yy-string-input-stream))
  (with-slots (index end string) stream
	      (if (>= index end)
		  :eof
		(prog1 (char string index)
		  (incf index)))
	      ))

;;;Window stream stream-read-char T.kosaka  
;;; added Symbolics code 31.Oct.90
(defmethod stream-read-char ((stream fundamental-character-input-stream))
  (let ((ret nil))
    (loop 
    (wait-process 'stream-listen stream)
     (if (setf ret
	      (stream-read-char-no-hang stream)
	 )
	 (return ret)))
    (setf (for-unread-char stream) ret)))

;;; 2.Nov.90 Yohta
;(defmethod stream-read-char (stream)
;  (lisp:read-char stream)
;  )


(defmethod STREAM-READ-CHAR-NO-HANG ((stream yy-string-input-stream))
  (with-slots (index end string) stream
       (if (>= index end)
	   nil
	 (prog1 (char string index)
                  (incf index)))
       ))

;;;Window stream stream-read-char-no-hang T.kosaka  
(defmethod stream-read-char-no-hang ((stream fundamental-character-input-stream))
 ;;; 1$@J8;z<h$j=P$9(J
  (let ((code nil))
    (with-slots (input-string) stream
     (if (null input-string)
	 nil
       (progn 
	 (setf code (elt input-string 0)
	       input-string (cdr input-string))
	 ;; 2.Nov.90 Yohta
#+:Symbolics
         (setf code (case (char-code code)
			((10 13)
			 #\Newline)
			(t
			 code)))

	 (setf (for-unread-char stream)
;	    (code-char code)
	   code)
	 )))))

(defmethod STREAM-CLEAR-INPUT ((stream yy-string-input-stream))
  (with-slots (index end string) stream
     (setf  string nil
	   index 0
	   end 0)))

(defmethod STREAM-CLEAR-INPUT ((stream fundamental-character-input-stream))
  (with-slots (input-string edit-string index) stream
      (setf input-string nil
	    edit-string nil
	    index 0))
  )

(defmethod stream-unread-char ((stream yy-string-input-stream) character)
  (with-slots (index  string) stream
	      (decf index)
	      (assert (eql (char string index) character))
	      nil))

;;; Window stream stream-unread-char T.kosaka
(defmethod stream-unread-char ((stream fundamental-character-input-stream) character)
  (with-slots (for-unread-char) stream
	      (assert (eql for-unread-char character))
	      nil))


(defmethod stream-read-line ((stream yy-string-input-stream))
  (with-slots (index end string) stream
	      (let* ((endline (position #\newline string :start index :end end))
		     (line (subseq string index endline)))
		(if endline
		    (progn (setq index (1+ endline))
			   (values line nil))
		  (progn (setq index end)
			 (values line t))))))

;;; string-output-stream CLASS 

(defmethod stream-write-char ((stream fundamental-character-output-stream) character)
  (with-slots (string endp) stream
	      (when (null string)
		    (setq string (make-array 64. 
				:element-type
#-:EXCL
                      'string-char 
#+:EXCL
                      'character

					     :fill-pointer 0 :adjustable t)))
	      (vector-push-extend character string)
	      (incf endp)
	      character))

  ;;; Lisp write-char
(defmethod stream-write-char (stream character)
  (lisp::write-char character stream))

(defmethod STREAM-FINISH-OUTPUT ((stream fundamental-character-output-stream))
  (stream-force-output stream)
  )

(defmethod STREAM-FINISH-OUTPUT (stream)
  (lisp::FINISH-OUTPUT stream))

(defmethod STREAM-CLEAR-OUTPUT ((stream fundamental-character-output-stream))
  (with-slots (string endp) stream
      (setf (fill-pointer string) 0
	    endp 0)))

(defmethod STREAM-CLEAR-OUTPUT (stream)
  (lisp::CLEAR-OUTPUT stream))



#|
  (defmethod stream-line-column ((stream yy-string-output-stream))
    (with-slots (string) stream
      (if (null string)
	  0
	(let ((nx (position #\newline string :from-end t)))
	  (if (null nx)
	      (length string)
	    (- (length string) nx 1))
	  ))))
|#

;;; YY Stream   graphic stream  or string stream T.kosaka
(defmethod stream-line-column ((stream fundamental-character-output-stream))
  (with-slots (string endp ) stream
	      (if (zerop endp)
		  (if string
		      (length string)
		    0)
		endp)))

;;; End of file

  



