;;; -*- Mode: LISP; Syntax: Common-lisp; Package: YY; Base: 10 -*-
;;;
;;;  Copyright (C) 1989,1990,1991 Aoyama Gakuin University
;;;
;;;		All Rights Reserved
;;;
;;; This software is developed for the YY project of Aoyama Gakuin University.
;;; Permission to use, copy, modify, and distribute this software
;;; and its documentation for any purpose and without fee is hereby granted,
;;; provided that the above copyright notices appear in all copies and that
;;; both that copyright notice and this permission notice appear in 
;;; supporting documentation, and that the name of Aoyama Gakuin
;;; not be used in advertising or publicity pertaining to distribution of
;;; the software without specific, written prior permission.
;;;
;;; This software is made available AS IS, and Aoyama Gakuin makes no
;;; warranty about the software, its performance or its conformity to
;;; any specification. 
;;;
;;; To make a contact: Send E-mail to ida@csrl.aoyama.ac.jp for overall
;;; issues. To ask specific questions, send to the individual authors at
;;; csrl.aoyama.ac.jp. To request a mailing list, send E-mail to 
;;; yyonx-request@csrl.aoyama.ac.jp.
;;;
;;; Authors:
;;;   version 1.0 90/03/05 by Masayuki Ida  (ida@csrl.aoyama.ac.jp)
;;;   update      90/03/23 by Takashi Kosaka (kosaka@csrl.aoyama.ac.jp)
;;;   version 1.1 90/07/31 by t.kosaka
;;;   update 1.11 90/09/14 by t.kosaka
;;;   version 1.2 90/11/05 by t.kosaka

;;;  Version 1.0 Written by Masayuki Ida  90-03-05
;;; ----------------------------------------------------------
;;; This file is completely brought from the David Gray's 
;;; Proposal to X3J13.
;;; ----------------------------------------------------------
;;; Version 1.0   Updated by t.kosaka 1990-3-23
;;; Version 1.3.1   Updated by t.kosaka 1991-11-28

(in-package :yy)


;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;; This is for string stream  ;;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
(defclass yy-string-input-stream ()
  ((string :initarg :string :type string)
     (index :initarg :start :type fixnum)
     (end :initarg :end :type fixnum)
     ))
;;; For YY string-stream-output-stream
(defclass yy-string-output-stream (fundamental-character-output-stream) ())
;;;    ((string :initform nil :initarg :string)
;;;     (endp    :initform 0 :initarg :endp)))


#| NOT use in YY
  (defclass string-input-stream (fundamental-character-input-stream)
    ((string :initarg :string :type string)
     (index :initarg :start :type fixnum)
     (end :initarg :end :type fixnum)
     ))

  (defclass string-output-stream (fundamental-character-output-stream)
    ((string :initform nil :initarg :string)))

  (defun MAKE-STRING-OUTPUT-STREAM ()
    (make-instance 'string-output-stream))

  (defun GET-OUTPUT-STREAM-STRING (stream)
    (with-slots (string) stream
      (if (null string)
	  ""
	(prog1 string (setq string nil)))))
|#
