;;; -*- Mode: LISP; Syntax: Common-lisp; Package: YY; Base: 10 -*-
;;; $@%&%#%s%I%&%9%H%j!<%`$NItIJ4XO"(J
;;; window-parts.lisp
;;;
;;;  Copyright (C) 1989,1990,1991 Aoyama Gakuin University
;;;
;;;		All Rights Reserved
;;;
;;; This software is developed for the YY project of Aoyama Gakuin University.
;;; Permission to use, copy, modify, and distribute this software
;;; and its documentation for any purpose and without fee is hereby granted,
;;; provided that the above copyright notices appear in all copies and that
;;; both that copyright notice and this permission notice appear in 
;;; supporting documentation, and that the name of Aoyama Gakuin
;;; not be used in advertising or publicity pertaining to distribution of
;;; the software without specific, written prior permission.
;;;
;;; This software is made available AS IS, and Aoyama Gakuin makes no
;;; warranty about the software, its performance or its conformity to
;;; any specification. 
;;;
;;; To make a contact: Send E-mail to ida@csrl.aoyama.ac.jp for overall
;;; issues. To ask specific questions, send to the individual authors at
;;; csrl.aoyama.ac.jp. To request a mailing list, send E-mail to 
;;; yyonx-request@csrl.aoyama.ac.jp.
;;;
;;; Authors:
;;;   version 1.0 90/06/01 by t.kosaka (kosaka@csrl.aoyama.ac.jp)
;;;   version 1.1 90/07/31 by t.kosaka
;;;   update 1.11 90/09/14 by t.kosaka
;;;   version 1.2 90/11/05 by t.kosaka

;;; 7/27 1990 $@8E:d(J
;;; Version 1.0   Coded by t.kosaka 1990-7-27
;;; Change Log    Add page-mode class viewport-mode class  1990-8-29
;;;               Update world-region method               1990-8-29

(in-package :yy)


;;; window-parts $@$N(J $@=i4|2=$N%a%=%C%I(J :after
;;; $@%&%#%s%I%&%Q!<%D$r:n$kEY$K%j%9%H$KEPO?(J
(defmethod initialize-instance :after ((parts window-parts)
									   &rest args &key &allow-other-keys)
  #-:PCL
  (declare (ignore args))
  (let ((parent (parent-window parts)))
	(push parts (window-parts-list parent))))

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;; $@MxMQ<T$,Dj5A$7$?%&%#%s%I%&%Q!<%D$N7W;;%a%=%C%I(J;;;
;;; $@%+%9%?%^%$%:$9$k;~MxMQ<T$,%a%=%C%I$r=q$/(J      ;;;
;;; ARGS.                                         ;;;
;;;     parts  ->  $@%&%#%s%I%&%Q!<%D$N%$%s%9%?%s%9(J ;;;
;;;     region ->  $@%&%#%s%I%&$N%j!<%8%g%s(J         ;;;
;;;     other-regions -> $@;H$o$?%j!<%8%g%s$N%j%9%H(J ;;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
(defgeneric compute-window-parts (parts region other-regions)
  (:method ((parts window-border) region other-regions)
		   #-:PCL
		   (declare (ignore  region other-regions))
		   nil)
  (:method (parts region other-regions)
		   #-:PCL
		   (declare (ignore parts region other-regions))
		   nil)
  )

;;; $@%&%#%s%I%&%Q!<%D$NBg$-$5JQ99$NAm>N4X?t(J
;;; $@MxMQ<T$O!"$3$NAm>N4X?t$K%a%=%C%I$r5-=R$9$k$3$H$G(J
;;; $@<+J,$N:n$C$?%&%#%s%I%&%Q!<%D$NBg$-$5!?0LCV$N@_Dj$,2DG=(J
;;; $@$3$NAm>N4X?t$KDI2C$9$k%a%=%C%I$NLa$jCM$O!"(J
;;; $@<+J,$NBg$-$5$rI=$9%j!<%8%g%s$G$J$1$l$P$J$i$J$$(J
(defgeneric set-window-parts-region (parts region)
  (:method ((parts window-border) region)
		   #-:PCL
		   (declare (ignore region))
		   (values))
  (:method (parts region)
		   #-:PCL
		   (declare (ignore parts region))
		   (values))
  )


;;; $@%9%/%m!<%k%P!<BS$NI}(J
(defparameter *SCROLL-BAR-BELT* 12)

;;; $@I=<(%a%=%C%I(J
(defmethod print-object ((ob title-bar) stream)
  (with-region-slots 
   (left bottom width height) ob
   (format stream "\#<Title Bar left:~a bottom:~a width: ~a height:~a>"
		   left bottom width height)))

;;; $@%?%$%H%k%P!<(Jredisplay$@%a%=%C%I(J
(defgeneric redisplay-title-bar (title)
  (:method ((title title-bar))
		   (default-redisplay-title-bar title))
  (:method (title)
#-:PCL
	   (declare (ignore title))
	   nil))

;;; $@%G%U%)%k%H$N%?%$%H%k%P!<I=<(4X?t(J
(defun default-redisplay-title-bar (title)
  (declare (special *BLACK-COLOR* *WHITE-COLOR*))
  (with-slots (title-font title-bar-string title-bar-color) title
			  ;; Territory back ground clear --> to default color
			  (draw-piece-color title title-bar-color)

			  ;; Draw string 
			  (draw-piece-string title 1 (font-kanji-base-line title-font)
								 title-bar-string
								 :color *WHITE-COLOR*
								 :font title-font))
  )


;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;; $@%?%$%H%k%P!<$N7W;;%a%=%C%I(J                    ;;;
;;; $@%+%9%?%^%$%:$9$k;~MxMQ<T$,%a%=%C%I$r=q$/(J      ;;;
;;; ARGS.                                         ;;;
;;;     titel  ->  $@%?%$%H%k%P!<%$%s%9%?%s%9(J       ;;;
;;;     region ->  $@%&%#%s%I%&$N%j!<%8%g%s(J         ;;;
;;;     other-regions -> $@;H$o$?%j!<%8%g%s$N%j%9%H(J ;;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
(defmethod compute-window-parts ((title title-bar) region other-regions)
  (declare (optimize (compilation-speed 0) (speed 3) (safety 0)))
  (default-compute-title title region other-regions))

;;; $@%G%U%)%k%H$N%?%$%H%k%P!<$NNN0h7W;;(J
(defun default-compute-title (title region other-regions)
  (declare (ignore other-regions)
		   (optimize (compilation-speed 0) (speed 3) (safety 0)))
  (let ((height (font-kanji-height (slot-value title 'title-font)))
		(width (region-width region)))
	(with-region-slots
	 (left bottom right top) title
	 (setf left 0 bottom 0
		   top  height right width))
	title))
   
;;; $@%?%$%H%k%P!<%j!<%8%g%sJQ994X?t2?$b$7$J$$(J
(defgeneric set-title-bar-region (title region)
  (:method ((title title-bar) region)
	   (if (eq title region)
	       (with-real-object (title) (+ 1 1))
	     (with-real-object  (title)
				(set-region title region)))
	   title)
  (:method (title region)
#-:PCL
	   (declare (ignore title region))
	   nil))



;;; X $@%*%U%;%C%HJQ99(J $@@dBPJQ99(J
(defun set-world-x-offset (new-value world)
  (declare (optimize (compilation-speed 0) (speed 3) (safety 0)))
  (with-region-slots 
   (width left bottom) world
   (let* ((ww width)
	  (x (- new-value (world-x-start world))))

      (setf left x
	    width ww
	    (slot-value world 'world-x-offset) new-value)
   
    ;;; $@%F%j%H%j!<$N0\F0(J
    (yy-protocol-3 (world-territory-no world) 
		   left bottom)
    new-value)))


;;; X $@%*%U%;%C%HJQ99(J $@AjBPJQ99(J
(defun add-x-offset-world (world value)
  (declare (optimize (compilation-speed 0) (speed 3) (safety 0)))
  (let ((x (- (+ (slot-value world 'world-x-offset) value) 
	      (world-x-start world))))
    (setf (slot-value world 'world-x-offset) x)
    x))

;;; Y$@%*%U%;%C%H$NJQ99(J $@@dBPJQ99(J
(defun set-world-y-offset (new-value world)
  (declare (optimize (compilation-speed 0) (speed 3) (safety 0)))
  (with-region-slots 
   (height bottom left) world
   (let ((hh height))
     
     (setf bottom (- new-value (world-y-start world))
	   height hh
	  (slot-value world 'world-y-offset) new-value)
   
    ;;; $@%F%j%H%j!<$N0\F0(J
    (yy-protocol-3 (world-territory-no world) left
		   bottom))))


;;; Y $@%*%U%;%C%HJQ99(J $@AjBPJQ99(J
(defun add-y-offset-world (world value)
  (declare (optimize (compilation-speed 0) (speed 3) (safety 0)))
  (let ((y (- (+ (slot-value world 'world-y-offset) value) 
	      (world-y-start world))))
    (setf (slot-value world 'world-y-offet) y)
    y))

;;; XY$@%*%U%;%C%H$NJQ99(J $@@dBPJQ99(J
(defun change-world-xy-offset-internal (world x y)
  (declare (optimize (compilation-speed 0) (speed 3) (safety 0)))
  (with-region-slots 
   (height width left bottom) world
   (let ((hh height)
	 (ww width)
	 (t-l left)
	 (t-b bottom))

    (setf left (- x (world-x-start world))
	  width ww
	  (slot-value world 'world-x-offset) x)
   
    (setf bottom (- y (world-y-start world))
	  height hh
	  (slot-value world 'world-y-offset) y)
    
    (when (or (/= t-l left)
	      (/= t-b bottom))
          ;;; $@%F%j%H%j!<$N0\F0(J
	(yy-protocol-3 (world-territory-no world) left
		       bottom))
    (values x y))))
    

;;; $@%o!<%/$rMxMQ$7$?(Jregion-union-no-copy
(defmethod region-union-no-copy-world ((world world-primitive)
				       region1 region2)
  (declare (optimize (compilation-speed 0) (speed 3) (safety 0)))
  (let ((region (resize-work world)))
    (with-region-slots ((l1 left) (b1 bottom) (r1 right) (t1 top)) region1
       (with-region-slots ((l2 left) (b2 bottom) (r2 right) (t2 top)) region2
	   (with-region-slots 
	    ((l3 left) (b3 bottom) (r3 right) (t3 top)) region
	    (setf l3 (min l1 l2)
		  b3 (min b1 b2)
		  r3 (max r1 r2)
		  t3 (max t1 t2)))))
    region))

;;; $@%Z!<%8%b!<%I$N%o!<%k%I$N%5%$%:JQ99(J
;;; $@;XDj%5%$%:$,85$N$b$N$h$j>.$5$1$l$P2?$b$7$J$$(J
(defmethod resize-world ((new-region region) (world drawable-page-world))
  (declare (optimize (compilation-speed 0) (speed 3) (safety 0)))
  (force-resize-world-for-page new-region world)
  )
			

;;; $@%S%e%]!<%H%b!<%I$N%o!<%k%I$N%5%$%:JQ99(J
;;; $@;XDj%5%$%:$,85$N$b$N$h$j>.$5$1$l$P2?$b$7$J$$(J
(defmethod resize-world ((new-region region) 
			 (world drawable-viewport-world))
  (declare (optimize (compilation-speed 0) (speed 3) (safety 0)))

  (force-resize-world new-region world))


;;; $@6/@)%o!<%k%I%5%$%:$NJQ99F~NO;~$NJ8;zNsMQ(J
;;; $@C"$7;XDj%5%$%:$,85$N$b$N$h$j>.$5$1$l$P2?$b$7$J$$(J
;;; $@%o!<%k%I%j!<%8%g%s$O!":8>e6y86E@$N%j!<%8%g%s(J
;;; $@?7%j!<%8%g%s$b:8>e6y(J
(defun force-resize-world (new-region world)

  ;;; $@IA2h%j!<%8%g%s$N(J0,0$@$,86E@$N%o!<%k%I%j!<%8%g%s(J
  (declare 
   #-CMU
   (inline - + > <)
   (optimize (compilation-speed 0) (speed 3) (safety 0))
   #-CMU
   (function (move-presentation-internal t integer integer))
   )
  (let ((v-s nil) (h-s nil))
    (with-temp-region-args 
     ((real-region) (work-region3 world)
      :left (- (world-x-start world))
      :bottom (- (world-y-start world))
      :width (region-width world)
      :height (region-height world))
     (let* ((x-start (world-x-start world)) 
	    (y-start (world-y-start world))
	    (x-offset (slot-value world 'world-x-offset))
	    (y-offset (slot-value world 'world-y-offset))
	    (tno (world-territory-no world))
	    (union-region 
	     (region-union-no-copy-world world real-region new-region)))

       (with-region-slots 
	((ul left) (ub bottom) (uw width) (uh height))	 union-region
	(with-region-slots 
	 (left bottom right top) world
	 (when (or (> uw (- right left))
		   (> uh (- top bottom)))
	      ;;; $@Bg$-$5$NJQ99(J X$@J}8~(J

	   (when (> uw (- right left))

     	     ;;; $@%^%$%J%9J}8~$K9-$,$k$+(J
	     (if (< ul (- 0 x-start))
		 (setf (world-x-start world) 
		   (abs ul)))

	     (setf left (+ ul x-offset)
	       right  (+ uw left)
	       h-s t))

	     ;;; $@Bg$-$5$NJQ99(J Y$@J}8~(J
	   (when (> uh (- top bottom))
    	            ;;; $@%^%$%J%9J}8~$K9-$,$k$+(J
	    (if (< ub (- 0 y-start))
		(setf (world-y-start world) 
		  (abs ub)))

	    (setf bottom (+ ub y-offset)
		  top (+ bottom uh)
		  v-s t))

	   ;;; $@%W%l%<%s%H$5$l$F$$$k$b$N$NFbIt0\F0(J
	   (move-presentation-internal world 
								   (- (world-x-start world) x-start)
                                   (- (world-y-start world) y-start))

	  (yy-protocol-4 tno
			 left bottom 
			 (- right left)
			 (- top bottom)
			 (- (world-x-start world) x-start)
			 (- (world-y-start world) y-start))
	    ))))
;(format t "v-s ~a h-s ~a ~%" v-s h-s)
      (values v-s h-s))))


;;; $@C"$7;XDj%5%$%:$,85$N$b$N$h$j>.$5$1$l$P2?$b$7$J$$(J
;;; $@%o!<%k%I%j!<%8%g%s$O!":8>e6y86E@$N%j!<%8%g%s(J
;;; $@?7%j!<%8%g%s$b:8>e6y(J
(defun force-resize-world-for-page (new-region world)
  (declare (optimize (compilation-speed 0) (speed 3) (safety 0))
		   #-CMU
		   (function (move-presentation-internal t integer integer))
		   )
      (let* ((x-start (world-x-start world)) 
	     (y-start (world-y-start world))
	     (x-offset (slot-value world 'world-x-offset))
	     (y-offset (slot-value world 'world-y-offset))
	     (shift-region (shift-region-position 
			    new-region (+ x-start x-offset)
					      (+ y-start y-offset)))
	     (union-region 
	      (region-union-no-copy-world world shift-region world))
	     (d-width (-  (region-width union-region) (region-width world)))
	     (d-height (- (region-height union-region) (region-height world)))
	     (c-width (region-width union-region))
	     (c-height (region-height union-region))
	     (v-s nil) (h-s nil))
	
	(when (or (> d-width 0) (> d-height 0))
	  (with-region-slots
	   ((uleft left) (ubottom bottom)) union-region
	   
	   (if (> d-width 0)
	       (setf h-s t))
	   
	   (if (> d-height 0)
	       (setf v-s T))

	   ;;; $@%9%?!<%H0LCV$NJQ99(J
	   (when  (> d-width 0)
	     (if (and (> 0 uleft)
		      (< uleft (- x-start)))
		 (setf (world-x-start world) 
		   (abs uleft)))

	     (when (> d-height 0)
	       (if (and (> 0 ubottom)
			(< ubottom (- y-start)))
		    (setf (world-y-start world)
		      (abs ubottom))))

		 ;; $@%W%l%<%s%H$5$l$F$$$k$b$N$NFbIt0\F0(J
		 (move-presentation-internal world 
									 (- (world-x-start world) x-start)
									 (- (world-y-start world) y-start))
  
	     (with-region-slots
	      ((wl left) (wb bottom) (ww width) (wh height)) world
	      (setf wl (- x-offset (world-x-start world))
		    wb (- y-offset (world-y-start world))
		    ww c-width
		    wh c-height)))))
	(values v-s h-s)))
	      

(defmethod print-object ((frame window-frame) stream)
  (with-region-slots
   (left bottom width height) frame
	   (format stream "\#<Window-Frame left:~a bottom:~a width:~a height ~a>"
			   left bottom width height)))
	 
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;; $@=D%9%/%m!<%k%P!<$N7W;;%a%=%C%I(J                         ;;;
;;; $@%+%9%?%^%$%:$9$k;~MxMQ<T$,%a%=%C%I$r=q$/(J               ;;;
;;; ARGS.                                                  ;;;
;;;   frame  ->  $@%&%#%s%I%&%U%l!<%`$N%$%s%9%s%?%s%9(J        ;;;
;;;   region ->       $@%&%#%s%I%&$N%j!<%8%g%s(J               ;;;
;;;   other-regions -> $@;H$o$?%j!<%8%g%s$N%j%9%H(J            ;;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
(defmethod compute-window-parts ((frame window-frame) region 
								 other-regions)
  (declare (optimize (compilation-speed 0) (speed 3) (safety 0)))
  (default-compute-frame frame region other-regions))

;;; $@%G%U%)%k%H$N%U%l!<%`%j!<%8%g%s$r5a$a$k(J
(defun default-compute-frame (frame region other-regions)
  (declare (optimize (compilation-speed 0) (speed 3) (safety 0)))
    (let* ((parent (parent-window frame))
		   (border (real-border-belt parent))
		   (max-width (region-width region))
		   (max-height (region-height region))
		   (ll border) (bb border) (rr border) (tt border))
				 
	  ;; bottom$@$,#0$N:GBg9b$5$r5a$a$k(J
	  ;; left $@$,(J $@#0$G:GBgI}$r5a$a$k(J
	  ;; right $@$,(J region-width $@$G(J $@:GBgI}$r5a$a$k(J
	  ;; top $@$,(J region-height $@$G(J $@:GBg9b$5$r5a$a$k!#(J
	  (dolist 
	   (item other-regions)
	   (when item
			 (with-region-slots
			  (left bottom right top width height) item
			  (when (= bottom 0)
					(if (<= bb height)
						(setf bb height)))
			  (when (and (= left 0) (not (= right max-width)))
					(if (<= ll width)
						(setf ll width)))
			  (when (and (= right max-width) (not (= left 0)))
					(if (<= rr width)
						(setf rr width)))
			  (when (= top max-height)
					(if (<= tt height)
						(setf tt height))))
		))

	  (with-region-slots
	   (left bottom right top) frame
	   (setf left ll bottom bb
			 right (- max-width rr)
			 top (- max-height tt)))
	  frame))


;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;; $@%U%l!<%`$N%5%$%:JQ99(J   ;;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
(defmethod set-frame-region ((frame window-frame) new-region)
  (declare (optimize (compilation-speed 0) (speed 3) (safety 0)))
  (unless (eq frame new-region)
    ;;; $@%j!<%8%g%s%5%$%:$NJQ99(J
    (set-region frame  new-region))
  ;;; $@%F%j%H%j!<%5%$%:$NJQ99(J
  (with-region-slots 
   (left bottom width height)  new-region
   (yy-protocol-4 (frame-territory-no frame)
		 left bottom width height))
  frame)


;;;$@%&%#%s%I%&%U%l!<%`I=<(>uBV$NJQ99(J
(defmethod (setf frame-visible) :after (new (frame window-frame))
  (declare (optimize (compilation-speed 0) (speed 3) (safety 0)))
  (if new
	(yy-protocol-2 (frame-territory-no frame) 1)
    (yy-protocol-2 (frame-territory-no frame) 0)))


;;;  $@%9%/%m!<%k%P!<$N%j!<%8%g%sJQ99(J NULL $@$N>l9g(J
(defmethod set-scroll-region ((ob NULL) region)
  (declare (ignore region))
  nil)

;;; $@%9%/%m!<%k%P!<$N%j!<%8%g%sJQ99(J
(defmethod set-scroll-region ((scroll scroll-bar) new-region)
  (declare (optimize (compilation-speed 0) (speed 3) (safety 0)))
  (if (not (eq new-region scroll))
	  (progn
		(with-real-object 
		 (scroll)
		 (set-region scroll new-region)
		 scroll))
	(with-real-object (scroll)))
  )

;;; print-object
(defmethod print-object ((ob vertical-scroll-bar) stream)
  (with-region-slots
   (left bottom width height) ob
   (format stream 
		   "#\<Vertical Scroll Bar left:~a bottom:~a width:~a height:~a>"
		   left bottom width height)))


;;; $@%o!<%k%I$N%*%U%;%C%H$r@_Dj(J
(defgeneric set-vertical-world-y-offset (scroll new-v)
  (:method ((scroll vertical-scroll-bar) new-v)
	   (setf (slot-value scroll 'world-y-offset) new-v))
  (:method ((scroll NULL) new-v)
#-:PCL
(declare (ignore new-v))
  ))


;;; world-height $@$N(Jsetf$@%a%=%C%I(J
;;; $@=DJ}8~$N%9%/%m!<%k%P%$%s%9%?%s%9$,$J$$;~$K$O2?$b$7$J$$(J
(defmethod (setf world-height) (val (ob vertical-scroll-bar))
     (setf (slot-value ob 'world-height) val))
(defmethod (setf world-height) (val (ob NULL))
#-:PCL
  (declare (ignore val))
  (values))

;;; frame-height$@$N(Jsetf$@%a%=%C%I(J
;;; $@=DJ}8~$N%9%/%m!<%k%P%$%s%9%?%s%9$,$J$$;~$K$O2?$b$7$J$$(J
(defmethod (setf frame-height) (val (ob vertical-scroll-bar))
  (setf (slot-value ob 'frame-height) val))
(defmethod (setf frame-height) (val (ob NULL))
#-:PCL
  (declare (ignore val))
  (values))

;;; $@=DJ}8~%9%/%m!<%k%P!<$,Dj5A$5$l$F$$$J$1$l$P2?$b$7$J$$(J
(defmethod redisplay-vertical-scroll ((vscroll null))
  (values))


;;; $@:FI=<(=DJ}8~%9%/%m!<%k%P!<(J
(defmethod redisplay-vertical-scroll ((vscroll vertical-scroll-bar))
  (declare (special *WHITE-COLOR*)
   #-CMU
   (inline - / round * + /=)
   (optimize (compilation-speed 0) (speed 3) (safety 0)))
  (WITH-INHIBIT-SCHEDULING
  
  (let* ((s-height (region-height vscroll))
         (w-height (slot-value vscroll 'world-height))
	 (v-height (slot-value vscroll 'frame-height))
	 (y-offset (slot-value vscroll 'world-y-offset))
	 (color (slot-value vscroll 'scroll-bar-color))
	 (vh (round (/-yy (* s-height v-height) w-height)))
	 (vs 0))

	 ;;; $@:BI87O$r$7$i$Y$k(J
	 (if (eq (coordinate vscroll) :left-bottom)
	 	;;; $@$R$@$j$7$?(J
	    (setf vs (- s-height (- vh (round (/-yy (* s-height (- y-offset)) 
						 w-height)) )))
   	          ;;; $@$R$@$j$&$((J
	    (setf vs (round (/-yy (* (- y-offset) s-height) w-height))))
    
         ;;; $@=q$-D>$7$,I,MW$+D4$Y$k(J
	 (with-slots (sdisplay-height vdisplay-start) vscroll
	    (when (or (/= vs vdisplay-start)
		      (/= vh (if sdisplay-height
				 sdisplay-height
			       0)))

   	           ;;; $@OH$NIA2h(J $@=i4|@_Dj;~(J
		  (if (null sdisplay-height)
		      (progn 
  		         ;;; $@0lEY>C5n(J
			(draw-piece-color vscroll *WHITE-COLOR*)
	                ;;; $@OHI=<((J
			(draw-piece-rectangle vscroll
					      0 0 (region-width vscroll)
					      s-height
					      :color color))
	    
 	            ;;; $@A0$N%9%/%m!<%k%P!<$NI=<($r>C5n$HOHI=<((J
		    (progn 
		       ;;; $@OHI=<((J
		      (draw-piece-rectangle vscroll
					    0 0 (region-width vscroll)
					    s-height :color color)

		       ;;; $@A0$N%9%/%m!<%k%P!<$N>C5n(J
		      (draw-piece-filled-rectangle vscroll
			   3 (+ vdisplay-start  1)
			   (- *SCROLL-BAR-BELT* 6)
			   (- sdisplay-height 2) 
			   :color *WHITE-COLOR*)))
		 
                   ;;; $@%+%l%s%HNN0h$r;XDj$5$l$??'$K$9$k(J
		  (draw-piece-filled-rectangle vscroll
		       3 (+ vs 1) (- *SCROLL-BAR-BELT* 6) (- vh 2)
		       :color color)

		  (setf vdisplay-start vs
			sdisplay-height vh)
		  
		  )
	    )))
  (values))

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;; $@=D%9%/%m!<%k%P!<$N7W;;%a%=%C%I(J                   ;;;
;;; $@%+%9%?%^%$%:$9$k;~MxMQ<T$,%a%=%C%I$r=q$/(J         ;;;
;;; ARGS.                                            ;;;
;;;   vscroll  ->  $@=D%9%/%m!<%k%P!<$N%$%s%9%s%?%s%9(J  ;;;
;;;   region ->       $@%&%#%s%I%&$N%j!<%8%g%s(J         ;;;
;;;   other-regions -> $@;H$o$?%j!<%8%g%s$N%j%9%H(J      ;;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
(defmethod compute-window-parts ((vscroll vertical-scroll-bar) region 
								 other-regions)
  (declare (optimize (compilation-speed 0) (speed 3) (safety 0)))
  (default-compute-vertical-scroll vscroll region other-regions))

;;; $@DL>o$N=DJ}8~$N%9%/%m!<%k%P!<$NNN0h$N7W;;(J
(defun default-compute-vertical-scroll (vscroll region other-regions)
  (declare (optimize (compilation-speed 0) (speed 3) (safety 0))
		   (special *SCROLL-BAR-BELT*))
    (let ((hh (region-top region))
		  (my-height (region-height region))
		  (bb 0))
				 
	  ;;; $@:8C<6y$G!"0lHV(Jbottom $@B&$K$"$k$b$N$r5a$a$k!#(J
	  (dolist 
	   (item other-regions)
	   (when item
			 (when (and (= (region-left item) 0)
						(= (region-bottom item) 0))
				   (setf bb (region-top item))
				   (decf my-height (region-height item))
				   (return))))
	  ;; $@:8C<6y$G(Jtop$@B&$K$"$k$b$N$r5a$a$k(J
	  (dolist 
	   (item other-regions)
	   (when item
			 (when (and (= (region-left item) 0)
						(= (region-top item) hh))
				   (decf my-height (region-height item))
				   (return))))

	  (with-region-slots
	   (left  bottom width height) vscroll
	   (setf left 0
			 bottom bb
			 width *SCROLL-BAR-BELT*
			 height my-height))
	  vscroll))


;;; $@=DJ}8~%9%/%m!<%k%P!<$N%j!<%8%g%sJQ99(J
(defmethod set-scroll-region :after ((scroll vertical-scroll-bar) new-region)
#-:PCL
    (declare (ignore new-region))
    (setf (slot-value scroll 'sdisplay-height) nil)
	scroll)



;;; print-object
(defmethod print-object ((ob horizontal-scroll-bar) stream)
  (with-region-slots
   (left bottom width height) ob
  (format stream 
		  "#\<Horizontal Scroll Bar left:~a bottom:~a width:~a height:~a>"
		  left bottom width height)))

;;; $@%o!<%k%I$N%*%U%;%C%H$r@_Dj(J
(defgeneric set-horizontal-world-x-offset (scroll new-v)
  (:method ((scroll horizontal-scroll-bar) new-v)
	   (setf (slot-value scroll 'world-x-offset) new-v))
  (:method ((scroll NULL) new-v)
#-:PCL
(declare (ignore new-v))
  ))

;;; world-width $@$N(Jsetf$@%a%=%C%I(J
;;; $@2#J}8~$N%9%/%m!<%k%P%$%s%9%?%s%9$,$J$$;~$K$O2?$b$7$J$$(J
(defmethod (setf world-width) (val (ob horizontal-scroll-bar))
     (setf (slot-value ob 'world-width) val))
(defmethod (setf world-width) (val (ob NULL))
#-:PCL
  (declare (ignore val))
  (values))

;;; frame-width$@$N(Jsetf$@%a%=%C%I(J
;;; $@2#J}8~$N%9%/%m!<%k%P%$%s%9%?%s%9$,$J$$;~$K$O2?$b$7$J$$(J
(defmethod (setf frame-width) (val (ob horizontal-scroll-bar))
  (setf (slot-value ob 'frame-width) val))
(defmethod (setf frame-width) (val (ob NULL))
#-:PCL
  (declare (ignore val))
  (values))



;;; $@:FI=<(2#J}8~%9%/%m!<%k%P!<(J NULL $@$N>l9g(J
(defmethod redisplay-horizontal-scroll ((hscroll NULL))
  (values))

;;; $@:FI=<(2#J}8~%9%/%m!<%k%P!<(J
(defmethod redisplay-horizontal-scroll ((hscroll horizontal-scroll-bar))
  (declare (special *WHITE-COLOR*)
   #-CMU
   (inline / * /= + - round)
   (optimize (compilation-speed 0) (speed 3) (safety 0)))
  (WITH-INHIBIT-SCHEDULING
  (let* ((s-width (region-width hscroll))
         (w-width (slot-value hscroll 'world-width))
		 (v-width (slot-value hscroll 'frame-width))
		 (color (slot-value hscroll 'scroll-bar-color))
		 (x-offset (- (slot-value hscroll 'world-x-offset)))
		 (vw (round (/-yy (* s-width v-width) w-width)))
		 (vs (round (/-yy (* x-offset s-width) w-width))))

    (with-slots (hdisplay-start sdisplay-width) hscroll
	(when (or (/= hdisplay-start vs)
		  (/= (if sdisplay-width 
			  sdisplay-width
			0) vw))

	  ;;; $@OH$rI=<($9$k(J $@=i4|>uBV$N$_(J
	      (if (null sdisplay-width)
		  (progn 
	             ;;; $@0lEY>C5n(J
		    (draw-piece-color hscroll *WHITE-COLOR*)
                    ;;; $@OH$rIA2h(J
		    (draw-piece-rectangle hscroll
					  0 0 s-width
					  (region-height hscroll)
					  :color color))

                 ;;; $@I=<(NN0h$N%/%j%"!<$HOH$rIA2h(J
		(progn 
	           ;;; $@OH$rIA2h(J
		  (draw-piece-rectangle hscroll
					0 0 s-width  (region-height hscroll)
					:color color)
	           ;;; $@I=<(NN0h$N%/%j%"!<(J
		  (draw-piece-filled-rectangle hscroll 
					       (+ hdisplay-start 1) 3
					       (- sdisplay-width 2)
					       (- *SCROLL-BAR-BELT* 6)
					       :color *WHITE-COLOR*)))
	  
	      
              ;;; $@%+%l%s%HNN0h$r;XDj$5$l$??'$K$9$k(J
	      (draw-piece-filled-rectangle hscroll 
			  (+ vs 1) 3 (- vw 2) (- *SCROLL-BAR-BELT* 6)
			  :color color)

	      (setf hdisplay-start vs
		    sdisplay-width vw)
	      ))))
  (values))


;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;; $@2#%9%/%m!<%k%P!<$N7W;;%a%=%C%I(J                   ;;;
;;; $@%+%9%?%^%$%:$9$k;~MxMQ<T$,%a%=%C%I$r=q$/(J         ;;;
;;; ARGS.                                            ;;;
;;;   hscroll  ->  $@2#%9%/%m!<%k%P!<$N%$%s%9%s%?%s%9(J  ;;;
;;;   region ->       $@%&%#%s%I%&$N%j!<%8%g%s(J         ;;;
;;;   other-regions -> $@;H$o$?%j!<%8%g%s$N%j%9%H(J      ;;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
(defmethod compute-window-parts ((hscroll horizontal-scroll-bar) region 
								 other-regions)
  (declare (optimize (compilation-speed 0) (speed 3) (safety 0)))
  (default-compute-horizontal-scroll hscroll region other-regions))

(defun default-compute-horizontal-scroll (hscroll region other-regions)
  (declare (optimize (compilation-speed 0) (speed 3) (safety 0))
		   (special *SCROLL-BAR-BELT*))
    (let ((ww 0)
		  (max-height (region-height region))
		  (tt (region-top region)))
				 
	  ;;; $@0lHV2<$K$"$k%&%#%s%I%&%Q!<%D$NI}$r5a$a$k(J
	  (dolist 
	   (item other-regions)
	   (when item
			 (if (= tt (region-top item))
				 (incf ww (region-width item)))))
	  
	  (with-region-slots
	   (left  bottom width height) hscroll
	   (setf left *SCROLL-BAR-BELT*
			 bottom (- max-height *SCROLL-BAR-BELT*)
			 width (- (region-width region) ww)
			 height *SCROLL-BAR-BELT*))
	  hscroll))

;;; $@2#J}8~%9%/%m!<%k%P!<$N%j!<%8%g%sJQ99(J
(defmethod set-scroll-region :after ((hscroll horizontal-scroll-bar) 
									 new-region)
#-:PCL
  (declare (ignore new-region))
  (setf (slot-value hscroll 'sdisplay-width) nil)
  hscroll)

;;; $@I=<(%a%=%C%I(J
(defmethod print-object ((ob coordinate-area) stream)
  (with-region-slots 
   (left bottom width height) ob
   (format stream "\#<Coordinate area left:~a bottom:~a width: ~a height:~a>"
		   left bottom width height)))

;;; $@:BI87OI=<(%(%j%"$N:FI=<((J
(defmethod redisplay-coordinate-area ((coordinate NULL))
  (values))

;;; $@:BI87OI=<(%(%j%"$N:FI=<((J
(defmethod redisplay-coordinate-area ((coordinate coordinate-area))
  (declare (special *WHITE-COLOR* *left-bottom* *left-top*)
   #-CMU
   (inline + / - round )
   (optimize (compilation-speed 0) (speed 3) (safety 0)))
  (let ((color (coordinate-area-color coordinate)))
    (with-region-slots 
     (width height) coordinate
    
    ;;; $@%P%C%/%0%i%&%s%I$r%/%j%"!<(J
    (draw-piece-color coordinate *WHITE-COLOR*)

    ;;; $@:BI87O$NI=<((J
    (if (eq (coordinate coordinate) :left-top)
	(draw-piece-put-image coordinate 0 0 *left-top*)
      (draw-piece-put-image coordinate 0 0 *left-bottom*))

     ;;; $@OH$NIA2h(J
    (draw-piece-rectangle coordinate 0 0 width height :color color)

    (values))))

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;; $@:BI87OI=<(%(%j%"$N7W;;%a%=%C%I(J                   ;;;
;;; $@%+%9%?%^%$%:$9$k;~MxMQ<T$,%a%=%C%I$r=q$/(J         ;;;
;;; ARGS.                                            ;;;
;;;     coordinate  ->  $@:BI87OI=<(%(%j%"%$%s%9%?%s%9(J ;;;
;;;     region ->       $@%&%#%s%I%&$N%j!<%8%g%s(J       ;;;
;;;     other-regions -> $@;H$o$?%j!<%8%g%s$N%j%9%H(J    ;;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
(defmethod compute-window-parts ((coordinate coordinate-area) region 
								 other-regions)
  (declare (optimize (compilation-speed 0) (speed 3) (safety 0)))
  (default-compute-coordinate coordinate region other-regions))
					 
;;; $@%G%U%)%k%H$N:BI87OI=<(%(%j%"$NNN0h7W;;(J
(defun default-compute-coordinate (coordinate region other-regions)
  (declare (optimize (compilation-speed 0) (speed 3) (safety 0))
		   (special *SCROLL-BAR-BELT*)
		   (ignore other-regions))
  (let ((height (region-height region)))
	(with-region-slots
	 (left  bottom right top) coordinate
	 (setf left 0 bottom (- height *SCROLL-BAR-BELT*)
		   top (+ bottom *SCROLL-BAR-BELT*)
		   right (+ left *SCROLL-BAR-BELT*)))
	coordinate))


;;; $@:BI87OI=<(%(%j%"$N2<$N0LCVJQ99(J NULL$@$J$i$P2?$b$7$J$$(J
(defmethod set-coordinate-area-region (new-region (coordinate NULL))
#-:PCL
  (declare (ignore new-region))
  (values))

;;; $@:BI87OI=<(%(%j%"$N2<$N0LCVJQ99(J
(defmethod set-coordinate-area-region (new-region
				       (coordinate coordinate-area))
  (declare (optimize (compilation-speed 0) (speed 3) (safety 0)))
  (if (eq new-region coordinate)
      (with-real-object (coordinate))
    (with-real-object 
     (coordinate)
     (with-region-slots 
      ((b1 bottom) (l1 left)) coordinate
      (with-region-slots
       ((b2 bottom) (l2 left)) new-region
		      
       (setf b1 b2 l1 l2)
	   ))))
  coordinate)

;;; $@I=<(%*%V%8%'%/%H(J
(defmethod print-object ((ob window-border) stream)
  (format stream "\#<Window Border>"))

;;; $@%&%#%s%I%&%9%H%j!<%`$+!)(J
(defun window-streamp (object)
   (typep object 'window-stream))

(defun /-yy (arg1 arg2)
  (declare 
   #-CMU
   (inline / zerop)
   (optimize (compilation-speed 0) (speed 3) (safety 0)))
  (if (zerop arg2)
      0
    (/ arg1 arg2)))

;;; $@;XDj%-!<%o!<%I%j%9%H$r=|$$$?%j%9%H$rJV$9(J
(defun delete-keyword-form-rest (keyword rest)
  (declare (optimize (compilation-speed 0) (speed 3) (safety 0)))
  (let ((flg nil))
    (mapcan #'(lambda (x)
		(if (find x keyword)
		    (progn (setf flg t) (values))
		  (if flg
		      (progn (setf flg nil) (values))
		    (list x))))
	    rest)))
	    
;;; End of file