;;; -*- Mode: LISP; Syntax: Common-lisp; Package: YY; Base: 10 -*-
;;; presentation-macro.lisp
;;;
;;;  Copyright (C) 1989,1990,1991 Aoyama Gakuin University
;;;
;;;             All Rights Reserved
;;;
;;; This software is developed for the YY project of Aoyama Gakuin University.
;;; Permission to use, copy, modify, and distribute this software
;;; and its documentation for any purpose and without fee is hereby granted,
;;; provided that the above copyright notices appear in all copies and that
;;; both that copyright notice and this permission notice appear in
;;; supporting documentation, and that the name of Aoyama Gakuin
;;; not be used in advertising or publicity pertaining to distribution of
;;; the software without specific, written prior permission.
;;;
;;; This software is made available AS IS, and Aoyama Gakuin makes no
;;; warranty about the software, its performance or its conformity to
;;; any specification.
;;;
;;; To make a contact: Send E-mail to ida@csrl.aoyama.ac.jp for overall
;;; issues. To ask specific questions, send to the individual authors at
;;; csrl.aoyama.ac.jp. To request a mailing list, send E-mail to
;;; yyonx-request@csrl.aoyama.ac.jp.
;;;
;;; Authors:
;;;   version 1.4 92/03/04 by t.kosaka

(in-package :yy)

;;; $@MxMQ<T$NDj5A$7$?%W%l%<%s%F!<%7%g%s%/%i%9$r$D$/$k(J
;;; class-name --> $@%/%i%9L>$N%7%s%\%k(J
;;; class-name-list -> $@%/%i%9L>$N%j%9%H(J(CL$@$N%G%U%)%k%H%/%i%9$b4^$`(J)
;;; $@La$jCM(J   $@%W%l%<%s%F!<%7%g%s%/%i%9L>(J($@%7%s%\%k(J)
(defmacro define-presentation-class (class-name class-name-list)
  `(progn
     (setf (get (QUOTE ,class-name) 'present-class) (QUOTE ,class-name-list))
     (QUOTE ,class-name)))

 	 
;;; $@MxMQ<T$,IA2h$7$?IA2h%W%j%_%F%#%V$r(J
;;; $@%W%l%<%s%F!<%7%g%s$H$7$FEPO?$9$k!#(J
;;; object  ---> $@IA2h$9$k;~$N%*%V%8%'%/%H(J
;;; stream  ---> $@IA2h$9$k;~$N%9%H%j!<%`(J
;;; presentation-class --> $@%W%l%<%s%F!<%7%g%s%/%i%9(J
;;; body    ---> $@IA2h4X?t$r5-=R$9$k(J
(defmacro with-output-as-presentation ((object stream  &optional 
					       presentation-class)
				       &body body)
  (declare (optimize (compilation-speed 0) (speed 3) (safety 0))
		   (special *total-send*))
  (let ((ins (gentemp))
		(region (gentemp)))
    `(let ((,ins 
		(make-instance 'display-yy-presentation
			       :display-presented-class 
			       (if (null ,presentation-class)
				   (type-of ,object)
				 ,presentation-class)
			       :presented-stream ,stream
			       :display-presented-instance ,object))
	   (,region (make-region :left 999999 :bottom 999999
				 :right -999999 :top -99999)))
       
       (setf (slot-value ,stream 'drawing-region) ,region
	     (slot-value ,stream 'presentation-instance) ,ins)
       
       (unwind-protect
	   (progn
	     ,@body)
	 (progn
	   (setf (slot-value ,stream 'drawing-region) nil
		 (slot-value ,stream 'presentation-instance) nil))
	 )

       (set-region ,ins ,region)

       (init-present-region ,ins (world-x-start ,stream)
			    (world-y-start ,stream))

       ;; $@%F%j%H%j$N@_Dj$HHV9f@_Dj(J
       (make-splite-territory ,ins ,stream)

       (set-up-presentation-object ,ins)

       ;; $@%W%l%<%s%F!<%7%g%s$r%W%C%7%e(J
       (push ,ins (present-list ,stream))
		 ;;; $@IA2h=hM}$r<B9T(J
       (first-draw-in-presentation ,ins (world-x-start ,stream)
				   (world-y-start ,stream))
       (values ,object ,ins)))
  )

;;; $@%G!<%?%*%V%8%'%/%H$,%j%9%H$N$h$&$JJ#9g%*%V%8%'%/%H$N>l9g!"(J
;;; $@J#9g%*%V%8%'%/%H$r9=@.$9$kFbIt%G!<%?%*%V%8%'%/%H$r(J
;;; $@FHN)$7$?%W%l%<%s%F!<%7%g%s$H$9$k!#(J
;;; $@$3$N%^%/%m$O!"(Jwith-output-as-presentation $@$NCf$G$7$+MxMQ$G$-$J$$!#(J
;;; $@$^$?!"%W%l%<%s%H$7$?FbIt%G!<%?%*%V%8%'%/%H$OC1BN$G0\F0$O!"$G$-$J$$(J
;;; $@C1BN$N0\F0$O!"?F(J(with-output-as-presentation)
;;;$@$N%W%l%<%s%F!<%7%g%s$N0\F0$H$J$k(J
;;; $@MxMQ<T$,IA2h$7$?IA2h%W%j%_%F%#%V$r(J
;;; $@%W%l%<%s%F!<%7%g%s$H$7$FEPO?$9$k!#(J
;;; object  ---> $@IA2h$9$k;~$N%*%V%8%'%/%H(J
;;; stream  ---> $@IA2h$9$k;~$N%9%H%j!<%`(J
;;; presentation-class --> $@%W%l%<%s%F!<%7%g%s%/%i%9(J
;;; body    ---> $@IA2h4X?t$r5-=R$9$k(J
(defmacro with-inside-output-as-presentation ((object stream  &optional
						      presentation-class)
					      &body body)
  (let ((ins (gentemp))
		(parent (gentemp))
		(parent-region (gentemp))
		(region (gentemp)))
    `(let ((,ins 
	    (make-instance 'display-yy-presentation-root
			   :display-presented-class
                           (if (null ,presentation-class)
                               (type-of ,object)
			     ,presentation-class)
			   :presented-stream ,stream
			   :display-presented-instance ,object))
	   (,parent (slot-value ,stream 'presentation-instance))
	   (,parent-region (slot-value ,stream 'drawing-region))
	   (,region (make-region :left 999999 :bottom 999999
				 :right -999999 :top -99999)))

       (setf (slot-value ,stream 'drawing-region) ,region
	     (slot-value ,stream 'presentation-instance) ,ins)
       
       (unwind-protect
	   (progn ,@body)
	 (progn
	   (setf
	    (slot-value ,stream 'drawing-region) ,parent-region
	    (slot-value ,stream 'presentation-instance) ,parent)))

       (set-region ,ins ,region)
       
       ;; $@?F$KIA2h$N%a%=%C%I$r@_Dj$9$k(J
       (setf  (slot-value ,parent 'draw-method-list)
	      (nconc (slot-value ,parent 'draw-method-list)
		     (slot-value ,ins 'draw-method-list)))
	   
       (setf (slot-value ,ins 'parent-presentation) ,parent)
       
       (push ,ins (slot-value ,parent 'child-present-list))
       (push ,ins (slot-value ,stream 'present-list))

       (values ,object ,ins))))


;;; $@%W%l%<%s%H$5$l$F$$$kIA2h%*%V%8%'%/%H$NJQ99(J
;;; $@;XDj$7$?(Jobject$@$H!"(Jpresentation-class$@$G0lCW$9$k(J
;;; $@IA2h%W%l%<%s%F!<%7%g%s$rA4$FJQ99$9$k!#(J
;;; $@$^$?!"(Jpresentation-ob $@$,M?$($i$l$l!"(J
;;; $@0lCW$9$k(J $@%W%l%<%s%F!<%7%g%s%*%V%8%'%/%H$,B8:_$9$l$P!"(J
;;; $@$=$NIA2h%W%l%<%s%F!<%7%g%s$rJQ99$9$k!#(J
;;; $@IA2h=*N;8e!"(Jshaped-presented-object$@$r8F$V!#(J
;;; object ---> $@IA2h$^$?$O0u;z$7$?;~$N%*%V%8%'%/%H(J
;;; stream ---> $@IA2h$^$?$O0u;z$7$?;~$N%9%H%j!<%`(J
;;; presentation-class --> $@%W%l%<%s%F!<%7%g%s%/%i%9(J
;;; &optional presentation-ob    --> $@%W%l%<%s%F!<%7%g%s$N%$%s%9%?%s%9(J
;;; body   ---> $@IA2h$^$?$O!"0u;z=hM}$r5-=R$9$k(J
(defmacro with-shape-presentation ((object stream presentation-class
					   &optional (presentation-ob nil))
				   &body body)
  (let ((present-list (gentemp))
	(parent (gentemp)))
    `(let ((,present-list (slot-value ,stream 'present-list)))
       (if ,presentation-ob
	   (let ((,parent (parent-presentation ,presentation-ob)))
;	     (store-old-left-bottom ,presentation-ob ,stream)
	     (before-reshape ,presentation-ob ,stream)
	     (unwind-protect
		 (progn
		   ,@body)
	       (progn
		 (setf (slot-value ,stream 'drawing-region) nil
		       (slot-value ,stream 'presentation-instance) nil)))

	     (when ,parent
		  (setf (slot-value ,parent 'draw-method-list)
			(nconc (slot-value ,parent 'draw-method-list)
			       (slot-value ,presentation-ob 'draw-mehtod-list))))
	     
	     (after-reshape ,presentation-ob ,stream)
			 
	     (shaped-presented-object 
	      (display-presented-instance ,presentation-ob) ,stream)
	     )
	 (let ((,parent nil))
	   (dolist 
	    (item ,present-list)
	    (if (presentation-classp ,object ,presentation-class)
		(when 
		 (eq ,object (slot-value item '_display-presented-instance))
;		 (store-old-left-bottom item ,stream)
		 (setf ,parent (parent-presentation item))
		 (before-reshape item ,stream)
		 (unwind-protect
		     (progn ,@body)
		   (progn
		     (setf (slot-value ,stream 'drawing-region) nil
			   (slot-value ,stream 'presentation-instance) nil)))
		 (when ,parent
		       (setf (slot-value ,parent 'draw-method-list)
			     (nconc (slot-value ,parent 'draw-method-list)
				    (slot-value item 'draw-method-list))))
				    
		   (after-reshape item ,stream)
		   (shaped-presented-object 
		    (slot-value item '_display-presented-instance) ,stream))
		  
		  ))
	     )))))

;;; $@%W%l%<%s%H$5$l$F$$$kIA2h%*%V%8%'%/%H$NJQ99(J
;;; $@;XDj$7$?(Jobject$@$H!"(Jpresentation-class$@$G0lCW$9$k(J
;;; $@IA2h%W%l%<%s%F!<%7%g%s$rA4$FJQ99$9$k!#(J
;;; $@$^$?!"(Jpresentation-ob $@$,M?$($i$l$l!"(J
;;; $@0lCW$9$k(J $@%W%l%<%s%F!<%7%g%s%*%V%8%'%/%H$,B8:_$9$l$P!"(J
;;; $@$=$NIA2h%W%l%<%s%F!<%7%g%s$rJQ99$9$k!#(J
;;; $@IA2h=*N;8e!"(Jshaped-presented-object$@$r8F$V!#(J
;;; object ---> $@IA2h$^$?$O0u;z$7$?;~$N%*%V%8%'%/%H(J
;;; stream ---> $@IA2h$^$?$O0u;z$7$?;~$N%9%H%j!<%`(J
;;; presentation-class --> $@%W%l%<%s%F!<%7%g%s%/%i%9(J
;;; &optional presentation-ob    --> $@%W%l%<%s%F!<%7%g%s$N%$%s%9%?%s%9(J
;;; body   ---> $@IA2h$^$?$O!"0u;z=hM}$r5-=R$9$k(J
(defmacro with-shape-presentation-alone 
  ((object stream presentation-class
		   &optional (presentation-ob nil)
		   &key (redraw T))	 &body body)
  (let ((present-list (gentemp))
        (parent (gentemp)))
    `(let ((,present-list (slot-value ,stream 'present-list)))
       (if ,presentation-ob
	   (let ((,parent (parent-presentation ,presentation-ob)))
;	     (store-old-left-bottom ,presentation-ob ,stream)
	     (before-reshape ,presentation-ob ,stream)

	     (unwind-protect
		 (progn ,@body)
	       (progn
		 (setf (slot-value ,stream 'drawing-region) nil
		       (slot-value ,stream 'presentation-instance) nil)))
	     (when ,parent
		   (setf (slot-value ,parent 'draw-method-list)
			 (nconc (slot-value ,parent 'draw-method-list)
				(slot-value ,presentation-ob 'draw-method-list))))

	     (after-reshape ,presentation-ob ,stream ,redraw)
	     )
	   (let ((,parent nil))
	     (dolist
	      (item ,present-list)

	      (if (presentation-classp ,object ,presentation-class)
		  (when 
		   (eq ,object (slot-value item '_display-presented-instance))
;		   (store-old-left-bottom item ,stream)
		   (setf ,parent (parent-presentation item))
		   (before-reshape item ,stream)

		   (unwind-protect
		       (progn ,@body)
		     (progn
		       (setf (slot-value ,stream 'drawing-region) nil
			     (slot-value ,stream 'presentation-instance) nil)))
		   (when ,parent
			 (setf (slot-value ,parent 'draw-method-list)
			       (nconc (slot-value ,parent 'draw-method-list)
				      (slot-value item 'draw-method-list))))
		   (after-reshape item ,stream ,redraw)
		   )
		  )))
	   ))))
	   

;;; $@%W%l%<%s%H$5$l$F$$$kIA2h%*%V%8%'%/%H$NJQ99(J
;;; $@;XDj$7$?(Jobject $@$H(J eq $@$G$+$D!"(Jpresentation-class$@$G0lCW$9$k(J
;;; $@IA2h%W%l%<%s%F!<%7%g%s$rA4$FJQ99$9$k!#(J
;;; $@$^$?!"(Jpresentation-ob $@$,M?$($i$l$l!"(J
;;; $@0lCW$9$k(J $@%W%l%<%s%F!<%7%g%s%*%V%8%'%/%H$,B8:_$9$l$P!"(J
;;; $@$=$NIA2h%W%l%<%s%F!<%7%g%s$rJQ99$9$k!#(J
;;; $@$3$N%^%/%m$O!"(Jwith-shape-presentation$@$d(J
;;; with-shape-presentation-alone $@$NCf$@$18F$P$l$k!#(J
;;; $@IA2h=*N;8e!"(Jshaped-presented-object$@$r8F$V!#(J
;;; object ---> $@IA2h$^$?$O0u;z$7$?;~$N%*%V%8%'%/%H(J
;;; stream ---> $@IA2h$^$?$O0u;z$7$?;~$N%9%H%j!<%`(J
;;; presentation-class --> $@%W%l%<%s%F!<%7%g%s%/%i%9(J
;;; &optional presentation-ob    --> $@%W%l%<%s%F!<%7%g%s$N%$%s%9%?%s%9(J
;;; body   ---> $@IA2h$^$?$O!"0u;z=hM}$r5-=R$9$k(J
(defmacro with-inside-shape-presentation 
	  ((object stream presentation-class
		   &optional (presentation-ob nil))
	   &body body)
  (let ((present-list (gentemp))
	(parent (gentemp)))
    `(let ((,present-list (slot-value ,stream 'present-list))
	   (,parent (slot-value ,stream 'presentation-instance)))
       (if ,presentation-ob
	   (progn
	     (if (null (slot-value ,stream 'present-redraw-all))
		 (progn 
		   (before-reshape ,presentation-ob ,stream)
		   (unwind-protect
		       (progn
			 ,@body)
		     (progn
		       (setf (drawing-region ,stream) ,parent
			     (presentation-instance ,stream) ,parent)))
		    (setf (slot-value ,parent 'draw-method-list)
			  (nconc
			   (slot-value ,parent 'draw-method-list)
			   (slot-value ,presentation-ob 'draw-method-list)))
		   (with-slots
		    ((wxs world-x-start) (wys world-y-start)) ,stream
		    (shift-region-position ,presentation-ob wxs wys))
		   )
	       ;; $@A4$F=q$-D>$7(J
	       (progn
		 (setf (slot-value ,stream 'drawing-region) ,presentation-ob
		       (slot-value ,stream 'presentation-instance) 
		       ,presentation-ob)
		 (unwind-protect
		     (progn ,@body)
		   (progn
		     (setf (slot-value ,stream 'drawing-region) ,parent
			   (slot-value ,stream 'presentation-instance) 
			   ,parent)))
		 (setf (slot-value ,parent 'draw-method-list)
		       (nconc
			(slot-value ,parent 'draw-method-list)
			(slot-value ,presentation-ob 'draw-method-list)))
	;(setf (slot-value ,presentation-ob 'draw-method-list)
					; nil)
			  )))
	 ;; $@%W%l%<%s%F!<%7%g%s$N<BBV$,$J$$;~(J
	 (if (null (slot-value ,stream 'present-redraw-all))
	     (progn
	       (dolist 
		(item ,present-list)

		(if (presentation-classp ,object ,presentation-class)
		    (when 
		     (eq ,object 
			 (slot-value item '_display-presented-instance))
		     (before-reshape item ,stream)
		     (unwind-protect
			 (progn ,@body)
		       (progn
			 (setf (slot-value ,stream 'drawing-region) 
			       ,parent
			       (slot-value ,stream 'presentation-instance) 
			       ,parent)))
		    (setf  
		     (slot-value ,parent 'draw-method-list)
		     (nconc
		      (slot-value ,parent 'draw-method-list)
		      (slot-value item 'draw-method-list)))
		;(setf (slot-value item 'draw-method-list) nil)				
		     (with-slots
		      ((wxs world-x-start) (wys world-y-start)) ,stream
		      (shift-region-position item wxs wys))
		     )))
	       )))
       )))

;;; $@%W%l%<%s%H$5$l$F$$$kIA2h%*%V%8%'%/%H$NA4$F$NJQ99(J
;;; $@I,$::G>e0L$N?F$G$J$1$l$P!"$J$i$J$$!#(J
;;; $@$=$&$G$J$$$H!"5sF0$OJ]>Z$7$J$$!#(J
;;; $@;XDj$7$?(Jobject$@$H!"(Jpresentation-class$@$G0lCW$9$k(J
;;; $@IA2h%W%l%<%s%F!<%7%g%s$rA4$FJQ99$9$k!#(J
;;; $@$^$?!"(Jpresentation-ob $@$,M?$($i$l$l!"(J
;;; $@0lCW$9$k(J $@%W%l%<%s%F!<%7%g%s%*%V%8%'%/%H$,B8:_$9$l$P!"(J
;;; $@$=$NIA2h%W%l%<%s%F!<%7%g%s$rJQ99$9$k!#(J
;;; $@IA2h=*N;8e!"(Jshaped-presented-object$@$r8F$V!#(J
;;; object ---> $@IA2h$^$?$O0u;z$7$?;~$N%*%V%8%'%/%H(J
;;; stream ---> $@IA2h$^$?$O0u;z$7$?;~$N%9%H%j!<%`(J
;;; presentation-class --> $@%W%l%<%s%F!<%7%g%s%/%i%9(J
;;; &optional presentation-ob    --> $@%W%l%<%s%F!<%7%g%s$N%$%s%9%?%s%9(J
;;; body   ---> $@IA2h$^$?$O!"0u;z=hM}$r5-=R$9$k(J
(defmacro with-shape-presentation-alone-all
  ((object stream presentation-class
	   &optional (presentation-ob nil))
   &body body)
  (let ((present-list (gentemp)))
    `(let ((,present-list (slot-value ,stream 'present-list)))
       (if ,presentation-ob
	   (progn
	     (shape-all-init ,presentation-ob ,stream)
	     (unwind-protect
		 (progn
		   ,@body)
	       (progn
		 (setf (slot-value ,stream 'drawing-region) nil
		       (slot-value ,stream 'presentation-instance) nil
		       (slot-value ,stream 'present-redraw-all) nil)))
	     (shape-all-end ,presentation-ob ,stream)
	     nil)
	 (progn
	   (dolist 
	    (item ,present-list)
	    (if (presentation-classp ,object ,presentation-class)
		(when 
		 (eq ,object (slot-value item '_display-presented-instance))
		 (shape-all-init item ,stream)
		 (unwind-protect
		     (progn
		       ,@body)
		   (progn
		     (setf (drawing-region ,stream) nil
			   (presentation-instance ,stream) nil
			   (present-redraw-all ,stream) nil)))
		 (shape-all-end item ,stream))
	      )))
	 ))))
		

;;; End of file


