;;; -*- Mode: LISP; Syntax: Common-lisp; Package: YY; Base: 10 -*-
;;; YY $@$GDj5A$7$F$$$k%^%/%m(J
;;; define-macro.lisp
;;;
;;;  Copyright (C) 1989,1990,1991 Aoyama Gakuin University and CSK Corp.
;;;
;;;		All Rights Reserved
;;;
;;; This software is developed for the YY project of Aoyama Gakuin University.
;;; Permission to use, copy, modify, and distribute this software
;;; and its documentation for any purpose and without fee is hereby granted,
;;; provided that the above copyright notices appear in all copies and that
;;; both that copyright notice and this permission notice appear in 
;;; supporting documentation, and that the names of Aoyama Gakuin of and CSK
;;; not be used in advertising or publicity pertaining to distribution of
;;; the software without specific, written prior permission.
;;;
;;; This software is made available AS IS, and Aoyama Gakuin makes no
;;; warranty about the software, its performance or its conformity to
;;; any specification. 
;;;
;;; To make a contact: Send E-mail to ida@csrl.aoyama.ac.jp for overall
;;; issues. To ask specific questions, send to the individual authors at
;;; csrl.aoyama.ac.jp. To request a mailing list, send E-mail to 
;;; yyonx-request@csrl.aoyama.ac.jp.
;;;
;;; Authors:
;;;   version 1.0 90/06/01 by t.kosaka (kosaka@csrl.aoyama.ac.jp)
;;;   version 1.1 90/07/31 by t.kosaka
;;;   update 1.11 90/09/14 by t.kosaka
;;;   version 1.2 90/11/05 by t.kosaka
;;;   version 1.3 90/12/19 by T.kosaka 
;;;               delete drawing-text macro
;;;   version 1.3 90/2/6/  by T.kosaka


;;; YY$@$GDj5A$7$F$$$k%^%/%m(J
;;; 5/10 1990 $@8E:d(J

;;; Version 1.0   Coded by t.kosaka 1990-5-10
;;; Change log 
;;; Updata with-translate-coordinate-stream can use all object.
;;;        Add with-temp-region 
;;; Update WITH-INHIBIT-SCHEDULING is added Symbolics code
;;;	   Contribution of E.Shiota
;;; Update add funtionalty unwind-protect at with-XXXX

(in-package :yy)

;;; with-position-destructured 
(defmacro with-position-destructured (((X Y) position) &rest body)
  `(let ((,X (position-x ,position))
	(,Y (position-y ,position)))
    ,@body))


;;; with-protocol {form}*
;;; $@%3%^%s%I!"L?Na$NAw=P=hM}$NGSB>@)8f(J
;;;
#+(OR LUCID EXCL SYMBOLICS)
(defmacro with-protocol (&rest forms)
  `(progn
	 (if *packet-sending*
		 #+:LUCID
	   (lucid::PROCESS-WAIT "Wait Forever" #'packet-sending)
	   #+:EXCL
	   (MP:PROCESS-WAIT "Wait Forever" #'packet-sending)
	   #+:SYMBOLICS
	   (process:process-wait "Wait Forever" #'packet-sending)
	   )
	 (push t  *packet-sending*)
	 ,@forms
	 (pop *packet-sending* )))

#+CMU
(defmacro with-protocol (&rest forms)
  (let ((mask (gentemp)))
	`(let ((,mask (before-interrupt-stop)))
	  ,@forms
	  (after-interrupt-stop ,mask)
	  )))

;;; defcommand command-name arguments {form}*
;;; YY Protocol $@$rE83+$9$k(J
;;; $@%3%^%s%I!"L?Na$NAw=P=hM}$NGSB>@)8f(J
;;;
#+(OR LUCID EXCL SYMBOLICS)
(defmacro defcommand (pn args &rest forms)
  (let ((val (gentemp)))
    `(defun ,pn ,args
       (declare (special *send* *max-message-size*)
		(optimize (compilation-speed 0) (speed 3) (safety 0)))
       (let ((,val nil))
	 #+:LUCID
	 (lucid::PROCESS-WAIT "Wait Forever" #'packet-sending)
	 #+:EXCL
	 (MP:PROCESS-WAIT "Wait Forever" #'packet-sending)
	 #+:SYMBOLICS
	 (process:process-wait "Wait Forever" #'packet-sending)
	 (push t  *packet-sending*)
	   
	 (unwind-protect
	     (setf ,val 
			   (progn ,@forms))
	   (pop *packet-sending* ))
	 ,val))
    ))

;;; defcommand command-name arguments {form}*
;;; YY Protocol $@$rE83+$9$k(J
;;; $@%3%^%s%I!"L?Na$NAw=P=hM}$NGSB>@)8f(J
;;;
#+CMU
(defmacro defcommand (pn args &rest form)
  (let ((val (gentemp))
		(mask (gentemp)))
	`(defun ,pn ,args
	   (let ((,val nil)
			 (,mask (before-interrupt-stop)))
		 (setf ,val (progn ,@FORM))
		 (after-interrupt-stop ,mask)
		 ,val))))

;;; WITH-INHIBIT-SCHEDULING
;;; FORM$@$r<B9TCf!"B>$N%W%m%;%9$N<B9T$r6X;_$9$k(J
;;; 
(DEFMACRO WITH-INHIBIT-SCHEDULING (&REST FORM)
  #+LUCID
  `(LUCID::WITH-SCHEDULING-INHIBITED ,@FORM)
  #+EXCL
  `(mp::without-scheduling ,@FORM)
  #+Symbolics
  `(PROCESS::with-lock (*fd-lock*)
				  ,@FORM)
  #+CMU
  (let ((ret (gentemp))
		(mask (gentemp)))
	`(let ((,mask (before-interrupt-stop))
		   (,ret ,nil))
	   (unwind-protect
		   (setf ,ret
				 (multiple-value-list (progn ,@FORM)))
		 (prog1
		   (if (= (length ,ret) 1)
			   (car ,ret)
			 (values-list ,ret))
		   (after-interrupt-stop ,mask)))
	   ))
  #-(OR :LUCID :EXCL Symbolics CMU)
  (ERROR 
   "WITH-INHIBIT-SCHEDULING: Sorry. Your LISP implementation is not supported.")
  )

(defmacro with-region-slots ((&rest args) ob &body body)
  (let ((r-internal (gentemp)))
    `(let ((,r-internal (region-internal ,ob)))
       ,.(mapcar #'(lambda (x) (until-atom x r-internal args))
		 body))))

(defsetf re-height-acc set-re-height)

;;; with-temp-region 
;;; $@4{$K:n$i$l$?(Jregion$@$r2>$K;H$&(J
(defmacro with-temp-region ((region) &body body)
  (let ((ob (gentemp))
		(val (gentemp)))
    `(WITH-INHIBIT-SCHEDULING
      (let ((,ob (copy-seq (region-internal ,region)))
			(,val (multiple-value-list ,@body)))
		(setf (region-internal ,region) ,ob)
		(if (= (length ,val) 1)
			(car ,val)
		  (values-list ,val))))))

;;; with-temp-region-args
;;; $@4{$K:n$i$l$?(Jregion$@$r2>$K;H$&(J
(defmacro with-temp-region-args (((var) region
                                 &key (left 0) (right left) (bottom 0) 
				 (top bottom)
				 (width nil) (height nil))
				 &body body)
  (declare (inline +))
  (let ((ob (gentemp))
	(cur (gentemp))
	(val (gentemp)))
    `(WITH-INHIBIT-SCHEDULING
      (let* ((,var ,region)
	     (,cur (region-internal ,region))
	     (,ob (copy-seq ,cur))
	     (,val nil))

		(setf (car ,cur) ,left (second ,cur) ,bottom
			  (third ,cur) ,right (fourth ,cur) ,top)

		(if ,width
			(setf (third ,cur) (+ (car ,cur) ,width)))

		(if ,height
			(setf (fourth ,cur) (+ (second ,cur) ,height)))
		
		(setf ,val (multiple-value-list (progn ,@body)))
		(setf (region-internal ,region) ,ob)
		(if (= (length ,val) 1)
			(car ,val)
		  (values-list ,val))))))


;;; $@:BI8JQ49MQ%^%/%m(J
(defmacro with-translate-coordinate ((&rest vars) object height &body body)
  (eval `(nconc (list 'let
	   (mapcar #'(lambda (X) 
		       (list (car X) (list '+ (second X) 
			 (translate-coordinate ,object (second X) ,height))))
		   (quote ,vars)))
	   (quote ,body))))

;;; $@;HMQK!(J 
#|
(defun test (stream x y1 y2 y3) ;;; y1 y2 y3$@$O(JY$@:BI8(J
  (with-translate-coordinate ((y1 y1) (y2 y2) (y3 y3))
			    ($@%9%H%j!<%`$N:BI8JQ49%$%s%9%?%s%9(J)
			    $@%9%H%j!<%`$N:GBg9b$5(J
			    (print y1) (print y2) (print y3))
y1 y2 y3 $@$K$O!":BI8JQ49$5$l$?CM$,%P%$%s%I$5$l$k!#(J
|#


;;;$@%0%i%U%#%C%/%H%i%s%9%U%)!<%`%^%H%j%C%/%9$N%9%m%C%HCM$rF@$k%^%/%m(J
(defmacro with-matrix-destructured (((theta x-time y-time) matrix) 
				    &rest body)
  `(let ((,theta (matrix-theta ,matrix)) (,x-time (matrix-x-time ,matrix))
	 (,y-time (matrix-y-time ,matrix)))
     ,@body))

;;;; $@%0%i%U%#%/%9%H%i%s%9%U%)!<%`$r9MN8$KF~$l$?%^%/%m(J
(defmacro with-transform-xy (((new-x new-y) stream x y)
                                       &rest body)
  `(let ((,new-x 0)
		 (,new-y 0))
     (multiple-value-setq (,new-x ,new-y)
       (transform-by-matrix-xy ,x ,y (stream-transform-by-matrix ,stream)))
     (setf ,new-y (round ,new-y)
		   ,new-x (round ,new-x))
     ,@body))



;;;; $@:BI8JQ49$H%0%i%U%#%/%9%H%i%s%9%U%)!<%`$r9MN8$KF~$l$?%^%/%m(J
(defmacro with-translate-transform (((new-pos) stream position) &rest body)
  `(let ((,new-pos (translate-coordinate 
		    (slot-value ,stream 'translate-coordinate)
		    (transform-by-matrix ,position
				 (stream-transform-by-matrix ,stream)
				 :return :position)
		    (world-height ,stream))))
     ,@body))


(defmacro with-translate-transform-xy (((new-x new-y) stream x y)
                                       &rest body)
  `(let ((,new-x 0)
	 (,new-y 0))
     (multiple-value-setq (,new-x ,new-y)
       (transform-by-matrix-xy ,x ,y (stream-transform-by-matrix ,stream)))
     (setf ,new-y (translate-coordinate-y 
		   (stream-translate-coordinate ,stream)
		   (round ,new-y) (world-height ,stream))
	   ,new-x (round ,new-x))
     ,@body))

#|
  (let ((old-pos (gentemp)))
  `(let* ((,old-pos  (transform-by-matrix-xy ,x ,y
                        (stream-transform-by-matrix ,stream)
                        :return T))
          (,new-y (translate-coordinate-y
                   (stream-translate-coordinate ,stream)
                   (round (second ,old-pos)) (world-height ,stream)))
          (,new-x (round (first ,old-pos))))
     ,@body)))

|#

;;; $@:BI8JQ49MQ%^%/%m(J
;;; 27.Aug.90 yohta height, yy -> gentemp
(defmacro with-translate-coordinate-stream (Y stream)
  (let ((height (gentemp)) (yy (gentemp)))
  `(let* ((,height (if ,stream
                      (world-height ,stream)
                    0))
          (,yy (if ,stream
                (translate-coordinate-y
                        (stream-translate-coordinate ,stream) ,Y ,height)
                ,Y)))
     ,yy)))

		     
;;; $@2sE>9TNsJQ49%^%/%m(J
(defmacro with-transform-stream (pos stream)
  `(transform-by-matrix ,pos (stream-transform-by-matrix ,stream) :position))


;;; lisp$@%*%V%8%'%/%H$rH<$C$?%F%j%H%j$N@8@.(J
(defmacro  with-object-make-territory (object &key
                                       (x 0) (y 0) (width 0) (height 0)
                                       (parent -1) (visible T)
									   (drawable T)
									   (window-mode T) (fence NIL) 
									   (transparent nil))
  (let ((territory (gentemp)))
    `(let ((,territory (make-territory
                        :x ,x :y ,y :width ,width :height ,height
                        :parent ,parent :visible ,visible
						:window-mode ,window-mode
						:fence ,fence
						:transparent ,transparent
                        :drawable ,drawable)))
       (set-territory-object ,territory ,object)

       ,territory)))


;;; lisp$@%*%V%8%'%/%H$rH<$C$?%F%j%H%j$N@8@.(J
;;; lisp$@%*%V%8%'%/%H$rH<$C$?%F%j%H%j$N@8@.(J
;;; 27.Aug.90 yohta territory -> gentemp
(defmacro  with-object-make-region-territory (object region
                               &key (parent -1) (visible T) (drawable T)
			       (fence NIL)
			       (transparent nil)
			       (window-mode T))
  (let ((territory (gentemp)))
    `(let ((,territory (make-territory
                        :x (region-left ,region)
                        :y (region-bottom ,region)
                        :width (region-width ,region)
                        :height (region-height ,region)
			:window-mode ,window-mode
			:transparent ,transparent
			:fence ,fence
                        :parent ,parent :visible ,visible :drawable ,drawable)))
       (set-territory-object ,territory ,object)

       ,territory)))


(defvar *packet-sending* nil)


;;; YY$@$N;~4V7WB,MQ%^%/%m(J
(defmacro yy-time (form)
  `(let ((*trace-output* (make-string-output-stream))
         (ret nil))
     (setf ret (time ,form))
     (format t "function ~a time: ~a~%" (car (quote ,form))
             (read-from-string (subseq (get-output-stream-string *trace-output*)
                                                      20)))
     ret)
     )

#|
;;; C_STRORE$@$N%j%9%W4X?t(J
(defmacro c_store (string no1 no2)
  `(cc_store ,string ,no1 ,no2))

;;; C_ACCESS $@$N%j%9%W4X?t(J
(defmacro c_access (string no)
  `(cc_access ,string ,no))

;;; C_STORE2$@$N%j%9%W4X?t(J
(defmacro c_store2 (string no1 no2)
  `(cc_store2 ,string ,no1 ,no2))

|#

#+SYMBOLICS
;;; c_access$@$NHFJQ?t$rDj5A$9$k(J
(defsetf c_access c_store)


;;; with-slots $@$N(Jgraphic-state $@HG(J
(defmacro with-graphic-state-slots ((&rest args) ob &body body)
  (let ((internal (gentemp)))
    `(let ((,internal (state-slots ,ob)))
       ,.(mapcar #'(lambda (x) (until-atom-state x internal args))
		 body))))
		 

;;; $@%0%i%U%#%/%9$N>uBV$rJQ99$9$k%^%/%m(J
;;; $@%^%/%m$J$$$G!"%m!<%+%k$KJQ99$5$l$k(J
(defmacro with-graphic-state ((&rest vars) ins &rest body)
  (let ((internal (gentemp))
	(old (gentemp))
	(val (gentemp)))
    `(let* ((,internal (state-slots ,ins))
	    (,old (copy-seq ,internal))
	    (,val nil))
       (unwind-protect
	   (setf ,val 
	     (multiple-value-list (progn 
		 ,.(mapcar #'(lambda (x) (until-atom-state x internal vars))
			   body))
	       ))
	 (progn 
	   (setf (state-slots ,ins) ,old)
	   (if (= (length ,val) 1)
		   (car ,val)
		 (values-list ,val))))
       )))
	 
#|
  (let ((val (gentemp))
	(v1 (gentemp))
        (v2 (gentemp))
        (v3 (gentemp))
        (v4 (gentemp))
        (v5 (gentemp))
        (v6 (gentemp))
        (v7 (gentemp))
        (v8 (gentemp))
        (v9 (gentemp))
        (v10 (gentemp)))
    `(with-slots 
      (operation color line-width line-edge joint-type filled-pattern
       line-dashing arc-mode filled-type default-color-pattern) ,ins
      (let ((,v1 operation)
	    (,v2 color)
	    (,v3 line-width)
	    (,v4 line-edge)
	    (,v5 joint-type)
	    (,v6 filled-pattern)
	    (,v7 line-dashing)
	    (,v8 arc-mode)
	    (,v9 filled-type)
	    (,v10 default-color-pattern)
	    (,val nil))

	(unwind-protect
	    (with-accessors ,vars ,ins (setf ,val
					(multiple-value-list (progn ,@body))))

       ;;; $@85$KLa$9(J
       (setf operation ,v1 color ,v2 line-width ,v3 line-edge ,v4
	     joint-type ,v5 filled-pattern ,v6 line-dashing ,v7
	     arc-mode ,v8 filled-type ,v9 default-color-pattern ,v10))
       (values-list ,val)))))

  (let ((v1 (gentemp))
	(v2 (gentemp))
	(v3 (gentemp))
	(v4 (gentemp))
	(v5 (gentemp))
	(v6 (gentemp))
	(v7 (gentemp))
	(v8 (gentemp))
	(v9 (gentemp))
	(v10 (gentemp))
	(vvv (gentemp))
	(v11 (gentemp)))
    `(let ((,v1 (graphic-operation ,ins))
	   (,v2 (graphic-color ,ins))
	   (,v3 (line-width ,ins))
	   (,v4 (line-edge ,ins))
	   (,v5 (line-joint-type ,ins))
	   (,v6 (line-dashing ,ins))
	   (,v7 (arc-mode ,ins))
	   (,v8 (filled-type ,ins))
	   (,v9 (filled-rule ,ins))
	   (,v10 (filled-pattern ,ins))
	   (,v11 (stream-default-color-pattern ,ins))
	   (,vvv nil))

       ;;; CLOS $@%^%/%m(J
       (unwind-protect
	   (with-accessors ,vars ,ins (setf ,vvv 
					(multiple-value-list (progn ,@body))))

       ;;; $@85$KLa$9(J
       (setf (graphic-operation ,ins) ,v1
	     (graphic-color ,ins) ,v2
	     (line-width ,ins) ,v3
	     (line-edge ,ins) ,v4
	     (line-joint-type ,ins) ,v5
	     (line-dashing ,ins) ,v6
	     (arc-mode ,ins) ,v7
	     (filled-type ,ins) ,v8
	     (filled-rule ,ins) ,v9
	     (filled-pattern ,ins) ,v10
	     (stream-default-color-pattern ,ins) ,v11))
       (values-list ,vvv))))
|#

;;; $@%F%-%9%H%3%s%H%m!<%k$N>uBV$rJQ49$9$k%^%/%m(J
;;; $@%^%/%m$J$$$G!"%m!<%+%k$KJQ99$5$l$k(J
(defmacro with-text-control (vars ins &rest body)
  (let ((v1 (gentemp))
	(v2 (gentemp))
	(v3 (gentemp))
	(v4 (gentemp))
	(v5 (gentemp))
	(v6 (gentemp))
	(v7 (gentemp))
	(vvv (gentemp)))
    `(let ((,v1 (stream-left-margin ,ins))
	   (,v2 (stream-right-margin ,ins))
	   (,v3 (stream-top-margin ,ins))
	   (,v4 (stream-bottom-margin ,ins))
	   (,v5 (stream-font ,ins))
	   (,v6 (slot-value ,ins 'line-feed))
	   (,v7 (stream-output-direction ,ins))
	   (,vvv nil))
        ;;; CLOS $@%^%/%m(J
       (unwind-protect 
	   (with-accessors ,vars ,ins (setf ,vvv 
					(multiple-value-list (progn  ,@body))))

       ;;; $@85$KLa$9(J
       (setf (stream-left-margin ,ins) ,v1
	     (stream-right-margin ,ins) ,v2
	     (stream-top-margin ,ins) ,v3
	     (stream-bottom-margin ,ins) ,v4
	     (stream-font ,ins) ,v5
 	     (slot-value ,ins 'line-feed) ,v6
	     (stream-output-direction ,ins) ,v7))
       (values-list ,vvv))))

;;; $@%0%i%U%#%C%/%9%^%H%j%/%9$NJQ99%a%=%C%I(J
;;; $@%^%/%m$J$$$G!"%m!<%+%k$KJQ99$5$l$k(J
(defmacro with-graphic-matrix (vars ins &rest body)
  (let ((v1 (gentemp))
		(v2 (gentemp))
		(v3 (gentemp))
		(matrix (gentemp))
		(old-m (gentemp))
		(flg (gentemp))
		(vvv (gentemp)))
    `(let* ((,matrix (stream-transform-by-matrix ,ins))
			(,old-m ,matrix)
			(,v1 (matrix-theta ,matrix))
			(,v2 (matrix-x-time ,matrix))
			(,v3 (matrix-y-time ,matrix))
			(,vvv nil)
			(,flg nil))

       ;;;Matrix $@$,Hs<B9T$N>l9g(J
       (if (eq 'graphic-transform-matrix-non
	       (class-name (class-of ,matrix)))
	   (setf ,flg T
		 (stream-transform-by-matrix ,ins)
		 (make-transform-matrix)
		 ,matrix (stream-transform-by-matrix ,ins)))

        ;;; CLOS $@%^%/%m(J
       (unwind-protect
		   (with-accessors ,vars ,matrix
						   (setf ,vvv (multiple-value-list (progn  ,@body))))

       ;;; $@85$KLa$9(J
       (if ,flg
		   (setf (stream-transform-by-matrix ,ins) ,old-m)
		 (setf (matrix-theta ,matrix) ,v1
			   (matrix-x-time ,matrix) ,v2
			   (matrix-y-time ,matrix) ,v3)))
	   (if (= (length ,vvv) 1)
		   (car ,vvv)
		 (values-list ,vvv)))))

;;; $@%0%i%U%#%C%/%9%^%H%j%C%/%9$r$+$1$J$$(J
(defmacro with-non-graphic-matrix (stream &rest body)
  (declare (special *non-graphic-transform-matrix*))
  (let ((old (gentemp))
	(ret (gentemp)))
    `(let ((,old (stream-transform-by-matrix ,stream))
	   (,ret nil))
       (setf (slot-value ,stream 'transform-by-matrix) 
	 *non-graphic-transform-matrix*)
       (setf ,ret (multiple-value-list (progn  ,@body)))
       (setf (slot-value ,stream 'transform-by-matrix) ,old)
       (values-list ,ret))))


;;; $@%^%&%9$r%0%i%V$9$k%^%/%m(J
;;; $@%^%&%9%+!<%=%k$O(JNIL$@$G$bNI$$(J
(defmacro with-mouse-grabbed (mouse-cursor &rest body)
  (declare (special *SYSTEM-MOUSE-CURSOR*))
  (let ((vvv (gentemp)))
    `(WITH-INHIBIT-SCHEDULING
      (let ((mouse *SYSTEM-MOUSE-CURSOR*)
	    (,vvv nil))
      (if ,mouse-cursor
         (change-mouse-cursor ,mouse-cursor))
	 (yy-protocol-74 2)
	 (setf ,vvv (progn ,@body))
	 (yy-protocol-74 1)
	 (setf *SYSTEM-MOUSE-CURSOR* mouse)
	 ,vvv))))


;;;
;;; Defgeneric for YY
;;; Becasue PCL is not supported :Mthod option yet.
;;;
;#+PCL
;(eval-when (eval load compile)

#+PCL
(shadow 'defgeneric (find-package 'yy))

#+PCL
(defmacro yy::defgeneric (function-specifier lambda-list &body options)
  (expand-defgeneric-for-yy function-specifier lambda-list options))

;;; $@%$%Y%s%H$N%Q%1%C%H$r$^$H$a$?9=B$BN(J
(defstruct event-packet
  data            ;;; $@%=%1%C%H%9%H%j!<%`$+$i$N%G!<%?$,F~$k(J
  max-byte        ;;; $@%=%1%C%H%9%H%j!<%`$NF~NO%P%$%H?t(J
  item            ;;; $@%Q%1%C%H$N9=B$(J  ($@%3%^%s%IHV9f(J $@%Q%1%C%HD9(J $@%Q%1%C%H<oJL(J)
  number          ;;; $@%Q%1%C%H?t(J
  current         ;;; $@8=:_%"%/%;%9$7$F$$$k%Q%1%C%H(J
)

;;; with-real-object 
;;; with-real-object (draw-piece) form
;;; $@%F%j%H%j!<$N@)8f%a%=%C%I(J
;;; draw-piece$@$K$*$1$k%j!<%8%g%s$N%9%m%C%H$rJQ99$9$k(J
;;; $@>l9g$O!"I,$:2<5-$N%^%/%m$rMxMQ$9$k$3$H(J
;;  $@$b$7$=$&$G$J$1$l$P!"<B:]$N%*%V%8%'%/%H$NJQ99$O5/$3$i$J$$!#(J
(defmacro with-real-object ((draw-piece) &body body)
  (let ((ret (gentemp))
	(ob (gentemp)))
    `(let ((,ret (multiple-value-list (progn ,@body)))
	   (,ob (region-internal ,draw-piece)))
       (yy-protocol-4 (territory ,draw-piece)
		       (car ,ob)
		       (second ,ob)
		       (re-width-acc ,ob)
		       (re-height-acc ,ob)
		      0 0)
	   (if (= (length ,ret) 1)
		   (car ,ret)
		 (values-list ,ret)))))


;;; with-event-object
;;; with-event-object (draw-piece) form
;;; draw-piece$@$K$*$1$k%^%&%9%a%=%C%I$rDI2C$7$?$$>l9g$O(J
;;; $@I,$:$3$N%^%/%m$rMxMQ$9$k(J
(defmacro with-event-object ((draw-piece) &body body)
  (let ((ret (gentemp)))
    `(let ((,ret (multiple-value-list (progn ,@body))))
       (yy-protocol-72 (territory ,draw-piece) 
		       (slot-value ,draw-piece 'event-mask))
	   (if (= (length ,ret) 1)
		   (car ,ret)
		 (values-list ,ret)))))

;;; $@;XDj$5$l$?%P%$%H$r<h$j=P$9(J
;;; #x00000000  <- fixnum
;;;    3 2 1 0  <- no
(defmacro get-one-byte (num no)
  `(ldb (byte 8 (* ,no 8)) ,num))


;;; End of macros.lisp