;;; -*- Mode: LISP; Syntax: Common-lisp; Package: YY; Base: 10 -*-
;;; եΥƥȥɥμ¹Խ
;;; graphic-test-exec.lisp
;;;
;;;  Copyright (C) 1989,1990,1991 Aoyama Gakuin University
;;;
;;;	      All Rights Reserved
;;;
;;; This software is developed for the YY project of Aoyama Gakuin University.
;;; Permission to use, copy, modify, and distribute this software
;; and its documentation for any purpose and without fee is hereby granted,
;;; provided that the above copyright notices appear in all copies and that
;;; both that copyright notice and this permission notice appear in 
;;; supporting documentation, and that the name of Aoyama Gakuin
;;; not be used in advertising or publicity pertaining to distribution of
;;; the software without specific, written prior permission.
;;;
;;; This software is made available AS IS, and Aoyama Gakuin makes no
;;; warranty about the software, its performance or its conformity to
;;; any specification. 
;;;
;;; To make a contact: Send E-mail to ida@csrl.aoyama.ac.jp for overall
;;; issues. To ask specific questions, send to the individual authors at
;;; csrl.aoyama.ac.jp. To request a mailing list, send E-mail to 
;;; yyonx-request@csrl.aoyama.ac.jp.
;;;
;;; Authors:
;;;   version 1.3 91/12/04 by t.kosaka
;;;
(in-package :yy)

;;; ݥȥꥹȤɸѴꥹȤ
(defun make-point-list-by-transform (window point-list)
  (declare (optimize (compilation-speed 0) (speed 3) (safety 0)))
  (let ((first nil))
	(mapcan #'(lambda (x)
				(if first
					(let ((xx 0)
						  (yy 0))
					  (with-transform-xy 
					   ((new-x new-y) window first x)
					   (setf first nil
							 xx new-x 
							 yy new-y))
					   (list xx yy))
				  (setf first x)))
				point-list)))

;;; ȥ꡼Υեåξ֤ꥹȤˤ
(defun make-graphic-state-list (window)
  (declare (optimize (compilation-speed 0) (speed 3) (safety 0)))
  (with-graphic-state
   ((lw line-width)
	(le line-edge) (jt joint-type) (ld line-dashing)
	(am arc-mode) (ft filled-type) (fp filled-pattern)
	(dc default-color-pattern) (fr filled-rule)	(sc stream-clockwize))
   window
   (list lw le jt ld am ft dc fr fp sc)))


;;; 
;;; event-x event-yϡɥΰ
(defmethod point-selection ((ob line-object) event-x event-y)
  (declare (optimize (compilation-speed 0) (speed 3) (safety 0)))
  (with-slots 
   (points-list (current current-graphic-state)) ob
   (point-line-selection points-list
						 (draw-line-width current) event-x event-y)))

;;; ɽ
;;; Ⱥɽ
(defmethod mark-drawobject ((ob line-object) operation &optional (color nil))
  (declare (optimize (compilation-speed 0) (speed 3) (safety 0)))
  (let ((parent (draw-stream ob)))
	(with-non-graphic-matrix 
	 parent
	 (with-slots 
	  (current-color (pl points-list) (current current-graphic-state)) ob
	  (with-graphic-state-for-draw 
	   parent current 
	   (if color
		   current-color
		   (selection-color parent)) operation
	   (draw-line-xy parent (car pl) (second pl) (third pl) (fourth pl))
	   )))))

;;; ֤
(defmethod start-point ((ob line-object))
  (declare (optimize (compilation-speed 0) (speed 3) (safety 0)))
  (with-slots 
   (points-list) ob
   (values (car points-list) (second points-list))))


;;; ƥȴؿ
(defun test-POINT-LINE-SELECTION ()
  (let ((lis (list '((0 0 -50 -50) 5 -25 -25) ;;; t
				   '((0 0 40 40) 5 20 20)  ;;; t
				   '((0 0 -40 -40) 5 -20 -20)
				   '((10 40 40 10) 5 20 30)
				   '((10 40 40 10) 5 20 30)
				   '((0 50 50 0) 5 30 30)
				   '((0 0 50 50) 5 30 30)
				   '((0 50 50 0) 5 25 25)
				   '((0 0 100 100) 5 50 50)
				   '((10 -10 10 50) 5 10 0)
				   '((10 -10 10 50) 5 10 -11) ;;; nil
				   '((10 -10 10 50) 5 10 -20) ;;; nil
				   '((10 10 50 10) 5 5 10)
   				   '((10 10 50 10) 5 5 60))))
	(dolist (item lis)
			(format t "~a ~a~%" item 
					(apply #'point-line-selection item)))))

;;; ߤ
(defmethod point-selection ((ob circle-object) event-x event-y)
  (declare (optimize (compilation-speed 0) (speed 3) (safety 0)))
  (with-slots
   (center-x center-y hankei (current current-graphic-state)) ob
   (point-circle-selection center-x center-y hankei 
						   (draw-line-width current)
						   (draw-fill-mode current)
						   event-x event-y)))

;;; ߤɽ
(defmethod mark-drawobject ((ob circle-object) operation &optional (color nil))
  (declare (optimize (compilation-speed 0) (speed 3) (safety 0)))
  (let ((parent (draw-stream ob)))
	(with-non-graphic-matrix 
	 parent
	 (with-slots 
	  (center-x center-y hankei current-color
	   (current current-graphic-state)) ob
	  (with-graphic-state-for-draw 
	   parent current 
	   (if color
		   current-color
		   (selection-color parent)) operation
	   (draw-circle-xy parent center-x center-y hankei)
	   )))
	))

;;; ߤȱ߸̤ΰưɽ
;;; ɽXORǾäƿ֤Ǻɽ
;;; οɽƤ뤳ȤݾڤƤ
(defmethod move-drawobject ((ob circle-object) new-x new-y)
  (declare (special *GXOR*)
		   (optimize (compilation-speed 0) (speed 3) (safety 0)))
  (mark-drawobject ob *GXOR* T)
  (with-slots 
   (center-x center-y) ob
   (setf center-x new-x
		 center-y new-y)
   (mark-drawobject ob *GXOR* T)
   ))

#|
;;; ưȤν
(defmethod moved-drawobject ((object circle-object))
  (let ((stream (draw-stream object)))
	(with-slots 
	 (center-x center-y) object
	 (with-transform-xy
	  ((nnx nny) stream center-x center-y)
	   (setf center-x nnx center-y nny))
	)))

|#

;;; ֤
(defmethod start-point ((ob circle-object))
  (declare (optimize (compilation-speed 0) (speed 3) (safety 0)))
  (with-slots 
   (center-x center-y) ob
   (values center-x center-y)))

;;; ߤθؿ
(defun point-circle-selection (center-x center-y hankei line-width fill-mode
										event-x event-y)
  (declare (optimize (compilation-speed 0) (speed 3) (safety 0)))
   (let* ((max-hankei (+ hankei
						 (float (/ line-width 2))))
		  (min-hankei (- hankei
						 (float (/ line-width 2))))
		  (kyori (sqrt
				  (+ (* (- center-x event-x)
						(- center-x event-x))
					 (* (- center-y event-y)
						(- center-y event-y))))))

   (if (eq *Fillednon* fill-mode)
	   (if (and (<= min-hankei kyori)
				(>= max-hankei kyori))
		   T
		 nil)
	 (if (>= hankei kyori)
		 T
	   nil))
   ))


;;; ߸̤
(defmethod point-selection ((ob arc-object) event-x event-y)
  (declare (optimize (compilation-speed 0) (speed 3) (safety 0)))
  (with-slots
   (center-x center-y hankei start-angle end-angle 
			 (current current-graphic-state)) ob
   (if (point-circle-selection center-x center-y hankei 
							   (draw-line-width current)
							   (draw-fill-mode current)
							   event-x event-y)
	   (if (arc-point-selection center-x center-y 
								start-angle end-angle 
								event-x event-y (draw-clockwise current))
		   T
		 nil)
	 nil)
   ))
		
;;; ߸ɽ
(defmethod mark-drawobject ((ob arc-object) operation &optional (color nil))
  (declare (optimize (compilation-speed 0) (speed 3) (safety 0)))
  (let ((parent (draw-stream ob)))
	(with-non-graphic-matrix 
	 parent
	 (with-slots 
	  (center-x center-y hankei start-angle end-angle current-color
	   (current current-graphic-state)) ob
	   (with-graphic-state-for-draw 
		parent current 
		(if color
			current-color
			(selection-color parent)) operation
		(draw-circle-xy parent center-x center-y hankei 
						:start-angle start-angle :end-angle end-angle)
		)))
	))

;;; ̤ޤϡ𷿤
(defun arc-point-selection (center-x center-y start-angle end-angle
									 event-x event-y clockwize)
  (declare (optimize (compilation-speed 0) (speed 3) (safety 0)))
  (let* ((new-x (- event-x center-x))
		 (new-y (- event-y center-y))
		 (new-end-angle end-angle)
		 (kakudo (angle-from-axsis-top new-x new-y)))

     ;;; ٤Ĵ
	(if (> start-angle end-angle)
		(setf end-angle (+ (* 2 pi) end-angle)))

	(if (eq clockwize :counter-clockwize)
		(if (or (and (>= kakudo start-angle)
					 (>= end-angle kakudo))
				(and (<= kakudo start-angle)
					 (<= kakudo end-angle)
					 (> start-angle new-end-angle)
					 (<= kakudo new-end-angle)))
			T
		  nil)
	  (if (or (and (<= kakudo start-angle)
				   (<= end-angle kakudo))
			  (and (>= kakudo start-angle)
				   (>= kakudo end-angle)
				   (<= kakudo new-end-angle)))
				   
		  T
		nil)
	)))


;;; ޤ
(defmethod point-selection ((ob polyline-object) event-x event-y)
  (declare (optimize (compilation-speed 0) (speed 3) (safety 0)))
  (with-slots 
   (point-pair-list (current current-graphic-state)) ob
   (let ((ret-flg nil)
		 (line-width (draw-line-width current)))
	 (dolist (item point-pair-list)
			 (when (point-line-selection item line-width event-x event-y)
				   (setf ret-flg T)
				   (return)))
	 ret-flg)))

;;; ޤɽ
(defmethod mark-drawobject ((ob polyline-object) 
							operation &optional (color nil))
  (declare (optimize (compilation-speed 0) (speed 3) (safety 0)))
  (let ((parent (draw-stream ob)))
	(with-non-graphic-matrix 
	 parent
	 (with-slots 
	  (current-color points-list (current current-graphic-state)) ob
	   (with-graphic-state-for-draw 
		parent current 
		(if color
			current-color
			(selection-color parent)) operation
		(apply #'draw-polyline-xy parent points-list)
		)))
	))


;;; ޤΰưɽ
;;; ɽXORǾäƿ֤Ǻɽ
;;; οɽƤ뤳ȤݾڤƤ
(defmethod move-drawobject ((ob polyline-object) new-x new-y)
  (declare (special *GXOR*)
		   (optimize (compilation-speed 0) (speed 3) (safety 0)))
  (mark-drawobject ob *GXOR* T)

  (with-slots 
   (points-list) ob
   (let ((sa-x (- new-x (car points-list)))
		 (sa-y (- new-y (second points-list))))
	 (setf (car points-list) new-x
		   (second points-list) new-y)
	 
	 (do ((p-list (cddr points-list) (cddr p-list)))
		 ((null p-list))
		 (incf (car p-list) sa-x)
		 (incf (second p-list) sa-y))))
   (mark-drawobject ob *GXOR* T)
   )

#|
;;; ޤΰưν
(defmethod moved-drawobject ((object polyline-object))
  (let ((stream (draw-stream object)))
	(with-slots 
	 (points-list point-pair-list) object
	 
	 (setf points-list (make-point-list-by-transform stream points-list)
		   point-pair-list (make-polyline-points-list points-list)))
	))
|#

;;; ޤΰưν
(defmethod moved-drawobject ((object polyline-object))
  (declare (optimize (compilation-speed 0) (speed 3) (safety 0)))
  (with-slots 
   (points-list point-pair-list) object
   (setf point-pair-list (make-polyline-points-list points-list)))
   )

;;; ֤
(defmethod start-point ((ob polyline-object))
  (declare (optimize (compilation-speed 0) (speed 3) (safety 0)))
  (with-slots 
   (points-list) ob
   (values (car points-list) (second points-list))))

;;; ¿ѷ
(defmethod point-selection ((ob polygon-object) event-x event-y)
  (declare (optimize (compilation-speed 0) (speed 3) (safety 0)))
  (with-slots 
   (points-list (current current-graphic-state) senbun-list) ob
   (if (eq *Fillednon* (draw-fill-mode current))
	   (let ((line-width (draw-line-width current)))
		 (dolist (item senbun-list)
				 (with-slots 
				  (x1 y1 x2 y2) item
				  (if (point-line-selection 
					   (list x1 y1 x2 y2) line-width event-x event-y)
					  (return T)))
				 ))
	 ;;; ɤĤ֤⡼
	 (let ((setten 0))
	   (dolist (item senbun-list)
			   (if (lien-upper-pointp item event-x event-y)
				   (if (line-point-interp item event-x event-y)
					   (incf setten)))
			   )
	   (if (oddp setten)
		   T
		 nil))
	 )))

;;; ¿ѷɽ
(defmethod mark-drawobject ((ob polygon-object) 
							operation &optional (color nil))
  (declare (optimize (compilation-speed 0) (speed 3) (safety 0)))
  (let ((parent (draw-stream ob)))
	(with-non-graphic-matrix 
	 parent
	 (with-slots 
	  (points-list current-color (current current-graphic-state)) ob
	   (with-graphic-state-for-draw 
		parent current 
		(if color
			current-color
		  (selection-color parent)) operation
		(apply #'draw-polygon-xy parent points-list)
		)))
	))


;;; ¿ѷΰưɽ
;;; ɽXORǾäƿ֤Ǻɽ
;;; οɽƤ뤳ȤݾڤƤ
(defmethod move-drawobject ((ob polygon-object) new-x new-y)
  (declare (special *GXOR*)
		   (optimize (compilation-speed 0) (speed 3) (safety 0)))
  (mark-drawobject ob *GXOR* T)

  (with-slots 
   (points-list) ob
   (let ((sa-x (- new-x (car points-list)))
		 (sa-y (- new-y (second points-list))))
	 (setf (car points-list) new-x
		   (second points-list) new-y)
	 
	 (do ((p-list (cddr points-list) (cddr p-list)))
		 ((null p-list))
		 (incf (car p-list) sa-x)
		 (incf (second p-list) sa-y))))
   (mark-drawobject ob *GXOR* T)
   )

#|
;;; ¿ѷΰưν
(defmethod moved-drawobject ((object polygon-object))
  (let ((stream (draw-stream object)))
	(with-slots 
	 (senbun-list points-list) object
	 (setf points-list (make-point-list-by-transform stream points-list)
		   senbun-list (make-polygon-senbun-list points-list))
	 )))
|#

;;; ¿ѷΰưν
(defmethod moved-drawobject ((object polygon-object))
  (declare (optimize (compilation-speed 0) (speed 3) (safety 0)))
  (with-slots 
   (senbun-list points-list) object
   (setf senbun-list (make-polygon-senbun-list points-list))
   ))

;;; ֤
(defmethod start-point ((ob polygon-object))
  (declare (optimize (compilation-speed 0) (speed 3) (safety 0)))
  (with-slots 
   (points-list) ob
   (values (car points-list) (second points-list))))

;;; 
(defmethod point-selection ((ob region-object) event-x event-y)
  (declare (optimize (compilation-speed 0) (speed 3) (safety 0)))
  (with-slots 
   (points-list (current current-graphic-state)) ob
   (let* ((left (car points-list))
		  (bottom (second points-list))
		  (right (+ left (third points-list)))
		  (top (+ bottom (fourth points-list)))
		  (line-width (float (/ (draw-line-width current) 2))))

	 (if (eq (draw-fill-mode current) *Fillednon*)
		 (if (and (>= event-x left)
				  (>= right event-x)
				  (>= event-y bottom)
				  (>= top event-y))
			 (cond
			  ((and (>= event-x left)
					(>= (+ left line-width) event-x))
			   T)
			  ((and (>= event-x (- right line-width))
					(>= right event-x))
			   T)
			  ((and (>= event-y bottom)
					(>= (+ bottom line-width) event-y))
			   T)
			  ((and (>= event-y (- top line-width))
					(>= top event-y))
			   T)
			  (T
			   nil)))
	   (if (and (>= event-x left)
				(>= right event-x)
				(>= event-y bottom)
				(>= top event-y))
		   T
		 NIL)
	   )
	 )))


;;; ֤
(defmethod start-point ((ob region-object))
  (declare (optimize (compilation-speed 0) (speed 3) (safety 0)))
  (with-slots 
   (points-list) ob
   (values (car points-list) (second points-list))))

;;; ɽ
(defmethod mark-drawobject ((ob region-object) operation &optional (color nil))
  (declare (optimize (compilation-speed 0) (speed 3) (safety 0)))
  (let ((parent (draw-stream ob)))
	(with-non-graphic-matrix 
	 parent
	 (with-slots
	  (points-list current-color (current current-graphic-state)) ob
	  (with-graphic-state-for-draw 
	   parent current 
	   (if color 
		   current-color
		 (selection-color parent)) operation
	   (draw-region-xy parent (car points-list)
					   (second points-list)
					   (third points-list)
					   (fourth points-list))
		)))
	))

;;; ưɽ
;;; ɽXORǾäƿ֤Ǻɽ
;;; οɽƤ뤳ȤݾڤƤ
(defmethod move-drawobject ((ob region-object) new-x new-y)
  (declare (special *GXOR*)
		   (optimize (compilation-speed 0) (speed 3) (safety 0)))
  (mark-drawobject ob *GXOR* T)

  (with-slots 
   (points-list) ob
   (setf (car points-list) new-x
		 (second points-list) new-y))

   (mark-drawobject ob *GXOR* T)
   )

#|
;;; ΰưν
(defmethod moved-drawobject ((object region-object))
  (declare (optimize (compilation-speed 0) (speed 3) (safety 0)))
  (let ((stream (draw-stream object)))
	(with-slots 
	 (points-list) object
	 (with-transform-xy
	  ((nx ny) stream (car points-list) (second points-list))
	  (setf (car points-list) nx
			(second points-list) ny)
	  ))))
|#

;;; ʱߤ
(defmethod point-selection ((ob ellipse-object) event-x event-y)
  (declare (optimize (compilation-speed 0) (speed 3) (safety 0)))
  (with-slots 
   (center-x center-y x-hankei y-hankei (current current-graphic-state)) ob
   (point-ellipse-selection center-x center-y 
							x-hankei y-hankei 
							(draw-line-width current)
							(draw-fill-mode current)
							event-x event-y)))

;;; ʱߤɽ
(defmethod mark-drawobject ((ob ellipse-object) 
							operation &optional (color nil))
  (declare (optimize (compilation-speed 0) (speed 3) (safety 0)))
  (let ((parent (draw-stream ob)))
	(with-non-graphic-matrix 
	 parent
	 (with-slots 
	  (center-x center-y x-hankei y-hankei current-color
	  (current current-graphic-state)) ob
	   (with-graphic-state-for-draw 
		parent current 
		(if color 
			current-color
		  (selection-color parent)) operation
		(draw-ellipse-xy parent center-x center-y x-hankei y-hankei)
		)))
	))



;;; ʱߤʱ߸̤ΰưɽ
;;; ɽXORǾäƿ֤Ǻɽ
;;; οɽƤ뤳ȤݾڤƤ
(defmethod move-drawobject ((ob ellipse-object) new-x new-y)
  (declare (special *GXOR*)
		   (optimize (compilation-speed 0) (speed 3) (safety 0)))
  (mark-drawobject ob *GXOR* T)
  (with-slots 
   (center-x center-y) ob
   (setf center-x new-x
		 center-y new-y)
   (mark-drawobject ob *GXOR* T)
   ))

#|
;;; ʱߡʱ߸̤ΰưν
(defmethod moved-drawobject ((object ellipse-object))
  (declare (optimize (compilation-speed 0) (speed 3) (safety 0)))
  (let ((stream (draw-stream object)))
	(with-slots 
	 (center-x center-y) object
	 (with-transform-xy
	  ((nx ny) stream center-x center-y)
	  (setf center-x nx
			center-y ny)
	  ))))
|#

;;; ֤
(defmethod start-point ((ob ellipse-object))
  (declare (optimize (compilation-speed 0) (speed 3) (safety 0)))
  (with-slots 
   (center-x center-y) ob
   (values center-x center-y)))


;;; ʱߤθؿ
(defun point-ellipse-selection (center-x center-y x-hankei y-hankei
										 line-width fill-mode
										 event-x event-y)
  (declare (optimize (compilation-speed 0) (speed 3) (safety 0)))
   (let* ((dx (- event-x center-x))
		  (dy (- event-y center-y))
		  (dis (sqrt (+ (* dx dx) (* dy dy))))
		  (rr (/ (* x-hankei y-hankei dis) 
				 (sqrt (+ (* y-hankei y-hankei dx dx)
						  (* x-hankei x-hankei dy dy)))))
		  (new-width (/ line-width 2)))

	 (if (eq *Fillednon* fill-mode)
	   (if (and (<= (- rr new-width) dis)
				(>= (+ rr new-width) dis))
		   T
		 nil)
	 (if (>= rr dis)
		 T
	   nil))
   ))

;;; ellipse-arc-objectɽ᥽å
(defmethod print-object ((ob ellipse-arc-object) stream)
  (declare (optimize (compilation-speed 0) (speed 3) (safety 0)))
  (with-slots 
   (center-x center-y x-hankei y-hankei	start-angle end-angle) ob
   (format stream "~a ~a Radius-X: ~a Radius-Y: ~a start: ~a end: ~a ~%"
		   center-x center-y x-hankei y-hankei start-angle end-angle)))
						


;;; ʱ߸̤ɽ
(defmethod mark-drawobject ((ob ellipse-arc-object) 
							operation &optional (color nil))
  (declare (optimize (compilation-speed 0) (speed 3) (safety 0)))
  (let ((parent (draw-stream ob)))
	(with-non-graphic-matrix 
	 parent
	 (with-slots 
	  (center-x center-y x-hankei y-hankei current-color
				start-angle end-angle (current current-graphic-state)) ob
	   (with-graphic-state-for-draw 
		parent current 
		(if color
			current-color
		(selection-color parent)) operation
		(draw-ellipse-xy parent center-x center-y x-hankei y-hankei
						 :start-angle start-angle :end-angle end-angle)
		)))
	))


;;; ʱ߸̤
(defmethod point-selection ((ob ellipse-arc-object) event-x event-y)
  (declare (optimize (compilation-speed 0) (speed 3) (safety 0)))
  (with-slots
   (center-x center-y x-hankei y-hankei start-angle 
			 end-angle (current current-graphic-state)) ob
   (if (point-ellipse-selection center-x center-y x-hankei y-hankei
							   (draw-line-width current)
							   (draw-fill-mode current)
							   event-x event-y)
	   (if (arc-point-selection center-x center-y 
								start-angle end-angle 
								event-x event-y (draw-clockwise current))
		   T
		 nil)
	 nil)
   ))

;;; ʸ
(defmethod point-selection ((ob string-object) event-x event-y)
  (declare (optimize (compilation-speed 0) (speed 3) (safety 0)))
  (with-slots
   (start-x start-y end-x end-y width) ob
   (point-line-selection (list start-x start-y end-x end-y)
                         width event-x event-y)))

;;; ʸɽ
(defmethod mark-drawobject ((ob string-object) operation &optional (color nil))
  (declare (optimize (compilation-speed 0) (speed 3) (safety 0)))
  (let* ((parent (draw-stream ob))
		 (original-matrix (stream-transform-by-matrix parent)))
	(with-slots 
	 (original-x original-y direction draw-font string-data matrix
	  current-color (current current-graphic-state)) ob
	  (with-graphic-state-for-draw 
	   parent current 
	   (if color
		   current-color
		 (selection-color parent)) operation
	   (setf (stream-transform-by-matrix parent) matrix)
	 
	   ;;; ȿˤ餹
	   (setf (matrix-theta matrix) (* (matrix-theta matrix) -1))
	   (with-transform-xy 
		((nx ny) parent original-x original-y)
		
		(setf (matrix-theta matrix) (* (matrix-theta matrix) -1))

		(draw-string-xy parent string-data nx ny
						:direction direction))
	   (setf (stream-transform-by-matrix parent) original-matrix)
		
	   ))))

;;; ʸΰưɽ
;;; ɽXORǾäƿ֤Ǻɽ
;;; οɽƤ뤳ȤݾڤƤ
(defmethod move-drawobject ((ob string-object) new-x new-y)
  (declare (special *GXOR*)
		   (optimize (compilation-speed 0) (speed 3) (safety 0)))
  (mark-drawobject ob *GXOR* T)
  (with-slots 
   (original-x original-y start-x start-y end-x end-y) ob
   (let ((sa-x (- new-x original-x))
		 (sa-y (- new-y original-y)))
   (setf original-x new-x
		 original-y new-y)
   (incf start-x sa-x)
   (incf end-x sa-x)
   (incf start-y sa-y)
   (incf end-y sa-y)
   (mark-drawobject ob *GXOR* T)
   )))

#|
;;; ʸΰưν
(defmethod moved-drawobject ((object string-object))
  (declare (optimize (compilation-speed 0) (speed 3) (safety 0)))
  (let ((stream (draw-stream object)))
	(with-slots 
	 (start-x end-x start-y end-y) object
	 (with-transform-xy
	  ((nx ny) stream start-x start-y)
	  (setf start-x nx
			start-y ny))
	 (with-transform-xy
      ((nx ny) stream end-x end-y)
	  (setf end-x nx
			end-y ny))
	  )))

|#
;;; ֤
(defmethod start-point ((ob string-object))
  (declare (optimize (compilation-speed 0) (speed 3) (safety 0)))
  (with-slots 
   (original-x original-y) ob
   (values original-x original-y )))


;;;ʬ֥Ȥ:after
(defmethod initialize-instance :after ((ob senbun) &rest args)
  (declare (ignore args)
		   (optimize (compilation-speed 0) (speed 3) (safety 0)))
  (with-slots 
   (x1 y1 x2 y2 katamuki seppen) ob
   (setf katamuki (if (zerop (- x2 x1))
					  :none
					(float (/ (- y2 y1)
							  (- x2 x1))))
		 seppen (if (eq katamuki :none)
					x1
				  (- y1 (* katamuki x1))))
   ))

;;; ɽ᥽å
(defmethod print-object ((ob senbun) stream)
  (declare (optimize (compilation-speed 0) (speed 3) (safety 0)))
  (with-slots 
   (x1 y1 x2 y2 katamuki seppen) ob
   (format stream "~%Y = ~aX + ~a (~a,~a) (~a,~a)" katamuki seppen
		   x1 y1 x2 y2)))
  
;;; Ϳ줿ʬͿ줿ξˤȤ T֤
;;; x y ϡΰ
(defmethod lien-upper-pointp ((ob senbun) x y)
  (declare (optimize (compilation-speed 0) (speed 3) (safety 0)))
  (with-slots 
   (katamuki seppen) ob
	(if (eq katamuki :none)
		nil
	  (let ((new-y (+ (* katamuki x) seppen)))
		(if (>= new-y y)
			T
		  nil))
	  )))

;;; Ϳ줿ʬϰϤͿ줿Ȥ
;;; ʬϰϤˤ뤫Ĵ٤
(defmethod line-point-interp ((ob senbun) x y)
  (declare (optimize (compilation-speed 0) (speed 3) (safety 0)))
  (with-slots 
   (y1 y2 katamuki seppen) ob
   (if (eq katamuki :none)
	   nil
	 (let ((new-y (+ (* katamuki x) seppen)))
	   (if (= katamuki 0.0)
		   (if (= y seppen)
			   T
			 NIL)
		 (if (and (>= new-y (min y1 y2))
				  (>= (max y1 y2) new-y))
			 T
		   nil))
	   ))
  ))

;;; ΥꥹȤʬꥹȤ
;;; δؿϡpolylineѤǤ롣
;;; points-list ==: (x1 y1 x2 y2 x2 y3 ... xn yn)
(defun make-polyline-points-list (points-list)
  (declare (optimize (compilation-speed 0) (speed 3) (safety 0)))
  (let ((ret-list nil))
	(do ((top-4 points-list (cddr top-4)))
		((null top-4))
		(push (list (car top-4)
					(second top-4)
					(third top-4)
					(fourth top-4))
			  ret-list))
	(reverse (cdr ret-list))))


;;; ΥꥹȤʬ󥹥󥹤ΥꥹȤ
;;; points-list ==: (x1 y1 x2 y2 x2 y3 ... xn yn)
(defun make-polygon-senbun-list (points-list)
  (declare (optimize (compilation-speed 0) (speed 3) (safety 0)))
  (let ((ret-list nil))
	(do ((top-4 points-list (cddr top-4)))
		((null top-4))
		(push (make-instance `senbun 
							 :x1(car top-4)
							 :y1 (second top-4)
							 :x2 (if (null (third top-4))
									 (car points-list)
								   (third top-4))
							 :y2 (if (null (fourth top-4))
									 (second points-list)
								   (fourth top-4))
							 )
			  ret-list))
	(reverse ret-list)))

;;; 襪֥Ȥǥޥ줿
(defun draw-object-button-down (ob state)
  (declare (special *GXOR*)
		   (optimize (compilation-speed 0) (speed 3) (safety 0)))
  (let ((x (mouse-state-x-position state))
		(y (mouse-state-y-position state))
		(non-selection-flg T)
		(parent (active-region-parent ob)))
	(with-region-slots
	 (left bottom) ob
	 (incf x left)
	 (incf y bottom))

	(if (point-selection-list ob x y)
		(progn
		  (clear-selection-mark (current-selection-object parent))
		  (setf (current-selection-object parent) ob
				non-selection-flg nil
				(point-sabun-x ob) (mouse-state-x-position state)
				(point-sabun-y ob) (mouse-state-y-position state))
		  ;;; Ĥ
		  (dolist (draw-object (draw-object-list ob))
				  (mark-drawobject draw-object *GXOR*))
		  )
	  (progn
	   ;;; פʤ
		(dolist (item (draw-primitive-list parent))
		      ;;; ¾ΤΤõ
				(when (not (eq item ob))
					  (if (region-contains-position-xy-p item x y)
						  (if (point-selection-list item x y)
							  (progn
								(clear-selection-mark 
								 (current-selection-object parent))
								(setf (current-selection-object parent) item
									  (point-sabun-x ob) 
									  (mouse-state-x-position state)
									  (point-sabun-y ob) 
									  (mouse-state-y-position state))
 		                        ;;; Ĥ
								(dolist (draw-object (draw-object-list item))
										(mark-drawobject draw-object *GXOR*))
								(setf non-selection-flg NIL)
								(return))
							)))
				)
		))
	  (when non-selection-flg
		  (clear-selection-mark (current-selection-object parent))
		  (setf (current-selection-object parent) nil)
		 )
	 ))

;;; ߤɽä
(defun clear-selection-mark (item)
  (declare (special *GXOR*)
		   (optimize (compilation-speed 0) (speed 3) (safety 0)))
  (when item
		(dolist (draw-object (draw-object-list item))
				(mark-drawobject draw-object *GXOR*)))
  )

(defun point-selection-list (ob x y)
  (declare (optimize (compilation-speed 0) (speed 3) (safety 0)))
  (let ((ret nil))
	(dolist (item (draw-object-list ob))
			(if (point-selection item x y)
				(progn 
				  (setf ret T)
				  (return))))
	ret))

;;; ɽ줿֥Ȥκɽ
;;; &rest ǻꤷ֥Ȥϡɽʤ
(defun redisply-draw-object (window &rest rest)
  (declare (special *GCOPY*)
		   (optimize (compilation-speed 0) (speed 3) (safety 0)))
  (let ((display-seq (reverse (draw-primitive-list window))))
	(dolist 
	 (item display-seq)
	 (if (not (find item rest))
		 (dolist (draw-object (reverse (draw-object-list item)))
				 (mark-drawobject draw-object *GCOPY* T))
	   ))
	))

;;; ꤷΰ򥦥ɥطʿɤ
(defmethod draw-background-color-region ((window window-stream)
										 (region region))
  (declare (special *GCOPY* *FillTiled*)
		   (optimize (compilation-speed 0) (speed 3) (safety 0)))
  (with-non-graphic-matrix
     window
	 (with-graphic-state
	  (color default-color-pattern operation filled-type) window
	  (setf color default-color-pattern
			filled-type *FillTiled*
			operation *GCOPY*)
   
	  (draw-region-region window region))))


;;; ؿ
(defun find-all-draw-oject (window)
  (let ((a-list (draw-primitive-list window)))
	(dolist (item a-list)
			(format t "~%~a" (class-of (car (draw-object-list item))))

			(let ((ob (car (draw-object-list item))))
			  (when (slot-exists-p ob 'points-list)
					(print (slot-value ob 'points-list)))
			  (when (slot-exists-p ob 'point-pair-list)
					(print (slot-value ob 'point-pair-list)))
			  (when (slot-exists-p ob 'senbun-list)
					(print (slot-value ob 'senbun-list)))
			  (when (slot-exists-p ob 'original-x)
					(with-slots 
					 (start-x start-y original-x original-y end-x end-y)
					 ob
					 (format t "~%original-x ~a original-y ~a start-x ~a start-y ~a end-x ~a end-y ~a" original-x original-y start-x start-y end-x end-y)
					 ))
			  )
			
			)))
