;;; -*- Mode: LISP; Syntax: Common-lisp; Package: YY; Base: 10 -*-
;;; $@%0%i%U%#%/%9$N%F%9%H%&%#%s%I%&(J
;;; graphic-test-class.lisp
;;;
;;;  Copyright (C) 1989,1990,1991 Aoyama Gakuin University
;;;
;;;	      All Rights Reserved
;;;
;;; This software is developed for the YY project of Aoyama Gakuin University.
;;; Permission to use, copy, modify, and distribute this software
;; and its documentation for any purpose and without fee is hereby granted,
;;; provided that the above copyright notices appear in all copies and that
;;; both that copyright notice and this permission notice appear in 
;;; supporting documentation, and that the name of Aoyama Gakuin
;;; not be used in advertising or publicity pertaining to distribution of
;;; the software without specific, written prior permission.
;;;
;;; This software is made available AS IS, and Aoyama Gakuin makes no
;;; warranty about the software, its performance or its conformity to
;;; any specification. 
;;;
;;; To make a contact: Send E-mail to ida@csrl.aoyama.ac.jp for overall
;;; issues. To ask specific questions, send to the individual authors at
;;; csrl.aoyama.ac.jp. To request a mailing list, send E-mail to 
;;; yyonx-request@csrl.aoyama.ac.jp.
;;;
;;; Authors:
;;;   version 1.3 91/02/26 by t.kosaka
;;;
;;; $@%0%i%U%#%C%/%9$N%F%9%H$r$9$k%/%i%9(J


(in-package :yy)

;;;  --------------  $@%9%i%$%@!<(J -------------------------

;;; $@%P%C%/%0%i%&%s%I$N?'$HI=<($9$k%*%V%8%'%/%H$N?'$rI=$9(J
(defclass color-value ()
  ((color :initarg :color :accessor color :initform *white-color*)
   (back-color :initarg :back-color :accessor back-color 
	       :initform *black-color*)))


;;; $@%9%i%$%@!<$,F0$/%/%i%9!!(J
(defclass slider-piece (event-drawable-piece)
  ((color-value  :initarg :color-value :initform nil :accessor color-value)
   (back-color :initarg :back-color :initform *white-color* 
	       :accessor back-color)
   (old-x :initform nil :accessor old-x)
   (current-x :initform 0 :accessor current-x)))

;;; $@%9%i%$%@!<$HCM!"I=<(J8;z$r07$&%/%i%9(J
(defclass slider (piece-region)
    ;;; $@%?%$%H%k$NJ8;zNs$O(J
  ((title-slot :initarg :title-slot :initform nil :accessor title-slot)
   (value-slot :initarg :value-slot :initform nil :accessor value-slot)
   (piece-slot :initarg :piece-slot :initform nil :accessor piece-slot)
   (color-value  :initarg :color-value :initform nil :accessor color-value)
   ))

;;; $@%9%i%$%@!<$N%?%$%H%k$rI=<($9$k%/%i%9(J
(defclass slider-title (piece-region)
  ((title :initarg :title :initform "" :accessor title)
   (color-value  :initarg :color-value :initform nil :accessor color-value)))


;;; $@%9%i%$%@!<$NCM$rI=<($9$k%/%i%9(J  
(defclass slider-value (piece-region)
  ((value :initarg :value :initform 0 :accessor value)
   (offset :initarg :offset :initform #'+ :accessor offset)
   (color-value  :initarg :color-value :initform nil :accessor color-value)
   (a-list :initarg :a-list :initform nil :accessor a-list)
   (form :initarg :form :accessor form :initform nil)))


;;; $@:BI8JQ49%^%H%j%C%/%9$rA`:n$9$k%9%i%$%@!<%/%i%9(J
(defclass matrix-panel (piece-region)
  ((theta-slider :initarg :theta-slider :initform nil
		 :accessor theta-slider)
   (x-time-slider :initarg :x-time-slider :initform nil
		  :accessor x-time-slider)
   (y-time-slider :initarg :y-time-slider :initform nil
		  :accessor y-time-slider)))

;;; $@%9%$%C%AIU$-$N%&%#%s%I%&$N%U%l!<%`$rDj5A$9$k(J
(defclass switch-frame (window-frame) ())


;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;; $@%9%$%C%AIU$-$N%&%#%s%I%&$rDj5A(J ;;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
(defclass switch-window (viewport-window-stream)
  ((switch-with-title :initarg switch-with-title :initform nil
		     :accessor switch-with-title)
   (matrix-panel :initarg matrix-panel :initform nil
		 :accessor matrix-panel)
   (draw-switch-list :initform nil :accessor draw-switch-list)
   (current-draw-switch :initform nil :reader current-draw-switch)
   (button-down-method :initform nil :accessor button-down-method)
   (points-list :initform nil :accessor points-list)
   (rubber-band-method :initform nil :accessor rubber-band-method)
   (temp-x :initform nil :accessor temp-x)
   (temp-y :initform nil :accessor temp-y)
   (old-temp-x :initform nil :accessor old-temp-x)
   (old-temp-y :initform nil :accessor old-temp-y)
   (move-oldest-x :initform nil :accessor move-oldest-x)
   (move-oldest-y :initform nil :accessor move-oldest-y)
   (arc-hankei :initform nil :accessor arc-hankei)
   (start-angle :initform nil :accessor star-angle)
   (end-angle :initform nil :accessor end-angle)
   (ellipse-x :initform nil :accessor ellipse-x)
   (ellipse-y :initform nil :accessor ellipse-y)
   (ellipse-x-hankei :initform nil :accessor ellipse-x-hankei)
   (ellipse-y-hankei :initform nil :accessor ellipse-y-hankei)
   (current-selection-object :initform nil :accessor current-selection-object))
  )


;;; $@%?%$%H%k!<%P!<$r;}$D%9%$%C%A%j!<%8%g%s(J
(defclass switch-with-title (piece-region)
  ((title-string :initarg :title-string :initform ""
                 :accessor title-string)
   (switch-body :initarg :switch-body :initform nil
		:accessor switch-body)))

;;; $@A*Br%9%$%C%A(J
(defclass select-switch (event-drawable-piece)
  ((switch-stream :initarg :switch-stream :initform nil 
		  :accessor switch-stream)
   (switch-value :initarg :switch-value 
		 :accessor switch-value)
   (select-value-list :initarg :select-value-list
		      :accessor select-value-list)
   (current-count :initarg :currenr-count :initform 0
		  :accessor current-count))
  )


;;; $@=D=q$-!?2#=q$-%9%$%C%A(J
(defclass tate-yoko-switch (select-switch) ())

;;; $@@~$NB@$5%9%$%C%A(J
(defclass line-width-switch (select-switch) ())

;;; $@@~$NC<$N%9%$%C%A(J
(defclass line-edge-switch (select-switch) ())

;;; $@@\B3E@$N7A%9%$%C%A(J
(defclass line-joint-switch (select-switch) ())

;;; $@E@@~%9%$%C%A(J
(defclass line-dashing-switch (select-switch) ())

;;; $@?'$N%9%$%C%A(J
(defclass color-change-switch (select-switch) ())

;;; $@%U%#%k$N%9%$%C%A(J
(defclass fill-switch (select-switch) ())

;;; $@%"!<%/%b!<%I$N%9%$%C%A(J
(defclass arc-mode-switch (select-switch) ())

;;; $@IA2h%3%^%s%I%9%$%C%A(J
(defclass draw-switch (event-drawable-piece)
  ((switch-stream :initarg :switch-stream :initform nil 
		  :accessor switch-stream)
   ))

;;; $@IA2h$7$?%*%V%8%'%/%H$r$^$H$a$FI=$9%/%i%9(J
(defclass drawing-objects (active-region)
  ((draw-object-list :initarg :draw-object-list :initform nil
					 :accessor draw-object-list)
   (sabun-x :initform 0 :initarg :sabun-x :accessor sabun-x)
   (sabun-y :initform 0 :initarg :sabun-y :accessor sabun-y)
   (point-sabun-x :initform 0 :accessor point-sabun-x)
   (point-sabun-y :initform 0 :accessor point-sabun-y)))


;;; $@IA2h%*%V%8%'%/%H$N4pK\%/%i%9(J
(defclass draw-object ()
  ((relationship :initform nil :initarg relationship
				 :accessor relationship)))

;;; $@E@IA2h%*%V%8%'%/%H(J
(defclass point-object (draw-object) ())

;;; $@@~IA2h%*%V%8%'%/%H(J
(defclass line-object (draw-object) ())

;;; $@@^$l@~IA2h%*%V%8%'%/%H(J
(defclass polyline-object (draw-object) ())
   
;;; $@B?3Q7AIA2h%*%V%8%'%/%H(J
(defclass polygon-object (draw-object) ())

;;; $@6k7A7AIA2h%*%V%8%'%/%H(J
(defclass region-object (draw-object) ())

;;; $@1_IA2h%*%V%8%'%/%H(J
(defclass circle-object (draw-object) ())

;;; $@1_8LIA2h%*%V%8%'%/%H(J
(defclass arc-object (draw-object) ())

;;; $@BJ1_8L$N%*%V%8%'%/%H(J
(defclass ellipse-arc-object (draw-object) ())

;;; $@BJ1_IA2h%*%V%8%'%/%H(J
(defclass ellipse-object (draw-object) ())

;;; $@J8;zNsIA2h%*%V%8%'%/%H(J
(defclass string-object (draw-object) ())

;;; $@@~$NIA2h(J
(defclass line-draw-switch (draw-switch) ())

;;; $@1_(J
(defclass circle-draw-switch (draw-switch) ())

;;; $@BJ1_(J
(defclass ellipse-draw-switch (draw-switch) ())

;;; $@@^$l@~$NIA2h(J
(defclass polyline-draw-switch (draw-switch) ())

;;; $@6k7A$NIA2h(J
(defclass region-draw-switch (draw-switch) ())

;;; $@B?3Q7A$NIA2h(J
(defclass polygon-draw-switch (draw-switch) ())

;;; $@1_8L$NIA2h(J
(defclass arc-draw-switch (draw-switch) ())

;;; $@BJ1_8L$NIA2h(J
(defclass arc-ellipse-draw-switch (draw-switch) ())

;;; $@J8;zNs(J
(defclass string-draw-switch (draw-switch) ())

;;; $@A*Br(J
(defclass selction-object-switch (draw-switch) ())

;;; $@4X78IU$1(J
(defclass relation-object-switch (draw-switch) ())

;;; $@>C5n(J
(defclass delete-object-switch (draw-switch) ())
