;;; -*- Mode: LISP; Syntax: Common-lisp; Package: YY; Base: 10 -*-
;;; graphic-primitive-class.lisp
;;;
;;;  Copyright (C) 1989,1990,1991 Aoyama Gakuin University
;;;  graphic-primitive.lisp
;;;
;;;		All Rights Reserved
;;;
;;; This software is developed for the YY project of Aoyama Gakuin University.
;;; Permission to use, copy, modify, and distribute this software
;;; and its documentation for any purpose and without fee is hereby granted,
;;; provided that the above copyright notices appear in all copies and that
;;; both that copyright notice and this permission notice appear in 
;;; supporting documentation, and that the name of Aoyama Gakuin
;;; not be used in advertising or publicity pertaining to distribution of
;;; the software without specific, written prior permission.
;;;
;;; This software is made available AS IS, and Aoyama Gakuin makes no
;;; warranty about the software, its performance or its conformity to
;;; any specification. 
;;;
;;; To make a contact: Send E-mail to ida@csrl.aoyama.ac.jp for overall
;;; issues. To ask specific questions, send to the individual authors at
;;; csrl.aoyama.ac.jp. To request a mailing list, send E-mail to 
;;; yyonx-request@csrl.aoyama.ac.jp.
;;;
;;; Authors:
;;;   version 1.0 90/06/01 by t.kosaka (kosaka@csrl.aoyama.ac.jp)
;;;   version 1.1 90/07/31 by t.kosaka
;;;   update 1.11 90/09/14 by t.kosaka
;;;   version 1.2 90/11/05 by t.kosaka

;;; $@IA2h5Z$SI=<($N$?$a$N4pK\%/%i%9$NDj5A(J

;;; Version 1.3.1  11/27/91  Coded by t.kosaka 

(in-package :yy)

;;; $@:BI8JQ49%/%i%9%_%-%7%s(J
(defclass translate-coordinate-mixin () ())

;;; $@:BI8JQ49%/%i%9(Jleft bottom
;;; $@:82<$9$_MQ$N%/%i%9(J
(defclass translate-coordinate-left-bottom
  (translate-coordinate-mixin)
  ())

;;; $@:BI8JQ49%/%i%9(Jleft top$@MQ(J
;;; $@:82<$9$_:BI87O%/%i%9(J
(defclass translate-coordinate-left-top
  (translate-coordinate-mixin)
  ())

;;; $@%0%i%U%#%C%/%H%i%s%9%U%)!<%`%^%H%j%C%/%9%_%-%7%s(J
(defclass graphic-transform-matrix-mixin ()
;;;  | cos theta -sin theta | | x-time |
;;;  | sin theta  cos theta | | y-time |
;;; $@$N2sE>9TNs$rDs6!$9$k%/%i%9(J
  ((theta :initarg :theta   :accessor matrix-theta 
		  :initform 0.0 :type number)
   (x-time :initarg :x-time :accessor matrix-x-time 
		   :initform 1.0 :type number)
   (y-time :initarg :y-time :accessor matrix-y-time 
		   :initform 1.0 :type number)))

;;; $@%0%i%U%#%C%/%H%i%s%9%U%)!<%`%^%H%j%C%/%9$N<B9T%/%i%9(J
(defclass graphic-transform-matrix-exec 
  (graphic-transform-matrix-mixin)
  ((step-slots :initform '(1 1 1 1) 
			   :initarg :step-slots :accessor step-slots)))

#|
  ((step-x1 :initarg :x-step1 :initform 1 :accessor step-x1)
   (step-x2 :initarg :x-step2 :initform 1 :accessor step-x2)
   (step-y1 :initarg :y-step1 :initform 1 :accessor step-y1)
   (step-y2 :initarg :y-step2 :initform 1 :accessor step-y2)))
|#

;;; $@%0%i%U%#%C%/%H%i%s%9%U%)!<%`%^%H%j%C%/%9$NHs<B9T%/%i%9(J
(defclass graphic-transform-matrix-non
  (graphic-transform-matrix-mixin)
  ())


;;; $@%0%i%U%#%C%/%9%F%$%H%_%-%7%s(J
(defclass graphic-state-mixin  ()
  ((state-slots :initform
		(list *GCOPY* *BLACK-COLOR* 1 *SQUEAR-LINE-EDGE*
		      *SHARP-JOINT* "" *ARCPIESLICE* *Fillednon*
		      *white-color* *EvenOddRule* nil :counter-clockwize)
		:accessor state-slots)))

;;; $@%0%i%U%#%C%/%9%H%j!<%`$NIA2h%5%$%:%/%i%9(J
(defclass graphic-output-stream-size (graphic-state-mixin )
  ((world-width :initarg :width :accessor world-width
	  :initform 0)
   (world-height :initarg :height :accessor world-height
	   :initform 0)))

;;; $@%0%i%U%#%C%/%9%H%j!<%`$N%F%-%9%H%3%s%H%m!<%k%/%i%9(J
(defclass graphic-text-control-mixin ()
   ;;; $@:8$O$7$N%F%-%9%H3+;O0LCV(J nil$@$J$i$P%9%H%j!<%`$N3+;O0LCV$+$i(J
   ;;; $@CM$,$"$l$P!"$=$N0LCV$+$i(J
  ((left-margin :initarg :left-margin :initform nil
		:accessor stream-left-margin)
   ;;; $@J8;zNs=PNO$N=*N;0LCV(J nil$@$J$i$PIA2h%5%$%:$K=>$&(J
   ;;; $@CM$,$"$l$P!"$=$N0LCV$^$G(J
   (right-margin :initarg :right-margin :initform nil
		:accessor stream-right-margin)
   (top-margin :initarg :top-margin :initform nil
   	       :accessor stream-top-margin)
   (bottom-margin :initarg :bottom-margin :initform nil
   		  :accessor stream-bottom-margin)
   ;;; $@%F%-%9%HMQ%U%)%s%H(J
   (font :initarg :text-font :accessor stream-font :type text-font
	 :initform *default-font*)
   ;;; $@%F%-%9%H$N%i%$%s%U%#!<%I9b$5(J
   (line-feed :initarg :line-feed  :initform 0
	      :accessor stream-line-feed)

   ;;; $@J8;zNs$N=P%9%?%$%k(J horizontal $@$J$i$P2#=q$-(J :vertical$@$J$i$P=D=q$-(J
   (output-direction :initarg :output-direction 
		     :accessor stream-output-direction  
	     :initform :horizontal)
   ;;; $@%^!<%8%sI}$G$NJ8;zNs:o=|(J $@2#=q$-(J $@MQ(J
   (truncate-width :initarg :truncate-width :accessor stream-truncate-width
		   :initform nil)
   ;;; $@%^!<%8%s9b$5$G$NJ8;zNs:o=|(J $@=D=q$-MQ(J
   (truncate-height :initarg :truncate-heigt :accessor stream-truncate-height
		    :initform nil)
   ))

;;; $@%0%i%U%#%C%/%9%H%j!<%`(J
(defclass graphic-stream
  (graphic-text-control-mixin graphic-output-stream-size 
							  fundamental-character-output-stream)

   ;;; $@%+!<%=%k$N%]%8%7%g%s%9%m%C%H(J
  ((cursor-position :initarg :strem-cursor-position  
		    :type position :accessor stream-cursor-position
		    :initform (make-position))
   
   ;;; $@:BI8JQ49MQ%9%m%C%H(J $@%G%U%)%k%H$O!":8>e$9$_(J
   (translate-coordinate :initarg :translate-coordinate-ob
			 :type translate-coordinate-mixin
			 :reader stream-translate-coordinate
			 :initform nil)

   ;;; $@%0%i%U%#%/%9%H%i%s%9%U%)!<%`%^%H%j%C%/%9%9%m%C%H(J
   ;;; $@%G%U%)%k%H$O!"2?$b$7$J$$(J
   (transform-by-matrix :initarg :transform-matrix
        :reader stream-transform-by-matrix
        :type graphic-transform-matrix-mixin
        :initform  (make-instance 'graphic-transform-matrix-non))

   ;;; $@%o!<%/MQ(Jregion
   (work-region1 :initform (make-region)
		 :accessor work-region1)
   (work-region2 :initform (make-region)
		 :accessor work-region2)
   (work-region3 :initform (make-region)
		 :accessor work-region3)
   (work-region4 :initform (make-region)
		 :accessor work-region4)

   ))


;;;  X3J13. Stream INPUT
(defclass fundamental-character-input-stream  ()
  ((input-string :initarg :input-string 
				 :type list :reader stream-input-string-internal
				 :initform nil)
   (for-unread-char :initarg :for-unread-char
					:accessor for-unread-char
					:initform nil)
   ))

;;;  X3J13. Stream OUTPUT
(defclass fundamental-character-output-stream ()
  ((string :initform (make-array 64.
                                :element-type
#-:EXCL
                      'string-char
#+:EXCL
                      'character
		      :fill-pointer 0 :adjustable t)
 :initarg :string )
   (endp    :initform 0 :initarg :endp )))









