;;; -*- Mode: LISP; Syntax: Common-lisp; Package: YY; Base: 10 -*-
;;; graphic-method-page.lisp
;;;
;;;  Copyright (C) 1989,1990,1991 Aoyama Gakuin University
;;;
;;;		All Rights Reserved
;;;
;;; This software is developed for the YY project of Aoyama Gakuin University.
;;; Permission to use, copy, modify, and distribute this software
;;; and its documentation for any purpose and without fee is hereby granted,
;;; provided that the above copyright notices appear in all copies and that
;;; both that copyright notice and this permission notice appear in 
;;; supporting documentation, and that the name of Aoyama Gakuin
;;; not be used in advertising or publicity pertaining to distribution of
;;; the software without specific, written prior permission.
;;;
;;; This software is made available AS IS, and Aoyama Gakuin makes no
;;; warranty about the software, its performance or its conformity to
;;; any specification. 
;;;
;;; To make a contact: Send E-mail to ida@csrl.aoyama.ac.jp for overall
;;; issues. To ask specific questions, send to the individual authors at
;;; csrl.aoyama.ac.jp. To request a mailing list, send E-mail to 
;;; yyonx-request@csrl.aoyama.ac.jp.
;;;
;;; Authors:
;;;   version 1.4 92/07/31 by t.kosaka (kosaka@csrl.aoyama.ac.jp)
;;; $@%Z!<%8%b!<%IMQ$N?^7A=PNO(J $@%Z!<%8%b!<%I$G$O!"?^7A=PNO$O!"IT2D(J

(in-package :yy)


;;; $@E@$NIA2h(J 
;;; draw-position-xy graphic-stream x y
;;; ASG. 
;;;         graphic-stream     = $@%0%i%U%#%/%9%9%H%j!<%`(J
;;;         x y                = $@0LCV(J
(defmethod draw-position-xy ((stream page-window-stream) 
							 (x integer) (y integer))
  #-PCL
  (declare (ignore x y))
  stream)

;;; $@E@$NIA2h(J $@%]%8%7%g%sMQ(J
;;; draw-position graphic-stram position
;;; ARG.
;;;             graphci-stream   =  $@%0%i%U%#%/%9%9%H%j!<%`(J
;;;             psosition        =  $@%0%i%U%#%/%9%9%H%j!<%`$G$N0LCV(J
(defmethod draw-position ((stream page-window-stream) (position position))
  #-PCL
  (declare (optimize (compilation-speed 0) (speed 3) (safety 0))
		   (ignore position))
  stream)

;;; $@@~$NIA2h(J
;;; draw-line-xy stream x1 y1 x2 y2
;;; ARG.
;;;               stream        =   $@%0%i%U%#%/%9%9%H%j!<%`(J
;;;               x1 y1 x2 y2   =   $@@~$N:BI8(J
(defmethod draw-line-xy ((stream page-window-stream) (x1 integer) (y1 integer)
			 (x2 integer) (y2 integer))
  #-PCL
  (declare (optimize (compilation-speed 0) (speed 3) (safety 0))
		   (ignore x1 y1 x2 y1 y2))
  stream)

;;; $@@~$NIA2h(J $@%]%8%7%g%sMQ(J
;;; draw-line stream position1 position2
;;; ARG
;;;           stream              =   $@%0%i%U%#%/%9%9%H%j!<%`(J
;;;           position1 position2 =   $@@~$NIA2h$9$k0LCV%$%s%9%?%s%9(J
(defmethod draw-line ((stream page-window-stream) (position1 position)
					  (position2 position))
  (declare (optimize (compilation-speed 0) (speed 3) (safety 0))
		   (ignore position1 position2))
  stream)

;;; $@6k7A$NIA2h(J
;;; draw-region-xy stream x y width height
;;; ARG.
;;;           stream           =  $@%0%i%U%#%/%9%9%H%j!<%`(J
;;;           x y              =  $@6k7A$rIA2h$9$k3+;O0LCV(J
;;;           width height     =  $@6k7A$NBg$-$5(J
(defmethod draw-region-xy ((stream page-window-stream) (x integer) (y integer)
						   (width integer) (height integer))
  #-PCL
  (declare (optimize (compilation-speed 0) (speed 3) (safety 0))
		   (ignore x y width height))
  stream)

;;; $@6k7A$NIA2h%]%8%7%g%sMQ(J
;;; draw-region stream position width height
;;; ARG.
;;;             stream            =   $@%0%i%U%#%/%9%9%H%j!<%`(J
;;;             position          =   $@6k7A$rIA2h$9$k3+;O0LCV%$%s%9%?%s%9(J
;;;             width height      =   $@6k7A$NBg$-$5(J
(defmethod draw-region ((stream page-window-stream) (pos position)
						(width integer) (height integer))
  #-PCL
  (declare (optimize (compilation-speed 0) (speed 3) (safety 0))
		   (ignore pos width height))
  steam)

;;; $@6k7A$NIA2h(J $@%j!<%8%g%sMQ(J
;;; draw-region-region stream region
;;; ARG.
;;;             stream           = $@%0%i%U%#%/%9%9%H%j!<%`(J
;;;             region           = $@6k7A$N0LCV$HBg$-$5$r;}$D%$%s%9%?%s%9(J
(defmethod draw-region-region ((stream page-window-stream) (region region))
  #-PCL
  (declare (optimize (compilation-speed 0) (speed 3) (safety 0))
		   (ignore region))
  stream)

;;; $@@^$l@~$NIA2h(J      
;;; draw-polyline-xy stream x xy-list
;;; ARG.
;;;          stream            = $@%0%i%U%#%/%9%9%H%j!<%`(J
;;;          x                 = $@:G=i$N0LCV(J
;;;          xy-list           = $@0LCV(J
(defmethod draw-polyline-xy ((stream page-window-stream) (x integer) 
							 &rest xy-list)
  #-PCL
  (declare (ignore x xy-list))
  stream)


;;; $@@^$l@~$NIA2h(J      
;;; draw-polyline-xy stream xy-list
;;; ARG.
;;;          stream            = $@%0%i%U%#%/%9%9%H%j!<%`(J
;;;          xy-list           = $@0LCV$N%j%9%H(J
(defmethod draw-polyline-xy ((stream page-window-stream) (pp list) &rest args)
  #-PCL
  (declare (optimize (compilation-speed 0) (speed 3) (safety 0))
		   (ignore  pp args))
  stream)

;;; $@@^$l@~$NIA2h(J $@%]%8%7%g%sMQ(J
;;; draw-polyline-xy stream position-list
;;; ARG.
;;;          stream           =  $@%0%i%U%#%/%9%9%H%j!<%`(J
;;;          postion          =  $@:G=i$N%]%8%7%g%s(J
;;           position-list    =  $@%]%8%7%g%s%$%s%9%?%s%974(J
(defmethod draw-polyline ((stream page-window-stream) (pos position) 
						  &rest position-list)
  #-PCL
  (declare (optimize (compilation-speed 0) (speed 3) (safety 0))
		   (ignore pos position-list))
  stream)


;;; $@B?3Q7A$NIA2h(J
;;; draw-polygon-xy stream x xy-list
;;; ARG.
;;;         stream            =    $@%0%i%U%#%/%9%9%H%j!<%`(J
;;;         x                 =    $@:G=i$N(JX
;;;         xy-list           =    $@0LCV(J(x y)$@74(J
(defmethod draw-polygon-xy ((stream page-window-stream) 
							(x integer) &rest xy-list)
  #-PCL
  (declare (optimize (compilation-speed 0) (speed 3) (safety 0))
		   (ignore x xy-list))
  stream)

;;; $@B?3Q7A$NIA2h(J
;;; draw-polygon-xy stream xy-list
;;; ARG.
;;;         stream            =    $@%0%i%U%#%/%9%9%H%j!<%`(J
;;;         xy-list           =    $@0LCV(J(x y)$@$N%j%9%H(J
(defmethod draw-polygon-xy ((stream graphic-stream) (pp list) &rest rest)
  (declare (optimize (compilation-speed 0) (speed 3) (safety 0))
		   (ignore pp rest))
  stream)

;;; $@B?3Q7A$NIA2h(J $@%]%8%7%g%sMQ(J
;;; draw-polygon stream position-list
;;; ARG.
;;;           stream           =  $@%0%i%U%#%/%9%9%H%j!<%`(J
;;;           pps              =  $@:G=i$N%]%8%7%g%s(J
;;;           position-list    =  $@0LCV%$%s%9%?%s%974(J
(defmethod draw-polygon ((stream page-window-stream) 
						 (pos position) &rest position-list)
  #-PCL
  (declare (optimize (compilation-speed 0) (speed 3) (safety 0))
		   (ignore pos position-list))
  stream)
		   

;;; $@;03Q7A$NIA2h(J   ($@FsEyJU;03Q7A(J)
;;; draw-triangle-xy stream x y width height
;;; ARG.
;;;           stream            =   $@%0%i%U%#%/%9%9%H%j!<%`(J
;;;           x y               =   $@DcJU$NCf?40LCV(J 
;;;           width             =   $@DcJU$NI}(J
;;;           height            =   $@9b$5(J
(defmethod draw-triangle-xy ((stream page-window-stream) 
							 (x integer) (y integer)
							 (width integer) (height integer))
  #-PCL
  (declare (optimize (compilation-speed 0) (speed 3) (safety 0))
		   (ignore x y width height))
  stream)

;;; $@;03Q7A$NIA2h(J $@%]%8%7%g%sMQ(J ($@FsEyJU;03Q7A(J)
;;; draw-triangle stream position width height
;;; ARG.
;;;              stream            = $@%0%i%U%#%/%9%9%H%j!<%`(J
;;;              position          = $@DcJU$NCf?40LCV%$%s%9%?%s%9(J
;;;              width             = $@;03Q7A$NI}(J
;;;              height            = $@9b$5(J
(defmethod draw-triangle ((stream page-window-stream) (position position)
						  (width integer) (height integer))
  #-PCL
  (declare (optimize (compilation-speed 0) (speed 3) (safety 0))
		   (ignore (position width height)))
  stream)

;;; $@BJ1_!"BJ1_8L!"BJ1_$N@p7?$NIA2h(J
;;; draw-ellipse-xy stream center-x center-y x-radius y-radius 
;;;                          &key (start-angle 0)
;;;                               (end-angle 2pi)
;;; ARG.
;;;               stream     =  $@%0%i%U%#%/%9%9%H%j!<%`(J
;;;     center-x center-y    =  $@BJ1_$NCf?4(J
;;;               x-radius   =  $@2#<4$K$*$1$kH>7B(J
;;;               y-radius   =  $@=D<4$K$*$1$kH>7B(J
;;;          start-angle     =  $@3+;O3QEY(J($@%i%G%#%"%s(J)
;;;          end-angle       =  $@=*N;3QEY(J($@%i%G%#%"%s(J)
;;;          clockwize       =  $@IA2hJ}8~(J
(defmethod draw-ellipse-xy ((stream page-window-stream) 
			    (center-x integer) (center-y integer)
			    (x-radius integer) (y-radius integer) 
			    &key (start-angle 0)
			    (end-angle (* 2 pi)))
  #-PCL
  (declare (optimize (compilation-speed 0) (speed 3) (safety 0))
		   (ignore center-x center-y x-radius y-radius start-angle
				   end-angle))
  stream)

;;; $@BJ1_!"BJ1_8L!"BJ1_$N@p7?$NIA2h(J
;;; draw-ellipse   stream posistion x-radius y-radius 
;;;                         &key (start-angle 0)
;;;                               (end-angle 2pi) (clockwize :clockwize)
;;; ARG.
;;;               stream     =  $@%0%i%U%#%/%9%9%H%j!<%`(J
;;;               position   =  $@BJ1_$NCf?4$N0LCV%$%s%9%?%s%9(J
;;;               x-radius   =  $@2#<4$K$*$1$kH>7B(J
;;;               y-radius   =  $@=D<4$K$*$1$kH>7B(J
;;;          start-angle     =  $@3+;O3QEY(J($@%i%G%#%"%s(J)
;;;          end-angle       =  $@=*N;3QEY(J($@%i%G%#%"%s(J)
;;;          clockwize       =  $@IA2hJ}8~(J
(defmethod draw-ellipse ((stream page-window-stream) (position position)
			    (x-radius integer) (y-radius integer) &key (start-angle 0)
			    (end-angle (* 2 pi)) (clockwize :clockwize))
  #-PCL
  (declare (optimize (compilation-speed 0) (speed 3) (safety 0))
		   (ignore position x-radius y-radius start-angle end-angle clockwize))
  stream)

;;; $@1_!"@p7?!"1_8L$NIA2h(J
;;; draw-circle-xy stream center-x center-y radius &key (start-angle 0)
;;;		(end-angle 2pi) 
;;; ARG.
;;;           stream             =  $@%0%i%U%#%/%9%9%H%j!<%`(J
;;;       center-x center-y      =  $@1_$NCf?4(J
;;;          radius              =  $@1_$NH>7B(J
;;;          start-angle         =  $@3+;O3QEY(J($@%i%G%#%"%s(J)
;;;          end-angle           =  $@=*N;3QEY(J($@%i%G%#%"%s(J)
(defmethod draw-circle-xy ((stream page-window-stream) (center-x integer)
			   (center-y integer) (radius integer)
			   &key (start-angle 0) (end-angle (* 2 pi)))
  #-PCL
  (declare (optimize (compilation-speed 0) (speed 3) (safety 0))
		   (ignore center-x center-y radius start-angle end-angle))
  stream)

;;; $@1_!"@p7?!"1_8L$NIA2h(J
;;; draw-circle stream position radius &key (start-angle 0)
;;;		(end-angle 2pi) clockwize
;;; ARG.
;;;           stream             =  $@%0%i%U%#%/%9%9%H%j!<%`(J
;;;          position            =  $@1_$NCf?40LCV$N%$%s%9%?%s%9(J
;;;          radius              =  $@1_$NH>7B(J
;;;          start-angle         =  $@3+;O3QEY(J($@%i%G%#%"%s(J)
;;;          end-angle           =  $@=*N;3QEY(J($@%i%G%#%"%s(J)
;;;          clockwize           =  $@IA2hJ}8~(J
(defmethod draw-circle ((stream page-window-stream) (position position)
						(radius integer) &key (start-angle 0)
						(end-angle (* 2 pi)))
  #-PCL
  (declare (optimize (compilation-speed 0) (speed 3) (safety 0))
		   (ignore position radius start-angle end-angle))
  stream)

;;; $@J8;zNs$NIA2h(J 
;;; draw-string-xy stream string x y &key start end direction
;;;            stream         = $@%0%i%U%#%/%9%9%H%j!<%`(J
;;;            string         = $@IA2h$9$kJ8;zNs(J
;;;            x y            = $@IA2h$9$k0LCV(J
;;;            start          = $@J8;zNs$N3+;O0LCV(J(string$@$J$$$G(J
;;;            end            = $@J8;zNs$N=*N;0LCV(J(string$@$J$$$G(J)
;;;            direction      = $@IA2h$9$kJ}8~(J
;;; RET.
;;;      (string T or nil)
;;;       T --> $@2~9T$,$"$C$?(J
(defmethod draw-string-xy ((stream page-window-stream) (string string)
						   (x integer) (y integer)
						   &key (start 0) (end (length string))
						   (direction :horizontal))
  #-PCL
  (declare (optimize (compilation-speed 0) (speed 3) (safety 0))
		   (ignore string z y start end direction))
  stream)

;;; $@J8;zNs$NIA2h(J 
;;; draw-string stream string position &key start end direction
;;;            stream         = $@%0%i%U%#%/%9%9%H%j!<%`(J
;;;            string         = $@IA2h$9$kJ8;zNs(J
;;;            position       = $@IA2h$9$k0LCV$N%$%s%9%?%s%9(J
;;;            start          = $@J8;zNs$N3+;O0LCV(J(string$@$J$$$G(J
;;;            end            = $@J8;zNs$N=*N;0LCV(J(string$@$J$$$G(J)
;;;            direction      = $@IA2h$9$kJ}8~(J
;;; RET.
;;;      (string T or nil)
;;;       T --> $@2~9T$,$"$C$?(J
(defmethod draw-string ((stream page-window-stream) (string string)
						(position position)
						&key (start 0) (end (length string))
						(direction :horizontal))
  #-PCL
  (declare (optimize (compilation-speed 0) (speed 3) (safety 0))
		   (ignore string position start end direction))
  stream)

;;; $@J8;z$NIA2h(J 
;;; draw-char-xy stream char x y &key direction
;;;            stream         = $@%0%i%U%#%/%9%9%H%j!<%`(J
;;;            string         = $@IA2h$9$kJ8;z(J
;;;            x y            = $@IA2h$9$k0LCV(J
;;;            direction      = $@IA2h$9$kJ}8~(J
;;; RET.
;;;      (string T or nil)
;;;       T --> $@2~9T$,$"$C$?(J
(defmethod draw-character-xy ((stream page-window-stream) (char character)
							  (x integer) (y integer)
							  &key (direction :horizontal))
  #-PCL
  (declare (optimize (compilation-speed 0) (speed 3) (safety 0))
		   (ignore char x y direction))
  stream)

;;; $@J8;z$NIA2h(J 
;;; draw-char stream char position &key direction
;;;            stream         = $@%0%i%U%#%/%9%9%H%j!<%`(J
;;;            string         = $@IA2h$9$kJ8;z(J
;;;            position       = $@IA2h$9$k0LCV$N%$%s%9%?%s%9(J
;;;            direction      = $@IA2h$9$kJ}8~(J
;;; RET.
;;;      (string T or nil)
;;;       T --> $@2~9T$,$"$C$?(J
(defmethod draw-character ((stream page-window-stream) (char character)
			(position position)
			&key (direction :horizontal))
  (declare (optimize (compilation-speed 0) (speed 3) (safety 0))
		   (ignore char position direction))
  stream)

;;; $@%0%i%U%#%/%9%H%j!<%`$K%$%a!<%8$rE>Aw$9$k!#(JXY$@MQ(J
;;; put-image-xy stream  image x y &optinal width height 
;;;                                &key (image-x 0) (image-y 0)
;;; ARG.
;;;       stream          = $@%0%i%U%#%/%9%H%j!<%`(J
;;;       x y             = $@%$%a!<%8$rIA2h$9$k0LCV(J
;;;       width           = $@IA2h$9$kI}(J
;;;       height          = $@IA2h$9$k9b$5(J
;;;       image-x         = $@%$%a!<%8Fb$N3+;O0LCV(J
;;;       image-y         = $@%$%a!<%8Fb$N3+;O0LCV(J
(defmethod put-image-xy ((stream page-window-stream) (image image)
						 (x integer) (y integer) 
						 &optional (width (image-width image))
						 (height (image-height image))
						 &key (image-x 0) (image-y 0))
  #-PCL
  (declare (optimize (compilation-speed 0) (speed 3) (safety 0))
		   (ignore image x y width height image-x image-y))
  stream)

;;; $@%0%i%U%#%/%9%H%j!<%`$K%$%a!<%8$rE>Aw$9$k!#%]%8%7%g%sMQ(J
;;; put-image stream  image position width height &key (image-x 0) (image-y 0)
;;; ARG.
;;;       stream          = $@%0%i%U%#%/%9%H%j!<%`(J
;;;       position        = $@%$%a!<%8$rIA2h$9$k0LCV$N%$%s%9%?%s%9(J
;;;       width           = $@IA2h$9$kI}(J
;;;       height          = $@IA2h$9$k9b$5(J
;;;       image-x         = $@%$%a!<%8Fb$N3+;O0LCV(J
;;;       image-y         = $@%$%a!<%8Fb$N3+;O0LCV(J
(defmethod put-image ((stream page-window-stream) (image image)
					  (position position) &optional
					  (width (image-width image))
					  (height (image-height image)) 
					  &key (image-x 0) (image-y 0))
  #-PCL
  (declare (optimize (compilation-speed 0) (speed 3) (safety 0))
		   (ignore image position width height image-x image-y))
  stream)


;;; $@%9%H%j!<%`$K%0%i%U%#%/%9%9%H%j!<%`$N%$%a!<%8$rIA2h$9$k!#(J
;;; draw-image distination-stream source-stream position width height
;;;            &key image-position
;;; ARG.
;;;       distination-stream   = $@%G%#%9%F%#%M!<%7%g%s%0%i%U%#%/%9%H%j!<%`(J
;;;       source-stream        = $@%=!<%9%0%i%U%#%/%9%H%j!<%`(J
;;;       position             = $@%$%a!<%8$rIA2h$9$k0LCV$N%$%s%9%?%s%9(J
;;;       width                = $@IA2h$9$kI}(J
;;;       height               = $@IA2h$9$k9b$5(J
;;;       image-position       = $@%=!<%9%0%i%U%#%/%9%H%j!<%`Fb$G$N0LCV$N(J
;;;                              $@%$%s%9%?%s%9(J
(defmethod draw-image ((d-stream page-window-stream) (s-stream graphic-stream)
					   (position position) (width integer) (height integer)
					   &key (image-position nil))
  #-PCL
  (declare (optimize (compilation-speed 0) (speed 3) (safety 0))
		   (ignore s-stream position width height image-position))
  d-stream)


;;; $@%9%H%j!<%`$K%0%i%U%#%/%9%9%H%j!<%`$N%$%a!<%8$rIA2h$9$k!#(JXY$@MQ(J
;;; draw-image-xy distination-stream source-stream dx dy width height
;;;            &key image-x image-y
;;; ARG.
;;;       distination-stream   = $@%G%#%9%F%#%M!<%7%g%s%0%i%U%#%/%9%H%j!<%`(J
;;;       source-stream        = $@%=!<%9%0%i%U%#%/%9%H%j!<%`(J
;;;       dx dy                = $@%$%a!<%8$rIA2h$9$k0LCV(J
;;;       width                = $@IA2h$9$kI}(J
;;;       height               = $@IA2h$9$k9b$5(J
;;;       image-x image-y      = $@%=!<%9%0%i%U%#%/%9%H%j!<%`Fb$G$N0LCV(J
(defmethod draw-image-xy ((d-stream page-window-stream) 
						  (s-stream graphic-stream)
						  (dx integer) (dy integer) (width integer) 
						  (height integer) &key (image-x 0) (image-y 0))
  #-PCL
  (declare (optimize (compilation-speed 0) (speed 3) (safety 0))
		   (ignore s-stream dx dy width height image-x image-y))
  d-stream)

;;; $@%9%H%j!<%`$K%S%C%H%^%C%W$N%$%a!<%8$rIA2h$9$k!#(J
;;; draw-image distination-stream source-bitmap position width height
;;;            &key image-position
;;; ARG.
;;;       distination-stream   = $@%G%#%9%F%#%M!<%7%g%s%0%i%U%#%/%9%H%j!<%`(J
;;;       source-bitmap        = $@%=!<%9%S%C%H%^%C%W(J
;;;       position             = $@%$%a!<%8$rIA2h$9$k0LCV$N%$%s%9%?%s%9(J
;;;       width                = $@IA2h$9$kI}(J
;;;       height               = $@IA2h$9$k9b$5(J
;;;       image-position       = $@%=!<%9%0%i%U%#%/%9%H%j!<%`Fb$G$N0LCV$N(J
;;;                              $@%$%s%9%?%s%9(J
(defmethod draw-image ((d-stream page-window-stream) (s-bitmap bitmap)
					   (position position) (width integer) (height integer)
					   &key (image-position nil))
  #-PCL
  (declare (optimize (compilation-speed 0) (speed 3) (safety 0))
		   (ignore s-bitmap position width height image-position))
  d-stream)


;;; $@%9%H%j!<%`$K%S%C%H%^%C%W$N%$%a!<%8$rIA2h$9$k!#(JXY$@MQ(J
;;; draw-image-xy distination-stream source-bitmap dx dy width height
;;;            &key image-x image-y
;;; ARG.
;;;       distination-stream   = $@%G%#%9%F%#%M!<%7%g%s%0%i%U%#%/%9%H%j!<%`(J
;;;       source-bitmap        = $@%=!<%9%S%C%H%^%C%W(J
;;;       dx dy                = $@%$%a!<%8$rIA2h$9$k0LCV(J
;;;       width                = $@IA2h$9$kI}(J
;;;       height               = $@IA2h$9$k9b$5(J
;;;       image-x image-y      = $@%=!<%9%0%i%U%#%/%9%H%j!<%`Fb$G$N0LCV(J
(defmethod draw-image-xy ((d-stream page-window-stream) (s-bitmap bitmap)
						  (dx integer) (dy integer) (width integer) 
						  (height integer) &key (image-x 0) (image-y 0))
  #-PCL
  (declare (optimize (compilation-speed 0) (speed 3) (safety 0))
		   (ignore s-bitmap dx dy width height image-x image-y))
  d-stream)


;;; $@%9%H%j!<%`$K%$%a!<%8$rIA2h$9$k!#(J
;;; draw-image distination-stream source-image position width height
;;;            &key image-position
;;; ARG.
;;;       distination-stream   = $@%G%#%9%F%#%M!<%7%g%s%0%i%U%#%/%9%H%j!<%`(J
;;;       source-image         = $@%=!<%9%$%a!<%8(J
;;;       position             = $@%$%a!<%8$rIA2h$9$k0LCV$N%$%s%9%?%s%9(J
;;;       width                = $@IA2h$9$kI}(J
;;;       height               = $@IA2h$9$k9b$5(J
;;;       image-position       = $@%=!<%9%0%i%U%#%/%9%H%j!<%`Fb$G$N0LCV$N(J
;;;                              $@%$%s%9%?%s%9(J
(defmethod draw-image ((d-stream page-window-stream) (s-image image)
					   (position position) (width integer) (height integer)
					   &key (image-position nil))
  #-PCL
  (declare (optimize (compilation-speed 0) (speed 3) (safety 0))
		   (ignore s-image position width height image-position))
  s-stream)

;;; $@%9%H%j!<%`$K%$%a!<%8$rIA2h$9$k!#(JXY$@MQ(J
;;; draw-image-xy distination-stream source-image dx dy width height
;;;            &key image-x image-y
;;; ARG.
;;;       distination-stream   = $@%G%#%9%F%#%M!<%7%g%s%0%i%U%#%/%9%H%j!<%`(J
;;;       source-image         = $@%=!<%9%$%a!<%8(J
;;;       dx dy                = $@%$%a!<%8$rIA2h$9$k0LCV(J
;;;       width                = $@IA2h$9$kI}(J
;;;       height               = $@IA2h$9$k9b$5(J
;;;       image-x image-y      = $@%=!<%9%0%i%U%#%/%9%H%j!<%`Fb$G$N0LCV(J
(defmethod draw-image-xy ((d-stream page-window-stream) (s-image image)
						  (dx integer) (dy integer) (width integer) 
						  (height integer) &key (image-x 0) (image-y 0))
  #-PCL
  (declare (optimize (compilation-speed 0) (speed 3) (safety 0))
		   (ignore s-image dx dy width height image-x image-y))
  d-stream)
		   


;;; $@%"%K%a!<%7%g%s%U%l!<%`$NDj5A(J
(defmethod define-animation-frame ((stream page-window-stream)
								   (x integer) (y integer)
								   (width integer) (height integer)
								   (max-number integer))
  #-PCL
  (declare (optimize (compilation-speed 0) (speed 3) (safety 0))
		   (ignore x y width height max-number))
  nil)

;;; End of file
