;;; -*- Mode: LISP; Syntax: Common-lisp; Package: YY; Base: 10 -*-
;;; YY $@$GDj5A$7$F$$$kJQ?t(J
;;; define-macro.lisp
;;;
;;;  Copyright (C) 1989,1990,1991 Aoyama Gakuin University and CSK Corp.
;;;
;;;		All Rights Reserved
;;;
;;; This software is developed for the YY project of Aoyama Gakuin University.
;;; Permission to use, copy, modify, and distribute this software
;;; and its documentation for any purpose and without fee is hereby granted,
;;; provided that the above copyright notices appear in all copies and that
;;; both that copyright notice and this permission notice appear in 
;;; supporting documentation, and that the names of Aoyama Gakuin of and CSK
;;; not be used in advertising or publicity pertaining to distribution of
;;; the software without specific, written prior permission.
;;;
;;; This software is made available AS IS, and Aoyama Gakuin makes no
;;; warranty about the software, its performance or its conformity to
;;; any specification. 
;;;
;;; To make a contact: Send E-mail to ida@csrl.aoyama.ac.jp for overall
;;; issues. To ask specific questions, send to the individual authors at
;;; csrl.aoyama.ac.jp. To request a mailing list, send E-mail to 
;;; yyonx-request@csrl.aoyama.ac.jp.
;;;
;;; Authors:
;;;   version 1.3 91/1/11 by T.kosaka 


(in-package :yy)

;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;; $@%0%m!<%P%kJQ?t$N@_Dj(J ;;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;; $@%F%j%H%*%jHV9f$H(JLISP$@%*%V%8%'%/%H$r4IM}$9$k%0%m!<%P%kJQ?t(J
(defvar *territory-lisp-object* nil)

;;; $@%$%Y%s%H%a%=%C%I$N%9%H%j!<%`(J
(defvar *event-method-stream* nil)

;;; $@%$%Y%s%H%a%=%C%I$N8=>u%W%m%;%9(J
(defvar *event-method-process*)

;;; $@%G%U%)%k%H%U%)%s%H(J
(defvar *DEFAULT-FONT* nil)

;;; $@>.$5$$%U%)%s%H(J
(defvar *SMALL-FONT* nil)

;;; YY $@$N%G%U%)%k%H%^%&%9%+!<%=%k(J
(defvar *DEFALUT-MOUSE-CURSOR* nil)

;;; $@8=:_$N%^%&%9%+!<%=%k(J
(defvar *SYSTEM-MOUSE-CURSOR* nil)

;;; get position $@MQ%^%&%9%+!<%=%k(J
(defvar *GET-POSITION-MOUSE-CURSOR* nil)

;;; $@8=>u$N(Jlisp$@%W%m%;%9(J
(defvar *current-lisp* nil)

;;; $@%W%m%;%94IM}%F!<%V%k(J
(defvar *yy-process-table* nil)

;;; $@=i4|%W%m%;%9$r<($9%F!<%V%k(J
(defvar *yy-initial-process* nil)

;;; $@%$%Y%s%H%k!<%W$N%W%m%;%9(J
(defvar *event-loop-process* nil)

;;; $@BT$A$N%?%0$H4X?t(J
(defvar *wait-tag-and-function-list* nil)

;;; $@%$%Y%s%H=hM}$N$?$a$NJQ?t(J
(defvar *event-packet* nil)

;;;YY$@$N%W%m%H%3%k$N%Q%1%C%H$G$"$k?t;z(J
(defparameter *YY-MAGIC-NO* 14876)

;;; $@%k!<%H%F%j%H%j$NHV9f(J
(defvar *ROOT-TERRITORY-NO* -1)

;;; $@%F%j%H%jHV9f(J
(defvar *current-territory-no* 1)

;;; $@DLCN$N4X?t(J (CMU)
(defvar *tuuchi-function* nil)

;;;;;;;;;;;;;;;;;;;
;;; YY$@$N4pK\?'(J  ;;;
;;;;;;;;;;;;;;;;;;;
;;; $@%+%i!<CM(J $@9u(J
(defvar *BLACK-COLOR* nil)
(defvar *BLACK-COLOR-NO* 0)
;;; $@%+%i!<CM(J $@Gr(J
(defvar *WHITE-COLOR* nil)
;;; $@%+%i!<CM(J $@F)L@(J
(defvar *transparent* nil)
;;; $@%+%i!<$NCM(J $@@V(J
(defvar *red-color* nil)
;;; $@%+%i!<$NCM(J $@@D(J 
(defvar *blue-color* nil)
;;; $@%+%i!<$NCM(J $@NP(J
(defvar *green-color* nil)
;;; $@%+%i!<$NCM(J $@2+?'(J
(defvar *yellow-color* nil)
;;; $@%+%i!<$NCM(J $@Cc?'(J
(defvar *brown-color* nil)
;;; $@%+%i!<$NCM(J $@;g(J
(defvar *purple-color* nil)
;;; $@%+%i!<$NCM(J $@%*%l%s%8(J
(defvar *orange-color* nil)
;;; $@%+%i!<$NCM(J $@?e?'(J
(defvar *SkyBlue-color* nil)
;;; $@%+%i!<$NCM(J $@2+NP(J
(defvar *YellowGreen-color* nil)

(defvar *event-process* nil)
(defvar *lister-process* nil)

;;; YY$@$GMxMQ$9$k%$%a!<%8(J
(defvar *image-yy* nil)
(defvar *left-bottom* nil)
(defvar *left-top* nil)
(defvar *hidari* nil)
(defvar *migi* nil)
(defvar *ue* nil)
(defvar *sita* nil)
(defvar *MARK-PAT-NO* 0)

;;; $@$^$H$a$?%W%m%H%3%k$N@)8f(J
(defvar *total-put-byte* 0)
(defvar *send-total-list* nil)
(defvar *total-send* nil)

;;; $@%j%9%W%j%9%J!<(J
(defvar *LISP-LISTENER* nil)

(defvar *prompt-window* nil)
(defvar *pop-up-menu-window* nil)

;;; $@8=:_$N%^%&%9%9%F!<%H(J
(defvar *SYSTEM-MOUSE-STATE* nil)

;;; $@%$%s%?!<%i%C%W%$%Y%s%H(J $@%$%s%?!<%J%kMQ(J
(defvar *SYSTEM-INTERRUPT-EVENT* nil)

;;; $@%k!<%H%&%#%s%I%&(J
(defvar *ROOT-WINDOW* nil)

;;; $@4A;zJQ49%&%#%s%I%&(J
(defvar *henkan-window* nil)

;;; $@%"%W%j%1!<%7%g%s%\%C%/%9%&%#%s%I%&(J
(defvar *application-box* nil)

;;; $@DLCN%W%m%;%9$KBP$7$FDd;_$rMW5a$9$k(J
(defvar *accept-tuuchi-stop* nil)

;;; $@DLCN%W%m%;%9$,Dd;_$7$?%U%i%0(J
(defvar *tuuchi-stop* nil)

;;; *STACK-SIZE*
;;; $@%9%?%C%/%5%$%:(J
#-LUCID
(DEFCONSTANT *STACK-SIZE* 50000) ; 5000Kbyte
#+LUCID
(DEFCONSTANT *STACK-SIZE* 200000) ;20000Kbyte

;;; CMU$@MQ$N3d$j9~$_KI;_>uBV%U%i%0(J
#+CMU
(defvar *with-inhibit* T)

;;; CMU$@MQ%7%0%J%k%^%9%/(J
#+CMU
(DEFCONSTANT *alam-mask* (ash 1 13))

;;; $@%Q%1%C%H$NE>Aw>uBV%U%i%0(J
(defvar *packet-sending* nil)

;;; *WHOSTATE*
;;; WHOSTATE
(DEFCONSTANT *WHOSTATE* "Wait Forever")

;;; $@@~$NC<$N7A(J
(defconstant *SQUEAR-LINE-EDGE* 1)
(defconstant *SQUEAR-LINE-EDGE-WITHOUT-END* 2)
(defconstant *ROUND-LINE-EDGE* 3)

;;; $@@~$N@\B3$N7A(J
(defconstant *SHARP-JOINT* 1)
(defconstant *ROUND-JOINT* 2)

;;; $@%*%Z%l!<%7%g%s(J
(defconstant *GCLEAR* #x00)
(defconstant *GAND*  #x01)
(defconstant *GANDREVERSE* #x02)
(defconstant *GCOPY* #x03)
(defconstant *GANDINTEVERTED* #x04)
(defconstant *GNOOP* #x05)
(defconstant *GXOR* #x06)
(defconstant *GOR* #x07)
(defconstant *GNOR* #x08)
(defconstant *GEQIV* #x09)
(defconstant *GINVERT* #x0a)
(defconstant *GORREVERSE* #x0b)
(defconstant *GCOPYINVERTED* #x0c)
(defconstant *GORINVERTED* #x0d)
(defconstant *GNAND* #x0e)
(defconstant *GSET* #x0f)

;;; $@%U%#%k%9%?%$%k(J
(defconstant *FillSolid* 0)      
(defconstant *FillTiled* 1)
(defconstant *FillOpaqueStippled* 4)

;;; $@%U%#%k$9$k$+H]$+(J
(defconstant *Fillednon* nil) 

;;; $@%U%#%k%k!<%k(J
(defconstant *EvenOddRule* 0)
(defconstant *WindingRule* 1)

;;; $@1_8L$N%b!<%I(J
(defconstant *ARCPIESLICE* 1)   ;;; $@@p7?(J
(defconstant *ARCCHORD* 0)     ;;; $@5]7?(J
      

;;; $@%^%&%9%9%F!<%H$N%Q%i%a!<%?(J    ;;;12345678123456781234567812345678 
(defconstant *mouse-right-1*      #b00000000000000000000000000000001)
(defconstant *mouse-middle-1*     #b00000000000000000000000000000010) 
(defconstant *mouse-left-1*       #b00000000000000000000000000000100) 
(defconstant *mouse-right-up*     #b00000000000000000000000000001000) 
(defconstant *mouse-middle-up*    #b00000000000000000000000000010000) 
(defconstant *mouse-left-up*      #b00000000000000000000000000100000) 
(defconstant *mouse-move*         #b00000000000000000000000001000000) 
(defconstant *mouse-in*           #b00000000000000000000000010000000) 
(defconstant *mouse-out*          #b00000000000000000000000100000000) 
(defconstant *mouse-wait*         #b00000000000000000000001000000000) 
(defconstant *mouse-right-2*      #b00000000000000000000010000000000) 
(defconstant *mouse-middle-2*     #b00000000000000000000100000000000) 
(defconstant *mouse-left-2*       #b00000000000000000001000000000000) 
(defconstant *interrupt*          #b00000000000000010000000000000000) 
(defconstant *meta*               #b00000001000000000000000000000000) 
(defconstant *control*            #b00000010000000000000000000000000) 
(defconstant *shift*              #b00000100000000000000000000000000)

;;; $@%7%U%H%-!<!"%3%s%H%m!<%k%-!<!"%a%?%-!<$r2!2<$7$J$,$i%^%&%9$,F0$/(J
(defconstant *shift-mouse-move* (logior *shift* *mouse-move*))
(defconstant *shift-control-mouse-move* (logior *shift* *mouse-move* *control*))
(defconstant *shift-meta-mouse-move* (logior *shift* *mouse-move* *meta*))
(defconstant *meta-mouse-move* (logior *meta* *mouse-move* ))
(defconstant *control-mouse-move* (logior *control* *mouse-move*))


;;; $@%7%U%H%-!<!"%3%s%H%m!<%k%-!<!"%a%?%-!<$r2!2<$7$J$,$i%^%&%9$,BT$D(J
(defconstant *shift-mouse-wait* (logior *shift* *mouse-wait*))
(defconstant *shift-control-mouse-wait* (logior *shift* *mouse-wait* *control*))
(defconstant *shift-meta-mouse-wait* (logior *shift* *mouse-wait* *meta*))
(defconstant *meta-mouse-wait* (logior *meta* *mouse-wait* ))
(defconstant *control-mouse-wait* (logior *control* *mouse-wait*))


;;; $@%7%U%H%-!<!"%3%s%H%m!<%k%-!<!"%a%?%-!<$r2!2<$7$J$,$i%^%&%9$,F~$k(J
(defconstant *shift-mouse-in* (logior *shift* *mouse-in*))
(defconstant *shift-control-mouse-in* (logior *shift* *mouse-in* *control*))
(defconstant *shift-meta-mouse-in* (logior *shift* *mouse-in* *meta*))
(defconstant *meta-mouse-in* (logior *meta* *mouse-in* ))
(defconstant *control-mouse-in* (logior *control* *mouse-in*))


;;; $@%7%U%H%-!<!"%3%s%H%m!<%k%-!<!"%a%?%-!<$r2!2<$7$J$,$i%^%&%9$,=P$k(J
(defconstant *shift-mouse-out* (logior *shift* *mouse-out*))
(defconstant *shift-control-mouse-out* (logior *shift* *mouse-out* *control*))
(defconstant *shift-meta-mouse-out* (logior *shift* *mouse-out* *meta*))
(defconstant *meta-mouse-out* (logior *meta* *mouse-out* ))
(defconstant *control-mouse-out* (logior *control* *mouse-out*))


;;; $@%7%U%H%-!<!"%3%s%H%m!<%k%-!<!"%a%?%-!<$r2!2<$7$J$,$i%^%&%9%/%j%C%/(J
(defconstant *shift-mouse-left-1*  (logior *shift* *mouse-left-1*))
(defconstant *shift-mouse-midle-1* (logior *shift* *mouse-middle-1*))
(defconstant *shift-mouse-right-1* (logior *shift* *mouse-right-1*))
(defconstant *meta-mouse-left-1*   (logior *meta* *mouse-left-1*))
(defconstant *meta-mouse-middle-1* (logior *meta* *mouse-middle-1*))
(defconstant *meta-mouse-right-1*  (logior *meta* *mouse-right-1*))
(defconstant *control-mouse-left-1*   (logior *control* *mouse-left-1*))
(defconstant *control-mouse-middle-1* (logior *control* *mouse-middle-1*))
(defconstant *control-mouse-right-1*  (logior *control* *mouse-right-1*))
(defconstant *shift-control-mouse-left-1*  (logior *shift* *control-mouse-left-1*))
(defconstant *shift-control-mouse-middle-1*  (logior *shift* *control-mouse-middle-1*))
(defconstant *shift-control-mouse-right-1*   (logior *shift* *control-mouse-right-1*))
(defconstant *shift-meta-mouse-left-1*   (logior *shift* *meta-mouse-left-1*))
(defconstant *shift-meta-mouse-middle-1* (logior *shift* *meta-mouse-middle-1*))
(defconstant *shift-meta-mouse-right-1*  (logior *shift* *meta-mouse-right-1*))


;;; $@%\%?%s$r2!2<$7$J$,$iF0$/(J
(defconstant *mouse-move-while-mouse-right-1* (logior *mouse-right-1* *mouse-move*))
(defconstant *mouse-move-while-mouse-middle-1*  (logior *mouse-middle-1* *mouse-move*))
(defconstant *mouse-move-while-mouse-left-1*    (logior *mouse-left-1* *mouse-move*))
(defconstant *mouse-move-while-shift-mouse-left-1* 
  (logior *shift* *mouse-left-1* *mouse-move* ))
(defconstant *mouse-move-while-shift-mouse-middle-1* 
  (logior *shift* *mouse-middle-1* *mouse-move* ))
(defconstant *mouse-move-while-shift-mouse-right-1* 
  (logior *shift* *mouse-right-1* *mouse-move* ))
(defconstant *mouse-move-while-meta-mouse-left-1*   
  (logior *meta* *mouse-left-1* *mouse-move* ))
(defconstant *mouse-move-while-meta-mouse-middle-1* (logior *meta* *mouse-middle-1* *mouse-move* ))
(defconstant *mouse-move-while-meta-mouse-right-1*  (logior *meta* *mouse-right-1* *mouse-move* ))
(defconstant *mouse-move-while-control-mouse-left-1*   
  (logior *control* *mouse-left-1* *mouse-move* ))
(defconstant *mouse-move-while-control-mouse-middle-1* 
  (logior *control* *mouse-middle-1* *mouse-move* ))
(defconstant *mouse-move-while-control-mouse-right-1*  
  (logior *control* *mouse-right-1* *mouse-move* ))
(defconstant *mouse-move-while-shift-control-mouse-left-1*  
  (logior *shift* *control-mouse-left-1* *mouse-move* ))
(defconstant *mouse-move-while-shift-control-mouse-middle-1*  
  (logior *shift* *control-mouse-middle-1* *mouse-move* ))
(defconstant *mouse-move-while-shift-control-mouse-right-1*   
  (logior *shift* *control-mouse-right-1* *mouse-move* ))
(defconstant *mouse-move-while-shift-meta-mouse-left-1*   
  (logior *shift* *meta-mouse-left-1* *mouse-move* ))
(defconstant *mouse-move-while-shift-meta-mouse-middle-1* 
  (logior *shift* *meta-mouse-middle-1* *mouse-move* ))
(defconstant *mouse-move-while-shift-meta-mouse-right-1*  
  (logior *shift* *meta-mouse-right-1* *mouse-move* ))

;;; $@%\%?%s$r2!2<$7$J$,$iBT$D(J
(defconstant *mouse-wait-while-mouse-right-1* (logior *mouse-right-1* *mouse-wait*))
(defconstant *mouse-wait-while-mouse-middle-1*  (logior *mouse-middle-1* *mouse-wait*))
(defconstant *mouse-wait-while-mouse-left-1*    (logior *mouse-left-1* *mouse-wait*))
(defconstant *mouse-wait-while-shift-mouse-left-1* 
  (logior *shift* *mouse-left-1* *mouse-wait* ))
(defconstant *mouse-wait-while-shift-mouse-middle-1* 
  (logior *shift* *mouse-middle-1* *mouse-wait* ))
(defconstant *mouse-wait-while-shift-mouse-right-1* 
  (logior *shift* *mouse-right-1* *mouse-wait* ))
(defconstant *mouse-wait-while-meta-mouse-left-1*   
  (logior *meta* *mouse-left-1* *mouse-wait* ))
(defconstant *mouse-wait-while-meta-mouse-middle-1* (logior *meta* *mouse-middle-1* *mouse-wait* ))
(defconstant *mouse-wait-while-meta-mouse-right-1*  (logior *meta* *mouse-right-1* *mouse-wait* ))
(defconstant *mouse-wait-while-control-mouse-left-1*   
  (logior *control* *mouse-left-1* *mouse-wait* ))
(defconstant *mouse-wait-while-control-mouse-middle-1* 
  (logior *control* *mouse-middle-1* *mouse-wait* ))
(defconstant *mouse-wait-while-control-mouse-right-1*  
  (logior *control* *mouse-right-1* *mouse-wait* ))
(defconstant *mouse-wait-while-shift-control-mouse-left-1*  
  (logior *shift* *control-mouse-left-1* *mouse-wait* ))
(defconstant *mouse-wait-while-shift-control-mouse-middle-1*  
  (logior *shift* *control-mouse-middle-1* *mouse-wait* ))
(defconstant *mouse-wait-while-shift-control-mouse-right-1*   
  (logior *shift* *control-mouse-right-1* *mouse-wait* ))
(defconstant *mouse-wait-while-shift-meta-mouse-left-1*   
  (logior *shift* *meta-mouse-left-1* *mouse-wait* ))
(defconstant *mouse-wait-while-shift-meta-mouse-middle-1* 
  (logior *shift* *meta-mouse-middle-1* *mouse-wait* ))
(defconstant *mouse-wait-while-shift-meta-mouse-right-1*  
  (logior *shift* *meta-mouse-right-1* *mouse-wait* ))

;;; $@%\%?%s$r2!2<$7$J$,$iF~$k(J
(defconstant *mouse-in-while-mouse-right-1* (logior *mouse-right-1* *mouse-in*))
(defconstant *mouse-in-while-mouse-middle-1*  (logior *mouse-middle-1* *mouse-in*))
(defconstant *mouse-in-while-mouse-left-1*    (logior *mouse-left-1* *mouse-in*))
(defconstant *mouse-in-while-shift-mouse-left-1* 
  (logior *shift* *mouse-left-1* *mouse-in* ))
(defconstant *mouse-in-while-shift-mouse-middle-1* 
  (logior *shift* *mouse-middle-1* *mouse-in* ))
(defconstant *mouse-in-while-shift-mouse-right-1* 
  (logior *shift* *mouse-right-1* *mouse-in* ))
(defconstant *mouse-in-while-meta-mouse-left-1*   
  (logior *meta* *mouse-left-1* *mouse-in* ))
(defconstant *mouse-in-while-meta-mouse-middle-1* (logior *meta* *mouse-middle-1* *mouse-in* ))
(defconstant *mouse-in-while-meta-mouse-right-1*  (logior *meta* *mouse-right-1* *mouse-in* ))
(defconstant *mouse-in-while-control-mouse-left-1*   
  (logior *control* *mouse-left-1* *mouse-in* ))
(defconstant *mouse-in-while-control-mouse-middle-1* 
  (logior *control* *mouse-middle-1* *mouse-in* ))
(defconstant *mouse-in-while-control-mouse-right-1*  
  (logior *control* *mouse-right-1* *mouse-in* ))
(defconstant *mouse-in-while-shift-control-mouse-left-1*  
  (logior *shift* *control-mouse-left-1* *mouse-in* ))
(defconstant *mouse-in-while-shift-control-mouse-middle-1*  
  (logior *shift* *control-mouse-middle-1* *mouse-in* ))
(defconstant *mouse-in-while-shift-control-mouse-right-1*   
  (logior *shift* *control-mouse-right-1* *mouse-in* ))
(defconstant *mouse-in-while-shift-meta-mouse-left-1*   
  (logior *shift* *meta-mouse-left-1* *mouse-in* ))
(defconstant *mouse-in-while-shift-meta-mouse-middle-1* 
  (logior *shift* *meta-mouse-middle-1* *mouse-in* ))
(defconstant *mouse-in-while-shift-meta-mouse-right-1*  
  (logior *shift* *meta-mouse-right-1* *mouse-in* ))

;;; $@%\%?%s$r2!2<$7$J$,$i=P$k(J
(defconstant *mouse-out-while-mouse-right-1* (logior *mouse-right-1* *mouse-out*))
(defconstant *mouse-out-while-mouse-middle-1*  (logior *mouse-middle-1* *mouse-out*))
(defconstant *mouse-out-while-mouse-left-1*    (logior *mouse-left-1* *mouse-out*))
(defconstant *mouse-out-while-shift-mouse-left-1* 
  (logior *shift* *mouse-left-1* *mouse-out* ))
(defconstant *mouse-out-while-shift-mouse-middle-1* 
  (logior *shift* *mouse-middle-1* *mouse-out* ))
(defconstant *mouse-out-while-shift-mouse-right-1* 
  (logior *shift* *mouse-right-1* *mouse-out* ))
(defconstant *mouse-out-while-meta-mouse-left-1*   
  (logior *meta* *mouse-left-1* *mouse-out* ))
(defconstant *mouse-out-while-meta-mouse-middle-1* (logior *meta* *mouse-middle-1* *mouse-out* ))
(defconstant *mouse-out-while-meta-mouse-right-1*  (logior *meta* *mouse-right-1* *mouse-out* ))
(defconstant *mouse-out-while-control-mouse-left-1*   
  (logior *control* *mouse-left-1* *mouse-out* ))
(defconstant *mouse-out-while-control-mouse-middle-1* 
  (logior *control* *mouse-middle-1* *mouse-out* ))
(defconstant *mouse-out-while-control-mouse-right-1*  
  (logior *control* *mouse-right-1* *mouse-out* ))
(defconstant *mouse-out-while-shift-control-mouse-left-1*  
  (logior *shift* *control-mouse-left-1* *mouse-out* ))
(defconstant *mouse-out-while-shift-control-mouse-middle-1*  
  (logior *shift* *control-mouse-middle-1* *mouse-out* ))
(defconstant *mouse-out-while-shift-control-mouse-right-1*   
  (logior *shift* *control-mouse-right-1* *mouse-out* ))
(defconstant *mouse-out-while-shift-meta-mouse-left-1*   
  (logior *shift* *meta-mouse-left-1* *mouse-out* ))
(defconstant *mouse-out-while-shift-meta-mouse-middle-1* 
  (logior *shift* *meta-mouse-middle-1* *mouse-out* ))
(defconstant *mouse-out-while-shift-meta-mouse-right-1*  
  (logior *shift* *meta-mouse-right-1* *mouse-out* ))

;;; $@%7%U%H%-!<!"%3%s%H%m!<%k%-!<!"%a%?%-!<$r2!2<$7$J$,$i%^%&%9%@%V%k%/%j%C%/(J
(defconstant *shift-mouse-left-2*    (logior *shift* *mouse-left-2*))
(defconstant *shift-mouse-middle-2*   (logior *shift* *mouse-middle-2*))
(defconstant *shift-mouse-right-2*   (logior *shift* *mouse-right-2*))
(defconstant *meta-mouse-left-2*     (logior *meta* *mouse-left-2*))
(defconstant *meta-mouse-middle-2*   (logior *meta* *mouse-middle-2*))
(defconstant *meta-mouse-right-2*    (logior *meta* *mouse-right-2*))
(defconstant *control-mouse-left-2*  (logior *control* *mouse-left-2*))
(defconstant *control-mouse-middle-2* (logior *control* *mouse-middle-2*))
(defconstant *control-mouse-right-2*  (logior *control* *mouse-right-2*))
(defconstant *shift-control-mouse-left-2*    (logior *shift* *control-mouse-left-2*))
(defconstant *shift-control-mouse-middle-2*  (logior *shift* *control-mouse-middle-2*))
(defconstant *shift-control-mouse-right-2*   (logior *shift* *control-mouse-right-2*))
(defconstant *shift-meta-mouse-left-2*    (logior *shift* *meta-mouse-left-2*))
(defconstant *shift-meta-mouse-middle-2*  (logior *shift* *meta-mouse-middle-2*))
(defconstant *shift-meta-mouse-right-2*   (logior *shift* *meta-mouse-right-2*))

;;; $@%7%U%H%-!<!"%3%s%H%m!<%k%-!<!"%a%?%-!<$r2!2<$7$J$,$i%^%&%9$,N%$5$l$?(J
(defconstant *shift-mouse-left-up*     (logior *shift* *mouse-left-up*))
(defconstant *shift-mouse-middle-up*    (logior *shift* *mouse-middle-up*))
(defconstant *shift-mouse-right-up*    (logior *shift* *mouse-right-up*))
(defconstant *meta-mouse-left-up*      (logior *meta* *mouse-left-up*))
(defconstant *meta-mouse-middle-up*    (logior *meta* *mouse-middle-up*))
(defconstant *meta-mouse-right-up*     (logior *meta* *mouse-right-up*))
(defconstant *control-mouse-left-up*   (logior *control* *mouse-left-up*))
(defconstant *control-mouse-middle-up* (logior *control* *mouse-middle-up*))
(defconstant *control-mouse-right-up*  (logior *control* *mouse-right-up*))
(defconstant *shift-control-mouse-left-up*    (logior *shift* *control-mouse-left-up*))
(defconstant *shift-control-mouse-middle-up*  (logior *shift* *control-mouse-middle-up*))
(defconstant *shift-control-mouse-right-up*   (logior *shift* *control-mouse-right-up*))
(defconstant *shift-meta-mouse-left-up*     (logior *shift* *meta-mouse-left-up*))
(defconstant *shift-meta-mouse-middle-up*   (logior *shift* *meta-mouse-middle-up*))
(defconstant *shift-meta-mouse-right-up*    (logior *shift* *meta-mouse-right-up*))

;;; $@%\%?%s%9%F!<%H$N0lHL(J
(defconstant *mouse-button-down-1* (logior  *mouse-right-1* *mouse-left-1*
				           *mouse-middle-1*))
(defconstant *mouse-move-while-button-down-1* (logior *mouse-button-down-1* *mouse-move*))
(defconstant *mouse-wait-while-button-down-1* (logior *mouse-button-down-1* *mouse-wait*))
(defconstant *mouse-in-while-button-down-1* (logior *mouse-button-down-1* *mouse-in*))
(defconstant *mouse-out-while-button-down-1* (logior *mouse-button-down-1* *mouse-out*))

(defconstant *mouse-button-down-2* (logior  *mouse-right-2* *mouse-left-2*
                                           *mouse-middle-2*))

(defconstant *mouse-button-up* (logior *mouse-right-up* *mouse-middle-up*
				      *mouse-left-up*))

(defconstant *mouse-none* 0)

;;; $@%+%i!<$N$?$a$NJQ?t(J
(defvar *all-colors* nil)

;;; $@DL?.9=B$BN$N@_Dj(J
;;;; $@%5!<%P!<$H$N@\B3>pJs(J
(defstruct yy-server-connection
  yy-version yy-release-no yy-responce-no
  yy-ntime yy-width yy-height yy-label)

;;; $@F~NO%^%9%/%F!<%V%k(J
(defvar *default-input-mask-table*
  ;;;$@%3!<%I(J   $@%3%^%s%I(J
  '(( 16 .   delete-text) (8 . back-space-text) (1 . top-buffer-text) (5 . end-buffer-text)
    (6 . next-cursor-text) (2 . before-cursor-text) (11 . delete-after-text)
    (0 . kana-kanji)))






