;;; -*- Mode: LISP; Syntax: Common-lisp; Package: YY; Base: 10 -*-
;;;
;;;  Copyright (C) 1989,1990,1991 Aoyama Gakuin University
;;;
;;;		All Rights Reserved
;;;
;;; This software is developed for the YY project of Aoyama Gakuin University.
;;; Permission to use, copy, modify, and distribute this software
;;; and its documentation for any purpose and without fee is hereby granted,
;;; provided that the above copyright notices appear in all copies and that
;;; both that copyright notice and this permission notice appear in 
;;; supporting documentation, and that the name of Aoyama Gakuin
;;; not be used in advertising or publicity pertaining to distribution of
;;; the software without specific, written prior permission.
;;;
;;; This software is made available AS IS, and Aoyama Gakuin makes no
;;; warranty about the software, its performance or its conformity to
;;; any specification. 
;;;
;;; To make a contact: Send E-mail to ida@csrl.aoyama.ac.jp for overall
;;; issues. To ask specific questions, send to the individual authors at
;;; csrl.aoyama.ac.jp. To request a mailing list, send E-mail to 
;;; yyonx-request@csrl.aoyama.ac.jp.
;;;
;;; Authors:
;;;   version 1.0 90/06/01 by t.kosaka (kosaka@csrl.aoyama.ac.jp)
;;;   version 1.1 90/07/31 by t.kosaka
;;;   update 1.11 90/09/14 by t.kosaka
;;;   version 1.2 90/11/05 by t.kosaka

;;; $@%&%#%s%I%&%9%H%j!<%`$N%"%/%;%5%j!<(J
;;; 3/128 1990 $@8E:d(J
;;; Version 1.0   Coded by t.kosaka 1990-3-13

(in-package :yy)


(defparameter *SCROLL-MOVE-STEP* 10)


;;; Y$@%*%U%;%C%H$r5a$a$k(J
(defun get-new-y-offset-internal (y world-height vscroll-height)
  (declare (inline round / *) 
	   (optimize (compilation-speed 0) (speed 3) (safety 0)))
  (round (/ (* y world-height) vscroll-height)))


;;; X$@%*%U%;%C%H$r5a$a$k(J
(defun get-new-x-offset-internal (x world-width hscroll-width)
  (declare (inline round / *)
	   (optimize (compilation-speed 0) (speed 3) (safety 0)))
  (round (/ (* x world-width) hscroll-width)))


;;;$@%9%/%m!<%k%a%=%C%I:8%\%?%s(J INTERNAL $@>e$K0\F0(J
(defun vertical-scroll-left-internal (window 
				     x y
				     &optional event-type)

  (declare (inline + - / *)
		   (ignore event-type x y)
		   (optimize (compilation-speed 0) (speed 3) (safety 0)))

  (let* ((s-height (region-height (vertical-scroll-region window)))
	 (w-height (region-height window))
	 (offset (round (/ (* (world-y-offset window) s-height) w-height)))

	 (co-style (class-name (class-of
				(stream-translate-coordinate window)))))

    (if (eq co-style 'translate-coordinate-left-bottom)
	(scroll window (world-x-offset window) 
	   (get-new-y-offset-internal (+ offset *scroll-move-step*)
				      w-height s-height))
      (scroll window (world-x-offset window)
	       (get-new-y-offset-internal (- offset *scroll-move-step*)
					    w-height s-height))
	   )
))
  

;;; $@%9%/%m!<%k%a%=%C%I1&%\%?%s(J INTERNAL $@2<$K0\F0(J
(defun vertical-scroll-right-internal (window x y
					   &optional event-type)
  (declare (inline round / * + -)
		   (ignore event-type x y)
		   (optimize (compilation-speed 0) (speed 3) (safety 0)))
  (let* ((s-height (region-height (vertical-scroll-region window)))
	 (w-height (region-height window))
	 (offset (round (/ (* (world-y-offset window) s-height) w-height)))

	 (co-style (class-name (class-of
				(stream-translate-coordinate window)))))

    (if (eq co-style 'translate-coordinate-left-bottom)
	(scroll window (world-x-offset window) 
	  (get-new-y-offset-internal (- offset *scroll-move-step*)
				      w-height s-height))
      (scroll window (world-x-offset window)
	      (get-new-y-offset-internal (+ offset *scroll-move-step*)
					    w-height s-height))
	   )))				;Removed extra close parenthis
  

;;; $@%9%/%m!<%k%a%=%C%ICf%\%?%s(J INTERNAL $@;XDj$5$l$?0LCV$K0\F0(J
(defun vertical-scroll-middle-internal (window x y
                                           &optional event-type)
  (declare (inline round / * + -)
	   (ignore event-type x)
	   (optimize (compilation-speed 0) (speed 3) (safety 0)))
   (let* ((s-height (region-height (vertical-scroll-region window)))
          (w-height (region-height window))
          (v-height (region-height (frame-region window)))
          (vh (round (/ (* s-height v-height) w-height)))
	  (new-y (- y (round (/ vh 2)))))

       (scroll window (world-x-offset window) 
	     (- (get-new-y-offset-internal new-y w-height s-height)))
     ))

;;; $@%\%?%s$,2!2<$5$l$J$,$iF0$$$?(J
(defun vertical-scroll-move-internal (window x y &optional event-type)
  (declare (inline round / * - abs)
		   (ignore x)
	   (optimize (compilation-speed 0) (speed 3) (safety 0)))
  ;;; $@Cf%\%?%s$,2!2<$5$l$?$+D4$Y$k(J
  (if (eq *mouse-move-while-mouse-middle-1*  event-type)
   (let* ((s-height (region-height (vertical-scroll-region window)))
          (w-height (region-height window))
          (v-height (region-height (frame-region window)))
          (vh (round (/ (* s-height v-height) w-height)))
	  (new-y (- y (round (/ vh 2))))
	  (offset (- (get-new-y-offset-internal new-y w-height s-height))))
     
	 ;;; $@0\F05wN%$rD4$Y$k(J
      (if (> (abs offset) *SCROLL-MOVE-STEP*)
	     (scroll window (world-x-offset window) offset)))
       ))


;;;$@%9%/%m!<%k%a%=%C%I:8%\%?%s(J INTERNAL $@:8$K0\F0(J
(defun horizontal-scroll-left-internal (window x y &optional event-type)
  (declare (inline round / * -)
		   (ignore event-type x y)
		   (optimize (compilation-speed 0) (speed 3) (safety 0)))
  (let* ((s-width (region-width (horizontal-scroll-region window)))
	 (w-width (region-width window))
	 (offset (round (/ (* (world-x-offset window) s-width) w-width))))
   (scroll window  (get-new-x-offset-internal (- offset *scroll-move-step*)
			       w-width s-width)
	   (world-y-offset window))
   ))

;;; $@%9%/%m!<%k%a%=%C%I1&%\%?%s(J INTERNAL $@1&$K0\F0(J
(defun horizontal-scroll-right-internal (window x y &optional event-type)
  (declare (inline round / * +)
		   (ignore event-type x y)
		   (optimize (compilation-speed 0) (speed 3) (safety 0)))
  (let* ((s-width (region-width (horizontal-scroll-region window)))
	 (w-width (region-width window))
	 (offset (round (/ (* (world-x-offset window) s-width) w-width))))
   (scroll window (get-new-x-offset-internal (+ offset *scroll-move-step*)
					      w-width s-width)
	   (world-y-offset window))
  ))

;;; $@%9%/%m!<%k%a%=%C%ICf%\%?%s(J INTERNAL $@;XDj$5$l$?0LCV$K0\F0(J
(defun horizontal-scroll-middle-internal (window x y &optional event-type)
  (declare (inline round / * -)
		   (ignore event-type y)
		   (optimize (compilation-speed 0) (speed 3) (safety 0)))
   (let* ((s-width (region-width (horizontal-scroll-region window)))
          (w-width (region-width window))
          (v-width (region-width (frame-region window)))
          (vw (round (/ (* s-width v-width) w-width)))
	  (new-x (- x (round (/ vw 2)))))

     (scroll window (- (get-new-x-offset-internal new-x w-width s-width))
	     (world-y-offset window))
     ))

;;; $@%\%?%s$,2!2<$5$l$J$,$iF0$$$?(J
(defun horizontal-scroll-move-internal (window x y &optional event-type)
  (declare (inline round / * -)
		   (ignore y)
		   (optimize (compilation-speed 0) (speed 3) (safety 0)))
  ;;; $@Cf%\%?%s$,2!2<$5$l$?$+D4$Y$k(J
  (if (eq *mouse-move-while-mouse-middle-1*  event-type)
       (let* ((s-width (region-width (horizontal-scroll-region window)))
	      (w-width (region-width window))
	      (v-width (region-width (frame-region window)))
	      (vw (round (/ (* s-width v-width) w-width)))
	      (new-x (- x (round (/ vw 2))))
	      (offset (- (get-new-x-offset-internal new-x w-width s-width))))

	 ;;; $@0\F05wN%$rD4$Y$k(J
	 (if (> (abs offset) *SCROLL-MOVE-STEP*)
	     (scroll window offset (world-y-offset window))))
       ))


;;; $@%j%9%W%j%9%J!<(J 
(defun yy-lisp-listener (stream)
  (declare (optimize (compilation-speed 0) (speed 3) (safety 0)))
  (yy-top-level stream))


(defmethod yy-top-level ((stream window-stream))
  (declare (optimize (compilation-speed 0) (speed 3) (safety 0)))
  (let ((+ nil) (++ nil) (+++ nil)
		(* nil) (** nil) (*** nil) (ret2 nil))
    (select-window stream)
    (tagbody listener-top-level 
      (loop
	(write-string "> " stream)
	(force-output stream)
	(setf +++ +)
	(setf ++ +)
	(setf + (read stream))
	(setf *** **)
	(setf ** *)
	(setf ret2 (second (multiple-value-list
						(yy-ignore-errors
						 (setf * (eval +))))))
	(if ret2
		(unwind-protect (eval +)
		  (progn (terpri stream) (force-output stream)
				 (go listener-top-level)))))
	
	  (terpri stream)
	  (write-string (write-to-string *) stream)
	  (terpri stream)
	  (force-output stream)
	)))
	  
    


