;;; -*- Mode: LISP; Package: YY-GEO; Syntax: Common-Lisp; Base: 10 -*-
(in-package :yy-geo)

;;; Modify Model Object Function

(defmethod extrude ((face face) vector)
  (declare (optimize (compilation-speed 0) (speed 3) (safety 0))
	   (values polyhedron))
  (with-slots (polyhedron vertices edges) face
    (let ((length (length vertices))
	  (new-vertices
	    (mapcar #'(lambda (x)
			(make-vertex-from-previous-vector x vector))
		    vertices)))
      (let ((new-edges nil))
	(dotimes (pos length)
	  (let ((pos+1 (+ 1 pos)))
	    (let ((v1 (nth-with-ring pos vertices length))
		  (v2 (nth-with-ring pos+1 vertices length))
		  (p1 (nth-with-ring pos new-vertices length))
		  (p2 (nth-with-ring pos+1 new-vertices length)))
	      (push (make-edge polyhedron p2 p1) new-edges)
	      (make-square-from-vertices polyhedron v1 v2 p2 p1)
	      )))
	(setf new-edges (reverse new-edges))
	(dotimes (pos length)
	  (set-right-parts-from-vertex
	    (nth-with-ring pos new-edges length)
	    (nth-with-ring pos new-vertices length)
	    (nth-with-ring (+ pos 1) new-edges length)
	    face
	    (nth-with-ring (- pos 1) new-edges length)))
	(setf vertices new-vertices
	      edges new-edges))
      (changed-object face))
    polyhedron))



(defmethod cut2 ((edge edge))
  (declare (optimize (compilation-speed 0) (speed 3) (safety 0))
	   (values polyhedron))
  (with-slots (polyhedron
		head tail left-face right-face
		for-wing back-wing ccw-for-wing ccw-back-wing) edge
    (let ((new-x (/ (+ (vertex-x head) (vertex-x tail)) 2))
	  (new-y (/ (+ (vertex-y head) (vertex-y tail)) 2))
	  (new-z (/ (+ (vertex-z head) (vertex-z tail)) 2)))
      (let ((new-vertex (make-vertex polyhedron new-x new-y new-z)))
	(let ((new-edge (make-edge polyhedron new-vertex tail)))
	  (with-slots (vertices edges) left-face
	    (setf vertices (insert-between vertices head tail new-vertex))
	    (push new-edge edges)
	    (changed-object left-face))
	  (with-slots (vertices edges) right-face
	    (setf vertices (insert-between vertices head tail new-vertex))
	    (push new-edge edges)
	    (changed-object right-face))
	  (with-slots  ((new-head head)(new-tail tail)
			(new-left-face left-face) (new-right-face right-face)
			(new-for-wing for-wing) (new-back-wing back-wing)
			(new-ccw-for-wing ccw-for-wing) (new-ccw-back-wing ccw-back-wing))
		       new-edge
	    (setf new-left-face left-face
		  new-right-face right-face
		  new-for-wing edge
		  new-ccw-for-wing edge
		  new-back-wing back-wing
		  new-ccw-back-wing ccw-back-wing))
	  (replace-edge back-wing edge new-edge)
	  (replace-edge ccw-back-wing edge new-edge)
	  (setf back-wing new-edge
		ccw-back-wing new-edge
		tail new-vertex))))
    (changed-object edge)
    polyhedron))

(defmethod cut3 ((edge edge))
  (declare (optimize (compilation-speed 0) (speed 3) (safety 0))
	   (values polyhedron))
  (with-slots (polyhedron
		head tail left-face right-face
		for-wing back-wing ccw-for-wing ccw-back-wing) edge
    (let* ((new-head-x (/ (+ (* 2 (vertex-x head)) (vertex-x tail)) 3))
	   (new-head-y (/ (+ (* 2 (vertex-y head)) (vertex-y tail)) 3))
	   (new-head-z (/ (+ (* 2 (vertex-z head)) (vertex-z tail)) 3))
	   (new-head-vertex (make-vertex polyhedron new-head-x new-head-y new-head-z))
	   (new-head-edge (make-edge polyhedron head new-head-vertex)))
      (let* ((new-tail-x (/ (+ (vertex-x head) (* 2 (vertex-x tail))) 3))
	     (new-tail-y (/ (+ (vertex-y head) (* 2 (vertex-y tail))) 3))
	     (new-tail-z (/ (+ (vertex-z head) (* 2 (vertex-z tail))) 3))
	     (new-tail-vertex (make-vertex polyhedron new-tail-x new-tail-y new-tail-z))
	     (new-tail-edge (make-edge polyhedron new-tail-vertex tail)))
	(with-slots (vertices edges) left-face
	  (setf vertices (insert-between vertices head tail new-head-vertex))
	  (setf vertices (insert-between vertices new-head-vertex tail new-tail-vertex))
	  (push new-head-edge edges)
	  (push new-tail-edge edges)
	  (changed-object left-face))
	(with-slots (vertices edges) right-face
	  (setf vertices (insert-between vertices head tail new-head-vertex))
	  (setf vertices (insert-between vertices new-head-vertex tail new-tail-vertex))
	  (push new-head-edge edges)
	  (push new-tail-edge edges)
	  (changed-object right-face))
	(with-slots  ((new-head head)(new-tail tail)
		      (new-left-face left-face) (new-right-face right-face)
		      (new-for-wing for-wing) (new-back-wing back-wing)
		      (new-ccw-for-wing ccw-for-wing) (new-ccw-back-wing ccw-back-wing))
		     new-head-edge
	  (setf new-left-face left-face
		new-right-face right-face
		new-for-wing for-wing
		new-ccw-for-wing ccw-for-wing
		new-back-wing edge
		new-ccw-back-wing edge))
	(with-slots  ((new-head head)(new-tail tail)
		      (new-left-face left-face) (new-right-face right-face)
		      (new-for-wing for-wing) (new-back-wing back-wing)
		      (new-ccw-for-wing ccw-for-wing) (new-ccw-back-wing ccw-back-wing))
		     new-tail-edge
	  (setf new-left-face left-face
		new-right-face right-face
		new-for-wing edge
		new-ccw-for-wing edge
		new-back-wing back-wing
		new-ccw-back-wing ccw-back-wing))
	(replace-edge back-wing edge new-tail-edge)
	(replace-edge ccw-back-wing edge new-tail-edge)
	(setf back-wing new-tail-edge
	      ccw-back-wing new-tail-edge
	      for-wing new-head-edge
	      ccw-for-wing new-head-edge
	      head new-head-vertex
	      tail new-tail-vertex)))
    (changed-object edge)
    polyhedron))



(defmethod lift-edge ((face face) (edge edge) (vector list))
  (declare (optimize (compilation-speed 0) (speed 3) (safety 0))
	   (values polyhedron))
  (with-slots (polyhedron vertices edges) face
    (with-slots (head tail left-face right-face
		      for-wing back-wing ccw-for-wing ccw-back-wing) edge
      (let ((new-head (make-vertex-from-previous-vector head vector))
	    (new-tail (make-vertex-from-previous-vector tail vector))
	    vertex1 vertex2)
	(cond ((eq face right-face)
	       (with-slots ((hh head) (tt tail)) for-wing
		 (setf vertex1 (if (eql head hh) tt hh)))
	       (with-slots ((hh head) (tt tail)) ccw-back-wing
		 (setf vertex2 (if (eql tail hh) tt hh))))
	      ((eq face left-face)
	       (with-slots ((hh head) (tt tail)) ccw-for-wing
		 (setf vertex1 (if (eql head hh) tt hh)))
	       (with-slots ((hh head) (tt tail)) back-wing
		 (setf vertex2 (if (eql tail hh) tt hh)))))		 
	(let ((new-edge (make-edge polyhedron new-head new-tail))
	      (new-head-lift (make-edge polyhedron new-head vertex1))
	      (new-tail-lift (make-edge polyhedron new-tail vertex2)))
	  (cond ((eq face left-face)
		 (make-square-from-vertices polyhedron head tail new-tail new-head)
		 (make-triangle-from-vertices polyhedron head new-head vertex1)
		 (make-triangle-from-vertices polyhedron new-tail tail vertex2)
;;		 (set-right-parts-from-vertex e1 new-head e2 face e3)
;;		 (set-right-parts-from-vertex e1 new-tail e2 face e3)
		 )
		((eq face right-face)
		 (make-square-from-vertices polyhedron tail head new-head new-tail)
		 (make-triangle-from-vertices polyhedron new-head head vertex1)
		 (make-triangle-from-vertices polyhedron tail new-tail vertex2)
;;		 (set-right-parts-from-vertex e1 new-head e2 face e4)
;;		 (set-right-parts-from-vertex e1 new-tail e2 face e4)
		 )
		(t :error))
	  (replacing-item vertices head new-head)
	  (replacing-item vertices tail new-tail)
	  (replacing-item edges edge new-edge)
	  (replacing-item edges (segment-between polyhedron head vertex1) new-head-lift)
	  (replacing-item edges (segment-between polyhedron tail vertex2) new-tail-lift)
	  (changed-object face)
	  new-edge)))))

(defmethod collapse ((face face))
  (declare (optimize (compilation-speed 0) (speed 3) (safety 0))
	   (values polyhedron))
  (with-slots (polyhedron vertices edges) face
    (let ((length (length vertices))
	  (center-vertex))
      (let ((center-x (/ (apply #'+ (mapcar #'vertex-x vertices)) length))
	    (center-y (/ (apply #'+ (mapcar #'vertex-y vertices)) length))
	    (center-z (/ (apply #'+ (mapcar #'vertex-z vertices)) length)))
	(setf center-vertex (make-vertex polyhedron center-x center-y center-z))
	(dotimes (pos length)
	  (let* ((vertex (nth-with-ring pos vertices length))
		 (edge (segment-between polyhedron vertex
					(nth-with-ring (+ 1 pos) vertices length))))
	    (with-slots (left-face right-face head tail
				   for-wing back-wing ccw-for-wing ccw-back-wing) edge
	      (if (eq left-face face)
		  (with-slots (vertices) right-face
		    (setf vertices (delete head vertices))
		    (replacing-item vertices tail center-vertex)
		    (changed-object right-face)
		    (if (eq vertex head)
			(with-slots (head tail) for-wing
			  (if (eq vertex head)
			      (setf head center-vertex)
			      (setf tail center-vertex))
			  (changed-object for-wing))
			(with-slots (head tail) ccw-back-wing
			  (if (eq vertex head)
			      (setf head center-vertex)
			      (setf tail center-vertex))
			  (changed-object ccw-back-wing))))
		  (with-slots (vertices) left-face
		    (setf vertices (delete head vertices))
		    (replacing-item vertices tail center-vertex)
		    (changed-object left-face)
		    (if (eq vertex head)
			(with-slots (head tail) ccw-for-wing
			  (if (eq vertex head)
			      (setf head center-vertex)
			      (setf tail center-vertex))
			  (changed-object ccw-for-wing))
			(with-slots (head tail) back-wing
			  (if (eq vertex head)
			      (setf head center-vertex)
			      (setf tail center-vertex))
			  (changed-object back-wing)))))
	      )))
	;; set edge wings
	;; delete edges
	(remove-object edges)
	(remove-object vertices)
	(remove-object face)))
    polyhedron))


