;;; -*- Mode: LISP; Base: 8; Package: TAPE; Lowercase: Yes -*-

(defun carry-load-target-pathname (plist)
  (let* ((group (get plist ':dump-group))
	 (group-action	 
	  (or (cadr (assoc group *spec-alist*))
	      (cadr (assq ':wild *spec-alist*)))))
    (when group-action
      (let* ((host (get plist ':host))
	     (dir (get plist ':directory))
	     (elem (list host dir))			;We don't dump devices yet.
	     (action (cadr (assoc elem *host-dir-alist*)))
	     (default
	       (cond ((typep action 'fs:pathname)	;Not really used.
		      (carry-load-translate-pathname plist action))
		     ;;other choices here will be everything-in-one-place, hierarchical, etc.
		     ((or (null action)
			  (and (listp action) (memq (car action) '(:default :auto-default))))
		      (when (null action)
			D,#TD1PsT[Begin using 006 escapes](1 0 (NIL 0) (NIL :ITALIC NIL) "CPTFONTI");; The default pathname when we don't know any better is the
			;; dumped pathname on the default host.  This doesn't
			;; translate pathnames between operating systems, but neither
			;; does the "Other Host" option below.
0			
			(setq action (list ':default (fs:default-pathname (get plist :pathname))))
			(push (list elem action) *host-dir-alist*))
		      (carry-load-translate-pathname plist (cadr action))))))
	(cond ((eq (car action) ':auto-default)
	       default)
	      (t
	       (let ((*carry-load-default* default)
		     (*carry-load-plist* plist))
		 (declare (special *carry-load-default* *carry-load-plist*))
		 (selectq
		   (fquery '(:choices
			     (((t "Yes") #/Y #\SP)
			      ((nil "No") #/N)
			      ((:other "Other place") #/O)
			      ((:host "Other host") #/H)
			      ((:accept "Accept this default for this directory") #/A))
			     :help-function carry-load-help)
			   "Load ~A:~A into ~A? "
			   (get plist ':host)
			   (get plist ':pathname)
			   default)
		   (nil nil)
		   ((t) default)
		   (:accept (setf (car action) ':auto-default) default)
		   (:proceed (push `(,group t) *spec-alist*) t)
		   (:host
		    (let* ((system-type (get plist :system-type))
			   (host (let ((defhost (get plist :host)))
				   (flet ((host-okay (host)
					    (eq (send host :system-type) system-type)))
				     (accept `((and fs:pathname-host
						    ((cl:satisfies ,#'host-okay)))
					       :description ,(format () "A ~A host"
								     system-type))
					     :prompt `("Host to use for ~A" ,defhost)
					     :default (block something
							(condition-case (host)
							     (fs:get-pathname-host defhost)
							   (fs:unknown-pathname-host )
							   (:no-error
							     (when (host-okay host)
							       (return-from something host))))
							(let ((lhost fs:user-login-machine))
							  (when (host-okay lhost)
							    lhost))))))))
		      ;; Host must be of the same system type.  Therefore parse the
		      ;; directory on the dumped host with regard to the new host to get
		      ;; the new default.  Of course, we're not really supposed to parse
		      ;; :string-for-directory's.
		      (setq default (fs:parse-pathname
				      (cl:case system-type
					(:lispm
					  (string-append (get plist :directory) ">"))
					((:unix :unix42)
					  (string-append (get plist :directory) "//"))
					(otherwise (get plist :directory)))
				      host))
		      (setq default (carry-load-translate-pathname plist default))
		      (setf (second action) default)
		      default))
		   (:other
		    (setq default (accept 'fs:pathname
					  :prompt `("New pathname for ~A:~A~%~2@T"
						    ,host ,(get plist ':pathname))
					  :default default))
		    (setf (second action) default)
		    default)))))))))