;;;; Modify this file to contain appropriate pathnames for your system.

(in-package 'obvius)
(export '(*default-printer*))

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

;;; Memory availability on your machines, in 64k segments
(lcl:change-memory-management :growth-limit 750)   ;50 Megabytes

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

;;;; Directory paths.  NOTE: these must end in a slash!!!

;;(defvar *lucid-path*                     "/usr/src/lucid-4.1/")
(defvar *obvius-directory-path*          "/usr/src/obvius-3.0/")
(defvar *lisp-source-path*               "/usr/src/obvius-3.0/lisp-source/")
(defvar *c-source-path*                  "/usr/src/obvius-3.0/c-source/")
(defvar *binary-path* 
  #+(and Sun (not Sparc))                "/usr/src/obvius-3.0/sun3-bin/"
  #+(and Sun Sparc (not *lisp-hardware)) "/usr/src/obvius-3.0/sun4-bin/"
  #+Irix                                 "/usr/src/obvius-3.0/sgi-bin/"
  #+Vax                                  "/usr/src/obvius-3.0/vax-bin/"
  #+HP                                   "/usr/src/obvius-3.0/hp-bin/")
(defvar *tiff-library*                   "/usr/local/lib/libtiff.a")
(defvar *obvius-image-path*              "/usr/src/obvius-3.0/")

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

;;; Printing environment

(defvar *temp-ps-directory* "/tmp/"
  "Temporary directory for PostScript files which are being sent to the printer.")

(defvar *default-printer* ""
  "Name of a PostScript printer.")

;;; Set :type property of *default-printer* variable (don't change this).
(eval-when (load eval) (setf (get '*default-printer* :type) 'string))

;;; The ~@* directive skips back to re-process the first arg!
(defvar *print-command-string* "cat ~A | lpr -P~A ; rm ~@*~A"
  "A print command.  This should be a format string which takes two args:
the filename and the printer .  On Unix systems, it will be run as a shell
program.")

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

;;;; File suffixes

(defvar *source-file-suffix* 
  #+Sun  ".lisp"
  #+Vax  ".lisp"
  #+Irix ".lisp"
  #+HP   ".l")

(defvar *binary-file-suffix* 
  #+(and Sun (not Sparc)) ".lbin"
  #+(and Sun Sparc) ".sbin"
  #+Irix ".mbin"
  #+Vax ".vbin"
  #+HP  ".b")
