(in-package :obvius)

(ccl::require :ff)

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;; specific code for one object file at a time for interface testing.
#|
(let ((libs '("StdCLib.o" 
              "Math.o" 
              "CSANELib.o"              ; matrix.c requires this (fabs)
              "Runtime.o"               ; matrix.c requires this (ULMULT)
              ;;"Interface.o"             ; imops requires this (GETPTRSIZE)
              )))
  (setq libs (loop for lib in libs collect
                   (merge-pathnames *c-source-path* lib)))
  (ccl::ff-load (list "obv:c-source;zoom.c.o")
                :ffenv-name 'obv
                :replace t
                :libraries  libs))
|#

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;; Define a function lisp-sym to call the function ff-sym,
;; with the same arguments passed to lisp-sym, almost. 
;; Those args corresponding to arg-specs that are 'array
;; get replaced with a pointer to the array that C can use.
(defmacro make-ff-wrapper (lisp-sym ff-sym arg-specs)
  (let* ((arg-syms (loop for i from 0 below (length arg-specs)
                         collect (gensym)))
         (new-arg-syms
          (loop for arg-sym in arg-syms
                for arg-spec in arg-specs
                collect (if (eq arg-spec 'array)
                          `(let (type offset parent d-offset)
                             (multiple-value-setq (parent d-offset) 
                               (ccl::displaced-array-p ,arg-sym))
                             (setq type (array-element-type ,arg-sym))
                             (setq offset 7)
                             (when (eq type 'bit) (incf offset))
                             (if parent 
                               (incf offset (* d-offset (sizeof type)))
                               (setq parent ,arg-sym))
                             (+ offset (ccl::%address-of parent)))
                          arg-sym))))
    (push 'list new-arg-syms)
    `(defun ,lisp-sym ,arg-syms (apply (quote ,ff-sym) ,new-arg-syms))))

#|
;;; old version, didn't deal with displaced arrays.
(defmacro make-ff-wrapper (lisp-sym ff-sym arg-specs)
  (let* ((arg-syms (loop for i from 0 below (length arg-specs)
                         collect (gensym)))
         (new-arg-syms
          (loop for arg-sym in arg-syms
                for arg-spec in arg-specs
                collect (cond ((eq arg-spec 'array)
                               `(+ 7 (ccl::%address-of ,arg-sym)))
                              ((eq arg-spec 'bit-array)
                               `(+ 8 (ccl::%address-of ,arg-sym)))
                              (t arg-sym))))
         )
    (push 'list new-arg-syms)
    `(defun ,lisp-sym ,arg-syms (apply (quote ,ff-sym) ,new-arg-syms))))
|#

#|
(make-ff-wrapper internal-dot-product internal_dot_product 
                 (array array (fixnum :long)))

(macroexpand-1 '(make-ff-wrapper internal-dot-product internal_dot_product 
                 (array array (fixnum :long))))

(DEFUN INTERNAL-DOT-PRODUCT (#:G154 #:G155 #:G156) 
  (APPLY 'INTERNAL_DOT_PRODUCT 
         (LIST (LET (TYPE OFFSET PARENT D-OFFSET) 
                 (MULTIPLE-VALUE-SETQ (PARENT D-OFFSET) 
                   (CCL:DISPLACED-ARRAY-P #:G154)) 
                 (SETQ TYPE (ARRAY-ELEMENT-TYPE #:G154)) 
                 (SETQ OFFSET 7) 
                 (WHEN (EQ TYPE 'BIT) (INCF OFFSET)) 
                 (IF PARENT (INCF OFFSET (* D-OFFSET (SIZEOF TYPE))) 
                     (SETQ PARENT #:G154)) 
                 (+ OFFSET (CCL:%ADDRESS-OF PARENT))) 
               (LET (TYPE OFFSET PARENT D-OFFSET) 
                 (MULTIPLE-VALUE-SETQ (PARENT D-OFFSET) 
                   (CCL:DISPLACED-ARRAY-P #:G155)) 
                 (SETQ TYPE (ARRAY-ELEMENT-TYPE #:G155)) 
                 (SETQ OFFSET 7) (WHEN (EQ TYPE 'BIT) (INCF OFFSET)) 
                 (IF PARENT (INCF OFFSET (* D-OFFSET (SIZEOF TYPE))) 
                     (SETQ PARENT #:G155)) 
                 (+ OFFSET (CCL:%ADDRESS-OF PARENT))) 
               #:G156)))

;; this produces the equivalent of
(defun internal-dot-product (arr-1 arr-2 size)
  (internal_dot_product (+ 7 (ccl::%address-of arr-1)) (+ 7 (ccl::%address-of arr-2))
                        size))

|#
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;; This macro creates a deffcfun statement almost identical 
;; to the input statement, except that 'array is replaced with '(fixnum :long)
;; in the arg specs.
(defmacro make-deffcfun (ff-sym-and-string arg-specs return-spec)
  `(ccl::deffcfun 
     ,ff-sym-and-string
     ,(substitute '(fixnum :long) 'array arg-specs)
     ,return-spec))

#|
(make-deffcfun (internal_dot_product "internal_dot_product") 
  (array array (fixnum :long)) :float)
|#
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;; Our top-level replacement for deffcfun.
;; Very similar syntax, handles arrays in a special way.
;; Create a lisp function with the specified symbol;
;; this is a wrapper function, which calles
;; a deffcfun-defined function, which interfaces to C
;; at the entry point specified by the entry srting.
;; *** what about the package of the symbol??
(defmacro deffcfun-obv (lisp-sym-and-entry arg-specs &optional (result-spec :void))
  (let* ((lisp-sym (first lisp-sym-and-entry))
         (entry (second lisp-sym-and-entry))
         (ff-sym-name (concatenate 'string "FF-" (symbol-name lisp-sym)))
         (ff-sym (intern ff-sym-name *package*))
         )
    (eval `(make-deffcfun ,(list ff-sym entry) ,arg-specs ,result-spec))
    (eval `(make-ff-wrapper ,lisp-sym ,ff-sym ,arg-specs))
    nil))

#|
;; Test code using internal-dot-product from in matrix.c
(fmakunbound 'internal-dot-product)
(fmakunbound 'ff-internal-dot-product)
(deffcfun-obv (internal-dot-product "internal_dot_product")
  (array array (fixnum :long)) :float)
(describe 'internal-dot-product)
(describe 'ff-internal-dot-product)
(setq foo (make-array 3 :element-type 'double-float :initial-contents '(1.0 2.0 3.0)))
(internal-dot-product foo foo (length foo))

;; Test displaced-array
(setq foo (make-array 10 :element-type 'double-float :initial-element 0.0))
(setq dfoo (make-array 3 :element-type 'double-float 
                       :displaced-to foo
                       :displaced-index-offset 3))
(progn
  (setf (aref dfoo 0) 1.0)
  (setf (aref dfoo 1) 2.0)
  (setf (aref dfoo 2) 3.0))
(internal-dot-product dfoo dfoo (length dfoo))
(print dfoo)

;; Test code using internal-sc-almost-equal from in matrix.c
(deffcfun-obv (internal-sc-almost-equal "internal_sc_almost_equal")
  (array float fixnum float) :long)
(setq foo (make-array 3 :element-type 'double-float :initial-contents '(1.0 1.0 1.01)))
(internal-sc-almost-equal foo 1.0 (length foo) 0.1) ;; Should be 0
(internal-sc-almost-equal foo 1.0 (length foo) 0.001) ;; Should be 1

;;; Test code for internal-8bit-to-f
(deffcfun-obv (internal-8bit-to-f "internal_8bit_to_f")
  (array array fixnum))
(setq foo (make-array 3 :element-type '(unsigned-byte 8) :initial-contents '(1 2 3)))
(setq fee (make-array 3 :element-type 'double-float :initial-element 0.0))
(internal-8bit-to-f foo fee (length foo))
(print foo)
(print fee)

;;; Test code for internal-replicate-1bit
(deffcfun-obv (internal-replicate-1bit "internal_replicate_1bit")
  (array fixnum fixnum array fixnum fixnum) :long)
(setq foo (make-array 32 :element-type 'bit :initial-element 1))
(setq fee (make-array 32 :element-type 'bit :initial-element 0))
(internal-replicate-1bit foo (length foo) 1 fee (length fee) 1)
(print foo)
(print fee)

;;; Test displaced bit array
(setq foo (make-array 64 :element-type 'bit :initial-element 1))
(setq fee (make-array 64 :element-type 'bit :initial-element 0))
(setq dfoo (make-array 32 :element-type 'bit :displaced-to foo 
                       :displaced-index-offset 32))
(setq dfee (make-array 32 :element-type 'bit :displaced-to fee 
                       :displaced-index-offset 32))
(internal-replicate-1bit dfoo (length dfoo) 1 dfee (length dfee) 1)
(print dfoo)
(print dfee)


;;; Test code for internal-chartohex
(deffcfun-obv (internal-chartohex "internal_chartohex")
  (string array fixnum fixnum array) :long)

(setq foo (make-array 3 :element-type '(unsigned-byte 8) :initial-contents '(1 2 3)))
(setq fee (make-array (+ 1 (* (length foo) 2)) :element-type '(unsigned-byte 8) 
                      :initial-element 0))

(internal-chartohex "Macintosh HD:Desktop Folder:foo" foo (length foo) 1 fee)

;; Test internal-add
(deffcfun-obv (internal-add "internal_add")
  (array array array fixnum))
(setq foo (make-array 3 :element-type 'double-float :initial-element 2.0))
(setq fee (make-array 3 :element-type 'double-float :initial-element 0.0))
(internal-add foo foo fee (length foo))
(print foo)
(print fee)
|#


;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;; Test code for Manual function definitions.
#|
(defun internal-dot-product (arr-1 arr-2 size)
  (internal_dot_product (+ 7 (ccl::%address-of arr-1)) (+ 7 (ccl::%address-of arr-2))
                        size))

(deffcfun (internal_dot_product "internal_dot_product") 
  ((fixnum :long) (fixnum :long) (fixnum :long)) :float)

(deffcfun (internal-sc-almost-equal "internal_sc_almost_equal") 
  ((fixnum :long) float (fixnum :long) float) :long)
|#

#|
(setf foo (make-array 3 :element-type 'double-float :initial-contents '(2.0 2.0 3.0)))
(internal-dot-product foo foo (length foo))

(setf fee (make-array 3 :element-type 'double-float :initial-contents '(1.0 1.0 1.0)))
(setq fee-add (+ 7 (ccl::%address-of fee)))
(internal-sc-almost-equal fee-add 1.0 (length fee) 1e-12)
(internal-sc-almost-equal fee-add 0.0 (length fee) 1e-12)

|#
