(in-package 'lispview)
(export '(match-event-spec))

;;; This is similar to lispview:match-event.  It finds an interest on
;;; a canvas which will match the given event spec (hopefully, the
;;; same way the corresponding event would do it!).  Note that the
;;; event spec should correspond to a single unique low-level X11
;;; event.
(let ((internal-mouse-doc-interest	;lexical closure for dummy mouse interest
       (make-instance 'mouse-interest :event-spec '(() (:left :down)))))
  (defun match-event-spec (canvas event-spec)
    (setq event-spec (parse-mouse-event-spec event-spec))
    (setf (slot-value internal-mouse-doc-interest 'parsed-event-spec) event-spec)
    (let* ((xvo (device canvas))
	   (type (car (x11-event-types internal-mouse-doc-interest)))
	   (button
	    (car (if (or (= type #.X11:ButtonPress) (= type #.X11:ButtonRelease))
		     (mapcar #'(lambda (buttons)
				 (case (cadr buttons);; no support for button chords
				   (:button0 #.X11:Button1)
				   (:button1 #.X11:Button2)
				   (:button2 #.X11:Button3)
				   (:button3 #.X11:Button4)
				   (:button4 #.X11:Button5)))
			     (cdaadr event-spec))))))
      (multiple-value-bind (state-mask state-match)
	  (x11-event-state-target (cdadar event-spec))
	(declare (ignore state-mask))
	(loop for xvi in (svref (xview-canvas-interest-table xvo) type) do
	      (when (and (= button (x11-mouse-interest-button xvi))
			 (= (x11-mouse-interest-state-match xvi) state-match))
		(return (x11-interest-object xvi)))
	      finally (return nil))))))

