
;;;; Patch for the very slow copy of data when creating X images.
;;;; Checks to see if array is of type '(unsigned-byte 8) or 'bit.  If
;;;; so does low level C library copy.  -EPS

(in-package :lispview)

(lucid::def-foreign-function (memcpy (:language :c))
    a1 a2 (n :fixnum))

(LCL:def-foreign-function (copy-swapped-32bit (:language :c))
    (arr :array) res (size :fixnum))

;;; width and height are the size of the region of interest.  The array rows
;;; may be padded beyond this.  In addition, the Ximage will be padded.
;;; *** NOTE: This is only faster for even width images...
(defun make-x11-image (dsp array width height depth visual)
  (XV:with-xview-lock 
  (let* ((img (X11:XCreateImage 
	       dsp 
	       (or visual x11-null-visual)
	       depth 
	       (if (= depth 1) X11:XYBitmap X11:ZPixmap)
	       0;; offset
	       x11-null-data
	       width
	       height
	       16;; bitmap_pad
	       0))			; bytes_per_line - XCreateImage calculates
	 (array-width (array-dimension array 1))
	 (padded-width (X11:ximage-bytes-per-line img)) ;in bytes
	 (length (* padded-width height)) ;in bytes
	 (data (FFI:malloc-foreign-pointer :type `(:pointer (:array X11:char (,length))))))
    (setf (FFI:foreign-pointer-type data) '(:pointer X11:char)
	  (X11:ximage-data img) data)

    (cond ((and (= depth 8)  (equal (array-element-type array) '(unsigned-byte 8)))
	   (if (= padded-width array-width)
	       (memcpy data array length)
	       (loop for row from 0 below height
		     for array-offset from 0 by array-width
		     for array-address from (lucid::array-data-address array) by array-width
		     for data-address from (lcl:foreign-pointer-address data) by padded-width
		     do (memcpy data-address array-address array-width))))

	  ;; On SPARC, Lucid bit array order is 32bit reversed from Ximages.
	  #+(and :SPARC :LUCID)
	  ((and (= depth 1) (equal (array-element-type array) 'bit)
		(= (* padded-width 8) array-width)
		(= (mod array-width 32) 0)) ;32bit padded
	   (copy-swapped-32bit array data (/ length 4)))

	  ;; This is very slow!!!
	  (t (warn "Slow X image copy ...")
	     (dotimes (y height)
	       (dotimes (x width)
		 (X11:XPutPixel img x y (aref array y x))))))
    img)))

#|  Another attempt, which didn't work for some unknown reason.  -EPS
    (if (lucid::stationary-object-p array)
        (setf (X11:ximage-data img) 
	      (lucid::make-foreign-pointer
	      :address (lucid::array-data-address array) 
	      :type `(:pointer (:array X11:char (,length)))))

|#
