
(in-package 'obvius)

(defmethod draw-color-float-arrays
    ((bltable frob)
     r-float-array g-float-array b-float-array
     pedestal scale zoom
     x-offset y-offset)
  (error "Color pictures not implemented yet"))

(defmethod draw-color-float-arrays
    ((bltable X-bltable)
     r-float-array g-float-array b-float-array
     pedestal scale zoom
     x-offset y-offset)
  (declare (ignore zoom))
  (setq scale (/-0 1.0 scale 1.0))
  (let* ((screen (screen-of bltable))
	 (bltable-data (data bltable))
	 (red-levels (expt 2 (first (rgb-bits screen))))
	 (green-levels (expt 2 (second (rgb-bits screen))))
	 (blue-levels (expt 2 (third (rgb-bits screen))))
	 (r-lut (make-array red-levels :element-type '(unsigned-byte 8)))
	 (g-lut (make-array green-levels :element-type '(unsigned-byte 8)))
	 (b-lut (make-array blue-levels :element-type '(unsigned-byte 8))))
    (loop for i from 0 below red-levels do (setf (aref r-lut i) i))
    (loop for i from 0 below green-levels do (setf (aref g-lut i) (* red-levels i)))
    (loop for i from 0 below blue-levels do (setf (aref b-lut i) (* red-levels green-levels i)))
    (zero! bltable-data)
    (with-status-message "Dithering colors"
      (with-static-arrays ((tmp-8bit-array (allocate-array (dimensions bltable-data)
							   :element-type '(unsigned-byte 8))))
	(loop for float-array in (list r-float-array g-float-array b-float-array)
	      for lut in (list r-lut g-lut b-lut)
	      do
	      (zero! tmp-8bit-array)
	      (internal-dither-into-8bit-lut
	       float-array (x-dim float-array) (y-dim float-array)
	       tmp-8bit-array (x-dim tmp-8bit-array)
	       (float pedestal) (float (* scale (length lut)))
	       (round x-offset) (round y-offset) lut (length lut))
	      (add tmp-8bit-array bltable-data :-> bltable-data))))
    (with-status-message "Converting to color map values"
      (loop for j from 0 below (y-dim bltable-data) do
	    (loop for i from 0 below (x-dim bltable-data) do
		  (setf (aref bltable-data j i)
			(aref (color-lut screen) (aref bltable-data j i)))))))
  bltable)
