(in-package 'obvius)

;;; Old version didn't use mean.
(defun make-gaussian-noise (dims &key -> (mean 0.0) (variance 1.0) (iterations 6))
  (with-result ((result ->)
		(list :class 'image :dimensions dims)
		'make-gaussian-noise dims :mean mean :variance variance)
    (setq iterations (round iterations))
    (with-local-viewables ((temp (similar result))
			   (stdev (sqrt (* (/ 12 iterations) variance))))
      (internal-const (data result) (/ iterations -2.0) (total-size result))
      (loop for i from 0 below iterations do 
	    (add (make-uniform-noise dims :-> temp)
		 result :-> result))
      (mul stdev result :-> result)
      (add mean result :-> result))
    result))
