(in-package 'obvius)

;;; viewable.lisp:

;;; Generic method does a continuable error.
(defmethod notify-of-inferior-destruction ((sup-vbl viewable) inf-vbl)
  (declare (ignore inf-vbl))
  (cerror "Destroy  both ~A and ~A."
	  "You are attempting to destroy ~A which is contained in ~A."
	  inf-vbl sup-vbl)
  (destroy sup-vbl))

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

;;; viewable-sequence.lisp:
;;; Add :image-list to initargs
(defmethod initialize-instance ((seq image-sequence) &rest initargs
				&key image-list &allow-other-keys)
  (when image-list
    (setf (getf initargs :viewable-list) image-list)
    (remf initargs :image-list))
  (apply #'call-next-method seq initargs))

;;; Misc.lisp:
(defmethod similar ((val number) &rest keys)
  (declare (ignore keys))
  val)

(defun factorial (int)
  (loop with val = 1
	for x from int downto 2
	do (setq val (* val x))
	finally (return val)))

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

;;;; viewable-matrix.lisp patches:

;;; Fix default args of blur
;;; Check for zeros and ones when multiplying a number array by a vbl-mtx.
;;; Give error if result = arg.

(defmethod blur ((mat viewable-matrix)
		 &key 
		 (level 1)
		 (kernel (mapcar #'(lambda (x) (* x (sqrt 2))) gauss-5))
		 (edge-handler :reflect1)
		 ->)
  (unary-viewable-matrix-op 'blur mat ->
			    :level level
			    :kernel kernel
			    :edge-handler edge-handler))

;;; keys: :edge-handler :resample :kernel
(defmethod gauss-out ((mat viewable-matrix) &rest keys &key ->)
  (remf keys :->)
  (let ((res-data (make-array (list (row-dim mat) (col-dim mat))
			      :initial-contents
			      (loop for y from 0 below (row-dim mat)
				    collect
				    (loop for x from 0 below (col-dim mat)
					  for vbl = (aref (data mat) y x)
					  for res = (and (viewable-p ->) (aref (data ->) y x))
					  collect
					  (apply 'gauss-out vbl :-> res keys))))))
    (with-result ((result ->)
		  (list :class (clos:class-of mat)
			:data res-data
			:display-type (display-type mat))
		  'apply 'gauss-out mat keys)
      result)))

(defmethod matrix-transpose ((mat viewable-matrix) &key ->)
  (with-result ((result ->) (list :class (class-of mat)
				  :data (make-viewable-array-data
					 (list (col-dim mat) (row-dim mat))
					 (aref (data mat) 0 0))))
    (when (eq result mat) (error "Result cannot be eq to argument."))
    (loop for j from 0 below (row-dim result) do
	  (loop for i from 0 below (col-dim result) do
		(copy (aref (data mat) i j) :-> (aref (data result) j i))))
    result))

(defmethod matrix-mul ((mat1 viewable-matrix) (mat2 viewable-matrix) &key ->)
  (with-result ((result ->) (list :class (class-of mat1)
				  :data (if (viewable-matrix-p ->)
					    (data ->)
					    (make-viewable-array-data
					     (list (row-dim mat1) (col-dim mat2))
					     (aref (data mat1) 0 0))))
		'matrix-mul mat1 mat2)
    (when (or (eq result mat1) (eq result mat2))
      (error "Result cannot be eq to argument."))
    (check-matrix-mul-compatibility (row-dim mat1) (col-dim mat1)
				    (row-dim mat2) (col-dim mat2)
				    (row-dim result) (col-dim result))
    (with-local-viewables ((temp (similar (aref (data mat1) 0 0))))
      (let ((m1 (data mat1))
	    (m2 (data mat2))
	    (res (data result)))
	(loop for i from 0 below (row-dim m1) do
	      (loop for k from 0 below (col-dim m2) do
		    (zero! (aref res i k))
		    (loop for j from 0 below (col-dim m1) do
			  (add (aref res i k)
			       (mul (aref m1 i j) (aref m2 j k) :-> temp)
			       :-> (aref res i k)))))
	))
    result))

(defmethod matrix-mul-transpose
    ((mat1 viewable-matrix) (mat2 viewable-matrix) &key ->)
  (with-result ((result ->) (list :class (class-of mat1)
				  :data (if (viewable-matrix-p ->)
					    (data ->)
					    (make-viewable-array-data
					     (list (row-dim mat1) (row-dim mat2))
					     (aref (data mat1) 0 0))))
		'matrix-mul mat1 mat2)
    (when (or (eq result mat1) (eq result mat2))
      (error "Result cannot be eq to argument."))
    (check-matrix-mul-compatibility (row-dim mat1) (col-dim mat1)
				    (col-dim mat2) (row-dim mat2)
				    (row-dim result) (col-dim result))
    (with-local-viewables ((temp (similar (aref (data mat1) 0 0))))
      (let ((m1 (data mat1))
	    (m2 (data mat2))
	    (res (data result)))
	(loop for i from 0 below (row-dim m1) do
	      (loop for k from 0 below (row-dim m2) do
		    (zero! (aref res i k))
		    (loop for j from 0 below (col-dim m1) do
			  (add (aref res i k)
			       (mul (aref m1 i j) (aref m2 k j) :-> temp)
			       :-> (aref res i k)))))
	))
    result))

(defmethod matrix-transpose-mul
    ((mat1 viewable-matrix) (mat2 viewable-matrix) &key ->)
  (with-result ((result ->) (list :class (class-of mat1)
				  :data (if (viewable-matrix-p ->)
					    (data ->)
					    (make-viewable-array-data
					     (list (col-dim mat1) (col-dim mat2))
					     (aref (data mat1) 0 0))))
		'matrix-mul mat1 mat2)
    (when (or (eq result mat1) (eq result mat2))
      (error "Result cannot be eq to argument."))
    (check-matrix-mul-compatibility (col-dim mat1) (row-dim mat1)
				    (row-dim mat2) (col-dim mat2)
				    (row-dim result) (col-dim result))
    (with-local-viewables ((temp (similar (aref (data mat1) 0 0))))
      (let ((m1 (data mat1))
	    (m2 (data mat2))
	    (res (data result)))
	(loop for i from 0 below (col-dim m1) do
	      (loop for k from 0 below (col-dim m2) do
		    (zero! (aref res i k))
		    (loop for j from 0 below (row-dim m1) do
			  (add (aref res i k)
			       (mul (aref m1 j i) (aref m2 j k) :-> temp)
			       :-> (aref res i k)))))
	))
    result))

(defmethod dot-product
    ((mat1 viewable-matrix) (mat2 viewable-matrix) &key ->)
  (with-result ((result ->) (aref (data mat1) 0 0)
		'dot-product mat1 mat2)
    (when (or (eq result mat1) (eq result mat2))
      (error "Result cannot be eq to argument."))
    (zero! result)
    (with-local-viewables ((temp (similar (aref (data mat1) 0 0))))
      (let ((m1 (vectorize (data mat1)))
	    (m2 (vectorize (data mat2))))
	(loop for i from 0 below (col-dim m1) do
	      (add result (mul (aref m1 i) (aref m2 i) :-> temp) :-> result))))
    result))

(defmethod matrix-mul ((mat viewable-matrix) (arr array) &key ->)
  (with-result ((result ->) (list :class (class-of mat)
				  :data (if (viewable-matrix-p ->)
					    (data ->)
					    (make-viewable-array-data
					     (list (row-dim mat) (col-dim arr))
					     (aref (data mat) 0 0))))
		'matrix-mul mat arr)
    (when (eq result mat) (error "Result cannot be eq to argument."))
    (check-matrix-mul-compatibility (row-dim mat) (col-dim mat)
				    (row-dim arr) (col-dim arr)
				    (row-dim result) (col-dim result))
    (with-local-viewables ((temp (similar (aref (data mat) 0 0))))
      (let ((m1 (data mat))
	    (m2 arr)
	    (res (data result)))
	(loop for i from 0 below (row-dim m1) do
	      (loop for k from 0 below (col-dim m2) do
		    (zero! (aref res i k))
		    (loop for j from 0 below (col-dim m1)
			  for m2-val = (aref m2 j k) do
			  (cond ((zerop m2-val) nil)
				((= m2-val 1.0)
				 (add (aref res i k) (aref m1 i j) :-> (aref res i k)))
				(t (add (aref res i k)
					(mul (aref m1 i j) m2-val :-> temp)
					:-> (aref res i k)))))))))
    result))

(defmethod matrix-mul-transpose ((mat viewable-matrix) (arr array) &key ->)
  (with-result ((result ->) (list :class (class-of mat)
				  :data (if (viewable-matrix-p ->)
					    (data ->)
					    (make-viewable-array-data
					     (list (row-dim mat) (row-dim arr))
					     (aref (data mat) 0 0))))
		'matrix-mul mat arr)
    (when (eq result mat) (error "Result cannot be eq to argument."))
    (check-matrix-mul-compatibility (row-dim mat) (col-dim mat)
				    (col-dim arr) (row-dim arr)
				    (row-dim result) (col-dim result))
    (with-local-viewables ((temp (similar (aref (data mat) 0 0))))
      (let ((m1 (data mat))
	    (m2 arr)
	    (res (data result)))
	(loop for i from 0 below (row-dim m1) do
	      (loop for k from 0 below (row-dim m2) do
		    (zero! (aref res i k))
		    (loop for j from 0 below (col-dim m1)
			  for m2-val = (aref m2 k j) do
			  (cond ((zerop m2-val) nil)
				((= m2-val 1.0)
				 (add (aref res i k) (aref m1 i j) :-> (aref res i k)))
				(t (add (aref res i k)
					(mul (aref m1 i j) m2-val :-> temp)
					:-> (aref res i k)))))))))
    result))

(defmethod matrix-transpose-mul ((mat viewable-matrix) (arr array) &key ->)
  (with-result ((result ->) (list :class (class-of mat)
				  :data (if (viewable-matrix-p ->)
					    (data ->)
					    (make-viewable-array-data
					     (list (col-dim mat) (col-dim arr))
					     (aref (data mat) 0 0))))
		'matrix-mul mat arr)
    (when (eq result mat) (error "Result cannot be eq to argument."))
    (check-matrix-mul-compatibility (col-dim mat) (row-dim mat)
				    (row-dim arr) (col-dim arr)
				    (row-dim result) (col-dim result))
    (with-local-viewables ((temp (similar (aref (data mat) 0 0))))
      (let ((m1 (data mat))
	    (m2 arr)
	    (res (data result)))
	(loop for i from 0 below (col-dim m1) do
	      (loop for k from 0 below (col-dim m2) do
		    (zero! (aref res i k))
		    (loop for j from 0 below (row-dim m1)
			  for m2-val = (aref m2 j k) do
			  (cond ((zerop m2-val) nil)
				((= m2-val 1.0)
				 (add (aref res i k) (aref m1 j i) :-> (aref res i k)))
				(t (add (aref res i k)
					(mul (aref m1 j i) m2-val :-> temp)
					:-> (aref res i k)))))))))
    result))

(defmethod matrix-mul ((arr array) (mat viewable-matrix) &key ->)
  (with-result ((result ->) (list :class (class-of mat)
				  :data (if (viewable-matrix-p ->)
					    (data ->)
					    (make-viewable-array-data
					     (list (row-dim arr) (col-dim mat))
					     (aref (data mat) 0 0))))
		'matrix-mul mat arr)
    (when (eq result mat) (error "Result cannot be eq to argument."))
    (check-matrix-mul-compatibility (row-dim arr) (col-dim arr)
				    (row-dim mat) (col-dim mat)
				    (row-dim result) (col-dim result))
    (with-local-viewables ((temp (similar (aref (data mat) 0 0))))
      (let ((m1 arr)
	    (m2 (data mat))
	    (res (data result)))
	(loop for i from 0 below (row-dim m1) do
	      (loop for k from 0 below (col-dim m2) do
		    (zero! (aref res i k))
		    (loop for j from 0 below (col-dim m1)
			  for m1-val = (aref m1 i j) do
			  (cond ((zerop m1-val) nil)
				((= m1-val 1.0)
				 (add (aref res i k) (aref m2 j k) :-> (aref res i k)))
				(t (add (aref res i k)
					(mul m1-val (aref m2 j k) :-> temp)
					:-> (aref res i k)))))))))
    result))

(defmethod matrix-mul-transpose ((arr array) (mat viewable-matrix) &key ->)
  (with-result ((result ->) (list :class (class-of mat)
				  :data (if (viewable-matrix-p ->)
					    (data ->)
					    (make-viewable-array-data
					     (list (row-dim arr) (row-dim mat))
					     (aref (data mat) 0 0))))
		'matrix-mul mat arr)
    (when (eq result mat) (error "Result cannot be eq to argument."))
    (check-matrix-mul-compatibility (row-dim arr) (col-dim arr)
				    (col-dim mat) (row-dim mat)
				    (row-dim result) (col-dim result))
    (with-local-viewables ((temp (similar (aref (data mat) 0 0))))
      (let ((m1 arr)
	    (m2 (data mat))
	    (res (data result)))
	(loop for i from 0 below (row-dim m1) do
	      (loop for k from 0 below (row-dim m2) do
		    (zero! (aref res i k))
		    (loop for j from 0 below (col-dim m1)
			  for m1-val = (aref m1 i j) do
			  (cond ((zerop m1-val) nil)
				((= m1-val 1.0)
				 (add (aref res i k) (aref m2 k j) :-> (aref res i k)))
				(t (add (aref res i k)
					(mul m1-val (aref m2 k j) :-> temp)
					:-> (aref res i k)))))))))
    result))

(defmethod matrix-transpose-mul ((arr array) (mat viewable-matrix) &key ->)
  (with-result ((result ->) (list :class (class-of mat)
				  :data (if (viewable-matrix-p ->)
					    (data ->)
					    (make-viewable-array-data
					     (list (col-dim arr) (col-dim mat))
					     (aref (data mat) 0 0))))
		'matrix-mul mat arr)
    (when (eq result mat) (error "Result cannot be eq to argument."))
    (check-matrix-mul-compatibility (col-dim arr) (row-dim arr)
				    (row-dim mat) (col-dim mat)
				    (row-dim result) (col-dim result))
    (with-local-viewables ((temp (similar (aref (data mat) 0 0))))
      (let ((m1 arr)
	    (m2 (data mat))
	    (res (data result)))
	(loop for i from 0 below (col-dim m1) do
	      (loop for k from 0 below (col-dim m2) do
		    (zero! (aref res i k))
		    (loop for j from 0 below (row-dim m1)
			  for m1-val = (aref m1 j i) do
			  (cond ((zerop m1-val) nil)
				((= m1-val 1.0)
				 (add (aref res i k) (aref m2 j k) :-> (aref res i k)))
				(t (add (aref res i k)
					(mul m1-val (aref m2 j k) :-> temp)
					:-> (aref res i k)))))))))
    result))

(defmethod dot-product ((mat viewable-matrix) (arr array) &key ->)
  (with-result ((result ->) (aref (data mat) 0 0)
		'dot-product mat arr)
    (when (eq result mat) (error "Result cannot be eq to argument."))
    (zero! result)
    (with-local-viewables ((temp (similar (aref (data mat) 0 0))))
      (let ((m1 (vectorize (data mat)))
	    (m2 (vectorize arr)))
	(loop for i from 0 below (col-dim m1)
	      for m2-val = (aref m2 i) do
	      (cond ((zerop m2-val) nil)
		    ((= m2-val 1.0)
		     (add result (aref m1 i) :-> result))
		    (t (add result (mul (aref m1 i) (aref m2 i) :-> temp) :-> result))))))
    result))
