
(in-package 'obvius)

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

;;; Minor fix (x-offset and y-offset were not needed)

(defmethod overlay-picture ((sub-vbl discrete-function) (sub-pic graph) vbl pic)
  (declare (ignore vbl))
  (with-slots (graph-type y-range x-range y-axis x-axis y-tick-step x-tick-step 
	       y-tick-length x-tick-length y-tick-gap x-tick-gap 
	       y-tick-format-string x-tick-format-string y-label x-label
	       color axis-color line-width
	       plot-symbol fill-symbol-p symbol-size
	       x-offset y-offset) sub-pic
    (multiple-value-bind (graph->frob-y graph->frob-x data->frob-y data->frob-x)
	(compute-graph-transforms sub-pic)
      (draw-graph (system-dependent-frob pic) (data sub-vbl)
		  graph-type graph->frob-y graph->frob-x data->frob-y data->frob-x
		  y-range x-range y-axis x-axis y-tick-step x-tick-step 
		  y-tick-length x-tick-length y-tick-gap x-tick-gap 
		  y-tick-format-string x-tick-format-string y-label x-label
		  :color color :axis-color axis-color :line-width line-width
		  :plot-symbol plot-symbol :fill-symbol-p fill-symbol-p
		  :symbol-size symbol-size))))

(defmethod overlay-picture ((sub-vbl one-d-image) (sub-pic graph) vbl pic)
  (declare (ignore vbl))
  (with-slots (graph-type y-range x-range y-axis x-axis y-tick-step x-tick-step 
	       y-tick-length x-tick-length y-tick-gap x-tick-gap 
	       y-tick-format-string x-tick-format-string y-label x-label
	       color axis-color line-width
	       plot-symbol fill-symbol-p symbol-size
	       x-offset y-offset) sub-pic
    (multiple-value-bind (graph->frob-y graph->frob-x data->frob-y data->frob-x)
	(compute-graph-transforms sub-pic)
      (draw-graph (system-dependent-frob pic) (data sub-vbl)
		  graph-type graph->frob-y graph->frob-x data->frob-y data->frob-x
		  y-range x-range y-axis x-axis y-tick-step x-tick-step 
		  y-tick-length x-tick-length y-tick-gap x-tick-gap 
		  y-tick-format-string x-tick-format-string y-label x-label
		  :color color :axis-color axis-color :line-width line-width
		  :plot-symbol plot-symbol :fill-symbol-p fill-symbol-p
		  :symbol-size symbol-size))))

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

;;; Add overlays of scatter plots:

(defmethod common-parameters ((class-name (eql 'scatter-plot)))
  (append (list :retain-bitmap :axis-color :y-range :x-range
		:y-axis-type :y-axis :x-axis :y-tick-step :x-tick-step
		:y-label :x-label :aspect-ratio :y-max-label-length :x-max-label-length
		:y-tick-format-string :x-tick-format-string :y-tick-length :x-tick-length
		:y-tick-gap :x-tick-gap)
	  (call-next-method)))

(defmethod overlay ((im image-pair) vbl pic)
  (unless (every #'(lambda (x) (image-pair-p x)) (viewable-list vbl))
    (error "Overlays on an image-pair must all be image-pairs"))
  (apply 'check-size im (viewable-list vbl))
  (overlay-drawables pic vbl))

(defmethod overlay-picture ((sub-vbl image-pair) (sub-pic scatter-plot) vbl pic)
  (declare (ignore vbl))
  (with-slots (system-dependent-frob retain-bitmap pane-of bounding-region graph-type
	       y-range x-range y-axis x-axis y-tick-step x-tick-step
	       y-tick-length x-tick-length y-tick-gap x-tick-gap
	       y-tick-format-string x-tick-format-string
	       y-label x-label axis-color color line-width
	       plot-symbol fill-symbol-p symbol-size) sub-pic
    (multiple-value-bind (graph->frob-y graph->frob-x data->frob-y data->frob-x)
	(compute-graph-transforms sub-pic)
      (draw-graph (system-dependent-frob pic)
		  (list (data (y-component sub-vbl))
			(data (x-component sub-vbl)))
		  graph-type graph->frob-y graph->frob-x data->frob-y data->frob-x
		  y-range x-range y-axis x-axis y-tick-step x-tick-step 
		  y-tick-length x-tick-length y-tick-gap x-tick-gap 
		  y-tick-format-string x-tick-format-string y-label x-label
		  :color color :axis-color axis-color :line-width line-width
		  :plot-symbol plot-symbol :fill-symbol-p fill-symbol-p
		  :symbol-size symbol-size))))

