;;; definitions for thingoids

; --------------------------------------------------------------------
; ** Simulator support for THINGOIDS
; ----------------------------------
; Solid objects are all of type THINGOID.  Each must be constructed
;  indivdually.  It should be kept in mind that when solid objects
;  are to be created and destroyed often (ie. enemy soldiers,
;  grenades and the like) they should exist as pools (see 'T' manual)
;  to minimize consing.
; THINGOIDS can be placed in parcels of type CONTAINER but not
;  parcels of type VESSEL. (see VESSELS below)
; --------------------------------------------------------------------
; * Generic THINGOID object constructor
; -------------------------------------
; This function makes a single object of a given type.  The arguments
;  determine the properties of the object in the simulation.  Generic
;  THINGOIDS are entirely passive.  Note that enemy troops, tires and
;  weapons are generic objects.
;
; (SI:MAKE-THING-GENERIC id kind bigness-num tools)
;  -    id: This should be a globally unique symbol differentiating
;            the object from all others.
;  -  kind: A symbol or list of symbols describing the classes that
;            the object belongs to.  The first symbol in this argument
;            is known as the objects KIND-ID and is used for display
;            purposes.
;  - bigness-num: This argument is an integer giving the pseudo-size
;            of the object.
;  - tools: A list of object classes that the robot arm must already
;            be holding before this object can be picked up.

(defclass thingoid
  (sim-object)
  ((environment :type environment
                :initform *undefined-object*)
   (bigness :accessor bigness
            :initarg :bigness
            :initform 0)
   (tool-needs :accessor tool-needs
               :initarg :tool-needs
               :initform '(undefined-tool))
   (recycle-pool :accessor recycle-pool
                 :initform '())
   (id-key  :accessor id-key  ;**** what is this for?
            :initform '())))


;;; ** Operations handled by all objects
               
(defmethod unique-id ((self thingoid)) 
  (if (not (null (id self)))
	  (id self)
	  (cond
		((null (id-key self))
		  (setf (id-key self) (make-unique-id 'thing))
		  (fetch-id (id-key self)))
	    (t (fetch-id (id-key self))))))

(defmethod recycle ((self thingoid))
  (cond ((recycle-pool self) 
         (return-to-pool (recycle-pool self) self)))
  (values)) 

(defmethod examine ((self thingoid))
  (post-sensor-datum 'thing
                     (unique-id self)
                     (kind-id self)
                     '()
                     '()))


;;; display stuff  ***
                    
(defmethod show ((self thingoid))
  (format t
          "Id:      ~a~&Bigness: ~a - Tools: ~a~&"
          (id self)
          (bigness self)
          (tool-needs self))
  (format t "Held-By: ~a~&" (environment self))
  t)
