(comment (herald rocks))

(defclass rock
  (thingoid)
  ((chance :accessor chance
           :initarg :chance)))

;;; ** Operations handled by all objects


;;; ** Other operations

;        (Defmethod pickup-chance ((self rock)) (chance self))

(defmethod examine ((self rock))
  (post-sensor-datum 'thing
                     (unique-id self)
                     'rock
                     nil
                     nil)
  (post-sensor-datum 'bigness
                     (unique-id self)
                     (bigness self)
                     nil
                     nil))

(defclass machine
  (container)
  ())

(defclass rock-machine   ; **** this seems to make boxes not rocks
  (machine)
  ((size :initform 50)
   (bigness :initform 10)
   (tools :initform '(undefined-tool))
   (visibles :initform nil)))

(defmethod toggle ((self rock-machine))
  (let ((contents (holdings self)))
    (let ((size (apply #'+ (mapcar #'bigness contents))))
      (if (>= size 15)
        (let ((new-box (si.make-box (make-unique-id 'box))))
          (mapcar #'(lambda (x) (take-out self x))
                  contents)
          (put-in self new-box))))))
               