;;; definitions for environments


(defclass environment
  (sim-object)              ; superclass
  ((holdings :accessor holdings
            :initarg :holdings
            :initform '())
   ))                       

(defmethod holdings (self)  ; returns nil when called on something
  '())                      ; without the slot

(defmethod actual-time ((Self environment))
  (actual-time (environment self)))

(defmethod show-inside ((self environment) thing-id)
  (let ((thing (obj-list-get-id (holdings self) thing-id)))
    (cond (thing (show thing))
          (t (mapc #'(lambda (x)
                       (show-inside x thing-id))
                   (holdings self))))))

(defvar *undefined-object* (make-instance 'environment
										  :id 'undefined-object
										  :kind '(undefined-object)))

;(setf (kind *undefined-object*) (list 'undefined-object))