;*********************************************************************
;  LOC.LISP

(defun make-loc-disp (window-in)
  (let ((max-icons-in-row (truncate (/ (- (height window-in) 35) 
									   (+ *small-icon-height* 15)))))
	(make-instance
	 'loc-disp
	 :display-window (make-window (x-coord window-in)
								  (+ 30 (y-coord window-in))
								  (width window-in)
								  (- (height window-in) 30))
	 :row1-vector (make-array (list max-icons-in-row))
	 :row2-vector (make-array (list max-icons-in-row)))))

(defun loc-max-icons-in-row (loc-disp)
  (let ((h (height (display-window loc-disp))))
	(truncate (/ (- h 35) (+ *small-icon-height* 15)))))
  
(defmethod dm-locate-obj ((self loc-disp) sym)
  (t-cond 
   ((position sym (row1-vector self) 
	   :test #'(lambda (sym vec-elt) 
				 (and vec-elt (eq sym (unique-id vec-elt)))))
           =>
     #'(lambda (pos)
		 (list 'current-location
			   (vloc->icon-win (list (row1-vector self)
									 pos)
							   self))))
   ((position sym (row2-vector self)
	  :test #'(lambda (sym vec-elt)
                (and vec-elt (eq sym (unique-id vec-elt)))))
           =>
     #'(lambda (pos)
         (list 'current-location
			   (vloc->icon-win (list (row2-vector self)
									 pos)
							   self))))
   (t nil)))

(defmethod next-empty-space ((self loc-disp) x)
  (let ((space (next-available-icon-position self)))
    (if space
      (vloc->icon-win space self)
      (cerror "To continue" "No available space at current location"))))

(defmethod dm-set ((self loc-disp) x obj)
  (declare (ignore x))
  (loc-draw-border-window self obj)
  (setf (current-location-obj self) obj))

(defmethod dm-add ((self loc-disp) x obj)
  (let ((pos (next-available-icon-position self)))
    (cond
	  ((null pos)
		(cerror "To continue" "No room to add ~a to location" obj))
	  (t (disp-in-small-icon obj (vloc->icon-win pos self))
		 (setf (svref (car pos) (cadr pos)) obj)))))

(defmethod dm-del ((self loc-disp) x obj)
  (declare (ignore x))
  (let ((vloc (obj->vloc obj self)))
    (cond
	  ((null vloc)
	    nil)  ; deleting the truck should have no effect
	  (t (disp.clear-rectangle (vloc->icon-win vloc self))
		 (setf (svref (car vloc) (cadr vloc)) nil)))))

(defmethod dm-empty ((self loc-disp) x)
  (dolist (y (append (coerce (row1-vector self) 'list)
                     (coerce (row2-vector self) 'list)))
    (if y (dm-del self '() y))))

(defmethod dm-refresh ((self loc-disp))
  (disp.clear-rectangle (display-window self))
  (loc-draw-border-window self (current-location-obj self))
  (dolist (item (append (coerce (row1-vector self) 'list)
						(coerce (row2-vector self) 'list)))
	(if item (disp-in-small-icon item (obj->icon-win item self)))))
