;*********************************************************
;  GRAPHIC-DISPLAYER.LISP

(defun make-displayer (truck-obj world-obj 
                          &optional (x 0) (y 0) (display-string ""))
  (let ((truck-window (make-window 0 0 385 450))
        (loc-window (make-window 384 0 135 450))
        (map-window (make-window 0 449 515 310)))
    (really-make-display x
						 y
						 *display-window-width*
						 *display-window-height*
						 truck-obj
						 (truck-arm-names truck-obj)
						 (truck-bay-names truck-obj)
						 (truck-fuel-capacity truck-obj)
						 truck-window
						 (world-map world-obj)
						 map-window
						 loc-window
						 display-string)))

;********************************

(defun really-make-display (display-corner-x 
							display-corner-y
							d-window-width
							d-window-height
							truck-obj
							arm-names
							bay-names
							fuel-capacity
							truck-window
							map-obj
							map-window
							loc-window
							display-string)
  (disp.terminate)
  (disp.init (make-window display-corner-x
                          display-corner-y
                          d-window-width
                          d-window-height)
             display-string)
  (disp.draw-rectangle (make-window 0
                                    0
                                    d-window-width
                                    d-window-height))
  (let ((new-thing (make-instance 'display-obj
                                  :truck-obj truck-obj)))
    (setf (truck-area new-thing) (make-truck-disp arm-names
                                                  bay-names
                                                  fuel-capacity
                                                  truck-window))
    (setf (map-area new-thing) (make-map-disp map-obj map-window))
    (setf (loc-area new-thing) (make-loc-disp loc-window))
    new-thing))
        
