;*******************************************************************
;  FUEL.LISP

(defclass fuel-disp  ()
  ((outer-window   :accessor outer-window   :initarg :outer-window)
   (inner-window   :accessor inner-window   :initarg :inner-window)
   (bottom-y       :accessor bottom-y       :initarg :bottom-y)
   (height-scale   :accessor height-scale   :initarg :height-scale)
   (current-value  :accessor current-value  :initform 0)
   (capacity       :accessor capacity       :initarg :capacity)
   (scale-x        :accessor scale-x        :initarg :scale-x)
   (scale-y        :accessor scale-y        :initarg :scale-y)
   (scale-width    :accessor scale-width    :initarg :scale-width)
   (scale-height   :accessor scale-height   :initarg :scale-height)))

(defun make-fuel-disp (capacity win)
  (let* ((inner-window (make-window (+ (x-coord win) 30)
									(+ (y-coord win) 10)
									(- (width win) 40)
									(- (height win) 20)))
		 (x (+ 1 (x-coord inner-window)))
		 (y (+ 1 (y-coord inner-window)))
		 (w (- (width inner-window) 2))
		 (h (- (height inner-window) 2))
		 (the-displayer 
		  (make-instance 'fuel-disp
						 :outer-window win
						 :inner-window inner-window
						 :capacity capacity
						 :scale-x x
						 :scale-y y
						 :scale-width w
						 :scale-height y
						 :bottom-y (- (+ y h) 1)
						 :height-scale (/  (coerce h 'float) capacity))))
	(fuel-display-gauge-picture the-displayer)
	the-displayer))

(defmethod display-window ((self fuel-disp))
  (outer-window self))

(defun fuel-display-gauge-picture (self)
  (let* ((outer-window (display-window self))
		 (inner-window (inner-window self))
		 (h4 (truncate (height inner-window) 4)))
	(disp.draw-rectangle inner-window)
	(disp.with-clip-window outer-window
      (disp.with-font (disp.small-font)
         (disp.text-at "  F" (make-position 3 15))
		 (disp.text-at "3/4" (make-position 3 (+ 15 h4)))
		 (disp.text-at "1/2" (make-position 3 (+ 15 (* 2 h4))))
		 (disp.text-at "1/4" (make-position 3 (+ 15 (* 3 h4))))
		 (disp.text-at "  E" (make-position 3 (+ 15 (* 4 h4))))))
	(disp.with-clip-window inner-window
		(do* ((l (list h4 (* 2 h4) (* 3 h4)) (cdr l))
			 (y (car l) (car l)))
			((null l) nil)
		  (disp.draw-line (make-position -3 y) (make-position 0 y))
		  (disp.draw-line (make-position (width inner-window) y)
						  (make-position (+ 3 (width inner-window)) y))))))

;******************************************************************8

(defmethod dm-set ((self fuel-disp) x val)
  (declare (ignore x))
  (cond 
    ((or (< val 0)
		 (> val (capacity self)))
	 (cerror "To continue" "Fuel gauge can't display ~a" val))
	(t (let ((new-height (truncate (+ 0.05 (* val (height-scale self))))))
		 (disp.clear-rectangle 
		  (make-window (scale-x self) (scale-y self)
					   (+ (scale-width self) 1) (- (scale-height self) 2)))
		 (disp.fill-rectangle 
		  (make-window (scale-x self) (- (bottom-y self) new-height)
					   (scale-width self) (+ 1 new-height)))
		  (setf (current-value self) val)))))

(defmethod dm-refresh ((self fuel-disp))
  (disp.clear-rectangle (outer-window self))
  (fuel-display-gauge-picture self)
  (dm-set self nil (current-value self)))



