;*************************************************************************
; ARM-SUPPORT.LISP

(defclass arm-disp ()
  ((dock-x :accessor dock-x  :initarg :dock-x)
   (dock-y :accessor dock-y  :initarg :dock-y)
   (corridor-list :accessor corridor-list :initarg :corridor-list)
   (bay-names :accessor bay-names  :initarg :bay-names)
   (dock-window :accessor  dock-window :initarg :dock-window)
   (current-loc :accessor current-loc :initarg :current-loc :initform '())
   (the-truck :accessor the-truck :initarg :the-truck :initform '())
   (cached-paths :accessor cached-paths :initarg :cached-paths :initform '())
   (cached-grippers
	:accessor cached-grippers :initarg :cached-grippers :initform '())
   (path-lines :accessor path-lines :initarg :path-lines  :initform '())
   (gripper-lines :accessor gripper-lines :initarg :gripper-lines :initform '())
   (right-cor-x :accessor right-cor-x :initarg :right-cor-x)
   (gauge-cor-y :accessor gauge-cor-y :initarg :gauge-cor-y)
   (bay1-cor-y :accessor bay1-cor-y :initarg :bay1-cor-y)
   (bay2-cor-y :accessor bay2-cor-y :initarg :bay2-cor-y)
   (gripper-x :accessor gripper-x :initarg :gripper-x)
   (gripper-y :accessor gripper-y :initarg :gripper-y)
   (gripper-length :accessor gripper-length :initarg :gripper-length)
   (gripper-orient :accessor gripper-orient :initarg :gripper-orient)
   (gripper-disp :accessor gripper-disp :initarg :gripper-disp)))

;************************************************************************

(defmethod set-truck ((self arm-disp) truck-obj)
  (setf (the-truck self) truck-obj)
  (arm.build-caches self)
  (dm-move self '() 'folded))

(defmethod dm-refresh ((self arm-disp))
  (if (path-lines self)
    (disp.draw-connected-lines (path-lines self)))
  (if (gripper-lines self)
    (disp.draw-disconnected-lines (gripper-lines self))))

(defmethod erase ((self arm-disp))
  (if (path-lines self)
    (disp.with-erasure 
     (disp.draw-connected-lines (path-lines self))))
  (setf (path-lines self) nil)
  (if (gripper-lines self)
    (disp.with-erasure 
     (disp.draw-disconnected-lines (gripper-lines self))))
  (setf (gripper-lines self)
       nil)
  (if (the-truck self)
    (refresh-arms (the-truck self))))

(defmethod dm-move ((self arm-disp) x loc)
  (declare (ignore x))
  (cond ((and (arm.same-loc? loc (current-loc self))
              (eq (gripper-disp self) 'outside))
         T)
        ((arm.same-loc? loc (current-loc self))
         (arm.change-gripper-direction 'outside self))
        ((eq loc 'inside)
         (cond ((eq (gripper-disp self) 'inside)
                T)
               (t 
                (arm.change-gripper-direction 'inside self))))
        (t (erase self)
           (disp.fill-rectangle (dock-window self))
           (arm.draw-path-lines loc self)
           (arm.draw-gripper-lines loc 'outside self)
           (setf (current-loc self) loc))))

