;*********************************************************************
;
; The simplest command processor just reads from the
; lisp interface, and prints output back to the lisp interface.
;
;*********************************************************************

(defun make-command-processor ()
  (list #'simple-input #'simple-output))

(defun simple-input ()
  (declare (ignore truck world))
  (print '==>)
  (let ((in (read)))
    (cond ((atom in)
	   (case in
	     ((nil quit bye exit q) nil)
	     (otherwise (format t "Enter a simulator command, e.g.~%  (eye-scan external)~%or 'quit to exit~%")
	      (simple-input))))
	  (t in))))

(defun simple-output (return-list)
  (format t "return-status: ~a~%return-value: ~a~%sensor-data: ~a~%"
	  (car return-list)
	  (cadr return-list)
	  (caddr return-list)))

