(in-package 'xtile)

(defun spp-fill-next-closest (world agent hole tiles-checked)
  (let* (tile-pos
        tile-obj
        (ok-world world)
        (ok-hole hole)
        new-world newer-world
        new-hole newer-hole
        (ok-agent agent)
        new-agent newer-agent
        plan-to plan-from
        (agent-row (obj-row agent))
        (agent-col (obj-col agent))
        (world-rows (tw-rows world))
        (world-cols (tw-cols world))
        (grid (make-array (list world-rows world-cols)
                           :initial-element nil)))
    (dotimes (i world-rows)
      (dotimes (j world-cols)
        (setf (aref grid i j)
              (aref (tw-grid world)  i j))))	
    (loop
        (setf new-world (tw-copy-world ok-world))
        (setf new-agent (find-same-obj ok-agent (tw-agent-list new-world)))
        (setf new-hole  (find-same-obj ok-hole (tw-hole-list new-world)))
        (multiple-value-setq (grid agent-row agent-col plan-to tile-pos)
          (path-to-tile grid agent-row agent-col plan-to tiles-checked))
        (format nil "~%Tile: ~s. Plan ~s" tile-pos plan-to)
        (when (not tile-pos)
          (return-from spp-fill-next-closest 
		    (values nil '(x) nil nil nil tiles-checked)))
        (setf tiles-checked (cons tile-pos tiles-checked))
        (setf tile-obj 
              (aref (tw-grid-which world) (car tile-pos)(cadr tile-pos)))
        (when (not (equal plan-to '(x)))
          (tw-simulate new-world new-agent plan-to)
          (setf newer-world (tw-copy-world new-world))
          (setf newer-agent (find-same-obj new-agent 
                                           (tw-agent-list newer-world)))
          (setf newer-hole
                (find-same-obj new-hole (tw-hole-list newer-world)))
          (setf plan-from (tw-plan-push new-world new-agent tile-obj
				    (obj-cells new-hole)))
          (when (not (equal plan-from '(x)))
            (tw-simulate newer-world newer-agent plan-from)
            (return-from spp-fill-next-closest
              (values tile-obj plan-to new-world 
                      plan-from newer-world tiles-checked)))))))

(defun path-to-tile (grid agent-row agent-col plan tiles-checked)
  (let (act tile-found
        (state 'initial))
    (loop
        (when (setf tile-found 
                    (tile-around-p grid agent-row agent-col tiles-checked))
          (return-from path-to-tile 
            (values grid agent-row agent-col plan tile-found)))
      (if (> (length plan) 400)
          (return-from path-to-tile 
            (values grid agent-row agent-col '(x) tile-found)))
      (case state 
          ('initial
           (multiple-value-setq (agent-row agent-col plan grid state act)
             (state-trans 
              'i agent-row agent-col plan grid 'go-right 'go-up 'go-left)))
          ('go-up 
           (multiple-value-setq (agent-row agent-col plan grid state act)
             (state-trans 
              'u agent-row agent-col plan grid 'go-right 'go-up 'go-left)))
          ('go-right            
           (multiple-value-setq (agent-row agent-col plan grid state act)
             (state-trans 
              'r agent-row agent-col plan grid 'go-down 'go-right 'go-up)))
          ('go-down 
           (multiple-value-setq (agent-row agent-col plan grid state act)
             (state-trans 
              'd agent-row agent-col plan grid 'go-left 'go-down 'go-right)))
          ('go-left 
           (multiple-value-setq (agent-row agent-col plan grid state act)
             (state-trans 
              'l agent-row agent-col plan grid 'go-up 'go-left 'go-down)))
          ('dead-end 
           (if plan
               (case (elt plan act)
                 ('u (setf plan (append plan '(d)))
                     (setf agent-row (1+ agent-row)))
                 ('d (setf plan (append plan '(u)))
                     (setf agent-row (1- agent-row)))
                 ('r (setf plan (append plan '(l)))
                     (setf agent-col (1- agent-col)))
                 ('l (setf plan (append plan '(r)))
                     (setf agent-col (1+ agent-col)))))
           (cond ((can-move 'go-up grid agent-row agent-col)
                  (setf state 'go-up))
                 ((can-move 'go-down grid agent-row agent-col)
                  (setf state 'go-down))
                 ((can-move 'go-left grid agent-row agent-col)
                  (setf state 'go-left))
                 ((can-move 'go-right grid agent-row agent-col)
                  (setf state 'go-right))
                 (t (setf state 'dead-end)
                    (setf act (1- act))))))
        (format nil "~%Pos ~s,~s.  plan ~s. next state ~s."
                agent-row agent-col plan state))))

                    
 (defun state-trans (dir row col plan grid state1 state2 state3)
  (let (act
        state
        (d-row 0)
        (d-col 0))
    (when (not (equal dir 'i))           
      (case dir
        ('u (setf d-row -1))
        ('d (setf d-row 1))
        ('l (setf d-col -1))
        ('r (setf d-col 1)))
      (setf row (+ d-row row)
            col (+ d-col col))
      (setf plan (append plan (list dir))))
    (setf (aref grid row col) 'p)
    (cond ((can-move state1 grid row col)
           (setf state state1))
          ((can-move state2 grid row col)
           (setf state state2))
          ((can-move state3 grid row col)
           (setf state state3))
          (t (setf state 'dead-end)
             (setf act (1- (length plan)))))
    (values row col plan grid state act)))

(defun can-move (dir grid row col)
  (let ((d-row 0)
        (d-col 0))
    (case dir
      ('go-up (setf d-row -1))
      ('go-down (setf d-row 1))
      ('go-left (setf d-col -1))
      ('go-right (setf d-col 1)))
    (setf row (+ d-row row)
          col (+ d-col col))
    (if (equal (aref grid row col) nothing-char)
        t
        nil)))

(defun tile-around-p (grid row col tiles-checked)
  (mapc #'(lambda(i j) 
            (if (and (member (aref grid (+ row i) (+ col j)) tile-chars)
                     (not (member (list (+ row i) (+ col j)) tiles-checked 
                                  :test #'equal)))
                (return-from tile-around-p (list (+ row i) (+ col j)))))
        '(-1  0  1 -1  1 -1  0  1)
        '(-1 -1 -1  0  0  1  1  1))
  nil)



