;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;;
;;; defvar.lisp
;;;
;;; Variable declarations for the X tileworld system.  Some things to
;;; note about the defvar function:
;;;
;;;      1. Defvar'ed variables are not just globals, they also declared
;;;          to be dynamically scoped everywhere.
;;;      2. If one of these variables is rebound using "let", the
;;;          new incarnation is still dynamically scoped.
;;;      3. The initial-value form is not evaluated until the variable's
;;;          value is needed.  Actually, this doesn't seem to work
;;;          in Sun Common Lisp even though Steele says it's standard.
;;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

(in-package 'xtile)


(defvar *hostname* nil "The name of the X host on which to run, or the
                        empty string for the current host.")

(defvar *display* nil "A CLX structure representing the connection to the
                       X server.  By my convention, nil when not connected.")

(defvar *screen* nil "A CLX structure representing the screen that *display*
                      displays on.")

(defvar *black*)
(defvar *white*)
(defparameter *fontname* "*-16-*")
(defvar *font*)
(defvar *font-baseline*)
(defvar *font-height*)
(defvar *border* 3)
(defvar *root*)
(defvar *colormap*)
(defvar *font-descent*)
(defvar *dummy-window*)
(defvar *gcontext*)

(defvar *quit* nil)
(defvar *busy*)
(defvar *handlers* nil)
(defvar *event-level* 0)

(defvar *experiment-file-name*)
(defvar *experiment-list* nil)
(defvar *series-name* "")
(defvar *current-experiment-list*)
(defvar *current-experiment*)

(defvar *exper-name*)
(defvar *exper-logfile*)		;fossils
(defvar *world-time-limit*)
(defvar *world-old-core*)
(defvar *world*)
(defvar *world-rand-seed*)
(defvar *agent*)
(defvar *elapsed*)

(defvar *exper-button-height*)
(defvar *exper-window-width*)
(defvar *exper-window-height*)
(defvar *exper-window-x*)
(defvar *exper-window-y*)
(defvar *exper-window*)
(defvar *exper-gc*)

(defparameter *min-square-size* 10)		;smaller, couldn't see much
(defparameter *hole-inner-size* .7)  ;;How big bottom of hole is compared to top
;(defparameter *label-font-name* "*-r-*-34-*") ;; Mongo version
(defparameter *label-font-name* "*typewriter-medium-*-20-*") ;;Medium version
;(defparameter *label-font-name* "*-6-*") ;;Tiny version

;;; Vars that don't have values here are calculated at runtime

(defvar *label-font*)
(defvar *label-baseline*)
(defvar *label-descent*)
(defvar *label-text-height*)
(defvar *label-text-width*)
(defvar *label-hborder*)
(defvar *label-vborder*)
(defvar *label-width*)
(defvar *label-height*)
(defvar *label-gc*)
(defvar *char-font-name*)
(defvar *char-font*)
(defvar *char-baseline*)
(defvar *char-descent*)
(defvar *char-text-height*)
(defvar *char-text-width*)
(defvar *char-hborder*)
(defvar *char-vborder*)
(defvar *char-width*)
(defvar *char-height*)
(defvar *char-gc*)
(defvar *square-size*)
(defvar *cell-height*)
(defvar *cell-width*)
(defvar *world-window*)
(defvar *world-window-width*)
(defvar *world-window-height*)
(defvar *world-window-x*)
(defvar *world-window-y*)
(defvar *world-gc*)
(defvar *old-world-board-size*)
(defvar *world-board-size*)

(defvar *world-pixmaps*)
(defvar *pixmap-size*)
(defvar *hole-pm*)
(defvar *nothing-pm*)
(defvar *obstacle-pm*)
(defvar *tile-pm*)
(defvar *agent-pm*)
(defvar *agent-up-pm*)
(defvar *agent-down-pm*)
(defvar *agent-left-pm*)
(defvar *agent-right-pm*)
(defvar *black-gc*)
(defvar *white-gc*)
(defvar *grey25-gc*)
(defvar *grey50-gc*)
(defvar *grey75-gc*)

;;; Fossils

(defvar *exprfile*)
(defvar *history*)
(defvar *game-length*)
(defvar *keephistory*)
(defvar *historyfile*)
(defvar *display-on*)

;;;
(defvar *world-nseeds*)
(defvar *world-wait-between-seeds*)
(defvar *world-wait-after-all-seeds*)
(defvar *time-remaining*)

(defvar *current-seed*)
(defvar *seeds-left*)

(defvar *agent-name*)
(defvar *agent-speed*)
(defvar *agent-evalfunc*)
(defvar *agent-path-planner*)
(defvar *agent-threshold*)
(defvar *world-name*)
(defvar *exper-save-file-name*)

(defvar *exper-dialog*)
(defvar *exper-dialog-spec*)
(defvar *exper-save-time*)

(defvar *loaded-as*)

(defvar *world-speed*)
(defvar *world-hole-score-min*)
(defvar *world-hole-score-max*)
(defvar *world-hole-size-min*)
(defvar *world-hole-size-max*)
(defvar *world-hole-num-min*)
(defvar *world-hole-num-max*)

(defvar *exper-keeplog*)		;the boolean
