;;;
;;; agent-dialog.lisp
;;;
;;; The agent-module's dialog box stuff.
;;;

(in-package 'xtile)

(defvar *agent-dialog-spec*)
(defvar *agent-dialog*)

(setf *agent-dialog-spec*
      (make-dialog-spec :name "Agent Parameters"
			:buttons nil
			:fields (list
				 (make-field-spec
				  :label "Agent name:"
				  :getf #'(lambda () *agent-name*)
				  :testf #'(lambda (x) (or x t))
				  :putf #'(lambda (x) (setf *agent-name* x)))
				 (make-field-spec
				  :label "Speed:"
				  :getf #'(lambda () (format () "~s" *agent-speed*))
				  :testf #'(lambda (x) 
					     (let ((f (read-from-string x)))
					       (and (floatp f) (< 0 f 10))))
				  :putf #'(lambda (x) 
					    (setf *agent-speed* (read-from-string x))
					    (xtw-set-agent-parms)))
				 (make-field-spec
				  :label "Eval-func:"
				  :getf #'(lambda () (symbol-name *agent-evalfunc*))
				  :testf #'(lambda (x)
					     (let ((s (intern (symbol-name 
							       (read-from-string x)) 
							      'xtile)))
					       (or (eq s 'simple)
						   (eq s 'seu)
                                                   (eq s 'actual)
                                                   (eq s 'optimal))))
				  :putf #'(lambda (x)
					    (let ((s (intern (symbol-name 
							      (read-from-string x)) 
							     'xtile)))
					      (setf *agent-evalfunc* s)
					      (xtw-set-agent-parms))))
                                 (make-field-spec
				  :label "Path-Planner:"
				  :getf #'(lambda () (symbol-name *agent-path-planner*))
				  :testf #'(lambda (x)
					     (let ((s (intern (symbol-name 
							       (read-from-string x)) 
							      'xtile)))
					       (or (eq s 'search)
						   (eq s 'direct))))
				  :putf #'(lambda (x)
					    (let ((s (intern (symbol-name 
							      (read-from-string x)) 
							     'xtile)))
					      (setf *agent-path-planner* s)
					      (xtw-set-agent-parms))))
				 (make-field-spec
				  :label "Threshold:"
				  :getf #'(lambda () (prin1-to-string *agent-threshold*))
				  :testf #'(lambda (x)
					     (let ((n (read-from-string x)))
					       (and (integerp n) 
						    (< -1000 n 1000))))
				  :putf #'(lambda (x)
					    (setf *agent-threshold* (read-from-string x))
					    (xtw-set-agent-parms)))
				 )
			)
      )

(defun xtw-agent-update-dialog ()
  (if (null *agent-dialog*)
      (setf *agent-dialog* (create-new-dialog *agent-dialog-spec*))
    (update-fields *agent-dialog*)))
