;;; ti-graphics.lisp	D. Musliner
;;; - TI-dependent routines to implement di-graphics calls.

;  Copyright 1991, 1992
;  Regents of the University of Michigan
;  
;  Permission is granted to copy and redistribute this software so long as
;  no fee is charged, and so long as the copyright notice above, this
;  grant of permission, and the disclaimer below appear in all copies made.
;  
;  This software is provided as is, without representation as to its fitness
;  for any purpose, and without warranty of any kind, either express or implied,
;  including without limitation the implied warranties of merchantability and fitness
;  for a particular purpose.  The Regents of the University of Michigan shall not
;  be liable for any damages, including special, indirect, incidental, or
;  consequential damages, with respect to any claim arising out of or in
;  connection with the use of the software, even if it has been or is hereafter
;  advised of the possibility of such damages.


;;; NOTE NOTE labels are currently ignored for TI graphics.
;;; here's example from old graphics, what do args mean?
;;;       (send *mice-key-window* :draw-string w:medfnb-font
    	;;" Agent      Fire Agent       Burned " 30 30
 	;;w:black 0 8 1)

;;; NOTE NOTE di-ti-draw-lines currently ignored for TI graphics.
;;;

(provide 'ti-graphics)

(require 'di-graphics "di-graphics")

;(in-package 'di-graphics)

(proclaim '(optimize (speed 3) (safety 1)))

;(import '(windows:draw-polyline windows:draw-circle windows:make-position 
;		windows:make-window windows:clear-bitmap
;         	windows:delete-viewport windows:expose-viewport 
;		windows:window-title))

;;; ---------------------------------------------------------------------------
;;; TI graphics global constants.

(defvar *front-window* nil)	;; 2 windows for double buffering scheme.
(defvar *rear-window* nil)

(defvar *width* nil)
(defvar *height* nil)

(defvar *ti-x-mag* 1)
(defvar *ti-y-mag* 1)

(defvar *ti-x-offset* 0)
(defvar *ti-y-offset* 0)

;;; ---------------------------------------------------------------------------
(defflavor ti-graphics-window () 
	(w:bottom-box-label-mixin w:borders-mixin w:graphics-mixin w:window))

;;; ---------------------------------------------------------------------------

(defun di-ti-deinitialize-graphics ()
  (if *front-window* (send *front-window* :kill))
  (if *rear-window* (send *rear-window* :kill))
  (setf *front-window* nil)
  (setf *rear-window* nil))

;;; ---------------------------------------------------------------------------
;;; NOTE need to get x/y-ppi for TI

(defun di-ti-initialize-graphics (width height xmin ymin xmax ymax)
  (let ((ti-x-ppi 100)		;; NOTE just guesses for now.
 	(ti-y-ppi 100))

  (di-ti-deinitialize-graphics)
        ;; remap window dimensions from inches to pixels.
  (setf *width* (round (* ti-x-ppi width)))
  (setf *height* (round (* ti-y-ppi height)))

        ;; setup xy-mag and xy-offset to fit coord range w/in window.
  (setf *ti-x-offset* (- xmin))
  (setf *ti-y-offset* (- ymin))
  (setf *ti-x-mag* (/ *width* (- xmax xmin)))
  (setf *ti-y-mag* (/ *height* (- ymax ymin)))


  (setf *front-window*
          (make-instance 'ti-graphics-window
                         :blinker-p nil
                         :deexposed-typeout-action :permit
                         ;;:edges-from (if default-location
                         ;;                '(0 0 2000 2000)
                         ;;                :mouse)
                         :minimum-width (+ 20 *width*)
                         :minimum-height (+ 20 *height*)
                         :save-bits t
                         :inside-size (list *width* *height*)))
    ;;(send *front-window* :set-inside-size *width* *height*)
    (send *front-window* :set-label "Lisp TI-graphics")
    (send *front-window* :expose)
    (setf *rear-window*
          (make-instance 'ti-graphics-window
                         :deexposed-typeout-action :permit
                         :activate-p t
                         :blinker-p nil
                         :save-bits t
    			 ;;:set-label "Lisp TI-graphics"
                         :edges-from *front-window*
                         :inside-size (list *width* *height*)))
    (send *rear-window* :deexpose :force)))

;;; ---------------------------------------------------------------------------
(defun di-ti-label-drawing (label) 
  (send *rear-window* :set-label label))

;;; ---------------------------------------------------------------------------
(defun di-ti-start-drawing (&aux temp)
  (send *rear-window* :refresh))

;;; ---------------------------------------------------------------------------
(defun di-ti-finish-drawing (&aux temp)
  (setf temp *front-window*)
  (setf *front-window* *rear-window*)
  (setf *rear-window* temp)
  (send *rear-window* :deexpose :force)
  (send *front-window* :expose))

;;; ---------------------------------------------------------------------------
;;; NOTE is the color correct? I think 0 = white, 8 = black... are we drawing
;;; white on black?
;;; NOTE the way these are now, they dont specify a fill color.... do you think
;;; there is a default?
;;; if not, this may not be a very slick arrangement after all....

(defun di-ti-draw-rectangle (xmin ymin xmax ymax
                            &key (filled nil) (label nil)
                            &allow-other-keys &aux width height)

  (setf xmin (round (* (+ xmin *ti-x-offset*) *ti-x-mag*)))
  (setf xmax (round (* (+ xmax *ti-x-offset*) *ti-x-mag*)))
  (setf width (- xmax xmin))
  (cond ((< *ti-y-mag* 0) ;; when negative Y mag, dont invert Y axis (for MICE)
         (setf ymin (round (- (* (+ ymin *ti-y-offset*) *ti-y-mag*))))
         (setf ymax (round (- (* (+ ymax *ti-y-offset*) *ti-y-mag*))))
         (setf height (- ymax ymin))
         )
        (T
         (setf ymin (round (* (+ ymin *ti-y-offset*) *ti-y-mag*)))
         (setf ymax (round (* (+ ymax *ti-y-offset*) *ti-y-mag*)))
         (setf height (- ymax ymin))
         (setf ymin (- *height* height ymin))))

  (send *rear-window* 
	(if filled :draw-filled-rectangle :draw-rectangle)
	xmin ymin width height)
)

;;; ---------------------------------------------------------------------------
(defun di-ti-draw-circle (xmin ymin xmax ymax
                            &key (filled nil) (label nil)
                            &allow-other-keys &aux width height)
  (setf xmin (round (* (+ xmin *ti-x-offset*) *ti-x-mag*)))
  (setf xmax (round (* (+ xmax *ti-x-offset*) *ti-x-mag*)))
  (setf width (- xmax xmin))
  (cond ((< *ti-y-mag* 0) ;; when negative Y mag, dont invert Y axis (for MICE)
         (setf ymin (round (- (* (+ ymin *ti-y-offset*) *ti-y-mag*))))
         (setf ymax (round (- (* (+ ymax *ti-y-offset*) *ti-y-mag*))))
         (setf height (- ymax ymin))
         )
        (T
         (setf ymin (round (* (+ ymin *ti-y-offset*) *ti-y-mag*)))
         (setf ymax (round (* (+ ymax *ti-y-offset*) *ti-y-mag*)))
         (setf height (- ymax ymin))
         (setf ymin (- *height* height ymin))))

  (send *rear-window* 
	(if filled :draw-filled-circle :draw-circle)
	(+ xmin (/ width 2)) (+ ymin (/ height 2)) 
	(/ (- xmax xmin) 2))
)
			
;;; ---------------------------------------------------------------------------
(defun di-ti-draw-triangle (x1 y1 x2 y2 x3 y3
                            &key (filled nil) (label nil)
                            &allow-other-keys)
  (setf x1 (ti-convert-x x1)) 
  (setf x2 (ti-convert-x x2))
  (setf x3 (ti-convert-x x3))
  (setf y1 (ti-convert-y y1)) 
  (setf y2 (ti-convert-y y2))
  (setf y3 (ti-convert-y y3))
;  (cond ((< *x-y-mag* 0) ;; when negative Y mag, dont invert Y axis (for MICE)
;         (setf ymin (round (- (* (+ ymin *x-y-offset*) *x-y-mag*))))
;         (setf ymax (round (- (* (+ ymax *x-y-offset*) *x-y-mag*))))
;         (setf height (- ymax ymin))
;         )
;        (T
;         (setf ymin (round (* (+ ymin *x-y-offset*) *x-y-mag*)))
;         (setf ymax (round (* (+ ymax *x-y-offset*) *x-y-mag*)))
;         (setf height (- ymax ymin))
;         (setf ymin (- *height* height ymin))))

  (send *rear-window* 
	(if filled :draw-filled-triangle :draw-triangle)
	x1 y1 x2 y2 x3 y3)
)
			
;;; ---------------------------------------------------------------------------

(defun ti-convert-x (x) (round (* (+ x *ti-x-offset*) *ti-x-mag*)))

(defun ti-convert-y (y) 
  (cond ((< *ti-y-mag* 0)
	 (round (- (* (+ y *ti-y-offset*) *ti-y-mag*))))
	(T
	 (- *height* (round (* (+ y *ti-y-offset*) *ti-y-mag*))))))

;;; ---------------------------------------------------------------------------
(defun di-ti-draw-segments (&rest seglist)
  (setf seglist (map-even #'ti-convert-x seglist))
  (setf seglist (map-odd #'ti-convert-y seglist))
  (apply #'internal-ti-draw-segments seglist))

(defun internal-ti-draw-segments (&rest seglist)
  (cond (seglist
	 (send *rear-window*
	       :draw-line (first seglist) (second seglist) 
	       (third seglist) (fourth seglist))
	 (apply #'internal-ti-draw-segments (rest (rest (rest (rest seglist))))))
	(T nil)))

;;; ---------------------------------------------------------------------------

(defun di-ti-center-text (x y text)
  (setf x (ti-convert-x x))
  (setf y (ti-convert-y y))
  (send *rear-window*
	:draw-string w:medfnb-font text x y 0 0 0 1.7))






