;;;;	test-graphics.lisp 		D. Musliner
;;;;
;;;; - routines to test device-independent graphics.

;  Copyright 1991, 1992
;  Regents of the University of Michigan
;  
;  Permission is granted to copy and redistribute this software so long as
;  no fee is charged, and so long as the copyright notice above, this
;  grant of permission, and the disclaimer below appear in all copies made.
;  
;  This software is provided as is, without representation as to its fitness
;  for any purpose, and without warranty of any kind, either express or implied,
;  including without limitation the implied warranties of merchantability and fitness
;  for a particular purpose.  The Regents of the University of Michigan shall not
;  be liable for any damages, including special, indirect, incidental, or
;  consequential damages, with respect to any claim arising out of or in
;  connection with the use of the software, even if it has been or is hereafter
;  advised of the possibility of such damages.


(require 'tools "tools")
(require 'di-graphics "di-graphics")

(cond ((y-or-n-p "Run X graphics test? ")
	(di-set-graphics-mode 'x))
      ((y-or-n-p "Run PS graphics test? ")
	(di-set-graphics-mode 'ps))
      (T (format t "No test selected~%")
	 (break)))

(format T "Deinitializing old graphics window (if exists)~%")
(di-deinitialize-graphics)
(format T "Initializing graphics window~%")
(di-initialize-graphics 7 3.5 0 0 2000 1000)
(format T "Starting drawing~%")
(di-start-drawing)

(di-label-drawing "test-graphics.lisp test drawing")
(di-draw-rectangle 150 150 300 400 :label "Foo")
(di-draw-rectangle 900 100 1400 200 :label "Hi dave")
(di-draw-rectangle 400 450 900 750 :filled T)

(di-draw-rectangle 100 800 200 900)
(di-draw-circle 100 800 200 900)

(di-draw-rectangle 900 800 1400 900)
(di-draw-circle 900 800 1400 900 :filled T)

(di-draw-circle 1700 500 1900 700 :label "Wow, cool")

(di-draw-circle 900 800 1400 900 :filled T)

(di-draw-segments 100 100 200 200 900 750 1400 200 925 775 1425 225)

(format T "Finishing drawing~%")
(di-finish-drawing)
