;; structures.lisp

;  Copyright 1991, 1992
;  Regents of the University of Michigan
;  
;  Permission is granted to copy and redistribute this software so long as
;  no fee is charged, and so long as the copyright notice above, this
;  grant of permission, and the disclaimer below appear in all copies made.
;  
;  This software is provided as is, without representation as to its fitness
;  for any purpose, and without warranty of any kind, either express or implied,
;  including without limitation the implied warranties of merchantability and fitness
;  for a particular purpose.  The Regents of the University of Michigan shall not
;  be liable for any damages, including special, indirect, incidental, or
;  consequential damages, with respect to any claim arising out of or in
;  connection with the use of the software, even if it has been or is hereafter
;  advised of the possibility of such damages.

;;;            This work has been sponsored in part by:
;;;               the NSF (IRI-9010645, IRI-9015423)
;;;         the University of Michigan Rackham Graduate School
;;;


;(in-package 'MICE)

(use-package 'umass-extended-lisp)

;(export '(*add-randomness*
;          *current-time*
;          *current-agent*
;          *sort-agent-predicate*
;          *default-sort-agent-predicate*
;          *agent-schedule-queue*
;          *all-agents*))
;
(proclaim '(optimize (speed 3) (safety 1)))

;;; ***************************************************************************

(defvar *cautious?* nil)

;;; allows some randomness into the direction chosen to get to a goal location

(defvar *add-randomness* t)

;;;   A global variable to maintain the current-time (simulated)

(defvar *current-time* 0)

(defvar *current-agent* 0)

(defvar *agent-schedule-queue* nil)

(defvar *all-agents* nil)

(defvar *mice-channels* nil)

(defvar *longest-move-time* 0)

(defvar *verbose?* nil)

(defvar *collision-verbose* nil)

(defvar *link-verbose* nil)

(defvar *temp-authority* nil)

(defvar *debug?* nil)

(defvar *interruptable-command-sequences?* nil
 "If non-nil, MICE will clear the command buffer each time an
  agent is executed.")

;(defvar *mice-default-random-state?* nil
;"If non-nil, will cause the saved random-state to be loaded in whenever
;mice is run, so the sequence of random numbers generated for 2 runs of the
;same environment will be the same.")

(defvar *real-time-knob* nil
"If non-nil, each agent that is invoked is charged for time spent reasoning
corresponding to the formula [reasoning-units = k * real-time-seconds], rounded
to the nearest integer.  If nil, then no charge for reasoning is made.")

; This is used when the board is being printed to the screen, and specifies how often
; the printing is done.

(defvar *print-board-interval* 1)

;;; Event counters

(defvar *move-back-count* nil)

(defvar *move-count* nil)

(defvar *attempted-move-count* nil)

;;; The *event-function-list* is an assoc list of events and functions to be called when
;;; an event occurs.  Events include :LINK, :UNLINK, :MOVE-BACK, :SUCCESSFUL-MOVES,
;;; :ATTEMPTED-MOVES, and :ROTATE-FAIL.

(defvar *event-function-list* nil)

(defvar *status-change-actions* (list :ACTIVATED :INACTIVATED :CREATED :REMOVED))

(defvar *other-state-history-information-function* nil)

(defvar *can-overwrite-links* nil)

;;;   A location is an x,y pair

(defxstruct (location :EXPORT (:CONC-NAME "LOCATION$"))
  (x :LIMBO)
  (y :LIMBO))

;;;   A region

(defxstruct (region :EXPORT (:CONC-NAME "REGION$"))
  (x-min 0 :TYPE integer)
  (y-min 0 :TYPE integer)
  (x-max 0 :TYPE integer)
  (y-max 0 :TYPE integer))

;;;;   A command to the mice shell

;(defxstruct (mice-command :EXPORT (:CONC-NAME "MICE-COMMAND$"))
;  (command :NULL-ACTION)
;  (parameters nil)
;  (time-cost 0))

;;;   An element of the two-dimensional MICE world.

(defxstruct (grid-element (:CONC-NAME "GRID-ELEMENT$"))
  (agents        nil)
  (agent-history nil)    ;An assoc list by time containing lists of agents
  (features      nil)
  (draw-function nil))

(defvar *removed-agent-grid-location* (make-grid-element))

(defstruct (simulation-data (:CONC-NAME "SIMULATION-DATA$"))
  (last-agent               0               :TYPE    integer)
  (overall-region           (make-region :X-MIN 0 :Y-MIN 0 :X-MAX 20 :Y-MAX 20)   :TYPE region)
  (overall-time            -1               :TYPE    integer)
  (grid                     nil))

(defvar *simulation-data* (make-simulation-data))

;;; Sensor-data indicates the sensor's range, time it takes to scan, and things that obstruct it.

(defxstruct (sensor-data :EXPORT (:CONC-NAME "SENSOR-DATA$"))
  (range          (make-region :X-MIN -5 :Y-MIN -5 :X-MAX 5 :Y-MAX 5)    :TYPE region)
  (time           0                                                      :TYPE integer)
  (orientation-sensitive-p :UNKNOWN)
  (obstructed-by  nil)
  (interesting-p    #'(lambda (grid-elem)
                        (and (not (null (grid-element$agents grid-elem)))
                             (some #'(lambda (agent)
                                       (null (agent$removal-time agent)))
                                   (grid-element$agents grid-elem))))))

(defvar *default-sensor* (make-sensor-data))

;;;   Move-data indicates the time it takes to move in a particular direction

(defstruct (move-data (:CONC-NAME "MOVE-DATA$"))
  (north     1   :TYPE integer)
  (south     1   :TYPE integer)
  (east      1   :TYPE integer)
  (west      1   :TYPE integer)
  (forward   1   :TYPE integer)
  (backward  1   :TYPE integer)
  (left      1   :TYPE integer)
  (right     1   :TYPE integer)
  (rotate-one-quadrant 1 :TYPE integer))

;;;   A link maintains the connection between a composite agent and a sub-component (also an agent).

(defstruct (link (:CONC-NAME "LINK$"))
  (composite-agent  nil)
  (sub-component    nil)
  (type             nil))                       ;:FRONT, :LEFT, :RIGHT, and :BACK are rigid links that
                                                ;require the relative orientation to be maintained between a
                                                ;composite agent and its sub-component while :NEXT-TO
                                                ;is a non-rigid link that is satisfied as long as the
                                                ;the agents are 4-connected.  The :SHARED-LOC link is
                                                ;satisfied if the agents are in the same location.

(defvar *links* nil)                                ;List of links between agents.
(defvar *attempted-links* nil)                       ;List of intended links between agents

;;;   An action attempted by an agent

(defstruct (agent-action (:CONC-NAME "AGENT-ACTION$"))
  (action         nil)                          ;:ACTIVATED, :INACTIVATED, :CREATED, :REMOVED,
                                                ;:MOVE, :LINK or :UNLINK.
  (time           *current-time*     :TYPE integer))

;;;   An agent's state

(defxstruct (agent-state :EXPORT (:CONC-NAME "AGENT-STATE$"))
  (location       (make-location)     :TYPE location)  
  (status          nil)                         ; :CREATED, :ACTIVATED, :INACTIVATED or :REMOVED
  (orientation     nil)                         ; Facing :NORTH, :SOUTH, :EAST or :WEST
  (action-history  nil)                         ; Acons list by time of actions
  (linkages        nil)
  (other           nil))

;;;   An agent

(defxstruct (agent :EXPORT (:CONC-NAME "AGENT$") (:PRINT-FUNCTION agent-print-function))
  (name                nil)
  (current-status      :CREATED)
  (location       (make-location)     :TYPE location)
  (current-time    *current-time*     :TYPE integer)
  (type                nil)
  (blocked-by-types    nil)
  (capture-types       nil)
  (captured-by-types   nil)
  (draw-function       nil)
  (sensors      (list (make-sensor-data)))      ; List of sensors available for use.
  (move-data     (make-move-data))               ;  :TYPE move-data)
  (scan-data-buffer    nil) 
  (command-buffer      nil)                      ; stores future commands
  (link-cost-alist     '((:ALL . 1)))            ; associate agent types with cost to link to them
  (unlink-cost-alist   '((:ALL . 1)))            ; associate agent types with cost to unlink from them
  (creation-time   *current-time*)
  (removal-time        nil)
  (state-history   (acons -1
                          (make-agent-state :ACTION-HISTORY
                                            (acons *current-time* (make-agent-action :ACTION :CREATED
                                                                                     :TIME *current-time*)
                                                   nil))
                          nil))
  (create-p            nil)                     ;Should a new agent be created.
  (remove-p            nil)                     ;Should an agent be removed.
  (activate-p          nil)                     ;Should this agent be activated.
  (inactivate-p        nil)                     ;Should this agent be inactivated.
  (create-function     nil)                     ;How to create a new agent.
  (remove-function     nil)                     ;How to remove an agent.
  (activate-function   nil)                     ;Function applied when this agent is activated.
  (inactivate-function nil)                     ;Function applied when this agent is inactivated.
  (domain-variables    nil)
  (overlap-predicates  nil)
  (invocation-function nil)
  (collision-function  nil)
  (orientation         :NORTH)                  ;Facing :NORTH, :SOUTH, :EAST or :WEST.
  (super-component     nil)                     ;Cons of parent and type of link to parent.
  (sub-components      nil)                     ;Acons list of children and type of link to each child.
  (authority           nil)
  (channels            nil)			;Channel list to which the agent is participating
  (receive-queue       nil)		        ;Mice puts the received messages to this queue.
  (receive-message-buffer nil)		        ;:RECV command saves the received message to this buffer.
  )

(defun agent-print-function (agent stream print-level)
  (declare (ignore print-level))
  (format stream "~A" (agent$name agent)))

(defun make-agent-name ()
  (format nil "A~a"
          (setf (simulation-data$last-agent *simulation-data*)
                (1+ (simulation-data$last-agent *simulation-data*)))))

;;;   Communication channel

(defxstruct (channel :EXPORT (:CONC-NAME "CHANNEL$"))
  (name         	nil)
  (agents               nil)		; Participating agent names
  (delay                1)
  (capacity             nil)		; Average number of messages per unit time. nil means infinity
  (reliability          1.0)		; Probability of successful message communication
  (range                nil)		; (make-region :X-MIN -5 :Y-MIN -5 :X-MAX 5 :Y-MAX 5)
					; nil for infinity range
  (orientation-sensitive-p :UNKNOWN)
  (obstructed-by        nil)		; A function that takes a grid-element as an argument and returns 
					;a number between 0 and 1 indicating the width of the obstruction 
					;in the grid location
  (failure-message-priority 0)		; A negative value causes the failure messages to be sent back and
  					; a positive value is new priority of the message after failure.
  (time-to-send 0)			; The time required to :SEND a message.
  (time-to-receive 0)			; The time required to :RECV messages.

  ;; Internal slots, not for user interface
  (status               :CREATED)
  (cost                 0)
  ;;(statistics     	(make-communication-statistics))
  (message-buffer       nil)		
  (on-going-messages    nil)
  (current-time         *current-time* :TYPE integer)
  )

;;(defxstruct (communication-statistics :EXPORT (:CONC-NAME "communication-statistics$"))
;;  (n-success		0)
;;  (n-failure		0)
;;  (n-obstruction	0)
;;  (n-outrange		0)
;;  (total-cost		0)
;;  (total-delay	0)
;;  )

(defstruct (message (:CONC-NAME message$))
  speaker                               ; Sender's name
  hearer                                ; Receiver's name or :all
  type                                  ; The type of message-content
  content                               ; The content of the message
  (priority 		0)		; Message transmission priority >= 0
  channel-name				; The name of the channel through which the message is sent
  time-created                          ; time stamp
  status                                ; :created :on-the-way :over-capacity
					; :out-of-range :obstructed :failure :success
)

(defun make-channel-name ()
  (format nil "C~a"
          (setf (simulation-data$last-agent *simulation-data*)
                (1+ (simulation-data$last-agent *simulation-data*)))))

(defvar *remote-hosts*)

(defvar *time-limit* 200)
