;; saverestore.lisp

;  Copyright 1991, 1992
;  Regents of the University of Michigan
;  
;  Permission is granted to copy and redistribute this software so long as
;  no fee is charged, and so long as the copyright notice above, this
;  grant of permission, and the disclaimer below appear in all copies made.
;  
;  This software is provided as is, without representation as to its fitness
;  for any purpose, and without warranty of any kind, either express or implied,
;  including without limitation the implied warranties of merchantability and fitness
;  for a particular purpose.  The Regents of the University of Michigan shall not
;  be liable for any damages, including special, indirect, incidental, or
;  consequential damages, with respect to any claim arising out of or in
;  connection with the use of the software, even if it has been or is hereafter
;  advised of the possibility of such damages.

;;;            This work has been sponsored in part by:
;;;               the NSF (IRI-9010645, IRI-9015423)
;;;         the University of Michigan Rackham Graduate School
;;;

;(in-package 'MICE)

(proclaim '(optimize (speed 3) (safety 1)))

;;; ***************************************************************************
;;; DJM: new save and restore functions use only the di-graphics calls, so
;;;  do not store any MICE-specific stuff, and we can replay the simulations
;;;	without any of the MICE stuff loaded.  
;;; - also save 5-8x on space, and replay faster.

;;; - runs saved using the old commands have a ".mice" suffix, while those
;;;	saved with the new commands are given a ".dig" suffix.

(defun save-mice-graphics (filename)
  "(save-mice-graphics filename)
	- saves graphics calls needed to redisplay the simulation."
  (di-save-drawings filename))

(defun restore-mice-graphics (filename)
  "(restore-mice-graphics filename)
	- restores graphics calls needed to redisplay the simulation."
  (di-restore-drawings filename))

;;; ***************************************************************************

(defun save-mice-history (filename)

  "SAVE-MICE-HISTORY filename

Currently, saves information about the agents needed for the graphics."

  (with-open-file (stream (merge-pathnames filename "*.mice")
                          :direction :output
                          :if-exists :new-version)
    (format stream "~%(setf *all-agents* nil)")
    (dolist (agent-name-and-structure *all-agents*)
      (let ((agent (rest agent-name-and-structure)))
        (format stream "~%(create-agent
                          :NAME '~S
                          :CURRENT-STATUS '~S
                          :LOCATION '~S
                          :CURRENT-TIME ~S
                          :TYPE '~S
                          :BLOCKED-BY-TYPES '~S
                          :CAPTURE-TYPES '~S
                          :CAPTURED-BY-TYPES '~S
                          :DRAW-FUNCTION '~S
                          :SENSORS '~S
                          :MOVE-DATA '~S
                          :CREATION-TIME ~S
                          :REMOVAL-TIME ~S
                          :STATE-HISTORY '~S
                          :CREATE-P '~S
                          :REMOVE-P '~S
                          :ACTIVATE-P '~S
                          :INACTIVATE-P '~S
                          :CREATE-FUNCTION '~S
                          :REMOVE-FUNCTION '~S
                          :ACTIVATE-FUNCTION '~S
                          :INACTIVATE-FUNCTION '~S
                          :DOMAIN-VARIABLES '~S
                          :OVERLAP-PREDICATES '~S
                          :COLLISION-FUNCTION '~S
                          :ORIENTATION '~S
                          :SUPER-COMPONENT '~S
                          :SUB-COMPONENTS '~S
                          :AUTHORITY '~S)"
                (agent$name agent)
                (agent$current-status agent)
                (agent$location agent)
                (agent$current-time agent)
                (agent$type agent)
                (agent$blocked-by-types agent)
                (agent$captured-by-types agent)
                (agent$capture-types agent)
                (agent$draw-function agent)
                (agent$sensors agent)
                (agent$move-data agent)
                (agent$creation-time agent)
                (agent$removal-time agent)
                (agent$state-history agent)
                (agent$create-p agent)
                (agent$remove-p agent)
                (agent$activate-p agent)
                (agent$inactivate-p agent)
                (agent$create-function agent)
                (agent$remove-function agent)
                (agent$activate-function agent)
                (agent$inactivate-function agent)
                (agent$domain-variables agent)
                (agent$overlap-predicates agent)
		(agent$collision-function agent)
		(agent$orientation agent)
		(agent$super-component agent)
		(agent$sub-components agent)
		(agent$authority agent)
 ;               (agent$invocation-function agent)
                )))
    (format stream "~%(setf *current-time* ~S)" *current-time*)
    (format stream "~%(setf *simulation-data*
                            (make-simulation-data :OVERALL-REGION '~S :OVERALL-TIME '~S))"
            (simulation-data$overall-region *simulation-data*)
            (simulation-data$overall-time   *simulation-data*))
    (format stream "~%(setf (simulation-data$grid *simulation-data*)
        (make-array (list (1+ (- (region$x-max (simulation-data$overall-region *simulation-data*))
                                 (region$x-min (simulation-data$overall-region *simulation-data*))))
                          (1+ (- (region$y-max (simulation-data$overall-region *simulation-data*))
                                 (region$y-min (simulation-data$overall-region *simulation-data*)))))
                    :element-type 'grid-element))"
            )
    (do ((x (region$x-min (simulation-data$overall-region *simulation-data*)) (1+ x)))
        ((> x (region$x-max (simulation-data$overall-region *simulation-data*))) nil)
      (do ((y (region$y-min (simulation-data$overall-region *simulation-data*)) (1+ y)))
          ((> y (region$y-max (simulation-data$overall-region *simulation-data*))) nil)
        (let ((grid-element (get-grid-element nil nil :X x :Y y)))
          (when grid-element (format stream "~%(let ((grid-element (get-grid-element nil t :X ~S :Y ~S)))
                                                 (setf (grid-element$agents grid-element) '~S)
                                                 (setf (grid-element$agent-history grid-element) '~S)
                                                 (setf (grid-element$features grid-element) '~S)
                                                 (setf (grid-element$draw-function grid-element) '~S))"
                                     x y (grid-element$agents grid-element) (grid-element$agent-history grid-element)
                                     (grid-element$features grid-element) (grid-element$draw-function grid-element))))))
    ))

;;; ***************************************************************************

(defun restore-mice-history (filename)
  ;(let ((*package* (find-package 'mice)))
    (load (merge-pathnames filename ".mice")))




