;; measures.lisp

;  Copyright 1991, 1992
;  Regents of the University of Michigan
;  
;  Permission is granted to copy and redistribute this software so long as
;  no fee is charged, and so long as the copyright notice above, this
;  grant of permission, and the disclaimer below appear in all copies made.
;  
;  This software is provided as is, without representation as to its fitness
;  for any purpose, and without warranty of any kind, either express or implied,
;  including without limitation the implied warranties of merchantability and fitness
;  for a particular purpose.  The Regents of the University of Michigan shall not
;  be liable for any damages, including special, indirect, incidental, or
;  consequential damages, with respect to any claim arising out of or in
;  connection with the use of the software, even if it has been or is hereafter
;  advised of the possibility of such damages.

;;;            This work has been sponsored in part by:
;;;               the NSF (IRI-9010645, IRI-9015423)
;;;         the University of Michigan Rackham Graduate School
;;;

;(in-package 'MICE)

(proclaim '(optimize (speed 3) (safety 1)))

;;; ***************************************************************************

(defun incr-move-back-count (agent-list)
  (setf *move-back-count* (+ *move-back-count* (length agent-list))))

;;; ---------------------------------------------------------------------------

(defun count-move-back-by-type (agent-list)
  (setf *move-back-count* (count-by-type agent-list *move-back-count*)))

;;; ---------------------------------------------------------------------------

(defun count-attempted-move-by-type (agent-list)
  (setf *attempted-move-count* (count-by-type agent-list *attempted-move-count*)))

;;; ---------------------------------------------------------------------------

(defun count-successful-move-by-type (agent-list)
  (setf *move-count* (count-by-type agent-list *move-count*)))

;;; ---------------------------------------------------------------------------

(defun count-by-type (agent-list counter)
  (mapc #'(lambda (agent)
            (if (null (assoc (agent$type agent) counter))
                (setf counter (acons (agent$type agent) 1 counter))
                (setf (cdr (assoc (agent$type agent) counter))
                      (1+ (cdr (assoc (agent$type agent) counter))))))
        agent-list)
  counter)

;;; ---------------------------------------------------------------------------

(defun count-moves-and-track (agent-list)
  (count-successful-move-by-type agent-list)
  (mapc #'(lambda (agent)
            (when (and (eq (agent$type agent) :RED)
                       (not (grid-element$draw-function (get-grid-element (agent$location agent)))))
              (setf (grid-element$draw-function (get-grid-element (agent$location agent)))
                    `(if (> *current-time* ,*current-time*)
                         :HOLLOW-RECTANGLE
                         nil))))
        agent-list))

;;; ---------------------------------------------------------------------------

(defun send-moveback-notice-to-all (agent-list)
  (dolist (agt agent-list)
    (let* ((dir (rest (agent-action$action (rest (first (agent-state$action-history
                                                            (current-state agt))))))))
      (format t "Agent ~a move ~a undone due to a conflict.~%" (agent$name agt) dir)
      (dolist (host *remote-hosts*)
        (request-slave-interaction
          host
          :string-out (format nil "Agent ~a move ~a undone due to a conflict.~%" (agent$name agt) dir)
          :graphics-time nil)))))

;;; ***************************************************************************
;;; EOF
