;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;;
;;;  PROJECT:  MICE
;;;
;;;  MODULE :  User/Developer Initialization file
;;;
;;;  VERSION:   BETA
;;;
;;;  DESCRIPTION:
;;;    This file contains code for loading in special files and capabilities
;;;    used for the use of the MICE system under MCL Version 1.3.2.
;;;
;;;  IMPLEMENTATION NOTES:
;;;
;;;  REVISION HISTORY
;;;  09/10/91  Luke Hohmann  - Initial Version
;;;  11/15/91  Young-pa So
;;;   
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;


;  Copyright 1991, 1992
;  Regents of the University of Michigan
;  
;  Permission is granted to copy and redistribute this software so long as
;  no fee is charged, and so long as the copyright notice above, this
;  grant of permission, and the disclaimer below appear in all copies made.
;  
;  This software is provided as is, without representation as to its fitness
;  for any purpose, and without warranty of any kind, either express or implied,
;  including without limitation the implied warranties of merchantability and fitness
;  for a particular purpose.  The Regents of the University of Michigan shall not
;  be liable for any damages, including special, indirect, incidental, or
;  consequential damages, with respect to any claim arising out of or in
;  connection with the use of the software, even if it has been or is hereafter
;  advised of the possibility of such damages.


;;==================== MACL Internal global variables ===================== 
(setq *load-verbose* t)
(setq *save-local-symbols* t)
(setq *fasl-save-local-symbols* t)
(setq *verbose-eval-selection* t)
(setq *print-case* :downcase)
(setq *warn-if-redefine* nil)

(disable-dead-keys)
(require 'traps)
(require 'records)
(require 'quickdraw)
(purge-functions nil)
(defun target () (cadr (windows)))


;;===========================  Bring in examples code =====================
;lots of the example code from MACL 1.3.2 we like
(push "ccl;examples:" *module-search-path*)

; this item gives a 'save as' menu item
;(require 'save-copy)

; this allows *window*'s to print themselves
; note that dialogs connot print themselvs
;(require 'hardcopy)

; this gives a font menu underneath the edit menu
;(require 'font-menus)

;;================== load the allegro interface designer AID =============
;(load "ccl;AID:make-aid")
;(interface-designer::load-aid)


;;==================== define some keystroke equivalents for menus ======
; give the Close menu item the standard command-key
(ask (ask *file-menu* (find-menu-item "Close")) 
  (set-command-key #\W))

(ask (ask *file-menu* (find-menu-item "Quit"))
  (set-command-key #\Q))

(ask (ask *eval-menu* (find-menu-item "Compile File")) 
  (set-command-key #\F))

(ask (ask *eval-menu* (find-menu-item "Load")) 
  (set-command-key #\D))


;;==================== set this to *emacs-mode* to t if you use emacs ======
(setf *emacs-mode* nil)


;========= fix so that Allegro can find files in the library on machines
;========= that use wierd inits
(def-logical-pathname "LibSearchFix;" "ccl;library:")

; prepare the MICE search path so that we can find the mice files
(def-logical-pathname "MICE;" "home;MICE:")
(def-logical-pathname "MICE home;" "home;")

; now add all of these to the search path that lisp uses to find modules
;
(push (expand-logical-pathname "LibSearchFix;") *module-search-path*)
(push (expand-logical-pathname "MICE;") *module-search-path*)
(push (expand-logical-pathname "MICE home;") *module-search-path*)


; announce that the basic initializations have been done.
;
(pushnew :basic-init *features*)

;; these requires are part of the mice environment
;;
(require 'umass-extended-lisp)


(if (y-or-n-dialog "Load MICE automatically?")
  (with-cursor *watch-cursor*
    (load "MICE;mac-loadmice.lisp")))
