;  Copyright 1991, 1992
;  Regents of the University of Michigan
;  
;  Permission is granted to copy and redistribute this software so long as
;  no fee is charged, and so long as the copyright notice above, this
;  grant of permission, and the disclaimer below appear in all copies made.
;  
;  This software is provided as is, without representation as to its fitness
;  for any purpose, and without warranty of any kind, either express or implied,
;  including without limitation the implied warranties of merchantability and fitness
;  for a particular purpose.  The Regents of the University of Michigan shall not
;  be liable for any damages, including special, indirect, incidental, or
;  consequential damages, with respect to any claim arising out of or in
;  connection with the use of the software, even if it has been or is hereafter
;  advised of the possibility of such damages.


;; defsystem.lisp

#-TI
(format t "~%MICE version 2.0~%Copyright 1991,1992~%Regents of the University of Michigan~%")

(unless (find-package "UMASS-EXTENDED-LISP")
  (defpackage "UMASS-EXTENDED-LISP"
    (:use "TICL" "LISP")))

(defsystem mice
  (:name "Michigan Intelligent Coordination Experiment")
  (:short-name "mice")
  (:pathname-default "vulture://katana/users/jaeho/commice/")
  (:module tools ("tools"))
  (:module uel ("umass-extended-lisp" "ti-extensions" "allegro-extensions"))
  (:module defxstruct ("defxstruct"))
  (:module structs ("structures"))
  (:module graphics ("measures" "di-graphics" "ti-graphics" "graphics" "icons"))
  (:module code    ("mice" "extint" "board" "communication"))
  (:module domain ("domain"))
  (:module agents ("agents"))
  (:module save ("saverestore"))
  (:compile-load tools)
  (:compile-load uel)
  (:compile-load defxstruct (:fasload uel))
  (:compile-load structs (:fasload defxstruct))
  (:compile-load graphics (:fasload structs))
  (:compile-load code (:fasload graphics))
  (:compile-load domain)
  (:compile-load agents)
  (:compile-load save)
  )
