;; allegro-extensions.lisp

;  Copyright 1991, 1992
;  Regents of the University of Michigan
;  
;  Permission is granted to copy and redistribute this software so long as
;  no fee is charged, and so long as the copyright notice above, this
;  grant of permission, and the disclaimer below appear in all copies made.
;  
;  This software is provided as is, without representation as to its fitness
;  for any purpose, and without warranty of any kind, either express or implied,
;  including without limitation the implied warranties of merchantability and fitness
;  for a particular purpose.  The Regents of the University of Michigan shall not
;  be liable for any damages, including special, indirect, incidental, or
;  consequential damages, with respect to any claim arising out of or in
;  connection with the use of the software, even if it has been or is hereafter
;  advised of the possibility of such damages.

;;;            This work has been sponsored in part by:
;;;               the NSF (IRI-9010645, IRI-9015423)
;;;         the University of Michigan Rackham Graduate School
;;;


;(in-package 'MICE)

;(export '(ordered-set-difference))

(proclaim '(optimize (speed 3) (safety 1)))

;;; ***************************************************************************

; because allegro reverses the order of set-difference

(defun ordered-set-difference (list1 list2 &key (test #'equal) (key #'identity))
  (let ((difference list1))
    (dolist (e2 list2 difference)
      (setf difference (remove-if #'(lambda (e1) (funcall test (funcall key e1) (funcall key e2))) difference)))))

;;(defun set-difference (set1 set2)
;;  (cond ((null set1) nil)
;;        ((member (first set1) set2)
;;         (set-difference (rest set1) set2))
;;        (t (cons (first set1) (set-difference (rest set1) set2)))))

;;; ***************************************************************************
;;; EOF

