;;;; -*- Mode: Fi:Common-Lisp -*-
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;;; 
;;;; Description       : Example startup file
;;;; 
;;;; Original author(s): Jaeho Lee <jaeho@bigtwohearted.engin.umich.edu>
;;;; Organization      : University of Michigan DAI Lab
;;;; Created On        : Sat Jan 11 13:46:18 1992
;;;; Last Modified On  : Tue Jan 14 10:05:41 1992
;;;; Last Modified By  : Jaeho Lee <jaeho@bigtwohearted.engin.umich.edu>
;;;; 
;;;; Copyright (C) 1992 University of Michigan.
;;;; 
;;;; PURPOSE
;;;; 	After loading this file in the common lisp, just issue either
;;;;    (mice "pursuit.env") or (run) to start the program.
;;;; 
;;;; HISTORY 
;;;; 24-Jan-1992                Young-pa So
;;;;    Adapted to the Macintosh Environment
;;;;    This is a Start Up file for the Predator-Prey Example.
;;;;    4 predators pursue 1 prey. The 4 predators use 
;;;;    the Contract Net Protocol in coordinating their joint effort.
;;;;
;;;; 11-Jan-1992		Jaeho Lee (on bigtwohearted.engin.umich.edu)
;;;;    After the communication capability of MICE has been made, revised
;;;;    and modified by Jaeho Lee.
;;;;    
;;;; 04-Oct-1991		
;;;;     Originally written by Jaeho Lee and Young-Pa So for the class project
;;;;     of EECS 598-4 at fall term, 1991. 
;;;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

;  Copyright 1991, 1992
;  Regents of the University of Michigan
;  
;  Permission is granted to copy and redistribute this software so long as
;  no fee is charged, and so long as the copyright notice above, this
;  grant of permission, and the disclaimer below appear in all copies made.
;  
;  This software is provided as is, without representation as to its fitness
;  for any purpose, and without warranty of any kind, either express or implied,
;  including without limitation the implied warranties of merchantability and fitness
;  for a particular purpose.  The Regents of the University of Michigan shall not
;  be liable for any damages, including special, indirect, incidental, or
;  consequential damages, with respect to any claim arising out of or in
;  connection with the use of the software, even if it has been or is hereafter
;  advised of the possibility of such damages.



(def-logical-pathname "C-net;" "MICE home;MICE Examples:")

(setf *display?* t)
(setf *graphics?* t)
(setf *debug-cnet* nil)

(load "C-net;cnet-architecture")
(load "C-net;cnet-strategy")
(load "C-net;cnet-manager")
(load "C-net;cnet-contractor")

(defun run (&optional (env "C-net;pursuit.env"))
  (mice env)
  (terpri)
  (princ "Redisplaying the run...")
  (terpri)
  (redisplay-run))

