/* 
 * points.c -- definition of global points
 * 
 */

#include <stdio.h>

#include "constants.h"
#include "structures.h"
#include "parameters.h"
#include "display.h"

#define MAXPOINTS 100

point *				/* list of global points */
pointlist[MAXPOINTS];

int				/* pointer to points list */
pointlist_p = 0;

float
point_phi(point *p)		/* returns the direction to the point */
{				/* between -PI and PI in radians */
  return(norm2_angle((float)atan2(p->y,p->x)));
}

void
add_point(point *p)		/* adds P to pointlist */
{
  if (pointlist_p < MAXPOINTS)
    pointlist[pointlist_p++] = p;
}

void
rem_point(point *p)		/* remove it */
{
  int i;
  for (i=0; i<pointlist_p; i++)
    if (pointlist[i] == p)	/* found it, move everything up */
      {
	for (; i<pointlist_p; i++)
	  {
	    pointlist[i] = pointlist[i+1];
	  }
	pointlist_p--;
	break;
      }
}

void
update_point(point *p, float th, float cth, float sth, float dx, float dy)
{
  float tx, ty;
  tx = p->x - dx;
  ty = p->y - dy;
  p->x = tx * cth - ty * sth;
  p->y = ty * cth + tx * sth;
  p->th = sub_ang(p->th,th);
}

void
update_pointlist(float x, float y, float th) /* updates all points on the list */
{
  int i;
  float cth, sth;
  th = -th;			/* historical reasons... */
  cth = cos(th);
  sth = sin(th);
  for (i=0; i<pointlist_p; i++)
    update_point(pointlist[i],th,cth,sth,x,y);
}


void
add_target(int x, int y)	/* adds a target point at screen x,y */
{
  float sx, sy;
  point *p;
  sx = (float)x - screen_matrix.a13;
  sy = screen_matrix.a23 - (float)y;
  p = (point *)malloc(sizeof(point));
  p->x = (- sy) / screen_matrix.a12;
  p->y = sx / screen_matrix.a21;
  p->th = 0.0;
  p->type = PT_POS;
  add_point(p);
}
