/*#########################################
 * 
 * angles.c -- utility functions dealing with angles
 * 
 *#########################################
 */


#include "structures.h"
#include "constants.h"

/* normalize */

float norm_angle(a)		/* between 0 and 2PI */
     float a;
{
  if (a > ANG360) a = a - ANG360;
  else if (a < 0.0) a = a + ANG360;
  return(a);
}

float norm2_angle(a)		/* between -PI and PI */
     float a;
{
  if (a > ANG180) a = a - ANG360;
  else if (a < (- ANG180)) a = a + ANG360;
  return(a);
}

float norm_dangle(a)		/* between 0 and 2PI */
     float a;
{
  if (a > ang_to_deg(ANG360)) a = a - ang_to_deg(ANG360);
  else if (a < 0.0) a = a + ang_to_deg(ANG360);
  return(a);
}

float norm2_dangle(a)		/* between -PI and PI */
     float a;
{
  if (a > ang_to_deg(ANG180)) a = a - ang_to_deg(ANG360);
  else if (a < (- ang_to_deg(ANG180))) a = a + ang_to_deg(ANG360);
  return(a);
}

/* Rotation function */

prot(x,y,th)			
     float *x, *y;
     float th;
{
  float cs, sn, xt, yt;
  cs = cos((double)th);
  sn = sin((double)th);
  xt = *x;  yt = *y;
  *x = cs*xt + sn*yt;
  *y = cs*yt - sn*xt;
}
