/*
 * Global defs for most display and interpretation routines
 *
 */

#include <stdio.h>
#include <math.h>

extern int w_width, w_height, w_offset_x, w_offset_y;
extern int c_width, c_height;
extern int wxoff, wyoff;
extern double w_scale;

#define scalex(x) (w_offset_x + (w_scale * (x))) 
#define scaley(y) (w_offset_y + (w_scale * (y))) 
#define dscale(x) (w_scale * (x)) 
#define xscale(x,y) scalex(- y)
#define yscale(x,y) scaley(- x)
#define dxscale(x,y) dscale(- y)
#define dyscale(x,y) dscale(- x)

static double rad_to_deg = (180.0 / M_PI); /* convert radians to degrees */
static double deg_to_rad = (M_PI / 180.0); /* convert degrees to radians */

#define min(x,y) (((x) < (y)) ? (x) : (y))
#define max(x,y) (((x) > (y)) ? (x) : (y))
#define sround(x) (nint(x))	/* single-precision? arg round to int */

/* Translation to screen coords.  Real +x on flakey translates to "up" on the
 *   screen, and real +y is to Flakey's left, i.e, "left" on the screen.  
 *   So we have: +x -> scaled -y,  +y -> scaled -x.
 */


struct rotm			/* this is a 2x3 rotation/translation matrix */
{				/* specialized, usually a21 = -a12, a22 = a11 */
  double a11;
  double a12;
  double a13;
  double a21;
  double a22;
  double a23;
  double a31;
  double a32;
  double a33;
};

extern struct rotm screen_matrix; /* scales to screen coords from rw */


#define flakey_width 580	/* in mm */

/* These are defined in winsonar.c */

#define CBUF_LEN 100

struct cbuf			/* Circular buffers. */
{
  int start;			/* Start is the point at which entries start. */
  int end;			/* This points to the last entry + 1.  */
				/* Equals start when empty */
  int limit;			/* Extent of buffer */
  int interp;                   /* Extent of interpreted data. */
  float lastx;			/* Last x-coordinate to be interpreted */
  float lasty;			/* Last y-coordinate to be interpreted */
  float stub_x;
  float stub_y;
  float xbuf[CBUF_LEN];
  float ybuf[CBUF_LEN];
};


extern struct cbuf *sraw_buf;	/* holds raw sonar readings */
extern struct cbuf *sl_buf;	/* holds interpreted left/right readings */
extern struct cbuf *sr_buf;
extern struct cbuf st_buf;	/* stereo readings */


#define BUF_NULL 256
#define SLBUF_NULL 255		/* structured light null entry */
#define RW_NULL -10000.0	/* RW coord null */

#define N_BRK -1		/* not much info about surround */
#define A_BRK -2		/* most significant: depth disparity, long segments */
#define B_BRK -3		/* short break, no depth disparity */
#define C_BRK -4		/* short segments, depth disparity */
#define CBUF_NULL -10		/* no entry */



/* 
 * Left and right depth aggregate buffers.
 * Start depth buffer at w_offset + SON_OFFSET, work up SBUF_LEN * SON_NUM pixels.
 * Each depth buffer element represents SON_NUM pixel's worth (= 4, nominally)
 *
 */

#define SON_NUM  4		/* vertical size (pixels) to aggregate raw readings */

/* upper part of buffer, at center of Flakey */

#define SON_OFFSET 0
#define SBUF_LEN 20
#define NULL_STUB 100

extern int lbuf[], rbuf[];	/* right and left sonar depth buffers */
extern int fbuf[];		/* front sonar buffer */
