#include <X11/Xlib.h>
#include <X11/Xutil.h>
#include <X11/Xos.h>

/*
 * Global defs for most display and interpretation routines
 *
 */

#include "dispall.h"

#define FLAKEY_WIN_CLASS "Flakey"

extern Display *display;	/* screen */
extern GC gc;			/* drawing GC */
extern GC cgc;			/* clearing GC */
extern GC c_gc;			/* drawing GC */
extern GC c_cgc;		/* clearing GC */
extern Pixmap graphics_pm;	/* drawing pixmap for double-buffering */
extern Window win;		/* visible window */
extern Window info_win;		/* for text drawing */
extern Window control_win;

#define INFO_WIDTH   100	/* info window width */
#define INFO_HEIGHT  400	/* info window min height */
#define INFO_X       w_width	/* and offsets in main window */
#define INFO_Y       0

#define CONTROL_WIDTH 400	/* control window params */
#define CONTROL_HEIGHT 400


/* structures for drawings buffers */

struct sX_data			/* structure holding segments */
{
  int end;			/* most we can have */
  int ofw;			/* buffer overflow if > 0 */
  int n;			/* where we're at, initially 0 */
  XSegment *p;			/* pointer to a segment buffer */
};

extern struct sX_data *sx; 
extern XSegment *sX_buf_p;

extern XPoint      *pX_buf_p;	/* buffer ptrs for points, segments, and boxes */
extern XRectangle  *rX_buf_p;
extern XArc        *aX_buf_p;

extern XPoint      pX_buf[];	/* buffers for points, segments, and boxes */
extern XRectangle  rX_buf[];
extern XArc        aX_buf[];

extern int  pX_buf_n;		/* buffer counters */
extern int  rX_buf_n;
extern int  aX_buf_n;

#define pX_buf_MAX 400
#define rX_buf_MAX 400
#define aX_buf_MAX  50

#define put_point(mx,my) { pX_buf_p->x = (mx), \
			   pX_buf_p->y = (my), \
			   pX_buf_p++;        \
			     if (++pX_buf_n >= pX_buf_MAX)  \
			       { pX_buf_p--; pX_buf_n--; } }

#define put_box(mx,my,mw,mh) { rX_buf_p->x = (mx), \
			   rX_buf_p->y = (my), \
			   rX_buf_p->width = (mw), \
			   rX_buf_p->height = (mh), \
			   rX_buf_p++;        \
			   if (++rX_buf_n >= rX_buf_MAX)  \
			   { rX_buf_p--; rX_buf_n--; } }

#define put_vector(mx1,my1,mx2,my2) { \
  sX_buf_p = (sx->p) + (sx->n); \
  sX_buf_p->x1 = (mx1); \
  sX_buf_p->y1 = (my1); \
  sX_buf_p->x2 = (mx2); \
  sX_buf_p->y2 = (my2); \
  if (  (++(sx->n)) >= (sx->end) )  \
     { (sx->n)--; (sx->ofw)++; } }

#define put_arc(mx,my,mw,mh,a1,a2) { \
     aX_buf_p->x = (mx); \
     aX_buf_p->y = (my); \
     aX_buf_p->width = (mw); \
     aX_buf_p->height = (mh); \
     aX_buf_p->angle1 = (a1); \
     aX_buf_p->angle2 = (a2); \
     aX_buf_p++;        \
     if (++aX_buf_n >= aX_buf_MAX)  \
       { aX_buf_p--; aX_buf_n--; } }

#define put_text(mx,my,mstr,mlen) \
  XDrawImageString(display,info_win,gc,mx,my,mstr,mlen)

#define check_alive if (win ==  0) return(-1)



#define KeyType 0		/* types for act_window */
#define ExposeType 1
#define ConfigureType 2
#define ButtonType 3
