awm.p                                                                                               100705  017064  000205  00000054724 05427665512 010153  0                                                                                                     47426  popx                            lnxp                                              1  0                                                                                                                                                                 /*  AWM.P  */


section $-awm => new_awm
                 awm_undefchar
                 ved_awm
                 awm_x_known_min awm_x_known_max
                 awm_y_known_min awm_y_known_max
                 awm_x_actual_min awm_x_actual_max
                 awm_y_actual_min awm_y_actual_max
                 awm_move_bug_to
                 awm_set_direction
                 awm_move
                 awm_left awm_right awm_forward awm_back
                 awm_forwardvector awm_rightvector awm_direction
                 awm_x awm_y
                 awm_position
                 awm_retina_coords_to_awm_coords
                 awm_awm_coords_to_retina_coords
                 awm_merge_retina
                 app_awm
                 awm_neighbour
                 awm_app_neighbours awm_app_vh_neighbours
                 awm_replace;


/*
SPECIFICATION
-------------

This module defines some routines and structures for Bugs to use when
storing information about their world in analogical form as a 2-D map of
the surroundings. I call the structures AWMs, for "array world-model".


Externally, an AWM looks like a 2-D array. Create one by calling
    new_awm( undefchar )
where 'undefchar' is the character to be stored in otherwise undefined
array elements.

Access it by subscripting:
    awm(3,4) =>
    `#` -> awm(x,y);
AWMs are mapped onto strings, so you'll get an error if you try to
store anything other than a character in them.

Their class_print is set to a line-by-line display routine, so the
print-arrow will automatically print the contents.

AWMs are flexible arrays. They are created with initial bounds running
from -10 to 10 in both dimensions. If you try to put a character outside
the present bounds, the array will be expanded automatically. If you try
to read outside the current bounds, or to read a location that hasn't
been set, you'll get the character indicating "undefined": this is the
undefchar argument to new_awm.

You can find out how much of an AWM is known using the routines
    awm_x_known_min awm_x_known_max
and
    awm_y_known_min awm_y_known_max
These delimit a rectangle for which at least one character in each line
and column is not undefined. Outside this rectangle, all the characters
are undefined. When an AWM is created, all characters are undefined.

You can discover the total size of an AWM by calling
    awm_x_actual_min awm_x_actual_max
    awm_y_actual_min awm_y_actual_max
These indicate the actual space allocated to the array. They are
completely irrelevant as far as finding out what information is in the
AWM, because an AWM is virtually infinite. However, you can use them to
calculate the amount of memory used - once your AWM gets too big, you
may want to discard some regions and begin again.

You can also use AWMs to keep track of the Bug's position. An AWM
contains internal coordinates and direction vectors corresponding for a
notional bug. You can change these with various routines, such as
awm_left and awm_forward, and can read out the resulting values. This
enables your Bug's world-model to keep track of the Bug itself. The
internal bug's coordinate system is as you would expect: north lies along
the Y axis, and corresponds to the forwardvector (0,1).         

AWMs are useful for tasks like finding paths between points, and
dividing the world into regions. Many of these are best done
analogically; for example, you can easily find regions by picking a
blank, flooding with some character until you hit obstructions on all
sides, and repeating until there are no blanks left. This module
therefore exports some routines for finding and processing the
neighbours of a point, and for replacing characters in an AWM.

Finally, there is a routine for merging the contents of a bug's retina
into an AWM.


PUBLIC new_awm( undefchar ):

Returns a new AWM whose undefined-character is undefchar. The x_known
and y_known bounds initially run from +1 to -1, and all characters are
undefined. The internal bug is created at (0,0), facing internal north:
forwardvector and rightvector are (0,1) and (1,0).


PUBLIC awm_undefchar( awm ):

Returns awm's undefined-character.


PUBLIC awm_x_known_min( awm ):
PUBLIC awm_x_known_max( awm ):
PUBLIC awm_y_known_min( awm ):
PUBLIC awm_y_known_max( awm ):

Return the lower and upper x-bounds, and the lower and upper y-bounds,
on the known area of awm. Within this rectangle, there is at least one
known location in every line and column. Outside it, all locations are
undefined.


PUBLIC awm_x_actual_min( awm ):
PUBLIC awm_x_actual_max( awm ):
PUBLIC awm_y_actual_min( awm ):
PUBLIC awm_y_actual_max( awm ):

Return the lower and upper x-bounds, and the lower and upper y-bounds,
on the actual storage used by AWM.


PUBLIC ved_awm():

Defines the Ved command 'awm', which copies the contents of the current
Ved buffer into an AWM.

The command can have the following forms:
    awm
    awm name
    awm name undefchar

These commands create a new awm and assign it to valof(name). If
undefchar is omitted, it defaults to ? . If name is omitted, it defaults
to "awm". The x-bounds of the AWM run from the leftmost non-blank column
(indexed at 1) to the rightmost non-blank column; its y-bounds run from
the top non-blank Ved line to the bottom (indexed at 1). If the buffer
contains a B, this will be taken to give the position of the internal
bug, and the square will be assumed blank.


PUBLIC app_awm( awm, p ):

Applies procedure p to every non-undefined location in awm. p must take
three arguments: p(awm,i,j), where the latter two give the location's
coordinates.


PUBLIC awm_replace( awm, c, newc ):

Replaces specified characters in awm by character newc. If c is a
character, all occurrences of it will be replaced by newc. If it is a
procedure, it must take a character as argument and return true or
false; all characters c for which p(c) is true will be replaced by newc.


PUBLIC awm_app_neighbours( awm, x, y, p ):

This applies p to every neighbour of awm(x,y). p must be a procedure of
three arguments, p(awm,i,j), as for app_awm.


PUBLIC awm_app_vh_neighbours( awm, x, y, p ):

This is like awm_app_neighbours, but only applies p to vertical and
horizontal neighbours. awm_app_neighbours also applies it to diagonal
ones. Both procedures avoid applying p to any undefined cells, i.e.
those which contain awm.awm_undefchar.


PUBLIC awm_neighbour( awm, x, y, p ):

This is used for finding a neighbour with specified properties. p must
be a procedure of three arguments, p(awm,i,j), returning true or false.
awm_neighbour applies p to each neighbour (including diagonal ones)
until it finds one for which p is true. If it finds one, it returns
true, otherwise false.


PUBLIC awm_move_bug_to( awm, x, y ):

Moves awm's internal bug to (x,y), without changing its bearing.


PUBLIC awm_set_direction( awm, direction ):

Sets awm's internal bug's direction to direction. This must be one of
"north", "east", "south", "west".


PUBLIC awm_move( awm, action ):

action must be one of "left", "right", "forward", "back". This procedure
changes awm's internal bug's location or bearing accordingly.


PUBLIC awm_right( awm ):
PUBLIC awm_left( awm ):
PUBLIC awm_forward( awm ):
PUBLIC awm_back( awm ):

Equivalent to awm_move( awm, "right" ) ... awm_move( awm, "back" ).


PUBLIC awm_direction( awm ):
PUBLIC awm_forwardvector( awm ):
PUBLIC awm_rightvector( awm ):

These return the bearing of awm's internal bug. The direction is one of
"north", "east", "south", "west". The forwardvector and rightvector are
unit vectors along the bug's Y and X axis, and are returned as a 'vec':
see lib vec.


PUBLIC awm_x( awm ):
PUBLIC awm_y( awm ):
PUBLIC awm_position( awm ):

These return the x and y coordinates of awm's internal bug, and the
bug's position as a 'vec'.


PUBLIC awm_retina_coords_to_awm_coords( rvec ):

This routine converts the retinal coordinates rvec into an AWM coordinate
vector.


PUBLIC awm_awm_coords_to_retina_coords( avec ):

This routine converts the AWM coordinates avec into a retinal coordinate
vector.


PUBLIC awm_merge_retina( awm, retina ):

This routine copies retinal contents into an AWM. 'retina' is a retina,
which must be as described in HELP EDEN, e.g. a 7*5 array whose bug is
at location (3,2). awm_merge_retina copies each retinal element into the
corresponding position of awm, assuming that the bug whose retina it is
has its location and bearing given by awm's internal bug.
*/


/*
IMPLEMENTATION
--------------

We represent a awm as a one-element record, whose single field is an
array. We define the record's class_apply routine so that subscripting
it accesses this array, and we modify its class_print routine so that
printing it displays the awm a line at a time.

The array is mapped onto a message by newanyarray. I originally did this
just because I wanted to be able to give newanyarray a second
(initialising) argument, and you can't do that without giving it a third
one too. (The documentation suggests you can, but it doesn't work.)
However, using messages is useful because it stops people putting
non-characters in the array.

ved_awm depends on getvedargs and vedbounds, from utils.
*/


needs vec;
needs retina;
needs fault;


recordclass awm
    awm_chars
    ;;; The underlying array.

    awm_undefchar
    ;;; The undef character.

    awm_x_known_min awm_x_known_max
    awm_y_known_min awm_y_known_max
    ;;; Bounds on known space.

    awm_x_actual_min awm_x_actual_max
    awm_y_actual_min awm_y_actual_max
    ;;; Bounds on actual space.

    awm_x awm_y
    awm_direction
    awm_forwardvector awm_rightvector;
    ;;; Internal bug location and heading.


define global new_awm( undefchar );
    consawm( newanyarray( [% -10, 10, -10, 10 %], undefchar, key_of_dataword("string") ),
             undefchar,
             1, -1, 1, -1,
             -10, 10, -10, 10,
             0, 0,
             "north",
             consvec(0,1), consvec(1,0)
           );
enddefine;


/*  Subscripting routine.  */
define access_awm( x, y, awm );
    lvars x, y, awm;

    define prmishap( message, culprits );
        lvars message, culprits;
        if issubstring('INVALID ARRAY SUBSCRIPT',1,message) then
            clearstack();
            awm.awm_undefchar;
            exitfrom(access_awm)
        else
            sysprmishap(message,culprits)
        endif;
    enddefine;

    (awm.awm_chars)(x,y);
enddefine;
access_awm -> class_apply( key_of_dataword("awm") );
/*
I use the error-handler to detect out-of-range subscripts, for
efficiency. Note the call to clearstack() - it appears, though this
isn't documented, that the stack contains one or both of the subscripts,
depending on which was faulty. We have to clear these.
*/


vars expand_awm;/*forward*/


/*  Updater for subscripts.  */
define update_awm( c, x, y, awm );
    vars c, x, y, awm;

    if c = awm.awm_undefchar then return endif;

    if x < awm.awm_x_known_min or x > awm.awm_x_known_max or
       y < awm.awm_y_known_min or y > awm.awm_y_known_max then
        expand_awm( awm, x, y );
        min( awm.awm_x_known_min, x ) -> awm.awm_x_known_min;
        max( awm.awm_x_known_max, x ) -> awm.awm_x_known_max;
        min( awm.awm_y_known_min, y ) -> awm.awm_y_known_min;
        max( awm.awm_y_known_max, y ) -> awm.awm_y_known_max;
    endif;

    c -> (awm.awm_chars)(x,y);

enddefine;
update_awm -> updater( class_apply( key_of_dataword("awm") ) );
/*
I don't use error-trapping here, because it kept giving problems
and causing extraneous errors. The routine that wouldn't quite
work is commented out below.
*/

/*
define update_awm( c, x, y, awm );
    vars c, x, y, awm;

    if c = awm.awm_undefchar then return endif;

    define prmishap( message, culprits );
        lvars message, culprits;
        if issubstring('INVALID ARRAY SUBSCRIPT',1,message) then
            expand_awm( awm, x, y );
            c -> (awm.awm_chars)(x,y);
            clearstack();
            exitfrom(update_awm)
        else
            sysprmishap(message,culprits)
        endif;
    enddefine;

    min( awm.awm_x_known_min, x ) -> awm.awm_x_known_min;
    max( awm.awm_x_known_max, x ) -> awm.awm_x_known_max;
    min( awm.awm_y_known_min, y ) -> awm.awm_y_known_min;
    max( awm.awm_y_known_max, y ) -> awm.awm_y_known_max;

    c -> (awm.awm_chars)(x,y);

enddefine;
update_awm -> updater( class_apply( key_of_dataword("awm") ) );
*/


/*  expand_awm( awm, x, y ):
        Expand awm so that it has enough space to store awm(x,y).       
*/
define expand_awm( awm, x, y );

    lvars awm, x, y;
    lvars new_x_actual_min, new_x_actual_max, new_y_actual_min, new_y_actual_max;
    lvars newchars, i, j;

    if x < awm.awm_x_actual_min then x-5 else awm.awm_x_actual_min endif -> new_x_actual_min;
    if x > awm.awm_x_actual_max then x+5 else awm.awm_x_actual_max endif -> new_x_actual_max;
    if y < awm.awm_y_actual_min then y-5 else awm.awm_y_actual_min endif -> new_y_actual_min;
    if y > awm.awm_y_actual_max then y+5 else awm.awm_y_actual_max endif -> new_y_actual_max;

    newanyarray( [% new_x_actual_min, new_x_actual_max, new_y_actual_min, new_y_actual_max %],
                 awm.awm_undefchar, key_of_dataword("string") ) -> newchars;

    for i from awm.awm_x_actual_min to awm.awm_x_actual_max do
        for j from awm.awm_y_actual_min to awm.awm_y_actual_max do
            (awm.awm_chars)(i,j)-> newchars(i,j);
        endfor;
    endfor;

    new_x_actual_min -> awm.awm_x_actual_min;
    new_x_actual_max -> awm.awm_x_actual_max;
    new_y_actual_min -> awm.awm_y_actual_min;
    new_y_actual_max -> awm.awm_y_actual_max;

    newchars -> awm.awm_chars;
enddefine;


/*  The print routine.  */                 
procedure( awm );
    lvars awm;
    lvars i, j;

    printf( 'AWM: xk: %p to %p;  yk: %p to %p \n' <>
            '     xbounds: %p to %p;   ybounds: %p to %p \n' <>
            '     position: (%p,%p) \n' <>
            '     forward: %p;   right: %p \n',
            [% awm.awm_x_known_min, awm.awm_x_known_max, awm.awm_y_known_min, awm.awm_y_known_max,
               awm.awm_x_actual_min, awm.awm_x_actual_max, awm.awm_y_actual_min, awm.awm_y_actual_max,
               awm.awm_x, awm.awm_y,
               awm.awm_forwardvector, awm.awm_rightvector
            %]
    );

    for j from awm.awm_y_known_max by -1 to awm.awm_y_known_min do
        for i from awm.awm_x_known_min to awm.awm_x_known_max do
            if i=awm.awm_x and j=awm.awm_y then
                cucharout( `B` )
            else
                cucharout( awm(i,j) );
            endif;
        endfor;
        1.nl;
    endfor;
    1.nl;

endprocedure -> class_print( key_of_dataword("awm") );


define global awm_retina_coords_to_awm_coords( awm, rvec );
    lvars awm, rvec;

    consvec(
        awm.awm_x + (rvec.vec_x-3)*(awm.awm_rightvector.vec_x)
                  + (rvec.vec_y-2)*(awm.awm_forwardvector.vec_x)
    ,
        awm.awm_y + (rvec.vec_x-3)*(awm.awm_rightvector.vec_y)
                  + (rvec.vec_y-2)*(awm.awm_forwardvector.vec_y)
    );
enddefine;


define global awm_awm_coords_to_retina_coords( awm, avec );
    lvars awm, i, j, x, y, avec;
    lvars fv = awm.awm_forwardvector, rv = awm.awm_rightvector;

    avec.vec_x -> x;
    avec.vec_y -> y;

    (-y*fv.vec_x + x*fv.vec_y) / (rv.vec_y*fv.vec_x + rv.vec_x*fv.vec_y) -> i;
    (-x*rv.vec_y + y*rv.vec_x) / (rv.vec_x*fv.vec_y + rv.vec_y*fv.vec_x) -> j;

    consvec( i+3, j+2 );
enddefine;


define global awm_merge_retina( awm, retina );
    lvars awm, retina;
    lvars xmax, ymax, i, j, x, y, avec;

    retina_bounds( retina ) -> ymax -> xmax;

    for i to xmax do
        for j to ymax do
            awm_retina_coords_to_awm_coords( awm, [%i,j%] ) -> avec;
            retina(i,j) -> awm(avec.vec_x,avec.vec_y);
        endfor;
    endfor;

enddefine;


define global awm_position( awm );
    consvec( awm_x(awm), awm_y(awm) );
enddefine;


define global awm_move_bug_to( awm, x, y );
    lvars x, y;
    x -> awm.awm_x;
    y -> awm.awm_y;
enddefine;


define global awm_forward( awm );
    lvars awm;
    awm.awm_x + awm.awm_forwardvector.vec_x -> awm.awm_x;
    awm.awm_y + awm.awm_forwardvector.vec_y -> awm.awm_y;
enddefine;


define global awm_back( awm );
    lvars awm;
    awm.awm_x - awm.awm_forwardvector.vec_x -> awm.awm_x;
    awm.awm_y - awm.awm_forwardvector.vec_y -> awm.awm_y;
enddefine;


vars renew_direction_vectors;/*forward*/


define global awm_left( awm );
    lvars awm;
    switchon awm.awm_direction
    case = "north" then "west"
    case = "west"  then "south"
    case = "south" then "east"
    case = "east"  then "north"
    endswitchon -> awm.awm_direction;
    renew_direction_vectors( awm.awm_direction, awm );
enddefine;


define global awm_right( awm );
    lvars awm;
    switchon awm.awm_direction
    case = "north" then "east"
    case = "west"  then "north"
    case = "south" then "west"
    case = "east"  then "south"
    endswitchon -> awm.awm_direction;
    renew_direction_vectors( awm.awm_direction, awm );
enddefine;


define global awm_set_direction( awm, dir );
    lvars awm, dir;
    dir -> awm.awm_direction;
enddefine;


/*  renew_direction_vectors( dir, awm ):
        Recalculate internal bug's direction vectors to be consistent
        with dir.
*/
define renew_direction_vectors( dir, awm );
    lvars dir, awm;
    switchon dir
    case = "north" then
        consvec( 0, 1 ) -> awm.awm_forwardvector;
        consvec( 1, 0 ) -> awm.awm_rightvector;
    case = "east" then
        consvec( 1, 0 ) -> awm.awm_forwardvector;
        consvec( 0, -1 ) -> awm.awm_rightvector;
    case = "south" then
        consvec( 0, -1 ) -> awm.awm_forwardvector;
        consvec( -1, 0 ) -> awm.awm_rightvector;
    case = "west" then
        consvec( -1, 0 ) -> awm.awm_forwardvector;
        consvec( 0, 1 ) -> awm.awm_rightvector;
    else
        FAULT( 'renew_direction_vectors: bad direction' );
    endswitchon
enddefine;


define global awm_move( awm, action );
    lvars awm, action;
    switchon action
        case = "left" then awm_left( awm )
        case = "right" then awm_right( awm )
        case = "forward" then awm_forward( awm )
        case = "back" then awm_back( awm )
    endswitchon
enddefine;


vars vedawm;/*forward*/


define global ved_awm();
    vedawm(
        procedure(awm,varname);
            lvars awm,varname;
            awm -> valof(varname)
        endprocedure
    );
enddefine;


/*  vedawm( proc ):
        Reads the awm from the current Ved buffer, converts it to an awm
        record a, and calls
            proc( a, name )
        where name is the argument given to the Ved command.

        When using Pop-11, proc just assigns a to valof(name). However,
        we can also call vedawm from Prolog. Since Prolog users
        don't like accessing Pop-11 global variables, I supply _them_
        with a ved command for putting awms into the database.
        This requires encapsulating a differently, i.e. a different
        proc argument to vedawm.
*/
define vedawm( p );
    lvars p;
    lvars i, j, x_min, x_max, line_min, line_max;
    lvars varname, width, height, awm, c, undefchar, args, len;

    if vedargument = '' then
        vedbounds() -> line_max -> line_min -> x_max -> x_min;
        x_max -> width;
        line_max -> height;
        "awm" -> varname;
    else getvedargs( [1,2]) -> args -> len;
        vedbounds() -> line_max -> line_min -> x_max -> x_min;
        x_max -> width;
        line_max -> height;
        args(1).consword -> varname;
        if len = 2 then args(2)(1) else `?` endif -> undefchar;
    endif;
    new_awm( undefchar ) -> awm;

    for j to height do
        for i to width do
            vedjumpto(j,i);
            vedcurrentchar() -> c;
            if c = `B` then
                i->awm.awm_x;
                height-j+1 -> awm.awm_y;
                ` ` -> c;
            endif;
            c -> awm(i,height-j+1);
        endfor;
    endfor;
    p( awm, varname );

enddefine;


define global awm_app_neighbours( awm, x, y, p );
    lvars awm, x, y, p;
    lvars i, j;
    for i from max(x-1,awm.awm_x_known_min) to min(x+1,awm.awm_x_known_max) do
        for j from max(y-1,awm.awm_y_known_min) to min(y+1,awm.awm_y_known_max) do
            if not( i=x and j=y ) then p(awm,i,j) endif;
        endfor;
    endfor;
enddefine;


define global awm_app_vh_neighbours( awm, x, y, p );
    lvars awm, x, y, p;
    lvars i, j;

    for i from max(x-1,awm.awm_x_known_min) to min(x+1,awm.awm_x_known_max) do
        for j from max(y-1,awm.awm_y_known_min) to min(y+1,awm.awm_y_known_max) do
            if not( i=x and j=y ) and
               ( i=x or j=y ) then
                p(awm,i,j)
            endif;
        endfor;
    endfor;
enddefine;


define global awm_neighbour( awm, x, y, p );
    lvars awm, x, y, p;
    awm_app_neighbours( awm, x, y,
                        procedure(awm,i,j);
                            lvars awm, i, j;
                            if p(awm,i,j) then
                                true; exitfrom( awm_neighbour )
                            endif;
                        endprocedure
    );
    false;
enddefine;


vars app_awm;/*forward*/


define global awm_replace( awm, c, newc );
    lvars awm, c, newc;

    if isprocedure(c) then
        app_awm( awm,
                 procedure(awm,x,y);
                     lvars awm,x,y;
                     if c(awm(x,y)) then newc->awm(x,y) endif;
                 endprocedure
        )
    else
        app_awm( awm,
                 procedure(awm,x,y);
                     lvars awm,x,y;
                     if awm(x,y)=c then newc->awm(x,y) endif;
                 endprocedure
        )
    endif;
enddefine;


define global app_awm( awm, p );
    lvars awm, p;
    lvars i, j;
    for i from awm.awm_x_known_min to awm.awm_x_known_max do
        for j from awm.awm_y_known_min to awm.awm_y_known_max do
            p( awm, i, j );
        endfor;
    endfor;
enddefine;


endsection;
e, culprits;
        if issubstring('INVALID ARRAY SUBSCRIPT',1,message) then
            expand_awm( awm, x, y );
            c -> (awm.awm_chars)(x,y);
            clearstack();
            exitfrom(update_awm)
        else
            sysprmishap(message,culprits)
        endif;
    enddefine;

    min( awm.awm_x_known_min, x ) -> awm.awm_x_known_min;
    max( awm.awm_x_known_max, x ) -> awm.awm_x_known_max;
    min( awm.awm_y_known_min, y ) -> awm.awm_y_known_min;
    max( awm.awm_y_known_max, y ) ->awm.pl                                                                                              100705  017064  000205  00000000072 05427665512 006501  0                                                                                                     47426                                                                                    1  0                                                                                                                                                                 /*  AWM.PL  */


:- pop_load('awm_pl.p').

prolog.
 endif -> new_x_actual_max;
    if y < awm.awm_y_actual_min then y-5 else awm.awm_y_actual_min endif -> new_y_actual_min;
    if y > awm.awm_y_actual_max then y+5 else awm.awm_y_actual_max endif -> new_y_actual_max;

    newanyarray( [% new_x_actual_min, new_x_actual_max, new_y_actual_min, new_y_actual_max %],
                 awm.awm_undefchar, key_of_dataword("string") ) -> newchars;

    for i from awm.awm_x_actual_min to awm.awm_x_actual_max do
        awm1.pl                                                                                             100705  017064  000205  00000006202 05427665512 006563  0                                                                                                     47426                                                                                    1  0                                                                                                                                                                  zc awm za zl 4 -10 22 -10 19 63 63 63 63 63 63 63 63 63 63 63
 63 63 63 63 63 63 63 63 63 63 63 63 63 63 63 63 63 63 63 63 63
 63 63 63 63 63 63 63 63 63 63 63 63 63 63 63 63 63 63 63 63 63
 63 63 63 63 63 63 63 63 63 63 63 63 63 63 63 63 63 63 63 63 63
 63 63 63 63 63 63 63 63 63 63 63 63 63 63 63 63 63 63 63 63 63
 63 63 63 63 63 63 63 63 63 63 63 63 63 63 63 63 63 63 63 63 63
 63 63 63 63 63 63 63 63 63 63 63 63 63 63 63 63 63 63 63 63 63
 63 63 63 63 63 63 63 63 63 63 63 63 63 63 63 63 63 63 63 63 63
 63 63 63 63 63 63 63 63 63 63 63 63 63 63 63 63 63 63 63 63 63
 63 63 63 63 63 63 63 63 63 63 63 63 63 63 63 63 63 63 63 63 63
 63 63 63 63 63 63 63 63 63 63 63 63 63 63 63 63 63 63 63 63 63
 63 63 63 63 63 63 63 63 63 63 63 63 63 63 63 63 63 63 63 63 63
 63 63 63 63 63 63 63 63 63 63 63 63 63 63 63 63 63 63 63 63 63
 63 63 63 63 63 63 63 63 63 63 63 63 63 63 63 63 63 63 63 63 63
 63 63 63 63 63 63 63 63 63 63 63 63 63 63 63 63 63 63 63 63 63
 63 63 63 63 63 63 63 63 63 63 63 63 63 63 63 63 63 63 63 63 63
 63 63 63 63 63 63 63 63 63 63 63 63 63 63 63 63 63 63 63 63 63
 63 63 63 63 63 63 63 63 63 63 63 63 63 63 63 63 63 63 63 63 63
 63 63 63 63 63 63 42 42 42 42 42 42 42 42 42 42 42 42 42 42 42
 42 42 42 42 42 42 42 63 63 63 63 63 63 63 63 63 63 63 42 32 32
 32 32 32 32 42 32 32 32 32 32 42 32 32 32 32 32 32 32 42 63 63
 63 63 63 63 63 63 63 63 63 42 32 32 32 32 42 32 42 32 32 84 32
 32 42 32 32 32 32 32 32 32 42 63 63 63 63 63 63 63 63 63 63 63
 42 32 32 32 32 32 32 35 32 32 32 32 32 42 32 32 32 32 32 32 32
 42 63 63 63 63 63 63 63 63 63 63 63 42 32 32 32 32 32 32 42 32
 32 32 32 32 42 32 32 32 32 32 32 32 42 63 63 63 63 63 63 63 63
 63 63 63 42 32 32 32 107 32 32 42 32 32 32 32 32 64 32 32 32
 32 32 42 32 42 63 63 63 63 63 63 63 63 63 63 63 42 32 32 32 32
 32 32 42 32 32 32 32 32 42 32 32 42 32 32 32 32 42 63 63 63 63
 63 63 63 63 63 63 63 42 42 42 42 42 42 42 42 42 42 42 42 42 42
 32 32 32 42 32 32 32 42 63 63 63 63 63 63 63 63 63 63 63 42 32
 32 32 32 32 32 32 32 32 32 32 32 32 32 32 32 32 32 32 32 42 63
 63 63 63 63 63 63 63 63 63 63 42 32 32 32 32 32 32 32 32 32 32
 32 32 42 32 32 32 42 32 32 32 42 63 63 63 63 63 63 63 63 63 63
 63 42 32 32 32 32 32 32 32 32 32 32 32 32 42 32 43 32 42 32 32
 32 42 63 63 63 63 63 63 63 63 63 63 63 42 32 32 32 32 32 32 32
 32 32 32 32 32 42 32 42 32 42 32 32 32 42 63 63 63 63 63 63 63
 63 63 63 63 42 32 32 32 32 32 32 32 32 32 32 32 32 32 32 32 32
 32 32 32 32 42 63 63 63 63 63 63 63 63 63 63 63 42 42 42 42 42
 42 42 42 42 42 42 42 42 42 42 42 42 42 42 42 42 42 63 63 63 63
 63 63 63 63 63 63 63 63 63 63 63 63 63 63 63 63 63 63 63 63 63
 63 63 63 63 63 63 63 63 63 63 63 63 63 63 63 63 63 63 63 63 63
 63 63 63 63 63 63 63 63 63 63 63 63 63 63 63 63 63 63 63 63 63
 63 63 63 63 63 63 63 63 63 63 63 63 63 63 63 63 63 63 63 63 63
 63 63 63 63 63 63 63 63 63 63 63 63 63 63 63 63 63 63 63 63 63
 63 63 63 63 63 63 63 63 63 63 63 63 63 63 63 63 63 63 63 63 63
 63 63 63 63 63 63 63 63 63 63 63 63 63 63 63 63 63 63 63 63 63
 63 63 63 63 63 63 63 63 63 63 63 63 63 63 0 22 0 14 -10 22 -10
 19 4 4 north zc vec 0 1 zc vec 1 0
= "east"  then "south"
    endswitchon -> awm.awm_direction;
    renew_direction_vectors( awm.awm_direction, awm );
enddefine;


define global awm_set_direction( awm, dir );
    lvars awm, dir;
    dir -> awm.awm_direction;
enddefine;


/*  renew_direction_vectors( dir, awm ):
        Recalculate internal bug's direction vectors to be consistent
        with dir.
*/
define renew_direction_vectors( dir, awm );
    lvars dir, awm;
    switchon dir
    case = "north" then
     awm_path.p                                                                                          100705  017064  000205  00000007470 05427665513 007353  0                                                                                                     47426                                                                                    1  0                                                                                                                                                                 /*  AWM_PATH.P  */


section awm_path => awm_path;


/*
SPECIFICATION
-------------


This module finds a path within an awm, using hill-climbing search. An
``awm'' is an ``array world-model'', for letting a bug represent a map
of its world. For a description of AWMs and the operations on them, see
HELP AWM.

The module defines one routine, awm_path:


PUBLIC awm_path( awm, start, goal, safe ):

Searches for a path from start to goal within awm. The procedure safe
determines which points can be traversed and which are treated as
obstacles. The path is returned as a list of points whose first element
is start and whose final element is goal. Each point is represented as a
two-element list [%x,%y]. If there is no path, the procedure returns
false.

safe must be a procedure of three arguments, safe(awm,x,y) returning
true or false. It returns true if awm(x,y) is passable, and false if
it is an obstacle. You will usually want to define it as
    define safe(awm,x,y);
        lvars awm, x, y;
        awm(x,y) = ` `
    enddefine;


Because the search method will not always be the most suitable, I
describe it below. It works as follows:
    0)  Initialise a queue of points to [% start %].

    1)  Take the first element off the queue. If there is none,
        the search has failed: return false. Otherwise, this is
        the next point to be explored.

    2)  If this point is the goal, return true.

    3)  Find all the safe horizontal and vertical neighbours of this
        point, eliminating any which have already been explored. Add the
        others to the front of the queue, before all the points already
        there. We do this so that the points added are sorted by
        distance to goal: the nearer a point is to goal, the nearer it
        is to the front of the queue.

    4)  Go back to 1.

If you are unfamiliar with search, you will find it helpful to read
TEACH SEARCHING for an introduction, and then HELP SEARCH to see how I
implement and use it.
*/


/*
IMPLEMENTATION
--------------

We use path_search from SEARCH.P, supplying an insert procedure that
implements hill-climbing, using distance towards the goal as its
evaluation function.

This module has an associated HELP file, HELP AWM_PATH. Please keep
the two in step.
*/


needs utils;
needs vec;
needs awm;
needs search;


define global awm_path( awm, start, goal, safe );
    lvars awm, start, goal, safe;

    define next_from( point );
        lvars point;
        lvars x0=point.vec_x, y0=point.vec_y;
        [%
            awm_app_vh_neighbours( awm, x0, y0,
                                   procedure(awm,x,y);
                                       lvars awm, x, y;
                                       if safe(awm,x,y) then [% x, y %] endif;
                                   endprocedure
                                 )
        %]
    enddefine;

    define insert( newpoint, path, q );
        lvars newpoint, q, path;
        lvars d, first, rest, f, first_path;

        define dist( p1, p2 );
            lvars p1, p2;
            distance( p1.vec_x, p1.vec_y, p2.vec_x, p2.vec_y );
        enddefine;

        dist( goal, newpoint ) -> d;

        if q /= [] then
            dest(q) -> rest -> f;
            f(1) -> first;
            f(2) -> first_path;
            if d <= dist( goal, first ) then
                [ [^newpoint ^path] ^^q ]
            else
                [ [^first ^first_path] ^^(insert( newpoint, path, rest )) ]
            endif
        else
            [ [^newpoint ^path] ]
        endif;
    enddefine;

    path_search( start,
                 (nonop =)(% goal %),
                 next_from,
                 insert
               );

enddefine;


endsection;
if awm(x,y)=c then newc->awm(x,y) endif;
                 endprocedure
        )
    endif;
enddefine;


define global app_awm( awm, p );
    lvars awm, p;
    lvars i, j;
    for i from awm.awm_x_known_min to awm.awm_x_known_max do
        for j from awm.awm_y_known_min to awm.awm_y_known_max do
            p( awm, i, j );
        endfor;
    endfor;
enddefine;


endsectioawm_path.pl                                                                                         100705  017064  000205  00000005156 05427665513 007526  0                                                                                                     47426                                                                                    1  0                                                                                                                                                                 /*  AWM_PATH.PL  */


:- module awm_path;


:- public awm_path/5.



/*
SPECIFICATION
-------------


This module finds a path within an awm, using hill-climbing search. An
``awm'' is an ``array world-model'', for letting a bug represent a map
of its world. For a description of AWMs and the operations on them, see
HELP AWM.

The module defines one predicate, awm_path:


PUBLIC awm_path( awm, start, goal, safe ):

Searches for a path from start to goal within awm. The procedure safe
determines which points can be traversed and which are treated as
obstacles. The path is returned as a list of points whose first element
is start and whose final element is goal. Each point is represented as a
two-element list [%x,%y]. If there is no path, the procedure returns
false.

safe must be a procedure of three arguments, safe(awm,x,y) returning
true or false. It returns true if awm(x,y) is passable, and false if
it is an obstacle. You will usually want to define it as
    define safe(awm,x,y);
        lvars awm, x, y;
        awm(x,y) = ` `
    enddefine;


Because the search method will not always be the most suitable, I
describe it below. It works as follows:     
    0)  Initialise a queue of points to [% start %].

    1)  Take the first element off the queue. If there is none,
        the search has failed: return false. Otherwise, this is
        the next point to be explored.

    2)  If this point is the goal, return true.

    3)  Find all the safe horizontal and vertical neighbours of this
        point, eliminating any which have already been explored. Add the
        others to the front of the queue, before all the points already
        there. We do this so that the points added are sorted by
        distance to goal: the nearer a point is to goal, the nearer it
        is to the front of the queue.

    4)  Go back to 1.

If you are unfamiliar with search, you will find it helpful to read
TEACH SEARCHING for an introduction, and then HELP SEARCH to see how I
implement and use it.
*/


/*
IMPLEMENTATION
--------------

We call into AWM_PATH.P.

This module has an associated HELP file, HELP AWM_PATH. Please keep
the two in step.
*/


:- prolog_language( pop11 ).
needs awm_path;
:- prolog_language( prolog ).


awm_path( AWM, Here, There, Safe, Path ) :-
    prolog_eval( awm_path_pl(AWM,Here,There,Safe), Path ).


:- prolog_language( pop11 ).


define awm_path( AWM, Here, There, Safe );
    define safe(
    awm_path( AWM, Here, There, Safe );
enddefine;


:- prolog_language( prolog ).


:- endmodule.
 63 63 63 63 63
 awm_pl.p                                                                                            100705  017064  000205  00000000666 05427665513 007032  0                                                                                                     47426                                                                                    1  0                                                                                                                                                                 /*  AWM_PL.P  */





section $-awm => ved_pawm;


define ved_pawm();
    vedawm(
        procedure( awm, varname );
            lvars awm, varname;
            lvars assertion, goal;
            prolog_maketerm( awm, varname, 1 ) -> assertion;
            prolog_maketerm( assertion, "asserta", 1 ) -> goal;
            prolog_invoke( goal ).erase;
        endprocedure
    );
enddefine;


/*
endsection;
*/
63 63 63 63 63 63 63 63 63 63 42 32
 32 32 32 32 32 32 32 32 32 32 32 32 32 32 32 32 32 32 32 42 63
 63awm_to_objects.p                                                                                    100705  017064  000205  00000014034 05427665514 010545  0                                                                                                     47426                                                                                    1  0                                                                                                                                                                 /*  AWM_TO_OBJECTS.P  */


/*
SPECIFICATION
-------------

This file is used by PLANNING_BUG.PL. It converts an AWM into a list
of objects, regions, and coordinates.


The routine exported is
    awm_to_objects( awm )

This takes an AWM and divides it into regions, as implemented in
AWM_TO_REGIONS.P. It then runs over each object and produces a list of
objects. This is of the form
    [ <object-spec> <object-spec> <bug-spec> <bug-direction> ]

Each <object-spec> is a list of the form
    [% x, y, type, n, [r1, r2] %]
or
    [% x, y, type, n, r %]
where x and y are the location within the AWM; type is the object's type
(a word such as "rock"); n is a unique integer: no two objects have the
same number; r, r1, and r2 are region numbers. The region numbers are
arbitrary, but are printable characters. The first type of list is used
for doors and rocks, which join one region to another. The second type
is used for hammers, keys, and food, which sit entirely within one
region.

A <bug-spec> is like the first type of <object-spec>, but without the
object number:
    [% x, y, "me", r %]

A <bug-direction> is a list:
    [% "dir", fx, fy %]
where fx and fy are the components of Bug's forwardvector, as 
represented by its AWM.


Warning: these routines only work for certain types of world. Hammers,
keys, and food must not be embedded within a wall like this:
    ***T***
and doors and rocks must always be:
    ***@***
and must not be free-standing.
*/


/*
IMPLEMENTATION
--------------

See comments in awm_to_objects. This code depends on AWM_TO_REGIONS.P.
*/


needs awm_to_regions;
needs fault;


define awm_to_objects( awm );
    lvars awm;
    lvars objects;

    reset_object_no();
    /*  Each object has its own unique number. Reset the first number
        to 0.
    */

    awm_to_regions( awm,
                    `1`, procedure(c);1+c;endprocedure, false ).erase;
    /*  Mark regions within awm.  */

    [% app_awm( awm, classify ) %] -> objects;
    /*  Return a list of object classifications, including details
        of their regions.
    */

    [% awm.awm_x, awm.awm_y, "me", region_in(awm,awm.awm_x,awm.awm_y) %] :: objects -> objects;
    /*  Add the Bug to this. It is not explicitly represented as a
        character within the AWM.
    */

    [% "dir", awm.awm_forwardvector.vec_x, awm.awm_forwardvector.vec_y %] :: objects -> objects;
    /*  Add details of its direction.  */

    awm_replace( awm, designates_region, ` ` );
    /*  Wipe out the region markers.  */

    objects
enddefine;


/*  classify( awm, x, y ):
        awm is an AWM in which regions have been marked. classify
        returns details of the object at awm(x,y) as an
        <object-spec>: see specification comment.
        door, then it's represented as
*/
define classify( awm, x, y );
    lvars awm, x, y;
    lvars type;

    classifier( awm(x,y) ) -> type;
    switchon type
        case = "rock" orcase = "door" then
            [% x, y, type, new_object_no(), regions_joined_by(awm,x,y) %]
        case = "hammer" orcase = "key" orcase = "food" then
            [% x, y, type, new_object_no(), region_in(awm,x,y) %];
    endswitchon;
enddefine;


/*  region_in( awm, x, y ):
        awm(x,y) is assumed to be something like a hammer, that lies
        entirely within one region. region_in returns the character for
        that region.
*/
define region_in( awm, x, y );
    lvars awm, x, y;
    lvars found, r;
    awm_neighbour( awm, x, y,
                   procedure(awm,x,y);
                       lvars awm, x, y;
                       if designates_region( awm(x,y) ) then
                           awm(x,y)->r; true
                       else
                           false
                       endif;
                   endprocedure
    ) -> found;
    if not( found ) then
        FAULT( 'region_in: no region found', [%awm,x,y%] )
    endif;
    r;
enddefine;


/*  regions_joined_by( awm, x, y ):
        awm(x,y) is assumed to be something like a door, that separates
        one region from another. regions_joined_by returns the
        characters for those two regions as a list [% c1, c2 %], where
        c1 < c2.
*/
define regions_joined_by( awm, x, y );
    lvars awm, x, y;
    lvars r1, r2, found;
    region_in( awm, x, y ) -> r1;
    awm_neighbour( awm, x, y,
                   procedure(awm,x,y);
                       lvars awm, x, y;
                       lvars c=awm(x,y);
                       if designates_region( c ) then
                           if c=r1 then false
                           else c->r2; true
                           endif;
                       else
                           false
                       endif;
                   endprocedure
    ) -> found;
    if not( found ) then
        FAULT( 'regions_joined_by: no region found', [%awm,x,y%] )
    endif;

    if r1 < r2 then [% r1, r2 %] else [% r2, r1 %] endif;
enddefine;


/*  designates_region( c ):
        True if character c is used to mark a region in an AWM.         
*/
define designates_region( c );
    lvars c;
    c >= `1` and c <= `9`;
enddefine;


/*  classifier( c ):
        Returns a word naming the object whose character is c.             
*/
newproperty([%
             [% `*`, "boulder" %],
             [% `@`, "rock" %],
             [% `T`, "hammer" %],
             [% `#`, "door" %],
             [% `k`, "key" %],
             [% `:`, "narrows" %],
             [% `+`, "food" %],
             [% `Q`, "quicksand" %]
            %],
            10, "unknown", true ) -> classifier;


/*
Object numbers
--------------
*/


vars object_no;


/*  new_object_no():
        Return a new unique object number.
*/
define new_object_no();
    1 + object_no ->> object_no;
enddefine;


/*  reset_object_no():
        Reset the object number to 0.
*/
define reset_object_no();
    0 -> object_no;
enddefine;
         47426                                                                                    1  0                                                                                                                                                                 awm_to_objects.pl                                                                                   100705  017064  000205  00000007064 05427665514 010726  0                                                                                                     47426                                                                                    1  0                                                                                                                                                                 /*  AWM_TO_OBJECTS.PL  */


/*
SPECIFICATION
-------------

This file is used by PLANNING_BUG.PL. It converts an AWM into a list
of objects, regions, and coordinates. You should read the specification
at the top of AWM_TO_OBJECTS.P before going any further.


The predicate exported is
    awm_to_objects( AWM+, State-, StateAbs-, Map-, D- )

This takes an AWM as its first argument, and passes it to the Pop-11
routine awm_to_objects. From that's result, it generates a state
specifying what objects are found in which squares, an "abstract state"
specifying what objects are in what regions, a map specifying which
regions are adjacent, and a bug-direction.

State will become a list of elements, each of the form
    square( Obj, [X,Y] )
where Obj is either the atom 'me', or a structure such as hammer(1) or
key(3), and X,Y are the co-ordinates within AWM.

StateAbs will become a list of elements, each of the form
    in( R, Obj )
or
    blocked( R1, R2, Obj )
where R1 and R2 are integers identifying regions. The first form
indicates that Obj is entirely within R; the second, that it is a door
or rock set in a wall between them. The idea of the abstract state is
that it be used in an abstraction-based planner such as ABSTRIPS.

Map will become a list of elements
    joins( R1, R2 )
indicating that R1 is separated from R2 by a wall. Map contains both
joins(R1,R2) and joins(R2,R1). This is because it is to be used by a
planner, and I haven't worked out how to interface planning with
inference over states.

D is
    dir( [X,Y] )
where [X,Y] is Bug's forwardvector.


Note the caution in AWM_TO_OBJECTS.P about the limited range of worlds
this works on.
*/


/*
IMPLEMENTATION
--------------
*/


:- prolog_language(pop11).
needs awm_to_objects;
:- prolog_language(prolog).


awm_to_objects( AWM, State, StateAbs, Map, D ) :-
    prolog_eval( awm_to_objects(AWM), ObjectList ),
    stateify_objects( ObjectList, State, StateAbs, Map, D ).


/*  stateify_objects( ObjectList+, State-, StateAbs-, Map-, D- ):
        ObjectList is a list of objects, in the form specified by
        AWM_TO_OBJECTS.P. stateify_objects converts this to the other
        arguments.
*/
stateify_objects( [], [], [], [], [] ) :- !.

stateify_objects( [O1|On], S, SA, M, D ) :-
    stateify_object( O1, S1, SA1, M1, D1 ),
    stateify_objects( On, Sn, SAn, Mn, Dn ),
    append( S1, Sn, S ),
    append( SA1, SAn, SA ),
    append( M1, Mn, M ),
    append( D1, Dn, D ).


/*  stateify_object( Object+, State-, StateAbs-, Map-, D- ):
        Object is one element of an object list, in the form specified
        by AWM_TO_OBJECTS.P. stateify_object converts this to the other
        arguments, these each receive a list.
*/
stateify_object( [ X, Y, Type, Id, [ R1, R2 ] ], State, StateAbs, Map, D ) :-
    !,
    Obj =.. [ Type, Id ],
    ObjPred =.. [ Type, Obj ],
    State = [ square(Obj,[X,Y] ) ],
    StateAbs = [ blocked(R1,R2,Obj) ],
    Map = [ joins(R1,R2), joins(R2,R1) ],
    D = [].

stateify_object( [ X, Y, me, R ], State, StateAbs, Map, D ) :-
    !,
    State = [ square(me,[X,Y] ) ],
    StateAbs = [ in(me,R) ],
    Map = [],
    D = [].

stateify_object( [ dir, X, Y ], State, StateAbs, Map, D ) :-
    !,
    State = [],
    StateAbs = [],
    Map = [],
    D = [ dir([X,Y]) ].

stateify_object( [ X, Y, Type, Id, R ], State, StateAbs, Map, D ) :-
    Obj =.. [ Type, Id ],
    State = [ square(Obj,[X,Y] ) ],
    StateAbs = [ in(Obj,R) ],
    Map = [],
    D = [].
                                                                                                          awm_to_regions.p                                                                                    100705  017064  000205  00000013020 05427665515 010555  0                                                                                                     47426                                                                                    1  0                                                                                                                                                                 /*  AWM_TO_REGIONS.P  */


section awm_to_regions => awm_to_regions;


/*
SPECIFICATION
-------------

This module exports a routine for marking regions within an AWM. The
idea is best shown by an example:

    awm =>
    ** AWM:
         xk: -5 to 5;  yk: -5 to 5
         xbounds: -10 to 10;   ybounds: -10 to 10
         position: (0,0)
         forward: [0 1];   right: [1 0]
    ???     ???
    ???*****???
    ???     ???
      *   k  *
      *      *
      *  B   #
      *    * *
      *      *
    ???*****???
    ???     ???
    ???@    ???

    awm_to_regions( awm, `a`, procedure(c);1+c;endprocedure, true )
        -> regions;

    awm=>
    ** AWM:
         xk: -5 to 5;  yk: -5 to 5
         xbounds: -10 to 10;   ybounds: -10 to 10
         position: (0,0)
         forward: [0 1];   right: [1 0]
    ???eeeee???
    ???*****???
    ???ccccc???
    bb*ccckcc*d
    bb*cccccc*d
    bb*ccBccc#d
    bb*cccc*c*d
    bb*cccccc*d
    ???*****???
    ???aaaaa???
    ???@aaaa???

    regions==>
    ** [[101 [-2 5] [-1 5] [0 5] [1 5] [2 5]]
        [100 [5 -2] [5 -1] [5 0] [5 1] [5 2]]
        [99 [-2 -2]
            [-2 -1]
            <etc>
            [3 2]
            [2 3]]
        [98 [-5 -2]
            [-5 -1]
            <etc>
            [-4 -2]
            [-4 2]]
        [97 [-1 -5] [-2 -4] [-1 -4] [0 -5] [0 -4]
            [1 -5] [1 -4] [2 -5] [2 -4]]]

Essentially, within an AWM, awm_to_regions finds all the regions
(connected regions of blank squares, bounded by non-spaces or
undefineds), and replaces all the blanks in each with a unique
character. It also returns a list of these characters and the points
making up each region. The marked AWM can be used in various types of
analogical processing. For example, to find out what region an object is
in, you only need to look at the region markers neighbouring it.


PUBLIC awm_to_regions( awm, first_reg, next_reg, keep ):

This routine marks awm in the way described above. first_reg must be a
character, to be used as the marker for the first region found.
next_reg must be a function which when applied to a region marker,
yields the next one. In the example above, this is done just by
adding one to it.

If keep is true, awm_to_regions returns a list of sublists. Each sublist
is of the form
    [ <region> <point1> <point2> ... ]
where <region> is that region's character, and <point1> etc are the
points within the region, as vecs (or lists: see HELP VEC).        

If keep is true, awm_to_regions just returns an integer, giving the
number of regions found.


Resetting an AWM
----------------

You can use the routine awm_replace from AWM.P to get rid of the region
markers. In the example above, the call

    awm_replace( awm, procedure(c);lvars c; c>=`a`;endprocedure, ` ` );

will replace any character whose ASCII code is that for `a` or greater,
with a space.
*/


/*
IMPLEMENTATION
--------------

I use a brute-force method. awm_to_regions runs through its awm argument,
examining every character in turn. If this character is blank, it calls
flood to replace it and all the blanks connected to it by a region
marker. It then restarts the scan.

It should be possible to make this more efficient by not examining
characters which have been flooded out. I haven't thought about how to
do this.

This module has a HELP file, HELP AWM_TO_REGIONS. Keep it in step with
the code.
*/


needs awm;


vars flood;/*forward*/


define awm_to_regions( awm, first_reg, next_reg, keep );
    lvars awm, first_reg, next_reg, keep;
    lvars i=awm.awm_x_known_min, j=awm.awm_y_known_min;
    lvars reg=first_reg, regno=0, regions = [];

    /*  Scans from one beyond the location of the last-scanned
        character, i.e. (i+1,j) for a c. If found, set (i,j) to
        its location and return true, else return false.
    */
    define scan_until(c);
        lvars c;
        lvars x=i+1, y=j;
        repeat
            if x > awm.awm_x_known_max and y > awm.awm_y_known_max then return(false) endif;
            if x > awm.awm_x_known_max then awm.awm_x_known_min->x; 1+y->y; nextloop; endif;
            if awm(x,y) = c then x->i; y->j; return(true) else 1+x->x; endif;
        endrepeat;
    enddefine;

    while scan_until(` `) do
        1 + regno -> regno;
        if keep then
            [ [ ^reg ^^([%flood(awm,reg,i,j,keep)%]) ] ^^regions ] -> regions;
        else
            flood(awm,reg,i,j,keep)
        endif;
        next_reg(reg) -> reg;
    endwhile;

    if keep then regions else regno endif;          
enddefine;


/*  flood( awm, c, i, j, keep ):
        Starting at awm(i,j), which should be blank, fill it and all
        squares connected thereto with a c. We use depth-first search to
        do this, implemented by recursive calls to flood within
        awm_app_neighbours. If the recursion depth grows too big, we
        could use depth-first search from SEARCH.P instead.
*/
define flood( awm, c, i, j, keep );
    lvars awm, c, i, j, keep;

    if awm(i,j) = ` ` then
        c -> awm(i,j);
        if keep then [% i, j %] endif;
        awm_app_neighbours( awm, i, j,
                            procedure(awm,x,y);
                                lvars awm, x, y;
                                if awm(x,y) = ` ` then flood(awm,c,x,y,keep) endif
                            endprocedure
                          )
    endif;
enddefine;


endsection;
6                                                                                    1  0                                                                                                                                                                 budget.pl                                                                                           100705  017064  000205  00000001662 05427665517 007202  0                                                                                                     47426                                                                                    1  0                                                                                                                                                                 /*  BUDGET.PL  */


resolve [r].

stm [budget_needs_more_money].

stm_predicates all.

budget_needs_more_money     =>  tax_increases.
budget_needs_more_money     =>  real_wages_decrease.
tax_increases               =>  workers_incentives_decrease.
real_wages_decrease         =>  workers_incentives_decrease.
workers_incentives_decrease =>  production_decreases.
production_decreases        =>  exports_decrease.
exports_decrease            =>  budget_needs_more_money.


/*
This describes a small portion of what economists call macro-economics:
the relations between inflation, unemployment, etc. The relations are
not at all esoteric, in fact they are taken from "There's a Hole in My
Budget" by Flanders and Swann, in which there is a ``dialogue between
the Prime Minister and Chancellor, who wander round the room in a slow
inflationary spiral''. The song is a take-off of "There's a hole in my
bucket".
*/
he form
    in( R, Obj )
or
    blocked( R1, R2, Obj )
where R1 and R2 are integers identifying regions. The firbug.p                                                                                               100705  017064  000205  00000000606 05427677537 006333  0                                                                                                     47426                                                                                    1  0                                                                                                                                                                 ;;;  BUG.P
 
 
/*  This file defines a routine for calling "bug" from Pop-11. See
    BUG.PL for an explanation.
*/
 
 
define bug( Message );
    lvars Message;
    if stacklength() > 1 then
        prolog_invoke( prolog_maketerm( Message.consword, (), "bug", 2 ) )
    else
        prolog_invoke( prolog_maketerm( Message.consword, "bug", 1 ) )
    endif;
enddefine;
objects( ObjectList, State, StateAbs, Map, D ).


/*  stateify_objects( ObjectList+, State-, StateAbs-, Map-, D- ):
        ObjectList is a lisbug.pl                                                                                              100705  017064  000205  00000021612 05427677445 006505  0                                                                                                     47426                                                                                    1  0                                                                                                                                                                 /*  BUG.PL  */
 
 
:- module bug.
 
 
:- public bug/1,
          bug/2,
          warning/1,
          warning/2,
          assertion/1,
          assertion/2,
          assertion/3,
          '??' /1.
 
 
:- op( 100, fx, ?? ).
 
 
/*
SPECIFICATION
-------------
 
This module exports 'bug'. I call this to report "shouldn't happen"
errors, such as clauses that fail when they ought to succeed. 'bug'
reports the bug and aborts.
 
It also exports 'assertion', a variant of 'bug' that takes the condition
as an argument. Use this to state an assertion (i.e. program invariant)
that should hold at some point in your program.
 
?? is like assertion/1, but an operator declared for use when you
need to find out which goal in a sequence of goals has failed when it
ought to have succeeded. Put ?? in front of each goal, and re-run
the predicate.
 
 
NOTE WELL: This version of the module outputs MY address. Please replace
it by your own, since in general bugs will get reported to your students
or other users of the Tutor. Report any bugs you think I ought to know
about to me, but try to fix them first.
 
 
PUBLIC bug( Culprit+ ):
-----------------------
 
Report a program bug. Culprit will usually be the value that provoked
the bug: for example, an illegal argument value. It could also be a list
of culprits. In Prolog they're all terms anyway, and 'bug' just calls
'write' to display them.
 
'bug' writes Culprit to an output stream that's guaranteed to be
accessible and visible to the user (the 'user' stream on my system),
gives details of how to contact the bug-fixer, and aborts to the
top-level interpreter.
 
If your Prolog implements backtrace (mine doesn't), it's worth calling
it from the body of bug, to give you a trace of the calls leading up it.
 
 
PUBLIC bug( Where+, Culprit+ ):
-------------------------------
 
As bug/1, but writes Where just before writing Culprit, and writes the
word 'Culprit(s)' before Culprit.
 
 
PUBLIC warning( Culprit+ ):
PUBLIC warning( Where+, Culprit+ ):
-----------------------------------
 
Like bug, but don't halt after reporting.
 
 
PUBLIC assertion( Cond+ ):
--------------------------
 
Tests Cond and reports a bug iff it fails. Call this to specify
invariants that hold between your variables or facts, passing the
invariant as Cond.
 
 
PUBLIC assertion( Cond+, Term+ ):
---------------------------------
 
As assertion/1, but writes out Term as additional information.
 
 
PUBLIC assertion( Cond+, Term+, Culprit+ ):
-------------------------------------------
 
As assertion/1, but writes out Term and Culprit as additional
information.
 
 
PUBLIC ?? Goal+
---------------    
 
Like assertion/1, but writes a slightly different message saying that
?? detected a failure.
 
 
More notes on their use.
------------------------
 
If you look at a well-written program, you will find constructions like
this
    if i=2 then
        action1
    else if i=3 then
        action2
    else if i=5 then
        action3
    else
        Bug( 'In procedure P', Illegal value of i', i );
    end
using some general routine to report an illegal value and stop the
gracefully. If the language implements a case statement, a similar
call can be used to trap default values not in the list of cases. The
authors of ``Software Tools'' (Brian W. Kernighan and P. J. Plauger.) an
excellent book on how to write good programs and good tools, lay great
stress on this under the name of ``defensive programming'': trapping
bugs _before_ they cause a program to run wild and waste pages of
printer paper or hours of computer time.
 
Prolog is not quite as horrible as Fortran. But the technique is worth
adapting, especially to catch unexpected clause failures. These are
often caused by errors that lead to illegal arguments being passed:
    do_command( again ) :-
        do_again.
 
    do_command( bye ) :-
        do_bye.
 
    ...
 
    do_command( show(Range) ) :-
        do_show( Range ).
 
    do_command( Other ) :-
        bug( 'do_command', Other ).
If an illegal value were somehow passed to do_command and the final
clause weren't present, do_command would fail, perhaps provoking
unexpected backtracking much later on and causing the program to run
amok in a fashion having little apparent connection with the illegal
value. It's neater to trap, and report, the bug as soon as it's
detected. It would be even neater to be able to tell the Prolog compiler
that certain predicates should raise an error whenever they fail: much
as one can do with the NOFAIL control card for Snobol patterns. I
leave this as a suggestion for Prolog implementors.
 
By convention, I use predicates bug/1 and bug/2 for this. Their actions
are the same except that bug/2 takes one extra argument, usually a
message giving extra information about where the bug was detected. After
reporting the bug, they both call abort rather than halt. This leaves
Prolog running, so giving the programmer some chance of discovering more
about the bug's environment.
 
Poplog Prolog lacks the standard predicate backtrace. If your Prolog
implements backtrace, amend bug to call it; this will give you
information about the path leading up to the bug.
 
This module also exports assertion1/2/3. The idea is that they be used
as ``active annotations'' to indicate that the specified condition
should always hold at this point:
    assertion( Length1=Length2, 'list lengths should be equal' )
A good program will note such invariant conditions in its comments.
assertion gives the added bonus of signalling violations.
 
One place that I have found assertions particularly useful is in
situations such as
    p( X ) :-
        q( X ),
        fail.
 
    p( _ ).
where we want to call q and then undo the bindings it makes. There is an
example of this in module show. If some mistake causes q to fail when it
ought to succeed, this will not be visible in the control behaviour,
since p will succeed regardless. By changing the call of q(X) to
assertion(q(X)), we can trap such mistakes.
*/
 
 
/*
IMPLEMENTATION
--------------
 
'bug' writes the message and name of person to contact on 'user' and
halts. In my version, this module also defines a Pop-11 routine for
enabling 'bug' to be called from Pop-11. You can omit this if not using
Poplog!
 
'assertion' must call Cond in such a way that any bindings are
preserved. I.e. not inside a 'not'.
*/
 
 
/*  Load Pop-11 code in BUG.P. Omit this if not using Poplog.  */
:- pop_compile( 'bug.p' ).
 
 
bug( X ) :-
    bug_1( '*** BUG detected ***',
           '', '',
           X, '', ''
         ),
    abort.
 
 
bug( X, Culprit ) :-
    bug_1( '*** BUG detected ***',
           '', '',
           X, '\nCulprit(s): ', Culprit
         ),
    abort.
 
 
warning( X ) :-
    bug_1( '*** BUG detected ***',
           '', '',
           X, '', ''
         ).
 
 
warning( X, Culprit ) :-
    bug_1( '*** BUG detected ***',
           '', '',
           X, '\nCulprit(s): ', Culprit
         ).
 
 
assertion( Cond ) :-
    Cond, !.
 
assertion( Cond ) :-
    bug_1( '*** BUG (assertion violation) detected ***',
           'Failing condition was ', Cond,
           '', '', ''
         ),
    abort.
 
 
??( Cond ) :-
    Cond, !.
 
??( Cond ) :-
    bug_1( '*** ?? goal failed ***',
           'Failing condition was ', Cond,
           '', '', ''
         ),
    abort.
 
 
assertion( Cond, X ) :-
    Cond, !.
 
assertion( Cond, X ) :-
    bug_1( '*** BUG (assertion violation) detected ***',
           'Failing condition was ', Cond,
           X, '', ''
         ),
    abort.
 
 
assertion( Cond, X, Culprit ) :-
    Cond, !.
 
assertion( Cond, X, Culprit ) :-
    bug_1( '*** BUG (assertion violation) detected ***',
           'Failing condition was ', Cond,
           X, '\nCulprit(s): ', Culprit
         ),
    abort.
 
 
/*  bug_1( Type+, CondMsg+, Cond+, X1+, X2+, X3- ):
        Utility for writing bits of messages. The COS is assumed to be
        where you want the bug report to go.
*/
bug_1( Type, CondMsg, Cond, X1, X2, X3 ) :-
    telling( COS ),
    tell( user ),
    write( Type ), nl,
    (
        CondMsg \= ''
    ->
        write(CondMsg), write(Cond), nl
    ;
        true
    ),
    write(X1), write(X2), write(X3), nl,
    display_contact_address,
    tell( COS ).
 
 
/*  display_contact_address:
        Write details to COS of the person to receive bug reports.
*/
display_contact_address :-
    write( 'Please report the bug to Jocelyn Paine,' ), nl,
    write( 'Experimental Psychology, South Parks Road, Oxford OX1 3UD.' ),
    nl,
    write( 'Email: POPX @ UK.AC.OX.VAX.' ), nl.
 
 
:- endmodule.
Obj )
or
    blocked( R1, R2, Obj )
where R1 and R2 are integers identifying regions. The firchars_to_items.p                                                                                    100705  017064  000205  00000001506 05427665522 010550  0                                                                                                     47426                                                                                    1  0                                                                                                                                                                 /*  CHARS_TO_ITEMS.P  */


section $-chars_to_items => chars_to_items;


/*
SPECIFICATION
-------------

This module exports a routine for converting a list of characters into
a list of items. It is useful for itemising sentences read by a bug.

PUBLIC chars_to_items( chars ):

chars is a list or vector of characters, or a string. The result is the
corresponding list of Pop-11 items.
*/


/*
IMPLEMENTATION
--------------

Convert the argument to a string, then use stringin and incharitem on
that. Probably not the most efficient method.
*/


define global chars_to_items( chars );
    lvars chars;
    lvars proc, item;

    incharitem(stringin(cons_with consstring{%explode(chars)%})) -> proc;
    [% until ( proc()->item; item=termin ) do item enduntil %]
enddefine;


endsection;
                                                                       1  0                                                                                                                                                                 chars_to_items.pl                                                                                   100705  017064  000205  00000000166 05427665522 010725  0                                                                                                     47426                                                                                    1  0                                                                                                                                                                 /*  CHARS_TO_ITEMS.PL  */


chars_to_items( Chars, Items ) :-
    prolog_eval( chars_to_items(Chars), Items ).

 
?? is like assertion/1, but an operator declared for use when you
need to find out which goal in a sequence of goals has failed when it
ought to have succeeded. Put ?? in front of each goal, and re-run
the predicate.
 
 
NOTE WELL: This version of the module outputs MY address. Please replace
it by your own, since in general bugs will get reported to your students
or other users of the Tutor. Recollect.w                                                                                           100705  017064  000205  00000016620 05427665525 007207  0                                                                                                     47426                                                                                    1  0                                                                                                                                                                  zc world zl 0 zl 1 zl 2 2 5 zw 5 117 110 100 101 102 zs 17 99
 111 108 108 101 99 116 95 111 98 106 101 99 116 115 46 112 zw 5
 117 110 100 101 102 zw 5 117 110 100 101 102 31 8 za zl 4 0 30
 0 7 zw 5 117 110 100 101 102 zw 5 117 110 100 101 102 zw 5 117
 110 100 101 102 zw 5 117 110 100 101 102 zw 5 117 110 100 101
 102 zw 5 117 110 100 101 102 zw 5 117 110 100 101 102 zw 5 117
 110 100 101 102 zw 5 117 110 100 101 102 zw 5 117 110 100 101
 102 zw 5 117 110 100 101 102 zw 5 117 110 100 101 102 zw 5 117
 110 100 101 102 zw 5 117 110 100 101 102 zw 5 117 110 100 101
 102 zw 5 117 110 100 101 102 zw 5 117 110 100 101 102 zw 5 117
 110 100 101 102 zw 5 117 110 100 101 102 zw 5 117 110 100 101
 102 zw 5 117 110 100 101 102 zw 5 117 110 100 101 102 zw 5 117
 110 100 101 102 zw 5 117 110 100 101 102 zw 5 117 110 100 101
 102 zw 5 117 110 100 101 102 zw 5 117 110 100 101 102 zw 5 117
 110 100 101 102 zw 5 117 110 100 101 102 zw 5 117 110 100 101
 102 zw 5 117 110 100 101 102 zw 5 117 110 100 101 102 zw 5 117
 110 100 101 102 zw 5 117 110 100 101 102 zw 5 117 110 100 101
 102 zw 5 117 110 100 101 102 zw 5 117 110 100 101 102 zw 5 117
 110 100 101 102 zw 5 117 110 100 101 102 zw 5 117 110 100 101
 102 zw 5 117 110 100 101 102 zw 5 117 110 100 101 102 zw 5 117
 110 100 101 102 zw 5 117 110 100 101 102 zw 5 117 110 100 101
 102 zw 5 117 110 100 101 102 zw 5 117 110 100 101 102 zw 5 117
 110 100 101 102 zw 5 117 110 100 101 102 zw 5 117 110 100 101
 102 zw 5 117 110 100 101 102 zw 5 117 110 100 101 102 zw 5 117
 110 100 101 102 zw 5 117 110 100 101 102 zw 5 117 110 100 101
 102 zw 5 117 110 100 101 102 zw 5 117 110 100 101 102 zw 5 117
 110 100 101 102 zw 5 117 110 100 101 102 zw 5 117 110 100 101
 102 zw 5 117 110 100 101 102 zw 5 117 110 100 101 102 zw 5 117
 110 100 101 102 zw 5 117 110 100 101 102 zw 5 117 110 100 101
 102 zw 5 117 110 100 101 102 zw 5 117 110 100 101 102 zw 5 117
 110 100 101 102 zw 5 117 110 100 101 102 zw 5 117 110 100 101
 102 zw 5 117 110 100 101 102 zw 5 117 110 100 101 102 zw 5 117
 110 100 101 102 zw 5 117 110 100 101 102 zw 5 117 110 100 101
 102 zw 5 117 110 100 101 102 zw 5 117 110 100 101 102 zw 5 117
 110 100 101 102 zw 5 117 110 100 101 102 zw 5 117 110 100 101
 102 zw 5 117 110 100 101 102 zw 5 117 110 100 101 102 zw 5 117
 110 100 101 102 zw 5 117 110 100 101 102 zw 5 117 110 100 101
 102 zw 5 117 110 100 101 102 zw 5 117 110 100 101 102 zw 5 117
 110 100 101 102 zw 5 117 110 100 101 102 zw 5 117 110 100 101
 102 zw 5 117 110 100 101 102 zw 5 117 110 100 101 102 zw 5 117
 110 100 101 102 zw 5 117 110 100 101 102 zw 5 117 110 100 101
 102 zw 5 117 110 100 101 102 zw 5 117 110 100 101 102 zw 5 117
 110 100 101 102 zw 5 117 110 100 101 102 zw 5 117 110 100 101
 102 zw 5 117 110 100 101 102 zw 5 117 110 100 101 102 zw 5 117
 110 100 101 102 zw 5 117 110 100 101 102 zw 5 117 110 100 101
 102 zw 5 117 110 100 101 102 zw 5 117 110 100 101 102 zw 5 117
 110 100 101 102 zw 5 117 110 100 101 102 zw 5 117 110 100 101
 102 zw 5 117 110 100 101 102 zw 5 117 110 100 101 102 zw 5 117
 110 100 101 102 zw 5 117 110 100 101 102 zw 5 117 110 100 101
 102 zw 5 117 110 100 101 102 zw 5 117 110 100 101 102 zw 5 117
 110 100 101 102 zw 5 117 110 100 101 102 zw 5 117 110 100 101
 102 zw 5 117 110 100 101 102 zw 5 117 110 100 101 102 zw 5 117
 110 100 101 102 zw 5 117 110 100 101 102 zw 5 117 110 100 101
 102 zw 5 117 110 100 101 102 zw 5 117 110 100 101 102 zw 5 117
 110 100 101 102 zw 5 117 110 100 101 102 zw 5 117 110 100 101
 102 zw 5 117 110 100 101 102 zw 5 117 110 100 101 102 zw 5 117
 110 100 101 102 zw 5 117 110 100 101 102 zw 5 117 110 100 101
 102 zw 5 117 110 100 101 102 zw 5 117 110 100 101 102 zw 5 117
 110 100 101 102 zw 5 117 110 100 101 102 zw 5 117 110 100 101
 102 zw 5 117 110 100 101 102 zw 5 117 110 100 101 102 zw 5 117
 110 100 101 102 zw 5 117 110 100 101 102 zw 5 117 110 100 101
 102 zw 5 117 110 100 101 102 zw 5 117 110 100 101 102 zw 5 117
 110 100 101 102 zw 5 117 110 100 101 102 zw 5 117 110 100 101
 102 zw 5 117 110 100 101 102 zw 5 117 110 100 101 102 zw 5 117
 110 100 101 102 zw 5 117 110 100 101 102 zw 5 117 110 100 101
 102 zw 5 117 110 100 101 102 zw 5 117 110 100 101 102 zw 5 117
 110 100 101 102 zw 5 117 110 100 101 102 zw 5 117 110 100 101
 102 zw 5 117 110 100 101 102 zw 5 117 110 100 101 102 zw 5 117
 110 100 101 102 zw 5 117 110 100 101 102 zw 5 117 110 100 101
 102 zw 5 117 110 100 101 102 zw 5 117 110 100 101 102 zw 5 117
 110 100 101 102 zw 5 117 110 100 101 102 zw 5 117 110 100 101
 102 zw 5 117 110 100 101 102 zw 5 117 110 100 101 102 zw 5 117
 110 100 101 102 zw 5 117 110 100 101 102 zw 5 117 110 100 101
 102 zw 5 117 110 100 101 102 zw 5 117 110 100 101 102 zw 5 117
 110 100 101 102 zw 5 117 110 100 101 102 zw 5 117 110 100 101
 102 zw 5 117 110 100 101 102 zw 5 117 110 100 101 102 zw 5 117
 110 100 101 102 zw 5 117 110 100 101 102 zw 5 117 110 100 101
 102 zw 5 117 110 100 101 102 zw 5 117 110 100 101 102 zw 5 117
 110 100 101 102 zw 5 117 110 100 101 102 zw 5 117 110 100 101
 102 zw 5 117 110 100 101 102 zw 5 117 110 100 101 102 zw 5 117
 110 100 101 102 zw 5 117 110 100 101 102 zw 5 117 110 100 101
 102 zw 5 117 110 100 101 102 zw 5 117 110 100 101 102 zw 5 117
 110 100 101 102 zw 5 117 110 100 101 102 zw 5 117 110 100 101
 102 zw 5 117 110 100 101 102 zw 5 117 110 100 101 102 zw 5 117
 110 100 101 102 zw 5 117 110 100 101 102 zw 5 117 110 100 101
 102 zw 5 117 110 100 101 102 zw 5 117 110 100 101 102 zw 5 117
 110 100 101 102 zw 5 117 110 100 101 102 zw 5 117 110 100 101
 102 zw 5 117 110 100 101 102 zw 5 117 110 100 101 102 zw 5 117
 110 100 101 102 zw 5 117 110 100 101 102 zw 5 117 110 100 101
 102 zw 5 117 110 100 101 102 zw 5 117 110 100 101 102 zw 5 117
 110 100 101 102 zw 5 117 110 100 101 102 zw 5 117 110 100 101
 102 zw 5 117 110 100 101 102 zw 5 117 110 100 101 102 zw 5 117
 110 100 101 102 zw 5 117 110 100 101 102 zw 5 117 110 100 101
 102 zw 5 117 110 100 101 102 zw 5 117 110 100 101 102 zw 5 117
 110 100 101 102 zw 5 117 110 100 101 102 zw 5 117 110 100 101
 102 zw 5 117 110 100 101 102 zw 5 117 110 100 101 102 zw 5 117
 110 100 101 102 zw 5 117 110 100 101 102 zw 5 117 110 100 101
 102 zw 5 117 110 100 101 102 zw 5 117 110 100 101 102 zw 5 117
 110 100 101 102 zw 5 117 110 100 101 102 zw 5 117 110 100 101
 102 zw 5 117 110 100 101 102 zw 5 117 110 100 101 102 zw 5 117
 110 100 101 102 zw 5 117 110 100 101 102 zw 5 117 110 100 101
 102 zw 5 117 110 100 101 102 zw 5 117 110 100 101 102 zw 5 117
 110 100 101 102 za zl 4 0 30 0 7 42 42 42 42 42 42 42 42 42 42
 42 42 42 42 42 42 42 42 42 42 42 42 42 42 42 42 42 42 42 42 42
 42 32 32 32 32 32 32 32 32 32 101 32 32 32 32 32 32 32 32 32
 32 32 32 32 32 32 32 32 32 32 42 42 32 32 102 32 32 32 32 32
 32 32 32 32 32 32 32 103 32 32 32 32 32 32 32 32 32 32 32 32
 32 42 42 32 32 32 32 32 99 32 32 32 32 32 98 32 32 32 32 32 32
 32 32 32 32 32 32 32 32 32 32 32 42 42 32 32 32 32 32 32 32 97
 32 32 32 32 32 32 32 32 32 78 32 32 32 32 32 32 32 32 32 32 32
 42 42 32 32 32 32 32 32 32 32 32 32 32 100 32 32 32 32 32 32
 32 32 32 32 32 32 32 32 32 32 32 42 42 32 32 32 32 32 104 32
 32 32 32 32 32 32 32 32 32 32 32 32 32 32 32 32 32 32 32 32 32
 32 42 42 42 42 42 42 42 42 42 42 42 42 42 42 42 42 42 42 42 42
 42 42 42 42 42 42 42 42 42 42 42 42 zw 5 117 110 100 101 102
 zw 5 117 110 100 101 102 zw 5 117 110 100 101 102 zw 5 117 110
 100 101 102 zl 0 0 0
                                         47426                                                                                    1  0                                                                                                                                                                 control.pl                                                                                          100705  017064  000205  00000027030 05427677463 007410  0                                                                                                     47426                                                                                    1  0                                                                                                                                                                 /*  CONTROL.PL  */
 
 
:- module control.
 
 
:- public non_binding_call/1,
          call_without_failure/1,
          once/1,
          forall/2,
          while/2,
          for/5,
          for/3,
          for/2,
          for_in_list/3,
          for_in_list/4,
          for_reverse_in_list/3.
 
 
/*
SPECIFICATION
-------------
 
The Tutor frequently needs to perform some action for each solution
of a goal, or for each element of a list, or as long as a
particular condition holds. There is an advantage to building predicates
to encapsulate such loops, hiding the (often messy) details of how they
are implemented. It saves programmer time; and it makes for more legible
programs, for the same reason that
    FOR I = 1 TO 20 BY 2 DO PRINT(I)
is easier to read then
        I = 1
    1:
        IF I > 20 THEN GOTO 2
        PRINT(I)
        I = I + 1
        GOTO 1
    2:
The function of the code is made explicit instead of being distributed
amongst smaller components. This is one of the themes of ``Software
Tools'', the authors of which present a pre-processor that translates
loops and other control constructs written in Ratfor, a ``rational
version of Fortran'' into Fortran. (There is much to be said for
treating Fortran as fit only for automatic generation; it is certainly
not a suitable tool for human use.)
 
This module does the same job for Prolog, but encapsulates the gory
details of cuts and other low-level control inside predicates, rather
than using a pre-processor.
 
 
In more detail, 'once', 'call_without_failure' and 'non_binding_call'
alter the way goals are called. For example, 'once' (you may already
have it on your system) makes a goal non-resatisfiable.
 
Finally, there is a selection of looping predicates, for packaging up
'repeat'...'fail' loops and others. Some of these are similar to some
described in Tony Dodd's book "Prolog: A Logical Approach". Note that,
unlike him, I don't define any of the predicate names as operators. This
is to avoid interfering with names that the user of the Tutor might pick
on.
 
 
All these predicates have a goal as one of their arguments. If you are
using a cross-referencer, you may have to tell it that they do. For
example, if you call
    once( all_solns(G,S) )
the cross-referencer will have no more reason to think that 'all_solns'
is a predicate than it does in seeing
    write( all_solns(G,S) ).
And if all_solns/2 is undefined, the cross-referencer will not detect
that fact. However, you will probably have some way of telling it that
'once' actually takes something to be called. The same caution applies
to other program-analysis programs.
 
 
PUBLIC non_binding_call( Goal+ ):
Calls Goal and succeeds or fails accordingly. But does not make any variable
bindings, so even if Goal succeeds, its variables are in the same state
after the call as before.
 
Example:
    non_binding_call( (I=2,J=3,I=J) )  --  fails.
    non_binding_call( (I=2,J=2,I=J) )  --  succeeds, leaving I and J
                                           unbound.
 
 
 
PUBLIC once( Goal+ ):
Calls Goal and succeeds or fails accordingly, but is not resatisfiable.
 
Example:
Given the facts a(1), a(2), a(3), then
    once(( a(X), write(X) )), fail
writes 1 and then fails.
 
 
PUBLIC call_without_failure( Goal+ ):
Calls Goal and always succeeds. Not resatisfiable.
 
 
PUBLIC forall( Cond+, Goal+ ):
'forall' calls Goal for each resatisfaction of Cond, and then succeeds.
If Goal fails, the action is undefined ('forall' will call 'bug'). Not
resatisfiable. All variables in Cond and Goal are unbound on exit.
 
Example:
    forall( a(X), (write(X),write(' ')) )
writes 1 2 3 using the above clauses for a/1.
 
 
PUBLIC while( Cond+, Goal+ ):
'while' evaluates Cond, and if it succeeds, calls Goal. It repeats this
for as long as Cond continues to succeed. 'while' is different from
'forall' in that it evaluates Cond afresh on each cycle rather than
backtracking into it. If Goal fails, the action is undefined (a call to
'bug'). Not resatisfiable. All variables in Cond and Goal are unbound
on exit.
 
Example:
    while( a(X), (write(X),write(' ')) )
writes 1 indefinitely.                    
 
 
PUBLIC for( I-, Start+, End+, Step+, Goal+ ):
'for' calls Goal for values of I from Start to End, increasing by Step
each time, and then succeeds. If Goal fails, the action is undefined
(a call to 'bug'). Not resatisfiable. I, and all variables in Goal,
are unbound on exit.
 
If I > End on call, for succeeds and does nothing.
 
Example:
    for( I, 1, 20, 2, (write(I),write(' ')) )
writes
    1 3 5 7 9 11 13 15 17 19
 
 
PUBLIC for( I-, End+, Goal+ ):
Equivalent to for(I, 1, End, 1, Goal ).
 
 
PUBLIC for( N+, Goal+ ):
Calls Goal N times. Equivalent to for(_,N,Goal).
 
 
PUBLIC for_in_list( Elt-, List+, Goal+ ):
'for_in_list' calls Goal for Elt bound to each element of List, in
order, and then succeeds. If Goal fails, the action is undefined (a call
to 'bug'). Not resatisfiable. Elt, and all variables in Goal, are
unbound on exit.
 
Example:
    for_in_list( Elt, [a,b,c,d], (write(Elt),write(' ')) )
writes
    a b c d
 
 
PUBLIC for_reverse_in_list( Elt-, List+, Goal+ ):
As 'for_in_list', but the elements are visited in reverse order.
Example:
    for_reverse_in_list( Elt, [a,b,c,d], (write(Elt),write(' ')) )
writes
    d c b a
 
 
PUBLIC for_in_list( Elt-, List+, Goal+, SepGoal+ ):
This is like for_in_list/3. However, it also calls SepGoal _between_ each
pair of elements (i.e. at each "comma" in the list).
 
Example:
    for_in_list( Elt, [a,b,c,d], write(Elt), write(', ') )
writes
    a, b, c, d
*/
 
 
/*
IMPLEMENTATION
--------------
 
'once' and 'call_without_failure' are trivial. 'non_binding_call' uses
'not'. not(not(G)) must, to be logically correct, have the same
success/fail status as G, but it can't bind any variables - but see
below for a horrid bug in Poplog.
 
 
The looping predicates use (_->_;_) where necessary to cut out unwanted
alternatives. They all call 'bug' if their Goal fails. I've assumed goal
failure probably indicates an error - if the user really wants to pass a
goal that sometimes fails, she can make it always succeed by calling
call_without_failure.
 
There are several predicates - for, for_in_list, for_reverse_in_list,
while - that call Goal once and then call themselves recursively if they
need to call Goal again. For example:
    for( I, Start, End, Step, Goal ) :-
        Start =< End,
        !,
        non_binding_call(( I=Start,
                           (Goal->true;bug('for: goal failed',Goal)) )),
        NewStart is Start+Step,
        for( I, NewStart, End, Step, Goal ).
'for' calls Goal once with the index variable I bound to Start, and then
again with it bound to Start+Step. In doing this, we must beware of the
possibility that Goal may bind some variables in itself. If it does,
then we have to unbind them before the next call. We do this by using
'non_binding_call'. This also serves to unbind the index variable (I in
'for'; Elt in 'for_in_list').
 
 
Having said this, the implementation of 'while' is now more long-winded
than necessary. My original code was
    while( Cond, Goal ) :-
        non_binding_call(
                          (
                              Cond
                          ->
                              (Goal->true;bug('while:goal failed'))
                          ;
                              fail
                          )
                      ),
        while( Cond, Goal ).
    while( _, _ ).
which I prefer. But this malfunctions in a horrible way on Poplog
(versions 11 _and_ 13). The bug is most simply seen in the question
    ?- not( not( X=1 -> true ; true ) ).
which binds X to 1! 'not' should _never_ bind variables: something
pretty bad is going on here. Anyway, it's necessary to program around
it. Robert Duncan says this bug is fixed in Poplog V14.1.
 
I have had to fix some of the other predicates for the same reason.
They use 'assertion' instead of saying
    ( Goal -> true ; bug('while:goal failed') )
. This was something that could have done for 'while', but forgot about.
*/
 
 
:- needs assertion.
 
 
once(G) :- call(G), !.
 
 
call_without_failure( G ) :-
    ( call( G ) -> true ; true ).
 
 
non_binding_call( G ) :-
    not(not(G)).
 
 
forall( Cond, Goal ) :-
    Cond,
    assertion( Goal,
               'forall: goal failed',
               [Goal]
             ),
    fail.
 
forall( _, _ ).
 
 
while( Cond, Goal ) :-
    once((
            repeat,
            while_1( Cond ,Goal )
        )).
 
 
while_1( Cond, Goal ) :-
    Cond, !,
    assertion( Goal,
               'while: goal failed',
               [Goal]
             ),
    fail.
 
while_1( _, _ ).
 
 
for( I, Start, End, Step, Goal ) :-
    Start =< End,
    !,
    non_binding_call(( I=Start,
                       assertion( Goal,
                                  'for: goal failed',
                                  [Goal]
                                )
                    )),
    NewStart is Start+Step,
    for( I, NewStart, End, Step, Goal ).
 
for( _, _, _, _, _ ).
 
 
for( I, End, Goal ) :-
    for( I, 1, End, 1, Goal ).
 
 
for( N, Goal ) :-
    for( _, N, Goal ).
 
 
for_in_list( Elt, [Head|Tail], Goal ) :-
    !,
    non_binding_call(( Elt=Head,
                       assertion( Goal,
                                  'for_in_list: goal failed',
                                  [Goal]
                                )
                    )),
    for_in_list( Elt, Tail, Goal ).
 
for_in_list( Elt, [], _ ).
 
 
for_in_list( Elt, [Head], EltGoal, _ ) :-
    !,
    non_binding_call(( Elt=Head,
                       assertion( EltGoal,
                                  'for_in_list: goal failed',[EltGoal]
                                )
                    )).
 
for_in_list( Elt, [Head|Tail], EltGoal, SepGoal ) :-
    !,
    non_binding_call(( Elt=Head,
                       assertion( EltGoal,
                                  'for_in_list: goal failed',
                                  [EltGoal]
                                )
                    )),
    for_in_list_1( Elt, Tail, EltGoal, SepGoal ).
 
for_in_list( _, [], _, _ ).
 
 
for_in_list_1( Elt, [Head|Tail], EltGoal, SepGoal ) :-
    !,
    non_binding_call((
                       assertion( SepGoal,
                                  'for_in_list: sep goal failed',
                                  [SepGoal]
                                )
                    )),
    non_binding_call(( Elt=Head,
                       assertion( EltGoal,
                                  'for_in_list: goal failed',
                                  [EltGoal]
                                )
                    )),
    for_in_list_1( Elt, Tail, EltGoal, SepGoal ).
 
for_in_list_1( _, [], _, _ ).
 
 
for_reverse_in_list( Elt, [Head|Tail], Goal ) :-
    for_reverse_in_list( Elt, Tail, Goal ),
    non_binding_call(( Elt=Head,
                       assertion( Goal,
                                  'for_reverse_in_list: goal failed',
                                  [Goal]
                                )
                    )).
 
for_reverse_in_list( Elt, [], _ ).
 
 
:- endmodule.
gst smaller components. This is one of the themes of ``Software
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                defaultobjects.p                                                                                    100705  017064  000205  00000007240 05427665530 010543  0                                                                                                     47426                                                                                    1  0                                                                                                                                                                 section $-objects;


/*
Useful routines
---------------
*/


lib objectutils.p;


/*
Output
------
*/


define my_line1() -> items -> format;
    lvars items, format;
    'Action: ~10A    Facing: ~8A Position: ~8A' -> format;
    [% $-eden$-last_action, direction(), '('><bug_xW()><','><bug_yW()><')', %] -> items;
enddefine;


define my_line2() -> items -> format;
    lvars items, format;
    'Inventory: ~10A Here: ~8A   Time: ~8A' -> format;
    [% object_name(inventory()), object_name(object_at_bug()), $-eden$-time %] -> items;
enddefine;


/*
Spaces
------
*/


define nothing(message,id,x,y);
    lvars message, id, x, y;
    switchon message
    case =[forward] then
        obey(bw_forward);
    case =[back] then
        obey(bw_back);
    case =[right] then
        obey(bw_right);
    case =[left] then
        obey(bw_left);
    case =[wait] then
        ;
    else
        ;
    endswitchon;
enddefine;
define_object( "nothing", nothing, ` ` );


/*
Rocks
-----
*/


define boulder(message,id,x,y);
    lvars message, id, x, y;
    switchon message
    case =[forward] orcase =[back] then
        ;
    else
        ;
    endswitchon;
enddefine;
define_object( "boulder", boulder, `*` );


/*
Food
----
*/


define food(message,id,x,y);
    lvars message, id, x, y;
    switchon message
    case =[use] then
;;;        __hunger-1 -> __hunger;
        destroy( id );
    else
        portable(message,id,x,y)
    endswitchon;
enddefine;
define_object( "food", food, `+` );


/*
Doors and keys
--------------
*/


define key(message,id,x,y);
    lvars message, id, x, y;
    lvars next_x, next_y;
    switchon message
    case =[use] then
        one_forward(x,y) -> next_y -> next_x;
        if object_at(next_x,next_y) = `#` then
            destroy( [% next_x, next_y %] );
            destroy( id );
        endif;
    else
        portable(message,id,x,y)
    endswitchon;
enddefine;
define_object( "key", key, `k` );


define door(message,id,x,y);
    lvars message, id, x, y;
    boulder( message, id, x, y );
enddefine;
define_object( "door", door, `#` );


/*
Rocks and hammers
-----------------
*/


define hammer(message,id,x,y);
    lvars message, id, x, y;
    lvars next_x, next_y;
    switchon message
    case =[use] then
        one_forward(x,y) -> next_y -> next_x;
        if object_at(next_x,next_y) = `@` then
            destroy( [% next_x, next_y %] );
        endif;
    else
        portable(message,id,x,y)
    endswitchon;
enddefine;
define_object( "hammer", hammer, `T` );


define rock(message,id,x,y);
    lvars message, id, x, y;
    boulder( message, id, x, y );
enddefine;
define_object( "rock", rock, `@` );


/*
Quicksands
----------
*/


define quicksand(message,id,x,y);
    lvars message, id, x, y;
    switchon message
    case =[forward] orcase =[back] then
        nothing(message,id,x,y)
    else
        kill_bug()
    endswitchon;
enddefine;
define_object( "quicksand", quicksand, `Q` );


/*
Portable things
---------------
*/


define portable(message,id,x,y);
    lvars message, id, x, y;
    switchon message
    case =[forward] then
        obey(bw_forward);
    case =[back] then
        obey(bw_back);
    case =[left] then
        obey(bw_left);
    case =[right] then
        obey(bw_right);
    case =[grab] then
        obey(bw_grab);
    case =[drop] then
        obey(bw_drop);
    endswitchon;
enddefine;


/*
Obey
----
*/


define obey( proc );
    lvars proc;
    proc( $-eden$-world );
enddefine;


endsection;
ates an error - if the user really wants to pass a
goal that sometimes fails, she can make it alwadefaultworld                                                                                        100705  017064  000205  00000001734 05427665530 010005  0                                                                                                     47426                                                                                    1  0                                                                                                                                                                 !  DEFAULTWORLD

defaultobjects
        **********************************************
        * B        @ *            *    T             *
        *      QQQQQQ*            *                  *
        *      QQQQQQ*        ***********            *
        ** ** @QQQQkQ*        #         *            *
        *      QQQQQQ*        *********Q             *
        *      QQQQQQ*                *Q             *
        *          @ *                *Q             *
        *            *                *              *
        *        T   *                *              *
        *            *********        **************@*
        *            *                             *k*
        *            @                      ********@*
        *            *                      *+#      *
        *            *                      **********
        *            *                       *       *
        **********************************************
 in the question
    ?- not( not( X=1 -> true ; true ) ).defaultworld.w                                                                                      100705  017064  000205  00000055132 05427665531 010254  0                                                                                                     47426                                                                                    1  0                                                                                                                                                                  zc world zl 0 zl 1 zl 2 2 15 zw 5 117 110 100 101 102 zs 16 100
 101 102 97 117 108 116 111 98 106 101 99 116 115 46 112 zw 5
 117 110 100 101 102 zw 5 117 110 100 101 102 46 17 za zl 4 0
 45 0 16 zw 5 117 110 100 101 102 zw 5 117 110 100 101 102 zw 5
 117 110 100 101 102 zw 5 117 110 100 101 102 zw 5 117 110 100
 101 102 zw 5 117 110 100 101 102 zw 5 117 110 100 101 102 zw 5
 117 110 100 101 102 zw 5 117 110 100 101 102 zw 5 117 110 100
 101 102 zw 5 117 110 100 101 102 zw 5 117 110 100 101 102 zw 5
 117 110 100 101 102 zw 5 117 110 100 101 102 zw 5 117 110 100
 101 102 zw 5 117 110 100 101 102 zw 5 117 110 100 101 102 zw 5
 117 110 100 101 102 zw 5 117 110 100 101 102 zw 5 117 110 100
 101 102 zw 5 117 110 100 101 102 zw 5 117 110 100 101 102 zw 5
 117 110 100 101 102 zw 5 117 110 100 101 102 zw 5 117 110 100
 101 102 zw 5 117 110 100 101 102 zw 5 117 110 100 101 102 zw 5
 117 110 100 101 102 zw 5 117 110 100 101 102 zw 5 117 110 100
 101 102 zw 5 117 110 100 101 102 zw 5 117 110 100 101 102 zw 5
 117 110 100 101 102 zw 5 117 110 100 101 102 zw 5 117 110 100
 101 102 zw 5 117 110 100 101 102 zw 5 117 110 100 101 102 zw 5
 117 110 100 101 102 zw 5 117 110 100 101 102 zw 5 117 110 100
 101 102 zw 5 117 110 100 101 102 zw 5 117 110 100 101 102 zw 5
 117 110 100 101 102 zw 5 117 110 100 101 102 zw 5 117 110 100
 101 102 zw 5 117 110 100 101 102 zw 5 117 110 100 101 102 zw 5
 117 110 100 101 102 zw 5 117 110 100 101 102 zw 5 117 110 100
 101 102 zw 5 117 110 100 101 102 zw 5 117 110 100 101 102 zw 5
 117 110 100 101 102 zw 5 117 110 100 101 102 zw 5 117 110 100
 101 102 zw 5 117 110 100 101 102 zw 5 117 110 100 101 102 zw 5
 117 110 100 101 102 zw 5 117 110 100 101 102 zw 5 117 110 100
 101 102 zw 5 117 110 100 101 102 zw 5 117 110 100 101 102 zw 5
 117 110 100 101 102 zw 5 117 110 100 101 102 zw 5 117 110 100
 101 102 zw 5 117 110 100 101 102 zw 5 117 110 100 101 102 zw 5
 117 110 100 101 102 zw 5 117 110 100 101 102 zw 5 117 110 100
 101 102 zw 5 117 110 100 101 102 zw 5 117 110 100 101 102 zw 5
 117 110 100 101 102 zw 5 117 110 100 101 102 zw 5 117 110 100
 101 102 zw 5 117 110 100 101 102 zw 5 117 110 100 101 102 zw 5
 117 110 100 101 102 zw 5 117 110 100 101 102 zw 5 117 110 100
 101 102 zw 5 117 110 100 101 102 zw 5 117 110 100 101 102 zw 5
 117 110 100 101 102 zw 5 117 110 100 101 102 zw 5 117 110 100
 101 102 zw 5 117 110 100 101 102 zw 5 117 110 100 101 102 zw 5
 117 110 100 101 102 zw 5 117 110 100 101 102 zw 5 117 110 100
 101 102 zw 5 117 110 100 101 102 zw 5 117 110 100 101 102 zw 5
 117 110 100 101 102 zw 5 117 110 100 101 102 zw 5 117 110 100
 101 102 zw 5 117 110 100 101 102 zw 5 117 110 100 101 102 zw 5
 117 110 100 101 102 zw 5 117 110 100 101 102 zw 5 117 110 100
 101 102 zw 5 117 110 100 101 102 zw 5 117 110 100 101 102 zw 5
 117 110 100 101 102 zw 5 117 110 100 101 102 zw 5 117 110 100
 101 102 zw 5 117 110 100 101 102 zw 5 117 110 100 101 102 zw 5
 117 110 100 101 102 zw 5 117 110 100 101 102 zw 5 117 110 100
 101 102 zw 5 117 110 100 101 102 zw 5 117 110 100 101 102 zw 5
 117 110 100 101 102 zw 5 117 110 100 101 102 zw 5 117 110 100
 101 102 zw 5 117 110 100 101 102 zw 5 117 110 100 101 102 zw 5
 117 110 100 101 102 zw 5 117 110 100 101 102 zw 5 117 110 100
 101 102 zw 5 117 110 100 101 102 zw 5 117 110 100 101 102 zw 5
 117 110 100 101 102 zw 5 117 110 100 101 102 zw 5 117 110 100
 101 102 zw 5 117 110 100 101 102 zw 5 117 110 100 101 102 zw 5
 117 110 100 101 102 zw 5 117 110 100 101 102 zw 5 117 110 100
 101 102 zw 5 117 110 100 101 102 zw 5 117 110 100 101 102 zw 5
 117 110 100 101 102 zw 5 117 110 100 101 102 zw 5 117 110 100
 101 102 zw 5 117 110 100 101 102 zw 5 117 110 100 101 102 zw 5
 117 110 100 101 102 zw 5 117 110 100 101 102 zw 5 117 110 100
 101 102 zw 5 117 110 100 101 102 zw 5 117 110 100 101 102 zw 5
 117 110 100 101 102 zw 5 117 110 100 101 102 zw 5 117 110 100
 101 102 zw 5 117 110 100 101 102 zw 5 117 110 100 101 102 zw 5
 117 110 100 101 102 zw 5 117 110 100 101 102 zw 5 117 110 100
 101 102 zw 5 117 110 100 101 102 zw 5 117 110 100 101 102 zw 5
 117 110 100 101 102 zw 5 117 110 100 101 102 zw 5 117 110 100
 101 102 zw 5 117 110 100 101 102 zw 5 117 110 100 101 102 zw 5
 117 110 100 101 102 zw 5 117 110 100 101 102 zw 5 117 110 100
 101 102 zw 5 117 110 100 101 102 zw 5 117 110 100 101 102 zw 5
 117 110 100 101 102 zw 5 117 110 100 101 102 zw 5 117 110 100
 101 102 zw 5 117 110 100 101 102 zw 5 117 110 100 101 102 zw 5
 117 110 100 101 102 zw 5 117 110 100 101 102 zw 5 117 110 100
 101 102 zw 5 117 110 100 101 102 zw 5 117 110 100 101 102 zw 5
 117 110 100 101 102 zw 5 117 110 100 101 102 zw 5 117 110 100
 101 102 zw 5 117 110 100 101 102 zw 5 117 110 100 101 102 zw 5
 117 110 100 101 102 zw 5 117 110 100 101 102 zw 5 117 110 100
 101 102 zw 5 117 110 100 101 102 zw 5 117 110 100 101 102 zw 5
 117 110 100 101 102 zw 5 117 110 100 101 102 zw 5 117 110 100
 101 102 zw 5 117 110 100 101 102 zw 5 117 110 100 101 102 zw 5
 117 110 100 101 102 zw 5 117 110 100 101 102 zw 5 117 110 100
 101 102 zw 5 117 110 100 101 102 zw 5 117 110 100 101 102 zw 5
 117 110 100 101 102 zw 5 117 110 100 101 102 zw 5 117 110 100
 101 102 zw 5 117 110 100 101 102 zw 5 117 110 100 101 102 zw 5
 117 110 100 101 102 zw 5 117 110 100 101 102 zw 5 117 110 100
 101 102 zw 5 117 110 100 101 102 zw 5 117 110 100 101 102 zw 5
 117 110 100 101 102 zw 5 117 110 100 101 102 zw 5 117 110 100
 101 102 zw 5 117 110 100 101 102 zw 5 117 110 100 101 102 zw 5
 117 110 100 101 102 zw 5 117 110 100 101 102 zw 5 117 110 100
 101 102 zw 5 117 110 100 101 102 zw 5 117 110 100 101 102 zw 5
 117 110 100 101 102 zw 5 117 110 100 101 102 zw 5 117 110 100
 101 102 zw 5 117 110 100 101 102 zw 5 117 110 100 101 102 zw 5
 117 110 100 101 102 zw 5 117 110 100 101 102 zw 5 117 110 100
 101 102 zw 5 117 110 100 101 102 zw 5 117 110 100 101 102 zw 5
 117 110 100 101 102 zw 5 117 110 100 101 102 zw 5 117 110 100
 101 102 zw 5 117 110 100 101 102 zw 5 117 110 100 101 102 zw 5
 117 110 100 101 102 zw 5 117 110 100 101 102 zw 5 117 110 100
 101 102 zw 5 117 110 100 101 102 zw 5 117 110 100 101 102 zw 5
 117 110 100 101 102 zw 5 117 110 100 101 102 zw 5 117 110 100
 101 102 zw 5 117 110 100 101 102 zw 5 117 110 100 101 102 zw 5
 117 110 100 101 102 zw 5 117 110 100 101 102 zw 5 117 110 100
 101 102 zw 5 117 110 100 101 102 zw 5 117 110 100 101 102 zw 5
 117 110 100 101 102 zw 5 117 110 100 101 102 zw 5 117 110 100
 101 102 zw 5 117 110 100 101 102 zw 5 117 110 100 101 102 zw 5
 117 110 100 101 102 zw 5 117 110 100 101 102 zw 5 117 110 100
 101 102 zw 5 117 110 100 101 102 zw 5 117 110 100 101 102 zw 5
 117 110 100 101 102 zw 5 117 110 100 101 102 zw 5 117 110 100
 101 102 zw 5 117 110 100 101 102 zw 5 117 110 100 101 102 zw 5
 117 110 100 101 102 zw 5 117 110 100 101 102 zw 5 117 110 100
 101 102 zw 5 117 110 100 101 102 zw 5 117 110 100 101 102 zw 5
 117 110 100 101 102 zw 5 117 110 100 101 102 zw 5 117 110 100
 101 102 zw 5 117 110 100 101 102 zw 5 117 110 100 101 102 zw 5
 117 110 100 101 102 zw 5 117 110 100 101 102 zw 5 117 110 100
 101 102 zw 5 117 110 100 101 102 zw 5 117 110 100 101 102 zw 5
 117 110 100 101 102 zw 5 117 110 100 101 102 zw 5 117 110 100
 101 102 zw 5 117 110 100 101 102 zw 5 117 110 100 101 102 zw 5
 117 110 100 101 102 zw 5 117 110 100 101 102 zw 5 117 110 100
 101 102 zw 5 117 110 100 101 102 zw 5 117 110 100 101 102 zw 5
 117 110 100 101 102 zw 5 117 110 100 101 102 zw 5 117 110 100
 101 102 zw 5 117 110 100 101 102 zw 5 117 110 100 101 102 zw 5
 117 110 100 101 102 zw 5 117 110 100 101 102 zw 5 117 110 100
 101 102 zw 5 117 110 100 101 102 zw 5 117 110 100 101 102 zw 5
 117 110 100 101 102 zw 5 117 110 100 101 102 zw 5 117 110 100
 101 102 zw 5 117 110 100 101 102 zw 5 117 110 100 101 102 zw 5
 117 110 100 101 102 zw 5 117 110 100 101 102 zw 5 117 110 100
 101 102 zw 5 117 110 100 101 102 zw 5 117 110 100 101 102 zw 5
 117 110 100 101 102 zw 5 117 110 100 101 102 zw 5 117 110 100
 101 102 zw 5 117 110 100 101 102 zw 5 117 110 100 101 102 zw 5
 117 110 100 101 102 zw 5 117 110 100 101 102 zw 5 117 110 100
 101 102 zw 5 117 110 100 101 102 zw 5 117 110 100 101 102 zw 5
 117 110 100 101 102 zw 5 117 110 100 101 102 zw 5 117 110 100
 101 102 zw 5 117 110 100 101 102 zw 5 117 110 100 101 102 zw 5
 117 110 100 101 102 zw 5 117 110 100 101 102 zw 5 117 110 100
 101 102 zw 5 117 110 100 101 102 zw 5 117 110 100 101 102 zw 5
 117 110 100 101 102 zw 5 117 110 100 101 102 zw 5 117 110 100
 101 102 zw 5 117 110 100 101 102 zw 5 117 110 100 101 102 zw 5
 117 110 100 101 102 zw 5 117 110 100 101 102 zw 5 117 110 100
 101 102 zw 5 117 110 100 101 102 zw 5 117 110 100 101 102 zw 5
 117 110 100 101 102 zw 5 117 110 100 101 102 zw 5 117 110 100
 101 102 zw 5 117 110 100 101 102 zw 5 117 110 100 101 102 zw 5
 117 110 100 101 102 zw 5 117 110 100 101 102 zw 5 117 110 100
 101 102 zw 5 117 110 100 101 102 zw 5 117 110 100 101 102 zw 5
 117 110 100 101 102 zw 5 117 110 100 101 102 zw 5 117 110 100
 101 102 zw 5 117 110 100 101 102 zw 5 117 110 100 101 102 zw 5
 117 110 100 101 102 zw 5 117 110 100 101 102 zw 5 117 110 100
 101 102 zw 5 117 110 100 101 102 zw 5 117 110 100 101 102 zw 5
 117 110 100 101 102 zw 5 117 110 100 101 102 zw 5 117 110 100
 101 102 zw 5 117 110 100 101 102 zw 5 117 110 100 101 102 zw 5
 117 110 100 101 102 zw 5 117 110 100 101 102 zw 5 117 110 100
 101 102 zw 5 117 110 100 101 102 zw 5 117 110 100 101 102 zw 5
 117 110 100 101 102 zw 5 117 110 100 101 102 zw 5 117 110 100
 101 102 zw 5 117 110 100 101 102 zw 5 117 110 100 101 102 zw 5
 117 110 100 101 102 zw 5 117 110 100 101 102 zw 5 117 110 100
 101 102 zw 5 117 110 100 101 102 zw 5 117 110 100 101 102 zw 5
 117 110 100 101 102 zw 5 117 110 100 101 102 zw 5 117 110 100
 101 102 zw 5 117 110 100 101 102 zw 5 117 110 100 101 102 zw 5
 117 110 100 101 102 zw 5 117 110 100 101 102 zw 5 117 110 100
 101 102 zw 5 117 110 100 101 102 zw 5 117 110 100 101 102 zw 5
 117 110 100 101 102 zw 5 117 110 100 101 102 zw 5 117 110 100
 101 102 zw 5 117 110 100 101 102 zw 5 117 110 100 101 102 zw 5
 117 110 100 101 102 zw 5 117 110 100 101 102 zw 5 117 110 100
 101 102 zw 5 117 110 100 101 102 zw 5 117 110 100 101 102 zw 5
 117 110 100 101 102 zw 5 117 110 100 101 102 zw 5 117 110 100
 101 102 zw 5 117 110 100 101 102 zw 5 117 110 100 101 102 zw 5
 117 110 100 101 102 zw 5 117 110 100 101 102 zw 5 117 110 100
 101 102 zw 5 117 110 100 101 102 zw 5 117 110 100 101 102 zw 5
 117 110 100 101 102 zw 5 117 110 100 101 102 zw 5 117 110 100
 101 102 zw 5 117 110 100 101 102 zw 5 117 110 100 101 102 zw 5
 117 110 100 101 102 zw 5 117 110 100 101 102 zw 5 117 110 100
 101 102 zw 5 117 110 100 101 102 zw 5 117 110 100 101 102 zw 5
 117 110 100 101 102 zw 5 117 110 100 101 102 zw 5 117 110 100
 101 102 zw 5 117 110 100 101 102 zw 5 117 110 100 101 102 zw 5
 117 110 100 101 102 zw 5 117 110 100 101 102 zw 5 117 110 100
 101 102 zw 5 117 110 100 101 102 zw 5 117 110 100 101 102 zw 5
 117 110 100 101 102 zw 5 117 110 100 101 102 zw 5 117 110 100
 101 102 zw 5 117 110 100 101 102 zw 5 117 110 100 101 102 zw 5
 117 110 100 101 102 zw 5 117 110 100 101 102 zw 5 117 110 100
 101 102 zw 5 117 110 100 101 102 zw 5 117 110 100 101 102 zw 5
 117 110 100 101 102 zw 5 117 110 100 101 102 zw 5 117 110 100
 101 102 zw 5 117 110 100 101 102 zw 5 117 110 100 101 102 zw 5
 117 110 100 101 102 zw 5 117 110 100 101 102 zw 5 117 110 100
 101 102 zw 5 117 110 100 101 102 zw 5 117 110 100 101 102 zw 5
 117 110 100 101 102 zw 5 117 110 100 101 102 zw 5 117 110 100
 101 102 zw 5 117 110 100 101 102 zw 5 117 110 100 101 102 zw 5
 117 110 100 101 102 zw 5 117 110 100 101 102 zw 5 117 110 100
 101 102 zw 5 117 110 100 101 102 zw 5 117 110 100 101 102 zw 5
 117 110 100 101 102 zw 5 117 110 100 101 102 zw 5 117 110 100
 101 102 zw 5 117 110 100 101 102 zw 5 117 110 100 101 102 zw 5
 117 110 100 101 102 zw 5 117 110 100 101 102 zw 5 117 110 100
 101 102 zw 5 117 110 100 101 102 zw 5 117 110 100 101 102 zw 5
 117 110 100 101 102 zw 5 117 110 100 101 102 zw 5 117 110 100
 101 102 zw 5 117 110 100 101 102 zw 5 117 110 100 101 102 zw 5
 117 110 100 101 102 zw 5 117 110 100 101 102 zw 5 117 110 100
 101 102 zw 5 117 110 100 101 102 zw 5 117 110 100 101 102 zw 5
 117 110 100 101 102 zw 5 117 110 100 101 102 zw 5 117 110 100
 101 102 zw 5 117 110 100 101 102 zw 5 117 110 100 101 102 zw 5
 117 110 100 101 102 zw 5 117 110 100 101 102 zw 5 117 110 100
 101 102 zw 5 117 110 100 101 102 zw 5 117 110 100 101 102 zw 5
 117 110 100 101 102 zw 5 117 110 100 101 102 zw 5 117 110 100
 101 102 zw 5 117 110 100 101 102 zw 5 117 110 100 101 102 zw 5
 117 110 100 101 102 zw 5 117 110 100 101 102 zw 5 117 110 100
 101 102 zw 5 117 110 100 101 102 zw 5 117 110 100 101 102 zw 5
 117 110 100 101 102 zw 5 117 110 100 101 102 zw 5 117 110 100
 101 102 zw 5 117 110 100 101 102 zw 5 117 110 100 101 102 zw 5
 117 110 100 101 102 zw 5 117 110 100 101 102 zw 5 117 110 100
 101 102 zw 5 117 110 100 101 102 zw 5 117 110 100 101 102 zw 5
 117 110 100 101 102 zw 5 117 110 100 101 102 zw 5 117 110 100
 101 102 zw 5 117 110 100 101 102 zw 5 117 110 100 101 102 zw 5
 117 110 100 101 102 zw 5 117 110 100 101 102 zw 5 117 110 100
 101 102 zw 5 117 110 100 101 102 zw 5 117 110 100 101 102 zw 5
 117 110 100 101 102 zw 5 117 110 100 101 102 zw 5 117 110 100
 101 102 zw 5 117 110 100 101 102 zw 5 117 110 100 101 102 zw 5
 117 110 100 101 102 zw 5 117 110 100 101 102 zw 5 117 110 100
 101 102 zw 5 117 110 100 101 102 zw 5 117 110 100 101 102 zw 5
 117 110 100 101 102 zw 5 117 110 100 101 102 zw 5 117 110 100
 101 102 zw 5 117 110 100 101 102 zw 5 117 110 100 101 102 zw 5
 117 110 100 101 102 zw 5 117 110 100 101 102 zw 5 117 110 100
 101 102 zw 5 117 110 100 101 102 zw 5 117 110 100 101 102 zw 5
 117 110 100 101 102 zw 5 117 110 100 101 102 zw 5 117 110 100
 101 102 zw 5 117 110 100 101 102 zw 5 117 110 100 101 102 zw 5
 117 110 100 101 102 zw 5 117 110 100 101 102 zw 5 117 110 100
 101 102 zw 5 117 110 100 101 102 zw 5 117 110 100 101 102 zw 5
 117 110 100 101 102 zw 5 117 110 100 101 102 zw 5 117 110 100
 101 102 zw 5 117 110 100 101 102 zw 5 117 110 100 101 102 zw 5
 117 110 100 101 102 zw 5 117 110 100 101 102 zw 5 117 110 100
 101 102 zw 5 117 110 100 101 102 zw 5 117 110 100 101 102 zw 5
 117 110 100 101 102 zw 5 117 110 100 101 102 zw 5 117 110 100
 101 102 zw 5 117 110 100 101 102 zw 5 117 110 100 101 102 zw 5
 117 110 100 101 102 zw 5 117 110 100 101 102 zw 5 117 110 100
 101 102 zw 5 117 110 100 101 102 zw 5 117 110 100 101 102 zw 5
 117 110 100 101 102 zw 5 117 110 100 101 102 zw 5 117 110 100
 101 102 zw 5 117 110 100 101 102 zw 5 117 110 100 101 102 zw 5
 117 110 100 101 102 zw 5 117 110 100 101 102 zw 5 117 110 100
 101 102 zw 5 117 110 100 101 102 zw 5 117 110 100 101 102 zw 5
 117 110 100 101 102 zw 5 117 110 100 101 102 zw 5 117 110 100
 101 102 zw 5 117 110 100 101 102 zw 5 117 110 100 101 102 zw 5
 117 110 100 101 102 zw 5 117 110 100 101 102 zw 5 117 110 100
 101 102 zw 5 117 110 100 101 102 zw 5 117 110 100 101 102 zw 5
 117 110 100 101 102 zw 5 117 110 100 101 102 zw 5 117 110 100
 101 102 zw 5 117 110 100 101 102 zw 5 117 110 100 101 102 zw 5
 117 110 100 101 102 zw 5 117 110 100 101 102 zw 5 117 110 100
 101 102 zw 5 117 110 100 101 102 zw 5 117 110 100 101 102 zw 5
 117 110 100 101 102 zw 5 117 110 100 101 102 zw 5 117 110 100
 101 102 zw 5 117 110 100 101 102 zw 5 117 110 100 101 102 zw 5
 117 110 100 101 102 zw 5 117 110 100 101 102 zw 5 117 110 100
 101 102 zw 5 117 110 100 101 102 zw 5 117 110 100 101 102 zw 5
 117 110 100 101 102 zw 5 117 110 100 101 102 zw 5 117 110 100
 101 102 zw 5 117 110 100 101 102 zw 5 117 110 100 101 102 zw 5
 117 110 100 101 102 zw 5 117 110 100 101 102 zw 5 117 110 100
 101 102 zw 5 117 110 100 101 102 zw 5 117 110 100 101 102 zw 5
 117 110 100 101 102 zw 5 117 110 100 101 102 zw 5 117 110 100
 101 102 zw 5 117 110 100 101 102 zw 5 117 110 100 101 102 zw 5
 117 110 100 101 102 zw 5 117 110 100 101 102 zw 5 117 110 100
 101 102 zw 5 117 110 100 101 102 zw 5 117 110 100 101 102 zw 5
 117 110 100 101 102 zw 5 117 110 100 101 102 zw 5 117 110 100
 101 102 zw 5 117 110 100 101 102 zw 5 117 110 100 101 102 zw 5
 117 110 100 101 102 zw 5 117 110 100 101 102 zw 5 117 110 100
 101 102 zw 5 117 110 100 101 102 zw 5 117 110 100 101 102 zw 5
 117 110 100 101 102 zw 5 117 110 100 101 102 zw 5 117 110 100
 101 102 zw 5 117 110 100 101 102 zw 5 117 110 100 101 102 zw 5
 117 110 100 101 102 zw 5 117 110 100 101 102 zw 5 117 110 100
 101 102 zw 5 117 110 100 101 102 zw 5 117 110 100 101 102 zw 5
 117 110 100 101 102 zw 5 117 110 100 101 102 zw 5 117 110 100
 101 102 zw 5 117 110 100 101 102 zw 5 117 110 100 101 102 zw 5
 117 110 100 101 102 zw 5 117 110 100 101 102 zw 5 117 110 100
 101 102 zw 5 117 110 100 101 102 zw 5 117 110 100 101 102 zw 5
 117 110 100 101 102 zw 5 117 110 100 101 102 zw 5 117 110 100
 101 102 zw 5 117 110 100 101 102 zw 5 117 110 100 101 102 zw 5
 117 110 100 101 102 zw 5 117 110 100 101 102 zw 5 117 110 100
 101 102 zw 5 117 110 100 101 102 zw 5 117 110 100 101 102 zw 5
 117 110 100 101 102 zw 5 117 110 100 101 102 zw 5 117 110 100
 101 102 zw 5 117 110 100 101 102 zw 5 117 110 100 101 102 zw 5
 117 110 100 101 102 zw 5 117 110 100 101 102 zw 5 117 110 100
 101 102 zw 5 117 110 100 101 102 zw 5 117 110 100 101 102 zw 5
 117 110 100 101 102 zw 5 117 110 100 101 102 zw 5 117 110 100
 101 102 zw 5 117 110 100 101 102 zw 5 117 110 100 101 102 zw 5
 117 110 100 101 102 zw 5 117 110 100 101 102 zw 5 117 110 100
 101 102 zw 5 117 110 100 101 102 zw 5 117 110 100 101 102 zw 5
 117 110 100 101 102 zw 5 117 110 100 101 102 zw 5 117 110 100
 101 102 zw 5 117 110 100 101 102 zw 5 117 110 100 101 102 zw 5
 117 110 100 101 102 zw 5 117 110 100 101 102 zw 5 117 110 100
 101 102 zw 5 117 110 100 101 102 zw 5 117 110 100 101 102 zw 5
 117 110 100 101 102 zw 5 117 110 100 101 102 zw 5 117 110 100
 101 102 zw 5 117 110 100 101 102 zw 5 117 110 100 101 102 zw 5
 117 110 100 101 102 zw 5 117 110 100 101 102 zw 5 117 110 100
 101 102 zw 5 117 110 100 101 102 zw 5 117 110 100 101 102 zw 5
 117 110 100 101 102 zw 5 117 110 100 101 102 zw 5 117 110 100
 101 102 zw 5 117 110 100 101 102 zw 5 117 110 100 101 102 zw 5
 117 110 100 101 102 zw 5 117 110 100 101 102 zw 5 117 110 100
 101 102 zw 5 117 110 100 101 102 zw 5 117 110 100 101 102 zw 5
 117 110 100 101 102 zw 5 117 110 100 101 102 zw 5 117 110 100
 101 102 zw 5 117 110 100 101 102 zw 5 117 110 100 101 102 zw 5
 117 110 100 101 102 zw 5 117 110 100 101 102 zw 5 117 110 100
 101 102 zw 5 117 110 100 101 102 zw 5 117 110 100 101 102 zw 5
 117 110 100 101 102 zw 5 117 110 100 101 102 zw 5 117 110 100
 101 102 zw 5 117 110 100 101 102 zw 5 117 110 100 101 102 zw 5
 117 110 100 101 102 zw 5 117 110 100 101 102 zw 5 117 110 100
 101 102 zw 5 117 110 100 101 102 zw 5 117 110 100 101 102 zw 5
 117 110 100 101 102 zw 5 117 110 100 101 102 zw 5 117 110 100
 101 102 zw 5 117 110 100 101 102 zw 5 117 110 100 101 102 zw 5
 117 110 100 101 102 zw 5 117 110 100 101 102 zw 5 117 110 100
 101 102 zw 5 117 110 100 101 102 zw 5 117 110 100 101 102 zw 5
 117 110 100 101 102 zw 5 117 110 100 101 102 zw 5 117 110 100
 101 102 zw 5 117 110 100 101 102 zw 5 117 110 100 101 102 zw 5
 117 110 100 101 102 zw 5 117 110 100 101 102 zw 5 117 110 100
 101 102 zw 5 117 110 100 101 102 zw 5 117 110 100 101 102 zw 5
 117 110 100 101 102 zw 5 117 110 100 101 102 zw 5 117 110 100
 101 102 zw 5 117 110 100 101 102 zw 5 117 110 100 101 102 zw 5
 117 110 100 101 102 zw 5 117 110 100 101 102 zw 5 117 110 100
 101 102 zw 5 117 110 100 101 102 zw 5 117 110 100 101 102 zw 5
 117 110 100 101 102 zw 5 117 110 100 101 102 zw 5 117 110 100
 101 102 zw 5 117 110 100 101 102 zw 5 117 110 100 101 102 zw 5
 117 110 100 101 102 zw 5 117 110 100 101 102 zw 5 117 110 100
 101 102 zw 5 117 110 100 101 102 zw 5 117 110 100 101 102 zw 5
 117 110 100 101 102 zw 5 117 110 100 101 102 zw 5 117 110 100
 101 102 zw 5 117 110 100 101 102 zw 5 117 110 100 101 102 zw 5
 117 110 100 101 102 zw 5 117 110 100 101 102 zw 5 117 110 100
 101 102 zw 5 117 110 100 101 102 zw 5 117 110 100 101 102 za
 zl 4 0 45 0 16 42 42 42 42 42 42 42 42 42 42 42 42 42 42 42 42
 42 42 42 42 42 42 42 42 42 42 42 42 42 42 42 42 42 42 42 42 42
 42 42 42 42 42 42 42 42 42 42 32 32 32 32 32 32 32 32 32 32 32
 32 42 32 32 32 32 32 32 32 32 32 32 32 32 32 32 32 32 32 32 32
 32 32 32 32 42 32 32 32 32 32 32 32 42 42 32 32 32 32 32 32 32
 32 32 32 32 32 42 32 32 32 32 32 32 32 32 32 32 32 32 32 32 32
 32 32 32 32 32 32 32 42 42 42 42 42 42 42 42 42 42 42 32 32 32
 32 32 32 32 32 32 32 32 32 42 32 32 32 32 32 32 32 32 32 32 32
 32 32 32 32 32 32 32 32 32 32 32 42 43 35 32 32 32 32 32 32 42
 42 32 32 32 32 32 32 32 32 32 32 32 32 64 32 32 32 32 32 32 32
 32 32 32 32 32 32 32 32 32 32 32 32 32 32 32 42 42 42 42 42 42
 42 42 64 42 42 32 32 32 32 32 32 32 32 32 32 32 32 42 32 32 32
 32 32 32 32 32 32 32 32 32 32 32 32 32 32 32 32 32 32 32 32 32
 32 32 32 32 32 42 107 42 42 32 32 32 32 32 32 32 32 32 32 32
 32 42 42 42 42 42 42 42 42 42 32 32 32 32 32 32 32 32 42 42 42
 42 42 42 42 42 42 42 42 42 42 42 64 42 42 32 32 32 32 32 32 32
 32 84 32 32 32 42 32 32 32 32 32 32 32 32 32 32 32 32 32 32 32
 32 42 32 32 32 32 32 32 32 32 32 32 32 32 32 32 42 42 32 32 32
 32 32 32 32 32 32 32 32 32 42 32 32 32 32 32 32 32 32 32 32 32
 32 32 32 32 32 42 32 32 32 32 32 32 32 32 32 32 32 32 32 32 42
 42 32 32 32 32 32 32 32 32 32 32 64 32 42 32 32 32 32 32 32 32
 32 32 32 32 32 32 32 32 32 42 81 32 32 32 32 32 32 32 32 32 32
 32 32 32 42 42 32 32 32 32 32 32 81 81 81 81 81 81 42 32 32 32
 32 32 32 32 32 32 32 32 32 32 32 32 32 42 81 32 32 32 32 32 32
 32 32 32 32 32 32 32 42 42 32 32 32 32 32 32 81 81 81 81 81 81
 42 32 32 32 32 32 32 32 32 42 42 42 42 42 42 42 42 42 81 32 32
 32 32 32 32 32 32 32 32 32 32 32 42 42 42 32 42 42 32 64 81 81
 81 81 107 81 42 32 32 32 32 32 32 32 32 35 32 32 32 32 32 32
 32 32 32 42 32 32 32 32 32 32 32 32 32 32 32 32 42 42 32 32 32
 32 32 32 81 81 81 81 81 81 42 32 32 32 32 32 32 32 32 42 42 42
 42 42 42 42 42 42 42 42 32 32 32 32 32 32 32 32 32 32 32 32 42
 42 32 32 32 32 32 32 81 81 81 81 81 81 42 32 32 32 32 32 32 32
 32 32 32 32 32 42 32 32 32 32 32 32 32 32 32 32 32 32 32 32 32
 32 32 32 42 42 32 32 32 32 32 32 32 32 32 32 64 32 42 32 32 32
 32 32 32 32 32 32 32 32 32 42 32 32 32 32 84 32 32 32 32 32 32
 32 32 32 32 32 32 32 42 42 42 42 42 42 42 42 42 42 42 42 42 42
 42 42 42 42 42 42 42 42 42 42 42 42 42 42 42 42 42 42 42 42 42
 42 42 42 42 42 42 42 42 42 42 42 42 zw 5 117 110 100 101 102
 zw 5 117 110 100 101 102 zw 5 117 110 100 101 102 zw 5 117 110
 100 101 102 zl 0 0 0
102 zw 5 117 110 100 101 102 zw 5 117 110 100
 101 102 zw 5 117 110 100 101 102 zw 5 117 110 100 101 102 zw 5
 117 110 100 101 102 zw 5 117 110 100 101 102 zw 5 117 110 100
 101 102 zw 5 117 110 100 101 102 zw 5 117 110 100 101 102 zw 5
 117 110 100 101 102 zw 5 117 110 100 101 102 zw 5 117 110 100
 101 102 zw 5 117 110 100 101 102 zw 5 117 110 100 101 102 zw 5
 117 110 100 101 102 zw 5 117 110 100 101 102 zw 5 117 110 100
 101 102 zw 5 117 110 100 101 102 zw 5distribute.com                                                                                      100705  017064  000205  00000007556 05427665532 010256  0                                                                                                     47426                                                                                    1  0                                                                                                                                                                 ! Readme file
$ copy announce. [popx.aisoc.eden]                   
$ copy readme. [popx.aisoc.eden]

! Worlds
$ copy defaultobjects.p [popx.aisoc.eden.worlds]
$ copy defaultworld.w [popx.aisoc.eden.worlds]
$ copy defaultworld. [popx.aisoc.eden.worlds]
$ copy planning_world.w [popx.aisoc.eden.worlds]
$ copy planning_world. [popx.aisoc.eden.worlds]
$ copy tree_objects.p [popx.aisoc.eden.worlds]
$ copy tree_world.w [popx.aisoc.eden.worlds]
$ copy tree_world. [popx.aisoc.eden.worlds]
$ copy tw*.w [popx.aisoc.eden.worlds]
$ copy tw*. [popx.aisoc.eden.worlds]

! Bugs
$ copy exec_bug.p [popx.aisoc.eden.bugs]
$ copy manual_bug.p [popx.aisoc.eden.bugs]
$ copy next_world_bug.p [popx.aisoc.eden.bugs]
$ copy ps_bug.p [popx.aisoc.eden.bugs]
$ copy pse_bug.p [popx.aisoc.eden.bugs]
$ copy reincarnating_bug.p [popx.aisoc.eden.bugs]
$ copy search_bug.p [popx.aisoc.eden.bugs]
$ copy talk_bug.p [popx.aisoc.eden.bugs]
$ copy very_simple_bug.p [popx.aisoc.eden.bugs]

! Teach files

! Help files
$ copy awm. [popx.aisoc.eden.help]
$ copy awm_path. [popx.aisoc.eden.help]
$ copy awm_to_regions. [popx.aisoc.eden.help]
$ copy chars_to_items. [popx.aisoc.eden.help]
$ copy eden. [popx.aisoc.eden.help]
$ copy exec. [popx.aisoc.eden.help]
$ copy fault. [popx.aisoc.eden.help]
$ copy needs. [popx.aisoc.eden.help]
$ copy path_to_moves. [popx.aisoc.eden.help]
$ copy retina. [popx.aisoc.eden.help]
$ copy search. [popx.aisoc.eden.help]
$ copy senses_to_feature_vector. [popx.aisoc.eden.help]
$ copy stow. [popx.aisoc.eden.help]
$ copy style. [popx.aisoc.eden.help]
$ copy vec. [popx.aisoc.eden.help]

! Eden code
$ copy add_file_defaults.p [popx.aisoc.eden]
$ copy chars_to_items.p [popx.aisoc.eden]
$ copy competition_interface.p [popx.aisoc.eden]              
$ copy draw_lines.p [popx.aisoc.eden]
$ copy eden.p [popx.aisoc.eden]
$ copy eden_core.p [popx.aisoc.eden]
$ copy fault.p [popx.aisoc.eden]
$ copy load_file.p [popx.aisoc.eden]
$ copy needs.p [popx.aisoc.eden]
$ copy retina.p [popx.aisoc.eden]
$ copy stow.p [popx.aisoc.eden]
$ copy utils.p [popx.aisoc.eden]
$ copy vedreadlinechars.p [popx.aisoc.eden]
$ copy vec.p [popx.aisoc.eden]
$ copy worlds.p [popx.aisoc.eden]

! Useful bug-control libraries
$ copy awm.p [popx.aisoc.eden]
$ copy awm_path.p [popx.aisoc.eden]
$ copy awm_to_regions.p [popx.aisoc.eden]
$ copy exec.p [popx.aisoc.eden]
$ copy path_to_moves.p [popx.aisoc.eden]
$ copy search.p [popx.aisoc.eden]
$ copy senses_to_feature_vector.p [popx.aisoc.eden]

!Prolog Eden.
$ copy chars_to_items.pl [popx.aisoc.eden.plog]
$ copy eden.pl [popx.aisoc.eden.plog]
$ copy eden_core.pl [popx.aisoc.eden.plog]

!Prolog bug-control libraries.
$ copy [.plog]exec.pl [popx.aisoc.eden.plog]
$ copy [.plog]vec.pl [popx.aisoc.eden.plog]

!Prolog help files.
$ copy [.plog]exec. [popx.aisoc.eden.plog.help]
$ copy [.plog]vec. [popx.aisoc.eden.plog.help]

! Prolog bugs
$ copy exec_bug.pl [popx.aisoc.eden.plog.bugs]
$ copy manual_bug.pl [popx.aisoc.eden.plog.bugs]
$ copy planning_bug.pl [popx.aisoc.eden.plog.bugs]
$ copy awm_to_objects.p [popx.aisoc.eden.plog.bugs]
$ copy awm_to_objects.pl [popx.aisoc.eden.plog.bugs]
$ copy explore.p [popx.aisoc.eden.plog.bugs]
$ copy gb.pl [popx.aisoc.eden.plog.bugs]
$ copy gb_lex.pl [popx.aisoc.eden.plog.bugs]
$ copy warplan.pl [popx.aisoc.eden.plog.bugs]
$ copy logic$src:useful.pl [popx.aisoc.eden.plog.bugs]
$ copy logic$src:lists.pl [popx.aisoc.eden.plog.bugs]
$ copy logic$src:control.pl [popx.aisoc.eden.plog.bugs]
$ copy logic$src:output.pl [popx.aisoc.eden.plog.bugs]
$ copy [-.book]popbeast.tex [popx.aisoc.eden.plog.bugs]
$ copy reincarnating_bug.pl [popx.aisoc.eden.plog.bugs]
$ copy search_bug.pl [popx.aisoc.eden.plog.bugs]
$ copy talk_bug.pl [popx.aisoc.eden.plog.bugs]
$ copy very_simple_bug.pl [popx.aisoc.eden.plog.bugs]

$ pu [popx.aisoc...]
102 zw 5 117 110 100 101 102 zw 5
 117 110 100 101 102 zw 5 117 110 100 101 102 zw 5 117 110 100
 101 102 zw 5 117 110 100 101 102 zw 5 117 110 100 101 102 zw 5
 117 110 100 101 102 zw 5 117 110 100 101 102 zw 5 117 110 100
 101 102 zw 5 117 110 100 101 102 zw 5 117 110 100 101 102 zw 5
 117 110 1draw_lines.p                                                                                        100705  017064  000205  00000010004 05427665532 007666  0                                                                                                     47426                                                                                    1  0                                                                                                                                                                 /*  DRAW_LINES.P  */


section $-draw_lines => ved_point
                        ved_draw;


/*
SPECIFICATION
-------------

This module defines routines for drawing lines in Ved. They can be used
to draw worlds or retinal images.


PUBLIC ved_point():

This defines the Ved command 'point'. The command can take the following
forms:
    point
    point x y

The no-argument form "marks" the current point. The two-argument form
"marks" the point at column x on the specified line, and moves the
cursor thereto.


PUBLIC ved_draw():

This defines the Ved command 'draw'. The command can take the following
forms:
    draw
    draw char
    draw x y
    draw char x y

This draws a line from the "marked" point to the character at (x,y).
If char is omitted, it defaults to *. If (x,y) are omitted, they
default to the cursor position; if present, Ved jumps thereto before
drawing the line.
*/


/*
IMPLEMENTATION
--------------

ved_point notes the mark position, and stores it in point_x, point_y.

ved_draw establishes its end position, and draws there a line to from
point_x, point_y. To do this, it calls drawanyline.

drawanyline depends on procanyline(x1,y1,x2,y2,proc). This procedure
constructs a set of integral points (x,y) which plot the best
approximation to a line from (x1,y1) to (x2,y2), and calls proc(x,y) on
each point. For drawanyline, proc is something which puts a character at
(x,y). The code inside procanyline comes from the image-processing
routines in Ramsay and Barrett's book "AI in Practice".
*/


needs utils;


vars point_x, point_y;


define global ved_point();
    lvars args, len;
    if vedargument = '' then
        vedjumpto( vedline, vedcolumn )
    else
        getvedargs( [2] ) -> args -> len;
        vedjumpto( args(2), args(1) )
    endif;
    vedcolumn -> point_x;
    vedline -> point_y;
enddefine;


vars drawanyline;/*forward*/


define global ved_draw();              
    lvars args, len, char, x, y;
    if vedargument = '' then
        vedcolumn -> x; vedline -> y;
        `*` -> char;
    else
        getvedargs( [1,2,3] ) -> args -> len;
        if len = 2 then
            `*` -> char;
            args(1) -> x; args(2) -> y;
        elseif len = 1 then
            args(1)(1) -> char;
            vedcolumn -> x; vedline -> y;
        else
            args(3)(1) -> char;
            args(1) -> x; args(2) -> y;
        endif;
    endif;
    drawanyline( char, point_x, point_y, vedcolumn, vedline );
    vedjumpto( y, x );
    vedcolumn -> point_x;
    vedline -> point_y;
enddefine;


vars procanyline;/*forward*/


/*  drawanyline(c, x1, y1, x2, y2):
        Draw a line of c characters between x1,y1 and x2,y2 inclusive.
*/
define drawanyline(c, x1, y1, x2, y2);
    procanyline( x1, y1, x2, y2,
                 procedure( x, y, c );
                    vedjumpto( y.round, x.round );
                    c -> vedcurrentchar();
                 endprocedure(% c %)
    );
enddefine;


/*  procanyline(x1, y1, x2, y2, proc):
        Call proc on each x,y value between x1,y1 and x2,y2 inclusive.
        These values are interpolated to be suitable for Ved or turtle
        plotting. They may be reals, and not integers.
*/
define procanyline(x1, y1, x2, y2, proc);
    lvars x1, y1, x2, y2, proc;
    lvars inc, dx, dy, stepx; 

    x2 - x1 -> dx;
    y2 - y1 -> dy;
    if  round(dx) == 0 and round(dy) == 0 then
        proc(x2,y2); return
    endif;
    unless abs(dx) > abs(dy) ->> stepx then
        x1, y1 -> x1 -> y1;
        x2, y2  -> x2 -> y2;
        dx, dy -> dx -> dy;
    endunless;
    dy / abs(dx) -> inc;
    sign(dx) -> dx;
    for x1 from x1 by dx to x2 - (0.1 * dx) do
        proc(if stepx then
                    x1, y1
                 else
                    y1, x1
                 endif);
        y1 + inc -> y1;
    endfor;
    proc(if stepx then x2, y2 else y2, x2 endif);
enddefine;


endsection;
 32 32 32 32 32 32 35 32 32 32 32 32 32
 32 32 32 42 32 32 32 32 32 32 32 32 32 32 32 32 42 42 32 32 32
 32 32 32 81 81 81 81 81 81 42 32 32 32 32 32 32 32 32 42 42 42
 42 42 42 42 42 42 42 42 32 32 32 32 e.dir/                                                                                              040754  017064  000205  00000000000 05427751534 006237  5                                                                                                         0                                                                                    1  0                                                                                                                                                                 eden.com                                                                                            100705  017064  000205  00000000220 05427665533 006771  0                                                                                                     47426                                                                                    1  0                                                                                                                                                                 ! EDEN.COM
!
$ ass/user tt: sys$input
$ ass/user [popx.eden] poplib
$ ass/user 1 pop_on_pc
$ pop11 /[popx.eden]prolog /[popx.eden]eden
 05427665532 010256  0                                                                                                     47426                                                                                    1  0                                                                                                                                                                 eden.p                                                                                              100705  017064  000205  00000000466 05427665534 006467  0                                                                                                     47426                                                                                    1  0                                                                                                                                                                 /*  EDEN.P  */


/*
SPECIFICATION
-------------

This is the master file which load the code for Eden. It loads 'needs',
and then loads eden_core.
*/


/*
IMPLEMENTATION
--------------

See the implementation notes in EDEN_CORE.P for other information.
*/


lib needs;
lib eden_core;
ing_bug.p [popx.aisoc.eden.bugs]
$ copy search_bug.p [popx.aisoc.eden.bugs]
$ copy talk_bug.p [popx.aisoc.eden.bugs]
$ copy very_simple_bug.p [popx.aisoc.eden.bugs]

! Teach files

! Help files
$ copy awm. [popx.aisoc.eden.help]eden.pl                                                                                             100705  017064  000205  00000002732 05427673661 006641  0                                                                                                     47426                                                                                    1  0                                                                                                                                                                 /*  EDEN.PL  */


/*
SPECIFICATION
-------------

This is the master file which load the code for Eden.
*/


/*
IMPLEMENTATION
--------------

I name this file EDEN so that it has an obvious name. However, I want it
to be separate from the main body of Eden: that's why the latter is
called EDEN_CORE.
*/


/*  I don't use the Poplog 'module' facility because I've had some
    problems with it, and I'm not sure exactly how it switches
    contexts when calling from a predicate exported from one module
    to one defined in another. (See also the note in EDEN_CORE.P
    about 'eden'.) However, I put 'module' and 'public' directives
    at the head of all my modules to help those who will use
    a module system, whether Poplog's or someone else's. The
    declaration below makes them all dummy operators.

    For more information on programming style, see the text file
    STYLE.
*/
:- op( 253, fx, [module, public, dynamic, needs]).


/*  (1) Load the Pop-11 code for Eden.
    (2) Extend the Prolog library list with the current directory.
        This is done only so that I can use the Poplog built-in
        predicate 'library' to load my own files. You can omit it.
*/
:- prolog_language(pop11).
lib needs;
lib eden_core;
:- prolog_language(prolog).


/*  Load the Prolog interface to Eden, EDEN_CORE.PL. Also the
    'lib' module which I use.
*/
:- reconsult('eden$src:lib.pl').
:- reconsult('eden$src:eden_core').
lanning_bug.pl [popx.aisoc.eden.plog.bugs]
$ copy awm_to_objects.p [popx.aisoc.eden.plog.bugs]
$ copy aeden.tex                                                                                            100705  017064  000205  00000047530 05427665536 007035  0                                                                                                     47426                                                                                    1  0                                                                                                                                                                 \documentstyle[a4,epsf,alltt]{article}
\begin{document}


\include{commands}
\font \smalltt = cmtt8
\newcommand{\squash}[1]{{\smalltt #1}}

\title{How to run Eden}
\author{Jocelyn Paine}
\maketitle


\section{Eden}

This handout shows you how to run Eden. There is quite a lot of material
here. The best way to use it is to read it through once without trying
out the commands, to get an idea of what I'll ask you to do. Then read
through again, this time trying each command as I mention it.


\subsection{How to start Eden from the operating system}

Because CTC change their computer system from year to year, I can't
include here instructions on how to log in. You should already know this
from my demonstration, but if you don't, please ask. Note also that you
need to log in in different ways on different machines. In particular,
the method you use at CTC will not work in your college computer room,
or in the Department. (This is unfortunate, and is the result of a long
tradition of computer manufacturers refusing to standardise terminals
and other equipment.) So if you want to work elsewhere than CTC, please
ask me to show you how.

Let's assume then that you have already logged in and given your
identification. You will then be talking to the VAX's {\it operating
system}, the master control program which allocates the computer's
``attention'' between different programs and terminals. Each computer
manufacturer has its own name for its operating system --- the VAX
one is called VMS.

VMS signals its presence by displaying a dollar {\it prompt} at the
left hand end of the line. When you see this prompt, you can type a
command, which you must terminate by hitting the RETURN key.

VMS accepts a variety of commands, many of which are to do with
creating, copying, printing, and deleting files. If you have used
another operating system, MS-DOS for instance, you'll be familiar with
the type of thing they do. However, we shall not use these commands
much. VMS also accepts commands which tell it to run programs, and we
shall use one of these, the \verb/eden/ command. So when you see a
\verb/$/ prompt, type
\begin{verbatim}
eden
\end{verbatim}
and then hit the RETURN key. What this does is to tell VMS to start
running Prolog, and to load into it the Eden microworld-simulator.

You should make sure that you are typing in lower case --- that is, that
you don't have the CAPS LOCK key on. Although VMS doesn't mind whether
you use upper or lower case, Prolog does. Most letters in Prolog
commands have to be lower-case, apart from the occasional use of
upper-case for ``variables''.


\subsection{Starting a life from Prolog}
\label{eden:startlife}           

Once you have given VMS the \verb/eden/ command, there will be a short
wait, and you will then see a Prolog start-up message followed by a new
prompt --- not a dollar, but the symbols \verb/?-/. This tells you that
you are now talking to Prolog. Actually, you are talking to a version of
Prolog into which the code to run Eden has been automatically loaded. In
the rest of these notes, I may use either the name Prolog or the name
Eden, without being too careful about which.

The main thing you do, having started Eden, is to tell it to run a
particular bug ``brain'' in a particular world. Let's demonstrate this
with a simple production-system bug. Type the command
\begin{verbatim}
eps( psbug2, psworld2 ).
\end{verbatim}
and go on to the next section. Make sure that you include all the
punctuation, including the final dot. You must also hit RETURN
afterwards. If you forget the dot or the RETURN, then the system will
not regard your input as complete, and will just sit there waiting.


\subsection{Controlling Eden}

Once you have done this, the screen will start displaying one of the
micro-worlds, and eventually settle down into something like
figure~\ref{eden:start}, below:
\vfigstart
\begin{alltt}
\squash{
---!   7!- (1 Continue? y/n/s(low) <cycles>/f(ast) <cycles>/l(isten)/p(op)/refre
 Action: none          Facing: east     Position: (3,3)
 Inventory: nothing    Here: nothing    Time: 0


 ***********
 *         *
 *  B   S  *
 *         *
 *+     1  *
 ***********
}
\end{alltt}
\vfigend{eden:start}{An Eden display}

This shows the situation at the start of the bug's life. The line at the
top is a reminder of some of the commands you can give Eden, to control
the way it steps through the life. Do not try any of these until I say
so, in section~\ref{eden:experiments}.            

Below it are two lines showing various bits of status information: the
bug's previous action; the direction it is facing; its position; what it
is holding; the object, if any, it is standing next to; and the
``time''. Below that is the micro-world itself, the bug being indicated
by a \verb/B/.

The reason for having the status information is that the display is,
because of the terminals we are forced to use, very crude. The bug may
be in the same square as another object, but there is no way to display
that in the diagram. Nor can we show what it is holding, or which way it
is facing.

To appreciate how the control commands are used, you need to know how
Eden runs a life. Essentially, Eden consists of two parts: a
world-manager and a bug ``brain''. When you start a new life, these run
in a series of cycles, each cycle being as follows:
\begin{description}

\item[1] The world-manager generates from the current world, an image on
the bug's ``retina''. In some worlds, it may also generate various other
perceptions, such as a ``smell'' indicating roughly where the food is.

\item[2] It then activates the ``brain''. This ``thinks'' about the
perceptions, and eventually comes back with a ``motor command''.

\item[3] The world-manager works out how this action affects the bug and
the rest of the world. It updates the world accordingly, displaying the
changes on the screen.
\end{description}


\subsection{Stepping through a life}

The line at the top of the screen is a reminder of the commands
you can give to control how Eden steps through a bug's life.
You have several possible replies:

\begin{enumerate}

\item Typing \verb/y/ will run the life for one cycle. You will then be
invited to type another control command.

\item Typing \verb/n/ stops the life and returns to Prolog. You will
then get another \verb/?-/ prompt.

\item Typing \verb/s/ followed by a space and a number runs the life
for that number of cycles before asking for another control command.
We call this ``slow'' mode, because the screen is updated on every
cycle.

\item Typing \verb/f/ followed by a space and a number runs the world in
fast mode for that number of cycles. With fast mode enabled, Eden does
not update the screen between cycles. This allows you to run a large
number of cycles much faster than in slow mode. However, it also means
that you won't see what the bug is doing. This option is mainly useful
when testing machine-learning programs, and you won't need it much in
this course.

\item Typing \verb/l/ enables you to pass a sentence for Bug to
``listen'' to. You probably won't use this much either.

\item Typing \verb/r/ refreshes the screen. This is useful if, say, the
operators have just broadcast a general message, and you want to remove
it.

\item Typing \verb/e/ allows you to ``edit'' the world as the bug runs.
This is useful for experimenting with ``opportunism'' --- testing how
well your bug can adapt to sudden changes. To do this, you need to know
how to use the editor, and I'll go into this in a separate handout.

\item Typing \verb/v/ allows you to edit the view window. Again, you
need to know the editor first. Editing the view window is useful if
there's a lot of output, and you want to go back and look at it. It's
also useful if you want to print the window.

\end{enumerate}

\begin{sloppypar}
In each case, you must hit RETURN after replying. Note that your
keystrokes are not displayed as you respond to this question. One thing
that catches many people out is if you accidentally type some extra
characters before answering the question and hitting RETURN, Eden
will not understand what you meant and will repeat the question. In such
a case just be patient and retype.
\end{sloppypar}       

\subsection{Experimenting with the control commands}
\label{eden:experiments}

Let's now run through these. I assume that you haven't done anything
since starting the life in section~\ref{eden:startlife}, so you should
still have the initial display of figure~\ref{eden:start} shown on your
screen. The simplest thing you can do is to stop the life and
return to Prolog. To do this, type \verb/n/ and then hit RETURN. {\bf It
is important that here, and other places where RETURN is needed, you do
type it. If not, the system will just sit there waiting, and you will
never get a reply.}

The display should then clear. Once again, you will see Prolog's
\verb/?-/ prompt.

You can start another life by typing
\begin{verbatim}
eps( psbug2, psworld2 ).
\end{verbatim}
again. Remember to type the dot and the RETURN. For practice, do that
now, and then exit with \verb/n/ again.

You are now back in Prolog again. Start a third life as above. This
time, hit \verb/r/ and then RETURN. \verb/r/ stands for ``refresh'' or
``redraw''. The screen will flicker briefly as it is redrawn. I receive
quite a lot of Email messages, and when each arrives, VMS announces its
arrival by displaying a message. This may well happen when you are
running Eden: if so, use \verb/r/ to remove the message.

Having typed \verb/r/, you are still at the start of a life, and Eden is
waiting for another control command. This time, type \verb/s/, then hit
a space, then type \verb/30/, and then hit RETURN. You will see the bug
moving around in the upper part of the screen. At the same time, the
lower part will display what its ``brain'' is doing, in the form of
production-system rules. After about 20 moves, no more rules will apply,
and the life will finish, returning to Prolog.

If you want, you can try that again. It is always possible to run
a bug over and over again.

You have now tried the control commands \verb/n/, \verb/r/ and \verb/s/.
The final one to try is \verb/y/, which runs a bug in single-step mode.
This is where Eden pauses after each cycle and asks you whether you want
to continue. Start a new life, and then type \verb/y/ and RETURN. The
bug will go through one cycle, and then pause. Type \verb/y/ and RETURN
again. Keep doing this until the life exits.


\subsection{Two more commands --- turning the view window on and off}

There are two more control commands which are not shown on the status
line. These are \verb/+/ and \verb/-/, which turn the view window on and
off respectively.

When you start a life, the view window is turned on, and will display
all the production system's internal workings. Though useful, this does
slow down the display, so it's useful to know how to turn it off.

You should be back in Prolog, with the \verb/?-/ prompt. Start a new
life by typing
\begin{verbatim}
eps( psbug2, psworld2 ).
\end{verbatim}
Don't forget the dot and RETURN!

Then type \verb/-/ and RETURN. Eden will then invite you to type another
control command. Type \verb/s/, a space, \verb/30/, and RETURN. This
time, the bug will run through a life as above, but without the view
output. It will eventually exit to Prolog, as before.

You can turn the view window back on with \verb/+/, as I now show. Start
a new life. Type \verb/-/ and hit RETURN. Then type \verb/s/, a space,
\verb/10/, and RETURN. This will run the bug through 10 cycles. Next,
type \verb/+/ and RETURN. Then type \verb/s/, a space, \verb/20/, and
RETURN. This will run the bug through the rest of its life, this time
with the view window on.

Of course, you can also single-step, using \verb/y/, with view either on
or off.


\subsection{A shorter way to start new lives}
\label{eden:shorter}

It's a bit tedious to have to type
\begin{verbatim}
eps( psbug2, psworld2 ).
\end{verbatim}
every time you want to reincarnate the bug. Eden actually remembers
which brain and world were last used; if you want to use the same ones
again, you don't need to explicitly mention them. So if you are in
Prolog, and you want to re-run a bug you've already run, you can use a
short form of the command:
\begin{verbatim}
eden.
\end{verbatim}

Try this now. You must still have a dot and a RETURN to end the command.

Note: do not confuse this command with the \verb/eden/ command that you
typed to VMS. Although they have the same name, these two commands do
two quite different things, and you are talking to two different
programs when you give them. This is explained further in my handout on
{\it Who am I talking to? --- operating systems and the computer}. Note
also that you cannot give the \verb/eden./ command when you start the
first life from Prolog, because Eden won't know which brain and world to
use.


\subsection{What are the objects?}

One can create many different kinds of object in Eden, and you need not
be limited to those in \verb/psworld2/ or in the {\it AI and PopBeast}
example. But so that you know what is going on in \verb/psworld2/,
here's a table of the objects it contains:
\begin{description}

\item[{\tt *}] Boulder. Can't be picked up or moved through. I usually use
these to delimit the world.

\item[{\tt +}] Food. We use the symbol \verb/+/ because it adds something
to your energy! Can be picked up by doing a \verb/grab/. Once
picked up, it can be eaten by doing a \verb/use/. You can move over
it.

\item[{\tt 1}] Coin (one-p piece). Can be picked up and moved over. Once
picked up, if you are facing a slot machine, \verb/use/ing the coin will
cause it to disappear, and a piece of food to fall from the machine.

\item[{\tt S}] Slot machine. Can't be picked up or moved through.

\end{description}


\subsection{Logging out and in again}

After that interlude, back to computer commands. The next thing to do is
to try putting it all together, making sure that you can log in and
start Eden even if I'm not around.

You should still be talking to Prolog, as shown by the \verb/?-/ prompt.
First, exit from Prolog by hitting the CONTROL and Y keys at the same
time. This will get you back to VMS, which will display a \verb/$/
prompt. Incidentally, hitting CONTROL and Y will get you out of almost
any program.

Next, type \verb/logout/ and RETURN. This tells VMS that you want to
finish the session. You will see a long display of filenames, and will
then be disconnected from the VAX, back talking to the CTC microcomputer
network.

Now, try logging in again. Once logged in, type your identification.
Then start up Eden. Then start a life and run through it. Then exit from
Prolog and log out.

Continue trying this until you can do it without any help.


\subsection{The basic actions and objects}

This section is mainly for reference. It summarises the eight basic bug
actions, and the properties of the objects used in the {\it AI and
PopBeast} and {\it Production systems} handouts. You will need it before
you try out the manual bug described in the following section, and
before you start writing your own brains. Eden is not, by the way,
limited to the objects listed below, and it is possible to create new
types.

There are eight actions:
\begin{verbatim}
forward     back
right       left
grab        drop
use         wait
\end{verbatim}

Forward and back move one square forward or back, unless the square
being moved into is blocked, in which case nothing happens.

Right and left turn 90 degrees in the appropriate direction, but don't
move forward or back.

Drop and grab pick up or put down an object. If the bug tries to grab an
object but the object is ``too heavy'', nothing will happen; also
nothing will happen if it is already carrying something. Dropping an
object leaves it in the current square; if this is already occupied by
another object (of whatever type) nothing happens, and the bug remains
holding the object.

Waiting does nothing for a turn.

The effect of using an object depends on its type, so this is the next
thing to look at, in the table below.

The table also indicates, in the Share column, what happens on moving
into the same square as an object. A y in the Share column means that
the bug can enter the same square as the object, n means it can't.

The Grab column indicates the effect of grabbing an object. y means that
it can be picked up; n, that it can't.

The numbers refer to notes below.
\begin{center}
\begin{tabular}{llrrr}
Symbol   & Name             &  Grab & Share & Use       \\
\hline
\verb/B/ &  Bug             &  -    &    -  &    -      \\
\verb/+/ &  food            &  y    &    y  &    (3)    \\
\verb/*/ &  boulder         &  n    &    n  &    n      \\
\verb/@/ &  rock            &  n    &    n  &    n      \\
\verb/#/ &  door            &  n    &    n  &    n      \\
\verb/Q/ &  quicksand       &  n    &    (1)&    n      \\
\verb/T/ &  hammer          &  y    &    y  &    (4)    \\
\verb/k/ &  key             &  y    &    y  &    (5)    \\
\verb/:/ &  narrows         &  n    &    (2)&    n      \\
\verb/1/ &  coin            &  y    &    y  &    (6)    \\
\verb/S/ &  slot machine    &  n    &    n  &    n
\end{tabular}
\end{center}
\begin{description}
\item [1]  Moving forward or back off the quicksand is OK; any other
action will drown you.
\item [2]  You can only pass into a narrows if you are not holding
anything.
\item [3]  Using food eats it.
\item [4]  Using a hammer only does something if you are facing a
rock. The rock disappears, the hammer remains in your inventory.
\item [5]  Using a key only does something if you are facing a
door. The door and key both disappear.
\item [6]  Using a coin only does something if you are facing a
slot machine. The coin disappears, and a piece of food is dropped into
a randomly chosen empty square nearby.
\end{description}

In this table, the ``narrows'' corresponds to a narrow gap, that you can
only move through if not carrying anything.

Note that an unsuccessful action does not crash the system, it merely
has no effect.


\subsection{The manual bug}

It's sometimes useful to be able to try out actions manually before
building them into your bug brain. You can do this with the ``manual
bug''. This has an ``empty'' brain which just reads commands from the
keyboard and carries out the appropriate action.

To start it up, get into Prolog, and type
\begin{verbatim}
manual( psworld2 ).
\end{verbatim}
Note that you use the command \verb/manual/, not \verb/eps/ or
\verb/eden/, and that you only give it the name of a world.

When you get the world display, give the control command \verb/s/,
space, and \verb/200/, followed as usual by RETURN. You will then get a
display inviting you to type one of the letters \verb/f/, \verb/b/,
\verb/l/, \verb/r/, \verb/g/, \verb/d/, \verb/w/, \verb/u/ or \verb/q/.
The first eight are the initial letters of the eight basic bug actions.
The final one, \verb/q/, causes the bug to quit the life, returning to
Prolog.

Now you know what the actions do, you can try these out. For example,
try picking up the coin and using it in the machine.

You might also like to try the puzzle set by the \verb/defaultworld/.
This is the world with which I introduced Eden in {\it AI and PopBeast}.
Try
\begin{verbatim}
manual( defaultworld ).
\end{verbatim}
and see whether you can get the bug to the food.

If you want to run the manual bug in the same world more than once, you
need not type the full command again. As in section~\ref{eden:shorter},
you can just type
\begin{verbatim}
eden.
\end{verbatim}
followed of course by RETURN.

\end{document}
 may well happen when you are
running Eden: if so, use \verb/r/ to remove the message.

Having typed \verb/r/, you are still at the start of a life, and Eden is
waiting for another control command. This time, type \verb/s/, then hit
a space, then type \verb/30/, and then hit RETURN. You will seden_core.p                                                                                         100705  017064  000205  00000131462 05427665537 007503  0                                                                                                     47426                                                                                    1  0                                                                                                                                                                 /*  EDEN_CORE.P  */


section $-eden => eden,
                  resume_eden,
                  exit_eden,
                  define_bug,
                  say,
                  heard_from,
                  inventory,
                  retina,
                  bug_message,
                  bug_using_ved,
                  bug_view,
                  bug_view_on,
                  bug_view_off;


/*
SPECIFICATION
-------------

This is the main module defining Eden. It has to be loaded by EDEN.P.
For details of Eden itself, see HELP EDEN. The specifications given
below assume you have read that.


Running Eden:
=============

PUBLIC eden( <arguments> ):

'eden' starts Eden running, putting a bug into a world and setting it
off. The arguments are
    eden( <bug-file>, <world-file>, <options> )
    eden( <options>  )
where <options> stands for any number (including none) of the following
arguments, in any order:
    "no_ved"
    "batch"
    "prolog"
    [% "save", file, proc, proc, ... %]

<bug-file> and <world-file> must be strings, denoting files. The
bug-file must be a file of Pop-11 code, and its extension defaults to
.P. The world-file contains a saved world, as saved by the Ved 'saveworld'
command, and its extension defaults to .W.

If a file is specified without a directory, Eden looks first in the
current directory. If it can't find the file there, it then searches the
library files, as defined by 'popuseslist'. See HELP POPUSESLIST for
more details. This assumes Eden and the standard worlds and bugs
will have been set up as libraries, which I hope will be true on most
systems.

The "no_ved", "batch" and "prolog" options are Pop-11 words. The save
option is a list whose first element should be the word "save", whose
second element should be a filename, and whose remaining elements should
be procedures.

Example calls of eden are:
    eden( "no_ved" );
    eden( 'MYBUG', 'tw1', [ save mycases ^retina ], "batch" );
    eden( 'manual_bug', 'MyWorld',
          [% "save", 'CASES', retina %], "no_ved" );

The "prolog" option should only be used by Prolog Eden, when calling
'eden' from Prolog. It isn't for the user.


How to avoid repeating filenames
--------------------------------

If the world and bug you want to eden are exactly the same as last time,
you can omit them. You can still specify the other options to eden(), for
instance:
    eden();
    eden( "batch" );
    eden( [% "save", 'CASES', retina %], "no_ved" );


Saving cases
------------

By using the save option, you can direct that perceptions and actions
are to be stored in a file. You can then read this back later, and use
it (for example) for training a neural net.

Example options are:
    [ save cases ^retina ]
    [ save fred ]
    [ save cases ^myproc ]

In each of these, the second element is a filename. It can be either a
word or a string. The remaining elements are procedure names. Each
procedure should return at least one result. The procedures can be
Eden's perceptual procedures, etc., or can be your
own.

When running your bug in save mode, Eden starts each cycle by invoking
your 'think' procedure, and noting the action returned. It then calls
each procedure in your save-list, and makes a list of the results. It
puts the action at the end of this list, and saves the whole list in a
your file. So if your save option was this
    [ save cases ^retina ^smell ]
then the first list saved might be
    [% R, "forward", "forward" %]
where R stands for the retina (it will be saved as an
array, of course), and the last two elements are the smell and the bug's
action. These lists would all be saved in the file CASES. Everything
else works as without the save option; the only difference you may
notice is that the simulation will be slightly slower.

The saved cases can be read back with library STOW, see HELP STOW.
Briefly, suppose you have a case file called CASES. You can ``open''
this by doing
    unstow_from( 'CASES' ) -> r;
This makes 'r' into a ``repeater'' --- that is a procedure that, on each
call, returns the next item in sequence.

So if your save option had been
    [ save cases ^retina ^smell ]
then each call of r would give you a list whose first element was the
whose second was the retina, and whose third was the smell. As
mentioned above, the first of these might be
    [% 500, R, "forward", "forward" %]


Running without Ved
-------------------

To run outside Ved, give the "no_ved" option to eden(). Eden will run,
displaying the world and status information for each cycle in teletype
mode, as a sequence of lines. The prompts are the same, but you won't be
able to edit sentences passed to the listener. Examples are:
    eden( "no_ved" );
    eden( 'talk_bug', 'tw3', "no_ved" );


Batch mode
----------

In normal use, whether Ved or non-Ved mode, Eden interacts with the
user, prompting for the number of cycles to run next. This would make it
tedious to run a bug which needs to run through several hundred or even
thousand worlds. By giving the "batch" option, you can specify that
Eden is to run lives until bugdead finally returns "stop", without
any prompting or display of the world. In batch mode, Eden prints three
lines to the standard output for each life, like this:
    Starting life 1.
    Life 1.
    Result from bugdead: rerun.


Sections
--------

On exit, 'eden' resets the current section to 'pop_section': see
the implementation notes.


Resuming Eden:
==============

PUBLIC resume_eden():

This resumes Eden from where it was last exited, using the current world
and bug.


Exiting Eden:
=============

PUBLIC exit_eden():

Exits cleanly from Eden. You should not use this during the competition.


The senses:
===========

PUBLIC retina():

Returns Bug's retina, as a 2-D array with origin (1,1). Subscript this
thus:
    retina()(X,Y)
The result will be a character representing the object seen, ` ` if none.
Bug is in the position (3,2), and does not see himself.


PUBLIC heard_from(id):

The last sentence ``heard'' by Bug from id. [] if none, otherwise a list
of characters.


PUBLIC inventory():

The contents of Bug's inventory. A character representing an object:
` ` if none.


Special output:
===============

PUBLIC bug_using_ved():

True if Ved is being used, i.e. if 'eden' was called without the
"no_ved" option. False otherwise.


PUBLIC bug_message( thing ):

Displays 'thing' as a status message. In Ved mode, this is displayed on
the status line by vedputmessage, otherwise as a line of text terminated
by a newline. 'thing' need not be a string, the routine will convert it
to one.


The view window:
================

The bug_view routine allows you to write output that will get sent to a
separate Ved window. There are also routines for turning view output on
and off.


PUBLIC bug_view expr:

bug_view is a syntax word which must be followed by an expression. This
expression should be a call to an output routine. In Ved mode, before
calling the routine, bug_view opens a new Ved window for a buffer called
VIEW, and gives it the bottom half of the screen, leaving the bug in the
top half. bug_view then arranges for the output of this routine to be
sent to the next location in the window. Once bug_view has finished, the
window remains open until the end of the run. Subsequent calls to
bug_view will write their output at the end of the same window.

In non-Ved mode, bug_view proc() is equivalent to proc().

Examples are:
    bug_view pr('Demonstrating my new bug\n');
    bug_view printf('Smell was: %p\n', [% smell() %] );


PUBLIC bug_view_on():
PUBLIC bug_view_off():

The routines bug_view_on() and bug_view_off() turn view on and off. By
default, 'eden' turns it on. If it's turned off, calls to bug_view will
have no effect. This is useful if you want to leave bug_view statements
in, but disable them on some runs.
*/


/*
IMPLEMENTATION
--------------


Name
----

I name this file EDEN so that it has an obvious name. However, I want it
to be separate from the main body of Eden: that's why the latter is
called EDEN_CORE.


Documentation and other dependencies
------------------------------------

The main HELP file for this program is HELP EDEN. Please make sure that
you update it when you change anything in Eden. This applies, amongst
other things, to the specification of routines such as drop(), which are
used by people writing their own objects. It also applies, more
obviously, to the use of eden(), to saving cases, to Ved versus non-Ved
modes, and to the simulator prompts.

A few other HELP files also refer to HELP EDEN, HELP RETINA in
particular. Various modules, particularly WORLDS.P, assume it when
specifying things such as the format of worlds to be read by Ved. AWM.P
assumes in awm_merge_retina that the retina is as in this version of
Eden. This means that changes to Eden may invalidate other HELP files,
and the specification comments in some of the other libraries. Before
making any changes therefore, it's best to read all the HELP files and
library specifications, to gain an overview of what is mentioned where.

EDEN_CORE.PL also assumes this.


The simulator
-------------

The top-level routine is 'eden'. This gets the options and sets some
global variables accordingly, and then calls 'simulate'. If in Ved mode,
it may call 'simulate' to be run inside Ved. 'simulate' is the main
simulation routine: it loads the world and bug, and then calls 'life'
repeatedly to handle each life, using 'bugdead' to indicate whether to
stop.

'life' calls 'cycle' to handle each simulation cycle. These cycles
have the form
    update bug perceptions
    call brain
    update world according to result

The main world-updating routine is ... This calls the
object-writer's own routines, as described in HELP EDEN. It also calls
routines defined lower down here, such as 'drop', once the world is
definitely to be changed.


Sections
--------

I assume that, since most bug-writers will be novices, they won't know
about sections, and so their code will be in the top-level
(pop_section). Hence I've ensured that when a bug's code is loaded, it's
compiled in that section, and that brain procedures are fetched from it.
This is done inside 'simulate'.

Objects are assumed to be written in the same section as this one,
$-eden. This gives easy access to useful routines such as drop() and
fed(), and obviates the need for them to be made public. Object writers
will know more about Pop, and should be able to handle sections, at
least to the extent of treating them as ``magic brackets''.

Users of Prolog Eden will write their bug brains to be in Prolog's
equivalent of pop_section. Eden doesn't call these directly, but via
interface routines defined in EDEN_CORE.PL. These interface routines are
put into section $-eden, and hence 'simulate' fetches them from there.

When 'eden' returns, it switches section back to pop_section. I have found
that if I don't do this, then after calling Prolog eden, it gets set to
$-eden. I don't know why.

It is necessary to change the section to pop_section before calling the
brain (and possibly start_thinking and bugdead). If this isn't done,
then if they use ? or ?? in the matcher, it will assign to variables
in $-eden.


Portability
-----------

The file-handling code in LOAD_FILES.P and ADD_FILE_DEFAULTS.P may need
to be changed.


Programming style
-----------------

I like writing my programs top-down, with the highest-level procedures
first. Unfortunately, this conflicts with Pop's automatic declaration
feature, and causes a fountain of undeclared variable messages, as the
compiler encounters a call to yet another undefined procedure. This is
why several procedures are declared first as
    vars <name>; /*forward*/

See also the file STYLE for programming style.
*/


needs worlds;
needs utils;
needs fault;
needs vedreadlinechars;
needs stow;
needs draw_lines;
needs chars_to_items;
needs load_file;
needs smatch;
needs edit_world;
needs edit_view;


vars tracing_eden;
false -> tracing_eden;
/*  True if internals of simulation are to be traced.  */

vars world;
/*  The current world.  */

vars last_action;
/*  The bug's last action.  */

vars time;
/*  The time in the current life.  */

vars bug_ids;
/*  The numbers of the current bugs.  */

vars mode;
/*  Whether to run in slow, fast, or batch modes.  */

vars save_cases;
/*  true if cases to be saved.  */

vars what_to_save;
/* only defined if save_cases. A list specifying which perceptions to
save. */

vars where_to_save;
/* only defined if save_cases. A filename specifying where to save to.
*/

vars language;
/* which language the bug is in. Currently deals with "pop" and
"prolog". */

vars save_stream;
/*  Defined if save_cases. The consumer for saved cases.  */

vars view_opened;
/*  Whether the view file has been opened in the current run.  */

vars no_view;
/*  True iff view command is to be ignored.  */

vars use_ved;
/*  Whether Eden is to be run from inside Ved or not.  */


/*
Top-level procedure.
--------------------

The main procedure for starting Eden is eden. This is designed to be
called directly from Pop-11, or encapsulated in Prolog.
*/


vars set_default_parameters, eden_;/*forward*/


define eden();
    lvars bugs, world_file;

    true -> use_ved;
    false -> save_cases;
    "pop" -> language;
    "slow" -> mode;

    set_default_parameters();
    /*  Takes any options off the stack, and sets globals accordingly.
    */

    if stacklength() >= 2 then
        if ().dup.isstring or ().dup.isword or ().dup.islist then
            () -> world_file;
            () -> bugs;
        endif
    else
        "same_world" -> world_file;
        "same_bugs" -> bugs;
    endif;
    /*  Takes the filenames, if present.  */

    eden_( bugs, world_file, false );

    pop_section -> current_section;
enddefine;


define resume_eden();
    eden_( "same_bugs", "same_world", true );
    pop_section -> current_section;
enddefine;


define global exit_eden();
    if tracing_eden then pr('Calling exit_eden()\n') endif;
    exitfrom(simulate);
enddefine;


/*  set_default_parameters:
        Reads all the options from the stack, and assigns them
        to the global variables. Everything else is left on the stack.
*/
define set_default_parameters();
    lvars top;
    vars what, where;
    if stacklength() >= 1 then
        () -> top;
        switchon top
            case = "no_ved" then
                false -> use_ved;
                set_default_parameters();
            case = "ved" then
                true -> use_ved;
                set_default_parameters();
            case = "batch" then
                false -> use_ved;
                "batch" -> mode;
                set_default_parameters();
            case matches [ save ? ^ !where ?? ^ !what ] then
                true -> save_cases;
                what -> what_to_save;
                where >< '' -> where_to_save;
                set_default_parameters();
            case = "prolog" then
                "prolog" -> language;
                set_default_parameters();
            else
                top;
        endswitchon
    endif;
enddefine;


vars simulate, load_world, call_in_section;/*forward*/


/*  eden_( bug_file, world_file, restart ):
        This is called by 'eden' once it has taken off the options.

        world_file will be either "same_world" or a filename.
        restart will be either true if starting Eden from scratch, or
        false if resuming an old run.

        The global variables denoting options will be set as follows:
        use_ved: true or false.
        mode: "slow" or "batch".
        language: "pop" or "prolog".
        save_cases: true or false.
        where_to_save: only defined if save_cases. Is the filename in
        the save-option.
        what_to_save: only defined if save_cases. Is the list of
        procedures occurring in the save-option after the filename.

*/
define eden_( bug_spec, world_file, restart );
    lvars bug_spec, world_file, restart;

    /*  Load world.  */
    unless world_file = "same_world" or restart then
        load_world( world_file );
    endunless;

    /*  Load bugs.  */
    unless bug_spec = "same_bugs" or bug_spec = "same_bug" then
        bw_set_retina_size( world, 5, 7, 3, 2 );
        load_bugs( bug_spec );
    endunless;

    /*  Set consumer for saved cases.  */
    if save_cases then
        stow_to( where_to_save ) -> save_stream;
    endif;

    /*  By default, viewing is on.  */
    false -> no_view;

    /*  Run Eden.  */
    if use_ved then
        vedscreenlength -> vedstartwindow;
        false -> vedautowrite;
        false -> view_opened;
        vedobey( 'bug', simulate );
    else
        simulate();
    endif;

    /*  Close save-file.  */
    if save_cases then
        save_stream( termin );
    endif;
enddefine;


/*
Loading bugs
------------
*/


vars _bug_procs;
/*  Will be set by a call of define_bug.  */


define load_bugs( bug_spec );
    lvars bug_spec;
    lvars is_file, i, bug;

    /*  1) If it's a single file-name, convert to a word.  */
    false -> is_file;
    if language="pop" and bug_spec.isstring then
        consword(bug_spec) -> bug_spec;
        true -> is_file;
    elseif language="prolog" and bug_spec.is_character_list then
        character_list_to_word(bug_spec) -> bug_spec;
        true -> is_file
    endif;

    /*  2) If it's a single file-name, load that file, otherwise
           treat as a procedure or list of procedures.
    */
    if is_file then
        [] -> _bug_procs;
        load_bug_code( bug_spec );
        /*  May affect _bug_procs via define_bug.  */
        if _bug_procs = [] then
            if language="pop" then
                [% call_in_section(pop_section,valof(%bug_spec%)) %]
            elseif language="prolog" then
                [% bug_spec %]
            endif -> _bug_procs
        endif;
    else
        if not(islist(bug_spec)) then
            [%bug_spec%]
        else
            bug_spec
        endif -> _bug_procs;
    endif;

    [%
        for i to length(_bug_procs) do
            if not(_bug_procs(i).isundef) then
                bw_new_bug( world, i, make_procedure(_bug_procs(i)) );
                bw_initialise_bug( world, "east" );
                i
            endif;
        endfor;
    %] -> bug_ids;

enddefine;


define is_character_list(l);
    lvars l;
    lvars c;
    if not(islist(l)) then
        return(false)
    else
        for c in l do
            if not(isinteger(c)) then return(false) endif;
        endfor;
    endif;
    true
enddefine;


define character_list_to_word(l);
    lvars l;
    consword( explode(l), length(l) );
enddefine;


define make_procedure(proc);
    lvars proc;
    if language="pop" then
        proc
    elseif language="prolog" then
        call_in_section(%pop_section,prolog_invoke(%proc%)%)
    endif;
enddefine;


/*  load_bug_code( bug_file ):
        bug_file is a word or string. Compile it.
*/
define load_bug_code( bug_file );
    lvars bug_file;

    /*  1) Get the full filename. Using 'identfn' as an argument
        causes it to be returned as load_file's result.
    */
    if language = "pop" then
        load_file( bug_file, '.p', identfn, [ ^current_directory ]<>popuseslist ) -> bug_file; .erase;
    elseif language = "prolog" then
        load_file( bug_file, '.pl', identfn, [ ^current_directory ]<>prologliblist ) -> bug_file; .erase;
    endif;

    /*  2) Error if file not found.  */
    if bug_file = false then
        mishap( 'load_bug_code: bug file not found', [%bug_file%] );
    endif;

    /*  3) Compile the full filename, in pop_section.  */
    if language = "pop" then
        call_in_section( pop_section, compile(%bug_file%) );
    elseif language = "prolog" then
        call_in_section( pop_section, prolog_compile(%bug_file%) );
    endif;
enddefine;


define global define_bug(id,proc);
    lvars id, proc;
    if id > length(_bug_procs) then
        expand( _bug_procs, id ) -> _bug_procs;
    endif;
    proc -> _bug_procs(id);
enddefine;


/*
Eden.
-----
*/


vars save_case, reset_world, replace_world,
     life,
     retina, sentence, inventory;/*forward*/


/*  simulate():
        This is the main simulator procedure, called by eden_.

        On entry, the following global variables will be set:
        world: the current world.

        save_stream: the consumer along which cases are saved. This is
        not used directly. Instead, if cases are to be saved, a new
        ``brain'' is built which thinks as before, but also writes its
        perceptions and actions along this consumer.

        view_opened: false.

        Various Ved variables.

        The bug file will have been compiled in pop_section,
        hopefully defining 'bugdead', 'start_thinking' and
        'think'.

        The world file will have been loaded into 'world',
        and its objects-file will have been compiled in section
        $-eden (i.e. this one).

*/
define simulate();
    lvars disposition, i, proc, no_of_lives;
    vars worldfile;

    setpop -> interrupt;

    /*  Open bug window and clear any rubbish left in the file.  */
    if use_ved then
        vedselect( 'bug' );
        ved_clear();
    endif;

    /*  If saving cases, then build a new procedure which saves
        the results of the procs specified in the save option.
        We do this by building a new procedure which
        is the composition of all these procs, together with
        something which returns the action.
    */
    if save_cases then
        if language = "prolog" then
            [% retina, sentence, inventory %] -> what_to_save;
        endif;
        what_to_save(1) -> proc;
        for i from 2 to length(what_to_save) do
            proc <> what_to_save(i) -> proc;
        endfor;
        procedure(p);
            lvars p;
            p() -> last_action;
            save_case( proc<>identfn(%last_action%) );
            last_action
        endprocedure(% brain %) -> brain;
    endif;

    /*  Reset world.  */
    reset_world();

    /*  Run lives repeatedly. 'disposition' is the result returned
        by bugdead.
    */
    0 -> no_of_lives;
    until (
            1 + no_of_lives -> no_of_lives;
            life( no_of_lives ) -> disposition;
            if disposition = "stop" then
                true
            elseif disposition = "rerun" then
                reset_world();
                true
            elseif disposition matches [ rerun ? ^ !worldfile ] then
                replace_world( worldfile><'' );
                reset_world();
                true
            else
                FAULT( 'simulate: illegal disposition', [%disposition%] );
            endif
          ) do
    enduntil;

    if tracing_eden then pr('About to return from simulate\n') endif;
enddefine;


/*
Individual lives and cycles.
----------------------------
*/


vars initialise_display, say, bug_message, cycle,
     show_info, show_world, ask_number_of_cycles;/*forward*/

vars display_updated;
/* This is declared later, and its use here is messy.  */

vars bugs_all_dead;
/*  Set false at the start of a life.  */


/*  life( number ):
        This procedure runs one life, and is called from simulate().
        number is the number of the current life, starting from
        1, and is used only for display.
*/
define life( number );
    lvars number;
    lvars cycles_left;

    0 -> time;
    /*  Ensure that time is defined before the first display, in
        case the user wants to display it.
    */

    if mode = "batch" do
        printf( 'Starting life %p.\n', [%number%] )
    else
        initialise_display();
        show_info();
        show_world();
    endif;

    /*  Ensure that in batch mode, Eden never stops and gives the
        continue prompt.
    */
    if mode = "batch" then
        1000000
    else
        0
    endif -> cycles_left;

    false -> bugs_all_dead;
    until bugs_all_dead do
        /*  Set heard and said sentences to null on each cycle.  */
        bw_clear_sentences( world );

        /*  This 'if' should always do nothing in batch mode.  */
        if cycles_left = 0 then
            if mode = "fast" then
                show_info();
                false -> display_updated;
                /*  This forces show_world to display the new world-state.
                    So after a sequence of fast actions has finished, we
                    see the latest state of the world.
                */
                show_world();
            endif;
            ask_number_of_cycles() -> cycles_left;
            if mode = "fast" then
                bug_message( 'Entering fast mode' );
            endif;
            /*  NB. This may cause an exit from 'simulate' if
                the user so requests. It also deals with
                sentence-reading.
            */
        endif;

        if tracing_eden then pr('About to call cycle\n') endif;
        cycle();
        if tracing_eden then pr('Returned from cycle\n') endif;

        cycles_left - 1 -> cycles_left;
        if mode = "slow" then
            show_info();
            show_world();
        elseif mode = "fast" then
            bug_message( 'Fast mode: time = '><time );
        endif;
        /*  Do nothing in batch mode.  */
    enduntil;

    if mode = "batch" then
        printf( 'Ending life %p, time = %p.\n', [% number, time %] );
    endif;

    "rerun";
    /*  Have eliminated bugdead, for the moment.  */
enddefine;


/*  cycle():
        Runs one cycle of Eden, drawing on the screen as
        it does so.
*/
define cycle();
    lvars bug_id;
    true -> bugs_all_dead;
    if tracing_eden then printf('bug_ids %p\n', [%bug_ids%]) endif;
    for bug_id in bug_ids do
    if tracing_eden then printf('selecting bug_id %p\n', [%bug_id%]) endif;
        bw_select_bug(world,bug_id);
        if tracing_eden then printf('bug_is_dead %p\n', [%bw_bug_is_dead(world)%]) endif;
        if not(bw_bug_is_dead(world)) then
            bw_update_vision(world);
            if tracing_eden then pr('About to call bw_resume_bug\n') endif;
            bw_resume_bug(world) -> last_action;
            if tracing_eden then pr('Returned from bw_resume_bug with last_action=%p\n',[%last_action%] ) endif;
            if not(bw_bug_is_dead(world)) then
                false -> bugs_all_dead;
            endif;
            if tracing_eden then printf('Tested bugs dead %p, and about to call bw_act\n',[%bugs_all_dead%]) endif;
            bw_act(world,last_action);
            if tracing_eden then pr('Returned from bw_act\n') endif;
            if tracing_eden then pr('About to call my_update\n') endif;
            /*  Call object-writer's update routine.  */
            if word_identifier( "my_update", main_section("objects"), true ) /= false then
                from_section(main_section("objects"),"my_update")()
            endif;
            if tracing_eden then pr('Returned from my_update\n') endif;
        endif;
    endfor;
    1 + time -> time;
enddefine;


vars ask_continue;/*forward*/


/*  ask_number_of_cycles():
        Gives the continue prompt, reads and checks the reply.
        If the user types l, reads the sentence; if he types p,
        reads and obeys the Pop-11 code.
*/
define ask_number_of_cycles();
    lvars reply;
    vars what, rest, cycles;

    while ( ask_continue() ->> reply ) matches [ ? ^ !what ?? ^ !rest ] and
          ( what="l" or what="p" or what="r" or
            what="e" or what="v" or what="+" or what="-" ) do
        if what = "l" then
            bw_user_say( world, world.bw_current_bug, rest(1) );
        elseif what="p" then
            call_in_section( pop_section, popval(%chars_to_items(rest(1))%) );
        elseif what="r" then
            if use_ved then vedrefresh(); endif;
        elseif what="e" then
            if use_ved then edit_world(); endif;
        elseif what="v" then
            if use_ved then edit_view(); endif;
        elseif what="+" then
            bug_view_on()
        elseif what="-" then
            bug_view_off()
        endif;
    endwhile;

    if reply = [n] then
        bug_message( 'Exiting Eden' );
        exit_eden();
    elseif reply = [y] then
        "slow" -> mode;
        1;
    elseif reply matches [ f ? ^ !cycles ] then
        "fast" -> mode;
        cycles;
    elseif reply matches [ s ? ^ !cycles ] then
        "slow" -> mode;
        cycles;
    else
        FAULT( 'ask_number_of_cycles: bad reply', [% reply %] );
    endif;
enddefine;


/*
Updating the world and display.
-------------------------------

In the current implementation, the world- and bug-drawing routines
update the display immediately, if using Ved and in slow mode.
Everything else waits for show_world or show_info.
*/


vars display_updated;


/*  initialise_display():
*/
define initialise_display();
    false -> display_updated;

    if use_ved then
        ved_clear();
        vedsetscreen('');
    endif;
enddefine;


vars draw_bug;/*forward*/


/*  move_bug_to( old_xW, old_yW ):
        This is called after the bug has been moved.
        Display the contents of that location
        before and after the move, if using Ved and slow.
*/
define move_bug_to( old_xW, old_yW );
    lvars xW, yW;

    if mode="slow" and use_ved then
        draw( old_xW, old_yW, world(old_xW,old_yW), "check" );
        draw_bug();
        true -> display_updated;
    endif;
enddefine;


/*  place_object_at( char, xW, yW ):
        Place char at xW,yW. Display the contents of that location,
        if using Ved and in slow mode.
*/
define place_object_at( char, xW, yW );
    lvars char, xW, yW;
    lvars i;
    if mode="slow" and use_ved then
        if bw_bug_xW(world) = xW and bw_bug_yW(world) = yW and char /= ` ` then
            for i to 4 do
                draw( xW, yW, char, "check" );
                vedscreenflush();
                wait( 0.5 );
                draw_bug();
                unless i = 4 then vedscreenflush(); wait(0.5) endunless;
            endfor
        else
            draw( xW, yW, char, "nocheck" );
        endif;
        true -> display_updated;
    endif;
enddefine;


/*
Display.
--------

This section assumes things about the screen layout. Horizontally, all
output starts at column 1 and carries on as far as possible: there are
no marginal annotations or other effects.

Vertically, the bug window is divided as follows:
    First two lines : the bug status information.
    Third line      : what the bug last heard.
    Fourth line     : what the bug last said.
    Fifth line      : blank.
    Sixth line      : top line of world.
*/


constant info_line_1 = 1;
constant info_line_2 = 2;
constant heard_line  = 3;
constant said_line   = 4;
constant world_line_1= 5;


vars redraw_display;/*forward*/


define show_world();
    unless use_ved and display_updated then
        redraw_display();
    endunless;
    true -> display_updated;
enddefine;


define redraw_display();
    lvars i, j, char;

    if not( use_ved ) then nl(1) endif;

    for j from bw_world_height(world)-1 by -1 to 0 do
        for i from 0 to bw_world_width(world)-1 do
            if i=bw_bug_xW(world) and j=bw_bug_yW(world) then
                bug_symbol()
            else
                world( i, j )
            endif -> char;
            if use_ved then
                draw( i, j, char, "nocheck" )
            else
                cucharout( char )
            endif;
        endfor;
    if not( use_ved ) then nl(1) endif;
    endfor;

    if not( use_ved ) then nl(1) endif;

    if use_ved then draw_bug() endif;
    ;;; The bug has already been displayed, but this will ensure that
    ;;; it is in view, since draw_bug does so.
enddefine;


vars reply;/*forward*/


define show_info();
    lvars p1, p2, p3, p4;
    lvars bug_xW = world.bw_bug_xW, bug_yW = world.bw_bug_yW;

    if use_ved then
        vedformat_print(% info_line_1 %) -> p1;
        vedformat_print(% info_line_2 %) -> p2;
    else
        format_print ->> p1 -> p2;
    endif;

    if word_identifier( "my_line1", main_section("objects"), true ) /= false then
        p1( from_section(main_section("objects"),"my_line1")() )
    else
        p1( 'Action: ~8A    Facing: ~8A Position: ~8A',
            [% last_action,
               bw_direction(world),
               '('><bug_xW><','><bug_yW><')',
             %]
          );
    endif;

    if not(use_ved) then
        nl(1);
    endif;

    if word_identifier( "my_line2", main_section("objects"), true ) /= false then
        p2( from_section(main_section("objects"),"my_line2")() )
    else
        p2(
            'Inventory: ~8A Here: ~8A Time: ~8A',
            [% bw_object_name(world,inventory()),
               bw_object_name(world,world(bug_xW,bug_yW)),
               time
            %]
          );
    endif;

    if not(use_ved) then
        nl(1);
    endif;

    if use_ved then
        vedformat_print(% heard_line %) -> p3;
        vedformat_print(% said_line %) -> p4;
    else
        format_print ->> p3 -> p4;
    endif;

    p3( '~{~C~}', [%bw_heard_from(world,"user")%] );

    if not(use_ved) then
        nl(1);
    endif;

    p4( '~{~A ~}', [%bw_heard_by_user_from(world,bw_current_bug(world))%] );

    if not(use_ved) then
        nl(1);
    endif;

enddefine;


/*  draw_bug():
        Display the bug, and ensure it's in view.

        Precondition: use_ved.
*/
define draw_bug();
    draw( bw_bug_xW(world), bw_bug_yW(world), bug_symbol(), "check" );
    ;;;  The "check" argument ensures the bug is in view.
enddefine;


/*  draw( xW, yW, char, check ):
        Update the VED display with char, placing it in the
        position appropriate to world co-ordinates (xW,yW).
        If check = "check", then ensure that this position
        is in the visible window.

        Precondition: use_ved.
*/
define draw( xW, yW, char, check );
    lvars xW, yW, char, check, xVED, yVED;
    world_coords_to_ved_coords( xW, yW ) -> yVED -> xVED;
    vedjumpto( yVED, xVED );
    char -> vedcurrentchar();
    if check = "check" then vedcheck() endif;
enddefine;


define world_coords_to_ved_coords( xW, yW ) -> yVED -> xVED;
    lvars xW, yW;
    lvars xVED, yVED;
    xW+1 -> xVED;
    (world_line_1-1) + bw_world_height(world)-yW -> yVED;
enddefine;


define ved_coords_to_world_coords( xVED, yVED ) -> yW -> xW;
    lvars xVED, yVED;
    lvars xW, yW;
    xVED-1 -> xW;
    bw_world_height(world) + (world_line_1-1) - yVED -> yW;
enddefine;


define bug_symbol();
    `B` + bw_current_bug(world)-1
enddefine;


/*
Bug's perceptions.
------------------

The routines in this section access Bug's perceptions. They can all be
called by authors of bugs, and are all exported.
*/


define global inventory();
    world.bw_inventory;
enddefine;


define retina();
    world.bw_retina;
enddefine;


define heard_from( from_id );
    lvars from_id;
    bw_heard_from( world, from_id );
enddefine;


define say( to_id, sentence );
    lvars to_id, sentence;
    bw_say( world, to_id, sentence );
enddefine;


/*
Loading worlds
--------------
*/


/*  reset_world():
        Sets up the world. Call this before every new life.
*/
define reset_world();
    "none" -> last_action;
    /*  Call object-writer's start routine.  */
    if word_identifier( "my_start1", main_section("objects"), true ) /= false then
        from_section(main_section("objects"),"my_start1")()
    endif;
    world.bw_reset;
    if word_identifier( "my_start2", main_section("objects"), true ) /= false then
        from_section(main_section("objects"),"my_start2")()
    endif
enddefine;


/*  replace_world( world_file ):
        Sets up a replacement world, by loading it. Must be followed
        by a call to reset_world.
*/
define replace_world( world_file );
    lvars world_file;
    load_world( world_file );
enddefine;


/*  load_world( world_file ):
        Loads a new world. Must be followed by a call to reset_world.
        Keeps the bugs from the current world, if they exist.
*/
define load_world( world_file );
    lvars world_file;
    lvars objects_file, new_world;

    load_file( world_file, '.w', identfn, [ ^current_directory ]<>popuseslist ) -> world_file;
    if world_file = false then
        mishap( 'load_world: world file not found', [%world_file%] )
    else
        erase()
    endif;
    worldfile_to_world( world_file ) -> new_world;

    bw_objects_file( new_world ) -> objects_file;
    load_file( objects_file, '.p', identfn, [ ^current_directory ]<>popuseslist ) -> objects_file; .erase;
    if objects_file = false then
        mishap( 'load_world: objects file not found', [%objects_file%] );
    endif;

    call_in_section( section_subsect( "objects", pop_section, false ),
                     compile(%objects_file%)
                   );

    bw_set_display_routines( new_world, move_bug_to, place_object_at );

    /*  Dirty - should provide access routines.  */
    if not(world.isundef) then
        world.$-worlds$-world_bugs -> new_world.$-worlds$-world_bugs;
        world.$-worlds$-world_max_bugs -> new_world.$-worlds$-world_max_bugs;
    endif;
    new_world -> world;
enddefine;


/*
Saving cases.
-------------
*/


/*  save_case( proc );
        Save a list made from proc's result(s), in the case file.
*/
define save_case( proc );
    lvars proc;
    save_stream( [% proc() %] );
enddefine;


/*
User interface.
---------------
*/


define global bug_using_ved();
    use_ved
enddefine;


define global bug_message( message );
    lvars message;

    if not( message.isstring ) then
        message >< '' -> message;
    endif;

    if use_ved then
        vedputmessage( bw_current_bug(world)><' '><message )
    else
        pr( bw_current_bug(world)><' '><message ); 1.nl;
    endif;
enddefine;


vars read_sentence;/*forward*/
vars read_item;/*forward*/


/*  ask_continue():
        Outputs the Eden ``continue'' prompt, and reads and checks
        replies.
        Result is one of
            [ y ]
            [ n ]
            [ r ]
            [ e ]
            [ v ]
            [ + ]
            [ - ]
            [ f ^integer ]
            [ s ^integer ]
            [ l ^chars ]
            [ p ^chars ]
*/
define ask_continue();
    lvars reply, number, c;

    if use_ved then
        bug_message( 'Continue? y/n/s(low) <cycles>/f(ast) <cycles>/l(isten)/p(op)/r(efresh)/e(edit)' );
    else
        bug_message( 'Continue? y/n/s(low) <cycles>/f(ast) <cycles>/l(isten)/p(op)' );
    endif;

    read_item().uppertolower -> reply;
    if reply="s" or reply="f" then
        read_item() -> number;
        if not( number.isinteger ) then
            bug_message( 'Number expected after f or s');
            signal_error();
            ask_continue();
        else
            [% reply, number %]
        endif;
    elseif reply="y" or reply="n" or reply="+" or reply="-" then
        [% reply %]
    elseif (reply="r" or reply="e" or reply="v") and use_ved then
        [% reply %]
    elseif reply="l" or reply="p" then
        [% reply, read_sentence(reply) %]
    else
        bug_message( 'Bad reply' );
        signal_error();
        ask_continue()
    endif;
enddefine;


/*  read_char():
        Reads one character, in Ved and non-Ved modes.
        In Ved mode, the character is read immediately, and
        not echoed. In non-Ved mode, it will be echoed, and will
        not come in until the next RETURN.
*/
define read_char();
    lvars c;
    if use_ved then
        rawcharin() -> c;
        c
    else
        charin();
    endif;
enddefine;


vars rawitemin;
incharitem( rawcharin )-> rawitemin;
/*  Used by read_item().    */


/*  read_item():
        Reads one item, in Ved and non-Ved modes.
        In Ved mode, the item is read immediately, and
        not echoed. In non-Ved mode, it will be echoed, and will
        not come in until the next RETURN.
*/
define read_item();
    if use_ved then
        rawitemin()
    else
        itemread()
    endif;
enddefine;


/*  read_sentence(what):
        Reads a sentence for Bug to ``listen'' to. In Ved mode, it
        allows the sentence to be edited. The sentence is returned
        as a list of characters.

        This routine is also used to read a line of Pop for Bug to obey.
        Whether it's a sentence or code is indicated by the -what-
        argument: "l" or "p".
*/
define read_sentence(what);
    lvars what;
    lvars c, old_vedstatic;

    if use_ved then
        true -> vedstatic;
        vedstatic -> old_vedstatic;
        vedjumpto( heard_line, 1 );
        if what = "l" then
            vedreadlinechars( 'Type sentence: finish with RETURN or ENTER', '?' );
        else
            vedreadlinechars( 'Type Pop-11 statements: finish with RETURN or ENTER', ':' );
        endif;
        old_vedstatic -> vedstatic;
    else
        if what = "l" then
            pr( 'Type sentence on next line: finish with RETURN\n' );
        else
            pr( 'Type Pop-11 statements on next line: finish with RETURN\n' );
        endif;
        [% while (
               read_char() -> c;
               if c = `\n` then
                   false
               else
                   c; true
               endif )
           do;
           endwhile
        %]
    endif;

enddefine;


/*  signal_error():
        Signal an error by bell, if possible, in both Ved and non-Ved
        modes.
*/
define signal_error();
    if use_ved then
        vedscreenbell()
    endif;
enddefine;


/*
Viewing thoughts
----------------

A (Ved-)window onto the brain.
*/


define syntax bug_view();
    sysxcomp();
    sysCALL( word_identifier( "to_view",
                              section_subsect( "eden", pop_section, false ),
                              true
                            )
           );
enddefine;


define bug_view_on();
    false -> no_view;
enddefine;


define bug_view_off();
    true -> no_view;
enddefine;


define to_view( Writer );
    lvars Writer;
    lvars c;

    if no_view then return endif;

    if use_ved then
        cucharout -> c;
        vedcharinsert -> cucharout;

        if not( view_opened ) then
            12 -> vedstartwindow;
            vedselect( 'view' );
            ved_clear();
            true -> view_opened;
        else
            vedselect( 'view' )
        endif;

        pr( bw_current_bug(world)><' ' ); Writer();

        c -> cucharout;

        vedselect( 'bug' );
    else
        pr( bw_current_bug(world)><' ' ); Writer();
    endif;

enddefine;


/*
Sections
--------

These routines deal with access to things in the code of bugs.
*/


/*  from_section( sect, name ):
        Returns the value of variable name in sect. Used for
        accessing the brain procedures. We can't use $-<id> which
        would be easier: it seems the identifier has to be already
        defined when you write that, which these won't be.
*/
define from_section( sect, id );
    lvars sect, id;
    lvars wi;
    word_identifier( id, sect, true ) -> wi;
    if wi = false then
        FAULT( 'from_section: identifier not found', [%sect,id%] )
    else
        wi.valof;
    endif;
enddefine;


/*  main_section(id):
        Returns that subsection of pop_section whose name is id.
        Why doesn't bloody Poplog have a decent notation for denoting
        section names, rather than having to use this section_subsect
        procedure?
*/
define main_section( id );
    lvars id;
    section_subsect( id, pop_section, false );
enddefine;


/*  call_in_section( sect, proc ):
*/
define call_in_section( sect, proc );
    vars sect, proc;
    sect -> current_section;
    proc();
    main_section("eden") -> current_section;
enddefine;

endsection;


section $-objects;
endsection;
bug_symbol(), "check" );
    ;;;  The "check" argument ensures the bug is in view.
enddefine;


/*  draw( xW, yW, char, check ):
        Update the VED display with char, placing it in the
        position appropriate to world co-ordinates (xW,yW).
        If check = "check", then ensure that this position
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                 eden_core.pl                                                                                        100705  017064  000205  00000030762 05427665537 007660  0                                                                                                     47426                                                                                    1  0                                                                                                                                                                 /*  EDEN_CORE.PL  */


:- module eden.

:- public
    eden/0,
    eden/1,
    eden/2,
    eden/3,
    eden/4,
    resume_eden/0,
    exit_eden/0,
    retina/3,
    inventory/1,
    heard_from/2,
    say/2,
    exec/1,
    (bug_message)/1,
    bug_using_ved/0,
    (bug_view)/1,
    bug_view_on/0,
    bug_view_off/0.


/*
SPECIFICATION
-------------

This is the main module defining Eden for Prolog. It has to be loaded by
EDEN.PL. For details of Eden itself, see HELP EDEN. The specifications
given below assume you have read that.


Running Eden:
=============

PUBLIC eden( <arguments> ):

'eden' starts Eden running, putting a bug into a world and setting it
off. The arguments are
    eden( <bug-file>, <world-file>, <options> )
    eden( <options>  )
up to a limit of four arguments. <options> stands for any number
(including none), upto the argument limit, of the following arguments,
in any order:
    noved
    batch
    [ save, <save-file> ]

<bug-file> and <world-file> must be atoms, denoting files. The bug-file
must be a file of Prolog code, and its extension defaults to .PL. The
world-file contains a saved world, as saved by the Ved 'saveworld'
command, and its extension defaults to .W.

If a file is specified without a directory, Eden looks first in the
current directory. If it can't find the file there, it then searches the
library files, as defined by 'prologliblist'. See HELP LIBRARY for more
details. This assumes Eden and the standard worlds and bugs will have
been set up as libraries, which I hope will be true on most systems.

The noved and batch options are atoms. The save option is a list whose
first element should be the atom 'save' and whose second element should
be a filename.

Example calls of eden are:
    eden( noved ).
    eden( 'MYBUG', tw1, [ save, mycases ] ).
    eden( manual_bug, 'MyWorld',
          [ save, 'CASES' ], batch ).


How to avoid repeating filenames
--------------------------------

If the world and bug you want to run are exactly the same as last time,
you can omit them. You can still specify the other options to 'eden', for
instance:
    eden.
    eden( noved );
    eden( [ save, 'CASES' ], batch ).


Saving cases
------------

By using the save option, you can direct that perceptions and actions
are to be stored in a file. You can then read this back later, and use
it (for example) for training a neural net.

In the present version of of Prolog Eden, you only have one option,
    [ save, <file> ]
where <file> is a filename, as an atom. This saves the perceptions to
<file> in the order
    retina sentence inventory

You will need to enter Pop-11 to read them back, and you should use LIB
STOW to do this. For further details, see HELP EDEN.


Running without Ved
-------------------

To run outside Ved, give the 'noved' option to eden(). Eden will run,
displaying the world and status information for each cycle in teletype
mode, as a sequence of lines. The prompts are the same, but you won't be
able to edit sentences passed to the listener. Examples are:
    eden( noved ).
    eden( talk_bug, tw3, noved ).


Batch mode
----------

In normal use, whether Ved or non-Ved mode, Eden interacts with the
user, prompting for the number of cycles to run next. This would make it
tedious to run a bug which needs to run through several hundred or even
thousand worlds. By giving the batch option, you can specify that
Eden is to run lives until bugdead finally returns 'stop', without
any prompting or display of the world. In batch mode, Eden prints three
lines to the standard output for each life, like this:
    Starting life 1.
    EndedLife 1 494.               
    Result from bugdead: rerun.


Resuming Eden:
==============

PUBLIC resume_eden:

This resumes Eden from where it was last exited, using the current world
and bug.


Exiting Eden:
=============

PUBLIC exit_eden/0:

Exits cleanly from Eden. You should not use this during the competition.


The senses:
===========

PUBLIC retina( X?, Y?, Obj? ):

If X and Y are instantiated, unifies Obj with the atom representing the
object at location (X,Y) in Bug's retina. If there is no object, the
atom returned is ' '.

If X or Y or both are uninstantiated, scans the entire retina, returning
each value of X and Y for which Obj unifies. If Obj is a variable,
this will successively return all the objects seen.


PUBLIC sentence( S? ):

Unifies S with the last sentence ``heard'' by Bug. [] if none, otherwise
a list of characters.


PUBLIC inventory( I? ):

Unifies I with the contents of Bug's inventory. This is an atom
representing an object: ' ' if none.


Special output:
===============

PUBLIC bug_using_ved:

Succeeds if Ved is being used, i.e. if 'eden' was called without the
'noved' option. Fails otherwise.


PUBLIC bug_message Goal+:

bug_message is used to write to the Ved status line. It is a unary
operator of precedence 250, which takes a goal as argument. In Ved mode,
it calls its argument, which should produce some output. Rather than
displaying this immediately, it collects the output in a string, and
then displays that string on the status line.

In non-Ved mode, it just calls its argument, and then writes a newline.               

An example is:
    bug_message output( Meaning )

This calls the goal output(Meaning), and displays the output it would
send on the status line (in Ved mode). In non-Ved mode, it just calls
output(Meaning).      


The view window:
================

The bug_view predicate allows you to write output that will get sent to a
separate Ved window. There are also predicates for turning view output on
and off.


PUBLIC bug_view Goal+:

bug_view is a prefix operator of precedence 250, whose argument should
be a goal which generates some output. In Ved mode, before obeying the
goal, bug_view opens a new Ved window for a buffer called VIEW, and
gives it the bottom half of the screen, leaving the bug in the top half.
bug_view then arranges for the output from the goal to be sent to the
next location in the window. Once bug_view has finished, the window
remains open until the end of the run. Subsequent calls to bug_view will
write their output at the end of the same window.

In non-Ved mode, bug_view Goal is equivalent to Goal.

Examples are:
    bug_view write('Demonstrating my new bug\n')
    bug_view ( smell(S), write(S), nl )


PUBLIC bug_view_on:
PUBLIC bug_view_off:

The predicates bug_view_on and bug_view_off turn view on and off. By
default, 'eden' turns it on. If it's turned off, calls to bug_view will
have no effect. This is useful if you want to leave bug_view statements
in, but disable them on some runs.
*/


/*
IMPLEMENTATION
--------------

See notes in EDEN_CORE.P, and also below. Note that the encapsulation
of retina/3 assumes that the retina is 5 by 7.
*/


:- library(chars_to_items).
/*  Load this so the user can access it without needing to load
    it.
*/


/*
The top-level predicate: eden
----------------------------

These predicates just pass their arguments to the Pop-11 'eden', together
with the special option "prolog". This enables Eden to adapt itself to
the needs of Prolog, e.g. in calling predicates to interface the brain.
*/


eden :-
    prolog_eval( eden(prolog) ).


eden( Arg ) :-
    prolog_eval( eden( quote(Arg), prolog ) ).


eden( Arg1, Arg2 ) :-
    prolog_eval( eden( quote(Arg1), Arg2, prolog ) ).


eden( Arg1, Arg2, Arg3 ) :-
    prolog_eval( eden( quote(Arg1), Arg2, Arg3, prolog ) ).


eden( Arg1, Arg2, Arg3, Arg4 ) :-
    prolog_eval( eden( quote(Arg1), Arg2, Arg3, Arg4, prolog ) ).


resume_eden :-
    prolog_eval( apply(valof(resume_eden)) ).


exit_eden :-
    prolog_eval( apply(valof(exit_eden)) ).


/*
Interface to perceptions
------------------------

We can call some of the Pop-11 perceptual routines directly. Others have
to be encapsulated, via interface routines defined below.
*/


retina( X, Y, NO ) :-
    ( var(X) ; var(Y) ),
    nonvar(NO),
    NO = nearest(Obj),
    retina_nearest( X, Y ),
    prolog_eval( consword( apply(X,Y,apply(valof(retina))),1), Obj ),
    !.

retina( X, Y, Obj ) :-
    nonvar(X), nonvar(Y),
    !,
    prolog_eval( consword( apply(X,Y,apply(valof(retina))),1), Obj ).

retina( X, Y, Obj ) :-
    retina_xbounds( X, XLow, XHigh ),
    retina_ybounds( Y, YLow, YHigh ),
    retina_sweep( X, XLow, XHigh, Y, YLow, YHigh, Obj ).


retina_xbounds( X, X, X ) :-
    nonvar(X),
    !.

retina_xbounds( _, 1, 5 ).


retina_ybounds( Y, Y, Y ) :-
    nonvar(Y),
    !.

retina_ybounds( _, 1, 7 ).


retina_sweep( X, XLow, XHigh, Y, YLow, YHigh, Obj ) :-
    retina_between( X, XLow, XHigh ),
    retina_between( Y, YLow, YHigh ),
    prolog_eval( consword( apply(X,Y,apply(valof(retina))),1), Obj ).


retina_between( _, Low, High ) :-
    Low > High,
    !, fail.

retina_between( Low, Low, _ ).

retina_between( X, Low, High ) :-
    Next is Low + 1,
    retina_between( X, Next, High ).


retina_nearest(3,2).
retina_nearest(3,3).
retina_nearest(4,2).
retina_nearest(3,4).
retina_nearest(2,2).
retina_nearest(5,2).
retina_nearest(3,5).
retina_nearest(3,1).
retina_nearest(2,3).
retina_nearest(1,2).
retina_nearest(4,3).
retina_nearest(4,1).
retina_nearest(3,6).
retina_nearest(2,4).
retina_nearest(5,3).
retina_nearest(5,1).
retina_nearest(4,4).
retina_nearest(3,7).
retina_nearest(2,5).
retina_nearest(2,1).
retina_nearest(4,5).
retina_nearest(2,6).
retina_nearest(1,3).
retina_nearest(1,1).
retina_nearest(4,6).
retina_nearest(2,7).
retina_nearest(1,4).
retina_nearest(5,4).
retina_nearest(4,7).
retina_nearest(1,5).
retina_nearest(5,5).
retina_nearest(1,6).
retina_nearest(5,6).
retina_nearest(1,7).
retina_nearest(5,7).


inventory( I ) :-
    prolog_eval( consword(apply(valof(inventory)),1), I ).


heard_from( Id, S ) :-
    prolog_eval( heard_from(Id), S ).


say( Id, S ) :-
    prolog_eval( say(Id,prolog_full_deref(quote(S))) ).


exec( A ) :-
    prolog_eval( exec(A) ).


/*
bug_message and bug_using_ved
-----------------------------

bug_message Goal passes Goal to the interface routine to_message,
defined below. This switches cucharout so that all characters output are
dumped into a string, which is then passed to the Pop-11 bug_messsage.
We use prolog_invoke to call Goal: see next section.   
*/


:- op( 250, fx, bug_message ).


bug_message( Goal ) :-
    prolog_eval(
                apply(
                      quote(Goal),
                      valof(word_identifier(to_message_PL,
                                            section_subsect(eden,valof(pop_section),false),
                                            true
                                           )
                           )
                     )
               ).


:- prolog_language(pop11).

section $-eden;

define to_message_PL( goal );                  
    lvars goal;
    vars cucharout;
    procedure (c); lvars c; c endprocedure -> cucharout;
    cons_with consstring {% prolog_invoke(goal).erase %}.bug_message
enddefine;

endsection;

:- prolog_language(prolog).


bug_using_ved :-
    prolog_evaltrue( apply(valof(bug_using_ved)) ).


/*
Viewing thoughts
----------------

bug_view Goal passes the constructed routine
    prolog_invoke(Goal)<>erase
to the Pop-11 routine to_view, which underlies the Pop-11 bug_view.
The constructed routine invokes Prolog on Goal, and then erases the
result which will indicate success or failure. See HELP POPTOPLOG.
*/


:- op( 250, fx, bug_view ).


bug_view( Goal ) :-
    prolog_eval(
                apply(
                      quote(Goal),
                      valof(word_identifier(view_PL,
                                            section_subsect(eden,valof(pop_section),false),
                                            true
                                           )
                           )
                     )
               ).


bug_view_on :-
    prolog_eval( apply(valof(bug_view_on)) ).


bug_view_off :-
    prolog_eval( apply(valof(bug_view_off)) ).


:- prolog_language(pop11).

section $-eden;

define view_PL( Goal );
    $-eden$-to_view( prolog_invoke(%Goal%)<>erase )
enddefine;

endsection;

:- prolog_language(prolog).


:- endmodule.
g filenames
--------------------------------

If the world and bug you want to run are exactly the same as last time,
you can omit them. You caedit_view.p                                                                                         100705  017064  000205  00000002100 05427665541 007514  0                                                                                                     47426                                                                                    1  0                                                                                                                                                                 /*  EDIT_VIEW.P  */


section $-eden => edit_view;


;;; make mapping to ved_q "soft", by mapping to word
;;; not procedure.
vedsetkey('\^[q', "ved_q");


define edit_view();

    lvars oldfile = vedcurrent;
    lvars oldvedline, oldvedcolumn;

    define vars ved_x();
        vedjumpto( oldvedline, oldvedcolumn );
        vededitor(identfn, oldfile);

        ;;; then exit from ved_get_and_edit
        exitfrom(edit_view)
    enddefine;

    define vars ved_q();
        vedjumpto( oldvedline, oldvedcolumn );
        vededitor(identfn, oldfile);

        ;;; then exit from ved_get_and_edit
        exitfrom(edit_view)
    enddefine;

    ;;; make the specified file current, after saving the oldfile
    edit('VIEW');

    ;;; save position so can restore writing position on exit.
    vedline -> oldvedline;
    vedcolumn -> oldvedcolumn;

    ;;; Invoke a replica of VED's top level loop, to be left when
    ;;; ved_q or ved_x is invoked
    runproc(0, consproc(0,vedscreenraw<>vedprocess));
enddefine;


endsection;
this:
    Starting life 1.
    EndedLife 1 494.               
    Result from bugdead: rerun.


Resuming Eden:
==============

PUBLIC resume_eden:

This resumes Eden from where it was last exited, using the current world
and bug.


Exiting Eden:
=============

PUBLIC exit_eden/0:

Exits cleanly from Eden. You should not use this during the competition.


The senses:
===========

PUBLIC retina( X?, Y?, Obj? ):

If X and Y are instantiated, unifies Obj with the atom representing the
object at location (X,edit_world.p                                                                                        100705  017064  000205  00000003036 05427665541 007702  0                                                                                                     47426                                                                                    1  0                                                                                                                                                                 /*  EDIT_WORLD.P  */                     


section $-eden => edit_world;


;;; make mapping to ved_q "soft", by mapping to word
;;; not procedure.
vedsetkey('\^[q', "ved_q");


define edit_world();

    lvars oldfile = vedcurrent;

    define vars ved_x();
        vededitor(identfn, oldfile);

        ;;; read back world
        get_world();

        ;;; then exit from ved_get_and_edit
        exitfrom(edit_world)
    enddefine;

    define vars ved_q();
        vededitor(identfn, oldfile);

        ;;; then exit from ved_get_and_edit
        exitfrom(edit_world)
    enddefine;

    ;;; Set local static mode.
    vars vedstatic = true;

    ;;; make the specified file current, after saving the oldfile
    edit('BUG');

    ;;; Invoke a replica of VED's top level loop, to be left when
    ;;; ved_q or ved_x is invoked
    runproc(0, consproc(0,vedscreenraw<>vedprocess));
enddefine;


define get_world();
    lvars xW, yW, xVED, yVED, new_obj, old_obj, id;

    for yW from bw_world_height(world)-1 by -1 to 0 do
        for xW from 0 to bw_world_width(world)-1 do
            world_coords_to_ved_coords( xW, yW ) -> yVED -> xVED;
            vedjumpto( yVED, xVED );
            vedcurrentchar() -> new_obj;
            world( xW, yW ) -> old_obj;

            bw_new_object( world, new_obj ) -> id;
            if new_obj /= `B` then
                bw_place_object( world, id, [%xW,yW%] );   
            endif;

        endfor;
    endfor;
enddefine;


endsection;
 of the run. Subsequent calls to bug_view will
write theditor.tex                                                                                          100705  017064  000205  00000017520 05427665540 007377  0                                                                                                     47426                                                                                    1  0                                                                                                                                                                 \documentstyle[a4,epsf,alltt]{article}
\begin{document}


\include{commands}


\title{Introduction to the editor}
\author{Jocelyn Paine}
\maketitle


\section{The Ved editor}

In the handout on {\it How to run Eden}, I showed you how to use the
control commands like \verb/y/, \verb/r/ and \verb/s/. I also mentioned
that there is an \verb/e/ command for ``editing'' the world --- that is,
for changing it as Eden runs.

In general, an editor is a program for creating and modifying files.
Word-processors on PCs and other microcomputers are editors, though they
have a lot of specialised text-handling facilities that aren't found in
other editors. You will need an editor not only for modifying the
worlds, but --- more importantly --- for writing your own brains, so
this is the next thing to learn. Each computer system comes with its own
editor. Although basic concepts such as cursor movements don't
vary between editors, the details of what commands to give do.
We shall be using the {\it Ved} editor, written by Sussex University and
built into this version of Prolog. Even if you know how to use
WordPerfect or some other word-processor, you won't be able to use the
same commands with Ved. However, some of the ideas will be similar.

As with the Eden handout, the best thing to do is to read these notes
once without trying anything, and then go through again, this time
working all the examples.


\subsection{Starting Ved from Prolog}

First, start up Eden Prolog if necessary. Remember that the command,
from VMS, is just \verb/eden/. You should then get a \verb/?-/ prompt.

Next, type
\begin{verbatim}
teach vedprpc
\end{verbatim}
Note: this is an unusual command, because you {\it don't} need to end it
with a dot. For reasons best known to Poplog's implementors, this is
true of all the commands for starting editing from Prolog. However, you
do need the RETURN after it.

Once you have done this, you will see the first part of a file displayed
on the screen, which gives you instructions on how to continue. Work
through it carefully, and ask if you have any trouble. Note these
important points before starting. Firstly, the file assumes you are
working from CTC. If not, the keys it describes won't work. Ask me for
help. Secondly, it refers in several places to the \verb/prolog/
command, used to start Prolog from VMS. We are using a different
command, \verb/eden/, because we want the Eden simulator to be loaded
into Prolog. So wherever it says \verb/prolog/, type \verb/eden/.


\subsection{Another TEACH file}

In Poplog jargon, these instructional files that the editor displays are
called {\it TEACH files} (or sometimes {\it HELP files}). There is
another TEACH file which continues where \verb/vedprpc/ left off. This
is \verb/vedprpc2/. Once you are happy with the stuff in the previous
section, get into Prolog, and then type
\begin{verbatim}
teach vedprpc2
\end{verbatim}
Follow the instructions as before. Once again, where it talks about the
\verb/prolog/ command, use the \verb/eden/ command instead.

At the end of this file, you'll be told that you can go on to
\verb/ved3/. Whether you do so is up to you. It contains some useful
stuff such as how to search for particular strings, and if you're happy
with Ved so far, by all means learn these extra commands. However, you
can get by without them, so you may prefer to leave them for the moment.               


\subsection{Editing the world}

You now know enough to try out the Eden control command \verb/e/. Get
into Eden Prolog, and start a new life:
\begin{verbatim}
eps( psbug2, psworld2 ).
\end{verbatim}

Then run it for 12 cycles, until the bug has put the coin in the slot
machine, causing a piece of food to appear. You can do this in various
ways. The quickest is to give the control command \verb/-/ and RETURN,
to turn off the view window; and then \verb/s/, space, \verb/200/
and RETURN, to run forward 12 cycles. But if you wanted, you could
single-step until the food appears, by repeatedly pressing \verb/y/ and
RETURN.

When the food appears, type \verb/e/ and RETURN. The cursor will then
move to somewhere within the world. Move it until it is over the
\verb/+/ symbol, to the left of the \verb/S/. Then type a space. This
will overwrite the \verb/+/. Then move the cursor over the \verb/S/, and
type a \verb/+/. You have now replaced the slot-machine with a piece of
food. Can the bug cope?

To end the edit, do ENTER \verb/x/, as described in the TEACH file. This
preserves the changes in the world and goes back to Eden. Now
single-step through with \verb/y/ and watch the bug. 

If, while editing, you decide you don't want to change the world, quit
the edit with ESC q. Again, this was described in the TEACH file.

Note: the behaviour of the world-editor is slightly different from that
you are now used to. When you type a character, it {\it overwrites} the
character beneath it, rather than pushing the rest of the line to the
right. This is called {\it static} mode. I use it in the world-editor
because it's convenient there. However, it's less useful in updating
text files, which is why I haven't mentioned it before or implemented
it elsewhere.

You can try making other changes to the world. Most of the time, the bug
will not be able to cope --- not surprising, given the simplicity of
its rules.


\subsection{Editing the view window}

This, done with the \verb/v/ command, is mainly useful if a lot of
diagnostic output is produced, and flies past so quickly that you want
to go back and look at it again. It's also handy for making a printed
copy.

To demonstrate \verb/v/, get into Prolog and start a new life. This
time, do not use the \verb/-/ command: you will need some view output to
experiment with! Then run the bug for a few cycles, say 10.

When it stops, type \verb/v/ and then hit RETURN. The cursor will move
into the view window, just after the last piece of output. You can then
move it up and down to bring any part of the window into sight, using
any of the edit commands you already know. You can expand the window to
cover the whole screen by hiting ESC \verb/w/, as described in
\verb/vedprpc/. Note that it's also possible to change the window by
typing into it. I don't advise this though, since it will scramble
future view output for the same life.

When you have finished, end the edit with ENTER \verb/x/ or ESC
\verb/q/. The cursor will then jump back to its old position, and Eden
will be ready for the next control command. You can then run the bug
from where you left off.

To print the window, give the command ENTER \verb/ctcprint/ RETURN while
you are editing it. The output so far will be printed on the CTC
printer. You can also use the other printing commands described in
\verb/vedprpc2/ to print on the other printers.


\subsection{Looking at bug brains}

The text of the standard bug brains I've written is stored as library
files. You can run them in Eden, but because they're not held in your
directory, you need a special Ved command to look at them. This is the
\verb/showlib/ command. You use it like \verb/teach/ and \verb/ved/, by
typing it in response to the \verb/?-/ prompt. Thus,
\begin{verbatim}
showlib psbug1
\end{verbatim}
will show you the rules used in the production-system bug \verb/psbug1/.
Try that now. As with \verb/ved/ and \verb/teach/, you don't need a dot
after the filename. When you've finished, return to Prolog with ESC
\verb/q/.

You should remember that the section on {\it Other TEACH files} in
\verb/vedprpc/ showed you how to temporarily transfer to another TEACH
file, with the command
\begin{verbatim}
ENTER teach window RETURN
\end{verbatim}
as an example. You can do the same with \verb/showlib/, using it from
the Ved command line. Try that now.


\end{document}
      100705  017064  000205  00000003036 05427665541 007702  0                                                                                                     47426                                                                                    1  0                                                                                                                                                                 editor2.tex                                                                                         100705  017064  000205  00000037766 05427665540 007477  0                                                                                                     47426                                                                                    1  0                                                                                                                                                                 \documentstyle[a4,epsf,alltt]{article}
\begin{document}


\include{commands}


\title{Editing your own programs}
\author{Jocelyn Paine}
\maketitle


This handout shows you how to construct your own production system
programs. I assume that you've already read the notes on {\it
Introduction to the editor} and {\it Production systems}.


\section{Adapting one of my programs}   

The easiest way to start is by modifying a program that already exists.
This is useful if you just want to take one of my examples and alter its
resolution strategy or initial STM. Let's start by modifying the rules
in \verb/psbug2/. This is the bug that picks up coins and uses them to
get food out of a slot machine.

First, you need to tell the editor to copy the program into your own
{\it directory} or working area. Although the editor lets you examine my
programs via the \verb/showlib/ command, it won't let you change the
master copies. Get into Prolog, and give the editing command
\begin{verbatim}
showlib psbug2
\end{verbatim}
Because this is an editing command, you don't need a dot after it.
The editor will then display the code for \verb/psbug2/ on the screen.
You have done this already, in the production systems handout.

Next, you must tell the editor to copy this code into one of your own
files. Do this by giving the command
\begin{verbatim}
ENTER name mybug.pl RETURN
\end{verbatim}
This will create a file named \verb/MYBUG.PL/, and copy \verb/psbug2/
into it.

Finally, make whatever changes you want. Then exit the edit by doing
\begin{verbatim}
ENTER x RETURN
\end{verbatim}
This will save the file and return you to Prolog.

You can then run the new program by typing
\begin{verbatim}
eps( mybug, psworld2 ).
\end{verbatim}

Four notes on filenames. Firstly, program files must always end in
\verb/.pl/, an abbreviation for ``Prolog''. This suffix is called the
{\it file extension} or (less commonly) {\it file type}. If you omit it
or get it wrong, then various parts of the system will fail to find the
file, and your program will appear to have gone missing, or to be
unrunnable. Filenames can be in upper or lower case, but to save you
having to change case, use lower.

Secondly, when you use the \verb/eps/ command, the name of your bug
should be the same as the name of the filename, but without the
extension.

Thirdly, every time you do ENTER \verb/x/ RETURN, the editor saves a new
copy of your file. This is laid over the old copy, making it appear to
be inaccessible. However, it is actually still there. If you make a
mistake, and need to recover an old copy, I can do so for you.

Fourthly, do not give your files the same name as my examples. If you
do, you won't be able to get at the examples any more, because the
editor will choose your file in preference to mine.              


\section{Starting from scratch}   

If you want to start from scratch, then begin by using the \verb/ved/
command from Prolog. Let's say you wanted to create a brain called
\verb/NEWBUG.PL/. Then you would start by doing
\begin{verbatim}
ved newbug.pl
\end{verbatim}
This creates a new, empty, file.

Then type into it. When you have finished, do
\begin{verbatim}
ENTER x RETURN
\end{verbatim}

You can then use the code via \verb/eps/, in the same way as in the
previous section:
\begin{verbatim}
eps( newbug, psworld2 ).
\end{verbatim}

If you want to copy bits of other files, including ones got via
\verb/showlib/, into your file, there is a way to do so. It involves
marking text and using the ENTER commands \verb/d/ and \verb/yank/
together with ESC \verb/x/. See the \verb/ved3/ TEACH file for details.
You get to this by doing
\begin{verbatim}
teach ved3
\end{verbatim}
from Prolog.

For real experts, there's a shorter method using the \verb/ti/ and
\verb/to/ commands. Ask me for details, or see the \verb/mark/ HELP
file.


\section{Editing an existing file}

You do this in the same way as creating a new file. If your file were
called \verb/MYBUG.PL/, then you'd begin by doing
\begin{verbatim}
ENTER ved mybug.pl RETURN
\end{verbatim}
from Prolog.

Then edit the file and finish with
\begin{verbatim}
ENTER x RETURN
\end{verbatim}

Run it as before:
\begin{verbatim}
eps( mybug, psworld2 ).
\end{verbatim}


\section{Creating your own world}

By now, you might want to try making your own worlds as well as your own
bugs. See my handout on {\it Creating your own worlds} for this.


\section{Reference: syntax of production systems}

This is a short and incomplete summary of what can go into your PS
programs. When resources allow, it may be improved sometime in the
future. Also, I may need to add some more features. If you need help
understanding this, please ask.

A PS program contains the following:
\begin{itemize}

\item A \verb/resolve/ declaration. This is followed by a list containing
some of the letters \verb/p/, \verb/s/, \verb/r/, in some order, separated
by commas. Like all declarations and statements, it ends in a dot. Lists
start and end with square brackets.

Examples:
\begin{verbatim}
resolve [p,s,r].
resolve [s,p].
resolve [].
\end{verbatim}

How does it work? When it matches the rules, the PS may obtain more than
one candidate. If so, it looks at the first letter in the list; the
letters stand for ``priority'', ``specificity'', and ``recency''. Let's
say the first letter is a \verb/p/. Then the PS will sort the rules by
priority. This is a number you can attach with the word \verb/prio/, as
in \verb/psbug3/ --- if it is missing, 0 is assumed. After sorting, the
PS takes all the matched rules with the highest priority, and discards
the others.

Assume the next letter is \verb/s/. The PS then sorts these remaining
rules by complexity of condition, most complex first. At the moment, the
complexity measure is a count of the total number of arguments in the
left-hand side. After sorting, the PS takes the rules with highest
specificity and discards the rest.

Assume the next letter is \verb/r/. This denotes resolution by inverse
rule-firing recency. The PS sorts the remaining rules by order of the
time at which they last fired, never-fired rules counting highest. After
sorting, takes those with the highest score, and discards the rest.

If more than one rule remains, the PS takes one at random.

In \verb/psbug1/ and \verb/psbug2/, the recency resolution method has
been the most important.

\item A \verb/stm/ declaration. This gives the initial contents of STM.
For an example, see \verb/holidays/. Like \verb/resolve/, the thing
following \verb/stm/ is a list, this time of facts to be placed in STM.
Each one will be a predicate with or without arguments: see the handout
on {\it Production Systems (2)}.

Examples:
\begin{verbatim}
[ mp, hot ].
[].
[ loves(john,mary), loves(fred,bert) ].
[ pub(white_horse,broad_street,oxford,halls) ].
\end{verbatim}

\item One of the declarations \verb/stm_predicates/ or
\verb/perceptual_predicates/. For an example, see \verb/holidays/. The
declaration is followed either by the word \verb/all/ or by a list of
predicate names.

\begin{sloppypar}
If the declaration is \verb/stm_predicates/, it means that all the
predicates named (or \verb/all/ of them) are assumed to be in STM; any
others are perceptual. This is the case in \verb/holidays/. If the
declaration is \verb/perceptual_predicates/, it means that all the
predicates named (or \verb/all/ of them) are assumed to be perceptual or
action predicates, such as \verb/can_see/ and \verb/move_towards/. These
don't look at, or change, STM, but access perceptions and actions
directly.
\end{sloppypar}

Examples:
\begin{verbatim}
stm_predicates all.
stm_predicates [ loves, likes ].
perceptual_predicates [ can_see ].
perceptual_predicates all.
\end{verbatim}

If neither declaration is present, \verb/perceptual_predicates all/ is
assumed, as in \verb/psbug1/ and \verb/psbug2/.

\item A set of rules. Each rule has a left-hand side and a right-hand
side, separated by \verb/=>/. Like other statements, rules all end in a
dot. Examples are:                 
\begin{verbatim}
toilet_cleaner => poor, bored.
can_see(w),over(w) => exec([use]).
\end{verbatim}

The left-hand side is a set of {\it goals}, separated by commas. The
goals are predicates with or without arguments, see {\it Production
Systems (2)} for more info. The comma means ``and''. That is, the rule
will match if {\it all} the goals are simultaneously true. That is, if
all the perceptual goals are satisfied by what the bug's perceptions
tell it, and if all the data indicated by the STM goals is in STM.

The right-hand side is a set of actions, separated by commas. Each
action is either an STM goal , or a motor goal. Obeying an
STM goal puts the relevant data into STM; obeying a motor
goal --- well, obeys it.

One special motor goal is \verb/exec/. This takes a primitive
bug-action as argument, where the action is a list. Examples are:
\begin{verbatim}
exec( [forward] )
exec( [right] )
\end{verbatim}

A rule may be preceded by an optional priority, of the form (e.g.)
\verb/1 prio/ or \verb/23 prio/. You can have as many different priority
levels as you want in one program; the default is zero. See the
description above of resolution-by-priority for how priorities are used.
Example of a rule with priority:
\begin{verbatim}
1 prio thirst(T),T>20,can_see(w) => move_towards(w).
\end{verbatim}

\end{itemize}


\subsection{How rule conditions are tested}

The left-hand side of a rule are made up from a series of goals. Each
goal is a predicate, with or without arguments.

The left-hand side is taken to be true (aka ``matches'', or ``is
satisfied'', or ``succeeds'') if all the predicates are true. Only rules
with true left-hand sides are passed on to the resolution stage.

Argumentless goals are just names, such as \verb/mp/. An
argumentless perceptual goal is true if the perceptual condition it
denotes is currently true. (At the moment, I have no such
predicates.)

An argumentless STM goal is true if the same symbol --- its name
--- appears in the current STM. Thus the STM goal \verb/mp/ is
true if the symbol \verb/mp/ is in the current STM.

Goals with arguments consist of a predicate name, immediately followed
by an open bracket, a sequence of arguments separated by commas, and a
close bracket.

Each argument can be:
\begin{itemize}

\item A constant. This is either a number, such as \verb/1/ or
\verb/-4.982/, or a name, such as \verb/w/ or \verb/bug/. Names stand
for particular ``things'': individuals, properties, classes, etc. 

Most names contain only lower-case letters:
\begin{verbatim}
fred
bug_237
pizza2go
\end{verbatim}
Such a name must start with a lower-case letter, and this can be
followed by any number of lower-case letters, digits, or underlines.

If you want a name to contain upper-case letters, it must be surrounded
by single quotes, \verb/'/. This is why, in the slot-machine-using bugs,
the \verb/'S'/ is in quotes. Do not leave the quotes off a name like
\verb/'S'/. If you do, it will be treated as a variable, which means
something quite different. The only time you will need to use such names
is when they are used as Eden objects.

Lower-case names can be quoted, but need not: \verb/w/ and \verb/'w'/
mean the same thing.

Names can also be a special non-alphabetic symbol or sequence of
symbols, such as \verb/+/. Some such symbols have to be quoted, but the
ones I shall use all don't. As with upper-case letters, the
only time you need to use such names is when they are used as Eden
objects.

\item A variable. Variables are either the special underline symbol,
\verb/_/, or start with a capital letter, such as \verb/Someone/ or
\verb/T/. This is the main use of capitals in Prolog.

\end{itemize}

How do predicates with arguments work in goals?

Let's deal with predicates having all constant arguments first.
A perceptual predicate with constant arguments is true if the
corresponding perceptual condition is satisfied. Thus \verb/can_see(w)/
is true only if the bug can currently see water.

An STM predicate with constant arguments is true if exactly the same
group of symbols (the same ``fact'') appears in STM. Thus the STM
predicate \verb/loves(john,mary)/ would be true only if the fact
\verb/loves(john,mary)/ appeared in the current STM. Note that it would
{\it not} be satisfied by any of
\begin{verbatim}
loves(mary,john)
loves(john)
loves
loves(john,mary,today)
\end{verbatim}

Now for predicates with variables. These stand for any constant in what
should be an obvious way. Thus, the perceptual predicate
\verb/can_see(X)/ is true if the bug can see anything at all. In fact,
this condition is always true, since the bug can always see at least a
space!

STM predicates with variable arguments are true if there is a fact with
the same predicate name and number of arguments in STM, and if any
constant arguments match. Thus, the STM predicate \verb/loves(X,mary)/
is true if any of the follwing are in STM:
\begin{verbatim}
loves( john, mary )
loves( bert, mary )
loves( 33.4, mary )
\end{verbatim}

If the same variable occurs twice in a predicate, then it must denote
the same constant. Thus \verb/loves(X,X)/ is satisfied by
\begin{verbatim}
loves(john,john)
\end{verbatim}
and
\begin{verbatim}
loves(mary,mary)
\end{verbatim}


\subsection{``And'' and variables}

A left-hand side is true if all its goals are. When saying this, all the
variables must be interpreted consistently. Thus we might have the
left-hand side
\begin{verbatim}
can_see(X), want(X)
\end{verbatim}
where \verb/want(X)/ is an STM goal. This would be true if the bug wants
food and can see food, or if it wants water and can see water, etc. It
would not be true if the bug wanted only water but could see only food.

There is one special exception to this. If two \verb/_/ variables appear
in the same left-hand side, they need not stand for the same object. So
\begin{verbatim}
can_see(_), want(_)
\end{verbatim}
could be true if the bug wanted only water but could see only food.

Similarly, \verb/loves(_,_)/ could be true if the STM contains only the
fact \verb/loves(john,mary)/.


\subsection{Numerical conditions}

There are a few special conditions, written using the symbols
\begin{verbatim}
>   <
>=  =<
=   \=
\end{verbatim}
These are used in comparisons.

The symbols \verb/</ and \verb/>/ have their usual mathematical meaning.
The symbols \verb/=</ and \verb/>=/ mean ``less than or equal'' and
``greater than or equal''. They can only be used when comparing numbers.
In general, one --- possibly both --- of the numbers will be in a
variable taken from an earlier goal in the same rule. Thus,
\begin{verbatim}
thirst(T), T > 20
\end{verbatim}
For examples, see
\begin{verbatim}
eps( skier, psworld0 ).
\end{verbatim}

The symbols \verb/=/ and \verb/\=/ can compare numbers or names. The
second means ``not equal''.


\subsection{Negation}

Any goal can be enclosed by a \verb/not(...)/. This inverts its truth.
Thus
\begin{verbatim}
not(holding(+))
\end{verbatim}
is true if
\begin{verbatim}
holding(+)
\end{verbatim}
is false, i.e. when the bug is holding something other than food.


\subsection{How rule right-hand sides are obeyed}

A right-hand side can consist of STM goals and motor goals, separated by
commas. These goals are obeyed strictly from left to right.

Obeying an STM goal puts the symbols into STM.

Obeying a motor goal causes the bug to perform (or more accurately, to
try performing) the corresponding action.

One special motor goal is \verb/exec/. As already described, this obeys
a single action.

There is a special STM goal, \verb/erase/. This removes its argument
from STM. Thus the rule
\begin{verbatim}
over(w) => exec([use]), erase( i_need(water) ).
\end{verbatim}
would erase the fact \verb/i_need(water)/ from STM.

\end{document}
he matched rules with the highest priority, and discards
the others.

Assume the next letter isexec.p                                                                                              100705  017064  000205  00000004670 05427665542 006500  0                                                                                                     47426                                                                                    1  0                                                                                                                                                                 /*  EXEC.P  */


/*
SPECIFICATION
-------------

This module provides facilities for writing ``brains'' for Eden that, as
far as they are concerned, run continuously, rather than starting afresh
on each call to 'think'. In effect, it provides a simple form of
coroutine. Experienced Poplog programmers will see that it is a very
simple interface to LIB PROCESS (see HELP PROCESS): I have written it so
that novices can write co-routine style brains without having to know
anything more about LIB PROCESS.


You can make a procedure into a process by calling
    proc_to_process( proc ) -> co;

You can then start running it by calling
    restart_process( co );

Eventually, proc should call
    exec( a )
where a is an action. This will get passed back as the result of
'restart_process'. 'proc' will stop running, and return control to just after
this call of 'restart_process'. To start 'proc' from where it left off, call
'restart_process' again.


PUBLIC proc_to_process( proc ):

Converts proc into a process, returned as the result.


PUBLIC restart_process( co ):

Runs 'co' until it calls exec(action). 'action' is then returned as the
result of 'restart_process', and 'co' suspends itself, as described
above. 'co' can either be a process which has not been run before, or
one which has, and is suspended.


PUBLIC exec( action ):

Called from inside 'proc' to suspend and return an action.


Example:

    vars co;

    define start_thinking();
        proc_to_process( brain ) -> co;
    enddefine;

    define think();
        restart_process( co );
    enddefine;

    define brain();
        repeat
            if smell() = "here" then
                exec( "grab");
                exec( "use" )
            else
                exec( smell() )
            endif;
        endrepeat;
    enddefine;

    define bugdead();
        start_thinking();
        "rerun";
    enddefine;

This bug can be found in EXEC_BUG.P.        
*/


/*
IMPLEMENTATION
--------------

This relies on the process feature. See REF PROCESSES.

This library has a HELP file, HELP EXEC. Keep it in step with the code.
*/


define exec( action );
    lvars action;
    suspend( action, 1 );
enddefine;


define restart_process( co );
    lvars co;
    runproc( 0, co );
enddefine;


define proc_to_process( proc );
    lvars proc;
    consproc( 0, proc );
enddefine;
ta indicated by the STM goals is in STM.

The right-hand side is a set of actions, separated by commas. Each
action is either an STM goal , or a motor goal. Obeying an
STM goal puts the relevant data intofault.p                                                                                             100705  017064  000205  00000002512 05427665543 006661  0                                                                                                     47426                                                                                    1  0                                                                                                                                                                 /*  FAULT.P  */


section $-fault => FAULT;


/*
SPECIFICATION
-------------

This module exports 'FAULT'. I call this to report "shouldn't happen"
errors, such as 'else' statements that should never be reached. I have
named the routine 'FAULT' to distinguish it from things to do with the
Eden Bug.


PUBLIC FAULT( Message ):

Displays Message (which can be any text), and returns to the Pop
top-level. If FAULT has a second argument, this is printed after the
message. In the current version, FAULT in fact calls 'mishap' (see HELP
MISHAP).
*/


/*
IMPLEMENTATION
--------------

Some slightly messy code to decide which stack elements to put where,
depending on the stack length. Is there a cleaner way to do this?

There is a HELP file for this, HELP FAULT. Keep it in step with the
code.
*/


define global FAULT();
    lvars message, culprits;

    () -> culprits;
    /*  Assume there's more than one argument, so the top one
        is culprits.
    */

    if stacklength() = 0 then
        /*  But if there wasn't, the top one was the message.  */
        culprits -> message;
        [] -> culprits;
    else
        () -> message;
        /*  Otherwise the message is still on the stack.  */
    endif;

    mishap( message><'', culprits )
enddefine;


endsection;
s, etc. 

Most names contain only lower-case letters:
\begin{verbatim}
fred
bug_237
pizza2go
\end{verbatim}
Such a name must start with a lower-case letter, and this can be
followed by any number of lower-case letters, digits, or underlines.

If you want a nafiles.p                                                                                             100705  017064  000205  00000002252 05427677563 006656  0                                                                                                     47426                                                                                    1  0                                                                                                                                                                 ;;;  FILES.P
 
/*  These are the Pop-11 parts of FILES.PL. See its implementation
    section for an explanation.
*/
 
 
define exists_file( Directory, File, Extension );
    lvars Directory, File, Extension;
    lvars Repeater, FullName;
    sys_file_match( File><'', Directory><'*'><Extension, false, false) ->
      Repeater;
    if (Repeater() ->> FullName) = termin then
        0
    elseif FullName = false then
        'BUG: exists_file'.pr; 1.nl;
    else
        FullName.consword
    endif;
enddefine;
 
 
define add_file_defaults( Directory, Name, Extension );
    lvars Directory, Name, Extension;
    lvars Parts;          
    sysfileparse( Name ) -> Parts;
    (Parts(1) ><
     Parts(2) ><
     if Parts(3) = '' then Directory else Parts(3) endif ><
     Parts(4) ><
     if Parts(5) = '' then Extension else Parts(5) endif ><
     Parts(6)
    ).consword
enddefine;
 
 
define print_file( Name, Printer, Delete );
    lvars Name, Printer, Delete;
    if Delete = "nodelete" then '/DELETE' else '' endif -> Delete;                   
    sysobey( '$ PRINT ' >< Name >< '/QUEUE=' >< Printer >< Delete );
enddefine;
}

Now for predicates with variables. These stand for any constant in what
should be an obvious way. Thus, the perceptual predicate
\verb/can_see(X)/ is true if the bug can see anything at all. In fact,
this condition is always true, since the bug can always see at least a
space!

STM predicates with variable arguments are true if there is a fact with
the same predicate name and number of arguments in files.pl                                                                                            100705  017064  000205  00000043262 05427677451 007034  0                                                                                                     47426                                                                                    1  0                                                                                                                                                                 /*  FILES.PL  */
 
 
:- module files.
 
 
:- public open_input/2,
          open_output/2,
          open_and_reconsult/2,
          exists_file/2, exists_file/1,
          find_file/4, find_file/5,
          add_file_defaults/2,
          print_file/2, print_and_delete_file/2.
 
 
/*
SPECIFICATION
-------------
 
This module exports file-handling predicates.
 
Briefly, open_input and open_output try opening files for input or
output, but instead of crashing if an error (such as illegal filename)
occurs, they return an atom saying what the error was. This makes it
possible to trap and recover from errors.
 
open_and_reconsult acts the same way, but reconsults the file if it's
readable.
 
exists_file checks whether a file exists and returns its full name.
 
find_file acts as a wildcarded search, looking for a file amongst a
range of directories or extensions.
 
add_file_defaults generates a full file name from a partial name plus
defaults.
 
print_file prints a file to a specified printer. print_and_delete_file
does the same but deletes it afterwards.
 
You must consult BUG.PL before using this module.
 
 
PUBLIC open_input( FileName+, Status? ):
----------------------------------------
 
"Status indicates the result of trying to open FileName for input and
redirecting the CIS to it".
 
Try opening the file named FileName for input. FileName should be an
atom. If it opens, unify Status with 'ok', and make the file the CIS.
Otherwise leave the CIS as it is and unify Status with one of the atoms
    {file_not_found, directory_not_found,
     access_forbidden, invalid_filename}. An error which isn't one of
these may have undefined effects (such as causing an 'abort').
 
 
PUBLIC open_and_reconsult( FileName+, Status? ):
------------------------------------------------
 
"Status indicates the result of trying to open and reconsult FileName".
 
FileName should be as for open_input. Try opening FileName for input. If
it opens, unify Status with 'ok' and reconsult the file. Otherwise unify
Status with one of the same error atoms as for open_input, and don't
consult the file. The same caution about unexpected errors holds.
 
This predicate does not change the CIS.
 
 
PUBLIC open_output( FileName+, Status? ):
-----------------------------------------
 
"Status indicates the  result of trying to open FileName  for output and
redirect the COS to it".
 
Try opening the file for output. If it opens, unify Status with 'ok',
and make the file the COS. Otherwise leave the COS as it is and unify
Status with one of the atoms
    {no_space_for_file, directory_not_found, access_forbidden,
     invalid_filename}.
This predicate works in the same  way as open_read, and the same caution
about unexpected errors applies.
 
 
PUBLIC exists_file( FileName+, FullName? ):
-------------------------------------------
 
"The file named FileName exists, and its full name is FullName".
 
FileName can be either an atom, or a structure of the form
    Name+defaults(Directory,Extension)
where Name, Directory, and Extension are atoms.
 
This predicate checks to see whether the file exists. If so, FullName is
unified with an atom which is the full name (complete with disc,
directory, extension, and version number on my system, VAX/VMS). If not,
the predicate fails.
 
If FileName is a +structure, its second argument is assumed to contain
defaults for the directory name and file extension. If the name doesn't
contain a component, and the default value given is not '', exists_file
adds the default before testing for existence.
 
Examples:
 
    exists_file( 'fred.pl', F )
        -  fail if no FRED.PL exists in the current directory.
        -  else set F to (e.g.) 'fs12:[me]fred.pl;12'.
 
    exists_file( 'fred'+defaults('[me]','.pl')
        -  if [ME]FRED.PL exists, set F to the full name as above.
 
    exists_file( 'fred.lsp'+defaults('[me]','.pl')
        -  if [ME]FRED.LSP exists, set F to the full name.
 
    exists_file( '[you]fred.lsp'+defaults('[me]','.pl')
        - if [YOU]FRED.LSP exists, set F to the full name.
 
Note: As exists_file is implemented here, it deems a file to be found
even if it can't be read. So finding a file is no guarantee that it can
be read (the file might, for example, have read access denied).
 
 
PUBLIC exists_file( File+ ):
----------------------------
 
"The file named File exists".
 
As for exists_file/2, ignoring the second argument.
 
 
PUBLIC find_file( File+, DefaultList+, FullName?, Status? ):
------------------------------------------------------------
 
"Status indicates whether there exists a file whose name is File plus
one of the defaults in DefaultList. Its full name is FullName."
 
File is an atom, naming a file. DefaultList is a list of structures,
each of the form
    defaults(Directory,Extension)
as for exists_file/2.
 
The idea is that DefaultList specifies a number of directory/extension
defaults under which to search for File. This list must not be empty.
 
These defaults work in the same way as for exists_file. find_file tries
each in turn, until either it runs out of defaults, or it finds the
file. If it does find the file, it unifies FullName with the full name
(as for exists_file) and Status with 'ok'. Otherwise it leaves FullName
uninstantiated and unifies Status with the atom file_not_found.
 
Note that (like exists_file), find_file may say that a file exists even
if it can't be read.
 
Examples:
 
    find_file( fred,
               [defaults('','.pl'),defaults('','.lsp')],
               F, Status )
        - if FRED.PL exists in the current directory, sets
          F to (e.g.) 'fs12:[me]fred.pl;12'.
        - if FRED.PL doesn't exist, but FRED.LSP does, sets F
          to (e.g.) 'fs12:[me]fred.lsp;5'.
        - else sets Status to file_not_found.
 
    find_file( 'fred.lib',
               [defaults('',''),defaults('[here]',''),
                defaults('[there]','')],
               F, Status )
        - searches the current directory, [HERE], and [THERE]
          in that order for FRED.LIB.
 
 
PUBLIC find_file( File+, DirectoryList+, Extension+,
                  FullName?, Status? ):
----------------------------------------------------
 
"Status indicates whether there exists, in one of the directories in
DirectoryList, a file whose name is File and whose extension defaults to
Extension. Its full name is FullName."
 
This is a different arrangement of arguments, more convenient for some
purposes; it searches a list of directories for a file with specified
extension. Once again, the list must not be empty.    
 
Arguments File, FullName and Status are as for find_file/4.
DirectoryList is a list of directory names (each of which must be an
atom). Extension is a default extension, also an atom.
 
Example:
 
    find_file( 'fred', [ '', '[MATTHEWS]', '[LATNER]' ], '.PL',
               F, Status )
        - looks for FRED.PL, first in the current
          directory, then in [MATTHEWS], and finally
          in [LATNER]. If found, F becomes a full
          name, otherwise S becomes file_not_found.
 
 
PUBLIC add_file_defaults( FileName+, FullName? ):                     
-------------------------------------------------
 
"FullName is the full name of FileName after adding any defaults
it specifies".
 
FileName can be either an atom, or a structure of the form
    Name+defaults(Directory,Extension)
as for exists_file.
 
If either default is not '', and the file name lacks that component,
then add_file_defaults adds it to make FullName.
 
Examples:
 
    add_file_defaults( fred+defaults('[me]','.pl'), F )
        - sets F to '[me]fred.pl'.
 
    add_file_defaults( 'fred.lsp'+defaults('','.pl'), F )
        - sets F to 'fred.lsp'.
 
    add_file_defaults( fred, F )   or
 
    add_file_defaults( fred+defaults('','') )
        - set F to fred.
 
 
PUBLIC print_file( FileName+, Printer+ ):
-----------------------------------------
 
"FileName has been printed to Printer".
 
Prints the file on the specified printer. FileName must be an atom.
Printer is any atom naming one of the printers
    { USERAREA, PSYZOO, CTC, ... }
defined in HELP PRINTERS at Oxford.
 
Note there is no status returned. Under VMS, it is not possible to
pick one up (even though the file has been queued for printing, the
printer might be off-line, out of paper, etc).
*/
 
 
/*
IMPLEMENTATION
--------------
 
 
Below are notes on my implementation, and suggestions for porting. Of
course, your Prolog implementor may be nice and provide 'print_file',
'exists_file' etc. built-in. In that case, you're lucky...
 
 
1) Safe open routines.
----------------------
 
These rely on being able to trap and recover from errors. If you can't
do this, you won't be able to implement them. The way it's done here is
this: when an error occurs (e.g. trying to see a non-existent file,
trying to call an undefined predicate, trying to do arithmetic on a
variable, trying to square-root a negative number),
Poplog calls the system predicate
    prolog_error( ErrorMessage, Culprits )
with an error-message-atom (which may come in part from VMS) and the
item or items which caused the error (the "culprits").
 
There are initially two clauses for prolog_error. The first is activated
whenever ErrorMessage indicates that an undefined predicate was called.
The second is activated if the first fails (i.e. when the error is
_not_ an undefined predicate). It calls another system predicate which
reports the error and aborts.
 
You can change this action by asserting extra clauses for prolog_error.
Obviously, to be useful, they must be asserta'd, to come before the
clauses I've just mentioned. Part of the code below does this: there is
one clause asserted for trapping errors caused by open_input and
open_and_reconsult; and another for trapping errors caused by
open_output.
 
Consider input first. The clause for prolog_error that deals with input
translates the system message it receives into one of the atoms I use
for the Tutor's error codes. This is done by calling
    input_error( SystemMessage, MyMessage )
It then asserts
    '$open_input_error_was'( MyMessage )
 
So open_input can now be made safe. It calls 'see'. This will either
work normally; or cause an error. In the latter case, the error will
cause a call of prolog_error, which will assert a clause for
'$open_input_error_was'(...). open_input can then test for the presence
of this clause, retract it if it exists, and return the status value.
 
open_output works in the same way. There is one complication. I
sometimes want the same system message to be translated differently for
input and output errors. So I need two different error-handlers. This is
achieved by asserting another clause saying which the calling routine
was: one of
    '$calling_open_input'
    '$calling_open_output'
My clauses for prolog_error can then check this.
 
If your Prolog has error-trap predicates, you may be able to adapt this
mechanism. If not, but you have something akin to '$nofilerrors': i.e.
some way of making 'see' fail if it detects an error, you can use that.
You won't be able to pick up an error code, but you can at least detect
whether 'see' failed, and return status value not_ok or something.
 
 
2) Exists file.
---------------
 
This calls a Pop-11 routine to test for file existence.
 
If you don't have a built-in existence tester, or one reachable from a
foreign language, you may be able to use error traps, if you have them.
To test whether a file exists: try 'see'ing it. If this causes an
error, it probably doesn't exist. It might of course exist but be
unreadable: in that case, you will lose a bit of specificity in
the message (it's possible that the teacher could have copied the scripts
to a library directory, and forgotten to give public access).
 
 
3) Find file.
-------------
 
This just calls exists_file for each possible full name.
 
 
4) Add file defaults.
---------------------
 
This calls a Pop-11 routine for parsing filenames into their components.
If you don't have something like this, you could convert the filename to
a list of characters and use a DCG grammar to parse it.
 
 
5) Print file.
--------------
 
This calls the Pop-11 command issuer. If you don't have one, you might
be able to do something like this:
    print_file( File, Printer ) :-
        seeing( CIS ), telling( COS ),
        see( File ), tell( Printer ),
        repeat,
            (
                get0(C),
                C = /* your end-of-file character */
            ;
                put(C),
                fail
            ),
        seen, told,
        see( CIS ), tell( COS ).
in systems where the printer can be treated as a file.
*/
 
 
:- needs bug.
 
 
:- dynamic '$open_input_error_was'/1,
           '$open_output_error_was'/1,
           '$calling_open_input'/0,
           '$calling_open_output'/0.
 
 
/*  The Pop-11 parts of these predicates live in FILES.P  */
:- pop_compile( 'files.p' ).
 
 
open_input( FileName, StatusOut ) :-
    retractall( '$open_input_error_was'(_) ),
    assert( '$calling_open_input' ),
    seeing( CIS ),
    see( FileName ),
    (
        '$open_input_error_was'(Status)
    ->
        see( CIS ),
        retractall( '$open_input_error_was'(_) )
    ;
        Status = ok
    ),
    retractall( '$calling_open_input' ),
    StatusOut = Status.
 
 
open_and_reconsult( FileName, StatusOut ) :-
    retractall( '$open_input_error_was'(_) ),
    assert( '$calling_open_input' ),
    reconsult( FileName ),
    (
        '$open_input_error_was'(Status)
    ->
        retractall('$open_input_error_was'(_))
    ;
        Status = ok
    ),
    retractall( '$calling_open_input' ),
    StatusOut = Status.
 
 
input_error('CAN\'T OPEN FILE (file not found)',
            file_not_found).
 
input_error('CAN\'T OPEN FILE (directory not found)',
            directory_not_found).
 
input_error(
'CAN\'T OPEN FILE (insufficient privilege or file protection violation)',
            access_forbidden).
 
input_error('CAN\'T OPEN FILE (error in file name)',
            invalid_filename).
 
input_error('Wrong value for argument1 of see',
            invalid_filename).
 
 
:- assert((
prolog_error(SystemMessage,File) :-
    '$calling_open_input', !,
    input_error(SystemMessage,MyMessage),
    asserta( '$open_input_error_was'(MyMessage) )
)).
 
 
open_output( FileName, StatusOut ) :-
    assert( '$calling_open_output' ),
    retractall( '$open_output_error_was'(_) ),
    telling( COS ),
    tell( FileName ),
    (
        '$open_output_error_was'(Status)
    ->
        tell( COS ),
        retractall('$open_output_error_was'(_))
    ;
        Status = ok
    ),
    retractall( '$calling_open_output' ),
    StatusOut = Status.
 
 
output_error('CAN\'T OPEN FILE (directory not found)',
             directory_not_found).
 
output_error('CAN\'T CREATE FILE (error in file name)',
             invalid_filename).
 
output_error('Wrong value for argument1 of tell',
             invalid_filename).
 
output_error('CAN\'T CREATE FILE (disk quota exceeded)',
             no_space_for_file).
 
output_error(
'CAN\'T OPEN FILE (insufficient privilege or file protection violation)',
             access_forbidden).
 
 
:- assert((
prolog_error(SystemMessage,_) :-
    '$calling_open_output', !,
    output_error( SystemMessage, MyMessage ),
    asserta( '$open_output_error_was'(MyMessage) )
)).
 
 
exists_file( File+defaults(Directory,Extension), FullName ) :-
    !,
    prolog_eval( exists_file(Directory,File,Extension), FullName ),
    /*  Returns 0 if the file doesn't exist.  */
    FullName \= 0.
 
exists_file( File, FullName ) :-
    exists_file( File+defaults('',''), FullName ).
 
 
exists_file( File ) :-
    exists_file( File, _ ).
 
 
find_file( _, [], _, _ ) :-
    bug( 'find_file: default list is empty' ).
 
find_file( File, DefaultList, FullNameOut, StatusOut ) :-
    find_file1( File, DefaultList, FullName, Status ),
    FullNameOut = FullName,
    StatusOut = Status.
 
 
find_file1( _, [], _, file_not_found ) :- !.
 
find_file1( File, [Defaults|OtherDefaults], FullName, ok ) :-
    exists_file( File+Defaults, FullName ),
    !.
 
find_file1( File, [_|OtherDefaults], FullName, Status ) :-
    find_file( File, OtherDefaults, FullName, Status ).
 
 
find_file( _, [], _, _, _ ) :-
    bug( 'find_file: default list is empty' ).
 
find_file( File, DefaultList, Extension, FullNameOut, StatusOut ) :-
    find_file1( File, DefaultList, Extension, FullName, Status ),
    FullNameOut = FullName,
    StatusOut = Status.
 
 
find_file1( _,  [], _, _, file_not_found ) :- !.
 
find_file1( File, [Dir|OtherDirs], Ext, FullName, ok ) :-
    exists_file( File+defaults(Dir,Ext), FullName ),
    !.
 
find_file1( File, [_|OtherDirs], Ext, FullName, Status ) :-
    find_file1( File, OtherDirs, Ext, FullName, Status ).
 
 
add_file_defaults( File+defaults(Directory,Extension), FullName ) :-
    !,
    prolog_eval( add_file_defaults(Directory,File,Extension), FullName ).
 
add_file_defaults( FileName, FileName ).
 
 
print_file( File, Printer ) :-
    prolog_eval( print_file(File,Printer,nodelete) ).
 
 
print_and_delete_file( File, Printer ) :-
    prolog_eval( print_file(File,Printer,delete) ).
 
 
:- endmodule.
 [LATNER]. If found, F becomes a full
          name, otherwise S becomes file_not_found.
 
 
PUBLIC add_file_defaults( FileName+, FullName? ):                     
--------------------------------                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                gb.pl                                                                                               100705  017064  000205  00000060162 05427665554 006321  0                                                                                                     47426                                                                                    1  0                                                                                                                                                                 /*  GB.PL  */


/*
This is the parser that I use with PLANNING_BUG.PL. It was sent
by Cameron Shelley. It defines a top-level predicate
    trans( Sentence+, Meaning-, Type- )
which parses Sentence and translates it into a type and a meaning.

Shelley wrote the parser. I wrote the parse-tree to meaning translator.
For more documentation on the parser, see right at the end of this
file.                 

Sentences are represented as lists of tokens (atoms).

Meanings are represented in a simple "logical form language". I shan't
define it formally, since in its present state, it's just a hack
which I wrote to get something going. Amongst other things, it
doesn't interface properly with the lexicon, and imperatives aren't
done correctly. Here are some examples:
    ?- trans( [eat,the,food], M, T ).
    M = the(_1, food(_1)) ,
        eat(me, _1)
    T = command

    ?- trans( [the,bug,eats,the,food], M, T ).
    M = the(_1, bug(_1)) ,
        the(_2, food(_2)) ,
        eats(_1, _2)
    T = assertion

    ?- trans( [the,big,bug,smashes,the,small,rock], M, T ).
    M = the(_1, (bug(_1) , big(_1))) ,
        the(_2, (rock(_2) , small(_2))) ,
        smashes(_1, _2)
    T = assertion

    ?- trans( [the,big,bug,smashes,the,small,rock,by,the,quicksand],M,T).
    M = the(_1, (bug(_1) , big(_1))) ,
        the(_2, (rock(_2) , small(_2) ,
        the(_3, quicksand(_3)) , by(_2, _3))) ,
        smashes(_1, _2)
    T = assertion
*/


/*
The parser
----------
*/


%%%%%%%%%
%       "Gibberish" -- A GB'ish parser!
%
%   A first attempt at a Government-Binding (GB) type
%   parser.  This parser is intended as an introductory
%   'toy' parser for NLU courses, so complexity will be
%   kept to a minimum while still being general enough
%   to be easily extended.  All constraints have been
%   been implemented as explicit prolog goals for
%   perspicuity.  Many optimizations are possible!  The
%   gapping mechanism actually performs a transformation
%   of the sentence into a 'normal' form and so has been
%   made general enough to move arbitrary structures
%   through the parse tree.
%
%   Author: Cameron Shelley
%   Address: cpshelley@violet.waterloo.edu
%        University of Waterloo
%
%   Comments are welcome!
%
%   This software is released into the public domain on the
%   condition that the author is cited as such, and all
%   modifications remain in the public domain; and this
%   condition is imposed on all subsequent users.
%
%   Modification History:
%   ---------------------
%   Jan 17/91 - creation
%   Feb 4/91  - fixed modal(nil) matching bug in "modal-2".
%   Feb 4/91  - added general conjunction rule "conj".
%           (idea from Steve Green -- thanks Steve!)
%
%%%%%%%%%

parse :- read_sentence(Sentence),
     sentence(Struc,Sentence,[]),
     print_struct(Struc).


trans( Sentence, Goal, Type ) :-
     sentence( Struc, Sentence, [] ),
     /*  print_struct(Struc), */
     trans_sentence( Struc, Goal, Type ).


%%%%%%%%%
%   'sentence' will parse the basic np,vp structure
%   at the top level.  Different sentence types will
%   be added (ie. questions).
%
%   sentence(
%       Struc  : return structure from sentence call
%       )
%
%%%%%%%%%

%   normal sentence
%
sentence(Struc) -->
    noun_phrase(Np,Pers,Nnum,nogap,nogap),
    {Nnum = Vnum},
    verb_phrase(Vp,Pers,Vnum,nogap),
    {Struc = s(Np,Vp)}.

%   question with modal transformed to initial position
%
sentence(Struc) -->
    modal(M,_,_,_,_,nogap,_),
    noun_phrase(Np,Pers,Nnum,nogap,nogap),
    {Nnum = Vnum},
    verb_phrase(Vp,Pers,Vnum,M),
    {Struc = q(Np,Vp)}.

%   imperative
%
sentence(Struc) -->
    verb_phrase(Vp,Pers,Vnum,M),
    {Struc = c(Vp)}.


%%%%%%%%%
%   'noun_phrase' will parse the various types of np's and
%   should subcategorize between np's and sbars at some point.
%   Also, proper nouns and pronouns can be treated as special
%   np's in this system.
%
%   noun_phrase(
%       Struc : return structure,
%       Pers  : np 'person' = first | second | third,
%       Nnum  : np 'number' = sing | plur,
%       Gap   : transformed np (if any),
%       Gapout: output gap if Gap not resolved
%   )
%
%%%%%%%%%

noun_phrase(Struc,Pers,Nnum,Gap,Gapout) -->
    [],
    {Gap =.. [np|_]},
    {Gapout = nogap},
    {Struc = Gap}.

noun_phrase(Struc,Pers,Num,Gap,Gapout) -->
    determiner(Det,Dnum),
    {Nnum = Dnum},
    noun_bar(Nbar,Nnum),
    {Pers = third},
    {Gapout = Gap},
    {InStruc = np(Det,Nbar)},
    conj(Struc,InStruc,Nnum,Num,np).

%
%   determiner is the noun phrase specifier
%
%   determiner(
%       Struc : return structure,
%       Dnum  : det 'number' = sing | plur
%   )
%
%   No determiner is considered to pluralize the np, ie:
%   "cats go" but not *"cat goes".  The default could be
%   changed to "all" or "some" if desired.
%

determiner(Struc,Dnum) --> [Word], {lexdet(Word,Det,Dnum)}, {Struc = det(Word)}.
determiner(Struc,Dnum) --> [], {Dnum = plur}, {Struc = det(nil)}.

%
%   noun_bar is here just a noun with arguments.  A treatment
%   of adjectives should be added.
%
%   noun_bar(
%       Struc : return structure,
%       Nnum  : noun 'number' parsed = sing | plur
%       )
%

noun_bar(Struc,Nnum) -->
    adjectives( As ),
    noun(N,Nnum),
    noun_args(Nmod),
    {Struc = nbar(As,N,Nmod)}.


%   adjectives(
%       Struc : return structure
%       )
%
adjectives(Struc) -->
    [], {Struc = adjectives(nil)}.

adjectives(Struc) -->
    [Word], {lexadjective(Word)},
    adjectives(Rest),
    {Struc = adjectives(Word,Rest)}.


%
%   mass nouns should be considered as noun_bars in this system!
%

noun(Struc,Nnum) --> [Word], {Nnum = sing}, {lexnoun(Word,_)},
    {Struc = noun(Word)}.
noun(Struc,Nnum) --> [Word], {Nnum = plur}, {lexnoun(_,Word)},
    {Struc = noun(Word)}.

%
%   noun_args here allows only pp's or nil's.  Handling of
%   embedded sentences can be added as suggested.
%
%   noun_args(
%       Struc : return structure
%       )
%

noun_args(Struc) -->
    prep_phrase(Pp),
    {Struc = n_args(Pp)}.

%noun_args(Struc) -->
%   sentence_bar(Sb),
%   {Struc = n_args(Sb)}.

noun_args(Struc) -->
    [],
    {Struc = n_args(nil)}.

%%%%%%%%%
%   'verb_phrase' will parse off the predicate of a sentence.
%   Auxiliaries could be added as suggested.  Sensitivity to
%   tense would also be handy.
%
%   verb_phrase(
%       Struc : return structure,
%       Mpers : 'person' of subject input to modal,
%       Mnum  : 'number' of subject input to modal,
%       Mgap  : gap (if any) input to modal
%   )
%
%   'Xpers' and 'Xnum' represent constraints passed to the
%   verb phrase which may be altered by the components and
%   passed to the next component as 'Ypers' or 'Ynum', ie.
%   Mpers ==> Vpers.
%
%%%%%%%%%

verb_phrase(Struc,Mpers,Mnum,Mgap) -->
    modal(M,Mpers,Vpers,Mnum,Vbnum,Mgap,Vbgap),
    verb_bar(Vb,Vpers,Vbnum,Vbgap),
    {InStruc = vp(M,Vb)},
    conj(Struc,InStruc,Mpers,Mnum,vp).

%
%   'verb_bar' parses a verb followed by arguments, if any.
%   Auxiliaries can be handled as specifiers before the actual
%   verb is read.  Subcategorization (Scat) could also be made
%   more detailed.
%
%   verb_bar(
%       Struc : return structure,
%       Pers  : 'person' of subject (check for agreement),
%       Vnum  : 'number' of subject (check for agreement again),
%       Pgap  : transformed np from predicate (if any)
%   )
%
%   {Gapout = nogap} ensures that the parse doesn't end with
%   an unresolved structure being gapped.
%

verb_bar(Struc,Pers,Vnum,Pgap) -->
    verb(V,Pers,Vnum,Scat),
    predicate(P,Pgap,Gapout,Scat),
    {Gapout = nogap},
    {Struc = vbar(V,P)}.

%
%   'modal' accepts the specifier of a vp.  It should be
%   expanded to help compute the mood and tense of the
%   sentence.
%
%   modal(
%       Struc : return structure,
%       Mpers : 'person' of subject np,
%       Vpers : 'person' resulting from 'modal' ("nil" if found),
%       Mnum  : 'number' of subject np,
%       Vbnum : 'number' resulting from 'modal' ("inf" if found),
%       Mgap  : transformed modal (if any),
%       Vbgap : gap resulting from 'modal' (unchanged if found)
%   )
%

modal(Struc,Mpers,Vpers,Mnum,Vbnum,Mgap,Vbgap) --> [Word],
    {lexmodal(Word)}, {Vbgap = Mgap}, {Vbnum = inf},
    {Vpers = nil}, {Struc = modal(Word)}.
modal(Struc,Mpers,Vpers,Mnum,Vbnum,Mgap,Vbgap) --> [],
    {Mgap =.. [modal|[X]]}, {X \== nil}, {Vbgap = nogap}, {Vbnum = inf},
    {Vpers = nil}, {Struc = Mgap}.
modal(Struc,Mpers,Vpers,Mnum,Vbnum,Mgap,Vbgap) --> [],
    {Mgap = nogap}, {Vbgap = nogap}, {Vbnum = Mnum},
    {Vpers = Mpers}, {Struc = modal(nil)}.

%
%   'verb' parses the verb from the input if it is found in
%   the lexicon.  "lexverb" could contain more info on the
%   verb.
%
%   verb(
%       Struc : return structure,
%       Pers  : 'person' of the subject (for agreement check),
%       Vnum  : 'number' of the subject (for agreement check again!),
%       Scat  : SubCATegory of the verb =
%               dt (ditransitive : two objects) |
%               tv (transitive : one object) |
%               iv (intransitive : no objects)
%   )
%

verb(Struc,Pers,Vnum,Scat) --> [Word],
    {Pers \== third; Vnum = plur}, {lexverb(Scat,Word,_,_)},
    {Struc = verb(Word)}.
verb(Struc,Pers,Vnum,Scat) --> [Word],
    {Pers = third}, {Vnum = sing}, {lexverb(Scat,_,Word,_)},
    {Struc = verb(Word)}.
verb(Struc,Pers,Vnum,Scat) --> [Word],
    {Vnum \== inf}, {lexverb(Scat,_,_,Word)},
    {Struc = verb(Word)}.

%
%   'predicate' parses the subcategorized dt, tv, or iv arguments
%   of the verb.
%
%   predicate(
%       Struc : return structure,
%       Pgap  : transformed np gap (if any),
%       Gapout: output any unresolved gap,
%       Scat  : SubCATegory to be returned
%   )
%

predicate(Struc,Pgap,Gapout,Scat) -->
    {Scat = dt},
    noun_phrase(Np1,_,_,nogap,_),
    noun_phrase(Np2,_,_,Pgap,Gapout),
    {Struc = pred(Np1,Np2)}.

predicate(Struc,Pgap,Gapout,Scat) -->
    {Scat = tv},
    noun_phrase(Np,_,_,Pgap,Gapout),
    {Struc = pred(Np)}.

predicate(Struc,Pgap,Gapout,Scat) -->
    {Scat = iv},
    [],
    {Gapout = Pgap},
    {Struc = pred(nil)}.

%%%%%%%%%
%   'prep_phrase' does the obvious.  Gapping could be introduced
%   to handle transformed pp's (but I doubt it :).
%
%   prep_phrase(
%       Struc : return structure
%   )
%
%%%%%%%%%

prep_phrase(Struc) -->
    preposition(P),
    noun_phrase(Np,_,_,nogap,_),
    {InStruc = pp(P,Np)},
    conj(Struc,InStruc,_,_,pp).

preposition(Struc) --> [Word], {lexprep(Word)}, {Struc = prep(Word)}.


%%%%%%%%%
%   'conj' will parse off a conjuction followed by a constituent
%   of category 'Cat'.  The result will be the right sister of
%   the previously parsed structure passed in.
%
%   conj(
%       OutStruc : result structure from conj,
%       InStruc  : previous structure parsed,
%       Arg1     : first constraint on constituent,
%       Arg2     : second constraint on constituent,
%       Cat      : category of new structure to be parsed
%   )
%
%   By McCawley's usage (McCawley 1988, Vol 1 & 2), constituents
%   should only be conjoined to others of the same category; ie.
%   np "and" np, vp "or" vp, etc.  If no conjunction is found
%   (conj-2,3), then the result structure is unchanged.
%
%%%%%%%%%

conj(OutStruc,InStruc,Arg1,Arg2,Cat) -->
    conjunction(C,Num),
    construct(Constr,Cat,Arg1,Arg2,Num),
    {OutStruc =.. [Cat,InStruc,C,Constr]}.

conj(Struc,Struc,_,_,vp) --> [].
conj(Struc,Struc,Arg,Arg,_) --> [].

conjunction(conj(Word),Num) --> [Word], {lexconj(Word,Num)}.

%
%   the meaning of the last three args for 'construct' depend
%   on which constituent is being parsed.  For np, the number
%   of the conjoined np is the 'number' of the first conjunction.
%   This is just a convenient heuristic.  For vp, the person
%   and number must still agree across conjunction.  For pp,
%   no such constraints are necessary.
%

construct(Struct,np,_,Num,Num) -->
    noun_phrase(Struct,_,_,nogap,_).
construct(Struct,vp,Pers,Vnum,_) -->
    verb_phrase(Struct,Pers,Vnum,nogap).
construct(Struct,pp,_,_,_) -->
    prep_phrase(Struct).


/*
Reading sentences
-----------------

Not used by the planning bug, but useful when testing.
*/


%%%%%%%%%
%   'read_sentence' provides the ability to get input
%   in a natural fashion by typing in words separated
%   by spaces and terminated with a period.  Adapted
%   from _Prolog and Natural Language Analysis_ by
%   Pereira and Schieber.
%
%%%%%%%%%

read_sentence(Input) :- get0(Char), read_sentence(Char,Input).
read_sentence(Char,[]) :- period(Char),!.
read_sentence(Char,Input) :- space(Char),!,get0(Char1),
    read_sentence(Char1,Input).
read_sentence(Char,[Word|Words]) :- read_word(Char,Chars,Next),
    name(Word,Chars),
    read_sentence(Next,Words).

read_word(C,[],C) :- space(C),!.
read_word(C,[],C) :- period(C),!.
read_word(Char,[Char|Chars],Last) :- get0(Next), read_word(Next,Chars,Last).

space(32).
period(46).


/*
Translating parse-trees to meanings
-----------------------------------
*/


/*  trans_sentence( Tree+, Meaning-, Type- ):
        Translates a parse tree into a meaning-representation
        and a type: one of 'assertion', 'command', 'question'.
*/
trans_sentence( s(NP,VP), Assertion, assertion ) :-
    !,
    trans_noun_phrase( NP, NPGoals, NPVar ),
    trans_verb_phrase( VP, Modal, Verb, ArgGoals, ArgVars ),
    combine_noun_verb( NPVar, Modal, Verb, ArgVars, VerbGoals ),
    Assertion = (NPGoals, ArgGoals, VerbGoals).

trans_sentence( q(NP,VP), Question, question ) :-
    trans_noun_phrase( NP, NPGoals, NPVar ),
    trans_verb_phrase( VP, Modal, Verb, ArgGoals, ArgVars ),
    combine_noun_verb( NPVar, Modal, Verb, ArgVars, VerbGoals ),
    conjoin( NPGoals, ArgGoals, VerbGoals, Question ).

trans_sentence( c(VP), Command, command ) :-
    trans_verb_phrase( VP, Modal, Verb, ArgGoals, ArgVars ),
    combine_noun_verb( me, Modal, Verb, ArgVars, VerbGoals ),
    Command = (ArgGoals, VerbGoals).


/*  combine_noun_verb( NPVar+, Modal+, Verb+, Vars+, VerbGoal- ):
        NPVar is the variable representing the subject of Verb.
        Vars are the variables representing its object(s).
        combine_noun_verb returns in VerbGoal a goal which
        represents the relation described by the verb, acting on
        NPVar and Vars.       
*/
combine_noun_verb( NPVar, Modal, Verb, [], VerbGoals ) :-
    !,
    VerbGoals =.. [ Verb, NPVar ].

combine_noun_verb( NPVar, Modal, Verb, [ArgVar1], VerbGoals ) :-
    !,
    VerbGoals =.. [ Verb, NPVar, ArgVar1 ].

combine_noun_verb( NPVar, Modal, Verb, [ArgVar1,ArgVar2], VerbGoals ) :-
    VerbGoals =.. [ Verb, NPVar, ArgVar1, ArgVar2 ].


/*  trans_noun_phrase( Tree+, Goal-, Var- ):
        Translates Tree, representing a noun phrase, into a goal. Some
        of the predicates in the goal will take Var as their argument.
        Goal should be regarded as existentially quantifying Var thus:
            (there exists Var) such that Goal
        This represents the meaning of the phrase in that Var is the
        object denoted by it, and Goal the conditions that object must
        satisfy.
*/
trans_noun_phrase( np(det(nil),NBar), NPGoals, NPVar ) :-
    !,
    trans_noun_bar( NBar, NPGoals, NPVar ).

trans_noun_phrase( np(det(the),NBar), the(NPVar,NPGoals), NPVar ) :-
    !,
    trans_noun_bar( NBar, NPGoals, NPVar ).

trans_noun_phrase( np(det(a),NBar), NPGoals, NPVar ) :-
    trans_noun_bar( NBar, NPGoals, NPVar ).


/*  trans_noun_bar( Tree+, Goal-, Var- ):
        Translates Tree, representing a noun-bar structure phrase, into
        a goal. Goal and Var represent an object, as above for
        trans_noun_phrase.
*/
trans_noun_bar( nbar(Adjectives,noun(Noun),Mod), NPGoals, NPVar ) :-
    trans_adjectives( Adjectives, NPVar, AdjGoals ),
    NounGoal =.. [ Noun, NPVar ],
    trans_noun_args( Mod, NPVar, ModGoals ),
    conjoin( NounGoal, AdjGoals, ModGoals, NPGoals ).


/*  trans_adjectives( Tree+, Goal-, Var- ):
        Translates Tree, representing a sequence of adjectives, into a
        goal. Goal and Var represent the meaning of these adjectives,
        in that any object Var which is describable by them must satisfy
        the conditions in Goal.
*/
trans_adjectives( adjectives(nil), _, true ) :- !.

trans_adjectives( adjectives(Adj,Rest), NPVar, AdjGoals ) :-
    trans_adjectives( Rest, NPVar, RestGoals ),
    AdjGoal =.. [ Adj, NPVar ],
    conjoin( AdjGoal, RestGoals, AdjGoals ).


/*  trans_noun_args( Tree+, Goal-, Var- ):
        The "arguments" of a noun are the following prepositional
        phrases, if any. trans_noun_args translates a
        prepositional-phrase-tree into a goal and variable representing
        a condition on the noun, as for trans_adjectives.
*/
trans_noun_args( n_args(nil), _, true ) :- !.

trans_noun_args( n_args(PP), NPVar, ModGoals  ) :-
    trans_prep_phrase( PP, Prep, ArgGoals, ArgVar ),
    PrepGoal =.. [ Prep, NPVar, ArgVar ],
    conjoin( ArgGoals, PrepGoal, ModGoals ).


/*  trans_verb_phrase( Tree+, Modal-, Verb-, Goal-, Vars- ):
        Translates Tree into a Verb, Goal, and Vars as for
        trans_verb_bar, and isolates the modal verb into Modal.
*/
trans_verb_phrase( vp(Modal,VerbBar), Modal, Verb, ArgGoals, ArgVars ) :-
    trans_verb_bar( VerbBar, Verb, ArgGoals, ArgVars ).


/*  trans_verb_bar( Tree+, Verb-, Goal-, Vars- ):
        Tree represents a verb-bar phrase. trans_verb_bar translates the
        verb's "argument" (the predicate: see below) into Goal and Vars,
        and isolates the verb into Verb.
*/
trans_verb_bar( vbar(verb(Verb),P), Verb, ArgGoals, ArgVars ) :-
    trans_predicate( P, ArgGoals, ArgVars ).


/*  trans_predicate( Tree+, Goal-, Vars- ):
        Tree represents a predicate, in the grammatical sense: the
        object(s) of a verb. These are noun phrases. trans_predicate
        translates each of them and returns a conjunction of the goals
        defining each phrase, and a list of variables representing the
        things referred to.
*/
trans_predicate( pred(NP1,NP2), (NP1Goals,NP2Goals), [NP1Var,NP2Var] ) :-
    !,
    trans_noun_phrase( NP1, NP1Goals, NP1Var ).
    trans_noun_phrase( NP2, NP2Goals, NP2Var ).

trans_predicate( pred(NP), NPGoals, [NPVar] ) :-
    !,
    trans_noun_phrase( NP, NPGoals, NPVar ).

trans_predicate( pred(nil), true, [] ) :- !.


/*  trans_prep_phrase( Tree+, Prep-, Goal-, Var- ):
        Tree is the parse-tree for a prepositional phrase.
        trans_prep_phrase translates its noun-phrase part into Goal and
        Var, and extracts the preposition into Prep.
*/
trans_prep_phrase( pp(prep(Prep),NP), Prep, NPGoals, NPVar ) :-
    trans_noun_phrase( NP, NPGoals, NPVar ).


/*
Joining goals together
----------------------
*/


/*  conjoin( G1+, G2+, G- ):
        G is the goal representing (G1 and G2). conjoin optimises
        out redundant trues.
*/
conjoin( true, G, G ) :- !.
conjoin( G, true, G ) :- !.
conjoin( G1, G2, (G1,G2) ) :- !.


/*  conjoin( G1+, G2+, G3, G- ):
        G is the goal representing (G1 and G2 and G3).
*/
conjoin( G1, G2, G3, G1G2G3 ) :-
    conjoin( G2, G3, G2G3 ),
    conjoin( G1, G2G3, G1G2G3 ).


/*  conjoin( G1+, G2+, G3+, G4+, G- ):
        G is the goal representing (G1 and G2 and G3 and G4).
*/
conjoin( G1, G2, G3, G4, G1G2G3G4 ) :-
    conjoin( G2, G3, G4, G2G3G4 ),
    conjoin( G1, G2G3G4, G1G2G3G4 ).


/*
Notes
-----

This is a documentation file, also written by Cameron, about how
the parser works, and extensions to it.

    Introduction to Gibberish
    -------------------------

The Gibberish parser has a limited but flexible parsing ability.
The code contains comments suggesting how Gibberish can be
modified to handle the sentences in file test2.  As a preliminary,
the student is advised to look at the simpler sentences in test1
and note how Gibberish handles them and why they are correct or
incorrect.  Comparing those sentences with the ones in test2 may
suggest what coverage this parser lacks, and what structures will
need to be added.  The following are a few hints about those
structures and how Gibberish can be expanded to suit:

    1)  the 'gapping' mechanism ("gap" is a term for a missing
        sentence constituent) has been implemented in full
        generality, so that any structure can be passed
        through as a gap.  In fact, gapping of noun phrases (NP's)
        has already been accomodated in the verb predicate,
        but it has not been utilized.  You *may* also wish
        to rewrite the prepositional phrase (PP) rule so that
        it can also accept gaps (hint)!

    2)  For an example of how the gapping works, look at the
        second "sentence" rule -- where the sentence is a
        question in which the modal has been 'moved' out of
        'normal' position to the front of the input.  The
        modal (if one is found, of course) is parsed unconditionally
        and its parsed structure is placed in the gap slot of
        the verb phrase (VP).  Notice in the VP rule that that
        structure is passed directly to the modal rule.  The
        second modal rule checks (since no modal has been
        found on the input) to see if the gap contains a modal
        passed in from the previous parsing.  The check is
        found in the Prolog goal "{Mgap =.. [modal|_]}".  If
        a modal is found, the output gap (Vbgap) is set to
        nogap (ie. the gap has been consumed) and the other
        variables are set to the appropriate state.  Now look
        at the first NP rule...

    3)  A sentence can only be judged correct if the gap has
        been consumed during the parse so that nothing is left
        over at the end of the sentence unresolved.  This is
        handled by the Prolog goal "{Gapout = nogap}" in the
        verb_bar rule.  If this equality fails, the parser 
        must backtrack.

    4)  This suggests that a profitable method of finding more
        general structures for parsing is to re-write sentences
        into a 'normal' form, ie.

        Does he know you stole his car.

        becomes:

        He does know you stole his car.

        A further possibility is:

        What do you want.

        becomes:

        You do want what.

    5)  In light of this, it is obvious that Gibberish's VP
        rules have to be expanded to include 'auxiliaries'
        and 'operators'.  'Wh-constituents' can also be worked
        into a similar scheme.  Of the roughly ten different
        'verb' tenses, Gibberish handles only three (hint)!

    6)  Another structure lacking in Gibberish is the sentence_bar
        (Sbar).  An example would be "for her to argue", or
        "having pleasure at the office".  The parser should be
        expanded to accomodate these as possible subjects and
        objects of verbs (and could be sub-categorized for).
        One possibility, in "noun_args", has been commented out.

    7)  The conjunction handling includes a simple mechanism
        to make conjoined structures agree much like simple ones.
        More structures than np, vp, and pp can be conjoined.
        In particular, the test sentence:

        a cat or dog will go and see the stamp.

        doesn't parse because the vp-level 'conj' expects both
        "will go" and "see" to be third & sing.  Conjunction at
        the vbar level will be needed to handle such a sentence.
        The nbar rule could use a similar arrangement.

    8)  Other areas of note: imperatives, adjectives, adverbs
        (and the phrases headed by both),  mood, voice, the
        verb "be",  the copula "be", pronouns, idioms, etc.
*/
b( NPVar, Modal, Verb, ArgVars, VerbGoals ),
    Assertion = (NPGoals, ArgGoals, VerbGoals).

trans_sentence( q(NP,VP), Question, question ) :-
    trans_noun_phrase( NP, NPGoals, NPVar ),
    trans_verb_phrase( VP, Modal, Verb, ArgGoals, ArgVars ),
    combine_noun_verb( NPVar, Modal, Verb, ArgVars, VerbGoals ),
    conjoin( NPGoals, ArgGoals, VerbGoals, Question ).

trans_sentence( c(VP), Command, command ) :-
    trans_verb_phrase( VP, Modal, Ver                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                gbug.pl                                                                                             100705  017064  000205  00000003154 05427665554 006653  0                                                                                                     47426                                                                                    1  0                                                                                                                                                                 /*  gbug.PL  */


resolve [p,r].

stm [ goal(notice_food) ].

stm_predicates [goal,path].


goal(notice_food),
can_see(+)
=>
erase(goal(notice_food)),
goal(plan_path).

goal(notice_food),
not(can_see(+))
=>
wander.


goal(plan_path),
retina(X,Y,nearest(+)),
retina_path( [3,2], [X,Y], Path )
=>
path(Path),
erase(goal(plan_path)),
goal(check_path_found).


goal(check_path_found),
path(not_found)
=>
erase(goal(check_path_found)),
goal(notice_food).

goal(check_path_found),
not(path(not_found))
=>
erase(goal(check_path_found)),
goal(follow_path).


goal(follow_path),
path( [First|Rest] )
=>
exec( First ),
erase(path(_)),
path(Rest).

goal(follow_path),
path( [] ),
over(+)
=>
erase(goal(follow_path)),
erase( path([]) ),
exec( [grab] ),
exec( [use] ),
goal( notice_food ).

goal(follow_path),
path( [] ),
not( over(+) )
=>
erase(goal(follow_path)),
erase( path([]) ),
goal( notice_food ).


:- prolog_language(pop11).

needs retina_path;

define safe(awm,x,y);
    awm(x,y) /= `*`
enddefine;

define find_path(start,goal);
    lvars start, goal;
    retina_path( retina(),start,goal,safe);
enddefine;

:- prolog_language(prolog).

:- library('path_to_moves.pl').

retina_path( Start, Goal, Moves ) :-
    prolog_eval( find_path(Start,Goal), Path ),
    path_to_moves( [0,1], Path, Moves_, _ ),
    moves_to_commands( Moves_, Moves ),
    !.

retina_path( Start, Goal, not_found ).


moves_to_commands( [], [] ) :- !.

moves_to_commands( [Move|Rest], [[Move]|Rest1] ) :-
    moves_to_commands( Rest, Rest1 ).
 ArgVar ),
    PrepGoal gbug1.pl                                                                                            100705  017064  000205  00000003400 05427665554 006726  0                                                                                                     47426                                                                                    1  0                                                                                                                                                                 /*  gbug1.PL  */


resolve [p,r].

stm [ goal(notice_food) ].

stm_predicates [goal,path].


goal(notice_food),
can_see(+)
=>
erase(goal(notice_food)),
goal(plan_path).

goal(notice_food),
not(can_see(+))
=>
wander.


goal(plan_path),
retina(X,Y,nearest(+)),
retina_path( [3,2], [X,Y], Path )
=>
path(Path),
erase(goal(plan_path)),
goal(check_path_found).


goal(check_path_found),
path(not_found)
=>
erase(goal(check_path_found)),
goal(notice_food).

goal(check_path_found),
not(path(not_found))
=>
erase(goal(check_path_found)),
goal(follow_path).


goal(follow_path),
path( [First|Rest] )
=>
exec( First ),
erase(path(_)),
path(Rest).

goal(follow_path),
path( [] ),
over(+)
=>
erase(goal(follow_path)),
erase( path([]) ),
exec( [grab] ),
exec( [use] ),
goal( wash ).

goal(follow_path),
path( [] ),
not( over(+) )
=>
erase(goal(follow_path)),
erase( path([]) ),
goal( notice_food ).


goal(wash),
can_see(w),
not(over(w))
=>
move_towards(w).

goal(wash),
over(w)
=>
exec( [use] ),
erase(goal(wash)),
goal(notice_food).


:- prolog_language(pop11).

needs retina_path;

define safe(awm,x,y);
    awm(x,y) /= `*`
enddefine;

define find_path(start,goal);
    lvars start, goal;
    retina_path( retina(),start,goal,safe);
enddefine;

:- prolog_language(prolog).

:- library('path_to_moves.pl').

retina_path( Start, Goal, Moves ) :-
    prolog_eval( find_path(Start,Goal), Path ),
    path_to_moves( [0,1], Path, Moves_, _ ),
    moves_to_commands( Moves_, Moves ),
    !.

retina_path( Start, Goal, not_found ).


moves_to_commands( [], [] ) :- !.

moves_to_commands( [Move|Rest], [[Move]|Rest1] ) :-
    moves_to_commands( Rest, Rest1 ).
2, G3, G1G2G3 ) :-
    conjoin( G2, G3, G2G3 ),
    conjoin( G1, G2G3, G1G2G3 ).


/*  conjoin( G1+, G2+, G3+, G4+, G- ):
        G is the goal representing (G1 and G2 and G3 and G4).
*/
conjoin( G1, G2, G3, G4, G1G2G3G4 ) :-
    conjoin( G2, G3, G4, G2G3G4 ),
    conjoin( G1, G2G3G4, G1G2G3G4 ).


/*
Notes
-----

This is a documentation file, also written by Cameron, about how
the parser works, and extgbug3.pl                                                                                            100705  017064  000205  00000003142 05427665554 006733  0                                                                                                     47426                                                                                    1  0                                                                                                                                                                 /*  gbug3.PL  */


resolve [p,r].

stm [ goal(notice_food) ].

stm_predicates [goal,path].


goal(notice_food),
can_see(+)
=>
erase(goal(notice_food)),
goal(plan_path).

goal(notice_food),
not(can_see(+))
=>
wander.


goal(plan_path),
retina(X,Y,nearest(+)),
retina_path( [3,2], [X,Y], Path )
=>
path(Path),
erase(goal(plan_path)),
goal(check_path_found).


goal(check_path_found),
path(not_found)
=>
erase(goal(check_path_found)),
goal(notice_food).

goal(check_path_found),
not(path(not_found))
=>
erase(goal(check_path_found)),
goal(follow_path).


goal(follow_path),
path(Path)
=>
exec_list(Path),
erase(path(Path)),
path([]).

goal(follow_path),
path( [] ),
over(+)
=>
erase(goal(follow_path)),
erase( path([]) ),
exec( [grab] ),
exec( [use] ),
goal( notice_food ).

goal(follow_path),
path( [] ),
not( over(+) )
=>
erase(goal(follow_path)),
erase( path([]) ),
goal( notice_food ).

:- prolog_language(pop11).

needs retina_path;

define safe(awm,x,y);
    awm(x,y) /= `*`
enddefine;

define find_path(start,goal);
    lvars start, goal;
    retina_path( retina(),start,goal,safe);
enddefine;

:- prolog_language(prolog).

:- library('path_to_moves.pl').

retina_path( Start, Goal, Moves ) :-
    prolog_eval( find_path(Start,Goal), Path ),
    path_to_moves( [0,1], Path, Moves_, _ ),
    moves_to_commands( Moves_, Moves ),
    !.

retina_path( Start, Goal, not_found ).


moves_to_commands( [], [] ) :- !.

moves_to_commands( [Move|Rest], [[Move]|Rest1] ) :-
    moves_to_commands( Rest, Rest1 ).
ow look
        at the first NPgbug4.pl                                                                                            100705  017064  000205  00000003362 05427665555 006741  0                                                                                                     47426                                                                                    1  0                                                                                                                                                                 /*  gbug4.PL  */


resolve [p,r].

stm [ goal(notice_food) ].

stm_predicates [goal,path].


goal(notice_food),
can_see(+)
=>
erase(goal(notice_food)),
goal(plan_path).

goal(notice_food),
not(can_see(+))
=>
wander.


goal(plan_path),
retina(X,Y,nearest(+)),
retina_path( [3,2], [X,Y], Path )
=>
path(Path),
erase(goal(plan_path)),
goal(check_path_found).


goal(check_path_found),
path(not_found)
=>
erase(goal(check_path_found)),
goal(notice_food).

goal(check_path_found),
not(path(not_found))
=>
erase(goal(check_path_found)),
goal(follow_path).


goal(follow_path),
facing('b')
=>
erase(goal(follow_path)),
erase(Path),
exec([left]), exec([forward]),
goal(notice_food).

goal(follow_path),
path( [First|Rest] )
=>
exec( First ),
erase(path(_)),
path(Rest).

goal(follow_path),
path( [] ),
over(+)
=>
erase(goal(follow_path)),
erase( path([]) ),
exec( [grab] ),
exec( [use] ),
goal( notice_food ).

goal(follow_path),
path( [] ),
not( over(+) )
=>
erase(goal(follow_path)),
erase( path([]) ),
goal( notice_food ).


:- prolog_language(pop11).

needs retina_path;

define safe(awm,x,y);
    awm(x,y) /= `*`
enddefine;

define find_path(start,goal);
    lvars start, goal;
    retina_path( retina(),start,goal,safe);
enddefine;

:- prolog_language(prolog).

:- library('path_to_moves.pl').

retina_path( Start, Goal, Moves ) :-
    prolog_eval( find_path(Start,Goal), Path ),
    path_to_moves( [0,1], Path, Moves_, _ ),
    moves_to_commands( Moves_, Moves ),
    !.

retina_path( Start, Goal, not_found ).


moves_to_commands( [], [] ) :- !.

moves_to_commands( [Move|Rest], [[Move]|Rest1] ) :-
    moves_to_commands( Rest, Rest1 ).
),
    Assertion = (NPGoals, ArgGoals, VerbGoals).

trans_sentence( q(NP,VP), Question, question ) :-
    trans_noun_phrase( NP, NPGoals, NPVar ),
    trans_verb_phrase( VP, Modal, Verb, ArgGoals, ArgVars ),
    combine_noun_verb( NPVar, Modal, Verb, ArgVars, VerbGoals ),
    conjoin( NPGoals, ArgGoals, VerbGoals, Question ).

trans_sentence( c(VP), Command, command ) :-
    trans_verb_phrase( VP, Modal, Vergbug5.pl                                                                                            100705  017064  000205  00000000260 05427665555 006734  0                                                                                                     47426                                                                                    1  0                                                                                                                                                                 /*  gbug5.PL  */


resolve [p,r].

stm [].

stm_predicates [].


heard( S )
=>
exec( S ).

not(heard(S))
=>
reply([please,type,something]),
exec([wait]).
                                                                                                                                                                                                                                                                                                                                                                      gbug6.pl                                                                                            100705  017064  000205  00000003224 05427665555 006740  0                                                                                                     47426                                                                                    1  0                                                                                                                                                                 /*  gbug6.PL  */


resolve [p,r].

stm [ goal(notice_food) ].

stm_predicates [goal,path].


1 prio
heard( S )
=>
exec( S ).


goal(notice_food),
can_see(+)
=>
erase(goal(notice_food)),
goal(plan_path).

goal(notice_food),
not(can_see(+))
=>
wander.


goal(plan_path),
retina(X,Y,nearest(+)),
retina_path( [3,2], [X,Y], Path )
=>
path(Path),
erase(goal(plan_path)),
goal(check_path_found).


goal(check_path_found),
path(not_found)
=>
erase(goal(check_path_found)),
goal(notice_food).

goal(check_path_found),
not(path(not_found))
=>
erase(goal(check_path_found)),
goal(follow_path).


goal(follow_path),
path( [First|Rest] )
=>
exec( First ),
erase(path(_)),
path(Rest).

goal(follow_path),
path( [] ),
over(+)
=>
erase(goal(follow_path)),
erase( path([]) ),
exec( [grab] ),
exec( [use] ),
goal( notice_food ).

goal(follow_path),
path( [] ),
not( over(+) )
=>
erase(goal(follow_path)),
erase( path([]) ),
goal( notice_food ).


:- prolog_language(pop11).

needs retina_path;

define safe(awm,x,y);
    awm(x,y) /= `*`
enddefine;

define find_path(start,goal);
    lvars start, goal;
    retina_path( retina(),start,goal,safe);
enddefine;

:- prolog_language(prolog).

:- library('path_to_moves.pl').

retina_path( Start, Goal, Moves ) :-
    prolog_eval( find_path(Start,Goal), Path ),
    path_to_moves( [0,1], Path, Moves_, _ ),
    moves_to_commands( Moves_, Moves ),
    !.

retina_path( Start, Goal, not_found ).


moves_to_commands( [], [] ) :- !.

moves_to_commands( [Move|Rest], [[Move]|Rest1] ) :-
    moves_to_commands( Rest, Rest1 ).
                                                                                         100705  017064  000205  00000003400 05427665554 006726  0                                                                                                     47426                                                                                    1  0                                                                                                                                                                 gbug7.pl                                                                                            100705  017064  000205  00000001130 05427665555 006733  0                                                                                                     47426                                                                                    1  0                                                                                                                                                                 /*  gbug7.PL  */


resolve [p,r].

stm [ goal(obey),
      reverse(right,left),
      reverse(left,right),
      reverse(forward,back),
      reverse(back,forward),

    ].

stm_predicates [stack,goal,reverse].


goal(obey),
heard([home])
=>
erase(goal(obey)),
goal(home).

goal(obey),
not(heard([home])),
heard([X])
=>
exec([X]),
stack(X)
.

goal(obey),
not(heard(_))
=>
reply([please,type,something]),
exec([wait]).


goal(home),
stack(S),
reverse(S,Rev)
=>
exec([Rev]).

goal(home),
not(stack(_))
=>
reply([i,am,home,!]),
exit_eden.
1).

needs retina_path;

define safe(awm,x,y);
    awm(x,y) /= `*`
enddefine;

define find_path(start,goal);
    lvars start, goal;
    retina_path( retina(),start,goal,safe);
enddefine;

:- prolog_language(prolog).

:- library('path_to_moves.pl').

retina_path( Start, Goal, Moves ) :-
    prolog_eval( find_path(Start,Goal), Path ),
    path_to_moves( [0,1], Path, Moves_, _ ),
    moves_to_commands( Moves_, Moves ),
    !.

retina_path( Start, Goal, not_found ).


moves_to_commands( generate.p                                                                                          100705  017064  000205  00000015606 05427665556 007354  0                                                                                                     47426                                                                                    1  0                                                                                                                                                                 /*  GENERATE.P  */


/*
tree ::=
    [ TREE <type> <st> <st>* ]

st ::=
    tree |
    terminal              
*/


define random_rule();
    generate( "Prog", non_terminals, terminals );
enddefine;


vars non_terminals;
[
    [ Prog TYPE A
        [ if Perception_test then Action_fn else Action_fn endif ]
    ]

    [ Action_fn TYPE A
        [ if Perception_test then Action_fn else Action_fn endif ]
        [ Action_const ]
    ]

    [ Perception_test TYPE PT
        [ (Perception_test and Perception_test) ]
        [ (Perception_test or Perception_test) ]
        [ Smell_fn Neeq Smell_const ]
        [ Inventory_fn Neeq Portable_object_const ]
;;;        [ energy() Gtlt Energy_const ]
    ]

    [ Smell_fn TYPE S
        [ smell() ]
    ]

    [ Inventory_fn TYPE I
        [ inventory() ]
    ]

] -> non_terminals;


vars terminals;
[
    [ Action_const TYPE A
        ["forward"] ["back"] ["left"] ["right"] ["grab"] ["drop"] ["use"]
    ]

    [ Smell_const TYPE S
        ["forward"] ["back"] ["left"] ["right"] ["here"] ["carried"]
    ]

    [ Portable_object_const TYPE I                
        [`+`] [`k`] [`T`] [` `]
    ]

    [ Neeq
        [=] [/=]
    ]

    [ Gtlt
        [<] [>]
    ]

    [ Energy_const
        INT 1 500
    ]
]  -> terminals;


/*
Generation
----------

Now some functions for generating sentences at random given a grammar
and a lexicon. generate(grammar,lexicon) will produce a list of words
from the lexicon forming a sentence according to the grammar, which is
assumed to use "s" as the non-terminal name for sentences. Recursion is
controlled by maxlevel.

*/


vars Level maxlevel;
20 -> maxlevel;


vars sub_gen;/*forward*/


/*  expand_to_terminals( category ):
        Return a lexical item of type -category-, or -false- if there
        isn't one.

        The result will be either
            a list of terminal symbols
        or
            [ [ TREE <type> ^^<list of terminals> ] ]
        or
            -false-
*/
define expand_to_terminals( category );
    lvars category;

    lvars entry, typed, terminals;
    vars name, type, rest, l, u;

    for entry in Lexicon do
        /*  Each entry is of the form
                [ <name> <list> <list>* ]
            or
                [ <name> TYPE <type> <list> <list>* ]
            where <list> is a list of terminal symbols.
        */
        if  entry matches [ ?name TYPE ?type ??rest ] then
            true -> typed;
        else
            entry --> [ ?name ??rest ];
            false -> typed;
        endif;

        if name = category then
            if rest matches [ INT ?l ?u ] then
                [% random(u-l+1)+l-1 %]
            else
                oneof( rest )
            endif -> terminals;

            if typed then
                return( [ [ TREE ^type ^^terminals ] ] )
            else
                return( terminals )
            endif;
        endif;
    endfor;

    /*  If -category- did name a lexical non-terminal, we will have
        already returned from this procedure. So if we get here,
        return false.
    */
    false
enddefine;


/*  expand_rhs( rhs ):
        -rhs- is a list representing the right-hand side of a
        production. Each element is either a terminal symbol, or a
        category name (non-terminal).

        The result is
            a list of terminals and/or trees
        or
            -false-
*/
define expand_rhs( rhs );
    lvars rhs;

    vars first, rest;
    lvars first_expanded, rest_expanded;

    if rhs = [] then
        []
    else
        rhs --> [ ?first ??rest ];
        if  ( sub_gen(first) ->> first_expanded ) = false then
            false
        elseif ( expand_rhs(rest) ->> rest_expanded ) = false then
            false
        else
            [ ^^first_expanded ^^rest_expanded ]
        endif
    endif;

enddefine;


/*  expand_rhss( rules ):
        -rules- is a list of possible right-hand-sides. Repeatedly try
        expanding one till a non-false result is obtained, i.e.
        recursion level doesn't get exceeded.

        Result is the same as for -expand_rhs-.     
*/
define expand_rhss( rules ) -> result;
    lvars rules, result;

    vars rule;

    until rules = [] do
        oneof(rules) -> rule;
        if  ( expand_rhs(rule)->> result ) then
            return
        else
            delete(rule,rules) -> rules
        endif
    enduntil;

    false->result;
enddefine;


/*  sub_gen( category ):
        -category- is either the name of a grammatical category (including
        terminal symbols), or a list of possible right hand sides of a
        rule. This function is called by generate which has Grammar and
        Lexicon as local variables. sub_gen does all the work. If depth
        of recursion exceeds maxlevel, then return false

        The result will be either
            a list of trees and/or terminal symbols
        or
            -false-
*/
define sub_gen( category );
    lvars category;

    lvars typed, result;
    vars entry, name, type, rest, Level;

    Level + 1 -> Level;

    if  Level > maxlevel then
        return( false )
    elseif islist(category) then
        return( expand_rhss( category ) )
    elseif ( expand_to_terminals(category) ->> result ) then
        if result /= false then return(result) endif;
    endif;

    /*  If we get this far, -category- is either a terminal symbol
        or the name of a non-terminal. Check next to see whether
        it is a non-terminal.
    */
    for entry in Grammar do
        /*  Each entry is of the form
                [ <name> <rhs> <rhs>* ]
            or
                [ <name> TYPE <type> <rhs> <rhs>* ]
            where <rhs> is a list representing a right-hand side.
        */
        if entry matches [ ?name TYPE ?type ??rest ] then
            true -> typed;
        else
            entry --> [ ?name ??rest ];
            false -> typed;
        endif;

        if name = category then
            sub_gen( rest ) -> result;
            if result /= false then
                if typed then
                    if result matches [ [ TREE ^type == ] ] then
                        /*  Leave it as it is.  */
                    else
                        [ [ TREE ^type ^^result ] ] -> result;
                    endif;
                endif;
            endif;
            return( result );
        endif;

    endfor;

    /*  If we get this far, -category- is a terminal.  */
    [% category %]

enddefine;


define generate( Category, Grammar, Lexicon );
    vars Category, Grammar, Lexicon;

    vars Level=0;
    ;;; Controls depth of recursion.

    sub_gen( Category )
enddefine;
ogworld                                                                                              100705  017064  000205  00000000352 05427665557 006613  0                                                                                                     47426                                                                                    1  0                                                                                                                                                                 !  gworld

pb_objects
        ****************
        *+       +   + *
        *  B           *
        * +         +  *
        *       +      *
        *  +           *
        *      +     + *
        ****************
olog_eval( find_path(Start,Goal), Path ),
    path_to_moves( [0,1], Path, Moves_, _ ),
    moves_to_commands( Moves_, Moves ),
    !.

retina_path( Start, Goal, not_found ).


moves_to_commands( [], [] ) :- !.

moves_to_commands( [Move|Rest], [[Move]|Rest1] ) :-
    moves_to_commands( Restgworld.w                                                                                            100705  017064  000205  00000007714 05427665557 007071  0                                                                                                     47426                                                                                    1  0                                                                                                                                                                  zc world zl 0 zl 1 zl 2 3 5 zw 5 117 110 100 101 102 zs 12 112
 98 95 111 98 106 101 99 116 115 46 112 zw 5 117 110 100 101 102
 zw 5 117 110 100 101 102 16 8 za zl 4 0 15 0 7 zw 5 117 110 100
 101 102 zw 5 117 110 100 101 102 zw 5 117 110 100 101 102 zw 5
 117 110 100 101 102 zw 5 117 110 100 101 102 zw 5 117 110 100
 101 102 zw 5 117 110 100 101 102 zw 5 117 110 100 101 102 zw 5
 117 110 100 101 102 zw 5 117 110 100 101 102 zw 5 117 110 100
 101 102 zw 5 117 110 100 101 102 zw 5 117 110 100 101 102 zw 5
 117 110 100 101 102 zw 5 117 110 100 101 102 zw 5 117 110 100
 101 102 zw 5 117 110 100 101 102 zw 5 117 110 100 101 102 zw 5
 117 110 100 101 102 zw 5 117 110 100 101 102 zw 5 117 110 100
 101 102 zw 5 117 110 100 101 102 zw 5 117 110 100 101 102 zw 5
 117 110 100 101 102 zw 5 117 110 100 101 102 zw 5 117 110 100
 101 102 zw 5 117 110 100 101 102 zw 5 117 110 100 101 102 zw 5
 117 110 100 101 102 zw 5 117 110 100 101 102 zw 5 117 110 100
 101 102 zw 5 117 110 100 101 102 zw 5 117 110 100 101 102 zw 5
 117 110 100 101 102 zw 5 117 110 100 101 102 zw 5 117 110 100
 101 102 zw 5 117 110 100 101 102 zw 5 117 110 100 101 102 zw 5
 117 110 100 101 102 zw 5 117 110 100 101 102 zw 5 117 110 100
 101 102 zw 5 117 110 100 101 102 zw 5 117 110 100 101 102 zw 5
 117 110 100 101 102 zw 5 117 110 100 101 102 zw 5 117 110 100
 101 102 zw 5 117 110 100 101 102 zw 5 117 110 100 101 102 zw 5
 117 110 100 101 102 zw 5 117 110 100 101 102 zw 5 117 110 100
 101 102 zw 5 117 110 100 101 102 zw 5 117 110 100 101 102 zw 5
 117 110 100 101 102 zw 5 117 110 100 101 102 zw 5 117 110 100
 101 102 zw 5 117 110 100 101 102 zw 5 117 110 100 101 102 zw 5
 117 110 100 101 102 zw 5 117 110 100 101 102 zw 5 117 110 100
 101 102 zw 5 117 110 100 101 102 zw 5 117 110 100 101 102 zw 5
 117 110 100 101 102 zw 5 117 110 100 101 102 zw 5 117 110 100
 101 102 zw 5 117 110 100 101 102 zw 5 117 110 100 101 102 zw 5
 117 110 100 101 102 zw 5 117 110 100 101 102 zw 5 117 110 100
 101 102 zw 5 117 110 100 101 102 zw 5 117 110 100 101 102 zw 5
 117 110 100 101 102 zw 5 117 110 100 101 102 zw 5 117 110 100
 101 102 zw 5 117 110 100 101 102 zw 5 117 110 100 101 102 zw 5
 117 110 100 101 102 zw 5 117 110 100 101 102 zw 5 117 110 100
 101 102 zw 5 117 110 100 101 102 zw 5 117 110 100 101 102 zw 5
 117 110 100 101 102 zw 5 117 110 100 101 102 zw 5 117 110 100
 101 102 zw 5 117 110 100 101 102 zw 5 117 110 100 101 102 zw 5
 117 110 100 101 102 zw 5 117 110 100 101 102 zw 5 117 110 100
 101 102 zw 5 117 110 100 101 102 zw 5 117 110 100 101 102 zw 5
 117 110 100 101 102 zw 5 117 110 100 101 102 zw 5 117 110 100
 101 102 zw 5 117 110 100 101 102 zw 5 117 110 100 101 102 zw 5
 117 110 100 101 102 zw 5 117 110 100 101 102 zw 5 117 110 100
 101 102 zw 5 117 110 100 101 102 zw 5 117 110 100 101 102 zw 5
 117 110 100 101 102 zw 5 117 110 100 101 102 zw 5 117 110 100
 101 102 zw 5 117 110 100 101 102 zw 5 117 110 100 101 102 zw 5
 117 110 100 101 102 zw 5 117 110 100 101 102 zw 5 117 110 100
 101 102 zw 5 117 110 100 101 102 zw 5 117 110 100 101 102 zw 5
 117 110 100 101 102 zw 5 117 110 100 101 102 zw 5 117 110 100
 101 102 zw 5 117 110 100 101 102 zw 5 117 110 100 101 102 zw 5
 117 110 100 101 102 zw 5 117 110 100 101 102 zw 5 117 110 100
 101 102 zw 5 117 110 100 101 102 zw 5 117 110 100 101 102 zw 5
 117 110 100 101 102 zw 5 117 110 100 101 102 zw 5 117 110 100
 101 102 zw 5 117 110 100 101 102 zw 5 117 110 100 101 102 za
 zl 4 0 15 0 7 42 42 42 42 42 42 42 42 42 42 42 42 42 42 42 42
 42 32 32 32 32 32 32 43 32 32 32 32 32 43 32 42 42 32 32 43 32
 32 32 32 32 32 32 32 32 32 32 42 42 32 32 32 32 32 32 32 43 32
 32 32 32 32 32 42 42 32 43 32 32 32 32 32 32 32 32 32 43 32 32
 42 42 32 32 32 32 32 32 32 32 32 32 32 32 32 32 42 42 43 32 32
 32 32 32 32 32 43 32 32 32 43 32 42 42 42 42 42 42 42 42 42 42
 42 42 42 42 42 42 42 zw 5 117 110 100 101 102 zw 5 117 110 100
 101 102 zw 5 117 110 100 101 102 zw 5 117 110 100 101 102 zl 0
 0 0
        [ [ TREE <type> ^^<list of terminals> ] ]
        or
            -false-
*/
define expand_to_terminals( category );
    lvars category;

    gworld1                                                                                             100705  017064  000205  00000000360 05427665557 006673  0                                                                                                     47426                                                                                    1  0                                                                                                                                                                 !  gworld1

gworld1_objects
        ****************
        *+w      +w w+ *
        *  B        w  *
        * +         +  *
        * w     +w     *
        *  +w        w *
        *      +w    + *
        ****************
 [ [ TREE ^type ^^terminals ] ] )
            else
                return( terminals )
            endif;
        endif;
    endfor;

    /*  If -category- did name a lexical non-terminal, we will have
        already returned from this procedure. So if we get here,
        return fagworld1.w                                                                                           100705  017064  000205  00000007750 05427665560 007144  0                                                                                                     47426                                                                                    1  0                                                                                                                                                                  zc world zl 0 zl 1 zl 2 3 5 zw 5 117 110 100 101 102 zs 17 103
 119 111 114 108 100 49 95 111 98 106 101 99 116 115 46 112 zw 5
 117 110 100 101 102 zw 5 117 110 100 101 102 16 8 za zl 4 0 15
 0 7 zw 5 117 110 100 101 102 zw 5 117 110 100 101 102 zw 5 117
 110 100 101 102 zw 5 117 110 100 101 102 zw 5 117 110 100 101
 102 zw 5 117 110 100 101 102 zw 5 117 110 100 101 102 zw 5 117
 110 100 101 102 zw 5 117 110 100 101 102 zw 5 117 110 100 101
 102 zw 5 117 110 100 101 102 zw 5 117 110 100 101 102 zw 5 117
 110 100 101 102 zw 5 117 110 100 101 102 zw 5 117 110 100 101
 102 zw 5 117 110 100 101 102 zw 5 117 110 100 101 102 zw 5 117
 110 100 101 102 zw 5 117 110 100 101 102 zw 5 117 110 100 101
 102 zw 5 117 110 100 101 102 zw 5 117 110 100 101 102 zw 5 117
 110 100 101 102 zw 5 117 110 100 101 102 zw 5 117 110 100 101
 102 zw 5 117 110 100 101 102 zw 5 117 110 100 101 102 zw 5 117
 110 100 101 102 zw 5 117 110 100 101 102 zw 5 117 110 100 101
 102 zw 5 117 110 100 101 102 zw 5 117 110 100 101 102 zw 5 117
 110 100 101 102 zw 5 117 110 100 101 102 zw 5 117 110 100 101
 102 zw 5 117 110 100 101 102 zw 5 117 110 100 101 102 zw 5 117
 110 100 101 102 zw 5 117 110 100 101 102 zw 5 117 110 100 101
 102 zw 5 117 110 100 101 102 zw 5 117 110 100 101 102 zw 5 117
 110 100 101 102 zw 5 117 110 100 101 102 zw 5 117 110 100 101
 102 zw 5 117 110 100 101 102 zw 5 117 110 100 101 102 zw 5 117
 110 100 101 102 zw 5 117 110 100 101 102 zw 5 117 110 100 101
 102 zw 5 117 110 100 101 102 zw 5 117 110 100 101 102 zw 5 117
 110 100 101 102 zw 5 117 110 100 101 102 zw 5 117 110 100 101
 102 zw 5 117 110 100 101 102 zw 5 117 110 100 101 102 zw 5 117
 110 100 101 102 zw 5 117 110 100 101 102 zw 5 117 110 100 101
 102 zw 5 117 110 100 101 102 zw 5 117 110 100 101 102 zw 5 117
 110 100 101 102 zw 5 117 110 100 101 102 zw 5 117 110 100 101
 102 zw 5 117 110 100 101 102 zw 5 117 110 100 101 102 zw 5 117
 110 100 101 102 zw 5 117 110 100 101 102 zw 5 117 110 100 101
 102 zw 5 117 110 100 101 102 zw 5 117 110 100 101 102 zw 5 117
 110 100 101 102 zw 5 117 110 100 101 102 zw 5 117 110 100 101
 102 zw 5 117 110 100 101 102 zw 5 117 110 100 101 102 zw 5 117
 110 100 101 102 zw 5 117 110 100 101 102 zw 5 117 110 100 101
 102 zw 5 117 110 100 101 102 zw 5 117 110 100 101 102 zw 5 117
 110 100 101 102 zw 5 117 110 100 101 102 zw 5 117 110 100 101
 102 zw 5 117 110 100 101 102 zw 5 117 110 100 101 102 zw 5 117
 110 100 101 102 zw 5 117 110 100 101 102 zw 5 117 110 100 101
 102 zw 5 117 110 100 101 102 zw 5 117 110 100 101 102 zw 5 117
 110 100 101 102 zw 5 117 110 100 101 102 zw 5 117 110 100 101
 102 zw 5 117 110 100 101 102 zw 5 117 110 100 101 102 zw 5 117
 110 100 101 102 zw 5 117 110 100 101 102 zw 5 117 110 100 101
 102 zw 5 117 110 100 101 102 zw 5 117 110 100 101 102 zw 5 117
 110 100 101 102 zw 5 117 110 100 101 102 zw 5 117 110 100 101
 102 zw 5 117 110 100 101 102 zw 5 117 110 100 101 102 zw 5 117
 110 100 101 102 zw 5 117 110 100 101 102 zw 5 117 110 100 101
 102 zw 5 117 110 100 101 102 zw 5 117 110 100 101 102 zw 5 117
 110 100 101 102 zw 5 117 110 100 101 102 zw 5 117 110 100 101
 102 zw 5 117 110 100 101 102 zw 5 117 110 100 101 102 zw 5 117
 110 100 101 102 zw 5 117 110 100 101 102 zw 5 117 110 100 101
 102 zw 5 117 110 100 101 102 zw 5 117 110 100 101 102 zw 5 117
 110 100 101 102 zw 5 117 110 100 101 102 zw 5 117 110 100 101
 102 zw 5 117 110 100 101 102 zw 5 117 110 100 101 102 zw 5 117
 110 100 101 102 za zl 4 0 15 0 7 42 42 42 42 42 42 42 42 42 42
 42 42 42 42 42 42 42 32 32 32 32 32 32 43 119 32 32 32 32 43
 32 42 42 32 32 43 119 32 32 32 32 32 32 32 32 119 32 42 42 32
 119 32 32 32 32 32 43 119 32 32 32 32 32 42 42 32 43 32 32 32
 32 32 32 32 32 32 43 32 32 42 42 32 32 32 32 32 32 32 32 32 32
 32 119 32 32 42 42 43 119 32 32 32 32 32 32 43 119 32 119 43
 32 42 42 42 42 42 42 42 42 42 42 42 42 42 42 42 42 42 zw 5 117
 110 100 101 102 zw 5 117 110 100 101 102 zw 5 117 110 100 101
 102 zw 5 117 110 100 101 102 zl 0 0 0
 ).


moves_to_commands( [], [] ) :- !.

moves_to_commands( [Move|Rest], [[Move]|Rest1] ) :-
    moves_to_commands( Restgworld1_objects.p                                                                                   100705  017064  000205  00000002654 05427665560 010644  0                                                                                                     47426                                                                                    1  0                                                                                                                                                                 section $-objects => energy, thirst, smell;


/*
Standard objects
----------------
*/


lib pb_objects.p;


/*
Physiology
----------
*/


vars __smelly, __last_eat_time;


define my_start1();
    false -> __smelly;
    0 -> __last_eat_time;
enddefine;


define my_update();
    if __smelly and __last_eat_time < $-eden$-time-5 then
        kill( 'You smell of food and have been eaten by a predator!' );
    endif;
enddefine;


define my_line2() -> items -> format;
    lvars format, items;
    lvars s;
    'Inventory: ~8A   Here: ~8A   Time: ~8A Smelly: ~8A' -> format;
    [% object_name(inventory()),
       object_name(object_at_bug()),
       $-eden$-time,
       __smelly
    %] -> items;
enddefine;


/*
Food
----
*/


vars old_food;
food -> old_food;
define food(message,id,x,y);
    lvars message, id, x, y;
    switchon message
    case =[use] then
        old_food(message,id,x,y);
        $-eden$-time -> __last_eat_time;
        true -> __smelly;
    else
        old_food(message,id,x,y);
    endswitchon;
enddefine;
define_object( "food", food, `+` );


/*
Cleaning
--------
*/


define water(message,id,x,y);
    lvars message, id, x, y;
    switchon message
    case =[use] then
        false -> __smelly;
    else
        nothing(message,id,x,y);
    endswitchon;
enddefine;
define_object( "water", water, `w` );


endsection;
zw 5 117 110 100 101 102 zw 5 117 110 100 101 102 zw 5
 117 110 100 101 102 zw 5 117 110 100 101 102 zw 5 117 110 100
 101 102 zw 5 117 110 100 101 102 zw 5 117 110 100 101 102 zw 5
 117 110gworld2                                                                                             100705  017064  000205  00000000360 05427665560 006666  0                                                                                                     47426                                                                                    1  0                                                                                                                                                                 !  gworld2

gworld2_objects
        ****************
        *+w      +w w+ *
        *  B        w  *
        * +         +  *
        * w     +w     *
        *  +w        w *
        *      +w    + *
        ****************
 101 102 zw 5
 117 110 100 101 102 zw 5 117 110 100 101 102 zw 5 117 110 100
 101 102 zw 5 117 110 100 101 102 zw 5 117 110 100 101 102 zw 5
 117 110 100 101 102 zw 5 117 110 100 101 102 zw 5 117 110 100
 101 102 zw 5 117 110 100 101 102 zw 5 117 110 100 101 102 zw 5
 117 110 100 101gworld2.w                                                                                           100705  017064  000205  00000007750 05427665560 007145  0                                                                                                     47426                                                                                    1  0                                                                                                                                                                  zc world zl 0 zl 1 zl 2 3 5 zw 5 117 110 100 101 102 zs 17 103
 119 111 114 108 100 50 95 111 98 106 101 99 116 115 46 112 zw 5
 117 110 100 101 102 zw 5 117 110 100 101 102 16 8 za zl 4 0 15
 0 7 zw 5 117 110 100 101 102 zw 5 117 110 100 101 102 zw 5 117
 110 100 101 102 zw 5 117 110 100 101 102 zw 5 117 110 100 101
 102 zw 5 117 110 100 101 102 zw 5 117 110 100 101 102 zw 5 117
 110 100 101 102 zw 5 117 110 100 101 102 zw 5 117 110 100 101
 102 zw 5 117 110 100 101 102 zw 5 117 110 100 101 102 zw 5 117
 110 100 101 102 zw 5 117 110 100 101 102 zw 5 117 110 100 101
 102 zw 5 117 110 100 101 102 zw 5 117 110 100 101 102 zw 5 117
 110 100 101 102 zw 5 117 110 100 101 102 zw 5 117 110 100 101
 102 zw 5 117 110 100 101 102 zw 5 117 110 100 101 102 zw 5 117
 110 100 101 102 zw 5 117 110 100 101 102 zw 5 117 110 100 101
 102 zw 5 117 110 100 101 102 zw 5 117 110 100 101 102 zw 5 117
 110 100 101 102 zw 5 117 110 100 101 102 zw 5 117 110 100 101
 102 zw 5 117 110 100 101 102 zw 5 117 110 100 101 102 zw 5 117
 110 100 101 102 zw 5 117 110 100 101 102 zw 5 117 110 100 101
 102 zw 5 117 110 100 101 102 zw 5 117 110 100 101 102 zw 5 117
 110 100 101 102 zw 5 117 110 100 101 102 zw 5 117 110 100 101
 102 zw 5 117 110 100 101 102 zw 5 117 110 100 101 102 zw 5 117
 110 100 101 102 zw 5 117 110 100 101 102 zw 5 117 110 100 101
 102 zw 5 117 110 100 101 102 zw 5 117 110 100 101 102 zw 5 117
 110 100 101 102 zw 5 117 110 100 101 102 zw 5 117 110 100 101
 102 zw 5 117 110 100 101 102 zw 5 117 110 100 101 102 zw 5 117
 110 100 101 102 zw 5 117 110 100 101 102 zw 5 117 110 100 101
 102 zw 5 117 110 100 101 102 zw 5 117 110 100 101 102 zw 5 117
 110 100 101 102 zw 5 117 110 100 101 102 zw 5 117 110 100 101
 102 zw 5 117 110 100 101 102 zw 5 117 110 100 101 102 zw 5 117
 110 100 101 102 zw 5 117 110 100 101 102 zw 5 117 110 100 101
 102 zw 5 117 110 100 101 102 zw 5 117 110 100 101 102 zw 5 117
 110 100 101 102 zw 5 117 110 100 101 102 zw 5 117 110 100 101
 102 zw 5 117 110 100 101 102 zw 5 117 110 100 101 102 zw 5 117
 110 100 101 102 zw 5 117 110 100 101 102 zw 5 117 110 100 101
 102 zw 5 117 110 100 101 102 zw 5 117 110 100 101 102 zw 5 117
 110 100 101 102 zw 5 117 110 100 101 102 zw 5 117 110 100 101
 102 zw 5 117 110 100 101 102 zw 5 117 110 100 101 102 zw 5 117
 110 100 101 102 zw 5 117 110 100 101 102 zw 5 117 110 100 101
 102 zw 5 117 110 100 101 102 zw 5 117 110 100 101 102 zw 5 117
 110 100 101 102 zw 5 117 110 100 101 102 zw 5 117 110 100 101
 102 zw 5 117 110 100 101 102 zw 5 117 110 100 101 102 zw 5 117
 110 100 101 102 zw 5 117 110 100 101 102 zw 5 117 110 100 101
 102 zw 5 117 110 100 101 102 zw 5 117 110 100 101 102 zw 5 117
 110 100 101 102 zw 5 117 110 100 101 102 zw 5 117 110 100 101
 102 zw 5 117 110 100 101 102 zw 5 117 110 100 101 102 zw 5 117
 110 100 101 102 zw 5 117 110 100 101 102 zw 5 117 110 100 101
 102 zw 5 117 110 100 101 102 zw 5 117 110 100 101 102 zw 5 117
 110 100 101 102 zw 5 117 110 100 101 102 zw 5 117 110 100 101
 102 zw 5 117 110 100 101 102 zw 5 117 110 100 101 102 zw 5 117
 110 100 101 102 zw 5 117 110 100 101 102 zw 5 117 110 100 101
 102 zw 5 117 110 100 101 102 zw 5 117 110 100 101 102 zw 5 117
 110 100 101 102 zw 5 117 110 100 101 102 zw 5 117 110 100 101
 102 zw 5 117 110 100 101 102 zw 5 117 110 100 101 102 zw 5 117
 110 100 101 102 zw 5 117 110 100 101 102 zw 5 117 110 100 101
 102 zw 5 117 110 100 101 102 zw 5 117 110 100 101 102 zw 5 117
 110 100 101 102 za zl 4 0 15 0 7 42 42 42 42 42 42 42 42 42 42
 42 42 42 42 42 42 42 32 32 32 32 32 32 43 119 32 32 32 32 43
 32 42 42 32 32 43 119 32 32 32 32 32 32 32 32 119 32 42 42 32
 119 32 32 32 32 32 43 119 32 32 32 32 32 42 42 32 43 32 32 32
 32 32 32 32 32 32 43 32 32 42 42 32 32 32 32 32 32 32 32 32 32
 32 119 32 32 42 42 43 119 32 32 32 32 32 32 43 119 32 119 43
 32 42 42 42 42 42 42 42 42 42 42 42 42 42 42 42 42 42 zw 5 117
 110 100 101 102 zw 5 117 110 100 101 102 zw 5 117 110 100 101
 102 zw 5 117 110 100 101 102 zl 0 0 0
 zw 5 117 110 100 101 102 zw 5 117 110 100 101
 102 zw 5 117 110 100 101 102 zw 5 117 110 100 101 102 zw 5 117
 110 100 gworld2_objects.p                                                                                   100705  017064  000205  00000006426 05427665561 010647  0                                                                                                     47426                                                                                    1  0                                                                                                                                                                 section $-objects;


/*
Standard objects
----------------
*/


lib pb_objects.p;


/*
Physiology
----------
*/


vars __digesting, __smelly, __smell_time, __eat_time;


define my_start1();
    false -> __smelly;
    false -> __digesting;
    0 -> __smell_time;
    0 -> __eat_time;
enddefine;


;;; Called after bug has moved and world has been updated with its action.
;;;
define my_update();
    lvars i, j, id;

    if __smelly and __smell_time < $-eden$-time-5 then
        kill( 'You smell of food and have been eaten by a predator!' );
    endif;

    if __digesting and __eat_time < $-eden$-time-15 then
        kill( 'You waited too long before defecating and have burst!' );
    endif;

    for i from 0 to bw_world_width($-eden$-world)-1 do
        for j from 0 to bw_world_height($-eden$-world)-1 do
            ($-eden$-world.$-worlds$-world_contents)(i,j) -> id;
            $-worlds$-message( [update], id, i, j );
        endfor;
    endfor;

enddefine;


define my_line1() -> items -> format;
    lvars format, items;
    'Action: ~10A  Facing: ~8A Position: ~8A Digesting: ~8A' -> format;
    [% trunc($-eden$-last_action,10),
       direction(),
       '('><bug_xW()><','><bug_yW()><')',
       __digesting
    %] -> items;
enddefine;


define my_line2() -> items -> format;
    lvars format, items;
    lvars s;
    'Inventory: ~8A Here: ~8A   Time: ~8A     Smelly: ~8A' -> format;
    [% object_name(inventory()),
       object_name(object_at_bug()),
       $-eden$-time,
       __smelly
    %] -> items;
enddefine;


/*
Food
----
*/


vars old_food;
food -> old_food;
define food(message,id,x,y);
    lvars message, id, x, y;
    switchon message
    case =[use] then
        old_food(message,id,x,y);
        $-eden$-time ->> __smell_time -> __eat_time;
        true -> __digesting;
        true -> __smelly;
    else
        old_food(message,id,x,y);
    endswitchon;
enddefine;
define_object( "food", food, `+` );


/*
Cleaning
--------
*/


define water(message,id,x,y);
    lvars message, id, x, y;
    switchon message
    case =[use] then
        false -> __smelly;
    else
        nothing(message,id,x,y);
    endswitchon;
enddefine;
define_object( "water", water, `w` );


/*
Excretion
*/


vars faeces_states = newproperty( [], 5, undef, true );


define faeces(message,id,x,y);
    lvars message, id, x, y;
    switchon message
    case =[new] then
        $-eden$-time -> faeces_states(id);
    case =[update] then
        if faeces_states(id) < $-eden$-time-10 then
            destroy(id)
        endif
    else
        portable(message,id,x,y);
    endswitchon;
enddefine;
define_object( "faeces", faeces, `f` );


vars old_nothing;
nothing -> old_nothing;
define nothing(message,id,x,y);
    lvars message, id, x, y;
    lvars newid;
    switchon message
    case =[defecate] then
        new(`f`) -> newid;
        old_nothing(message,id,x,y);
        place( newid, [%x,y%] );
        false -> __digesting;
    else
        old_nothing(message,id,x,y);
    endswitchon;
enddefine;
define_object( "nothing", nothing, ` ` );


/*
New actions
-----------
*/


define_action( "defecate" );


endsection;
object_name(inventory()),
       object_name(object_at_bug()),
       $-eden$-time,
       __smelly
    %] -> items;
enddefine;


/*
Food
----
*/


vars old_food;
food -> old_food;
define food(message,id,x,y);
    lvars message, id, x, y;
    switchon message
    case =[use] then
        old_food(message,id,x,y);
        $-eden$-time -> __last_eat_time;
        true -> __smelly;
    else
        old_food(message,id,x,y);
    endswitchon;
endgworld3                                                                                             100705  017064  000205  00000000412 05427665561 006666  0                                                                                                     47426                                                                                    1  0                                                                                                                                                                 !  gworld3

gworld3_objects
        ****************
        *        +     *
        *  B   +    +  *
        *      b       *
        *  +b +     +  *
        *           b  *
        *  b      b    *
        *  +   + + b + *
        ****************
     47426                                                                                    1  0                                                                                                                                                                 gworld3.w                                                                                           100705  017064  000205  00000010662 05427665561 007143  0                                                                                                     47426                                                                                    1  0                                                                                                                                                                  zc world zl 0 zl 1 zl 2 3 6 zw 5 117 110 100 101 102 zs 17 103
 119 111 114 108 100 51 95 111 98 106 101 99 116 115 46 112 zw 5
 117 110 100 101 102 zw 5 117 110 100 101 102 16 9 za zl 4 0 15
 0 8 zw 5 117 110 100 101 102 zw 5 117 110 100 101 102 zw 5 117
 110 100 101 102 zw 5 117 110 100 101 102 zw 5 117 110 100 101
 102 zw 5 117 110 100 101 102 zw 5 117 110 100 101 102 zw 5 117
 110 100 101 102 zw 5 117 110 100 101 102 zw 5 117 110 100 101
 102 zw 5 117 110 100 101 102 zw 5 117 110 100 101 102 zw 5 117
 110 100 101 102 zw 5 117 110 100 101 102 zw 5 117 110 100 101
 102 zw 5 117 110 100 101 102 zw 5 117 110 100 101 102 zw 5 117
 110 100 101 102 zw 5 117 110 100 101 102 zw 5 117 110 100 101
 102 zw 5 117 110 100 101 102 zw 5 117 110 100 101 102 zw 5 117
 110 100 101 102 zw 5 117 110 100 101 102 zw 5 117 110 100 101
 102 zw 5 117 110 100 101 102 zw 5 117 110 100 101 102 zw 5 117
 110 100 101 102 zw 5 117 110 100 101 102 zw 5 117 110 100 101
 102 zw 5 117 110 100 101 102 zw 5 117 110 100 101 102 zw 5 117
 110 100 101 102 zw 5 117 110 100 101 102 zw 5 117 110 100 101
 102 zw 5 117 110 100 101 102 zw 5 117 110 100 101 102 zw 5 117
 110 100 101 102 zw 5 117 110 100 101 102 zw 5 117 110 100 101
 102 zw 5 117 110 100 101 102 zw 5 117 110 100 101 102 zw 5 117
 110 100 101 102 zw 5 117 110 100 101 102 zw 5 117 110 100 101
 102 zw 5 117 110 100 101 102 zw 5 117 110 100 101 102 zw 5 117
 110 100 101 102 zw 5 117 110 100 101 102 zw 5 117 110 100 101
 102 zw 5 117 110 100 101 102 zw 5 117 110 100 101 102 zw 5 117
 110 100 101 102 zw 5 117 110 100 101 102 zw 5 117 110 100 101
 102 zw 5 117 110 100 101 102 zw 5 117 110 100 101 102 zw 5 117
 110 100 101 102 zw 5 117 110 100 101 102 zw 5 117 110 100 101
 102 zw 5 117 110 100 101 102 zw 5 117 110 100 101 102 zw 5 117
 110 100 101 102 zw 5 117 110 100 101 102 zw 5 117 110 100 101
 102 zw 5 117 110 100 101 102 zw 5 117 110 100 101 102 zw 5 117
 110 100 101 102 zw 5 117 110 100 101 102 zw 5 117 110 100 101
 102 zw 5 117 110 100 101 102 zw 5 117 110 100 101 102 zw 5 117
 110 100 101 102 zw 5 117 110 100 101 102 zw 5 117 110 100 101
 102 zw 5 117 110 100 101 102 zw 5 117 110 100 101 102 zw 5 117
 110 100 101 102 zw 5 117 110 100 101 102 zw 5 117 110 100 101
 102 zw 5 117 110 100 101 102 zw 5 117 110 100 101 102 zw 5 117
 110 100 101 102 zw 5 117 110 100 101 102 zw 5 117 110 100 101
 102 zw 5 117 110 100 101 102 zw 5 117 110 100 101 102 zw 5 117
 110 100 101 102 zw 5 117 110 100 101 102 zw 5 117 110 100 101
 102 zw 5 117 110 100 101 102 zw 5 117 110 100 101 102 zw 5 117
 110 100 101 102 zw 5 117 110 100 101 102 zw 5 117 110 100 101
 102 zw 5 117 110 100 101 102 zw 5 117 110 100 101 102 zw 5 117
 110 100 101 102 zw 5 117 110 100 101 102 zw 5 117 110 100 101
 102 zw 5 117 110 100 101 102 zw 5 117 110 100 101 102 zw 5 117
 110 100 101 102 zw 5 117 110 100 101 102 zw 5 117 110 100 101
 102 zw 5 117 110 100 101 102 zw 5 117 110 100 101 102 zw 5 117
 110 100 101 102 zw 5 117 110 100 101 102 zw 5 117 110 100 101
 102 zw 5 117 110 100 101 102 zw 5 117 110 100 101 102 zw 5 117
 110 100 101 102 zw 5 117 110 100 101 102 zw 5 117 110 100 101
 102 zw 5 117 110 100 101 102 zw 5 117 110 100 101 102 zw 5 117
 110 100 101 102 zw 5 117 110 100 101 102 zw 5 117 110 100 101
 102 zw 5 117 110 100 101 102 zw 5 117 110 100 101 102 zw 5 117
 110 100 101 102 zw 5 117 110 100 101 102 zw 5 117 110 100 101
 102 zw 5 117 110 100 101 102 zw 5 117 110 100 101 102 zw 5 117
 110 100 101 102 zw 5 117 110 100 101 102 zw 5 117 110 100 101
 102 zw 5 117 110 100 101 102 zw 5 117 110 100 101 102 zw 5 117
 110 100 101 102 zw 5 117 110 100 101 102 zw 5 117 110 100 101
 102 zw 5 117 110 100 101 102 zw 5 117 110 100 101 102 zw 5 117
 110 100 101 102 zw 5 117 110 100 101 102 zw 5 117 110 100 101
 102 zw 5 117 110 100 101 102 zw 5 117 110 100 101 102 zw 5 117
 110 100 101 102 zw 5 117 110 100 101 102 za zl 4 0 15 0 8 42
 42 42 42 42 42 42 42 42 42 42 42 42 42 42 42 42 32 32 43 32 32
 32 43 32 43 32 98 32 43 32 42 42 32 32 98 32 32 32 32 32 32 98
 32 32 32 32 42 42 32 32 32 32 32 32 32 32 32 32 32 98 32 32 42
 42 32 32 43 98 32 43 32 32 32 32 32 43 32 32 42 42 32 32 32 32
 32 32 98 32 32 32 32 32 32 32 42 42 32 32 32 32 32 32 43 32 32
 32 32 43 32 32 42 42 32 32 32 32 32 32 32 32 43 32 32 32 32 32
 42 42 42 42 42 42 42 42 42 42 42 42 42 42 42 42 42 zw 5 117 110
 100 101 102 zw 5 117 110 100 101 102 zw 5 117 110 100 101 102
 zw 5 117 110 100 101 102 zl 0 0 0
1 102 zw 5 117 110 100 101
 102 zw 5 117 110 100 101 102 zl 0 0 0
 zw 5 117 110 100 101 102 zw 5 117 110 100 101
 102 zw 5 117 110 100 101 102 zw 5 117 110 100 101 102 zw 5 117
 110 100 gworld3_objects                                                                                     100705  017064  000205  00000001604 05427665562 010404  0                                                                                                     47426                                                                                    1  0                                                                                                                                                                 /*  GWORLD3_OBJECTS.P  */


section $-objects;


lib pb_objects.p;


;;; Called after bug has moved and world has been updated with its action.
;;;
define my_update();
    lvars i, j, id;

    for i from 0 to bw_world_width($-eden$-world)-1 do
        for j from 0 to bw_world_height($-eden$-world)-1 do
            ($-eden$-world.$-worlds$-world_contents)(i,j) -> id;
            $-worlds$-message( [update], id, i, j );
        endfor;
    endfor;

enddefine;


define bomb( message, id, x, y );
    lvars message, id, x, y;
    lvars i, j;

    switchon message
    case =[update] then
        if distance( x, y, bug_xW(), bug_yW() ) < 1 then
            kill( 'You have been blown up by the bomb!' );
        endif;
    else
        portable( message, id, x, y );
    endswitchon
enddefine;
define_object( "bomb", bomb, `b` );


endsection;
s$-world_contents)(i,j) -> id;
            $-worlds$-message( [update], id, i, j );
        endfor;
    endfor;

enddefine;


define my_line1() -> items -> format;
    lvars formagworld3_objects.p                                                                                   100705  017064  000205  00000001604 05427665562 010642  0                                                                                                     47426                                                                                    1  0                                                                                                                                                                 /*  GWORLD3_OBJECTS.P  */


section $-objects;


lib pb_objects.p;


;;; Called after bug has moved and world has been updated with its action.
;;;
define my_update();
    lvars i, j, id;

    for i from 0 to bw_world_width($-eden$-world)-1 do
        for j from 0 to bw_world_height($-eden$-world)-1 do
            ($-eden$-world.$-worlds$-world_contents)(i,j) -> id;
            $-worlds$-message( [update], id, i, j );
        endfor;
    endfor;

enddefine;


define bomb( message, id, x, y );
    lvars message, id, x, y;
    lvars i, j;

    switchon message
    case =[update] then
        if distance( x, y, bug_xW(), bug_yW() ) < 1 then
            kill( 'You have been blown up by the bomb!' );
        endif;
    else
        portable( message, id, x, y );
    endswitchon
enddefine;
define_object( "bomb", bomb, `b` );


endsection;

        $-eden$-time -> faeces_states(id);
    case =[update] then
        if faeces_states(id) < $-eden$-time-10 then
            destroy(id)
        endif
    else
        portgworld4                                                                                             100705  017064  000205  00000000360 05427665562 006672  0                                                                                                     47426                                                                                    1  0                                                                                                                                                                 !  gworld4

gworld4_objects
        ****************
        *+       +   + *
        *  B           *
        * +         +  *
        *    b  +      *
        *  +       b   *
        *      +     + *
        ****************
;
food -> old_food;
define food(message,id,x,y);
    lvars message, id, x, y;
    switchon message
    case =[use] then
        old_food(message,id,x,y);
        $-eden$-time -> __last_eat_time;
        true -> __smelly;
    else
        old_food(message,id,x,y);
    endswitchon;
endgworld4.w                                                                                           100705  017064  000205  00000007742 05427665563 007153  0                                                                                                     47426                                                                                    1  0                                                                                                                                                                  zc world zl 0 zl 1 zl 2 3 5 zw 5 117 110 100 101 102 zs 17 103
 119 111 114 108 100 52 95 111 98 106 101 99 116 115 46 112 zw 5
 117 110 100 101 102 zw 5 117 110 100 101 102 16 8 za zl 4 0 15
 0 7 zw 5 117 110 100 101 102 zw 5 117 110 100 101 102 zw 5 117
 110 100 101 102 zw 5 117 110 100 101 102 zw 5 117 110 100 101
 102 zw 5 117 110 100 101 102 zw 5 117 110 100 101 102 zw 5 117
 110 100 101 102 zw 5 117 110 100 101 102 zw 5 117 110 100 101
 102 zw 5 117 110 100 101 102 zw 5 117 110 100 101 102 zw 5 117
 110 100 101 102 zw 5 117 110 100 101 102 zw 5 117 110 100 101
 102 zw 5 117 110 100 101 102 zw 5 117 110 100 101 102 zw 5 117
 110 100 101 102 zw 5 117 110 100 101 102 zw 5 117 110 100 101
 102 zw 5 117 110 100 101 102 zw 5 117 110 100 101 102 zw 5 117
 110 100 101 102 zw 5 117 110 100 101 102 zw 5 117 110 100 101
 102 zw 5 117 110 100 101 102 zw 5 117 110 100 101 102 zw 5 117
 110 100 101 102 zw 5 117 110 100 101 102 zw 5 117 110 100 101
 102 zw 5 117 110 100 101 102 zw 5 117 110 100 101 102 zw 5 117
 110 100 101 102 zw 5 117 110 100 101 102 zw 5 117 110 100 101
 102 zw 5 117 110 100 101 102 zw 5 117 110 100 101 102 zw 5 117
 110 100 101 102 zw 5 117 110 100 101 102 zw 5 117 110 100 101
 102 zw 5 117 110 100 101 102 zw 5 117 110 100 101 102 zw 5 117
 110 100 101 102 zw 5 117 110 100 101 102 zw 5 117 110 100 101
 102 zw 5 117 110 100 101 102 zw 5 117 110 100 101 102 zw 5 117
 110 100 101 102 zw 5 117 110 100 101 102 zw 5 117 110 100 101
 102 zw 5 117 110 100 101 102 zw 5 117 110 100 101 102 zw 5 117
 110 100 101 102 zw 5 117 110 100 101 102 zw 5 117 110 100 101
 102 zw 5 117 110 100 101 102 zw 5 117 110 100 101 102 zw 5 117
 110 100 101 102 zw 5 117 110 100 101 102 zw 5 117 110 100 101
 102 zw 5 117 110 100 101 102 zw 5 117 110 100 101 102 zw 5 117
 110 100 101 102 zw 5 117 110 100 101 102 zw 5 117 110 100 101
 102 zw 5 117 110 100 101 102 zw 5 117 110 100 101 102 zw 5 117
 110 100 101 102 zw 5 117 110 100 101 102 zw 5 117 110 100 101
 102 zw 5 117 110 100 101 102 zw 5 117 110 100 101 102 zw 5 117
 110 100 101 102 zw 5 117 110 100 101 102 zw 5 117 110 100 101
 102 zw 5 117 110 100 101 102 zw 5 117 110 100 101 102 zw 5 117
 110 100 101 102 zw 5 117 110 100 101 102 zw 5 117 110 100 101
 102 zw 5 117 110 100 101 102 zw 5 117 110 100 101 102 zw 5 117
 110 100 101 102 zw 5 117 110 100 101 102 zw 5 117 110 100 101
 102 zw 5 117 110 100 101 102 zw 5 117 110 100 101 102 zw 5 117
 110 100 101 102 zw 5 117 110 100 101 102 zw 5 117 110 100 101
 102 zw 5 117 110 100 101 102 zw 5 117 110 100 101 102 zw 5 117
 110 100 101 102 zw 5 117 110 100 101 102 zw 5 117 110 100 101
 102 zw 5 117 110 100 101 102 zw 5 117 110 100 101 102 zw 5 117
 110 100 101 102 zw 5 117 110 100 101 102 zw 5 117 110 100 101
 102 zw 5 117 110 100 101 102 zw 5 117 110 100 101 102 zw 5 117
 110 100 101 102 zw 5 117 110 100 101 102 zw 5 117 110 100 101
 102 zw 5 117 110 100 101 102 zw 5 117 110 100 101 102 zw 5 117
 110 100 101 102 zw 5 117 110 100 101 102 zw 5 117 110 100 101
 102 zw 5 117 110 100 101 102 zw 5 117 110 100 101 102 zw 5 117
 110 100 101 102 zw 5 117 110 100 101 102 zw 5 117 110 100 101
 102 zw 5 117 110 100 101 102 zw 5 117 110 100 101 102 zw 5 117
 110 100 101 102 zw 5 117 110 100 101 102 zw 5 117 110 100 101
 102 zw 5 117 110 100 101 102 zw 5 117 110 100 101 102 zw 5 117
 110 100 101 102 zw 5 117 110 100 101 102 zw 5 117 110 100 101
 102 zw 5 117 110 100 101 102 zw 5 117 110 100 101 102 zw 5 117
 110 100 101 102 za zl 4 0 15 0 7 42 42 42 42 42 42 42 42 42 42
 42 42 42 42 42 42 42 32 32 32 32 32 32 43 32 32 32 32 32 43 32
 42 42 32 32 43 32 32 32 32 32 32 32 98 32 32 32 42 42 32 32 32
 32 98 32 32 43 32 32 32 32 32 32 42 42 32 43 32 32 32 32 32 32
 32 32 32 43 32 32 42 42 32 32 32 32 32 32 32 32 32 32 32 32 32
 32 42 42 43 32 32 32 32 32 32 32 43 32 32 32 43 32 42 42 42 42
 42 42 42 42 42 42 42 42 42 42 42 42 42 zw 5 117 110 100 101 102
 zw 5 117 110 100 101 102 zw 5 117 110 100 101 102 zw 5 117 110
 100 101 102 zl 0 0 0
 5 117 110 100 101 102 zw 5 117 110 100 101
 102 zw 5 117 110 100 101 102 zw 5 117 110 100 101 102 zw 5 117
 110 100 101 102 zw 5gworld4_objects.p                                                                                   100705  017064  000205  00000001604 05427665563 010644  0                                                                                                     47426                                                                                    1  0                                                                                                                                                                 /*  GWORLD4_OBJECTS.P  */


section $-objects;


lib pb_objects.p;


;;; Called after bug has moved and world has been updated with its action.
;;;
define my_update();
    lvars i, j, id;

    for i from 0 to bw_world_width($-eden$-world)-1 do
        for j from 0 to bw_world_height($-eden$-world)-1 do
            ($-eden$-world.$-worlds$-world_contents)(i,j) -> id;
            $-worlds$-message( [update], id, i, j );
        endfor;
    endfor;

enddefine;


define bomb( message, id, x, y );
    lvars message, id, x, y;
    lvars i, j;

    switchon message
    case =[update] then
        if distance( x, y, bug_xW(), bug_yW() ) < 2 then
            kill( 'You have been blown up by the bomb!' );
        endif;
    else
        portable( message, id, x, y );
    endswitchon
enddefine;
define_object( "bomb", bomb, `b` );


endsection;
w 5 117 110 100 101
 102 zw 5 117 110 100 101 102 zl 0 0 0
 zw 5 117 110 100 101 102 zw 5 117 110 100 101
 102 zw 5 117 110 100 101 102 zw 5 117 110 100 101 102 zw 5 117
 110 100 gworld5                                                                                             100705  017064  000205  00000000360 05427665563 006674  0                                                                                                     47426                                                                                    1  0                                                                                                                                                                 !  gworld5

gworld5_objects
        ****************
        *  w           *
        *          +   *
        *      B       *
        *              *
        *  +       W   *
        *              *
        ****************
en$-world)-1 do
        for j from 0 to bw_world_height($-eden$-world)-1 do
            ($-eden$-world.$-worlds$-world_contents)(i,j) -> id;
            $-worlds$-message( [update], id, i, j );
        endfor;
    endfor;

enddefine;


define bomb( message, id, x, y );
    lvars messgworld5.w                                                                                           100705  017064  000205  00000007744 05427665563 007156  0                                                                                                     47426                                                                                    1  0                                                                                                                                                                  zc world zl 0 zl 1 zl 2 7 4 zw 5 117 110 100 101 102 zs 17 103
 119 111 114 108 100 53 95 111 98 106 101 99 116 115 46 112 zw 5
 117 110 100 101 102 zw 5 117 110 100 101 102 16 8 za zl 4 0 15
 0 7 zw 5 117 110 100 101 102 zw 5 117 110 100 101 102 zw 5 117
 110 100 101 102 zw 5 117 110 100 101 102 zw 5 117 110 100 101
 102 zw 5 117 110 100 101 102 zw 5 117 110 100 101 102 zw 5 117
 110 100 101 102 zw 5 117 110 100 101 102 zw 5 117 110 100 101
 102 zw 5 117 110 100 101 102 zw 5 117 110 100 101 102 zw 5 117
 110 100 101 102 zw 5 117 110 100 101 102 zw 5 117 110 100 101
 102 zw 5 117 110 100 101 102 zw 5 117 110 100 101 102 zw 5 117
 110 100 101 102 zw 5 117 110 100 101 102 zw 5 117 110 100 101
 102 zw 5 117 110 100 101 102 zw 5 117 110 100 101 102 zw 5 117
 110 100 101 102 zw 5 117 110 100 101 102 zw 5 117 110 100 101
 102 zw 5 117 110 100 101 102 zw 5 117 110 100 101 102 zw 5 117
 110 100 101 102 zw 5 117 110 100 101 102 zw 5 117 110 100 101
 102 zw 5 117 110 100 101 102 zw 5 117 110 100 101 102 zw 5 117
 110 100 101 102 zw 5 117 110 100 101 102 zw 5 117 110 100 101
 102 zw 5 117 110 100 101 102 zw 5 117 110 100 101 102 zw 5 117
 110 100 101 102 zw 5 117 110 100 101 102 zw 5 117 110 100 101
 102 zw 5 117 110 100 101 102 zw 5 117 110 100 101 102 zw 5 117
 110 100 101 102 zw 5 117 110 100 101 102 zw 5 117 110 100 101
 102 zw 5 117 110 100 101 102 zw 5 117 110 100 101 102 zw 5 117
 110 100 101 102 zw 5 117 110 100 101 102 zw 5 117 110 100 101
 102 zw 5 117 110 100 101 102 zw 5 117 110 100 101 102 zw 5 117
 110 100 101 102 zw 5 117 110 100 101 102 zw 5 117 110 100 101
 102 zw 5 117 110 100 101 102 zw 5 117 110 100 101 102 zw 5 117
 110 100 101 102 zw 5 117 110 100 101 102 zw 5 117 110 100 101
 102 zw 5 117 110 100 101 102 zw 5 117 110 100 101 102 zw 5 117
 110 100 101 102 zw 5 117 110 100 101 102 zw 5 117 110 100 101
 102 zw 5 117 110 100 101 102 zw 5 117 110 100 101 102 zw 5 117
 110 100 101 102 zw 5 117 110 100 101 102 zw 5 117 110 100 101
 102 zw 5 117 110 100 101 102 zw 5 117 110 100 101 102 zw 5 117
 110 100 101 102 zw 5 117 110 100 101 102 zw 5 117 110 100 101
 102 zw 5 117 110 100 101 102 zw 5 117 110 100 101 102 zw 5 117
 110 100 101 102 zw 5 117 110 100 101 102 zw 5 117 110 100 101
 102 zw 5 117 110 100 101 102 zw 5 117 110 100 101 102 zw 5 117
 110 100 101 102 zw 5 117 110 100 101 102 zw 5 117 110 100 101
 102 zw 5 117 110 100 101 102 zw 5 117 110 100 101 102 zw 5 117
 110 100 101 102 zw 5 117 110 100 101 102 zw 5 117 110 100 101
 102 zw 5 117 110 100 101 102 zw 5 117 110 100 101 102 zw 5 117
 110 100 101 102 zw 5 117 110 100 101 102 zw 5 117 110 100 101
 102 zw 5 117 110 100 101 102 zw 5 117 110 100 101 102 zw 5 117
 110 100 101 102 zw 5 117 110 100 101 102 zw 5 117 110 100 101
 102 zw 5 117 110 100 101 102 zw 5 117 110 100 101 102 zw 5 117
 110 100 101 102 zw 5 117 110 100 101 102 zw 5 117 110 100 101
 102 zw 5 117 110 100 101 102 zw 5 117 110 100 101 102 zw 5 117
 110 100 101 102 zw 5 117 110 100 101 102 zw 5 117 110 100 101
 102 zw 5 117 110 100 101 102 zw 5 117 110 100 101 102 zw 5 117
 110 100 101 102 zw 5 117 110 100 101 102 zw 5 117 110 100 101
 102 zw 5 117 110 100 101 102 zw 5 117 110 100 101 102 zw 5 117
 110 100 101 102 zw 5 117 110 100 101 102 zw 5 117 110 100 101
 102 zw 5 117 110 100 101 102 zw 5 117 110 100 101 102 zw 5 117
 110 100 101 102 zw 5 117 110 100 101 102 zw 5 117 110 100 101
 102 zw 5 117 110 100 101 102 zw 5 117 110 100 101 102 zw 5 117
 110 100 101 102 za zl 4 0 15 0 7 42 42 42 42 42 42 42 42 42 42
 42 42 42 42 42 42 42 32 32 32 32 32 32 32 32 32 32 32 32 32 32
 42 42 32 32 43 32 32 32 32 32 32 32 87 32 32 32 42 42 32 32 32
 32 32 32 32 32 32 32 32 32 32 32 42 42 32 32 32 32 32 32 32 32
 32 32 32 32 32 32 42 42 32 32 32 32 32 32 32 32 32 32 43 32 32
 32 42 42 32 32 119 32 32 32 32 32 32 32 32 32 32 32 42 42 42
 42 42 42 42 42 42 42 42 42 42 42 42 42 42 zw 5 117 110 100 101
 102 zw 5 117 110 100 101 102 zw 5 117 110 100 101 102 zw 5 117
 110 100 101 102 zl 0 0 0
 100 101 102 zw 5 117 110 100 101 102 zw 5 117 110 100 101
 102 zw 5 117 110 100 101 102 zw 5 117 110 100 101 102 zw 5 117
 110 gworld5_objects.p                                                                                   100705  017064  000205  00000014514 05427665564 010652  0                                                                                                     47426                                                                                    1  0                                                                                                                                                                 section $-objects => thirst,hunger;


/*
Standard objects
----------------
*/


lib pb_objects.p;


/*
Physiology
----------
*/


vars __hunger, __thirst, __sick;


define my_start1();
    0 -> __hunger;
    50 -> __thirst;
    0 -> __sick;
    0 ->> water_count -> food_count;
    80 -> vedlinemax;
enddefine;


define add_thirst(t);
    lvars t;
    t + __thirst -> __thirst;
    if __thirst > 400 then
        kill( 'You have died of thirst!' );
    endif;
    max( __thirst, 0 ) -> __thirst;
enddefine;


define add_hunger(h);
    lvars h;
    h + __hunger -> __hunger;
    if __hunger > 400 then
        kill( 'You have died of hunger!' );
    endif;
    max( __hunger, 0 ) -> __hunger;
enddefine;


define add_sickness(s);
    lvars s;
    s + __sick -> __sick;
    if __sick > 15 then
        kill( 'You have died of sickness!' );
    endif;
    max( __sick, 0 ) -> __sick;
enddefine;


;;; Called after bug has moved and world has been updated with its action.
;;;
define my_update();
    lvars i, j, id;

    appproperty( $-worlds$-id_to_location,
                 procedure(id,loc);
                     lvars id,loc;
                     lvars i, j;
                     if loc = "inventory" then
                         bug_xW() -> i; bug_yW() -> j;
                     else
                         loc(1) -> i; loc(2) -> j;
                     endif;
                     $-worlds$-message( [update], id, i, j );
                 endprocedure
               );

    if member( $-eden$-last_action, [forward,back,left,right] ) then
        add_hunger(10);
    endif;
    add_hunger(1);

    if member( $-eden$-last_action, [forward,back,left,right] ) then
        add_thirst(10);
    endif;
    add_thirst(2);

    add_sickness(-1);
enddefine;


define my_line1() -> items -> format;
    lvars format, items;
    'Action: ~10A  Facing: ~8APosition: ~7AThirst: ~3A Sick: ~3A' -> format;
    [% trunc($-eden$-last_action,10),
       direction(),
       '('><bug_xW()><','><bug_yW()><')',
       __thirst,
       trunc(__sick,2)
    %] -> items;
enddefine;


define my_line2() -> items -> format;
    lvars format, items;
    lvars s;
    'Inventory: ~8A Here: ~8A  Time: ~7A    Hunger: ~3A' -> format;
    [% object_name(inventory()),
       object_name(object_at_bug()),
       $-eden$-time,
       __hunger
    %] -> items;
enddefine;


/*
Food
----
*/


vars food_ages = newproperty( [], 5, undef, true );
vars food_count;


vars old_food;
food -> old_food;
define food(message,id,x,y,bad);
    lvars message, id, x, y, bad;
    switchon message
    case =[new] then
        $-eden$-time -> food_ages(id);
        1 + food_count -> food_count;
    case =[update] then
        if food_ages(id) < $-eden$-time-50 then
            destroy(id);
            food_count - 1 -> food_count;
        elseif food_ages(id) < $-eden$-time-40 then
            destroy(id);
            new(`-`) -> id;
            place( id, [%x,y%] );
        endif;
    case =[use] then
        old_food(message,id,x,y);
        add_hunger(-300);
        if bad then
            add_sickness(15);
        endif;
    else
        old_food(message,id,x,y);
    endswitchon;
enddefine;
define_object( "food", food(%false%), `+` );
define_object( "bad_food", food(%true%), `-` );


/*
Cleaning
--------
*/


vars water_ages = newproperty( [], 5, undef, true );
vars water_count;


define water(message,id,x,y,bad);
    lvars message, id, x, y, bad;
    switchon message
    case =[new] then
        $-eden$-time -> water_ages(id);
        1 + water_count -> water_count;
    case =[update] then
        if water_ages(id) < $-eden$-time-50 then
            destroy(id);
            water_count - 1 -> water_count;
        endif;
    case =[use] then
        add_thirst(-200);
        if bad then
            add_sickness(15);
        endif;
    case =[defecate] then
        new(`W`) -> newid;
        destroy(id);
        place(newid,[%x,y%]);
        defecate(x,y);
    else
        nothing(message,id,x,y);
    endswitchon;
enddefine;
define_object( "water", water(%false%), `w` );
define_object( "bad_water", water(%true%), `W` );


/*
Excretion
---------
*/


vars faeces_ages = newproperty( [], 5, undef, true );


define faeces(message,id,x,y);
    lvars message, id, x, y;
    switchon message
    case =[new] then
        $-eden$-time -> faeces_ages(id);
    case =[update] then
        if faeces_ages(id) < $-eden$-time-10 then
            destroy(id)
        endif
    else
        portable(message,id,x,y);
    endswitchon;
enddefine;
define_object( "faeces", faeces, `f` );


vars old_nothing;
nothing -> old_nothing;
define nothing(message,id,x,y);
    lvars message, id, x, y;
    lvars r, newid;
    switchon message
    case =[update] then
        if object_at(x,y) = ` ` then
            random(100) -> r;
            if r <= 1 and water_count<5 then
                new(`w`) -> newid;
                place( newid, [%x,y%] );
            elseif r <= 2 and food_count<5 then
                new(`+`) -> newid;
                place( newid, [%x,y%] );
            endif;
        endif;
    case =[defecate] then
        if object_at(x,y) = ` ` then
            old_nothing(message,id,x,y);
            new(`f`) -> newid;
            destroy(id);
            place(newid,[%x,y%]);
            defecate(x,y);
        endif;
    else
        old_nothing(message,id,x,y);
    endswitchon;
enddefine;
define_object( "nothing", nothing, ` ` );


define defecate(x,y);
    lvars x, y;
    add_thirst(20);
enddefine;


/*
New actions
-----------
*/


define_action( "defecate" );


/*
Procs
-----
*/


define global thirst(); __thirst enddefine;

define global hunger(); __hunger enddefine;


endsection;


define change_to_pop__(dummy);
    lvars dummy;
    pop_section -> current_section;
enddefine;


:- prolog_language(prolog).

:- prolog_eval(change_to_pop__(0)),
   retractall(( thirst(_) )),
   retractall(( hunger(_) )),
   assert(( thirst(T) :- prolog_eval(apply(valof(thirst)),T) )),
   assert(( hunger(H) :- prolog_eval(apply(valof(hunger)),H) )).

:- prolog_language(pop11).
 102 zw 5 117 110 100 101 102 zw 5 117 110 100 101 102 zw 5 117
 holidaybug.pl                                                                                       100705  017064  000205  00000000742 05427665565 010060  0                                                                                                     47426                                                                                    1  0                                                                                                                                                                 /*  HOLIDAYBUG.PL  */                   


resolve [p,s,r].


stm [ mp,
      hot
    ].


@computer_hacker => @rich.
@management_consultant => @rich.
@mp => @rich.

@hairdresser => @poor.
@teacher => @poor.
@toilet_cleaner => @poor.

@poor => @near.
@rich => @far.

@near, @hot => @costa_del_sol, @done.
@near, @cold => @aberdeen, @done.
@far, @hot => @egypt, @done.
@far, @cold => @switzerland, @done.

@done => exec([forward]), exec([wait]).
w 5 117 110 100 101 102 zw 5 117 110 100 101 102 zw 5 117
 110 100 holidays.pl                                                                                         100705  017064  000205  00000000702 05427665565 007541  0                                                                                                     47426                                                                                    1  0                                                                                                                                                                 /*  HOLIDAYS.PL  */


resolve [r].


stm [ mp,
      hot
    ].


stm_predicates all.


computer_hacker => rich.
management_consultant => rich.
mp => rich.

hairdresser => poor.
teacher => poor.
toilet_cleaner => poor.

poor => near.
rich => far.

near, hot => costa_del_sol, done.
near, cold => aberdeen, done.
far, hot => egypt, done.
far, cold => switzerland, done.

done => exec([forward]), exec([wait]).
 zw 5 117 110 100 101
 102 zw 5 117 110 100 101 102 zw 5 117 110 100 101 102 zw 5 117
 110 100 101 102 init.p                                                                                              100705  017064  000205  00000000000 05427665565 006503  0                                                                                                     47426                                                                                    1  0                                                                                                                                                                 init.pl                                                                                             100705  017064  000205  00000001116 05427673103 006653  0                                                                                                     47426                                                                                    1  0                                                                                                                                                                 :- prolog_language(pop11).


define ADD( dir, list );
    lvars dir, list;
    if not( member(dir,valof(list)) ) then
        dir :: valof(list) -> valof(list);
    endif;
enddefine;


ADD( 'eden$src:', "vedteachlist" );
ADD( 'eden$src:', "vedhelplist" );
ADD( 'eden$src:', "prologliblist" );
ADD( 'eden$src:', "prologliblist" );
ADD( 'eden$src:', "popliblist" );
ADD( 'eden$src:', "popuseslist" );
ADD( 'eden$src:', "vedteachlist" );
ADD( 'eden$src:', "vedhelplist" );

cancel ADD;


5000000 -> popmemlim;

vedvt100( false );

:- prolog_language(prolog).
                                                        100705  017064  000205  00000014514 05427665564 010652  0                                                                                                     47426                                                                                    1  0                                                                                                                                                                 jpkerm.ini                                                                                          100705  017064  000205  00000000740 05427665570 007357  0                                                                                                     47426                                                                                    1  0                                                                                                                                                                 set key \334 \27OM
set key \328 \27Ox
set key \336 \27Or
set key \331 \27Ot
set key \333 \27Ov
set key \315 \27OQ
set key \316 \27OR
set key \319 \10
set key \321 \27OD
set key \322 \27OC
set key \323 \27OA
set key \324 \27OB
set key \311 \27Om
set key \330 \27Ol
set key \4 \27OP\27Ot
set key \5491 \27OP\27Ot
set key \1395 \27OP\27Ot
set key \5 \27OP\27Ou
set key \1423 \27OP\27Ou
set key \6 \27OP\27Ov
set key \1396 \27OP\27Ov
set key \5492 \27OP\27Ov
.
;;;
define my_update();
    lvars i, j, id;

    appprol1.pl                                                                                               100705  017064  000205  00000000344 05427665570 006237  0                                                                                                     47426                                                                                    1  0                                                                                                                                                                 /*  L1.PL  */


resolve [p,s,r].


stm [ likes(mary,wine) ].


stm_predicates all.


likes(mary,wine) => loves(john,mary).
likes(mary,beer) => loves(bill,mary).
loves(_,_) => exec([forward]), exec([right]).
(-1);
enddefine;


define my_line1() -> items -> format;
    lvars format, items;
    'Action: ~10A  Facing: ~8APosition: ~7AThirst: ~3A Sick: ~3A' -> format;
    [% trunc($-eden$-last_action,10),
       direction(),
       '('><bug_xW()><','><bug_yW()><')',
       __thirst,
       trunc(__sick,2)
    %]lib.pl                                                                                              100705  017064  000205  00000075122 05427677102 006471  0                                                                                                     47426                                                                                    1  0                                                                                                                                                                 /*  LIB.PL  */


:- op( 253, fx, [module, public, dynamic, load_with, needs]).
/*  See below for purpose of these.  */


/*
This just makes sure that the directives succeed when called. Under
Poplog v13, failing directives cause an error message to be printed,
which I don't want. In Poplog, when compiling Prolog, this has to come
before the first use of any of these directives.
*/
module X.
public X.
dynamic X.
load_with X.
needs X.
endmodule.


:- module lib.
 
 
:- public lib/1,
          lib/2,
          lib_clearloads/0,
          add_linking_clause/3,
          del_linking_clause/3,
          load/1,
          load_scan/1,
          load_clearscan/0,
          load_writescan/1,
          load_readscan/1.
 
 
/*
SPECIFICATION
-------------
 
This module exports lib/1 and lib/2, for loading library files, and two
predicates for adding and deleting such things as portray or
term_expansion clauses. For more advanced library management, loading
the files necessary to implement given predicates, it exports load/1. It
also defines some operators (see start of module), partly for
compatibility with other module systems, and partly for use by load. See
the documentation file MODULES. for a description of their purpose.
 
 
PUBLIC lib( File+, Pred+ ):
---------------------------
 
File must be an atom naming a Prolog file. If this name doesn't include
a directory, lib will search for the file in the list of library
directories defined by library_directories/1, below; if the name does
include a directory, lib will look for the file there. If the name has
no extension, it will be assumed to be ".PL".
 
If lib finds the file, it will generate the full file name, including
disk, directory, extension, and version, and load it by calling
Pred(File). However, it will not load files it has already loaded.
 
The Pred argument is useful when loading files whose contents must be
translated, such as SDO rules (see SDO.PL).
 
 
PUBLIC lib( FileList+, Pred+ ):
-------------------------------
 
Loads each file in the list. If the file takes the form Name-P, then
P will be used as the loading predicate instead of Pred. Thus,
    lib( [ 'fred.sdo', fred-reconsult, 'bert.sdo' ], sdo_reconsult )
will load the first and third files with sdo_reconsult, but the
second one with reconsult.
 
 
PUBLIC lib( (File-Pred)+ ):
PUBLIC lib( (FileList-Pred)+ ):
-------------------------------
 
As the two argument form, but allows Pred to be specified as part of the
first argument.
 
 
PUBLIC lib( X+ ):
-----------------
 
Equivalent to lib(X,reconsult).
 
 
NOTE: this module relies on modules 'bug' and 'files'. Hence these, and
'lib' itself, are pre-loaded, and 'lib' will not re-load them.
 
 
PUBLIC lib_clearloads:
----------------------
 
Unsets the "file loaded" flags for all files loaded by lib (except for
lib itself, bug, and files).
 
 
PUBLIC lib_clearload( File ):
-----------------------------
 
Unsets the "file loaded" flags for File.
 
 
PUBLIC add_linking_clause( Link+, Pred+, Arity+ ):
PUBLIC del_linking_clause( Link+, Pred+, Arity+ ):
--------------------------------------------------
 
add_linking_clause ensures that there is a clause
    Pred( <ARGS> ) :- Link( <ARGS> )
in your database. Here, <ARGS> denotes a sequence of Arity variables.
 
del_linking_clause ensures that there is _no_ such clause.
 
For example,
    ?- add_linking_clause( term_expansion, expand, 2 ).
will ensure that the clause
    term_expansion(X,Y) :- expand(X,Y)
has been asserted.
 
    ?- del_linking_clause( portray, show, 1 ).
will ensure that there are no clauses for
    portray(X) :- show(X).
 
The use of these is that you can add new clauses for such predicates as
term_expansion and portray. It isn't enough for a module to contain
clauses like
    portray( Record ) :-
        is_record(Record), !, output_record(Record).
because when these are reconsulted, any other clauses for portray will
be wiped out. As Richard O'Keefe suggests, you can instead write
    my_portray( Record ) :-
        is_record(Record), !, output_record(Record).
    ... any other clauses for my_portray ...
and then (if there isn't one already), assert the "linking clause"
    portray( Thing ) :- my_portray( Thing ).
 
add/del_linking_clause automate the business of constructing and
asserting these link definitions. See Chapter 9 of "The Craft of Prolog"
for discussion.
 
 
Notes on use.
-------------         
 
I find two reasons for wanting lib.
 
Firstly, my files do not all live in the same directory. I might have
one directory for trees, arrays and other structures; one for games to
be used by the students; one for sample databases; and so on. It is
convenient to be able to load files without worrying about where they
live. Full VMS filenames are not in any case very elegant things to
type. 'lib' takes care of this by having an internal list of
directories, and running along each directory in turn until it finds the
library file it has been asked to load. This requires testing for file
existence, and so lib depends on the predicates in FILES.PL.
 
Secondly, I like to avoid the ``steering file'' approach to programs.
For many programs, the first file to be loaded is a steering file that
looks like this
    :- consult( 'useful.pl' ).
    :- consult( 'sets.pl' ).
    :- consult( 'lists.pl' ).
    :- consult( 'datetime.pl' ).
    ...
Such an approach is unmodular. If module A needs predicates from
module B, this is A's business and no-one else's. The loading
command for B should be placed inside A. A reader who is concerned
with how A works can then see that it depends on B: no-one else
needs to know. (Having said this, you will see that MASTER.PL
actually is a steering file. This should make things easier for
you, since it shows you immediately all the files you'll need.) 
 
The trouble with doing consult(B) inside A is that if C also needs B,
then the code for B will get loaded twice. If Prolog were a purely
logical language this would not matter, since the logical reading is
unimpaired by duplicating clauses. But of course Prolog isn't, and
loading a predicate twice may have very odd effects. If A and C were
both to reconsult(B), only one copy of the code would be loaded, (Well,
this should be true: under Poplog, you still get two copies. Don't ask
why.) but time would still be wasted in doing the extra reconsult.
 
lib has an anti-duplication flag which avoids this. Before lib loads
a file, it checks a flag to see whether the file has already been
loaded, and if so, does nothing.
 
The anti-duplication flag can come in useful when teaching students. If
you set an exercise, you may want the student to load some supplementary
predicates to use with it. It is nice not to worry about whether they
have already been loaded by the Tutor. By telling students to use lib,
you can ignore this worry; and you also save the student from having to
type directory names and file extensions.
 
This version of lib is adapted from Peter Ross' code in ``Advanced
Prolog''. There is a similar predicate in LIB and LIB2 from the Dec-10
library.
 
 
More advanced predicates
------------------------
 
 
PUBLIC load( Thing+ ):
PUBLIC load( ThingList+ ):
--------------------------
 
Here, Thing (or each element of ThingList) is either
    file(File)  -   File must be a filename suitable for 'lib'.
    Pred        -   assumed if an atom.
    Pred/Arity  -   Pred must be an atom.
 
'load' uses the public, needs, and load_with directives in your library
files to work out which other files are necessary to support the
predicates and files you have asked it to load, and then calls 'lib' to
load each one. It works as follows
1) For each Pred/Arity in the list, replace it by the name of its
   exporting file. Report a bug if more than one file exports the same
   predicate and arity.
2) For each Pred in the list, replace by the name of a file that exports
   that predicate with any arity. Report a bug if the same predicate
   (regardless of arity) is exported by more than one file.
3) Eliminate duplicate filenames and files that have already been loaded
   by lib.
4) Repeat the same process on the needs-lists of each of these files to
   build up the complete list of child files.
5) Perform a topological sort on the resulting list to sort it into
   ascending order. This is necessary because some files may rely on
   operators declared by earlier files. If there is a dependency loop,
   report it and leave the rest of the list unsorted.
 
For load to work, you must first have called load_scan as described
below.
 
 
PUBLIC load_scan( FileList ):
-----------------------------
 
Scans each file in the list and stores the information in its public,
needs, and load_with directives. These are operators declared at the
start of this module, and have the following syntax:
    public Pred/Arity, Pred/Arity, ...
    needs Pred/Arity, Pred/Arity, ...
    load_with Pred.
 
From these, load_scan can work out which predicate (second argument to
'lib') is needed to load each file, and which files are called by the
predicates defined in other files.
 
Note: already-loaded files are not included in the needs information.
If you are building up scans to be saved by load_writescan, you
should therefore call lib_clearloads first.
 
 
PUBLIC load_clearscan:
----------------------
 
Removes the information gathered by load_scan.
 
 
PUBLIC lib_writescan( File+ ):
------------------------------
 
Write the result of a load_scan to File.
 
 
PUBLIC lib_readscan( File+ ):
-----------------------------
 
Read the result of a load_scan to File, overwriting any previous scan
information.
 
 
The Tutor does not use these more advanced predicates, and they
are still experimental. You may or may not find them useful.
*/
 
 
/*
IMPLEMENTATION
--------------

See under specific sections below.
*/




/*
Dynamics.
*/


:- dynamic
   '$already_read' / 1,
   '$export_from' / 2,
   '$file_is_loaded' / 1,
   '$needs_files'/2,
   '$needs_list'/2,
   '$load_with'/2.


/*
Define 'pop_compile' for loading files of Pop-11 code. Remove this if
not using Poplog.
*/
pop_compile(F) :-
    prolog_eval(compile(><('eden$src:',><(F,'')))).

 
:- needs
   bug / 2,
   find_file / 5,
   open_and_reconsult / 2,
   open_input / 2,                     
   open_output / 2.

 
:- reconsult( 'eden$src:bug.pl' ).
:- reconsult( 'eden$src:files.pl' ).
 
 
/*
lib.
----
 
lib uses find_file from module FILES to search for its file amongst a
list of directories. If the file is found, it calls load_library_file.
This checks whether there's already an assertion stating that the file
has been loaded: if not, load_library_file reconsults the file.

The library directories are defined by library_directories below, in the
form used by find_file/5. The list must contain at least one element
(which will usually be either the notation for the current directory, []
at Oxford, or some standard library directory, eden$src etc at Oxford).

Note: you must change the two reconsults above, since they have to have
directories wired in.
*/


library_directories( [ 'eden$src:',
                       '[]'
                     ]
                   ).



/*  find_library_file( File+, FullName?, Status? ):
        Look for library file File in the directories above. If found,
        Status = ok, FullName = its full name (complete with version
        number on VMS); otherwise FullName is undefined and Status
        indicates the error.
*/
find_library_file( File, FullName, Status ) :-
    library_directories( LibraryDirectories ),
    find_file( File, LibraryDirectories, '.pl', FullName, Status ).
 
 
lib( [], _ ) :- !.
 
lib( [File|Files], Pred ) :-
    !,
    lib( File, Pred ),
    lib( Files, Pred ).
 
lib( File-Pred, _ ) :-
    !,
    lib( File, Pred ).
    /*  This one ensures that File-Pred elements in lists over-ride the
        outer Pred.
    */
 
lib( File, ReconsultPred ) :-
    find_library_file( File, FullName, Status ),
    (
        Status \= ok
    ->
        bug( 'lib: file not found', Status )
    ;
        load_library_file( File, FullName, ReconsultPred )
    ).
 
 
lib( X-Pred ) :-
    !,
    lib( X, Pred ).
 
lib( File ) :-
    lib( File, reconsult ).
 
 
lib_clearloads :-
    retractall( '$file_is_loaded'(_) ),
    assert_loaded( bug ),
    assert_loaded( files ),
    assert_loaded( lib ).
 
 
lib_clearload( File ) :-
    retractall( '$file_is_loaded'(File) ),
    assert_loaded( bug ),
    assert_loaded( files ),
    assert_loaded( lib ).
 
 
assert_loaded( File ) :-
    not( '$file_is_loaded'(File) ),
    asserta( '$file_is_loaded'( File ) ).
 
 
:- lib_clearloads.
/*  Calling this now will ensure that bug, files, and lib are marked as
    loaded.
*/
 
 
/*  load_library_file( File+, FullName+, ReconsultPred+ ):
        If File not already loaded, try to do so, and if successful,
        mark it as loaded via '$file_is_loaded'(File). We record
        the short (user-supplied) filenames rather than the file's
        full name; this makes it easier for 'load' to check whether
        its files have been loaded using the same assertions.
*/
load_library_file( File, FullName, ReconsultPred ) :-
    telling( COS ),
    tell( user ),
    seeing( CIS ),
    (
        '$file_is_loaded'( File )
    ->
        write( File ), write( ' already loaded.' ), nl
    ;
        open_library_file( FullName, ReconsultPred, Status ),
        (
            Status \= ok
        ->
            bug( 'lib: file not readable', Status )
        ;
            read_library_file( FullName, ReconsultPred ),
            see( FullName ), seen, see( CIS ),
            /* ... close file.  */
            asserta( '$file_is_loaded'( File ) ),
            write( 'File ' ), write( File ), write( ' reconsulted.' ), nl
        )
    ),
    tell( COS ).
 
 
open_library_file( File, ReconsultPred, Status ) :-
    open_input( File, Status ),
    seeing( CIS ), see( File ), seen, see( CIS ).
    /*  Open the file to find out whether it can be opened, then close
        again ready for ReconsultPred.
    */
 
 
read_library_file( File, ReconsultPred ) :-
    Goal =.. [ ReconsultPred, File ],
    call( Goal ).
 
 
/*
Linking clauses.
----------------
 
The definitions of add/del_linking_clause are taken from "The Craft of
Prolog" by Richard O'Keefe.
*/
 
 
add_linking_clause( Link, Pred, Arity ) :-
    '$make_goal'( Link, Arity, Head ),
    '$make_goal'( Pred, Arity, Body ),
    Head =.. [ _ | Args ],
    Body =.. [ _ | Args ],
    /*  to ensure that they share their variables  */
    (
        clause( Head, Body )
    ->
        true
    ;
        assert(( Head:-Body ))
    ).
 
 
del_linking_clause( Link, Pred, Arity ) :-
    '$make_goal'( Link, Arity, Head ),
    '$make_goal'( Pred, Arity, Body ),
    (
        retract(( Head:-Body )),
        fail
    ;
        true
    ).
 
 
'$make_goal'( Pred, Arity, Head ) :-
    functor( Head, Pred, Arity ).
 
 
/*
Scanning the files.
-------------------
 
Meaning of assertions:
 
    '$already_read'(F)      - F has been scanned.
    '$export_from'(F,P/A)   - F exports P/A.
    '$load_with'(F,P)       - F should be loaded by calling P(F).
    '$needs_list'(F,L)      - F's needs-list is L.
    '$needs_files'(F,Files) - F needs Files.
 
The final two will not exist at the same time.
 
Scanning operates in two phases. The first, tabulate_files_transports,
reads the exports and needs-lists. The second, convert_needs_lists,
converts the needs-lists as described above under "load", by calling
needs_list_to_needs_files. This can't be done until the exports are all
recorded, since we have to go from predicates to their home files.
*/
 
 
load_scan( Files ) :-
    tabulate_files_transports( Files ),
    convert_needs_lists.
 
 
load_clearscan :-
    retractall( '$already_read'(_) ),
    retractall( '$export_from'(_,_) ),
    retractall( '$load_with'(_,_) ),
    retractall( '$needs_list'(_,_) ),
    retractall( '$needs_files'(_,_) ).
 
 
load_writescan( F ) :-
    open_output( F, Status ),
    (
        Status = ok
    ->
        '$save_facts'( '$export_from'(_,_) ),
        '$save_facts'( '$load_with'(_,_) ),
        '$save_facts'( '$needs_files'(_,_) )
    ;
        bug( 'load_writescan: file not writeable', [F] )
    ).
 
 
load_readscan( F ) :-
    open_and_reconsult( F, Status ),
    (
        Status = ok
    ->
        true
    ;
        bug( 'load_readscan: file not readable', [F] )
    ).
 
 
/*  '$save_facts'( Head ):
        Head must be a structure whose arguments are all uninstantiated,
        and represents the head of a procedure. Save all clauses to COS,
        one per line, in reconsultable form. Assumes they are all
        unconditional facts.
*/
'$save_facts'( Head ) :-
    call( Head ),
    writeq( Head ), write('.'), nl,
    fail.
 
'$save_facts'( _ ).
 
 
/*
Reading public, load_with, and needs directives.
------------------------------------------------
 
This is the guts of load_scan.             
*/
 
 
/*  tabulate_files_transports( Files+ ):
        Read and record the directives for a list of files.
*/
tabulate_files_transports( [] ) :- !.
 
tabulate_files_transports( [File|Files] ) :-
    tabulate_file_transports( File ),
    tabulate_files_transports( Files ).
 
 
/*  tabulate_file_transports( File+ ):
        Read and record the directives for one file.
*/
tabulate_file_transports( File ) :-
    telling( COS ),
    tell( user ), write( 'Scanning exports and imports for ' ), write( File ), nl,
    find_library_file( File, FullName, Status ),
    (
        Status = ok
    ->
        read_file_transports( File, FullName )
    ;
        bug( 'load_scan: file not found', Status )
    ),
    write( 'Finished scanning ' ), write( File ), nl,
    tell( COS ).
 
 
/*  read_file_transports( File+, Fullname+ ):
        Read and record the directives for one file, if it has not
        already been scanned.
*/
read_file_transports( ShortName, FullName ) :-
    (
        '$already_read'( ShortName )
    ->
        true
    ;
        open_input( FullName, Status ),
        (
            Status = ok
        ->
            asserta( '$already_read'( ShortName ) ),
            read_file_transports_1( ShortName ),
            seeing( CIS ), see( FullName ), seen, see( CIS )
        ;
            bug( 'load_scan: file not reconsultable', Status )
        )
    ).
 
 
read_file_transports_1( File ) :-
    read( X ),
    do_putative_transports( File, X ).
 
 
/*  do_putative_transports( File+, X+ ):
        Process term X from File. File is the file's original
        (user-supplied) name, used when creating the assertions.
*/
do_putative_transports( File, end_of_file ) :-
    (
        not( '$needs_list'(File,_) )
    ->
        asserta( '$needs_list'( File, [] ) )
    ;
        true
    ).
 
do_putative_transports( File, (:-(public(Preds))) ) :-
    !,
    do_exports( File, Preds ),
    read_file_transports_1( File ).
 
do_putative_transports( File, (:-(load_with(Pred))) ) :-
    !,
    asserta( '$reconsult_with'( File, Pred ) ),
    read_file_transports_1( File ).
 
do_putative_transports( File, (:-(needs(Things))) ) :-
    !,
    '$comma_list_to_list'( Things, Things_ ),
    asserta( '$needs_list'( File, Things_ ) ),
    read_file_transports_1( File ).
 
do_putative_transports( File, _ ) :-
    read_file_transports_1( File ).
 
 
/*  do_exports( File+, X+ ):
        X+ is either a single P/A structure, or a comma-list (
        part or all of the 'public' directive's argument).
*/
do_exports( File, (E1,E2) ) :-
    !,
    do_exports( File, E1 ),
    do_exports( File, E2 ).
 
do_exports( File, Pred ) :-
    asserta( '$export_from'(File,Pred) ).
 
 
/*  convert_needs_lists:
        Replace all '$needs_list' assertions by equivalent
        '$needs_files' ones.
*/
convert_needs_lists :-
    retract( '$needs_list'( File, Things ) ),
    !,
    needs_list_to_needs_files( Things, [], Files ),
    asserta( '$needs_files'( File, Files ) ),
    convert_needs_lists.
 
convert_needs_lists.
 
 
/*
load.
-----
 
The method behind load was described in the specification part above. In
terms of predicates, it first calls
    needs_list_to_needs_files( ThingList, [], Files )
to convert the list of things into a list of filenames. The mapping is
    file(File)  -> File
    Pred/Arity  -> the exporting file
    Pred        -> the exporting file
 
The latter two are obtained from the '$export_from' assertions created by
load_scan. Duplicate filenames are removed; there may be a lot of these,
since several predicates might come from the same file.
 
It then does
    non_loaded_files_for( Files, Children )
to get, in Children, a list of all the files needed by Files
(technically speaking, the transitive closure of the relation defined by
the needs-lists of Files and their sons). This is done by breadth-first
search. The reason for using breadth-first is that, originally, I
obtained the needs-lists by reading them from the files in the "find
children" stage of search, rather than relying on the results of
load_scan. Doing a depth-first, which is easier, entailed having several
files open simultaneously ( F, and one of the files mentioned in its
needs-list, and one of the files mentioned in that one's needs-list...)
and this caused Poplog to run out of memory. Probably a system bug, but
I had to alter it so that only one file was open at any time. I have
kept the same structure, even though no longer necessary.
 
Having got these files, non_loaded_files_for then does a topological
sort, trying to order them so that if F1 needs F2, F2 appears earlier in
Children than F1. This may fail if the dependency graph contains a loop:
in that case, non_loaded_files_for gives a warning and leaves the order
of the looped part of the network, and the files above it, unchanged.
 
None of these algorithms are efficient. To make them so would require
more auxiliary predicates - perhaps the DEC10 graphs module - than I
want to include in a module this basic.
*/
 
 
load( Thing ) :-
    Thing \= [], Thing \= [_|_],
    !,
    load( [Thing] ).
    /*  This clause if Thing is not a list.  */
 
load( ThingList ) :-
    needs_list_to_needs_files( ThingList, [], Files ),
    non_loaded_files_for( Files, Children ),
    lib( Children ).
 
 
/*  needs_list_to_needs_files( List+, SoFar+, Files- ):
        The result of converting needs-list List to a list of
        files and appending to SoFar is Files.
*/
needs_list_to_needs_files( [], Files0, Files0 ) :- !.
 
needs_list_to_needs_files( [X|T], Files0, Files ) :-
    needs_thing_to_needs_file( X, File ),
    add_file( File, Files0, Files1 ),
    needs_list_to_needs_files( T, Files1, Files ).
 
 
/*  needs_thing_to_needs_file( Thing+, File- ):
        Thing is a predicate name, P/A, or file(File), as described
        above.
        File is the corresponding file.            
*/
needs_thing_to_needs_file( P/A, File ) :-
    !,
    needs_pa_to_needs_file( P, A, File ).
 
needs_thing_to_needs_file( file(File), File ) :-
    !.
 
needs_thing_to_needs_file( P, File ) :-
    atom( P ),
    !,
    needs_p_to_needs_file( P, File ).
 
 
needs_pa_to_needs_file( P, A, File ) :-
    '$export_from'( File1, P/A ),
    '$export_from'( File2, P/A ),
    File1 \= File2,
    !,
    bug( 'load_scan: predicate exported from more than one file',
         [ P/A-File1, P/A-File2 ]
    ).
 
needs_pa_to_needs_file( P, A, File ) :-
    '$export_from'( File, P/A ),
    !.
 
needs_pa_to_needs_file( P, A, _ ) :-
    bug( 'load_scan: predicate not in export list', [P/A] ).
 
 
needs_p_to_needs_file( P, File ) :-
    '$export_from'( File1, P/A1 ),
    '$export_from'( File2, P/A2 ),
    File1 \= File2 ,
    !,
    bug( 'load_scan: predicate exported from more than one file',
         [P/A1-File1, P/A2-File2]
    ).
 
needs_p_to_needs_file( P, File ) :-
    '$export_from'( File, P/A ),
    !.
 
needs_p_to_needs_file( P, _ ) :-
    bug( 'load_scan: predicate not in export list', [P] ).
 
 
/*  add_file( File+, SoFar+, Files- ):
        If File hasn't been loaded by lib, and is not already in SoFar,
        add it.
*/
add_file( File, Files0, [File|Files0] ) :-
    not( '$file_is_loaded'( File ) ),
    not( '$memberchk'(File,Files0) ),
    !.
 
add_file( File, Files0, Files0 ) :- !.
 
 
/*
Finding all the files.
----------------------
 
This entails a breadth-first search through all the needs-lists,
starting from the files passed as argument to load.
*/
 
 
/*  non_loaded_files_for( Files+, Children- ):
        Children are all the non-loaded files needed by Files,
        sorted in ascending order if there are no dependency loops.
*/
non_loaded_files_for( Files, Children ) :-
    '$bfs'( Files, Arcs, Children0 ),
    tsort( Children0, Arcs, Children ).
 
 
/*  '$bfs'( Files+, Arcs-, Children- ):
        Children is the list of all files needed by Files. Arcs is the
        needs relation, as a list of pairs (Parent,Child).
*/
'$bfs'( Files, Arcs, Children ) :-
    '$bfs'( Files, [], Arcs, Children ).
 
 
/*  '$bfs'( Files+, Visited+, Arcs-, Children- ):
        As above, but Visited is a list of all files whose needs-lists
        have already been examined.
*/
'$bfs'( [], _, [], [] ) :- !.
 
'$bfs'( [File|Rest], Visited, Arcs, Children ) :-
    '$memberchk'( File, Visited ),
    !,
    '$bfs'( Rest, Visited, Arcs, Children ).
 
'$bfs'( [File|Rest], Visited, Arcs, Children ) :-
    '$file_is_loaded'( File ),
    !,
    '$bfs'( Rest, Visited, Arcs, Children ).
 
'$bfs'( [File|Rest], Visited, Arcs1, [File|RestChildren] ) :-
    file_to_needs_files( File, Needs ),
    add_needs( File,Needs, Arcs, Arcs1 ),
    '$unite'( Rest, Needs, New ),
    '$bfs'( New, [File|Visited], Arcs, RestChildren ).
 
 
/*  add_needs( File+, Needs+, ArcsSoFar+, Arcs- ):
        Needs is the files needed by File.
        Add this relation to ArcsSoFar giving Arcs.
*/
add_needs( _, [], L, L ) :- !.
 
add_needs( F, [Need|Needs], L, T ) :-
    add_needs( F, Needs, [(F,Need)|L], T ).
 
 
file_to_needs_files( File, Files ) :-
    '$needs_files'( File, Files ),
    !.
 
file_to_needs_files( File, Files ) :-
    bug( 'load: no needs list for file', [File] ).
 
 
/*
Sorting file dependencies.
--------------------------
 
This uses a topological sort:
    tsort( Nodes+, Arcs+, TotalOrder? ):
TotalOrder is an ordering for the Nodes (a list), consistent with the
partial order given in Arcs. Arcs is a list of pairs (Parent,Child).
 
If Arcs contains a loop, tsort reports it and leaves the rest of the list
unsorted.
 
Example:
    ?- tsort( [c,b,a], [(a,b)], X ).
    X = [a,b,c].
 
The method is based on the fact that any acyclic graph must have at
least one node without children. At any iteration, select this node,
pump it to the output list and discard all related arcs from the graph,
then repeat with the remaining graph.
 
Credits:
Code posted to comp.lang.prolog in June 1992 by
Carlos Lang, M.Sc.,
Maestria en CC Cognocitivas,
Universidad de Costa Rica.
 
``Main strategy suggested in an exercise from Aho et al,
"The Design and Complexity of Computer Algorithms".
 
This code was developed using SWI-Prolog, ported by someone else
to 386.
 
Disclaimer: we have made no attempt whatsoever to provide an
efficient implementation.''
*/
 
 
tsort( [], _, [] ) :- !.
 
tsort( Nodes, Arcs, [N|R] ) :-
    no_child( N, Nodes, Arcs ),
    !,
    '$delete'( Nodes, N, Nodes1 ),
    '$delete'( Arcs, (_,N), Arcs1 ),
    '$delete'( Arcs1, (N,_), Arcs2 ),
    tsort( Nodes1, Arcs2, R ).
 
tsort( Nodes, Arcs, Nodes ) :-
    warning( 'load_scan: loop', [ Nodes, Arcs ] ).
 
 
/*  no_child( N-, Nodes+, Arcs+ ):
        N (in Nodes) has, according to Arcs, no children.               
*/
no_child( N, Nodes, Arcs ) :-
    '$member'( N, Nodes ),
    not( '$memberchk'( (N,_), Arcs ) ).
 
 
/*
Auxiliary predicates.
---------------------
 
The problem with writing the file-dependency analyser is that it needs
several list-handling and other auxiliary predicates. But we don't want
to define stuff that might clash with what the user uses 'load' to load.
Hence give the utilities funny names.
*/
 
 
/*  '$member'( Element+, List+ ):
        What's usually called member.
*/
'$member'(X, [X|_]).
'$member'(X, [_|Y]) :-
    '$member'(X, Y).
 
 
/*  '$memberchk'( Element+, List+ ):
        Deterministic version of '$member'.
*/
'$memberchk'( X, L ) :-
    '$member'( X, L ),
    !.
 
 
/*  '$delete'( List+, Element+, List1- ):
        Deletes all matches of Element from List, producing List1.
 
        Free variables in Element are not bound after the first
        deletion, so
            delete( L, (_,X), L1 )
        (where X is bound) will delete all pairs (_,X) from L.
*/
'$delete'( [], _, [] ) :- !.
 
'$delete'( [H1|T], H2, L ) :-
    not(not(H1=H2)),
    !,
    '$delete'( T, H2, L ).
 
'$delete'( [X|T], H, [X|L] ) :-
    '$delete'( T, H, L ).
 
 
/*  '$unite'( L1+, L2+, L- ):
        L is the union of L1 and L2.
*/
'$unite'( [], L, L ).
'$unite'( [H|R], S, [H|T] ) :-
    not( '$memberchk'(H,S) ),
    !,
    '$unite'( R, S, T ).
'$unite'( [H|R], S, T ) :-
    '$unite'( R, S, T ).
 
 
/*  Usual append. */
'$append'( [], L, L ).
'$append'( [H|R], S, [H|T] ) :-
    '$append'( R, S, T ).
 
 
/*  '$comma_list_to_list'( CommaList+, List- ):
        Converts a "comma list" of the form (a,b,c) into
        a list [a,b,c]. Used when converting needs-lists read
        from file, which are comma-lists.
*/
'$comma_list_to_list'( CommaList, List ) :-
    '$comma_list_to_list'( CommaList, [], List ).
 
 
'$comma_list_to_list'( (A,B), SoFar, Result ) :-
    !,
    '$comma_list_to_list'( B, SoFar, L1 ),
    '$comma_list_to_list'( A, L1, Result ).
 
'$comma_list_to_list'( X, SoFar, [X|SoFar] ).
 
 
:- endmodule.
c' directive's argument).
*/
do_exports( File, (E1,E2) ) :-
    !,
    do_exports( File, E1 ),
    do_exports( File, E2 ).
 
do_exports( File, Pred ) :-
    asserta( '$export_from'(File,Pred) ).
 
 
/*  convert_needs_lists:
        Replace all '$needs_list' assertions by equivalent
        '$needs_files' ones.
*/
convert_needs_lists :-
    retract( '$needs_list'( File, Things ) ),
    !,
    needs_list_to_needs_files( Things, [], Files ),
    asserta( '$needs_files'( File, Files ) ),
    convert_n                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                lists.pl                                                                                            100705  017064  000205  00000014530 05427677456 007071  0                                                                                                     47426                                                                                    1  0                                                                                                                                                                 /*  LISTS.PL  */


:- module lists.

:- public append/3,
          append_n/2,
          islist/1,
          last/2,
          length/2,
          member/2,
          member/3,
          reverse/2,
          rev_append/3,
          nth1/3,
          nth1/4,
          delete/3,
          sublist/3,
          sublist0/2,
          sublist1/2.
 
 
/*
SPECIFICATION
-------------
 
This module defines some common list predicates, giving them their usual
(?) definitions.
 
 
PUBLIC append( L1?, L2?, L3? ):

L3 is the result of appending L2 to L1.


PUBLIC append_n( Lists+, Result ):

Result is the result of appending all elements of Lists together.



PUBLIC rev_append( R+, L+, Result- ):

Result is the result of reversing R and prepending it to L.



PUBLIC islist( L+ ):

L is the null list or something of the form [_|_]. This predicate does
not run all the way down L, checking each element.


PUBLIC last(Last?, List?):

Is true when List is a List and Last is its last element.


PUBLIC length( L?, N? ):

N is the length of list L.


PUBLIC member( Element?, L? ):

Element is a member of L.


PUBLIC member( Element?, L?, Rest? ):

Element is a member of L. Rest is the rest of L.


PUBLIC reverse( L1?, L2? ):

L2 is the result of reversing L1.


PUBLIC nth1( N+, List+, Elem? ):

This is true when Elem is the Nth member of List, counting the first as
element 1. (That is, throw away the first N-1 elements and unify Elem with
the next.) It can only be used to select a particular element given the
list and index.


PUBLIC nth1( N+, List+, Elem?, Rest? ):

This is true when Elem is the Nth member of List, counting the first as
element 1, and Rest is the rest of the list. It can only be used to
select a particular element given the list and index.


PUBLIC delete( List+, Element+, List1- ):

Deletes all matches of Element from List, producing List1.

Free variables in Element are not bound after the first deletion, so
    delete( L, (_,X), L1 )
(where X is bound) will delete all pairs (_,X) from L.


PUBLIC sublist( Sequence?, SubSequence?, Complement? ):

Is true when SubList and Complement are both subsequences of the list
List (the order of corresponding elements being preserved) and every
element of List which is not in SubList is in the Complement and vice
versa. That is,
    length(List) = length(SubList)+length(Complement), e.g.
    sublist([1,2,3,4], [1,3,4], [2]).
This was written to generate subsets and their complements together, but
can also be used to interleave two lists in all possible ways. Note that
if S1 is a subset of S2, it will be generated *before S2 as a SubList
and *after it as a Complement.

N.B. Beware of the order of arguments! I took this version from the
Dec-10 library; I'm sure I've seen versions with the sublist argument
_first_.


PUBLIC sublist0( List+, SubList? ):

Is true when SubList is a subsequence of List, but may be List itself.
Thus sublist0([a,b], [a,b]) is true as well as sublist0([a,b], [a]).


PUBLIC sublist1( List+, SubList? ):

Is true when SubList is a proper subsequence of List, that is it
contains at least one element less. Thus (assuming you have setof and
bagof):
    ?- setof(X, sublist0([a,b,c],X), Xs).
    Xs = [[],[a],[a,b],[a,b,c],[a,c],[b],[b,c],[c]]

    ?- bagof(X, sublist0([a,b,c,d],X), Xs).
    Xs = [[a,b,c,d],[b,c,d],[c,d],[d],[],[c],[b,d],[b],[b,c],[a,c,d],
    [a,d],[a],[a,c],[a,b,d],[a,b],[a,b,c]]
*/


/*
IMPLEMENTATION
--------------
 
As usual, reverse and length use accumulator arguments to make
tail-recursion optimisation possible.

On Poplog, length is already defined, so I've commented out the
definition below. Uncomment it if your system lacks it.
 
The obvious definition of 'last' would be
    last(Last, [Last]) :- !.
    last(Last, [_|List]) :-
        last(Last, List).
 
However (see "The Craft of Prolog" section 6.5.4), Prologs with indexing
execute that less efficiently than they ought, because the indexing
can't distinguish between [_] and [_|_]. I have therefore used O'Keefe's
definition. It runs faster on Poplog too, though for different reasons,
since Poplog does not index the arguments for last_1. As Steve Knight
pointed out to me, in Poplog, you can examine the code for each by
setting pop_show_code to true and then loading.

nth1 and subseq are taken from the DEC-10 library.
*/


append([], L, L).
append([H|R], S, [H|T]) :-
    append(R, S, T).


append_n( Lists, Result ) :-
    append_n( Lists, [], Result ).


append_n( [], Result, Result ) :- !.
append_n( [H|T], SoFar, Result ) :-
    append_n( T, SoFar, SoFar1 ),
    append( H, SoFar1, Result ).


islist([]) :- !.
islist([_|_]).


last( Last, [H|T] ) :-
    last_1( T, H, Last ).
 
last_1( [], Last, Last ) :- !.
last_1( [H|T], _, Last ) :-
    last_1( T, H, Last ).
 
 
/*
length( L, N ) :-
    length( L, 0, N ).
 
length( [], N, N  ) :- !.
length( [H|T], N0, N ) :-
    N1 is N0 + 1,
    length( T, N1, N ).
 */
 
 
member(X, [X|_]).
member(X, [_|Y]) :-
    member(X, Y).
 
 
member(X, [X|T], T).
member(X, [H|Y], [H|Rest]) :-
    member(X, Y, Rest).
 
 
reverse( X, RX ) :-
    reverse( X, [], RX ).
 
reverse( [], R, R ) :- !.
reverse( [X|Y], Z, R ) :-
    reverse( Y, [X|Z], R ).
 
 
rev_append( A, B, C ) :-
    reverse( A, B, C ).
 
 
nth1(1, [Head|_], Head) :- !.
 
nth1(N, [_|Tail], Elem) :-
    M is N-1,
    nth1(M, Tail, Elem).

 
nth1(1, [Head|Tail], Head, Tail) :- !.
 
nth1(N, [Head|Tail], Elem, [Head|Rest]) :-
    M is N-1,
    nth1(M, Tail, Elem, Rest).
 
 
delete( [], _, [] ) :- !.
 
delete( [H1|T], H2, L ) :-
    not(not(H1=H2)),
    /*  This stops H2's variables getting bound.  */
    !,
    delete( T, H2, L ).
 
delete( [X|T], H, [X|L] ) :-
    delete( T, H, L ).


sublist([], [], []).

sublist([Head|Tail], Sbsq, [Head|Cmpl]) :-
    sublist(Tail, Sbsq, Cmpl).

sublist([Head|Tail], [Head|Sbsq], Cmpl) :-
    sublist(Tail, Sbsq, Cmpl).


sublist0(List, List).

sublist0(List, Rest) :-
    sublist1(List, Rest).


sublist1([_|Tail], Rest) :-
    sublist0(Tail, Rest).

sublist1([Head|Tail], [Head|Rest]) :-
    sublist1(Tail, Rest).


:- endmodule.
List+ ):
        What's usually called member.
*/
'$memberload_file.p                                                                                         100705  017064  000205  00000003550 05427665571 007470  0                                                                                                     47426                                                                                    1  0                                                                                                                                                                 /*  LOAD_FILE.P  */


section $-load_file => load_file;


/*
SPECIFICATION
-------------

This module exports a procedure to load a library file. In Eden,
I use it for loading worlds and the code of bugs.


PUBLIC load_file( file, ext, proc, list ):

-file- is the name of a file; it must be a string or word.
-ext- is an extension.
-proc- is a procedure of two arguments.

-load_file- looks for the file in -list-, which must be something like
-popuseslist- or -popliblist-. It examines each directory in turn. If it
finds the file, it calls
    proc( file, fn )
where -fn- is the file's full name, as returned by -readable-, and then
returns. -proc- may leave results on the stack, in which case they'll be
returned by -load_file-. If the file can't be found, -load_file- returns
-false-.

If the file has no extension, the extension is defaulted to -ext-. This
should contain the dot.
*/


/*
IMPLEMENTATION
--------------

I'm sure there's a system routine to do it, but I can't find it. The
code works under VMS, but I don't know about Unix.

Note that the spec in REF SYSIO is wrong. This says that sys_file_match
returns -false- instead of a repeater if the filename is invalid. In
fact, it returns -false- even if the filename is valid, but the file
doesn't exist.
*/


define global load_file( File, Ext, Proc, List );
    lvars File, Ext, Proc, List;               
    lvars Dir, FullName, Repeater;

    for Dir in List do
        sys_file_match( File><'', Dir><'*'><Ext, false, false ) ->
          Repeater;

        if Repeater = false then
            nextloop
        else
            Repeater() -> FullName;
            if FullName /= termin then
                return( Proc( File, FullName ) );
            endif;
        endif;
    endfor;

    return( false );
enddefine;


endsection;
                                                                                                                                                                                                                                                mailedit.com                                                                                        100705  017064  000205  00000001544 05427665571 007662  0                                                                                                     47426                                                                                    1  0                                                                                                                                                                 $ ! Copyright (c) 1987 Digital Equipment Corporation.  All rights reserved.
$ !
$ ! Command procedure to invoke an editor for MAIL.
$ !
$ ! Inputs:
$ !
$ ! P1 = Input file name.
$ ! P2 = Output file name.
$ !
$ ! If MAIL$EDIT is undefined, MAIL will invoke callable EDT.
$ ! If MAIL$EDITis defined to be a command procedure,
$ ! MAIL will create a subprocess to edit the mail.
$ !
$ ! Note that this procedure is run in the context of a subprocess.
$ ! LOGIN.COM is not executed.  However, all process logical names
$ ! and DCL global symbols are copied.
$ !
$ ! The default directory is the same as the parent process
$ !
$ DEFINE /USER SYS$INPUT 'F$TRNLNM("SYS$OUTPUT")'
$ IF P1 .EQS. "" THEN GOTO NOINPUT
$ pop11 "sysinitcomp(); vedinput(veddo(% "name 'p2' %)); popval([ved ^('p1')]);
$ EXIT
$NOINPUT:
$ ved 'P2'
$ EXIT
                                    1  0                                                                                                                                                                 makeeden.com                                                                                        100705  017064  000205  00000002116 05427701027 007622  0                                                                                                     47426                                                                                    1  0                                                                                                                                                                 $ ! MAKEEDEN.COM

$ ! This command file is used under VMS, to build a stand-alone version
$ ! of Eden.

$ ass/user [] poplib:
$ ! Make this point at wherever you want poplib to be when loading.

$ ass/user [] eden$src:
$ ! eden$src is where the source lives.

$  prolog                 

:- prolog_language(pop11).

false -> popgctrace; false -> popsyscall;
5000000 -> popmemlim;

:- prolog_language(prolog).

:- prolog_no_clauses.
:- prolog_syspredicates( on ).

:- reconsult('eden$src:init.pl').

:- reconsult('eden$src:eden.pl').
:- reconsult('eden$src:ps.pl').
:- reconsult('eden$src:ps_compile.pl').
:- reconsult('eden$src:ps_int.pl').
:- reconsult('eden$src:manual_bug.pl').
manual(World) :- eden(manual_bug,World).

:- prolog_syspredicates( off ).
:- prolog_clauses.

:- prolog_eval(apply(valof(sysgarbage))).
:- prolog_eval(apply(valof(sys_lock_heap))).

:- version('Eden Prolog').

:- write('About to save.\n').                               

:- (
save(eden,1) ->
version,
reinitialise,
abort
;
write('Eden saved\n')
).
( N+, List+, Elem?, Rest? ):

This is true when Elem is the Nth member of List, counting the first as
element 1, and Rest is the rest of the list. It can only be used to
select a particular element given the list and index.


PUBLIC delete( List+, Element+, List1- ):

Deletes all matches of Element from List, producing List1.

Free variables in Element are not bound after the first deletion, so
    delete( L, (_,X), L1 )
(where X is bound) will delete all pairs (_,X) from L.


PUBLIC sublist( Sequencemanual_bug.p                                                                                        100705  017064  000205  00000003302 05427665572 007660  0                                                                                                     47426                                                                                    1  0                                                                                                                                                                 /*  MANUAL_BUG.P  */


section $-bug => think, manual_bug;


/*
This is the ``manual bug''. It has no intelligence of its own, but
simply reads and performs actions as you type them.

The prompts for actions are self-explanatory. All replies are one letter
long, and you must not hit RETURN after them.
*/


vars think;/*forward*/


define global manual_bug();
    repeat
        think();
    endrepeat;
enddefine;


define global think();
    lvars keypress;

    bug_message('F-forward B-back L-left R-right G-grab D-drop U-use W-wait O-other Q-quit');

    getkey() -> keypress;
    switchon keypress
    case = `f` then exec([forward])
    case = `b` then exec([back])
    case = `l` then exec([left])
    case = `r` then exec([right])
    case = `g` then exec([grab])
    case = `d` then exec([drop])
    case = `w` then exec([wait])
    case = `u` then exec([use])
    case = `q` then exit_eden()
    case = `o` then exec(other())
    else
        think()
    endswitchon
enddefine;


define other();
    lvars action, mess='', keypress;
    for action in $-worlds$-actions do
        mess >< cons_with consstring {% action(1).lowertoupper %}
             >< '-' >< action >< ' ' -> mess;
    endfor;
    bug_message( mess );
    getkey() -> keypress;

    for action in $-worlds$-actions do
        if action(1)=keypress then
            return( [%action%] )
        endif;
    endfor;
    think();
enddefine;


define getkey();
    if bug_using_ved() then
        rawcharin().uppertolower
    else
        charin().uppertolower
    endif;
enddefine;


/*
define bugdead();
    "rerun"
enddefine;
*/


endsection;
Poplog, you can examine the code for each by
setting pop_show_code to true and then loading.

nth1 and subseq are taken from the DEC-10 library.
*/


append([], L, L).
append([H|R], S, [H|T]) :-
    append(R, S, T).


append_n( Lists, Result ) :-
    append_n( Lists, [], Result ).


append_n( [], Result, Result ) :- !.
append_n( [H|T], SoFar, Result ) :-
    append_n( T, SoFar, SoFar1 ),
    append( H, SoFar1, Result ).


imanual_bug.pl                                                                                       100705  017064  000205  00000000716 05427665572 010042  0                                                                                                     47426                                                                                    1  0                                                                                                                                                                 /*  MANUAL_BUG.PL  */


/*
This is the ``manual bug''. It has no intelligence of its own, but
simply reads and performs actions as you type them.

The prompts for actions are self-explanatory. All replies are one letter
long, and you must not hit RETURN after them.
*/


:- prolog_language(pop11).
needs manual_bug;
:- prolog_language(prolog).


manual_bug :-
    prolog_eval(apply(valof(manual_bug))).


/*
bugdead( _, rerun ).
*/
t(H1=H2)),
    /*  This stops H2's variables getting bound.  */
    !,
    deletmskermit.ini                                                                                        100705  017064  000205  00000001124 05427665573 007722  0                                                                                                     47426                                                                                    1  0                                                                                                                                                                 set parity even
set baud 9600
define vms set se s 1,set rec s 1
set key \334 \27OM
set key \328 \27Ox
set key \336 \27Or
set key \331 \27Ot
set key \333 \27Ov
set key \315 \27OQ
set key \316 \27OR
set key \319 \10
set key \321 \27OD
set key \322 \27OC
set key \323 \27OA
set key \324 \27OB
set key \311 \27Om
set key \330 \27Ol
set key \4 \27OP\27Ot
set key \5491 \27OP\27Ot
set key \1395 \27OP\27Ot
set key \5 \27OP\27Ou
set key \1423 \27OP\27Ou
set key \6 \27OP\27Ov
set key \1396 \27OP\27Ov
set key \5492 \27OP\27Ov
clear
output \b
pause 1
output \13

 load_file;


/*
SPECIFICATION
-------------

This module exports a procedure to load a library file. In Eden,
I use it for loading worlds and the code of bugs.


PUBLIC load_file( file, ext, proc, list ):

-file- is the name of a file; it must be a string or word.
-ext- is an extension.
-proc- is a procedure of two arguments.

-load_file- looks for the file in -list-, which must be something like
-popuseslist- or -popliblist-. It examines each directory in turn. needs.p                                                                                             100705  017064  000205  00000004702 05427665574 006653  0                                                                                                     47426                                                                                    1  0                                                                                                                                                                 /*  NEEDS.P  */


section $-need => needs;


/*
SPECIFICATION
-------------

'needs' is a replacement for 'uses' - see HELP USES. Unlike 'uses', it
does not require its libraries to set a variable of the same name. Hence
it is more convenient to use. Also, it loads all files into the
top-level section, pop-section. This is useful if you 'need' the same
file from inside several different sections, and it isn't itself a
section with an absolute name.


PUBLIC macro needs:

'needs' takes one argument, the name of a file. If it hasn't loaded
the file before, it searches 'popuseslist' for the first directory
containing it. When found, it loads the file, first switching section
to pop_section. Files are given the default extension .P . 
*/


/*
IMPLEMENTATION
--------------

'needs' is a macro which reads one item, the name of a library. It
checks whether it has been called with this before, by looking at
Defined(<library name>): if the library has been previously loaded
by 'needs', this will be true, else false.

If the library hasn't been loaded already, 'needs' does so by calling
'loadlib'. It changes section to pop_section first, and changes it back
after loading.

The code is based on 'uses', but with the addition of section-switching,
and with the use of a property rather than variables for marking whether
a library is already loaded.

There is a HELP file, HELP NEEDS, for this module. Make sure that you
update it if you change anything.          
*/


vars Defined;


if isundef(Defined) then
    newproperty( [], 50, false, true ) -> Defined;
endif;
/*  The check on isundef prevents us reassigning to Defined, and losing
    old values in the table, if the user loads NEEDS.P more than once.
*/


define global macro needs;
    vars LibName, ThisSection;

    readitem() -> LibName;

    if not(Defined(LibName)) then
        true -> Defined(LibName);
        /*  Mark file as loaded: do so here to avoid recursive
            a-needs-b-needs-a loops.
        */

        current_section -> ThisSection;
        pop_section -> current_section;
        loadlib($-need$-LibName><'');
        /*  Switch to pop_section and load file. Catenate LibName with
            '' to make it into a string, rather than a word.
        */

        $-need$-ThisSection -> current_section;
        /*  Switch back to original section.  */   
    endif;
enddefine;


endsection;
      1  0                                                                                                                                                                 new.w                                                                                               100705  017064  000205  00000001374 05427665577 006362  0                                                                                                     47426                                                                                    1  0                                                                                                                                                                  zc world zl 0 zl 1 zl 2 3 3 undef zs 5 110 101 119 46 112 undef
 undef 11 6 za zl 4 0 10 0 5 undef undef undef undef undef undef
 undef undef undef undef undef undef undef undef undef undef undef
 undef undef undef undef undef undef undef undef undef undef undef
 undef undef undef undef undef undef undef undef undef undef undef
 undef undef undef undef undef undef undef undef undef undef undef
 undef undef undef undef undef undef undef undef undef undef undef
 undef undef undef undef undef za zl 4 0 10 0 5 42 42 42 42 42
 42 42 42 42 42 42 42 77 32 32 32 32 32 32 32 32 42 42 32 32 32
 32 32 32 32 32 32 42 42 32 32 32 32 32 32 32 32 32 42 42 43 32
 32 32 32 32 32 32 32 42 42 42 42 42 42 42 42 42 42 42 42 undef
 undef undef undef zl 0 0 0
off ).
:- prolog_clauses.

:- prolog_eval(apply(valof(sysgarbage))).
:- prolog_eval(apply(valof(sys_lock_heap))).

:- version('Eden Prolog').

:- write('About to save.\n').                               

:- (
save(eden,1) ->
version,
reinitialise,
abort
;
write('Eden saved\nnewworld.w                                                                                          100705  017064  000205  00000005174 05427665600 007417  0                                                                                                     47426                                                                                    1  0                                                                                                                                                                  zc world 46 17 zv 17 zs 46 42 42 42 42 42 42 42 42 42 42 42 42
 42 42 42 42 42 42 42 42 42 42 42 42 42 42 42 42 42 42 42 42 42
 42 42 42 42 42 42 42 42 42 42 42 42 42 zs 46 42 32 32 32 32 32
 32 32 32 32 32 32 32 42 32 32 32 32 32 32 32 32 32 32 32 32 32
 32 32 32 32 32 32 32 32 32 32 42 32 32 32 32 32 32 32 42 zs 46
 42 32 32 32 32 32 32 32 32 32 32 32 32 42 32 32 32 32 32 32 32
 32 32 32 32 32 32 32 32 32 32 32 32 32 32 32 42 42 42 42 42 42
 42 42 42 42 zs 46 42 32 32 32 32 32 32 32 32 32 32 32 32 42 32
 32 32 32 32 32 32 32 32 32 32 32 32 32 32 32 32 32 32 32 32 32
 42 43 64 32 32 32 32 32 32 42 zs 46 42 32 32 32 32 32 32 32 32
 32 32 32 32 64 111 32 32 32 32 32 32 32 32 32 32 32 32 32 32
 32 32 32 32 32 32 32 42 42 42 42 42 42 32 42 64 42 zs 46 42 32
 32 32 32 32 32 32 32 32 32 32 32 42 32 32 32 32 32 32 32 32 32
 32 32 32 32 32 32 32 32 32 32 32 32 32 32 32 32 32 32 32 32 42
 64 42 zs 46 42 32 32 32 32 32 32 32 32 32 32 32 32 42 42 42 42
 42 42 42 42 42 32 32 32 32 32 32 32 32 42 42 42 42 42 42 42 42
 42 42 42 42 42 42 64 42 zs 46 42 32 32 32 32 32 32 32 32 46 46
 32 32 42 32 32 32 32 32 32 32 32 32 32 32 32 32 32 32 32 42 32
 32 32 32 32 32 32 32 32 32 32 32 32 32 42 zs 46 42 32 32 32 32
 32 32 32 32 32 32 32 32 42 32 32 32 32 32 32 32 32 32 32 32 32
 32 32 32 32 42 32 32 32 32 32 32 32 32 32 32 32 32 32 32 42 zs 46
 42 32 32 32 32 32 32 32 32 32 32 32 32 42 32 32 32 32 32 32 32
 32 32 32 32 32 32 32 32 32 42 111 42 32 32 32 32 32 32 32 32
 32 32 32 32 42 zs 46 42 32 32 32 32 32 32 32 32 32 32 32 32 42
 32 32 32 32 32 32 32 32 32 32 32 32 32 32 32 32 42 32 42 32 32
 32 32 32 32 32 32 32 32 32 32 42 zs 46 42 32 32 32 32 111 32
 32 111 111 111 111 32 42 32 32 32 32 32 32 32 32 42 42 42 42
 42 42 42 42 42 32 42 32 32 32 32 32 32 32 32 32 32 32 32 42 zs 46
 42 42 42 42 42 111 32 32 32 32 32 111 42 42 32 32 32 32 32 32
 32 32 32 32 32 32 32 32 32 32 32 32 42 32 32 32 32 32 32 32 32
 32 32 32 32 42 zs 46 42 32 32 32 32 111 32 111 32 32 32 111 32
 42 32 32 32 32 32 32 32 32 42 42 42 42 42 42 42 42 42 42 42 32
 32 32 32 32 32 32 32 32 32 32 32 42 zs 46 42 32 32 32 32 32 32
 32 32 32 32 32 32 42 32 32 32 32 32 32 32 32 32 32 32 32 42 32
 32 32 32 32 32 32 32 32 32 32 32 32 32 32 32 32 32 42 zs 46 42
 32 32 32 32 32 32 32 32 32 32 32 32 42 32 32 32 32 32 32 32 32
 32 32 32 32 42 32 32 32 32 46 32 32 32 32 32 32 32 32 32 32 32
 32 32 42 zs 46 42 42 42 42 42 42 42 42 42 42 42 42 42 42 42 42
 42 42 42 42 42 42 42 42 42 42 42 42 42 42 42 42 42 42 42 42 42
 42 42 42 42 42 42 42 42 42 3 14 37 3 zs 16 100 101 102 97 117
 108 116 111 98 106 101 99 116 115 46 112 500 east
                                                     100705  017064  000205  00000000716 05427665572 010042  0                                                                                                     47426                                                                                    1  0                                                                                                                                                                 objectutils.p                                                                                       100705  017064  000205  00000006230 05427665601 010071  0                                                                                                     47426                                                                                    1  0                                                                                                                                                                 
/*
Handy routines
--------------
*/


/*  bug_xW():
        Bug's x co-ordinate.
*/
define bug_xW();
    $-eden$-world.bw_bug_xW;
enddefine;


/*  bug_yW():
        Bug's y co-ordinate.
*/
define bug_yW();
    $-eden$-world.bw_bug_yW;
enddefine;


/*  object_at_bug():
*/
define object_at_bug();
    $-eden$-world( bug_xW(), bug_yW() );
enddefine;


/*  object_at(xW,yW):
*/
define object_at( xW, yW );
    lvars xW, yW;
    $-eden$-world( xW, yW );
enddefine;


/*  direction():
        Bug's direction, as one of {"north","south","east","west"}.
*/
define direction();
    $-eden$-world.bw_direction;
enddefine;


/*  forwardvector():
        Bug's forwardvector: a unit vector pointing in his current
        forward direction. This is the same as the Y-axis of his local
        co-ordinate system.
*/
define forwardvector();
    $-eden$-world.bw_forwardvector;
enddefine;


/*  rightvector():
        Bug's rightvector: a unit vector pointing in his current
        right direction. This is the same as the X-axis of his local
        co-ordinate system, and is his forwardvector rotated right
        by 90 degrees.
*/
define rightvector();
    $-eden$-world.bw_rightvector;
enddefine;


/*  bearing( x, y ):
*/
define bearing( x, y );
    lvars x, y;
    bw_bearing( $-eden$-world, x, y );
enddefine;


/*  scent( x, y ):
*/
define scent( x, y );
    lvars x, y;
    if x=bug_xW() and y=bug_yW() then
        "here"
    else
        bearing( x, y );
    endif;
enddefine;


/*  one_forward( xW, yW ):
        Returns the co-ordinates of the square one place forward
        from (xW,yW).
*/
define one_forward( xW, yW );
    lvars xW, yW;
    bw_rel_forward( $-eden$-world, xW, yW, 1 );
enddefine;


/*  one_back( xW, yW ):
        Returns the co-ordinates of the square one place back
        from (xW,yW).
*/
define one_back( xW, yW);
    lvars xW, yW;
    bw_rel_forward( $-eden$-world, xW, yW, -1 );
enddefine;


/*  one_left( xW, yW ):
        Returns the co-ordinates of the square one place left
        from (xW,yW).
*/
define one_left( xW, yW );
    lvars xW, yW;
    bw_rel_right( $-eden$-world, xW, yW, -1 );
enddefine;


/*  one_right( xW, yW ):
        Returns the co-ordinates of the square one place right
        from (xW,yW).
*/
define one_right( xW, yW );
    lvars xW, yW;
    bw_rel_right( $-eden$-world, xW, yW, 1 );
enddefine;


/*  object_name(char):
*/
define object_name(char);
    lvars char;
    bw_object_name( $-eden$-world, char );
enddefine;


/*
*/
define destroy( id_or_loc );
    lvars id_or_loc;
    bw_destroy_object( $-eden$-world, id_or_loc );
enddefine;


define new(type_or_char);
    lvars type_or_char;
    bw_new_object( $-eden$-world, type_or_char );
enddefine;


define place( id, loc );
    lvars id, loc;
    bw_place_object( $-eden$-world, id, loc );
enddefine;


define kill_bug();
    bw_kill_bug( $-eden$-world );
enddefine;


define kill(message);
    lvars message;
    bug_message( message );
    wait(5);
    kill_bug();
    exit_eden();
enddefine;
eviously loaded
by 'needs', this will be true, else false.

os.tex                                                                                              100705  017064  000205  00000023116 05427665602 006527  0                                                                                                     47426                                                                                    1  0                                                                                                                                                                 \documentstyle[a4]{article}
\begin{document}


\include{commands}


\title{Who am I talking to? --- operating systems and the computer}
\author{Jocelyn Paine}
\maketitle


In this handout, I say a bit about how the computer system is
controlled, about why you need to hit RETURN after each line, about the
different programs you may be talking to, and so on. To run Eden, it is
not essential that you know this material. However, I do find that
beginners are sometimes confused by the number of different programs
they have to interact with when doing the course. If you're not used to
computing, it's easy to believe that ``the computer'' is a single-minded
entity, speaking one language that is the same in all situations. In
fact this is far from the truth, as I go on to show in
section~\ref{os:who}. The system comprises a host of different programs.
These all expect different types of input, and the grammatical forms
appropriate for one will not suit another.

One thing that most of these programs do have in common is the
need for you to hit RETURN at the end of each line. Beginners often
forget to do this. In section~\ref{os:input}, I explain why it's       
necessary to do so, and what happens to your input if you don't.


\section{Operating systems}

When you log into the VAX, you get a start-up message saying something
like \verb/This is VMS version 5.1/, together with a lot of extraneous
garbage. Modern multi-user computers all come with a master control
program or {\it operating system} which sits in the machine continuously
looking after all the other programs. On the VAX, this program is called
{\it VMS}.

Generally, such computers are designed so that they can only run one
program at a time. To give the appearance of dealing simultaneously with
the people in this class plus all the other users elsewhere, the
operating system {\it time-shares}. It picks one terminal, sees which
program is to be run there, and runs it for a few milliseconds. It then
interrupts this, saving the state the program had got to, and picks
another terminal. It runs that program for a few milliseconds,
interrupts it, saves it, and picks yet another terminal. Eventually, it
gets back to the first. If each program is only run for a very short
time on each round, you get an effect like that of film frames, where
the operating system comes back to you so frequently that your program
appears to be running all the time. This resembles some theories
of attention in psychology, and indeed they were probably inspired by
this idea of a master controller sharing out resources amongst lots of
subordinate programs.

If there are many other users, the operating system can devote less
proportion of its time to each, so the programs appear to be running
slower. This happens especially in mid-morning and mid-afternoon, and
accounts for all those irritating pauses.


\subsection{What happens to your input --- inside the operating system}
\label{os:input}

To remain in control --- to give everyone a fair share of the machine
--- the operating system has to take charge of everything that goes into
it, including your input. Generally, when you press a key, the character
you typed gets sent to a storage area called a {\it buffer} inside
the operating system. When you press another key, the same happens. It
continues happening until you hit RETURN. When this happens, the
operating system has collected a whole line of input, and it now sends
this all at once to your program.

Why does the operating system store input in this way? Partly for
efficiency. It's quicker to batch up the characters and send a whole
batch to the terminal in one go than it is to send them one-by-one,
because there's a constant overhead associated with every transmission.
Partly for historical reasons, in that early computers worked on punched
cards, and programming languages were designed to fit one sentence on
each card. With such languages, you might as well wait until the whole
card has been read before sending any of it.

The important point then is that, most of the time, whatever you type
gets held by the operating system, and will not get to Prolog (or whatever
program you are talking to) unless you press RETURN. You can visualise
this if you imagine each character moving along a conveyer belt from the
terminal to the operating system. The latter puts each character into a
box. Only when it sees a RETURN does the system send the entire box (the
line) on to Prolog.

If you forget RETURN, it is easy to think that Prolog is just being very
slow to deal with your input, when in fact it never even receives it.
This is why I keep emphasising the need for RETURN.

Having said all this, it's worth noting that programs can, if absolutely
necessary, bypass the buffering process and respond to characters as
soon as they're typed. Because it's inefficient to do so, most programs
don't bother. However, some do. These include editors (such as Ved),
where it's essential that you see each character as soon as you've typed
it. The Eden ``manual bug'' does the same --- you can type actions such
as \verb/f/ and \verb/b/ without having to hit RETURN afterwards. When
learning to use a new program, always make sure you know whether RETURN
is needed after a command.


\subsection{What happens to your input --- inside Prolog}

When the input reaches Prolog, there are more complications caused by
the fact that Prolog commands need not be exactly one line long. If they
were, it would be easy to tell where they ended. But Prolog is designed
to be {\it free format}, so that spaces and newlines between words have
no significance. Thus you can write either
\begin{verbatim}
eps(psbug2,psworld2).
\end{verbatim}
or
\begin{verbatim}
eps( psbug2,
     psworld2
   ).
\end{verbatim}
or even
\begin{verbatim}
eps 
(
psbug2
,
psworld2
)
.
\end{verbatim}

When typing commands, you normally won't want this freedom, and will use
as few spaces as possible. However, when writing {\it programs} (such as
sets of production rules), it's very useful to have it. Indentation and
spacing form valuable psychological cues to a program's structure.
Hence, although the older card-based languages did not allow free-format
input, all the newer ones do.

This means that the only way Prolog can tell where a command
ends is by looking for the dot at the end. And it uses its own buffer to
do this. As soon as it receives a character from the operating system,
it adds it to the buffer. It keeps doing so, until it sees a dot. It
then takes the entire contents of the buffer to be the next command, and
processes that.

The upshot of this is that even if you hit RETURN, if you forget the dot
at the end of the command, Prolog will again just keep waiting.

Incidentally, the operating system does not need dots at the end of its
commands. It assumes that all commands are one line long unless you tell
it otherwise. If you type a dot, it will be treated as an error. You may
also have tried the Eliza program. This assumes that all sentences are
one line long, and hence doesn't need a terminator either. However, the
operating system and Eliza both require you to hit RETURN after a line.


\subsection{Who are you talking to?}
\label{os:who}

A common source of bewilderment on this system is that although you are
communicating with the same computer all the time, you are not talking
to the same {\it program} all the time. Beginners often talk about ``the
computer'', as though it were one indivisible entity. It is more
accurate to think in terms of multiple personalities, each program
having its own personality, memory, and language, and knowing nothing of
the others sharing the same machine.

So although the operating system and Prolog both share the VAX, they
follow completely different conventions. Prolog needs sentence
terminators; the operating system does not. Beginners will often type
\begin{verbatim}
eden.
\end{verbatim}
to the operating system, and get understandably confused when it
complains about an unwanted dot. Similarly, some people forget to start
up Prolog after logging in, and try typing Prolog commands at the
operating system, provoking cascades of error messages. To get round
this, the best advice is: watch the prompt! Prolog's prompt is
\verb/?-/; the operating system's is always \verb/$/.

The networks and intermediate stages are another source of bewilderment.
When you start up the terminals in CTC, you begin by talking to a
program running on the micro-computer there. The commands you give that
tell it to connect to the University master switchboard. In turn, you
must tell the switchboard to connect to the VAX. Then you tell a VAX
LOGIN program to log you in, typing your username and password; then you
tell the operating system to start up Prolog; and finally you talk to
Prolog. So you have all the sub-systems shown in
figure~\ref{os:subsystems} to deal with.
\newpage
\vfigstart
\begin{verbatim}
Micro <-> switchboard <-> LOGIN  <-> VAX operating <-> Prolog
                                     system
                                                         ^
                                                   ______|_______
                                                   |You are here|
                                                   --------------
\end{verbatim}
\vfigend{os:subsystems}{Subsystems on the VAX}

It is difficult at first to remember which sub-system you are talking
to at any stage, but practice makes it all seem easy, eventually.


\end{document}
;
enddefine;


define kill(message);
    lvars message;
    bug_message( message );
    wait(5);
    kill_bug();
    exit_eden();
enddefine;
eviously loaded
by 'needs', this will be true, else false.

output.pl                                                                                           100705  017064  000205  00000014500 05427677467 007272  0                                                                                                     47426                                                                                    1  0                                                                                                                                                                 /*  OUTPUT.PL  */


:- module output.


:- public output/1,
          add_user_output/1,
          del_user_output/1.


/*
SPECIFICATION
-------------

This module exports output/1, a simple formatted write predicate.
It defines the following operators, used to join the arguments to
output:
*/
:- op( 30, xf, ~ ).
:- op( 30, xf, ~~ ).
:- op( 40, xfy, ~<> ).
:- op( 40, xfy, <> ).
:- op( 40, xfy, ... ).
/*

PUBLIC output( Term ):
----------------------

If Term is uninstantiated, action is undefined (in fact, we call 'bug').
This is justified because we rarely _do_ want to output variables, while
treating uninstantiated Terms as an error has caught several bugs. You can
use var_ if you do want to output variables.

If
    user_output( Term )
succeeds, assume that the call of user_output has written Term, and
return, doing no other output. user_output provides a means of extending
'output' by adding new clauses for particular kinds of term, in the same
way that 'portray' does for 'print'.

If Term = A~, output A followed by a newline. (Tilde looks like an N for
newline: think of its use in Spanish).

If Term = A~~, output A followed by two newlines.

If Term = A<>B, output A immediately followed by B.

If Term = A~<>B, output A followed by a newline followed by B.

If Term = A...B, output A, then a space, then B.

If Term = result_(Pred,Arg), call the goal
    Pred(Arg,Text)
with a new variable Text, then output Text. Undefined if Pred
fails.

If Term = seplist_(List,Sep), write the elements of List separated
by Sep.

If Term = seplist_(List,Sep,Elt,Form), bind each element of List to
Elt, then write Form, which should contain Elt as a free variable.
As above, separate by Sep. Example:
    output( seplist_([a+1,b+2],' ',X+Y,X) )
will write a b.

If Term = nl_, write a newline.

If Term = write_(X), then call write(X).

If Term = writeq_(X), then call writeq(X).

if Term = display_(X), then call display(X).

If Term = put_(C), then put(C) (unless, is_newline_char(C), when we call
nl).

If Term = puts_(S) then S is a list of character codes. Do as above on
each one.

If Term = var_(V) then V is a variable. Action undefined (i.e. call bug)
if it isn't, else write(V).

If Term = anything else, call write(Term).


PUBLIC add_user_output( P+ ):
-----------------------------

"There is a clause
    user_output( Term ) :- P( Term )
in the database".

P must be the name of an arity-1 predicate. 'add_user_output' adds (if
one does not already exist) a clause like that shown above defining
'user_output' to call P. This gives a way of extending 'output'.

Example: Suppose we want 'output' to write all two-element lists in the
form
    ( Element1 Element2 )
and all atoms as
    atom<<Atom>>

We define
    my_output( [E1,E2] ) :-
        !,
        output( '('...E1...E2...')' ).
    my_output( A ) :-
        atom(A),
        !,
        output( 'atom<<'<>A<>'>>' ).
and call
    add_user_output( my_output ).


PUBLIC del_user_output( P+ ):
-----------------------------

"There is no clause
    user_output( Term ) :- P( Term )
in the database".

The argument should be as for add_user_output. 'del_user_output' deletes
any clause of the form shown above.

Example: To delete the link to 'my_output' shown above:
    del_user_output( my_output ).
*/


/*
IMPLEMENTATION
--------------
*/


:- needs
   add_linking_clause / 3,
   bug / 1,
   bug / 2,
   del_linking_clause / 3,
   is_newline_char / 1.


:- dynamic user_output/1.


output( V ) :-
    var(V), !, bug('output: variable argument').

output( X ) :-
    user_output( X ), !.

output( A~ ) :-
    !, output( A ), output( nl_ ).

output( A~~ ) :-
    !, output( A ), output( nl_ ), output( nl_ ).

output( A<>B ) :-
    !, output(A), output(B).

output( A~<>B ) :-
    !, output(A), output( nl_ ), output(B).

output( A...B ) :-
    !, output(A), output(' '), output(B).

output( spaces_(N) ) :-
    !,
    output_spaces( N ).

output( result_(Pred,Arg) ) :-
    !,
    functor( Goal, Pred, 2 ),
    arg( Goal, Arg, 1 ),
    arg( Goal, Text, 2 ),
    (
        call( Goal )
    ->
        output( Text )
    ;
        bug( 'output: result_ failed', result_(Pred,Arg) )
    ).

output( seplist_(X,_) ) :-
    ( var(X) ; ( X\=[], X\=[_|_] ) ),
    !,
    bug( 'output: bad arg to seplist_', X ).

output( seplist_(L,Sep) ) :-
    !,
    output_seplist( L, Sep ).

output( seplist_(X,_,Elt,Form) ) :-
    ( var(X) ; ( X\=[], X\=[_|_] ) ),
    !,
    bug( 'output: bad arg to seplist_', X ).

output( seplist_(L,Sep,Elt,Form) ) :-
    !,
    output_seplist( L, Sep, Elt, Form ).

output( nl_ ) :-
    !, nl.

output( write_(X) ) :-
    !, write( X ).

output( writeq_(X) ) :-
    !, writeq( X ).

output( display_(X) ) :-
    !, display( X ).

output( puts_(S) ) :-
    !,
    output_string( S ).

output( put_(C) ) :-
    !,
    (
        is_newline_char(C)
    ->
        output(nl_)
    ;
        put( C )
    ).

output( var_(V) ) :-
    !,
    (
        nonvar(V)
    ->
        bug( 'output: var_ argument not a variable.', [V] )
    ;
        write(V)
    ).

output( X ) :-
    !, write( X ).


output_seplist( [], Sep ) :- !.

output_seplist( [H], Sep ) :-
    !, output( H ).

output_seplist( [H|T], Sep ) :-
    !,
    output( H ),
    output( Sep ),
    (
        T = [X]
    ->
        output( X )
    ;
        output_seplist( T, Sep )
    ).


output_seplist( [], Sep, _, _ ) :- !.

output_seplist( [H], Sep, E, Form ) :-
    !,
    not(not(( H=E, output(Form) ))).

output_seplist( [H|T], Sep, E, Form ) :-
    !,
    not(not(( H=E, output(Form) ))),
    output( Sep ),
    (
        T = [X]
    ->
        not(not(( X=E, output(Form) )))
    ;
        output_seplist( T, Sep, E, Form )
    ).


output_spaces( 0 ) :- !.

output_spaces( N ) :-
    output( ' ' ),
    Nd is N-1,
    output_spaces( Nd ).


output_string( [] ) :- !.

output_string( [C|T] ) :-
    output( put_(C) ),
    output_string( T ).


add_user_output( P ) :-
    add_linking_clause( user_output, P, 1 ).


del_user_output( P ) :-
    del_linking_clause( user_output, P, 1 ).


:- endmodule.
ation and
spacing form valuable psychological cues to a program's structure.p.tex                                                                                               100705  017064  000205  00000142464 05427665606 006361  0                                                                                                     47426                                                                                    1  0                                                                                                                                                                 \documentstyle[a4,epsf]{article}
\begin{document}


% \vfigstart and \vfigend{label}{title} are used for fake
% figures, ie those chunks of source code to appear in tt typeface
% but too big to fit on a single page, so too big to appear in
% a figure environment.

\newcommand{\vfigstart}{
    \vspace{\intextsep}

    \noindent
    \rule{\textwidth}{1pt}
    \nopagebreak[3]
}

\newcommand{\vfigend}[2]{
    \rule{\textwidth}{1pt}
    \nopagebreak[4]
%    \vspace{6pt}
    \nopagebreak[4]
    \refstepcounter{figure}
    \begin{center}
    {\small {\bf Figure {\thefigure}} \hspace{1em} #2.}
    \end{center}
    \label{#1}
    \addcontentsline{lof}{figure}{
    \protect\numberline{\thefigure}{#2}
    }
    \vspace{\intextsep}
}

\newcommand{\figstart}{
    \begin{figure}

    \noindent
    \rule{\textwidth}{1pt}
}

\newcommand{\figend}[2]{
    \figurecap{#1}{#2}

    \noindent
    \rule{\textwidth}{1pt}
    \end{figure}
}

% \figurecap and \tablecap plonk captions for figures and tables,
% in the form requested by A-W. The negative vertical space is
% there to counteract the fact that a center environment is a
% new paragraph.
%
% NOTE: the presence of the center environment is going to cause
% lots of 'Underfull \hbox (badness 10000) ..' messages; you
% can happily ignore them.

% \figurecap{LABEL}{TITLE} puts a figure caption
\newcommand{\figurecap}[2]{
    \refstepcounter{figure}
    \begin{center}
    \vspace{-6pt}
    {\small {\bf Figure {\thefigure}} \hspace{1em} #2.}
    \end{center}
    \label{#1}
    \addcontentsline{lof}{figure}{
    \protect\numberline{\thefigure}{#2}
    }
%    \vspace{\intextsep}
}


\title{AI and PopBeast}
\author{Jocelyn Paine}
\maketitle


I'm going to describe about a small AI program which ``lives'' in a
computer-generated environment. This program carries out actions in
response to commands typed in English. As it does so, it displays the
representations it is building up, so you can watch its ``mind'' in
action. This handout is made up for the open day, and is very similar to
one I use here. Take a copy if you want; if you find you're not
interested, please put it back on the pile for someone else. If you find
this is the last one, please don't take it, but ask at the Help Desk to
get a copy made.

My motivation for describing this program here is that AI can only be
properly understood by experimenting with working models. Like
mathematics, you won't appreciate it properly if if you just read the
textbooks without trying it for yourself. It is also easier to
understand the concepts if you can see them in context as part of a
complete system, rather than in isolation. (This is true of any area of
knowledge, of course.)

The program, ``PopBeast'', is part of the ``Build-a-Mind Kit''. This is
something that I and others originated in our spare time for the
University AI Society, to give our members some experience of practical
AI. The Department has taken up the idea, and we are using a
modified version for the AI practical.

Now back to PopBeast. If we had unlimited resources, I would have built
a robot, equipped with TV camera and other sensors. However, robot
hardware is not cheap, and given the limited capabilities of today's
robots, I would also have problems in designing a suitable environment.
AI has found it much easier to make programs that indulge in ``rational
thought'' --- that play chess, translate languages, or prove theorems
--- than it has to make programs that, by perception and action, can
link their thoughts to the real world. Most industrial robots, if they
use vision at all, only do so in a very limited form; the average robot
is still guided by touch, and finds it impossible to cope if the parts
it's assembling aren't exactly where they should be.


\section{Eden and microworlds}

I have therefore settled on a program which acts not within the real
world, but within a computer, in a ``microworld'' called {\it Eden}. AI
has had a long tradition of such microworlds,
working on the principle that if you start small, and simplify a problem
to its utmost by working in a simulated environment stripped of all
inessentials, you can scale up later to the real world. Thus a lot of
research in planning has been done in the {\it blocks world}, which
consists of a few blocks whose only attributes are colour and size,
stacked on a table. In general, such environments are known as {\it
microworlds}. One of the most famous early AI programs, {\it Shrdlu},
was based in a microworld: see, e.g. the account in {\it AI and Natural
Man} by Boden.

It has become evident that very few, if any, of the problem-solving
methods developed in AI scale up as their inventors expected. This is
true regardless of whether the methods are meant as models of human
cognition, or whether they are just engineering attempts to implement
some form of machine cleverness.

There are precedents for such scaling problems in nature: the worst of
Hollywood aside, a man-sized flea would not be able to jump over the
Empire State Building. Insect respiration relies on oxygen being able to
diffuse from pores in the exoskeleton to every part of the body, and
this is only possible for small insects. Above a certain size, a
complete redesign --- lungs, with their fractally enormous surface area
--- was needed.
Incidentally, a
nice essay on the problems of scale, including an application to the
design of churches, is given in the chapter {\it Size and Shape} from
{\it Ever Since Darwin} by Stephen J Gould.

It is not therefore surprising that methods which work on a very small
scale should fail at a larger one. And it's important not to
underestimate the difference in scales between microworlds and the real
world. A typical AI microworld, Eden included, contains perhaps ten to
fifty ``objects'', where all objects of the same type are identical.
Generally, they have no internal structure, no parts, and at most ten
different attributes. In addition, the AI inhabiting such a microworld
typically receives complete perceptual information about its
environment. Finally, there is nothing corresponding to friction,
weather, predators, or anything else which can cause the environment to
behave unpredictably.


\section{What is the point of AI?}

Given that so many of these methods fail to scale up, what is the point
of AI? What has it achieved?

Firstly, there have been some useful technological spin-offs, expert
systems being the most famous. The successful applications of AI only
work within extremely restricted domains, but are useful as long as we
recognise their limitations. Recent research is producing new paradigms
which may succeed where the old ones failed.

As far as AI's contribution to psychology goes, it has made the subject
more rigorous, by demonstrating how much is left unspecified in a theory
which is not precise enough to be runnable on a computer.

It has helped make the idea of mental states respectable, shown that we
should ask in detail {\it how} the mind does things as well as {\it
what} it does, and demonstrated the kinds of language in which we can
talk about mental processes.

It has given us a number of general ideas about how computational
systems can be organised, and terminology for describing their
properties. These include the ideas of representation, control,
algorithmic complexity, and levels of description, as well as notions
about how to connect small computational systems to build large ones.

It has given us specific answers to some psychological questions,
notably in early vision.
 In other areas, such as the organisation
of memory, the answers aren't so specific. But even here, AI has
suggested a number of possible frameworks, and so helped us formulate
questions.

There are other views of AI's contributions. Sometime,
you should look at {\it The Foundations of AI}, edited by Partridge and
Wilks (CUP 1990). It contains a few very technical papers
on subjects like theorem-proving, but also a number of general ones by
Marr, Boden and others, giving their views of AI.


\section{Eden}

As I've implied, none of the methods used by PopBeast would scale up to
the real world; indeed, they don't work too well even within its current
environment. So they are not intended as models of any real animal, or
attempts to solve any problem in AI or robotics. However, I think them
to be worth demonstrating, because they illustrate a number of bits of
terminology that you'll meet in the literature.

PopBeast lives in a microworld called Eden, designed to provide an
environment which is reasonably challenging, whilst being easy to
compute. Given the grotty graphics available to us, it also had to be
easy to display on our terminals. Forget mice and windows; don't even
dream of bitmapped graphics and 256-colour screens. We are still
restricted to an 80 $\times$ 25 array of symbols --- including both
cases of letters and some funny punctuation marks, but omitting almost
everything else.

Given these constraints, what does Eden look like? Strictly speaking,
you can have many different worlds, but I'll refer to them all as
``Eden''. Figure~\ref{bw:defaultworld} shows one possibility, with an
explanation of the symbols underneath.
\figstart
\begin{verbatim}
        **********************************************
        * B        @ *            *    T             *
        *      QQQQQQ*            *                  *
        *      QQQQQQ*        ***********            *
        ** ** @QQQQkQ*        #         *            *
        *      QQQQQQ*        *********Q             *
        *      QQQQQQ*                *Q             *
        *          @ *                *Q             *
        *            *                *              *
        *        T   *                *              *
        *            *********        **************@*
        *            *                             *k*
        *            @                      ********@*
        *            *                      *+#      *
        *            *                      **********
        *            *                       *       *
        **********************************************

B = PopBeast    - aka Bug.
+ = food        - eat this to gain energy.
* = boulder     - impossible to move through.
@ = rock        - can be smashed with hammer (T).
# = door        - can be opened with key (k).
Q = quicksand   - drowns you unless you immediately move off it.
T = hammer      - smashes a rock.
k = key         - opens a door.
\end{verbatim}
\figend{bw:defaultworld}{Eden}

\begin{sloppypar}
Eden is two-dimensional, and divided into a rectangular grid of
squares. Each square can hold one object, and may also be able to
accomodate PopBeast. However, whether this is possible depends on
the object's ``size''. Boulders, rocks, and doors are big enough to
block a PopBeast from moving into the square they occupy; food, hammers,
and keys are smaller, and can be in the same square as a PopBeast.
\end{sloppypar}

How does a PopBeast interact with its environment? A PopBeast has a
``retina'' and a ``sense of smell''. Both these are automatically
updated by the simulator so that they always reflect the current state
of the world. The retina is a 7 $\times$ 5 array representing PopBeast's
immediate environment. The sense of smell gives the general direction of
the food, as one of \verb/forward/, \verb/back/, \verb/right/,
\verb/left/. In the world shown above, PopBeast is facing east (right):
it smells the food as being \verb/forward/, and it sees its retina as
shown in Figure~\ref{bw:retina}. PopBeast's position is represented by a
\verb/B/.
\figstart
\begin{verbatim}
 **  * QQ
  *
  *
  *
  *
  *B
  *
\end{verbatim}
\figend{bw:retina}{PopBeast's retina}

These are severe sensory limitations, which represent a compromise.
PopBeast needs {\it some} senses: it is difficult to build intelligent
behaviour into a being with no sensory apparatus whatsoever. On the
other hand, the senses must not provide information that's too precise,
because one of Eden's objectives is to let people experiment with the
problems of perceptual decoding. Given the size of the retina, if
PopBeast is to do any more than react to its immediate surroundings, it
somehow needs to move around the world and combine successive retinal
images into a consistent and correct {\it world model}.

Incidentally, it is an increasing trend that not everyone agrees on the
need for a world-model; some people believe that trying to construct and
maintain one leads to inefficient and non-adaptable agents. The contrary
view is put by R A Brooks in {\it Challenges for Complete Creature
Architectures}, from {\it From Animals to Animats}, edited by Meyer and
Wilson (MIT 1991).

PopBeast also faces the problem of integrating sight and smell. This is
harder than it might seem, because the senses are so different. If PopBeast
can see the food at all, then it knows exactly where it is. However, its
sense of smell only gives a general direction. So the world model must
be able to accomodate imprecise data: ``hints'' about the state of the
world. The problem of merging information from different sources is an
important one in robotics, and is known as {\it sensory fusion}.

Having got this sensory information, how does PopBeast use it? The
simulator works in a continuous cycle, rather like the turns in a game.
At the start of each turn, it updates PopBeast's senses so they're
consistent with the current state of the world. It then activates
PopBeast's ``brain''. This is a chunk of computer program which takes
the sense data, ``thinks'', and eventually comes up with a ``motor
command''. The simulator then takes this action, modifies the world
accordingly, and then starts the next turn. Warning: these ``motor
commands'' are single symbols, and have very little in common with motor
commands in real animals.

At the end of each turn, PopBeast can perform one of eight actions. Four
are moves: it can move one step forward or one step back, or turn 90
degrees left or right. It can't move diagonally, or more than one square
at a time. Every time PopBeast moves, it loses one unit of ``energy'':
starting with 500 units, if the energy gets down to zero, PopBeast will
``die''. This, plus the restricted range of movements, make it vital to
plan efficient paths when travelling. You also have to avoid obstacles.
You can only move forward or back on a quicksand; if you turn, you'll
fall in. You can't move through a boulder, rock or door. Boulders
represent fixed obstacles; rocks and doors are not so stubborn, because
you can smash or open them as described below.

Of the other four actions, two are to do with carrying objects. PopBeast
can pick up an object (provided that its ``hand'' is empty), or put one
down (if there's room for it in the square). It can't hold more than one
object at a time, however. Again, this restriction enforces efficient
planning. Some objects --- boulders, rocks, doors --- can't be picked
up; food, keys and hammers can.

PopBeast can also ``use'' the object it's carrying. What effect this has
depends on what the object is. Using food is equivalent to eating it.
Using a key will open a door, if PopBeast is standing next to the door.
Using a hammer will smash a rock, if PopBeast is standing next to the
rock. Keys and doors are not quite the same as hammers and rocks; if you
use a key, it disappears, but if you use a hammer, it remains for you to
use again. Using the other objects has no effect.

Eden was designed by Simon Perkins for the AI Society, as a setting for
members to write and test AI programs. He has done a very good job of
providing a challenging, yet conceptually simple, world within the
constraints of Oxford's computers. You might like to think about what
the PopBeast in Figure~\ref{bw:defaultworld} has to do in order to get
at the food. Note that it has to open the door in the top middle of the
world, but it needs a key to do this, and the only accessible key is
hidden in a nest of quicksands.

Note: by ``challenging'', I mean ``puzzle-like'' or intellectually
challenging, in the way in which so many problems posed to classical AI
systems have been. Eden contains nothing equivalent to the challenge of
running the London Marathon, or playing a complicated piece of Liszt.


\section{Mind design}

How might one design a PopBeast which can survive in such worlds? The
answer depends on how much information one is willing to program it
with. The PopBeast I describe below already ``knows'' the basic
properties of keys, doors and other objects when it starts life.
However, a truly artificial intelligence ought to be able to learn these
for itself, just by wandering around the world, playing with things, and
noting regularities. At first sight, it might seem easy to build
something which does this --- which notices that when you grab a rock it
doesn't move, but when you grab a key it does, and therefore keys can be
picked up. Indeed, in Eden, building such a program would not be too
difficult. Objects always behave in the same way; there are very few
objects, and very few actions one can perform; and perceptual data
(vision, anyway) is always complete.

In the real world, objects have many more properties and interact in
many more ways. Building an AI program that can decide {\it what}
properties and interactions to take note of is not trivial --- look up
{\it Bongard problems} in Hofstadter's {\it G\"{o}del, Escher, Bach}
(Penguin 1981) if you are not convinced.

Moreover, real world objects differ in all sorts of inessential ways
(consider the difference between two poodles); there are many more
things you can do with them; and no two situations are ever alike. We
are a long way from solving the problem of {\it machine learning}, and I
have circumvented it by pre-programming PopBeast with knowledge of its
world's basic physics. This is a big cop-out, since the ability to learn
should probably be central to every intelligence, with everything else
depending from it.     


\section{PopBeast and information representations}

As I hinted earlier, I'm using PopBeast to demonstrate representations.
An important idea in AI is that the same information can be represented
in many different ways. There's an analogy with chemistry here. How does
diamond differ from graphite? Graphite is soft enough for pencil leads;
it's opaque, it's a good conductor of electricity, and (as charcoal) it
makes an excellent fuel. Diamond is the hardest natural substance known;
it's transparent, it doesn't conduct electricity, and not even the most
desparate barbecue fanatic would throw his wife's wedding ring into the
coals. Yet both are made from the same atoms.

The difference is form. In graphite, the atoms are arranged in layers
that slip easily over one another, allowing the free passage of
electrons, and coming off in streaks onto paper. In diamond, the atoms
form a tetrahedral structure; it has no ``give'', and you must work very
hard to detach an atom.

This is obvious to any chemist. But until 1860 or so, the difference was
inexplicable. Although Dalton had put the idea of atoms combining in
definite ratios, the notion of shape and arrangement of atoms was
missing; no-one seems to have considered it until Van't Hoff proposed
that carbon atoms have a definite shape, with bonds pointing outwards as
from the centre of a tetrahedron.

Information has form as well. Programmers know that the same piece of
information can be represented in many different ways: numbers in base
10, base 2, or as Roman numerals; dates as day/month/year or as days
since January 1st 1890; images as arrays of intensity points or as a set
of classified objects; geometric facts as drawings on graphs or
co-ordinate equations \ldots.

These choices are not arbitrary. The way something is represented on a
particular information-processing system crucially affects the types of
operation we can perform naturally and quickly
(Figure~\ref{bw:pharoah}). For instance, if we represent dates as days
since a base date, it's easy to find the time between two dates, but
hard to tell which month any date falls into. With the day/month/year
representation, the converse is true.

\figstart
% \epsfxsize=4.5in\epsfbox{[popx]pic.epsf}
\vspace{2.2 in}
\begin{verbatim}
Picture omitted due to faults in word-processor. It was a cartoon, taken
from a book on software design by Cliff Jones, of an ancient Egyptian
scribe drawing on a large wall-board whilst complaining to somebody who
is dictating near by. He is busy drawing line after line of tiny
man-like hieroglyphs, following a few other symbols. The caption is
``are you sure there isn't a better way of writing `The Pharoah had
10,000 soldiers?' ''.
\end{verbatim}
\vspace{2.2 in}
\figend{bw:pharoah}{Some representations are better than others}

So representation should be a crucial idea in psychology. But until the
advent of computational models it has been largely neglected. What made
us realise its importance was the technical difficulty of programming
computers. Pages 24--33 of {\it Artificial Intelligence} by Winston (2nd
edition) give an excellent example of different representations in an
early analogy-solving program.


\section{How PopBeast represents its world}

Let's start then with the simple Eden of Figure~\ref{bw:world}.
\figstart
\begin{verbatim}
**********************
*                    *
*            * * *   *
*            * + *   *
*            *   *   *
*                    *
**************   *   *
*      *     *  *    *
*   k  *     @     * *
*      *     *       *
*  B   #     *       *
*    * *  T  *       *
*      *     *       *
**********************
\end{verbatim}
\figend{bw:world}{A simpler Eden}

Here, PopBeast is in a room which contains a key \verb/k/ and a door
\verb/#/. Suppose that I have told PopBeast to open the door. How does
it work out what to do? To answer this question, you have to know how
the command ``open the door'' is presented, and I'll get on to this
later. I will start though by talking about how PopBeast represents the
world --- how it remembers where it is, and what objects are around it.

It does this in two main ways. The first is by maintaining a kind of
internal image. In programming terms (if you know any --- don't worry if
not), this image is a two-dimensional array of characters which holds a
copy of the picture above. Non-programmers can think of it as just a
two-dimensional grid on which is drawn a map of the world. This is an
{\it analogue} representation. PopBeast builds up the map by wandering
around the world and superimposing successive retinal images; this is
fairly straightforward, and I shan't say any more about it.

The second method is based on logic, and describes the world as a set of
{\it propositions}. If you look at Figure~\ref{bw:props} and compare it
with the Eden in Figure~\ref{bw:world}, you should be able to work out
what's going on.
\vfigstart
\begin{verbatim}
square(me, [4,4])
square(key(1), [5,6])
square(door(2), [8,4])
square(hammer(3), [11,3])
square(rock(4), [14,6])
square(food(5), [16,11])

in(me, 49)
in(key(1), 49)
blocked(49, 50, door(2))
in(hammer(3), 50)
blocked(50, 51, rock(4))
in(food(5), 51)
joins(49, 50)
joins(50, 51)
joins(51, 49)

dir([1,0])
\end{verbatim}
\vfigend{bw:props}{Eden in propositions}

For those who don't know logic, a brief explanation of terminology is in
order. A proposition is a statement about an object, or about a relation
between objects. It is usually written as a name (the {\it predicate})
followed by some things in brackets. These things are the objects that
the proposition is talking about, and are called its {\it arguments}. If
there are more than one argument, they are separated by commas. Note
that some authors use variants of this notation: Charniak and McDermott,
for instance, use bracketed lists
\begin{verbatim}
( predicate argument-1 argument-2 )
\end{verbatim}
The arguments can be numbers, or simple names like \verb/me/, or groups
of things like \verb/[1,0]/, or compound ``structures'' like
\verb/key(1)/. How these are interpreted depends entirely on the program
using them: they have no intrinsic meaning. In PopBeast's world model,
most objects are represented as their type --- \verb/key(_)/ or
\verb/door(_)/ together with a unique number to distinguish one
individual from another. An exception to this rule is \verb/me/, for
obvious reasons. Co-ordinates are represented as pairs \verb/[X,Y]/, and
regions are given arbitrary numbers in the range 49--57 (there are
technical reasons for this, which I shall ignore).

Each predicate expresses some fact about an object or set of objects. In
this figure, the first group of propositions is all of the form
\verb/square( _, [_,_] )/. These describe the contents of squares. The
first argument denotes the object within a square, and the second
argument, specifying the position of the square, is a pair of (X,Y)
values. These are in PopBeast's internal co-ordinate system, for which
(0,0) is at the bottom left.

The second group describe the way the world is divided into regions, and
how they're connected. I have made PopBeast describe the world in terms
of regions because of their importance in everyday life: they enable you
to divide the world into pieces which can be reasoned about in
isolation, in that influences are contained, i.e. an event happening in
one region has very little effect on events in another.

In this group of propositions, the numbers 49,50,51 refer to the three
different regions. The \verb/joins/ propositions tell you which regions
are adjacent; the \verb/blocked/ propositions tell you whether you can
pass between them, and if not, why not; the \verb/in/ propositions tell
you which objects lie within a region.

The third group describes PopBeast's knowledge of the direction it is
facing in, by specifying how it would move were it to go forward. At the
moment, it would go one place right (X) and none north (Y), so the
direction is \verb/[1,0]/.

It goes without saying that I am not asking you to learn the details of
these notations, merely to appreciate the kind of information they
carry. The propositional representation is very close to how the {\it
Prolog} programming language works, and you will see it again in the AI
practical.

So far, we've seen three different ways of describing where things are.
We can use an analogue internal map, or we can use propositions. Within
the propositions, we can either give exact co-ordinates, or we can
describe the world in terms of regions and their contents. Why do we
need all these? The answer is that different representations are good
for different jobs. The analogue map is useful when you know the
locations of two points, and you want to plot a detailed path between
them. It is also easy to build up from retinal images, and serves as a
starting point for the propositional representations. The propositions
about squares and object co-ordinates are useful when deciding {\it
which} points we want to plot a path between. The propositions about
regions are useful in formulating high-level plans about moving from
region to region. If we know that region 1 contains a hammer, and region
2 contains a rock, then to smash the rock in region 2, we have to go
into region 1. At this level of detail, the exact co-ordinates of the
hammer and rock don't matter, so we can speed up computation by ignoring
them. At a lower level, we will eventually need to take them into
account: then we descend through the other two representations.


\section{How PopBeast represents meaning}

Like Shrdlu, PopBeast can obey simple commands. It can also answer
questions. How does it represent their meaning? As with the non-analogue
part of its world model, it uses propositions. Thus ``There is a key in
a room'' would become
\begin{verbatim}
in( K, R ), key(K), room(R).
\end{verbatim}
Literally translated, this means ``K is in R, and K is a key, and R is a
room'': by ``room'', PopBeast understands what I called a ``region''
earlier. The comma is the way that Prolog displays a logical ``and''.
The K and R are what are called {\it logical variables}. In the
world-model propositions, the arguments always named particular objects.
Here by contrast, they could refer to {\it any} objects for which the
proposition is true: that is, to any key K and room R such that K is in
R. This is reasonable, since the sentence did not specify a particular
room or key. Logicians may be puzzled by the lack of a quantifier for
the variables K and R. As written in standard logic, this would have a
$\exists K \exists R$ quantifier in front of it, but in Prolog, this can
be taken for granted. Non-logicians can ignore the last remark.

Verbs are also represented by propositions. Thus the sentence ``PopBeast
opens a door'' would become
\begin{verbatim}
opens( me, D ), door(D).
\end{verbatim}
Literally translated from the logic, this means ``I (PopBeast) open D, and D
is a door''.

There is actually slightly more to the representation than this. With
each assertion, PopBeast stores a special marker to indicate that it
{\it is} an assertion rather than a command. The reason for this is that
the logical translation alone is insufficient to distinguish the two.
The formula
\begin{verbatim}
opens( me, D ), door(D).
\end{verbatim}
could, as above, say something about the current state of the world.
However, it could also describe a state of the world which we want
PopBeast to make true, but which isn't true now --- i.e. act in such a
way that you are opening a door. PopBeast can tell from the grammatical
structure of a sentence whether it is meant to be a command or an
assertion. To summarise, the two meanings are represented as
\begin{center}
\begin{tabular}{ll}
    {\bf Sentence}     &                 {\bf Meaning}\\
                          &\\
    PopBeast opens a door & \verb#opens(me,D),door(D) / assertion# \\
    Open a door      & \verb#opens(me,D),door(D) / command#
\end{tabular}
\end{center}
where the \verb/assertion/ and \verb/command/ markers are not part of
the proposition.

You may have noticed that above I have talked about the sentence ``Open
a door'', whereas earlier I said that I could give PopBeast the command
``Open the door''. What is the difference in meaning? It is often the
case in English, though not always, that ``the'' refers back to some
previously mentioned item, or points at an item which is special in some
way to the listener or speaker. To deal with this properly, PopBeast
would have to determine {\it which} item this is, possibly by examining
the context built up by previous dialogue. I have finessed this by
ignoring it, and fixing PopBeast so that ``the'' and ``a'' are treated
alike. Future PopBeasts will be cleverer.


\section{How PopBeast creates plans and actions}

As before, let's suppose we have told PopBeast to open the door. Suppose
also that it is working on the first set (\verb/square/) of propositions
in Figure~\ref{bw:props} --- to keep these notes short, I'll ignore
anything it does with the \verb/in/, \verb/joins/ and \verb/blocked/
ones.

When I tried this out, with PopBeast as shown in Figure~\ref{bw:world},
it generated the following sequence of actions:
\begin{verbatim}
[left, forward, right, forward, left, forward,
 grab,
 right, forward, forward, right, forward, forward, left, forward,
 use
]
\end{verbatim}
To check these, you have to know that it was facing East when it
started. The notation I have used here is how Prolog displays what's
called a {\it list}. This is a kind of structure that can hold an
arbitrary number of data items. Programming languages that provide lists
also allow you to join lists together and insert elements anywhere
inside them. Hence lists are very good for storing variable-length data
like sentences, musical scores, and action sequences. If you know what
arrays are, think about the difference. Arrays are fixed length and
cannot be extended.

In the computer, lists themselves are implemented as blocks of bits
connected in a certain way. However, you need not worry about that
because Prolog takes care of all the details. Finding out how to make
programming languages that did this took somewhere between four and ten
years, and was a major boost to AI programming. The first major
programming language to implement them was called {\it LISP}: it is
still the most widely used AI language.


\subsection{What is the goal?}
\label{bw:whatisthegoal}

PopBeast now has to start planning a sequence of actions to achieve
this. The first step is to find out exactly what ``open'' means. This is
done by looking up \verb/opens/ in a table which gives its meaning in
terms of how it changes the world. In Eden, once you have opened a door,
it disappears, i.e. the square in which it stood becomes empty. So the
meaning can be expressed as ``The effect of opening a door is that at
the start of the activity there is a door in some square S, and at the
end of the activity there isn't''. In PopBeast's memory, this is stored
as below:
\begin{verbatim}
verb( opens(D),
      [ square(D,S),door(D) ],
      [ clear(S) ]
    ).
\end{verbatim}
Here, \verb/verb/ is a proposition which expresses information about
other propositions. The first argument is the predicate which we used to
represent ``opens'', the second is a statement about the start of the
activity of opening, and the third is a statement about the end of the
activity. \verb/clear(S)/ is how PopBeast represents the fact that
square S is empty. If we can fill in the current values for \verb/D/ and
\verb/S/, we will have a description of our current goal --- to convert
a state in which square \verb/S/ contained a door to one in which it
doesn't.

Note: as with world-models, not everyone believes that successful
artificial intelligences will contain explicit representations of their
goals. This view is descended from the idea that goals, beliefs and
other ``folk-psychology'' constructs are a pre-scientific means we have
developed for describing our own and other minds; they no more describe
what really goes on than astrology describes how the cosmos operates.
There are therefore no explicit representations of such things in human
and animal minds: trying to find them is bad cognitive science.
Furthermore, trying to build such representations into artificial minds
is bad engineering. These views are put in {\it Taking Eliminative
Materialism Seriously: A methodology for Autonomous Systems Research} by
Tim Smithers, from {\it Towards a Practice of Autonomous Systems},
edited by Varela and Bourgine (MIT 1992).

PopBeast {\it does} represent such entities --- for teaching purposes,
to illustrate classical AI. So going back to verbs, other ones could be
expressed in the same way. The meaning of ``go to object X'' is stored
as
\begin{verbatim}
verb( go(X),
      [ square(X,S)],
      [ square(X,S),square(me,S) ]
    ).
\end{verbatim}
This expresses the fact that at the start of going, X is in a certain
square called S, and at the end of going, PopBeast --- \verb/me/ --- is
also in S.


\subsection{Filling in referents}

Before PopBeast can use the above information, it has to replace D and S
below
\begin{verbatim}
[ square(D,S),door(D) ],
\end{verbatim}
with a specific square and door. It does this by matching against the
proposition
\begin{verbatim}
square(door(2), [8,4])
\end{verbatim}
in its world model, giving S=\verb/[8,4]/ and D=\verb/door(2)/. This
process is called {\it finding the referent} of D and S. As I hinted in
my discussion of ``the'', there are better ways to do this: PopBeast's
method is a very poor approximation to what any decent
language-understanding system should do, and to what we do. The problem
of finding referents also comes up in interpreting pronouns, and was one
of the objectives behind Shrdlu --- consider a sentence like ``Pick up
the red block and put it on the large green box''.


\subsection{Planning}

The \verb/verb/ table above has told PopBeast that opening something is
equivalent to making it disappear from the square in which it was. With
the referents of D and S filled in, this implies that opening
\verb/door(2)/ is equivalent to making it disappear from square
\verb/[8,4]/. How can PopBeast find a sequence of actions that will
achieve this --- a {\it plan}? This is called {\it planning}, and the
program that does it is called a {\it planner}.

Remember that in each turn, PopBeast can perform one of eight primitive
actions: left, right, forward, back, drop, grab, use, and wait. To
reason about what sequence of actions will achieve a goal such as
\verb/clear([8,4])/, PopBeast needs to represent the effect of each of
these actions. There are various ways to do this; the one I have chosen
is based on that used in an early planner called {\it STRIPS}.

The idea is that we represent the state of the world at any time by a
set of propositions, as PopBeast does in its propositional world-model.
We then represent each action by a table showing how, if it were carried
out, it would change the state. In particular: what does it make false
that used to be true; and what does it make true that used to be false?

Let's look at ``grab'' as an example. Before PopBeast grabs an object,
its hand must be empty, and the object must be in the same square as
PopBeast. After grabbing, the hand will contain the object, and the
square will be empty. We can represent this by saying that when grabbing
X in square S, PopBeast makes this fact true:
\begin{verbatim}
have(X)
\end{verbatim}
and makes these facts false:
\begin{verbatim}
square(X,S), empty
\end{verbatim}
Here, \verb/have(X)/ means ``I am holding X'', and \verb/empty/ means
``I am holding nothing''.

Other actions can be specified in the same fashion. When using a key K
on a door D in square S, the facts
\begin{verbatim}
empty, clear(S)
\end{verbatim}
become true, and the facts
\begin{verbatim}
have(K), square(D,S)
\end{verbatim}
become false. (Remember that after using a key on a door, the door
disappears from its square, and the key from PopBeast's hand.) This way
of describing actions is called the {\it add-list/delete-list
representation}.

We need one further piece of information for each action: under what
conditions it can be performed. You can only open a door if you are in
the same square as it and you have a key; you can only grab an object if
your hand is empty and you are in the same square as it. These necessary
conditions are called the action's {\it preconditions}. We represent
these in the same way as the add- and delete-lists: as sequences of
propositions. Thus the precondition for grabbing X in square S is
\begin{verbatim}
square(X,S), empty, square(me,S)
\end{verbatim}
which literally translated from the logic, means ``X is in S, and PopBeast is
in S, and PopBeast's hand is empty''.

Similarly, the precondition for opening door D with key K in square S is
that
\begin{verbatim}
have(K), square(D,S), square(me,S)
\end{verbatim}
which means ``I am holding K, D is in square S, and I am also in square
S''.

The add-lists, delete-lists and preconditions are collected together for
each primitive action, in a table rather like the \verb/verb/ table. As
an example, here are the descriptions of the primitive actions
\verb/grab/ and \verb/use/:
\begin{verbatim}
action( grab(X,S),
        [ square(X,S), empty, square(me,S) ],
        [ square(X,S), empty ],
        [ have(X) ]
      ).

action( use(K),
        [ have(K), square(D,S), square(me,S) ],
        [ have(K), square(D,S) ],
        [ empty, clear(S) ]
      ).
\end{verbatim}


\subsection{Building plans from actions}
\label{buildingplansfromactions}

Having decided to represent actions as above, how do we chain them
together so as to achieve a specified goal? The simplest method is {\it
blind search}; this is like playing a game of chess by considering all
possible moves from your current board state, then all possible moves
from each of the resulting states, then all possible moves from {\it
those} resulting states, and so on. Essentially, we draw a tree of
possibilities, form all the branches, and pick the one which leads to
the desired goal. I won't draw such a tree here: see page 138 of {\it
Cognitive Science projects in Prolog} by Scott and Nicolson (LEA 1991)
which
shows such a tree for the blocks
world.

This approach rapidly becomes unfeasible. The number of possibilities
increases so fast with level in the tree, that we run out of processor
time, no matter how fast our computer. This explosion of possibilities
is called the {\it combinatorial explosion}. In the Foreword to {\it
Computers and Thought}, Sloman calls AI the ``science of productive
laziness'' --- can we be lazy and avoid an exhaustive search?


\subsection{Means-end planning and goal regression}

An idea introduced by Newell, Simon and Shaw in their {\it General
Problem Solver} (GPS) program was that instead of choosing actions
blindly, as above, the planner should concentrate on those actions which
are most likely to lead it towards the final goal. This is called {\it
means-end} planning: choosing a means which is likely to achieve the
desired end.

My planner uses a method called {\it goal regression}, and introduced by
STRIPS. The idea is that we look at the add-lists of all the actions.
Some actions will have add-lists which add propositions we want in our
goal. We imagine that we'll apply one of these actions, and ask what new
goals need to be satisfied in order for us to do so. We then treat these
in the same way and pick an action that will satisfy them, and so on.

An example will help. As I showed in section~\ref{bw:whatisthegoal}, our
goal state is
\begin{verbatim}
clear( [8,4] )
\end{verbatim}
We can select actions that might work towards this goal by looking at
the add-lists. In essence, we want an action whose add-list contains a
\verb/clear/: that is, one which makes a square clear. One such action
is to use a key. Its add- and delete-lists show that we would get the
state
\begin{verbatim}
clear( [8,4] )
\end{verbatim}
if we applied it to the following state:
\begin{verbatim}
have( key(1) ), square( door(2), [8,4] ).
\end{verbatim}
In other words, we can make \verb/[8,4]/ clear if we have key 1, and we
use it on a door in \verb/[8,4]/. But this requires us to have a key, so
we set that as a new goal. We now need to find an action which gets a
key into our hand: namely \verb/grab/. But that requires us to be in the
same square as a key, so we must set the goal of getting to that square.
And so on. What we are doing is simplifying the problem by breaking the
original goal into a series of {\it subgoals}; in this case, using
goal-regression to do so.


\subsection{Planning at a level of abstraction}

When my planner had finished, it produced the following plan:
\begin{verbatim}
[ go([4, 4], [5, 6]),
  grab(key(1), [5, 6]),
  go([5, 6], [8, 4]),
  use(key(1))
]
\end{verbatim}
meaning ``go from \verb/[4,4]/ to \verb/[5,6]/; grab key 1; go from
\verb/[5,6]/ to \verb/[8,4]/; use key 1''. You will see that this plan
is incomplete; it doesn't say anything about {\it how} to go between two
points. The reason for this is that my planner is not very efficient
(though better than blind search), and it runs slowly if it has to
consider too many details. So I have treated ``go'' as a primitive
action: as far as the planner is concerned, one can always go between
any two points. This is called {\it planning at a level of abstraction}:
making a plan whilst ignoring some of the details.

Before PopBeast can obey this plan, it must be fleshed out with the actual
moves. To do this, PopBeast runs through, looking at all the \verb/go/s. For
each one, it plots a short path between the two points, and then
converts that into a sequence of lefts, rights, forwards, and backs. It
could be that no such path exists, if (say) there is a wall between the
points. In that case, the path-plotter would have to tell the planner to
make a new plan. In my example, paths do exist, and I'll ignore
situations where they don't.


\subsection{Fleshing out plans}

We find paths using the geometric world model. Consider the problem of
going from \verb/[4,4]/ to \verb/[5,6]/. We start at \verb/[4,4]/ and
enumerate all the clear neighbours. We then calculate the distance from
each of them to \verb/[5,6]/, using the standard formula. We pick the
neighbour for which this distance is least, and then repeat, finding its
neighbours, calculating distance, and so on. This is called {\it guided
search}. Instead of picking a neighbour blindly, we pick one which seems
most likely to lead to our goal. Our measure of success --- our {\it
evaluation function} --- is distance.

In this particular problem, this gives us a nice short path. However, it
wouldn't do so if there had been an obstacle a bit later on: our use of
distance as a guide would not tell us about this. Picking the neighbour
with the least distance from the goal is a good rule-of-thumb --- a good
{\it heuristic} --- but one that sometimes fails.

After the search had finished, it generated this path:
\begin{verbatim}
[ [4, 4], [4, 5], [5, 5], [5, 6] ]
\end{verbatim}

The final stage was to convert it into moves. This needed to know
PopBeast's initial heading, and to keep track of how it changed. The result
was this set of moves:
\begin{verbatim}
[left, forward, right, forward, left, forward]
\end{verbatim}

The other path was generated in the same way, giving a complete plan of
\begin{verbatim}
[left, forward, right, forward, left, forward,
 grab,
 right, forward, forward, right, forward, forward, left, forward,
 use
]
\end{verbatim}


\subsection{Planning and execution}

Having made a plan, PopBeast follows it an action at a time. It There is
nothing in the current PopBeast that allows it to adjust if an action fails,
or if the world changes in the meantime. In general, the early planners
assumed that these problems didn't arise. More recent work, especially
in robotics, has had to face them.


\section{The symbol-grounding problem; and a warning}

Most of the symbols in PopBeast have names which look like English words:
\verb/opens/, \verb/assertion/, \verb/in/. When looking at programs that
use such symbols, it's very easy to fall into the trap of thinking that
they mean a lot more to the program than they do. When {\it we} see the
symbol \verb/opens/, it induces a rich network of concepts and
associations. None of these, however, are available to PopBeast: to it,
\verb/opens/ only gains meaning by virtue of the way it is manipulated
by various parts of the program.

Another way to make this point is that PopBeast would behave exactly the same
if I were to systematically replace every name by its equivalent in some
other language. I could, for example, replace \verb/square/ by
\verb/vierkant/, \verb/key/ by \verb/sleutel/, \verb/me/ by \verb/mij/
\ldots As long as I have done this so that names are different in this
new language wherever they were different in the original, the program
won't suffer. I could of course also use made-up names: \verb/square/ by
\verb/z/, \verb/key/ by \verb/zz/, \verb/me/ by \verb/zzz/ \ldots

This is an important point, well worth bearing in mind when reading AI
programs and books. Most of the examples of symbolic representations you
will see use English names, for the simple reason that authors and
programmers find it easier to work with names with familiar
connotations. These names mean so much to us that we can easily forget
they have no such meaning to their program. Beware of this. I recommend
reading {\it Artificial intelligence and natural stupidity} by Drew
McDermott from {\it Mind Design} by Haugeland (MIT 1981)
as a preventative. It assumes some experience with semantic nets, so you
may want to come back to it when you've read about those.    

If the internal symbols don't gain meaning from their names, how do they
gain it? PopBeast's brain does not operate in isolation, but perceives and
acts in what, to it, is an external reality. How does the internal symbol
\verb/door/ come to be connected with what PopBeast perceives when it sees
a \verb/#/ in Eden? This is the {\it symbol-grounding} problem: how,
in an artificial or natural symbol-manipulating system, the internal
symbols come to be connected to external referents and actions. In PopBeast,
the answer is that although most of the symbols' names are completely
arbitrary, this is not true of the images on PopBeast's retina, nor of the
motor actions that it obeys. These are determined by Eden's ``laws of
physics'', and somewhere inside PopBeast there is a
consistent mapping between them and symbols like \verb/door/ --- a
mapping set up by me. The symbol-grounding problem becomes more acute in
learning systems which must identify for themselves novel
features and properties for which their programmer has not provided
pre-defined symbols.


\end{document}
me,S)
\end{verbatim}
which literally translated from the logic, means ``X is in S, and PopBeast is
in S, and PopBeast's hand is empty''.

Similarly, the                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                 path_to_moves.p                                                                                     100705  017064  000205  00000004306 05427665607 010421  0                                                                                                     47426                                                                                    1  0                                                                                                                                                                 /*  PATH_TO_MOVES.P  */


section path_to_moves => path_to_moves;


/*
SPECIFICATION
-------------

This module defines a routine for converting a path, expressed as a list
of points, into a list of bug moves. You supply it with the path and the
bug's initial heading, and it returns a list of actions, and a new
heading.


PUBLIC path_to_moves( heading, path ) -> new_heading -> moves:

'heading' must be a unit vector giving the bug's current direction.
'path' is a list of points. Each point must be horizontally or
vertically adjacent to the next.

The routine returns two results, the new heading, also as a unit vector,
and a list of moves. Each element of this is a word, one of "left",
"right", "forward", or "back".

Example:

    path_to_moves( [0 1],
                   [ [1 2] [1 3] [2 3] [3 3] [3 2] ]
    ) -> d -> moves;                     
    d=>
    moves=>
gives
    ** [0 -1]
    ** [forward right forward forward right forward]
*/


/*
IMPLEMENTATION
--------------

The routine works by taking pairs of points at a time, subtracting them
to give a direction, and calculating the turn needed to convert the
bug's current heading into this direction. This is done using routines
from VEC.P.

This module comes with a file HELP PATH_TO_MOVES. Make sure the two are
kept in step.
*/


needs vec;


vars path_to_moves_1;/*forward*/


define path_to_moves( dir, path );
    lvars path, dir;
    lvars dir1, p, q, rest_path;

    if path matches [=] then
        []; dir
    else
        path(1) -> p;
        path(2) -> q;
        tl(tl(path)) -> rest_path;
        vec_sub( q, p ) -> dir1;
        path_to_moves_1( turn2(dir,dir1), dir1, [ ^q ^^rest_path ] );
    endif;
enddefine;


define path_to_moves_1( move, dir, rest_path );
    lvars move, dir, rest_path;
    lvars new_dir, rest_moves;

    path_to_moves( dir, rest_path ) -> new_dir -> rest_moves;

    if move = "forward" then
        [ forward ^^rest_moves ]; new_dir
    elseif move = "back" then
        [ left left forward ^^rest_moves ]; new_dir
    else
        [ ^move forward ^^rest_moves ]; new_dir
    endif;

enddefine;


endsection;
erb/[8,4]/; use key 1''. You will see that this plan
is incomplete; it doesn't say anything about {\it how} to go between two
points. The reason for this is that my planner is not very efficient
(though better than blind search), and it runs slowly if it has to
consider too many details. So I have treated ``go'' as a primitive
action: as far as the planner is concerned, one can always go between
any two points. This is called {\it ppath_to_moves.pl                                                                                    100705  017064  000205  00000002504 05427665607 010573  0                                                                                                     47426                                                                                    1  0                                                                                                                                                                 /*  PATH_TO_MOVES.PL  */


:- module path_to_moves.


/*
SPECIFICATION
-------------

This module defines a predicate for converting a path, expressed as a
list of points, into a list of bug moves. You supply it with the path
and the bug's initial heading, and it returns a list of actions, and a
new heading.


PUBLIC path_to_moves( Heading+, Path+, NewHeading-, Moves- ):

Heading must be a unit vector giving the bug's current direction.
Path is a list of points. Each point must be horizontally or
vertically adjacent to the next.

The routine returns two results, the new heading, also as a unit vector,
and a list of moves. Each element of this is an atom, one of 'left',
'right', 'forward', or 'back'.

Example:

    path_to_moves( [0, 1],
                   [ [1, 2] [1, 3] [2, 3] [3, 3] [3, 2] ],
                   D,
                   Moves
                 ).
gives
    D = [0 -1]
    Moves = [forward, right, forward, forward, right, forward]
*/


/*
IMPLEMENTATION
--------------

Just calls the Pop-11 routine in PATH_TO_MOVES.P.
*/


:- prolog_language(pop11).
needs path_to_moves;
:- prolog_language(prolog).
:- library(are).


path_to_moves( Heading, Path, NewHeading, Moves ) :-
    [ NewHeading, Moves ] are path_to_moves( Heading, Path ).


:- endmodule.
PopBeast's initial heading, and to keep track of how it changed. The result
was this set of moves:
\begin{verbatim}
[left, forward, right, forward, left, forward]
\end{verbatim}

The other path was generated in the same way, giving a complete plan of
\begin{vpb_world.w                                                                                          100705  017064  000205  00000012720 05427665612 007364  0                                                                                                     47426                                                                                    1  0                                                                                                                                                                  zc world 46 17 zv 17 zs 46 42 42 42 42 42 42 42 42 42 42 42 42
 42 42 42 42 42 42 42 42 42 42 42 42 42 42 42 42 42 42 42 42 42
 42 42 42 42 42 42 42 42 42 42 42 42 42 zs 46 42 32 32 32 32 32
 32 32 32 32 32 32 32 42 32 32 32 32 32 32 32 32 32 32 32 32 32
 32 32 32 32 32 32 32 32 32 32 42 32 32 32 32 32 32 32 42 zs 46
 42 32 32 32 32 32 32 32 32 32 32 32 32 42 32 32 32 32 32 32 32
 32 32 32 32 32 32 32 32 32 32 32 32 32 32 32 42 42 42 42 42 42
 42 42 42 42 zs 46 42 32 32 32 32 94 32 32 32 32 32 32 32 42 32
 32 32 32 32 32 32 32 32 32 32 32 32 32 94 32 32 32 32 32 32 32
 42 43 35 32 32 32 32 32 32 42 zs 46 42 32 32 32 32 32 32 57 32
 32 32 32 32 64 32 32 32 32 32 32 32 32 43 32 32 32 32 32 32 32
 32 32 32 32 32 32 42 42 42 42 42 42 42 42 64 42 zs 46 42 32 32
 32 32 43 32 32 32 32 32 32 32 42 32 32 32 32 32 32 32 32 32 32
 32 32 32 32 32 32 32 32 32 32 32 32 32 32 32 32 32 32 32 42 107
 42 zs 46 42 32 32 32 32 32 53 32 32 32 32 32 32 42 42 42 42 42
 42 42 42 42 119 32 32 32 32 32 32 32 42 42 42 42 42 42 42 42
 42 42 42 42 42 42 64 42 zs 46 42 32 32 32 83 32 32 32 32 84 32
 32 32 42 32 32 32 119 119 119 119 119 119 32 32 32 32 32 32 32
 42 32 32 32 32 32 32 32 32 32 32 32 32 32 32 42 zs 46 42 32 32
 32 32 32 32 32 57 32 32 32 32 42 32 32 32 119 119 119 119 119
 119 119 32 32 32 32 32 32 42 32 32 32 32 32 32 32 32 32 32 32
 32 32 32 42 zs 46 42 32 32 32 94 32 32 32 32 32 32 64 32 42 32
 32 119 119 119 119 119 119 119 119 32 32 32 32 32 32 42 81 32
 32 32 32 32 32 32 32 32 32 32 32 32 42 zs 46 42 32 32 49 32 32
 32 81 81 81 81 81 81 42 32 32 32 119 119 119 119 119 32 32 32
 32 32 32 32 32 42 81 32 32 32 32 32 32 32 32 32 32 32 32 32 42
 zs 46 42 32 32 32 32 32 32 81 81 81 81 81 81 42 32 43 32 32 119
 119 32 43 42 42 42 42 42 42 42 42 42 81 32 32 32 32 32 32 32
 32 32 32 32 32 32 42 zs 46 42 42 32 42 42 32 64 81 81 81 81 107
 81 42 32 32 42 43 32 32 43 32 35 32 32 32 32 32 32 32 32 32 42
 32 32 32 32 32 32 32 32 32 32 32 32 42 zs 46 42 32 32 32 32 32
 32 81 81 81 81 81 81 42 32 32 43 32 43 43 32 43 42 42 42 42 42
 42 42 42 42 42 42 32 32 32 32 32 32 32 32 32 32 32 32 42 zs 46
 42 32 32 32 50 32 32 81 81 81 81 81 81 42 32 32 43 70 32 32 43
 32 43 32 32 32 42 32 32 32 32 32 32 32 32 32 32 32 32 32 32 32
 32 32 32 42 zs 46 42 32 32 32 32 32 32 32 32 32 32 64 32 42 32
 32 32 32 32 32 32 32 32 32 32 32 42 32 32 32 32 84 32 32 32 32
 32 32 32 32 32 32 32 32 32 42 zs 46 42 42 42 42 42 42 42 42 42
 42 42 42 42 42 42 42 42 42 42 42 42 42 42 42 42 42 42 42 42 42
 42 42 42 42 42 42 42 42 42 42 42 42 42 42 42 42 37 3 zs 12 112
 98 95 111 98 106 101 99 116 115 46 112 zv 17 zs 46 42 42 42 42
 42 42 42 42 42 42 42 42 42 42 42 42 42 42 42 42 42 42 42 42 42
 42 42 42 42 42 42 42 42 42 42 42 42 42 42 42 42 42 42 42 42 42
 zs 46 42 32 32 32 32 32 32 32 32 32 32 32 32 42 32 32 32 32 32
 32 32 32 32 32 32 32 32 32 32 32 32 32 32 32 32 32 32 42 32 32
 32 32 32 32 32 42 zs 46 42 32 32 32 32 32 32 32 32 32 32 32 32
 42 32 32 32 32 32 32 32 32 32 32 32 32 32 32 32 32 32 32 32 32
 32 32 42 42 42 42 42 42 42 42 42 42 zs 46 42 32 32 32 32 94 32
 32 32 32 32 32 32 42 32 32 32 32 32 32 32 32 32 32 32 32 32 32
 94 32 32 32 32 32 32 32 42 43 35 32 32 32 32 32 32 42 zs 46 42
 32 32 32 32 32 32 57 32 32 32 32 32 64 32 32 32 32 32 32 32 32
 43 32 32 32 32 32 32 32 32 32 32 32 32 32 42 42 42 42 42 42 42
 42 64 42 zs 46 42 32 32 32 32 43 32 32 32 32 32 32 32 42 32 32
 32 32 32 32 32 32 32 32 32 32 32 32 32 32 32 32 32 32 32 32 32
 32 32 32 32 32 32 42 107 42 zs 46 42 32 32 32 32 32 53 32 32
 32 32 32 32 42 42 42 42 42 42 42 42 42 119 32 32 32 32 32 32
 32 42 42 42 42 42 42 42 42 42 42 42 42 42 42 64 42 zs 46 42 32
 32 32 83 32 32 32 32 84 32 32 32 42 32 32 32 119 119 119 119
 119 119 32 32 32 32 32 32 32 42 32 32 32 32 32 32 32 32 32 32
 32 32 32 32 42 zs 46 42 32 32 32 32 32 32 32 57 32 32 32 32 42
 32 32 32 119 119 119 119 119 119 119 32 32 32 32 32 32 42 32
 32 32 32 32 32 32 32 32 32 32 32 32 32 42 zs 46 42 32 32 32 94
 32 32 32 32 32 32 64 32 42 32 32 119 119 119 119 119 119 119
 119 32 32 32 32 32 32 42 81 32 32 32 32 32 32 32 32 32 32 32
 32 32 42 zs 46 42 32 32 49 32 32 32 81 81 81 81 81 81 42 32 32
 32 119 119 119 119 119 32 32 32 32 32 32 32 32 42 81 32 32 32
 32 32 32 32 32 32 32 32 32 32 42 zs 46 42 32 32 32 32 32 32 81
 81 81 81 81 81 42 32 43 32 32 119 119 32 43 42 42 42 42 42 42
 42 42 42 81 32 32 32 32 32 32 32 32 32 32 32 32 32 42 zs 46 42
 42 32 42 42 32 64 81 81 81 81 107 81 42 32 32 42 43 32 32 43
 32 35 32 32 32 32 32 32 32 32 32 42 32 32 32 32 32 32 32 32 32
 32 32 32 42 zs 46 42 32 32 32 32 32 32 81 81 81 81 81 81 42 32
 32 43 32 43 43 32 43 42 42 42 42 42 42 42 42 42 42 42 32 32 32
 32 32 32 32 32 32 32 32 32 42 zs 46 42 32 32 32 50 32 32 81 81
 81 81 81 81 42 32 32 43 70 32 32 43 32 43 32 32 32 42 32 32 32
 32 32 32 32 32 32 32 32 32 32 32 32 32 32 32 42 zs 46 42 32 32
 32 32 32 32 32 32 32 32 64 32 42 32 32 32 32 32 32 32 32 32 32
 32 32 42 32 32 32 32 84 32 32 32 32 32 32 32 32 32 32 32 32 32
 42 zs 46 42 42 42 42 42 42 42 42 42 42 42 42 42 42 42 42 42 42
 42 42 42 42 42 42 42 42 42 42 42 42 42 42 42 42 42 42 42 42 42
 42 42 42 42 42 42 42 37 3 zv 1 zc bug 5 7 3 2 zc retina za zl 4
 1 5 1 7 32 32 32 32 32 32 32 32 32 32 32 32 32 32 32 32 32 32
 32 32 32 32 32 32 32 32 32 32 32 32 32 32 32 32 32 zw 5 117 110
 100 101 102 zl 0 zl 0 32 500 500 zw 5 117 110 100 101 102 19
 12 zw 4 101 97 115 116 zl 2 1 0 zl 2 0 -1 19 12 zw 4 101 97 115
 116 1 1
a new
heading.


PUBLIC path_to_moves( heading, path ) -> new_heading -> moves:

'heading' must be a unit vector giving the bug's current direction.
'path' is a list of points. Each point must be horizontapbw1.w                                                                                              100705  017064  000205  00000012612 05427665610 006423  0                                                                                                     47426                                                                                    1  0                                                                                                                                                                  zc world 46 17 zv 17 zs 46 42 42 42 42 42 42 42 42 42 42 42 42
 42 42 42 42 42 42 42 42 42 42 42 42 42 42 42 42 42 42 42 42 42
 42 42 42 42 42 42 42 42 42 42 42 42 42 zs 46 42 32 32 32 32 32
 32 32 32 32 32 32 32 42 32 32 32 32 32 32 32 32 32 32 32 32 32
 32 32 32 32 32 32 32 32 32 32 42 32 32 32 32 32 32 32 42 zs 46
 42 32 32 32 32 32 32 32 32 32 32 32 32 42 32 32 32 32 32 32 32
 32 32 32 32 32 32 32 32 32 32 32 32 32 32 32 42 42 42 42 42 42
 42 42 42 42 zs 46 42 32 32 32 32 94 32 32 32 32 32 32 32 42 32
 32 32 32 32 32 32 32 32 32 32 32 32 32 94 32 32 32 32 32 32 32
 42 32 35 32 32 32 32 32 32 42 zs 46 42 32 32 32 32 32 32 57 32
 32 32 32 32 64 32 32 32 32 32 32 32 32 32 32 32 32 32 32 32 32
 32 32 32 32 32 32 42 42 42 42 42 42 42 42 64 42 zs 46 42 32 32
 32 32 32 32 32 32 32 32 32 32 42 32 32 32 32 32 32 32 32 32 32
 32 32 32 32 32 32 32 32 32 32 32 32 32 32 32 32 32 32 32 42 107
 42 zs 46 42 32 32 32 32 32 53 32 32 32 32 32 32 42 42 42 42 42
 42 42 42 42 119 32 32 32 43 32 32 32 42 42 42 42 42 42 42 42
 42 42 42 42 42 42 64 42 zs 46 42 32 32 32 83 32 32 32 32 84 32
 32 32 42 32 32 32 119 119 119 119 119 119 32 32 32 32 32 32 32
 42 32 32 32 32 32 32 32 32 32 32 32 32 32 32 42 zs 46 42 32 32
 32 32 32 32 32 57 32 32 32 32 42 32 32 32 119 119 119 119 119
 119 119 32 32 32 32 32 32 42 32 32 32 32 32 32 32 32 32 32 32
 32 32 32 42 zs 46 42 32 32 32 94 32 32 32 32 32 32 64 32 42 32
 32 119 119 119 119 119 119 119 119 32 32 32 32 32 32 42 81 32
 32 32 32 32 32 32 32 32 32 32 32 32 42 zs 46 42 32 32 49 32 32
 32 81 81 81 81 81 81 42 32 32 32 119 119 119 119 119 32 32 32
 32 32 32 32 32 42 81 32 32 32 32 32 32 32 32 32 32 32 32 32 42
 zs 46 42 32 32 32 32 32 32 81 81 81 81 81 81 42 32 32 32 32 119
 119 32 32 42 42 42 42 42 42 42 42 42 81 32 32 32 32 32 32 32
 32 32 32 32 32 32 42 zs 46 42 42 32 42 42 32 64 81 81 81 81 107
 81 42 32 32 42 32 32 32 32 57 35 32 32 32 32 32 32 32 32 32 42
 32 32 32 32 32 32 32 32 32 32 32 32 42 zs 46 42 32 32 32 32 32
 32 81 81 81 81 81 81 42 32 32 32 32 32 32 32 32 42 42 42 42 42
 42 42 42 42 42 42 32 32 32 32 32 32 32 32 32 32 32 32 42 zs 46
 42 32 32 32 50 32 32 81 81 81 81 81 81 42 32 32 32 32 32 32 83
 32 32 32 32 32 42 32 32 32 32 32 32 32 32 32 32 32 32 32 32 32
 32 32 32 42 zs 46 42 32 32 32 32 32 32 32 32 32 32 64 32 42 32
 32 32 32 32 32 32 32 32 32 32 32 42 32 32 32 32 84 32 32 32 32
 32 32 32 32 32 32 32 32 32 42 zs 46 42 42 42 42 42 42 42 42 42
 42 42 42 42 42 42 42 42 42 42 42 42 42 42 42 42 42 42 42 42 42
 42 42 42 42 42 42 42 42 42 42 42 42 42 42 42 42 26 6 zs 12 112
 98 95 111 98 106 101 99 116 115 46 112 zv 17 zs 46 42 42 42 42
 42 42 42 42 42 42 42 42 42 42 42 42 42 42 42 42 42 42 42 42 42
 42 42 42 42 42 42 42 42 42 42 42 42 42 42 42 42 42 42 42 42 42
 zs 46 42 32 32 32 32 32 32 32 32 32 32 32 32 42 32 32 32 32 32
 32 32 32 32 32 32 32 32 32 32 32 32 32 32 32 32 32 32 42 32 32
 32 32 32 32 32 42 zs 46 42 32 32 32 32 32 32 32 32 32 32 32 32
 42 32 32 32 32 32 32 32 32 32 32 32 32 32 32 32 32 32 32 32 32
 32 32 42 42 42 42 42 42 42 42 42 42 zs 46 42 32 32 32 32 94 32
 32 32 32 32 32 32 42 32 32 32 32 32 32 32 32 32 32 32 32 32 32
 94 32 32 32 32 32 32 32 42 32 35 32 32 32 32 32 32 42 zs 46 42
 32 32 32 32 32 32 57 32 32 32 32 32 64 32 32 32 32 32 32 32 32
 32 32 32 32 32 32 32 32 32 32 32 32 32 32 42 42 42 42 42 42 42
 42 64 42 zs 46 42 32 32 32 32 32 32 32 32 32 32 32 32 42 32 32
 32 32 32 32 32 32 32 32 32 32 32 32 32 32 32 32 32 32 32 32 32
 32 32 32 32 32 32 42 107 42 zs 46 42 32 32 32 32 32 53 32 32
 32 32 32 32 42 42 42 42 42 42 42 42 42 119 32 32 32 43 32 32
 32 42 42 42 42 42 42 42 42 42 42 42 42 42 42 64 42 zs 46 42 32
 32 32 83 32 32 32 32 84 32 32 32 42 32 32 32 119 119 119 119
 119 119 32 32 32 32 32 32 32 42 32 32 32 32 32 32 32 32 32 32
 32 32 32 32 42 zs 46 42 32 32 32 32 32 32 32 57 32 32 32 32 42
 32 32 32 119 119 119 119 119 119 119 32 32 32 32 32 32 42 32
 32 32 32 32 32 32 32 32 32 32 32 32 32 42 zs 46 42 32 32 32 94
 32 32 32 32 32 32 64 32 42 32 32 119 119 119 119 119 119 119
 119 32 32 32 32 32 32 42 81 32 32 32 32 32 32 32 32 32 32 32
 32 32 42 zs 46 42 32 32 49 32 32 32 81 81 81 81 81 81 42 32 32
 32 119 119 119 119 119 32 32 32 32 32 32 32 32 42 81 32 32 32
 32 32 32 32 32 32 32 32 32 32 42 zs 46 42 32 32 32 32 32 32 81
 81 81 81 81 81 42 32 32 32 32 119 119 32 32 42 42 42 42 42 42
 42 42 42 81 32 32 32 32 32 32 32 32 32 32 32 32 32 42 zs 46 42
 42 32 42 42 32 64 81 81 81 81 107 81 42 32 32 42 32 32 32 32
 57 35 32 32 32 32 32 32 32 32 32 42 32 32 32 32 32 32 32 32 32
 32 32 32 42 zs 46 42 32 32 32 32 32 32 81 81 81 81 81 81 42 32
 32 32 32 32 32 32 32 42 42 42 42 42 42 42 42 42 42 42 32 32 32
 32 32 32 32 32 32 32 32 32 42 zs 46 42 32 32 32 50 32 32 81 81
 81 81 81 81 42 32 32 32 32 32 32 83 32 32 32 32 32 42 32 32 32
 32 32 32 32 32 32 32 32 32 32 32 32 32 32 32 42 zs 46 42 32 32
 32 32 32 32 32 32 32 32 64 32 42 32 32 32 32 32 32 32 32 32 32
 32 32 42 32 32 32 32 84 32 32 32 32 32 32 32 32 32 32 32 32 32
 42 zs 46 42 42 42 42 42 42 42 42 42 42 42 42 42 42 42 42 42 42
 42 42 42 42 42 42 42 42 42 42 42 42 42 42 42 42 42 42 42 42 42
 42 42 42 42 42 42 42 26 6 zv 1 zc bug 5 7 3 2 zc retina za zl 4
 1 5 1 7 32 32 32 32 32 32 32 32 32 32 32 32 32 32 32 32 32 32
 32 32 32 32 32 32 32 32 32 32 32 32 32 32 32 32 32 undef zl 0
 zl 0 32 500 500 undef 19 12 east zl 2 1 0 zl 2 0 -1 19 12 east
 1 1
119 119 119 119
 119 119 32 32 32 32 32 32 42 32 32 32 32 32 32 32 32 32 32 32
 32 32 32 42 zs 46 42 32 32 32 94 32 32 32 32 32 32 64 32 42 32
 32 119 119 119 119 119 119 119 119 32 32 32 32 32 32 42 81 32
 32 32 32 32 32 32 32 32 32 32 32 32 42 zs 46 42 32 32 49 32 32
 32 perform.p                                                                                           100705  017064  000205  00000000442 05427665612 007215  0                                                                                                     47426                                                                                    1  0                                                                                                                                                                 define perform( action );
    lvars action;
    vars s;

    exec( action );
    chars_to_items( sentence() ) -> s;
    while s /= [] do
        popval(s);
        say( ['Finished last Pop command: l(isten) for more.'] );
        exec( "wait" );
    endwhile;
enddefine;
2 32 32 32 32 42 32 32 32 32 84 32 32 32 32
 32 32 32 32 32 32 32 32 32 42 zs 46 42 42 42 42 42 42 42 42 42
 42 42 42 42 42 42 42 42 42 42 42 42 42 42 42 42 42 42 42 42 42
 42 42 42 42 42 42 42 42 42 42 42 42 42 42 42 42 37 3 zs 12 112
 98 9planning_world.w                                                                                    100705  017064  000205  00000015130 05427665615 010572  0                                                                                                     47426                                                                                    1  0                                                                                                                                                                  zc world zl 0 zl 1 zl 2 3 3 zw 5 117 110 100 101 102 zs 16 100
 101 102 97 117 108 116 111 98 106 101 99 116 115 46 112 zw 5
 117 110 100 101 102 zw 5 117 110 100 101 102 22 10 za zl 4 0
 21 0 9 zw 5 117 110 100 101 102 zw 5 117 110 100 101 102 zw 5
 117 110 100 101 102 zw 5 117 110 100 101 102 zw 5 117 110 100
 101 102 zw 5 117 110 100 101 102 zw 5 117 110 100 101 102 zw 5
 117 110 100 101 102 zw 5 117 110 100 101 102 zw 5 117 110 100
 101 102 zw 5 117 110 100 101 102 zw 5 117 110 100 101 102 zw 5
 117 110 100 101 102 zw 5 117 110 100 101 102 zw 5 117 110 100
 101 102 zw 5 117 110 100 101 102 zw 5 117 110 100 101 102 zw 5
 117 110 100 101 102 zw 5 117 110 100 101 102 zw 5 117 110 100
 101 102 zw 5 117 110 100 101 102 zw 5 117 110 100 101 102 zw 5
 117 110 100 101 102 zw 5 117 110 100 101 102 zw 5 117 110 100
 101 102 zw 5 117 110 100 101 102 zw 5 117 110 100 101 102 zw 5
 117 110 100 101 102 zw 5 117 110 100 101 102 zw 5 117 110 100
 101 102 zw 5 117 110 100 101 102 zw 5 117 110 100 101 102 zw 5
 117 110 100 101 102 zw 5 117 110 100 101 102 zw 5 117 110 100
 101 102 zw 5 117 110 100 101 102 zw 5 117 110 100 101 102 zw 5
 117 110 100 101 102 zw 5 117 110 100 101 102 zw 5 117 110 100
 101 102 zw 5 117 110 100 101 102 zw 5 117 110 100 101 102 zw 5
 117 110 100 101 102 zw 5 117 110 100 101 102 zw 5 117 110 100
 101 102 zw 5 117 110 100 101 102 zw 5 117 110 100 101 102 zw 5
 117 110 100 101 102 zw 5 117 110 100 101 102 zw 5 117 110 100
 101 102 zw 5 117 110 100 101 102 zw 5 117 110 100 101 102 zw 5
 117 110 100 101 102 zw 5 117 110 100 101 102 zw 5 117 110 100
 101 102 zw 5 117 110 100 101 102 zw 5 117 110 100 101 102 zw 5
 117 110 100 101 102 zw 5 117 110 100 101 102 zw 5 117 110 100
 101 102 zw 5 117 110 100 101 102 zw 5 117 110 100 101 102 zw 5
 117 110 100 101 102 zw 5 117 110 100 101 102 zw 5 117 110 100
 101 102 zw 5 117 110 100 101 102 zw 5 117 110 100 101 102 zw 5
 117 110 100 101 102 zw 5 117 110 100 101 102 zw 5 117 110 100
 101 102 zw 5 117 110 100 101 102 zw 5 117 110 100 101 102 zw 5
 117 110 100 101 102 zw 5 117 110 100 101 102 zw 5 117 110 100
 101 102 zw 5 117 110 100 101 102 zw 5 117 110 100 101 102 zw 5
 117 110 100 101 102 zw 5 117 110 100 101 102 zw 5 117 110 100
 101 102 zw 5 117 110 100 101 102 zw 5 117 110 100 101 102 zw 5
 117 110 100 101 102 zw 5 117 110 100 101 102 zw 5 117 110 100
 101 102 zw 5 117 110 100 101 102 zw 5 117 110 100 101 102 zw 5
 117 110 100 101 102 zw 5 117 110 100 101 102 zw 5 117 110 100
 101 102 zw 5 117 110 100 101 102 zw 5 117 110 100 101 102 zw 5
 117 110 100 101 102 zw 5 117 110 100 101 102 zw 5 117 110 100
 101 102 zw 5 117 110 100 101 102 zw 5 117 110 100 101 102 zw 5
 117 110 100 101 102 zw 5 117 110 100 101 102 zw 5 117 110 100
 101 102 zw 5 117 110 100 101 102 zw 5 117 110 100 101 102 zw 5
 117 110 100 101 102 zw 5 117 110 100 101 102 zw 5 117 110 100
 101 102 zw 5 117 110 100 101 102 zw 5 117 110 100 101 102 zw 5
 117 110 100 101 102 zw 5 117 110 100 101 102 zw 5 117 110 100
 101 102 zw 5 117 110 100 101 102 zw 5 117 110 100 101 102 zw 5
 117 110 100 101 102 zw 5 117 110 100 101 102 zw 5 117 110 100
 101 102 zw 5 117 110 100 101 102 zw 5 117 110 100 101 102 zw 5
 117 110 100 101 102 zw 5 117 110 100 101 102 zw 5 117 110 100
 101 102 zw 5 117 110 100 101 102 zw 5 117 110 100 101 102 zw 5
 117 110 100 101 102 zw 5 117 110 100 101 102 zw 5 117 110 100
 101 102 zw 5 117 110 100 101 102 zw 5 117 110 100 101 102 zw 5
 117 110 100 101 102 zw 5 117 110 100 101 102 zw 5 117 110 100
 101 102 zw 5 117 110 100 101 102 zw 5 117 110 100 101 102 zw 5
 117 110 100 101 102 zw 5 117 110 100 101 102 zw 5 117 110 100
 101 102 zw 5 117 110 100 101 102 zw 5 117 110 100 101 102 zw 5
 117 110 100 101 102 zw 5 117 110 100 101 102 zw 5 117 110 100
 101 102 zw 5 117 110 100 101 102 zw 5 117 110 100 101 102 zw 5
 117 110 100 101 102 zw 5 117 110 100 101 102 zw 5 117 110 100
 101 102 zw 5 117 110 100 101 102 zw 5 117 110 100 101 102 zw 5
 117 110 100 101 102 zw 5 117 110 100 101 102 zw 5 117 110 100
 101 102 zw 5 117 110 100 101 102 zw 5 117 110 100 101 102 zw 5
 117 110 100 101 102 zw 5 117 110 100 101 102 zw 5 117 110 100
 101 102 zw 5 117 110 100 101 102 zw 5 117 110 100 101 102 zw 5
 117 110 100 101 102 zw 5 117 110 100 101 102 zw 5 117 110 100
 101 102 zw 5 117 110 100 101 102 zw 5 117 110 100 101 102 zw 5
 117 110 100 101 102 zw 5 117 110 100 101 102 zw 5 117 110 100
 101 102 zw 5 117 110 100 101 102 zw 5 117 110 100 101 102 zw 5
 117 110 100 101 102 zw 5 117 110 100 101 102 zw 5 117 110 100
 101 102 zw 5 117 110 100 101 102 zw 5 117 110 100 101 102 zw 5
 117 110 100 101 102 zw 5 117 110 100 101 102 zw 5 117 110 100
 101 102 zw 5 117 110 100 101 102 zw 5 117 110 100 101 102 zw 5
 117 110 100 101 102 zw 5 117 110 100 101 102 zw 5 117 110 100
 101 102 zw 5 117 110 100 101 102 zw 5 117 110 100 101 102 zw 5
 117 110 100 101 102 zw 5 117 110 100 101 102 zw 5 117 110 100
 101 102 zw 5 117 110 100 101 102 zw 5 117 110 100 101 102 zw 5
 117 110 100 101 102 zw 5 117 110 100 101 102 zw 5 117 110 100
 101 102 zw 5 117 110 100 101 102 zw 5 117 110 100 101 102 zw 5
 117 110 100 101 102 zw 5 117 110 100 101 102 zw 5 117 110 100
 101 102 zw 5 117 110 100 101 102 zw 5 117 110 100 101 102 zw 5
 117 110 100 101 102 zw 5 117 110 100 101 102 zw 5 117 110 100
 101 102 zw 5 117 110 100 101 102 zw 5 117 110 100 101 102 zw 5
 117 110 100 101 102 zw 5 117 110 100 101 102 zw 5 117 110 100
 101 102 zw 5 117 110 100 101 102 zw 5 117 110 100 101 102 zw 5
 117 110 100 101 102 zw 5 117 110 100 101 102 zw 5 117 110 100
 101 102 zw 5 117 110 100 101 102 zw 5 117 110 100 101 102 zw 5
 117 110 100 101 102 zw 5 117 110 100 101 102 zw 5 117 110 100
 101 102 zw 5 117 110 100 101 102 zw 5 117 110 100 101 102 zw 5
 117 110 100 101 102 zw 5 117 110 100 101 102 zw 5 117 110 100
 101 102 za zl 4 0 21 0 9 42 42 42 42 42 42 42 42 42 42 42 42
 42 42 42 42 42 42 42 42 42 42 42 32 32 84 32 32 32 42 32 32 32
 32 32 42 32 32 32 32 32 32 32 42 42 32 32 32 32 42 32 42 32 32
 32 32 32 42 32 32 32 32 32 32 32 42 42 32 32 32 32 32 32 35 32
 32 32 32 32 42 32 32 32 32 32 32 32 42 42 32 32 32 32 32 32 42
 32 32 32 32 32 42 32 32 32 32 32 32 32 42 42 32 43 32 107 32
 32 42 32 32 32 32 32 64 32 32 32 32 32 42 32 42 42 32 32 32 32
 32 32 42 32 32 32 32 32 42 32 32 42 32 32 32 32 42 42 42 42 64
 42 42 42 42 42 42 42 42 42 42 32 32 32 42 32 32 32 42 42 32 32
 32 32 32 32 32 32 32 32 32 32 32 32 32 32 32 32 32 32 42 42 42
 42 42 42 42 42 42 42 42 42 42 42 42 42 42 42 42 42 42 42 42 zw 5
 117 110 100 101 102 zw 5 117 110 100 101 102 zw 5 117 110 100
 101 102 zw 5 117 110 100 101 102 zl 0 0 0
2
 32 32 32 32 42 42 42 42 42 42 42 42 42 119 32 32 32 43 32 32
 32 42 42ps.pl                                                                                               100705  017064  000205  00000030410 05427665621 006337  0                                                                                                     47426                                                                                    1  0                                                                                                                                                                 /*  PS.PL  */


:- module ps.


/*
SPECIFICATION
-------------
*/


/*
IMPLEMENTATION
--------------

bagof not portable.
*/


:- lib(output).
:- lib(control).
:- lib(lists).


ps( Time, Rules, Raps, STM0, StopPred, SRP, Context0, STM ) :-
    diagnose( 'PS', 'Starting cycle'...Time<>':'~ ),
    diagnose( 'PS', 'STM is'...stm_(STM0,4)~ ),
    match( Rules, STM0, Matched ),
    diagnose( 'PS', 'Matched rules'...rules_(Matched,4)~ ),
    Matched \= [],
    !,
    resolve( Matched, STM0, SRP, Context0, Resolved ),
    diagnose( 'PS', 'Firing rule'...rules_([Resolved],4)~ ),
    fire( Resolved, Raps, Time, STM0, Context0, STM1, SRP, Context1 ),
    diagnose( 'PS', 'STM is'...stm_(STM1,4)~~ ),
    Time1 is Time + 1,
    ps_continue_if_necessary( Time1, Rules, Raps, STM1, StopPred, SRP, Context1, STM ).

ps( _, _, _, _, _, _, _, _ ) :-
    diagnose( 'PS', 'No rules matched, so exiting'~ ),
    true.
    /* if no rules matched.  */


ps_continue_if_necessary( Time, Rules, Raps, STM, StopPred, SRP, Context, STM ) :-
    (
        StopPred = '$no_goal'(G)
    ->
        not(stm_member( G, STM ))
    ;
        Goal =.. [ StopPred, STM ],
        call( Goal )
    ).

ps_continue_if_necessary( Time, Rules, Raps, STM0, StopPred, SRP, Context, STM ) :-
    ps( Time, Rules, Raps, STM0, StopPred, SRP, Context, STM ).


ps( Rules, Raps, STM0, StopPred, SRP, STM ) :-
    ps( 1, Rules, Raps, STM0, StopPred, SRP, [], STM ).


ps( Rules, STM0, StopPred, SRP, STM ) :-
    ps( 1, Rules, [], STM0, StopPred, SRP, [], STM ).


fire( Rule, Raps, Time, STM0, Context0, STM, SRP, Context ) :-
    rule_vs_action( Rule, Action ),
    fire_all( STM0, Raps, Time, Action, SRP, STM ),
    rule_vs_rule_id( Rule, RuleId ),
    Context = [ fired(RuleId,Time) | Context0 ].


fire_all( STM, _, _, [], _, STM ) :- !.

fire_all( STM0, Raps, Time, [Action1|ActionsN], SRP, STM ) :-
    fire_one( STM0, Raps, Time, Action1, SRP, STM1 ),
    fire_all( STM1, Raps, Time, ActionsN, SRP, STM ).


fire_one( STM0, Raps, Time, Term, Context, STM ) :-
    fire_one_1( STM0, Raps, Time, Term, Context, STM ), !.

fire_one( STM0, Raps, Time, Term, Context, STM ) :-
    bug( 'fire_one: failed', [Term] ).


fire_one_1( STM0, Raps, Time, erase(Term), _, STM1 ) :-
    !,
    stm_delete( STM0, Time, Term, STM1 ).

fire_one_1( STM0, Raps, Time, '$at'(Term), SRP, STM ) :-
    copy( Raps, Raps_ ),
    raps_member( Rap, Raps_ ),
    rap_vs_goal( Rap, '$at'(Term) ),
    !,
    rap_vs_plan( Rap, Plan ),
    diagnose( 'PS', 'Starting RAP'...Rap~ ),
    stm_insert( STM0, Time, Term, STM1 ),
    do_plan( STM1, Raps, Time, Term, Plan, SRP, STM2 ),
    stm_delete( STM2, Time, Term, STM ).

fire_one_1( STM0, Raps, Time, '$at'(Term), _, STM1 ) :-
    !,
    stm_insert( STM0, Time, Term, STM1 ).

fire_one_1( STM, Raps, Time, Term, _, STM ) :-
    !,
    call( Term ).

fire_one_1( STM0, Raps, Time, sub(Name), SRP, STM ) :-
    !,
    '$sub_rules'( Name, Rules ),
    ps( Time, Rules, Raps, STM0, '$finish', SRP, [], STM ).


/*
Matching.
---------
*/


match( Rules, STM, Matched ) :-
    fast_bagof(
            Rule,
            (   rules_member( Rule, Rules ),
                rule_vs_condition( Rule, Cond ),
                match_cond( Cond, STM )
            ),
            Matched
         ).


match_cond( [], _ ) :- !.

match_cond( [C1|CN], STM ) :-
    !,
    match_primitive_cond( C1, STM ),
    match_cond( CN, STM ).


match_primitive_cond( '$at'(Term), STM ) :-
    !,
    stm_member( Term, STM ).

match_primitive_cond( not('$at'(Term)), STM ) :-
    !,
    not(stm_member( Term, STM )).

match_primitive_cond( Term, STM ) :-
    call( Term ).


/*
Conflict resolution.
--------------------
*/


resolve( [], STM, SRP, Context, _ ) :-
    !,
    bug( 'resolve: no rules', [STM,SRP,Context] ).

resolve( [Rule], _, _, _, Rule ) :- !.

resolve( [Rule|_], _, [], _, Rule ) :- !.

resolve( Rules, STM, [s|Rest], Context, Resolved ) :-
    !,
    resolve_by_specificity( Rules, STM, MostSpecific ),
    resolve( MostSpecific, STM, Rest, Context, Resolved ).

resolve( Rules, STM, [r|Rest], Context, Resolved ) :-
    !,
    resolve_by_recency( Rules, STM, Context, LeastRecent ),
    resolve( LeastRecent, STM, Rest, Context, Resolved ).

resolve( Rules, STM, [p|Rest], Context, Resolved ) :-
    !,
    resolve_by_priority( Rules, STM, MostImportant ),
    resolve( MostImportant, STM, Rest, Context, Resolved ).

resolve( Rules, _, SRP, _, _ ) :-
    bug( 'resolve: bad SRP', [SRP] ).


resolve_by_specificity( Rules, STM, MostSpecific ) :-
    tag_by_unspecificity( Rules, TaggedRules ),
    keysort( TaggedRules, Sorted ),
    diagnose( 'PS', 'Sorted by specificity to give rules'~<>tagged_rules_(Sorted,4)~ ),
    untag_and_take_best( Sorted, MostSpecific ).


resolve_by_priority( Rules, STM, MostImportant ) :-
    tag_by_priority( Rules, TaggedRules ),
    keysort( TaggedRules, Sorted ),
    diagnose( 'PS', 'Sorted by priority to give rules'~<>tagged_rules_(Sorted,4)~ ),
    untag_and_take_best( Sorted, MostImportant ).


resolve_by_recency( Rules, STM, Context, LeastRecent ) :-
    tag_by_time( Rules, Context, TaggedRules ),
    keysort( TaggedRules, Sorted ),
    diagnose( 'PS', 'Sorted by recency to give rules'~<>tagged_rules_(Sorted,4)~ ),
    untag_and_take_best( Sorted, LeastRecent ).


tag_by_unspecificity( [], [] ) :- !.

tag_by_unspecificity( [Rule|Rules], [MinusS-Rule|Taggeds] ) :-
    rule_vs_condition( Rule, Cond ),
    conditions_specificity( Cond, S ),
    MinusS is -S,
    !,
    tag_by_unspecificity( Rules, Taggeds ).


conditions_specificity( L, S ) :-
    conditions_specificity( L, 0, 0, S ).


conditions_specificity( [], Sum, Count, S ) :-
    !,
    S is Sum.
    /*  Don't take average.  */

conditions_specificity( [C1|Cn], Sum0, Count0, S ) :-
    condition_specificity( C1, CS ),
    Sum1 is Sum0 + CS,
    Count1 is Count0 + 1,
    conditions_specificity( Cn, Sum1, Count1, S ).


condition_specificity( C1, CS ) :-
    C1 =.. [ _ | Args ],
    args_specificity( Args, AS ),
    CS is AS + 1.


args_specificity( Args, S ) :-
    args_specificity( Args, 0, S ).


args_specificity( [], S, S ) :- !.

args_specificity( [A1|AN], S0, S ) :-
    var(A1),
    !,
    S1 is S0 + 0.5,
    args_specificity( AN, S1, S ).

args_specificity( [A1|AN], S0, S ) :-
    S1 is S0 + 1,
    args_specificity( AN, S1, S ).


tag_by_priority( [], [] ) :- !.

tag_by_priority( [Rule|Rules], [MinusP-Rule|Taggeds] ) :-
    rule_vs_priority( Rule, P ),
    MinusP is -P,
    !,
    tag_by_priority( Rules, Taggeds ).


tag_by_time( [], _, [] ) :- !.

tag_by_time( [Rule|Rules], Context, [Time-Rule|Taggeds] ) :-
    member( fired(RuleId,Time), Context ),
    rule_vs_rule_id( Rule, RuleId ),
    !,
    tag_by_time( Rules, Context, Taggeds ).

tag_by_time( [Rule|Rules], Context, [0-Rule|Taggeds] ) :-
    tag_by_time( Rules, Context, Taggeds ).


untag_and_take_best( [], [] ) :- !.

untag_and_take_best( [K-H1,K-H2|T], [H1|T_] ) :-
    !,
    untag_and_take_best( [K-H2|T], T_ ).

untag_and_take_best( [_-H|_], [H] ).


/*
Plans.
------
*/


do_plan( STM, _, _, _, [], _, STM ) :- !.

do_plan( STM0, Raps, Time, Goal, [A1|An], SRP, STM ) :-
    diagnose( 'PS', 'Doing RAP action'...A1~ ),
    do_a( STM0, Raps, Time, Goal, A1, SRP, STM1 ),
    do_plan( STM1, Raps, Time, Goal, An, SRP, STM ).


do_a( STM0, Raps, Time, Goal, ::(Prec,A), SRP, STM ) :-
    call(Prec),
    !,
    do_a( STM0, Raps, Time, Goal, A, SRP, STM ).

do_a( STM, _, _, _, ::(_,_), _, STM ).

do_a( STM0, Raps, Time, Goal, '$rules'(Rules), SRP, STM ) :-
    ps( Time, Rules, Raps, STM0, '$no_goal'(Goal), SRP, [], STM ).

do_a( STM0, Raps, Time, Goal, '$at'(Term), SRP, STM ) :-
    copy( Raps, Raps_ ),
    raps_member( Rap, Raps_ ),
    rap_vs_goal( Rap, '$at'(Term) ),
    !,
    rap_vs_plan( Rap, Plan ),
    diagnose( 'PS', 'Starting RAP'...Rap~ ),
    stm_insert( STM0, Time, Term, STM1 ),
    do_plan( STM1, Raps, Time, Term, Plan, SRP, STM2 ),
    stm_delete( STM2, Time, Term, STM ).

do_a( STM0, Raps, Time, Goal, '$at'(Term), SRP, STM ) :-
    !,
    stm_insert( STM0, Time, Term, STM ).

do_a( STM0, Raps, Time, Goal, (C->A1;A2), SRP, STM ) :-
    !,
    (
        call(C)
    ->
        do_a( STM0, Raps, Time, Goal, A1, SRP, STM )
    ;
        do_a( STM0, Raps, Time, Goal, A2, SRP, STM )
    ).

do_a( STM, Raps, Time, Goal, A, SRP, STM ) :-
    call( A ).


/*
Rules.
------
*/


rule_vs_action( rule(_,_,Action,_), Action ).


rule_vs_condition( rule(_,Cond,_,_), Cond ).


rule_vs_priority( rule(Priority,_,_,_), Priority ).


rule_vs_rule_id( rule(_,_,_,RuleId), RuleId ).


rules_member( Rule, Rules ) :-
    member( Rule, Rules ).


rule_insert( Rules, Rule, [Rule|Rules] ).


:- assert( '$rule_id'(0) ).


new_rule( rule(_,_,_,RuleId) ) :-
    '$rule_id'(RuleId),
    retract( '$rule_id'(_) ),
    Next is RuleId + 1,
    assert( '$rule_id'(Next) ).


/*
Subs.
-----
*/


sub_vs_plan( sub(_,Plan), Plan ).


sub_vs_goal( sub(Goal,_), Goal ).


subs_member( Sub, Subs ) :-
    member( Sub, Subs ).


sub_insert( Subs, Sub, [Sub|Subs] ).


/*
Raps.
-----
*/


rap_vs_plan( rap(_,Plan), Plan ).


rap_vs_goal( rap(Goal,_), Goal ).


raps_member( Rap, Raps ) :-
    member( Rap, Raps ).


rap_insert( Raps, Rap, [Rap|Raps] ).


/*
STM.
----
*/


new_stm( 'stm'(0,0,[]) ).


stm_insert( 'stm'(LastTime,LastTag,Facts0), Time, Term, 'stm'(Time,Tag,Facts) ) :-
    (
        LastTime = Time
    ->
        Tag is LastTag + 1
    ;
        Tag = 1
    ),
    TimeStamp is Time*1000 + Tag,
    Facts = [ fact(Term,TimeStamp) | Facts0 ].


stm_delete( 'stm'(LastTime,LastTag,Facts0), Time, Term, 'stm'(Time,Tag,Facts) ) :-
    (
        LastTime = Time
    ->
        Tag is LastTag + 1
    ;
        Tag = 1
    ),
    delete( Facts0, fact(Term,_), Facts ).
    /*  Variables in Term must remain unbound. This is ensured by
        'delete'.
    */


stm_member( Term, TimeStamp, 'stm'(_,_,Facts) ) :-
    member( fact(Term,TimeStamp), Facts ).


stm_member( Term, 'stm'(_,_,Facts) ) :-
    stm_member( Term, TimeStamp, 'stm'(_,_,Facts) ).


show_stm( STM, Indent ) :-
    forall(
        stm_member( Term, TimeStamp, STM ),
        output( spaces_(Indent)<>Term...'('<>timestamp_(TimeStamp)<>')'~ )
    ).


list_to_stm( L, STM ) :-
    new_stm( STM0 ),
    list_to_stm( L, STM0, STM ).


list_to_stm( [], STM, STM ) :- !.

list_to_stm( [Term|Terms], STM0, STM ) :-
    stm_insert( STM0, 0, Term, STM1 ),
    list_to_stm( Terms, STM1, STM ).


/*
Output.
-------
*/


:- add_user_output( ps_output ).


ps_output( timestamp_(T) ) :-
    !,
    Time is T div 1000,
    Tag is T mod 1000,
    output( Time<>'.'<>Tag ).

ps_output( stm_(STM,Indent) ) :-
    !,
    show_stm(STM,Indent).

ps_output( rules_(Rules,_) ) :-
    !,
    show_rules( Rules ).

ps_output( tagged_rules_(Rules,_) ) :-
    !,
    show_tagged_rules( Rules ).

ps_output( cond_(C) ) :-
    !,
    show_cond(C).

ps_output( action_(C) ) :-
    !,
    show_action(C).

ps_output( simple_ac_(AC) ) :-
    !,
    show_simple_ac(AC).


show_rules( [] ) :- !.

show_rules( [R1|Rn] ) :-
    show_rule( R1 ),
    ( Rn \= [] -> output(nl_), show_rules( Rn ) ; true ).


show_rule( Rule ) :-
    rule_vs_condition( Rule, C ),
    rule_vs_action( Rule, A ),
    output( cond_(C)...'=>'...action_(A) ).


show_tagged_rules( [] ) :- !.

show_tagged_rules( [R1|Rn] ) :-
    show_tagged_rule( R1 ),
    ( Rn \= [] -> output(nl_), show_tagged_rules( Rn ) ; true ).


show_tagged_rule( Tag-Rule ) :-
    rule_vs_condition( Rule, C ),
    rule_vs_action( Rule, A ),
    output( Tag...cond_(C)...'=>'...action_(A) ).


show_cond( C ) :-
    output( seplist_(C,',',Elt,simple_ac_(Elt)) ).


show_action( A ) :-
    output( seplist_(A,',',Elt,simple_ac_(Elt)) ).


show_simple_ac( '$at'(A) ) :-
    !,
    output( '@'<>A ).

show_simple_ac( A ) :-
    output( A ).


:- endmodule.
) :-
    rule_vs_action( Rule, Action ),
    fire_all( STM0, Raps, Time, Action, SRP, STM ),
    rule_vs_rule_id( Rule, RuleId ),
    Context = [ fired(RuleId,Time) | Context0 ].


fire_all( STM, _, _, [], _, STM ) :- !.

fire_all( STM0, Raps, Time, [Action1|ActionsN], SRP, STM ) :-
    fire_one( STM0, Raps, Time, Action1, SRP, STM1 ),
    fire_all( STM1, Raps, Time, ActionsN, SRP, STM ).


fire_one( STM0, Raps, Time, Term, Context, STM ) :-
    fire_one_1( Sps.tex                                                                                              100705  017064  000205  00000073316 05427665621 006540  0                                                                                                     47426                                                                                    1  0                                                                                                                                                                 \documentstyle[a4,epsf,alltt]{article}
\begin{document}


\include{commands}
\newcommand{\ital}[1]{{\it #1}}

\title{Production systems}
\author{Jocelyn Paine}
\maketitle


The type of artificial intelligence exemplified by the {\it AI and
PopBeast} handout is, for various reasons, unsuitable for the practical.
I say more about these in the following section: briefly, it isn't very
robust, and it is not representative of all current practice. I
have therefore adopted a different approach for the ``bugs'' that you
will be experimenting with. This is based round the idea of a {\it
production system}. After saying something about differing approaches to
AI, I shall go on to describe how production systems work, and how they
can be applied to Eden.


\section{Introduction --- some problems with classical AI}

In the handout on {\it AI and PopBeast}, I described a simple
artificially intelligent program. Its mental functioning is clearly
separated into three parts. There is a perception box that takes
``visual'' input and builds from it a description of the world. There is
a reasoning box that takes this description, together with a goal
generated by analysing the last command, and builds a plan. And there is
an action box that executes each action in the plan in turn. This
three-way division is probably typical of what is sometimes called
``classical'' AI; typical of almost all mid-70's robot designs and some
current ones, though of course my program is a lot simpler.
Incidentally, ``classical AI'' is a fairly loose term. If you intend to
use it in essays or exams, give some examples to show what you mean.                 

Many AI workers no longer accept this separation as the best way to
build robots that can act in an uncertain and changing world.
There are many reasons why. Here is one, as an example:
building a complete description of the world from sensory data is a very
difficult job, and demands a lot of computer time. We can't yet do it
for data coming from any but the crudest sensors. Even if we could, our
description-builders could not possibly run fast enough to have finished
computing the description by the time it is needed. The robot would run
into a door before realising that it was there.

Moreover, it seems obvious (with hindsight) that the type of description
one needs depends on what one is trying to achieve. A robot typesetter,
looking at these notes, would have to build a painstakingly detailed
description of them in terms of sentences, paragraphs, tab settings,
fonts, and margins. However, if I were to drop them out of my window, a
robot street-cleaner need only classify them as ``scrap paper'' in order
to do {\it its} job --- that of throwing away anything that's not a
person, dog, cat, or piece of street furniture. As another example, when
crossing the road, it's sufficient to perceive a speeding car as
something to be avoided --- quickly! But a garage attendant or traffic
warden needs rather more detail than that. The paper {\it An emerging
paradigm in robot architecture} by Malcolm, Smithers and Hallam (PSY AI
box photocopy M149) is a nicely-written not-very-technical account of
classical AI in robotics and of some newer alternatives. Most of it
should be intelligible after reading the {\it AI and PopBeast} notes,
and I recommend it.

Although PopBeast does not address these problems, it does have some
educational value, in that it can demonstrate ideas such as multiple
representations, logic-based world-models, path planning, and many other
concepts which are themselves still widely used. In addition, it's an
important demonstration of history, as well as of some current practice,
such as the FMC self-guiding vehicle mentioned in the above paper. And
those who don't know their history are condemned to repeat it.

However, I can't let you experiment with it because it isn't robust
enough. Its planner is based on a classical planner called Warplan,
written in the mid-70's. Although an important advance in its time, it
can't solve problems much more complicated than the ``open the door''
one --- on trying, it frequently gets into infinite loops. This is not
surprising. It has been shown that this kind of planning is
computationally intractable. Roughly speaking, the amount of time needed
to make a complete plan increases with the exponential of the number of
objects and plan steps being reasoned about. Better planners than
Warplan exist, though I haven't been able to obtain them --- but even if
I could, they would eventually hit the same limits. So I have taken a
different approach in this practical.


\subsection{Reactive planning and nouvelle AI}

PopBeast goes to one extreme --- trying to build a complete plan of
action before doing anything. Some people believe that it's time to
experiment with the opposite approach --- thinking ahead as little as
possible, and reacting directly to the real world wherever possible.
This is one of the differences between ``classical AI'' and what is
sometimes called ``nouvelle AI''.

Trying to generalise over the subject is risky. But I think it's fair to
say that the typical nouvelle AI approach is this: conventional AI has
had such little success that we need something completely different.
Most of what's needed in a natural intelligence was placed there by
evolution long before the human brain evolved (compare the two billion
years life has existed with the history of the human race). Conventional
AI has concentrated on rational intelligence, printing the postage stamp
on top of the Empire State Building without worrying about the building
itself. What we should be doing is to work our way up the evolutionary
tree, making a complete creature at each step and then building the next
on top of the last. So we should start by trying to mimic insects. The
result won't be able to solve chess problems or proving theorems, but it
should be able to wander around the lab without getting stuck under
chairs, running out of energy because it's failed to notice that its
batteries are running low, or falling over and being unable to right
itself.

Once we have a working insect, we can work up from there. Eventually, we
shall find that in the course of building competance to operate in the
real world, we have most of what's needed for rational thought. For
example, spatial problem solving may fall out as a byproduct of visual
navigation. The last few steps will then be easy.

The table below summarises the differences between an extreme classical
AI position and an extreme nouvelle AI one. Most workers will not be so
extreme, and will end up somewhere in between. A good illustration of
the middle-way approach is {\it Adaptive execution in complex dynamic
worlds} by James Firby (PSY AI Box photocopy F55). I experimented
with this approach for this course, but it was too complicated to use as
an introduction for novices. However, Firby makes a lot of general
observations on the problems of AI, and these are worth reading.

It is certainly too early yet to say which approach will work best.
Taking a rather broader view, we might say that AI should study and
compare all possible designs for intelligent agents, including those
typical of both classical and nouvelle AI, pushing each to its limits in
order to discover its strengths and weaknesses. A nice example of such a
comparison, and a useful look at nouvelle AI from the viewpoint of
someone who was once very classical, is in {\it Robot planning} by Drew
McDermott (PSY AI box photocopy M165). That paper is a bit technical in
places; one that's less so, and that looks at nouvelle AI from the point
of view of a disillusioned classicist, is {\it Elephants don't play
chess} by Rodney Brooks, in {\it Designing Autonomous Agents} edited by
Pattie Maes (PSY KH:M 026).
\begin{center}
\begin{tabular}{ll}
Classical AI & Nouvelle AI \\
 & \\
Make a detailed plan in advance & React directly to the world \\
\parbox{2 in}{Store
information about the world in memory}
& \parbox{2 in}{Take it directly from the
world when needed} \\
\parbox{2 in}{Decode
perceptions into world-models} & \parbox{2 in}{Use
raw perceptual data whenever possible}
\end{tabular}
\end{center}


\section{Production systems}

I have experimented with various AI techniques, but most of them were
too complex to implement or demonstrate during this course. However,
there is one which is simple to understand, and which can be adapted to
both the nouvelle and the classical AI approaches. This is the {\it
production system}.

The idea of a production system is that you have two kinds of ``memory''
or storage. One --- {\it short-term} or {\it working} memory --- holds
the data currently being worked on, as a set of symbols. The other ---
{\it long-term memory} --- consists of rules which operate on these
symbols, looking for certain patterns and replacing them by other
patterns. You can think of them as stimulus-response rules: given a
certain stimulus or pattern of symbols, your response is to replace it
by a different pattern. Abstractly, this situation is shown below, in
figures~\ref{ps:ltm} and \ref{ps:stm}. The numbers, incidentally, are
not part of the rules, and are just there for reference.

\vfigstart
\begin{alltt}
\ital{(1)} if \(\dagger\theta\flat\) then \(\Box\smile\angle\)
\ital{(2)} if \(\Box\sim\dagger\) then \(\theta\Box\frown\Xi\dagger\)
\ital{(3)} if \(\natural\Sigma\delta\) then \(\heartsuit\Sigma\angle\delta\)
\ital{(4)} if \(\Box\smile\angle\) then \(\Box\sim\dagger\)
\end{alltt}
\vfigend{ps:ltm}{Some production-system rules}

\newpage
\vfigstart
\begin{alltt}
\(\dagger\theta\flat\)
\end{alltt}
\vfigend{ps:stm}{Symbols in working memory}

I have not said anything about what these symbols might mean. The
production system itself has no knowledge of this, and its operation
does not depend at all on their meaning. The symbols only gain their
meaning by virtue of their relationship to other symbols, rules,
perceptions, and motor commands.


\subsection{How a production system works}

A production system works by repeating the same cycle over and over
again. Each cycle consists of three stages: {\it recognise}; {\it
resolve}; and {\it act}. In the first stage, the system searches for all
the rules which {\it match} the symbols in working memory --- that is,
all the rules whose left-hand sides are somehow satisfied by these
symbols. In the second, resolution, stage, it chooses one and only one
of these rules. And in the third, act, stage, it {\it fires} it. This
means that it adds the symbols in its right-hand side to working memory.

How would this work with the example shown above in figures~\ref{ps:stm}
and \ref{ps:ltm}? Our initial working memory contains the pattern
$\dagger\theta\flat$. Looking at the left-hand sides of the
rules, only one rule matches --- number 1. So the first stage ---
recognise --- returns just one rule. This makes the resolve stage
trivial --- it returns the same rule. Finally, the act stage fires the
rule. This adds the symbols $\Box\smile\angle$ to working
memory, which now looks like this:
\begin{alltt}
\(\Box\smile\angle\)
\(\dagger\theta\flat\)
\end{alltt}

That's the end of the first cycle. We now go round again. This time, two
rules match: number 1 and number 4. So the recognise stage returns
these two rules. What is the resolve stage to do? There are various
possible answers. One method, used in Eden, is to
prefer rules that haven't been used recently over those that have. The
system notes when each rule fired, and chooses the least recently fired
to fire again.

The justification of this is that it prevents the system applying the
same rule over and over again, and so helps to stop it getting stuck in
a loop. In the jargon of production systems, we could call this
resolution by inverse rule-firing-recency. It would sometimes also be
called resolution by rule-refractoriness, the idea being that
recently-fired rules are supressed by less recently-fired rules, and
suffer a ``refractory'' or non-firing period.

In our example, rule number 4 is definitely less recent, since it hasn't                  
been fired at all. The system therefore chooses it in preference to rule
1. The act stage can then add the symbols on the right-hand side of rule
4 to working memory, giving this:
\begin{alltt}
\(\Box\sim\dagger\)
\(\Box\smile\angle\)
\(\dagger\theta\flat\)
\end{alltt}

We are now ready for the third cycle. This time, three rules match,
rules 1, 4, and 2. Rule 2 is less recent than the others, since it has
never fired. So the resolve stage chooses it. Firing it then
adds $\theta\Box\frown\Xi\dagger$ to working memory, giving:
\begin{alltt}
\(\theta\Box\frown\Xi\dagger\)
\(\Box\sim\dagger\)
\(\Box\smile\angle\)
\(\dagger\theta\flat\)
\end{alltt}

Now the fourth cycle. Again, only three rules match, the same as above.
So the recognise stage returns them. What should the resolve stage do?
If we go strictly by recency, then rule 1 is now the least recent, so we
would choose it, and fire it, adding $\Box\smile\angle$ again.         
However, taking this approach isn't very helpful, because we will
continually add the same pieces of data over and over again.

An alternative approach might be to say that once a rule has fired, it
should never be allowed to fire again until it can add something
different. This would eliminate all of rules 1, 2, and 4. And there are
many other possible resolution methods. Which ones we choose depends on
what we are using the system for.


\subsection{So what are production systems for?}

The simplest way to regard them is just as a programming language. Such
a language contains just one construct --- the rule --- and so
should be easy to learn; unlike (say) Pascal, with its range of data
types, loop structures, conditionals, and other statement types. There
have in fact been several production-system languages, most used from
the mid-70's to the mid-80's. The best-known is OPS5, promoted for
writing expert systems.

Although it's easy to understand how production systems work, it is not
in fact easy to write big programs, and production-system languages
have fallen out of favour. The problem is that it can be hard to
see exactly what the resolution strategies will do, and hence in what
order rules will fire and data be added to memory. I have added some
features to the Eden production system which avoid some of these
problems.

The main reason for being interested in them is their use as cognitive
models. The notion of a production system probably dates from the 40's,
when some logicians used them as idealised mathematical models of
computation, in the same spirit as a Turing machine. As far as
psychology is concerned, they became important in the early 70's, when
Newell, Simon and Shaw adopted them as a model of human cognition. The
idea was that, at the lowest level, the brain is of course built from
neural hardware. However, this hardware implements short-term and
long-term memories, rule matchers, and other components of a production
system, in the same way that the logic gates in a computer implement
adders, registers, and other components of a digital computer.

We can understand how a computer program works by explaining its
operation in terms of adders, registers, and so on. It is not necessary
to know how these are built from logic gates. In the same way (say the
production-system theorists) we can explain cognitive processes in terms
of the rules that are fired, the symbols that are added to STM, and so
on. It is not necessary to know what is going on at the neural level.


\subsection{The functional architecture of cognition}

This view is often expressed by saying that the the neurophysiological
hardware of the brain implements a ``cognitive processor'', a simple
symbol-manipulating machine, and that this is a production system. For a
statement of this view, see {\it Foundations of Cognitive Science}
edited by Posner (Springer-Verlag 1989; PSY BH:P 084), Chapter 3.

But there can be many different types of production system. Here's a
list of some of the ways they could differ:
\begin{enumerate}
\item The symbols allowed --- what, and how many?
\item The resolution methods. You will see below that Eden has
various other methods I haven't yet mentioned.
\item The capacity of STM. Is there a maximum size, and if so, what
happens when more symbols are added? Do old ones drop out? If so, how
does this depend on the time they were added? Is there any kind of
``chunking'' mechanism, so that symbols can be grouped into a single
slot?
\item The rules' conditions. Can these test perceptual data directly, or
must they go via STM? What is the maximum size of pattern you can have?
Can you have ``wild card'' patterns --- so that $\Box$\verb/_/$\angle$
for example, might match any set of symbols starting with $\Box$ and
ending in $\angle$. Can the conditions check how many of some symbol
there are?
\item The rule's actions. Can these generate actions directly, or must
these go via STM? How many symbols can they add? Can they delete
symbols?
\end{enumerate}

Different theorists have proposed different types of cognitive
processor. The ways in which one differs from another: the complexity of
its rules, the capacity of STM and so on, these define its {\it
functional architecture}. In the same way, a VAX, a PC, and an Apple Mac
are all computers, with the same general design. But the details of
their functional architecture --- the maximum size of number that can be
stored, the memory capacity, and so on --- are all different.

For those who want to follow up such topics, there is a good account of
how production systems work in pages 190--199 of the {\it Handbook of
AI} volume I, by Barr and Feigenbaum (Kaufmann 1981; PSY KH:B 27). There
are some famous production-system models of children's development:
these are introduced in {\it Computers and Thought --- a practical
introduction to AI} by Sharples, Hogg, Hutchinson, Torrance and Young
(MIT press, 1989): PSY KH:S531. The start of chapter 7 places production
systems in a psychological context, while pages 226--231 in chapter 8
describe their use in modelling childrens' subtraction. This is also
described in {\it Learning and Problem Solving 3}, Open University
Course D303, Block 4, Units 26--28 (in the Oversize section, AA:O 2--O
M), and in the Young and O'Shea article in {\it Cognitive Science} for
1981. Note: there is a misprint in {\it Computers and Thought} that sets
this article in 1982.

Why did Newell and Simon consider production systems good theories?
There's an early article by Newell, detailing some of the flaws he finds
in experimental psychology, and what production systems have to offer.
This appears in {\it You can't play 20 questions with nature and win},
in {\it Visual Information Processing}, edited by Chase (PSY BC:C 39).

Another view is given in Richard Young's chapter on {\it Production
Systems for Modelling Human Cognition} in {\it Expert systems in the
micro-electronic age} edited by Michie (E.U.P. 1980; PSY KH:M 58). One
of the most recent approaches is Newell's SOAR, in {\it Unified Theories
of Human Cognition} by (Harvard 1990; PSY BH:N 044). You will find a
short survey of the book in {\it Behavioural and Brain Sciences} volume
15, number 3, September 1992. This also contains a number of criticisms
of SOAR and the idea of unified theories.


\section{Production systems and Eden}

We're now going to look at production systems as used in Eden.
Before going any further, you need to know how to run Eden. If you
haven't already done so, break off here and read my handout on {\it How
to run Eden}. Work through all the examples, making sure you can log in,
start up Eden, run the bug it mentions, and log out. Then come back
here. You may also want to break off and learn how to use the editor, as
described in my handout on {\it Introduction to the editor}. Although
this isn't essential yet, you will find it useful because you can then
examine the view window more easily, using the \verb/v/ control command.
You can also examine the source code of the bugs directly, using the Ved
\verb/showlib/ command. So if you feel like it, work through the editor
handout now too.

Let's start by looking at a simple bug, one whose abilities are
limited to grabbing and eating those pieces of food within its immediate
range of vision. You can demonstrate it by giving the Prolog command
\begin{alltt}
eps( psbug1, psworld1 ).
\end{alltt}

Do that now. You will see that the bug locates and eats the three pieces
of food around it, before the life ends and control returns to Prolog.

So far, I've been pretty abstract about how production systems work.
It's now time to get more specific. What sort of rules do Eden bugs use?
What is their functional architecture of cognition? That is, what sort
of conditions can a rule have? How big can short-term memory be? What
resolution strategies are there? What can appear on the right-hand side
of a rule?


\subsection{{\tt psbug1}}

To start answering these questions, have a look at the code in
figure~\ref{ps:psbug1}, below:
\vfigstart
\begin{verbatim}
resolve [p,s,r].

stm [].

holding(+)      => exec([use]).
over(+)         => exec([grab]).
can_see(+)      => move_towards(+).
\end{verbatim}
\vfigend{ps:psbug1}{The source of {\tt psbug1}}
If you know how to use the editor, you can display this code on your
screen via the Ved \verb/showlib/ command. This is described near the
end of my editor handout. If you want to try, give the Ved command
\begin{verbatim}
showlib psbug1
\end{verbatim}
either from Prolog, or as a Ved ENTER command.

\begin{sloppypar}
What is going on in the above code? It's in three parts. The first,
\verb/resolve [p,s,r]/, specifies the resolution strategies to be used.
These letters stand for priority, specificity and recency respectively,
and the methods are applied in this order. Priority is irrelevant here.
It's possible, when writing rules, to give some of them higher priority
than others. But I haven't done this. Specificity refers to the
complexity of conditions. This doesn't matter here either, since all the
conditions are equally complex.

So the resolve stage first looks for the rules with the highest
priority. Since they all have the same priority, this doesn't help. It
then looks for the rule with the most specific --- most complex ---
condition. This doesn't help either. Finally it sorts the rules by
recency, choosing the least recently fired. You will see this process
reflected in the view diagnostics, and if you know how to use the
\verb/v/ control command, you can move around the view window and
inspect it in more detail.
\end{sloppypar}

The second part of the code, \verb/stm []/, specifies the initial
contents of short-term memory. The brackets with nothing between them
mean that it's empty. It's actually going to stay empty throughout the
life, since this bug reacts directly to its perceptions, and doesn't
build up any memory structures. This is why the view window repeatedly
displays the line
\begin{verbatim}
1 PS STM is
\end{verbatim}
meaning there's nothing in STM.

The third part is the most important --- the rules. Each rule is
separated into two parts, a {\it condition} and an {\it action}. Before
explaining these further, it's necessary to explain a bit about the bug's
sense of ``vision''.


\subsection{Bug's vision and the sensory predicates}

You may remember from the PopBeast handout that the bugs see a 5 by 7
rectangle. This is oriented as shown in figure~\ref{ps:retina}.
\vfigstart
\begin{alltt}
.  .  .  .  .
.  .  .  .  .
.  .  .  .  .
.  .  .  .  .
.  .  .  .  .
.  .  B  .  .
.  .  .  .  .
\end{alltt}
\vfigend{ps:retina}{A bug's visual field}

In this diagram, the bug is facing upwards, or ``north''. It perceives
this rectangle as a two-dimensional ``retinal image''. Each location in
the retina represents one square, and contains a space if the square is
empty, or a symbol such as \verb/+/ or \verb/*/ if it isn't. With one
exception, this symbol is always the same as what you see on the screen.
The single exception is in the square containing the bug itself.
Although the screen display shows a \verb/B/, the bug does not see this;
as with the other squares, it sees either a space or an object symbol.
It's worth noting that within the retinal rectangle, a bug's vision
never gets blocked by objects near it: it can always see the contents of
every square.

A bug brain can access this retina by various {\it sensory predicates},
such as \verb/can_see/ and \verb/over/. These implement simple logical
tests on the visual field. For example,
\begin{verbatim}
can_see(+)
\end{verbatim}
is true if there is a \verb/+/ somewhere on the retina, and false
otherwise. Similarly,
\begin{verbatim}
can_see('1')
\end{verbatim}
would be true if the bug can see a \verb/1/.

The predicate \verb/over/ is a more specific test than \verb/can_see/.
It is true only if the bug is in the same square as the specified
object. Thus
\begin{verbatim}
over(+)
\end{verbatim}
is true if the bug is in the same square as a piece of food. This is a
useful test, because you can only grab things that are in the same
square as you.

The predicate \verb/holding/ has nothing to do with the retina; it tests
what the bug is holding. Thus
\begin{verbatim}
holding(+)
\end{verbatim}
is true if the bug is holding a piece of food. It would be false if the
bug is holding something else, or if its hand is empty.


\subsection{Generating actions}

You can see from the rules in figure~\ref{ps:psbug1} that the sensory
predicates are used on the left-hand side, as conditions. What about the
right-hand sides?

The simplest thing the bug can do is to issue one of the eight primitive
actions described in {\it Introduction to Eden}.
If a rule wants to generate one of these actions, its right-hand side
should look like this:
\begin{verbatim}
exec( [use] )
\end{verbatim}
or
\begin{verbatim}
exec( [forward] )
\end{verbatim}

As well as the primitive actions, there are also some {\it motor
competances}. These are little chunks of program which combine the
primitive actions so as to do useful things. \verb/psbug1/ uses only one
of these: it is
\begin{verbatim}
move_towards(+)
\end{verbatim}
This causes the bug to move a bit nearer a piece of food. If it is
facing it, it will move one square in the appropriate direction;
otherwise it will turn towards it.


\subsection{Putting these together --- the rules}

To recap,\verb/psbug1/ had the following three rules:
\begin{verbatim}
holding(+)      => exec([use]).
over(+)         => exec([grab]).
can_see(+)      => move_towards(+).
\end{verbatim}

In English, these translate as follows:
\begin{alltt}
If you are holding a piece of food, then use it.
If you are in the same square as a piece of food, then grab it.
If you can see a piece of food, then move towards it.
\end{alltt}
I hope it's now clear how these work. If you look at the view window,
you'll see that there are some cases where more than one rule matches,
so that the resolve stage has to choose between them. It manages this on
the basis of recency, which in this example, always gives the desired
result.


\subsection{Another brain --- {\tt psbug2}}

Now let's look at behaviour in a more complex world. In the {\it How to
run Eden} handout, you demonstrated \verb/psbug2/, whose world contained
a coin and slot-machine as well as food. Here is its brain:
\vfigstart
\begin{verbatim}
resolve [p,s,r].

stm [].

holding(+)      => exec([use]).
over(+)         => exec([grab]).
can_see(+)      => move_towards(+).

can_see('1')    => move_towards('1').
over('1')       => exec([grab]).

can_see('S'), holding('1') => move_towards('S').
next_to('S'), holding('1') => turn_towards('S').
facing('S'), holding('1')  => exec([use]).
\end{verbatim}
\vfigend{ps:psbug2}{The source of {\tt psbug2}}

The top three rules are the same as those of \verb/psbug1/, and deal
with the case where there is food to be seen. But what if there isn't?
In this world, it makes sense, if you can see a slot machine and you
have a coin, to head towards the machine and use the coin. If you don't
have a coin, it's sensible to try acquiring one. The find-and-grab-coin
behaviour is controlled by the fourth and fifth rules: I've put a blank
line before them to make them easier to see as a separate group.

The find-and-use-slot-machine behaviour is controlled by the final three
rules. Notice that, unlike the others, these each have {\it two}
perceptual conditions on the left-hand side, combined by a comma, the
symbol for ``and''. So the first rule means
\begin{alltt}
If you can see a slot-machine, and you are holding a coin,
then move towards the machine.
\end{alltt}
There is an added complication here. You can only use a coin in a
machine if you are facing towards it. Although in most cases, moving
towards the machine will leave the bug facing the right way, this isn't
necessarily so, e.g. if he backs towards it. Hence I have had to add a
rule to make him do so, the one which activates
\verb/turn_towards('S')/. Note that I have also introduced two new
perceptual conditions. These are \verb/next_to/, which is true if the
bug is standing on an adjacent square to an object; and \verb/facing/
which is true if he is next to an object and facing towards it.

This concludes the handout. The next thing to learn is how to use the
editor to create your own rules. I shall go into this in a future
handout.

\end{document}
ences} volume
15, number 3, September 1992. This also contains a number of criticisms
of SOAR and the idea of unified theories.


\section{Production systems and Eden}

We're now going                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                 ps1.pl                                                                                              100705  017064  000205  00000016314 05427665621 006427  0                                                                                                     47426                                                                                    1  0                                                                                                                                                                 /*  PS.PL  */


:- module ps.


:- public /.


/*
SPECIFICATION
-------------
*/


/*
IMPLEMENTATION
--------------

bagof not portable.
*/


ps( Time, Rules, STM0, StopPred, SR, WE, Context0, STM ) :-
    WE:report( ps, start, Time ),
    WE:report( ps, stm, stm_(STM0,4) ),
    match( Rules, STM0, Matched ),
    WE:report( ps, matched(Matched) ),
    Matched \= [],
    !,
    resolve( Matched, STM0, SR, Context0, Resolved ),
    we_report( WE, ps, 'Resolved to give rule'...rules_(Resolved,4)~ ),
    fire( Resolved, Time, STM0, Context0, STM1, Context1 ),
    we_report( WE, ps, 'STM is'...stm_(STM1,4)~~ ),
    Time1 is Time + 1,
    ps_continue_if_necessary( Time1, Rules, STM1, StopPred, SR, WE, Context1, STM ).

ps( _, _, _, _, _, _, _, _ ) :-
    true.
    /* if no rules matched.  */


ps_continue_if_necessary( Time, Rules, STM, StopPred, SR, WE, Context, STM ) :-
    Goal =.. [ StopPred, STM ],
    call( Goal ),
    !.

ps_continue_if_necessary( Time, Rules, STM0, StopPred, SR, WE, Context, STM ) :-
    ps( Time, Rules, STM0, StopPred, SR, WE, Context, STM ).


ps( Rules, STM0, StopPred, SR, WE, STM ) :-
    ps( 1, Rules, STM0, StopPred, SR, WE, [], STM ).


ps( Rules, STM0, StopPred, SR, STM ) :-
    ps( Rules, STM0, StopPred, SR, no_ved, STM ).


fire( Rule, Time, STM0, Context0, STM, Context ) :-
    rule_vs_action( Rule, Action ),
    fire_all( STM0, Time, Action, STM ),
    Context = [ fired(Rule,Time) | Context0 ].


fire_all( STM, _, [], STM ) :- !.

fire_all( STM0, Time, [Action1|ActionsN], STM ) :-
    fire_one( STM0, Time, Action1, STM1 ),
    fire_all( STM1, Time, ActionsN, STM ).


fire_one( STM0, Time, erase(Term), STM1 ) :-
    !,
    stm_delete( STM0, Time, Term, STM1 ).

fire_one( STM0, Time, Term, STM1 ) :-
    stm_insert( STM0, Time, Term, STM1 ).


/*
Matching.
---------
*/


match( Rules, STM, Matched ) :-
    fast_bagof(
            Rule,
            (   rules_member( Rule, Rules ),
                rule_vs_condition( Rule, Cond ),
                match_cond( Cond, STM )
            ),
            Matched
         ).


match_cond( [], _ ) :- !.

match_cond( [C1|CN], STM ) :-
    !,
    match_primitive_cond( C1, STM ),
    match_cond( CN, STM ).


match_primitive_cond( X>Y, _ ) :- !, X > Y.

match_primitive_cond( X>=Y, _ ) :- !, X >= Y.

match_primitive_cond( X<Y, _ ) :- !, X < Y.

match_primitive_cond( X=<Y, _ ) :- !, X =< Y.

match_primitive_cond( Term, STM ) :-
    stm_member( Term, STM ).


/*
Conflict resolution.
--------------------
*/


resolve( [], STM, _, Context, _ ) :-
    !,
    bug( 'resolve: no rules', [STM,Context] ).

resolve( [Rule], _, _, _, Rule ) :- !.

resolve( Rules, STM, SR, Context, Rule ) :-
    (
        SR = sr
    ->
        resolve_by_specificity( Rules, STM, MostSpecific ),
        resolve_by_recency( MostSpecific, STM, Context, [Rule|_] )
    ;
        SR = rs
    ->
        resolve_by_recency( Rules, STM, Context, LeastRecent ),
        resolve_by_specificity( LeastRecent, STM, [Rule|_] )
    ;
        SR = s
    ->
        resolve_by_specificity( Rules, STM, [Rule|_] )
    ;
        SR = r
    ->
        resolve_by_recency( Rules, STM, Context, [Rule|_] )
    ;
        bug( 'resolve: bad SR', [Rules, STM, SR, Context] )
    ).


resolve_by_specificity( Rules, STM, MostSpecific ) :-
    tag_by_unspecificity( Rules, TaggedRules ),
    keysort( TaggedRules, Sorted ),
    untag( Sorted, MostSpecific ).


resolve_by_recency( Rules, STM, Context, LeastRecent ) :-
    tag_by_time( Rules, Context, TaggedRules ),
    keysort( TaggedRules, Sorted ),
    untag( Sorted, LeastRecent ).


tag_by_unspecificity( [], [] ) :- !.

tag_by_unspecificity( [Rule|Rules], [MinusS-Rule|Taggeds] ) :-
    rule_condition( Rule, Cond ),
    conditions_specificity( Cond, S ),
    MinusS is -S,
    !,
    tag_by_unspecificity( Rules, Taggeds ).


conditions_specificity( L, S ) :-
    conditions_specificity( L, 0, 0, S ).


conditions_specificity( [], Sum, Count, S ) :-
    !,
    S is Sum.
    /*  Don't take average.  */

conditions_specificity( [C1|Cn], Sum0, Count0, S ) :-
    condition_specificity( C1, CS ),
    Sum1 is Sum0 + CS,
    Count1 is Count0 + 1,
    conditions_specificity( Cn, Sum1, Count1, S ).


condition_specificity( C1, CS ) :-
    C1 =.. [ _ | Args ],
    args_specificity( Args, AS ),
    CS is AS + 1.


args_specificity( Args, S ) :-
    args_specificity( Args, 0, S ).


args_specificity( [], S, S ) :- !.

args_specificity( [A1|AN], S0, S ) :-
    var(A1),
    !,
    S1 is S0 + 0.5,
    args_specificity( AN, S1, S ).

args_specificity( [A1|AN], S0, S ) :-
    S1 is S0 + 1,                    
    args_specificity( AN, S1, S ).


tag_by_time( [], _, [] ) :- !.

tag_by_time( [Rule|Rules], Context, [Time-Rule|Taggeds] ) :-
    member( fired(Rule,Time), Context ),
    !,
    tag_by_time( Rules, Context, Taggeds ).

tag_by_time( [Rule|Rules], Context, [0-Rule|Taggeds] ) :-
    tag_by_time( Rules, Context, Taggeds ).


untag( [], [] ) :- !.

untag( [_-H|T], [H|T1] ) :-
    untag( T, T1 ).


/*
Rules.
------
*/


rule_vs_action( rule(_,Action), Action ).


rule_vs_condition( rule(Cond,_), Cond ).


rules_member( Rule, Rules ) :-
    member( Rule, Rules ).


rule_insert( Rules, Rule, [Rule|Rules] ).


show_rules( Rules, Indent ) :-
    forall(
        rule_member( rule(Cond,Action), Rules ),
        output( spaces_(Indent)<>rule(Cond,Action)~ )
    ).


/*
STM.
----
*/


new_stm( stm(0,0,[]) ).


stm_insert( stm(LastTime,LastTag,Facts0), Time, Term, stm(Time,Tag,Facts) ) :-
    (
        LastTime = Time
    ->
        Tag is LastTag + 1
    ;
        Tag = 1
    ),
    TimeStamp is Time*1000 + Tag,
    Facts = [ fact(Term,TimeStamp) | Facts0 ].


stm_delete( stm(LastTime,LastTag,Facts0), Time, Term, stm(Time,Tag,Facts) ) :-
    (
        LastTime = Time
    ->
        Tag is LastTag + 1
    ;
        Tag = 1
    ),
    delete( Facts0, fact(Term,_), Facts ).
    /*  Variables in Term must remain unbound. This is ensured by
        'delete'.
    */


stm_member( Term, TimeStamp, stm(_,_,Facts) ) :-
    member( fact(Term,TimeStamp), Facts ).


stm_member( Term, stm(_,_,Facts) ) :-
    stm_member( Term, TimeStamp, stm(_,_,Facts) ).


show_stm( STM, Indent ) :-
    forall(
        stm_member( Term, TimeStamp, STM ),
        output( spaces_(Indent)<>Term...'('<>timestamp_(TimeStamp)<>')'~ )
    ).


list_to_stm( L, STM ) :-
    new_stm( STM0 ),
    list_to_stm( L, STM0, STM ).


list_to_stm( [], STM, STM ) :- !.

list_to_stm( [Term|Terms], STM0, STM ) :-
    stm_insert( STM0, 0, Term, STM1 ),
    list_to_stm( Terms, STM1, STM ).


/*
Output.
-------
*/


:- add_user_output( ps_output ).


ps_output( timestamp_(T) ) :-
    !,
    Time is T div 1000,
    Tag is T mod 1000,
    output( Time<>'.'<>Tag ).

ps_output( stm_(STM,Indent) ) :-
    !,
    show_stm(STM,Indent).

ps_output( rules_(Rules) ) :-
    !,
    output( Rules ).
    /* temp. */


:- endmodule.
rules are the same as those of \verb/psbug1/, and deal
with the case where there is food to be seen. But what if there isn't?
In this world, it makes sense, if you can see a slot machine and you
have a coin, to head towards the machine and use the coin.ps2.tex                                                                                             100705  017064  000205  00000034060 05427665622 006614  0                                                                                                     47426                                                                                    1  0                                                                                                                                                                 \documentstyle[a4,epsf,alltt]{article}
\begin{document}


\include{commands}
\newcommand{\ital}[1]{{\it #1}}

\title{Production systems (2)}
\author{Jocelyn Paine}
\maketitle


\section{Production systems and working memory}

In the previous handout on {\it Production systems}, I introduced the
general idea of a production system, and then demonstrated one
particular type of production system --- one functional architecture of
bug cognition --- applied to two bugs. In some ways, the demonstration
was a bit of a cheat. I introduced production systems as working mainly
on symbols in a short-term memory, but the two bugs didn't use STM at
all. They worked entirely on perceptual predicates and actions, and
their STMs remained empty throughout. In this handout, I'll remedy that,
with some bugs that think a bit before reacting.       


\subsection{Holidays}                   

In order to think, you need something to think about. In the context of
Eden, this means that you must be able to gather data before being able
to use it. This introduces issues of learning, navigation, and so
on, which I don't want to complicate matters with. I'm therefore going
to start with an example that has very little to do with Eden.

Please look at the rules below, in figure~\ref{ps2:holidays}.
\vfigstart
\begin{verbatim}
resolve [p,s,r].


stm [ mp,
      hot
    ].


stm_predicates all.


computer_hacker => rich.
management_consultant => rich.
mp => rich.

hairdresser => poor.
teacher => poor.
toilet_cleaner => poor.

poor => near.
rich => far.

near, hot => costa_del_sol, done.
near, cold => aberdeen, done.
far, hot => egypt, done.
far, cold => switzerland, done.

done => exec([forward]), exec([wait]).
\end{verbatim}
\vfigend{ps2:holidays}{Where to go for holiday}

In this program, we have the statement \verb/stm_predicates all/. Like
the \verb/resolve/ statement, this is something that programmers call a
{\it declaration} --- a statement that isn't itself obeyed as the
program runs, but that alters the way other symbols are interpreted or
other statements are executed. The declaration \verb/stm_predicates all/
tells Eden that all the names in rules refer to symbols in STM and not
to perceptual predicates or motor commands. Actually, there is one
exception to this: this is \verb/exec/ which is always taken as obeying
an action.

The initial contents of STM is given by the symbols after \verb/stm/:
that is, \verb/mp/ and \verb/hot/.

What do these symbols mean? The production system does not care, and
would work equally well if they were all meaningless names. However,
you can see that they have something to do with choosing holidays. The
idea is that you start the STM off by telling it what your job is, and
whether you like hot or cold weather. The job must be one of
\verb/computer_hacker/, \verb/hairdresser/,
\verb/management_consultant/, \verb/mp/, \verb/teacher/,
or \verb/toilet_cleaner/. The weather must be either \verb/hot/ or
\verb/cold/. The production system then runs a few rules, and eventually
comes up with the name of a country or resort, which it puts into STM.
It then obeys the bug-actions \verb/forward/ and \verb/wait/.

You can test the production system for yourself by doing
\begin{verbatim}
eps( holidays, psworld0 ).
\end{verbatim}
\verb/psworld0/ is set up so that the bug is standing just in front of a
quicksand. Once it has reached a conclusion, the rules make it obey the
\verb/forward/ and \verb/wait/ actions. These cause it to move onto the
quicksand and turn left: as described in the table of objects in {\it
How to run Eden}, this kills it! That's really just a nasty trick for
ending the life once a country has been chosen.

How do the rules work? I hope this is clear from my original discussion
of production systems. If not, you can follow it in Eden by looking at
the view window. This time, the diagnostics are quite long, so you will
almost certainly want to scroll through them with the editor, or to
print the window. How to do this was described in the {\it Editing the
view window} section in my editor handout. Briefly, you type the Eden
control command \verb/v/, and then give the editing command ENTER
\verb/ctcprint/ RETURN. This will print the window on the printer on the
first floor of CTC. To help with following the rules, the figure below,
figure~\ref{ps2:holidays_stm}, shows successive snapshots of the bug's
STM. Next to each fact is an annotation showing when it was added. The
number before the point identifies the production-system cycle; the
number after it shows when during that cycle.
\vfigstart
\begin{verbatim}
hot (0.2)
mp (0.1)

rich (1.1)
hot (0.2)
mp (0.1)

far (2.1)
rich (1.1)
hot (0.2)
mp (0.1)

done (3.2)
egypt (3.1)
far (2.1)
rich (1.1)
hot (0.2)
mp (0.1)
\end{verbatim}
\vfigend{ps2:holidays_stm}{The holiday-bug's STM}

If you want to experiment with changing these rules, or the initial
contents of STM, you may, provided you know how to edit and run your own
programs. For instructions on how to do this, see my handout on
{\it Editing your own programs}.


\subsection{Another example}

I will add another example sometime. In the meantime, why not try
writing your own. Some kind of diagnostic system is best, that starts
off with symbols denoting ``symptoms'' (in the broadest sense, e.g. they
could be the names of geological features, or of pop groups, from which
you infer the type of rocks present underground, or the type of rock
music someone likes). If you imitate the example above you should have
no problem. The handout on {\it Editing your own programs} gives, at its
end, some info on program structure.


\section{Production systems, predicates, and logic}

In the examples above, all the rules' primitive conditions were simple
``words'' like \verb/hot/ and \verb/mp/. It is possible to have more
complex conditions, which is where a connection with logic comes in. For
an example, have a look at the first two rules below. Ignore the third
one for the moment: it's another trick for killing the bug once enough
inferences have been made.
\begin{verbatim}
likes(mary,wine) => loves(john,mary).
likes(mary,beer) => loves(bill,mary).
loves(_,_) => exec([forward]), exec([right]).
\end{verbatim}

You will find a copy of these in the file \verb/l1.pl/, with the STM
initialised to \verb/likes(mary,wine)/. Try running them with
\verb/psworld0/:
\begin{verbatim}
eps( l1, psworld0 ).
\end{verbatim}
You will see that the final contents of STM is as shown below.
\begin{verbatim}
loves(john, mary) (1.1)
likes(mary, wine) (0.1)
\end{verbatim}
That is, the symbols \verb/loves(john,mary)/ have been added. This was done
by firing the first rule. So groups of symbols can have a more
complicated structure than in the holidays example.


\subsection{Predicates and arguments}

In fact, this structure will be familiar if you have studied logic. A
group starts with a name followed by an open bracket. This is called the
{\it predicate}. After the bracket come a sequence of names or numbers
separated by commas. These are called the {\it arguments} of the
predicate. Finally, there comes a closing bracket. Note that the word
``argument'' is used in a technical sense peculiar to mathematics; this
sense has nothing to do with its everyday meaning.

Predicates can have any number of arguments, so groups like these are
all valid:
\begin{verbatim}
job(mp)
loves(john,mary)
pub(prince_of_wales,walton_street,oxford,morrells) 
\end{verbatim}

If a predicate has no arguments, then you just write its name:
\begin{verbatim}
mp
hot
\end{verbatim}
Prolog will not allow you to have the name followed by an empty pair of
brackets, though some other languages do.


\subsection{What do they mean?}

I have repeatedly emphasised that, as far as the production system is
concerned, the groups of symbols are completely arbitrary. Only their
form matters to the program that runs the matching, resolution, and
firing processes, not their content. However, when we write programs, we
usually do intend each name to have some content --- to refer to
something. Here are some examples of two-argument predicates, where the
meaning should be clear.
\begin{verbatim}
event( 1756, mozarts_birth )
loves( joe, mary )
teaches_at( joseph, st_annes )
colour( grass, green )
legs( sheep, 4 )
costs_pence( mars_bar, 21 )
is_a( sheep, mammal )
\end{verbatim}

For such predicates, the predicate usually names a relation that
holds between its arguments. This is easiest to see with spatial
predicates, such as
\begin{verbatim}
on( block_a, block_b )
\end{verbatim}
You can also use predicates to say that an object has a certain
property, to say that an object belongs to a certain class, or to give
the result of operating on the object in a certain way. The last use is
like that of a function in maths, where one argument is the input and
the other is the result.

Predicates of fewer or more than two arguments can also be interpreted
as relations, though this is less obvious to non-logicians.

In most programs, the names appearing as arguments are used in one
of three ways:
\begin{center}
\begin{tabular}{llll}
To name individuals &   \verb/john/   &  \verb/egypt/ \\
To name properties  &   \verb/rich/   &  \verb/hot/   \\
To name classes     &   \verb/teacher/&  \verb/wine/
\end{tabular}
\end{center}

A predicate and its arguments form a {\it proposition}: a logical
statement. This may be either true or false, depending on the meaning of
all the names and the state of the real world. Here are some
propositions and possible meanings:
\begin{center}
\begin{tabular}{ll}
\verb/mp/                  & I am an MP. \\
\verb/egypt/               & I should go to Egypt on holiday. \\
\verb/rich /               & I am rich. \\
\verb/loves( john, mary )/ & John loves Mary.
\end{tabular}
\end{center}

When writing a program, you should always keep the intended meanings of
your predicates and arguments in mind. It is not always clear from the
names alone. For example, does \verb/gold/ refer to gold as a chemical
entity in general, or to gold in finance at a particular time, or to a
particular chunk of gold? Compare its meaning in the sentences ``Gold
does not dissolve in water'', ``Gold rose by \pounds 2.45 today'', and
``The gold in this ring was mined in 1847''.

As another example, of a different kind, does \verb/on(block_a,block_b)/
mean that A is standing on B, or that B is standing on A? Be careful
about the order of your arguments.


\subsection{Rules, inference, implication, and logic programming}

When we think of groups of symbols as propositions, we can see that a
production rule is a device which, given the fact that its left-hand
propositions are true, makes explicit the fact that the right-hand
propositions are true. We can therefore view production rules as {\it
rules of logical inference}: rules which, given one set of true
propositions, {\it infer} another set of true propositions. The rule in
\verb/l1.pl/ infers the proposition \verb/loves(john,mary)/ from the
proposition \verb/likes(mary,wine)/. That is, if you tell the rule that
\verb/likes(mary,wine)/, it will infer that \verb/loves(john,mary)/.

This is what {\it logic programming} is all about. In languages such as
Pascal and Basic, you program by telling the computer how to accomplish
some task. Your program consists of a sequence of little instructions,
which if obeyed in the right order will (hopefully) do the right thing.

But in logic programming, you describe your program in logic. Your
program consists of an initial set of propositions, plus a set of rules
which infer new propositions from old. In our production system, the
initial set of propositions is the initial STM, and the rules are the
production rules.

Logic programming became famous at the start of the 80's, with the
growth of interest in expert systems, Prolog, and the Japanese Fifth
Generation Project. For background reading on this, see {\it The Guide
to Expert Systems}, by Alex Goodall (Learned Information, 1985;
somewhere in PSY). Look at the chapters on logic programming (number 6,
I think), and on the history of AI. The most famous logic programming
language is Prolog, and in fact the Eden production system is built on
Prolog. They therefore share a number of similarities, particularly in
the syntax of predicates and in the way conditions are handled.

One of the important things about logic programming is that you can view
the rules, as well as the propositions, as logical statements. The rule
\begin{verbatim}
likes(mary,wine) => loves(john,mary).
\end{verbatim}
can be read as an implication: ``If Mary likes wine then John loves
Mary'' or ``Mary likes wine implies John loves Mary''.  Similarly, the
rule
\begin{verbatim}
far, hot => egypt, done.
\end{verbatim}
can be read as the implication ``If you can go somewhere far, and you
like it hot, then Egypt would suit you''.

You should note that not all production systems can be used for logic
programming. The Eden one can because it has facilities for grouping
symbols into predicates and arguments, and because the matching and
rule-firing were designed (with help from Prolog) to model logical
inference. However, matching and rule-firing don't have to work this
way.

Note also that, even in this production system, it's hard to interpret
some rules logically. This is particularly true of rules which create
symbols denoting a stage in the computation, or which obey actions.
You see both in the rule
\begin{verbatim}
loves(_,_) => exec([forward]), exec([right]).
\end{verbatim}
I used this to trigger an action once a \verb/loves/ fact had been
derived.


[The rest of this handout remains to be written. Ask me what to do
next. You could have a look at the bug \verb/skier.pl/, try running
it in \verb/psworld0/, and try making sense of it with the notes
at the end of the {\it Editing your own programs} handout.]


\end{document}
 a country has been chosen.

How do the rules work? I hope this is clear from my original discussion
of production systems. If not, you can follow it in Eden by looking at
the view window. This time, the diagnostics are quite long, so you will
almost certainly want to scroll through them with the editor, or to
print the window. How to do this was described in the {\it Editing the
view window} section in my editor handout. Briefps3.tex                                                                                             100705  017064  000205  00000054354 05427665623 006626  0                                                                                                     47426                                                                                    1  0                                                                                                                                                                 \documentstyle[a4,epsf,alltt]{article}
\begin{document}


\include{commands}
\newcommand{\ital}[1]{{\it #1}}

\title{Production systems (3)}
\author{Jocelyn Paine}
\maketitle


\section{Introducing {\tt gbug}}

This handout arises from something Gareth was trying to do in order to
make the bug's behaviour more directed. It demonstrates how data in STM
--- particularly goals and planned paths --- can be used to control
behaviour.

To begin, please try running \verb/gbug/ in \verb/gworld/, by doing
\begin{verbatim} eps( gbug, gworld ). \end{verbatim} When you try this
for the first time, switch off the diagnostics with the \verb/-/ control
command, and then run the bug for about 100 cycles by doing \verb/s
100/. This will enable you to appreciate the bug's behaviour without
being distracted by streams of diagnostics.

Notice that there is a lot less ``dithering'' than in the other bugs
you've seen. When the bug sees a piece of food, it heads straight
towards it, ignoring distractions on the way. Most of the other bugs got
confused by two pieces of food equally near them, and would continuously
turn toward one and then the other, never actually getting to either.
\verb/gbug/ doesn't do this.

How does this bug work? Its code is shown below, in
figure~\ref{ps3:gbug}.
\vfigstart
\begin{verbatim}
resolve [p,r].

stm [ goal(notice_food) ].

stm_predicates [goal,path].


goal(notice_food),
can_see(+)
=>
erase(goal(notice_food)),
goal(plan_path).

goal(notice_food),
not(can_see(+))
=>
wander.


goal(plan_path),
retina(X,Y,nearest(+)),
retina_path( [3,2], [X,Y], Path )
=>
path(Path),
erase(goal(plan_path)),
goal(check_path_found).


goal(check_path_found),
path(not_found)
=>
erase(goal(check_path_found)),
goal(notice_food).

goal(check_path_found),
not(path(not_found))
=>
erase(goal(check_path_found)),
goal(follow_path).


goal(follow_path),
path( [First|Rest] )
=>
exec( First ),
erase(path(_)),
path(Rest).

goal(follow_path),
path( [] ),
over(+)
=>
erase(goal(follow_path)),
erase( path([]) ),
exec( [grab] ),
exec( [use] ),
goal( notice_food ).

goal(follow_path),
path( [] ),
not( over(+) )
=>
erase(goal(follow_path)),
erase( path([]) ),
goal( notice_food ).


:- prolog_language(pop11).

needs retina_path;

define safe(awm,x,y);
    awm(x,y) /= `*`
enddefine;

define find_path(start,goal);
    lvars start, goal;
    retina_path( retina(),start,goal,safe);
enddefine;

:- prolog_language(prolog).

:- reconsult('path_to_moves.pl').

retina_path( Start, Goal, Moves ) :-
    prolog_eval( find_path(Start,Goal), Path ),
    path_to_moves( [0,1], Path, Moves_, _ ),
    moves_to_commands( Moves_, Moves ),
    !.

retina_path( Start, Goal, not_found ).


moves_to_commands( [], [] ) :- !.

moves_to_commands( [Move|Rest], [[Move]|Rest1] ) :-
    moves_to_commands( Rest, Rest1 ).
\end{verbatim}
\vfigend{ps3:gbug}{{\tt gbug}}             

At the end of this code, you will see a notation that will be strange to
you. This is a mixture of Prolog and Pop-11, and is there to interface a
path-planning predicate to the rules. I'll say more about that later.

Once you have tried the bug with the diagnostics turned off, run it
again with them on, and let it get as far as finding two or three pieces
of food. Exactly what it does will vary from run to run because of the
random element in \verb/wander/. However, you should find that 30 cycles
are sufficient. Then print out the view window so you can examine it more
closely. You can do this in two ways. Either edit the window with the
\verb/v/ control command during a life, and then give the ENTER
\verb/ctcprint/ command to Ved. Or wait until the life has finished, and
then do \verb/ved view/ from Prolog, followed by the ENTER \verb/ctcprint/
command. If you haven't already been shown how to use the CTC printer,
ask me. It's a dot matrix one, so it isn't very quick.

Having got a paper copy of your trace, look at the way that STM changes,
and at the rules that are fired. As you can see from the \verb/stm/
declaration, there are two STM predicates: \verb/goal/ and \verb/path/.
Each of these has one argument --- predicates with arguments were
introduced towards the end of my second handout on production systems.
In the trace, when STM predicates appear in the rules, they are marked
with an \verb/@/ symbol, although this doesn't appear in STM, or in the
rules as you write them. That helps to distinguish STM predicates from
perceptual ones, and is useful as a check against failing to declare
them properly. Before proceeding to the following section, try to get an
idea of what's going on for yourself. Concentrate on how the arguments
to these two STM predicates change in each PS cycle.

One minor point is that the resolution step never needs to be carried
out. I have constructed the rules in such a way that only one matches at
any stage. That makes the trace shorter; more important, it also makes
the program easier to understand. Although resolution is an important
component of PS's as psychological models, it does make the effect of a
program harder to predict. In general, unless you are using PS's for
cognitive modelling, it is worth making rule conditions as explicit as
possible, to cut down the number of rules that need to be resolved.


\section{Goals}

Every rule's condition contains a test on \verb/goal/, and many of the
rules erase the old \verb/goal/ fact and add a new one. This predicate
has four possible arguments:
\begin{verbatim}
check_path_found
follow_path
notice_food
plan_path
\end{verbatim}

Each argument indicates that the bug is trying to achieve a particular
goal, and is carrying out a particular kind of behaviour in order to do
so. What conditions cause it to change from one to another? You can
depict this diagrammatically in a {\it state transition diagram}. Take
some paper, and draw four points, one for each of the arguments. Label
each with its argument. Then think about the circumstances under which
the bug will change its goal from --- for example --- \verb/notice_food/
to \verb/plan_path/. Draw an arrow pointing from the \verb/notice_food/
node to the \verb/plan_path/ node. Write alongside this arrow the
circumstance which causes this change of goal. You can either write it
in English, or as a rule condition.

Altogether, with four points, there are twelve possible arrows. However,
not all of them exist in this bug. Fill in the rest of the ones that do,
and write the corresponding circumstance by each. This kind of diagram
is often useful in getting an overview of how complex systems behave.
The points, incidentally, are usually drawn as little circles, and
called {\it nodes}; the arrows are often called {\it arcs}. In many
systems, the transition from one node to another will not be
deterministic, and the arcs will have probabilities associated with
them.


\subsection{Adding a new goal}

If you have understood how STM predicates work, and how \verb/erase/
works, I hope it's not necessary for me to explain the goals further,
except in their interaction with path-planning. You can test your
understanding by trying the following problem.

\verb/gworld1/ is similar to \verb/gworld/. You will notice however that
each piece of food is next to some water. In this new world, once the
bug has eaten a piece of food, he becomes dirty. The smell attracts
predators, and if the bug does not wash himself within the next few
turns, he will be eaten! (The current version of Eden does not make the
predators visible, because it can't deal properly with other autonomous
objects: so far, they're just my plot device to explain why the bug
dies.)

You can demonstrate this by running \verb/gbug/ in the new world.
Lacking the necessary cleaning behaviour, it will soon perish. Note the
state of the bug's cleanliness, displayed on the second status line.

Now, assume that once the bug has eaten the food, he must set himself a
new goal: to wash. This entails first getting over the water, which can
be done with \verb/move_towards/, and then \verb/use/ing it. Having
washed, he should then go back to noticing food. Because each piece of
food is always very near to water, it isn't necessary to do
path-planning: you can just call \verb/move_towards/. Add a new rule or
rules to do this, imitating the use of goals in \verb/gbug/. Once it
works, update your state-transition diagram accordingly.


\subsection{Adding another goal}

In \verb/gworld2/, it isn't the world but the bug that I have made more
complicated. As in \verb/gworld1/, the bug must wash immediately after a
meal. But it also needs to defecate. Eating food puts the bug into a
state of digestion, shown on the first status line. Once in this state,
it must defecate within 15 moves, otherwise it will burst. Defecation is
achieved by performing the (new) action \verb/defecate/, and can only be
done in an empty cell. You can demonstrate this via the manual bug. To
make it defecate, type \verb/O/ when you get the initial list of
actions. This will bring up a new list, with just one option. Type
\verb/d/ in reply.

Now modify \verb/gworld2/ so that after eating, the bug not only cleans
itself, but also relieves itself. You will need to add a new goal. When
obeying this goal, the animal should seek an empty spot in which to
defecate. You denote this as \verb/' '/. Once you have modified your
rules, update your state transition diagram accordingly.

Finally, draw a new state transition diagram. Unlike the previous one,
this must reflect the state of the bug's environment and physiology, not
its mind. These put the bug into one of states: smelly-and-digesting,
smelly, digesting, dead, and neutral. The last one represents the bug
before it has eaten for the first time, or after it has cleaned and
relieved itself.

To end, it hardly needs saying that I do not intend the bugs as serious
models of animal physiology. However, they are not serious models of
animal {\it psychology} either, but just exercises --- in this case, on
goals. As I mentioned in the {\it AI and PopBeast} handout, some
researchers do not believe that folk-psychology entities such as goals
are explicitly represented in the mind; others go even further and
assert that they should not be represented in engineered artifacts such
as robots, because doing so leads to inflexible behaviour. Even
neglecting that point of difference, there are many many others between
the bug and real animals, and you should not infer that one is intended
as a model of the other.                   


\section{Path planning}

The rules below are the ones from \verb/gbug/ that either plan paths or
use them.
\begin{verbatim}
goal(plan_path),
retina(X,Y,nearest(+)),
retina_path( [3,2], [X,Y], Path )
=>
path(Path),
erase(goal(plan_path)),
goal(check_path_found).


goal(check_path_found),
path(not_found)
=>
erase(goal(check_path_found)),
goal(notice_food).

goal(check_path_found),
not(path(not_found))
=>
erase(goal(check_path_found)),
goal(follow_path).


goal(follow_path),
path( [First|Rest] )
=>
exec( First ),
erase(path(_)),
path(Rest).

goal(follow_path),
path( [] ),
over(+)
=>
erase(goal(follow_path)),
erase( path([]) ),
exec( [grab] ),
exec( [use] ),
goal( notice_food ).

goal(follow_path),
path( [] ),
not( over(+) )
=>
erase(goal(follow_path)),
erase( path([]) ),
goal( notice_food ).
\end{verbatim}

The idea is that when the bug spots a piece of food, it works out a
sequence of moves that will get it there. This sequence is not
guaranteed to be the shortest, though it often will be. Having generated
the sequence, the bug stores it as the argument to the STM predicate
\verb/path/. The sequence is represented as a {\it
list}: this word has a specific technical meaning in computing, implying
something about how elements of the sequence are connected together.
However, for your purposes, the main thing to note is that you can tell
something's a list by the fact that it's displayed in square brackets.
This is demonstrated below, with an extract from one of the diagnostic
traces.
\begin{verbatim}
path( [[right], [forward], [right], [forward]] )
\end{verbatim}


\subsection{Retinal coordinates and the {\tt retina} predicate}

The rule that generates these sequences is this one:
\begin{verbatim}
goal(plan_path),
retina(X,Y,nearest(+)),
retina_path( [3,2], [X,Y], Path )
=>
path(Path),
erase(goal(plan_path)),
goal(check_path_found).
\end{verbatim}
Its left-hand side contains one STM predicate, and two perceptual
predicates, \verb/retina/ and \verb/retina_path/. The former is related
to \verb/can_see/, but instead of just indicating whether an object is
within view, it also gives its coordinates in the retinal image. These
are expressed relative to the bottom left-hand corner of the retina as
\verb/(1,1)/, as shown in figure~\ref{ps3:retina} below:
\vfigstart
\begin{verbatim}
\begin{alltt}
1,7  _,_  _,_  _,_  5,7
_,_  _,_  _,_  _,_  _,_
_,_  _,_  _,_  _,_  _,_
_,_  _,_  _,_  _,_  _,_
_,_  _,_  _,_  _,_  _,_
_,_  _,_   B   _,_  _,_
1,1  _,_  _,_  _,_  5,1
\end{alltt}
\end{verbatim}
\vfigend{ps3:retina}{A bug's visual field}
In this figure, the bug's position is shown as a \verb/B/, and is
\verb/(3,2)/.

The first two arguments of the \verb/retina/ predicate are an object's X
and Y location. The third argument specifies the object. It can either
by a simple symbol, such as \verb/+/ or \verb/'S'/; or a designator of
the form \verb/nearest(+)/ or \verb/nearest('S')/.

This second case is the one we're interested in. When Prolog tries to
establish the truth of the condition
\begin{verbatim}
retina( X, Y, nearest(+) )
\end{verbatim}
it searches the retinal image for the nearest piece of food. It then
fills in the variables \verb/X/ and \verb/Y/ with its coordinates. These
can then be used again in the same rule.


\subsection{Retinal path-planning}

The second perceptual predicate in the rule is \verb/retina_path/. Now,
before explaining what it does, I have to explain that it isn't really a
perceptual predicate at all. Prolog is a general-purpose
logic-programming language in which one can write predicates about many
different subjects --- including simulated microworlds. What I have
called perceptual predicates up to now are actually perfectly normal
Prolog predicates which refer to particular aspects of the Eden
simulation. They all access the data structures which represent the
bug's perceptions, and are designed to give you information which
enables you to find out what the bug ``experiences''.

Like \verb/retina/, \verb/can_see/ and \verb/over/, \verb/retina_path/
is a normal Prolog predicate. Like them, it accesses the data structures
which represent the bug's perceptions. Unlike them, it does not just
report raw ``perceptions''. Instead, it goes through a fairly complex
searching process which is designed to find a free path. The type of
search used is one known as {\it hill-climbing}. The predicate starts by
making a list of all the ``safe'' (passable) cells next to the bug's
starting point. It then computes the distance from each of these cells
to the food, and takes the cell with the least distance. It then
repeats, finding all the neighbours of this new cell, and calculating
{\it their} distance. And so on. Eventually, it should get to the goal.

Sometimes, it won't be able to find a clear path. In that case, it will
back-up to the last choice it made between neighbours, select the next
nearest cell, and try again. Sometimes, no choice will lead it to the
goal.

The method of choosing, if possible, the neighbour nearest to the food
is not guaranteed to find the shortest path, but it often will. It's an
example of a {\it heuristic}: a computationally cheap rule-of thumb
which delivers a good-enough solution often enough to be worth
tolerating when it doesn't.    

If \verb/retina_path/ can find a path, it will set its third argument to
a list of the moves required to follow it. If it can't, it will set it
to \verb/not_found/.

So one effect of the whole rule,
\begin{verbatim}
goal(plan_path),
retina(X,Y,nearest(+)),
retina_path( [3,2], [X,Y], Path )
=>
path(Path),
erase(goal(plan_path)),
goal(check_path_found).
\end{verbatim}
is to put into STM either the fact \verb/path(not_found)/, or a fact of
the form \verb/path( [ [right], [forward], ... ] )/. The rule also
changes the current goal to \verb/check_path_found/.


\subsection{Checking that a path was found}

This is done by the two rules
\begin{verbatim}
goal(check_path_found),
path(not_found)
=>
erase(goal(check_path_found)),
goal(notice_food).

goal(check_path_found),
not(path(not_found))
=>
erase(goal(check_path_found)),
goal(follow_path).
\end{verbatim}

They just test the argument of \verb/path/ to see whether it is
\verb/not_found/. If it is, the bug goes back to looking for food, on
the assumption that it can't get to the piece it has just seen. This is
probably not very sensible behaviour, since it is likely to get the bug
into a loop, where it repeatedly notices the same piece of food, tries
to plot a path to it, and fails. Check whether this is so by
building a world in which the bug can see, but not get to, some food. If
the argument is not \verb/not_found/, it must be a path, so the bug
changes its goal to \verb/follow_path/.


\subsection{Following a path}

This is handled by the three rules below:
\begin{verbatim}
goal(follow_path),
path( [First|Rest] )
=>
exec( First ),
erase(path(_)),
path(Rest).

goal(follow_path),
path( [] ),
over(+)
=>
erase(goal(follow_path)),
erase( path([]) ),
exec( [grab] ),
exec( [use] ),
goal( notice_food ).

goal(follow_path),
path( [] ),
not( over(+) )
=>
erase(goal(follow_path)),
erase( path([]) ),
goal( notice_food ).
\end{verbatim}

The first rule checks the argument of \verb/path/ to see whether it
still contains some moves, using the special construction
\verb/[First|Rest]/. The condition \verb/path([First|Rest])/ will
succeed only if the path is not empty. If it does, then this will set
\verb/First/ to the first move, and \verb/Rest/ to a list containing the
others. The right-hand side of the rule then obeys the first move, and
resets the path so it contains only the rest.

The second rule's condition succeeds if the path is now empty and the
bug is over food. In this case, we just grab and eat it, and reset the
goal.

The third rule is a safety clause. It could happen that by the time we
get to the end of the path, the food has gone. For example, something
else might have eaten it, the path might have been miscalculated, or a
move might not have had the desired effect. If so, the bug doesn't waste
time trying to eat non-existent food, but goes back to looking for more.


\subsection{Cognitive versus subcognitive competances}

Now print out the rules in \verb/gbug3/. Notice that all but one of
the rules are the same as in \verb/gbug/ There is one that's different:
\begin{verbatim}
goal(follow_path),
path(Path)
=>
exec_list(Path),
erase(path(Path)),
path([]).
\end{verbatim}

This rule has a new motor command on its right-hand side,
\verb/exec_list/. This is like \verb/exec/, except that it obeys a whole
list of actions in one go, thus avoiding the necessity to run the same
rule over and over again, taking the first element from the path,
obeying it, replacing the whole path by its tail, and then repeating.
Try running \verb/gbug3/ in \verb/gworld/, and follow the trace to see
how \verb/exec_list/ is used.

This ought to be quicker, because fewer rules need be fired in order to
follow the path. However, it does have limitations, which you can
demonstrate as follows. Try running it in \verb/gworld3/. This is like
\verb/gworld/, except that it contains a few bombs (\verb/b/). These
will explode and kill you if you pass over them. Now try running
\verb/gbug/ in the same world. This too will get blown up.

Now try altering each bug so that if it sees the bomb ahead of it, it
alters course to avoid it. You may want to discard the rest of the
planned path and plan a new one after changing course; or you may want
to try rejoining the old path. The latter is harder!

Which bug is harder to make avoid bombs? Why? What does this have to do
with the organization of large companies?   


\section{Giving the bug commands}

There is another facility in Eden with which you can give commands to a
bug. To demonstrate this, run \verb/gbug5/ in any world. When Eden first
requests a control command, type \verb/l/ followed by RETURN. It will
then invite you to type a sentence, and will move the cursor to the
start of line three, ready for this. Type \verb/left/ and then hit
RETURN. The sentence is now stored in the bug's ``auditory buffer'', and
can be accessed by the perceptual predicate \verb/heard/.

When you have hit RETURN, Eden will ask you for another control command.
This time, hit \verb/y/ to execute one cycle. Notice that the bug
obeys your command. You can see how it works by looking at the code in
figure~\ref{ps3:gbug5}, below.
\vfigstart
\begin{verbatim}
resolve [p,r].

stm [].

stm_predicates [].


heard( S )
=>
exec( S ).

not(heard(S))
=>
reply([please,type,something]),
exec([wait]).
\end{verbatim}
\vfigend{ps3:gbug5}{{\tt gbug5}}

The predicate \verb/heard/ only succeeds if you have just typed a
sentence, in which case it sets its argument to the sentence as a list
of words. Thus, if you do type something, the first rule will fire, and
will execute the word you type. If this is an action name, then the bug
will obey the corresponding action.

If you don't type something, \verb/heard/ will be false, and the second
rule will fire. It calls another motor predicate, \verb/reply/, which
replies by displaying its argument on the fourth line. It then calls
\verb/exec([wait])/.     

As a final exercise, try modifying one of the \verb/g/-series bugs so
that if it's stuck for an action, and you type something, it will obey
it. This is an exercise where it may be easier {\it not} to introduce
another goal.

\end{document}
ing in computing, implying
something about how elements of the sequence are connected toget                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                ps_compile.pl                                                                                       100705  017064  000205  00000011754 05427665634 010065  0                                                                                                     47426                                                                                    1  0                                                                                                                                                                 /*  PS_COMPILE.PL  */


:- module ps_compile.


/*
SPECIFICATION
-------------
*/


:- op( 253, xfy, prio ).
:- op( 254, xfx, => ).
:- op( 254, xfx, reduces_to ).
:- op( 10, fx, @ ).
:- op( 20, xfx, :: ).
:- op( 10, fx, resolve ).
:- op( 10, fx, stm ).
:- op( 10, fx, stm_predicates ).
:- op( 10, fx, perceptual_predicates ).
:- op( 254, xfx, ::: ).  


/*
IMPLEMENTATION
--------------

I assume that this file will only be used when module ps is loaded.
*/


:- lib(useful).
:- lib(control).


to_rules( [], [] ) :- !.

to_rules( [Rule1|RulesN], RulesT ) :-
    to_rule( Rule1, Rule1T ),
    to_rules( RulesN, RulesNT ),
    rule_insert( RulesNT, Rule1T, RulesT ).


to_raps( [], [] ) :- !.

to_raps( [Rap1|RapsN], RapsT ) :-
    to_rap( Rap1, Rap1T ),
    to_raps( RapsN, RapsNT ),
    rap_insert( RapsNT, Rap1T, RapsT ).


to_subs( [], [] ) :- !.

to_subs( [Sub1|SubsN], SubsT ) :-
    to_sub( Sub1, Sub1T ),
    to_subs( SubsN, SubsNT ),
    sub_insert( SubsNT, Sub1T, SubsT ).


compile_ps( RulesT, STMT, ResolutionStrategy ) :-
    fast_bagof( (Cond=>Action), (Cond=>Action), Rules ),
    to_rules( Rules, RulesT ),
    (resolve ResolutionStrategy),
    (stm STM),
    list_to_stm( STM, STMT ).


to_raps( RapsT ) :-
    fast_bagof( (G reduces_to Rap), (G reduces_to Rap), Raps ),
    to_raps( Raps, RapsT ).


to_rule( (Cond => Action), RuleT ) :-
    to_condition( Cond, CondT, PrioT ),
    to_action( Action, ActionT ),
    new_rule( RuleT ),
    rule_vs_condition( RuleT, CondT ),
    rule_vs_priority( RuleT, PrioT ),
    rule_vs_action( RuleT, ActionT ).


to_subs( SubT ) :-
    fast_bagof( (Sub:::Rule), (Sub:::Rule), Subs ),         
    to_subs( Subs, SubsT ).


to_condition( (PrioT prio Cond), CondT, PrioT ) :-
    !,
    conj_vs_list( Cond, CondL ),
    to_condition_1( CondL, CondT ).

to_condition( Cond, CondT, PrioT ) :-
    to_condition( (0 prio Cond), CondT, PrioT ).


to_condition_1( [], [] ) :- !.

to_condition_1( [H|T], [H1|T1] ) :-
    to_prim_condition( H, H1 ),
    to_condition_1( T, T1 ).


from_stm( @S, '$at'(S) ) :- !.

from_stm( true, true ) :- !.

from_stm( =(A,B), =(A,B) ) :- !.
from_stm( \=(A,B), \=(A,B) ) :- !.
from_stm( >(A,B), >(A,B) ) :- !.
from_stm( >=(A,B), >=(A,B) ) :- !.
from_stm( <(A,B), <(A,B) ) :- !.
from_stm( =<(A,B), =<(A,B) ) :- !.
from_stm( exec(A), exec(A) ) :- !.
from_stm( erase(A), erase(A) ) :- !.

from_stm( S, '$at'(S) ) :-
    stm_predicates( L ),
    functor( S, F, _ ),
    ( L = all ; non_binding_call(member(F,L)) ), !.

from_stm( S, S ) :-
    perceptual_predicates( L ),
    functor( S, F, _ ),
    ( L = all ; non_binding_call(member(F,L)) ), !.

from_stm( S, S ).


to_prim_condition( not(Cond), not(CondT) ) :-
    from_stm( Cond, CondT ),
    !.

to_prim_condition( Cond, CondT ) :-
    from_stm( Cond, CondT ),
    !.


to_action( Action, ActionT ) :-
    conj_vs_list( Action, ActionL ),
    to_action_1( ActionL, ActionT ).


to_action_1( [], [] ) :- !.

to_action_1( [H|T], [H1|T1] ) :-
    to_prim_action( H, H1 ),
    to_action_1( T, T1 ).


to_prim_action( sub(Name), sub(Name) ) :- !.

to_prim_action( Action, ActionT ) :-
    from_stm( Action, ActionT ).


to_rap( (Goal reduces_to Plan), RapT ) :-
    to_prim_condition( Goal, GoalT ),
    to_plan( Plan, GoalT, PlanT ),
    rap_vs_goal( RapT, GoalT ),
    rap_vs_plan( RapT, PlanT ).


to_plan( Plan, GoalT, PlanT ) :-
    conj_vs_list( Plan, PlanL ),
    to_plan_1( PlanL, GoalT, PlanT ).


to_plan_1( [], _, [] ) :- !.

to_plan_1( [H|T], GoalT, [H1|T1] ) :-
    to_prim_plan( H, GoalT, H1 ),
    to_plan_1( T, GoalT, T1 ).


to_prim_plan( (Prec::Plan), GoalT, (PrecT::PlanT) ) :-
    !,
    to_prim_condition( Prec, PrecT ),
    to_prim_plan( Plan, GoalT, PlanT ).

to_prim_plan( (C->A1;A2), GoalT, (CT->A1T;A2T) ) :-
    !,
    to_prim_condition( C, CT ),
    to_prim_plan( A1, GoalT, A1T ),
    to_prim_plan( A2, GoalT, A2T ).

to_prim_plan( [A|B], GoalT, '$rules'(RulesT_) ) :-
    !,
    to_rules( [A|B], RulesT ),
    replace_finish( RulesT, GoalT, RulesT_ ).

to_prim_plan( Plan, _, PlanT ) :-
    from_stm( Plan, PlanT ).


to_sub( Name:::Rule, sub(Name,RuleT) ) :-
    to_rule( Rule, RuleT ).


replace_finish( [], _, [] ) :- !.

replace_finish( [R1|Rn], GoalT, [R1R|RnR] ) :-
    replace_finish_1( R1, GoalT, R1R ),
    replace_finish( Rn, GoalT, RnR ).


replace_finish_1( Rule, GoalT, Rule_ ) :-
    rule_vs_action( Rule, Action ),
    replace_finish_2( Action, GoalT, Action_ ),
    new_rule( Rule_ ),
    rule_vs_action( Rule_, Action_ ),
    rule_vs_condition( Rule, Condition ),
    rule_vs_condition( Rule_, Condition ).


replace_finish_2( [], _, [] ) :- !.

replace_finish_2( [finish|Rest], '$at'(G), [erase(G)|Rest] ).

replace_finish_2( [A1|Rest], GoalT, [A1|Rest_] ) :-
    replace_finish_2( Rest, GoalT, Rest_ ).


:- endmodule.
the rest.

The second rule's condition succeeds if the path is now empty and the
bug is over food. In this case, we just grab and eat it, and reset the
goal.

The third rule is a safety clause. It could happen that by the time we
get to the end of the path, the food has gone. For example, something
else might have eaten it,ps_int.pl                                                                                           100705  017064  000205  00000004710 05427665634 007221  0                                                                                                     47426                                                                                    1  0                                                                                                                                                                 /*  PS_INT.PL  */


/*
SPECIFICATION
-------------
*/


/*
IMPLEMENTATION
--------------

I assume this file will only be used when modules ps and eden
are both loaded.
*/


:- lib(random).


:- quietspy(on).


eps( Bug, World ) :-
    retractall( stm_predicates(_) ),
    retractall( perceptual_predicates(_) ),
    load_program( Bug, _ ),
    eden( psbug, World ).


load_program( Prog, StatusOut ) :-
    find_file( Prog, [ '', '[popx.eden]' ], '.pl', Fullname, Status ),
    (
        Status = ok
    ->
        open_and_reconsult( Fullname, Status )
    ;
        true
    ),
    StatusOut = Status.


psbug :-
    compile_ps( Rules, STM0, ResolutionStrategy ),
    ps( Rules, STM0, fail, ResolutionStrategy, STM ),
    write('Exiting psbug'),nl,
    exit_eden.                    


diagnose( Tag, Message ) :-
    bug_view output( Tag...Message ).


/*
Interface predicates
--------------------
*/


can_see( Obj ) :-
    retina( _, _, Obj ), !.


over( Obj ) :-
    retina( 3, 2, Obj ), !.


next_to( Obj ) :-
    (
        retina( 3, 3, Obj ) ;
        retina( 3, 1, Obj ) ;
        retina( 2, 2, Obj ) ;
        retina( 4, 2, Obj )
    ), !.


holding( Obj ) :-
    inventory( Obj ).


empty :-
    inventory( ' ' ).


move_towards( Obj ) :-
    retina( X, Y, Obj ),
    DX is X - 3,
    DY is Y - 2,
    AbsDX is abs(DX),
    AbsDY is abs(DY),
    (
        AbsDY >= AbsDX
    ->
        ( DY > 0 -> exec([forward]) ; exec([right]),exec([right]),exec([forward]) )
    ;
        ( DX > 0 -> exec([right]) ; exec([left]) )
    ).


turn_towards( Obj ) :-
    retina( X, Y, Obj ),
    DX is X - 3,
    DY is Y - 2,
    AbsDX is abs(DX),
    AbsDY is abs(DY),
    (
        AbsDY >= AbsDX
    ->
        ( DY > 0 -> true ; exec([right]),exec([right]) )
    ;
        ( DX > 0 -> exec([right]) ; exec([left]) )
    ).


facing( Obj ) :-
    retina( 3, 3, Obj ), !.


wander :-
    random_element( [ [[left],[forward]],
                      [[right],[forward]],
                      [[forward],[forward],[forward],[forward],[forward],[forward]]
                    ], E ),
    exec_list( E ).


exec_list( [] ) :- !.

exec_list( [A1|An] ) :-
    exec( A1 ),
    exec_list( An ).


heard( S ) :-
    heard_from(user,Chars),
    Chars \= [],
    chars_to_items( Chars, S ).


reply( S ) :-
    say(user,S).
s a list
of words. Thus, if you do type something, the first rule will fire, and
will execute the word you type. If this is an action name, then the bug
will obey the corresponding action.

If you don't type something, \verb/heard/ will be false, aps_interface.pl                                                                                     100705  017064  000205  00000001116 05427665635 010365  0                                                                                                     47426                                                                                    1  0                                                                                                                                                                 /*  PS_INTERFACE.PL  */


:- module ps_interface.


/*
SPECIFICATION
-------------
*/


/*
IMPLEMENTATION
--------------
*/


/*
Converting perceptions to STM.
------------------------------
*/


perceptions_to_stm( Vision, Inventory, Energy, FoodDirection, STM ) :-
    vision_to_list( Vision, VisionList ),
    (
        Inventory \= ' '
    ->
        List1 = [ hold(Inventory) | VisionList ]
    ;
        List1 = VisionList
    ),
    List = [ energy(Energy), smell(FoodDirection) | List1 ],
    list_to_stm( List, STM ).


:- endmodule.
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                 psbug1.pl                                                                                           100705  017064  000205  00000000242 05427665624 007121  0                                                                                                     47426                                                                                    1  0                                                                                                                                                                 /*  PSBUG1.PL  */


resolve [p,s,r].

stm [].

holding(+)      => exec([use]).
over(+)         => exec([grab]).
can_see(+)      => move_towards(+).
 reduces_to ).
:- op( 10, fx, @ ).
:- op( 20, xfx, :: ).
:- op( 10, fx, resolve ).
:- op( 10, fx, stm ).
:- op( 10, fx, stm_predicates ).
:- op( 10, fx, perceptual_predicates ).
:- op( 254, xfx, ::: ).  


/*
IMPLEMENTATION
--------------

I assume that this file will only be used when module ps is loaded.
*/


:- lib(useful).
:- lib(control).


to_rules( [], []psbug2.pl                                                                                           100705  017064  000205  00000000600 05427665624 007120  0                                                                                                     47426                                                                                    1  0                                                                                                                                                                 /*  PSBUG2.PL  */


resolve [p,s,r].

stm [].

holding(+)      => exec([use]).
over(+)         => exec([grab]).
can_see(+)      => move_towards(+).

can_see('1')    => move_towards('1').
over('1')       => exec([grab]).

can_see('S'), holding('1') => move_towards('S').
next_to('S'), holding('1') => turn_towards('S').
facing('S'), holding('1')  => exec([use]).
 PrioT ),
    to_action( Action, ActionT ),
    new_rule( RuleT ),
    rule_vs_condition( RuleT, CondT ),
    rule_vs_priority( RuleT, PrioT ),
    rupsbug3.pl                                                                                           100705  017064  000205  00000000414 05427665625 007125  0                                                                                                     47426                                                                                    1  0                                                                                                                                                                 /*  PSBUG3.PL  */


resolve [p,s,r].

stm [].

holding(+)      => exec([use]).
over(+)         => exec([grab]).
can_see(+)      => move_towards(+).

1 prio thirst(T),T>20,can_see(w) => move_towards(w).
1 prio thirst(T),T>20,over(w)    => exec([use]).
stm( exec(A), exec(A) ) :- !.
from_stm( erase(A), erase(A) ) :- !.

from_stm( S, '$at'(S) ) :-
    stm_predicates( L ),
    functor( S, F, _ ),
    ( L = all ; non_binding_call(member(F,L)) ), !.

from_stm( S, S ) :-
    perceptual_predicates( L ),
    functor(psworld0                                                                                            100705  017064  000205  00000000056 05427665627 007066  0                                                                                                     47426                                                                                    1  0                                                                                                                                                                 !  PSWORLD0

pb_objects
****
*BQ*
****

    from_stm( Action, ActionT ).


to_rap( (Goal reduces_to Plan), RapT ) :-
    to_prim_condition( Goal, GoalT ),
    to_plan( Plan, GoalT, PlanT ),
    rap_vs_goal( RapT, GoalT ),
    rap_vs_plan( RapT, PlanT ).


to_plan( Plan, GoalT, PlanT ) :-
    conj_vs_list( Plan, PlanL ),
    to_plan_1( PlanL, GoalT, PlanT ).


to_plan_1( [], _, [] ) :- !.

to_plan_1( [H|T], GoalT, [H1|T1] ) :-
    to_prim_plan( H, GoalT, H1 ),
    to_plan_1( T, GoalT, T1 ).


to_prim_plan( (psworld0.w                                                                                          100705  017064  000205  00000001224 05427665627 007331  0                                                                                                     47426                                                                                    1  0                                                                                                                                                                  zc world zl 0 zl 1 zl 2 1 1 zw 5 117 110 100 101 102 zs 12 112
 98 95 111 98 106 101 99 116 115 46 112 zw 5 117 110 100 101 102
 zw 5 117 110 100 101 102 4 3 za zl 4 0 3 0 2 zw 5 117 110 100
 101 102 zw 5 117 110 100 101 102 zw 5 117 110 100 101 102 zw 5
 117 110 100 101 102 zw 5 117 110 100 101 102 zw 5 117 110 100
 101 102 zw 5 117 110 100 101 102 zw 5 117 110 100 101 102 zw 5
 117 110 100 101 102 zw 5 117 110 100 101 102 zw 5 117 110 100
 101 102 zw 5 117 110 100 101 102 za zl 4 0 3 0 2 42 42 42 42
 42 32 81 42 42 42 42 42 zw 5 117 110 100 101 102 zw 5 117 110
 100 101 102 zw 5 117 110 100 101 102 zw 5 117 110 100 101 102
 zl 0 0 0
eplace_finish_2( Rest, GoalT, Rest_ ).


:- endmodule.
the rest.

The second rule's condition succeeds if the path is now empty and the
bug is over food. In this case, we just grab and eat it, and reset the
goal.

The third rule is a safety clause. It could happen that by the time we
get to the end of the path, the food has gone. For example, something
else might have eaten it,psworld1                                                                                            100705  017064  000205  00000000240 05427665627 007062  0                                                                                                     47426                                                                                    1  0                                                                                                                                                                 !  PSWORLD1

pb_objects
        ***********
        *         *
        *  B   +  *
        *         *
        *    + +  *
        ***********
nd eden
are both loaded.
*/


:- lib(random).


:- quietspy(on).


eps( Bug, World ) :-
    retractall( stm_predicates(_) ),
    retractall( perceptual_predicates(_) ),
    load_program( Bug, _ ),
    eden( psbug, World ).


load_program( Prog, StatusOut ) :-
    find_file( Prog, [ '', '[popx.eden]' ], '.pl', Fullname, Status ),
    (
        Status = ok
    ->
    psworld1.w                                                                                          100705  017064  000205  00000004276 05427665630 007336  0                                                                                                     47426                                                                                    1  0                                                                                                                                                                  zc world zl 0 zl 1 zl 2 3 3 zw 5 117 110 100 101 102 zs 12 112
 98 95 111 98 106 101 99 116 115 46 112 zw 5 117 110 100 101 102
 zw 5 117 110 100 101 102 11 6 za zl 4 0 10 0 5 zw 5 117 110 100
 101 102 zw 5 117 110 100 101 102 zw 5 117 110 100 101 102 zw 5
 117 110 100 101 102 zw 5 117 110 100 101 102 zw 5 117 110 100
 101 102 zw 5 117 110 100 101 102 zw 5 117 110 100 101 102 zw 5
 117 110 100 101 102 zw 5 117 110 100 101 102 zw 5 117 110 100
 101 102 zw 5 117 110 100 101 102 zw 5 117 110 100 101 102 zw 5
 117 110 100 101 102 zw 5 117 110 100 101 102 zw 5 117 110 100
 101 102 zw 5 117 110 100 101 102 zw 5 117 110 100 101 102 zw 5
 117 110 100 101 102 zw 5 117 110 100 101 102 zw 5 117 110 100
 101 102 zw 5 117 110 100 101 102 zw 5 117 110 100 101 102 zw 5
 117 110 100 101 102 zw 5 117 110 100 101 102 zw 5 117 110 100
 101 102 zw 5 117 110 100 101 102 zw 5 117 110 100 101 102 zw 5
 117 110 100 101 102 zw 5 117 110 100 101 102 zw 5 117 110 100
 101 102 zw 5 117 110 100 101 102 zw 5 117 110 100 101 102 zw 5
 117 110 100 101 102 zw 5 117 110 100 101 102 zw 5 117 110 100
 101 102 zw 5 117 110 100 101 102 zw 5 117 110 100 101 102 zw 5
 117 110 100 101 102 zw 5 117 110 100 101 102 zw 5 117 110 100
 101 102 zw 5 117 110 100 101 102 zw 5 117 110 100 101 102 zw 5
 117 110 100 101 102 zw 5 117 110 100 101 102 zw 5 117 110 100
 101 102 zw 5 117 110 100 101 102 zw 5 117 110 100 101 102 zw 5
 117 110 100 101 102 zw 5 117 110 100 101 102 zw 5 117 110 100
 101 102 zw 5 117 110 100 101 102 zw 5 117 110 100 101 102 zw 5
 117 110 100 101 102 zw 5 117 110 100 101 102 zw 5 117 110 100
 101 102 zw 5 117 110 100 101 102 zw 5 117 110 100 101 102 zw 5
 117 110 100 101 102 zw 5 117 110 100 101 102 zw 5 117 110 100
 101 102 zw 5 117 110 100 101 102 zw 5 117 110 100 101 102 zw 5
 117 110 100 101 102 zw 5 117 110 100 101 102 zw 5 117 110 100
 101 102 za zl 4 0 10 0 5 42 42 42 42 42 42 42 42 42 42 42 42
 32 32 32 32 43 32 43 32 32 42 42 32 32 32 32 32 32 32 32 32 42
 42 32 32 32 32 32 32 43 32 32 42 42 32 32 32 32 32 32 32 32 32
 42 42 42 42 42 42 42 42 42 42 42 42 zw 5 117 110 100 101 102
 zw 5 117 110 100 101 102 zw 5 117 110 100 101 102 zw 5 117 110
 100 101 102 zl 0 0 0
ting perceptions to STM.
------------------------------
*/


perceptions_to_stm( Vision, Inventory, Energy, FoodDirection, STM ) :-
    vision_to_list( Vision, VisionList ),
    (
        Inventory \= ' '
    ->
        List1 = [ hold(Inventory) | VisionList ]
    ;
        List1 = VisionList
    ),
    List = [ energy(Energy), smell(FoodDirection) | List1 ],
    list_to_stmpsworld2                                                                                            100705  017064  000205  00000000240 05427665630 007055  0                                                                                                     47426                                                                                    1  0                                                                                                                                                                 !  PSWORLD2

pb_objects
        ***********
        *         *
        *  B   S  *
        *         *
        *+     1  *
        ***********
624 007121  0                                                                                                     47426                                                                                    1  0                                                                                                                                                                 psworld2.w                                                                                          100705  017064  000205  00000004276 05427665630 007337  0                                                                                                     47426                                                                                    1  0                                                                                                                                                                  zc world zl 0 zl 1 zl 2 3 3 zw 5 117 110 100 101 102 zs 12 112
 98 95 111 98 106 101 99 116 115 46 112 zw 5 117 110 100 101 102
 zw 5 117 110 100 101 102 11 6 za zl 4 0 10 0 5 zw 5 117 110 100
 101 102 zw 5 117 110 100 101 102 zw 5 117 110 100 101 102 zw 5
 117 110 100 101 102 zw 5 117 110 100 101 102 zw 5 117 110 100
 101 102 zw 5 117 110 100 101 102 zw 5 117 110 100 101 102 zw 5
 117 110 100 101 102 zw 5 117 110 100 101 102 zw 5 117 110 100
 101 102 zw 5 117 110 100 101 102 zw 5 117 110 100 101 102 zw 5
 117 110 100 101 102 zw 5 117 110 100 101 102 zw 5 117 110 100
 101 102 zw 5 117 110 100 101 102 zw 5 117 110 100 101 102 zw 5
 117 110 100 101 102 zw 5 117 110 100 101 102 zw 5 117 110 100
 101 102 zw 5 117 110 100 101 102 zw 5 117 110 100 101 102 zw 5
 117 110 100 101 102 zw 5 117 110 100 101 102 zw 5 117 110 100
 101 102 zw 5 117 110 100 101 102 zw 5 117 110 100 101 102 zw 5
 117 110 100 101 102 zw 5 117 110 100 101 102 zw 5 117 110 100
 101 102 zw 5 117 110 100 101 102 zw 5 117 110 100 101 102 zw 5
 117 110 100 101 102 zw 5 117 110 100 101 102 zw 5 117 110 100
 101 102 zw 5 117 110 100 101 102 zw 5 117 110 100 101 102 zw 5
 117 110 100 101 102 zw 5 117 110 100 101 102 zw 5 117 110 100
 101 102 zw 5 117 110 100 101 102 zw 5 117 110 100 101 102 zw 5
 117 110 100 101 102 zw 5 117 110 100 101 102 zw 5 117 110 100
 101 102 zw 5 117 110 100 101 102 zw 5 117 110 100 101 102 zw 5
 117 110 100 101 102 zw 5 117 110 100 101 102 zw 5 117 110 100
 101 102 zw 5 117 110 100 101 102 zw 5 117 110 100 101 102 zw 5
 117 110 100 101 102 zw 5 117 110 100 101 102 zw 5 117 110 100
 101 102 zw 5 117 110 100 101 102 zw 5 117 110 100 101 102 zw 5
 117 110 100 101 102 zw 5 117 110 100 101 102 zw 5 117 110 100
 101 102 zw 5 117 110 100 101 102 zw 5 117 110 100 101 102 zw 5
 117 110 100 101 102 zw 5 117 110 100 101 102 zw 5 117 110 100
 101 102 za zl 4 0 10 0 5 42 42 42 42 42 42 42 42 42 42 42 42
 43 32 32 32 32 32 49 32 32 42 42 32 32 32 32 32 32 32 32 32 42
 42 32 32 32 32 32 32 83 32 32 42 42 32 32 32 32 32 32 32 32 32
 42 42 42 42 42 42 42 42 42 42 42 42 zw 5 117 110 100 101 102
 zw 5 117 110 100 101 102 zw 5 117 110 100 101 102 zw 5 117 110
 100 101 102 zl 0 0 0
 05427665627 007066  0                                                                                                     47426                                                                                    1  0                                                                                                                                                                 psworld3                                                                                            100705  017064  000205  00000000374 05427665631 007067  0                                                                                                     47426                                                                                    1  0                                                                                                                                                                 !  W

pb_objects1
*******************************************
*      w   w +w   w   w   +  w   +  w     *
*    B + +  +  +  +        +    w    w    *
*                     +     w     +    +  *
*******************************************
                    47426                                                                                    1  0                                                                                                                                                                 psworld3.w                                                                                          100705  017064  000205  00000014702 05427665631 007334  0                                                                                                     47426                                                                                    1  0                                                                                                                                                                  zc world zl 0 zl 1 zl 2 5 2 zw 5 117 110 100 101 102 zs 13 112
 98 95 111 98 106 101 99 116 115 49 46 112 zw 5 117 110 100 101
 102 zw 5 117 110 100 101 102 43 5 za zl 4 0 42 0 4 zw 5 117 110
 100 101 102 zw 5 117 110 100 101 102 zw 5 117 110 100 101 102
 zw 5 117 110 100 101 102 zw 5 117 110 100 101 102 zw 5 117 110
 100 101 102 zw 5 117 110 100 101 102 zw 5 117 110 100 101 102
 zw 5 117 110 100 101 102 zw 5 117 110 100 101 102 zw 5 117 110
 100 101 102 zw 5 117 110 100 101 102 zw 5 117 110 100 101 102
 zw 5 117 110 100 101 102 zw 5 117 110 100 101 102 zw 5 117 110
 100 101 102 zw 5 117 110 100 101 102 zw 5 117 110 100 101 102
 zw 5 117 110 100 101 102 zw 5 117 110 100 101 102 zw 5 117 110
 100 101 102 zw 5 117 110 100 101 102 zw 5 117 110 100 101 102
 zw 5 117 110 100 101 102 zw 5 117 110 100 101 102 zw 5 117 110
 100 101 102 zw 5 117 110 100 101 102 zw 5 117 110 100 101 102
 zw 5 117 110 100 101 102 zw 5 117 110 100 101 102 zw 5 117 110
 100 101 102 zw 5 117 110 100 101 102 zw 5 117 110 100 101 102
 zw 5 117 110 100 101 102 zw 5 117 110 100 101 102 zw 5 117 110
 100 101 102 zw 5 117 110 100 101 102 zw 5 117 110 100 101 102
 zw 5 117 110 100 101 102 zw 5 117 110 100 101 102 zw 5 117 110
 100 101 102 zw 5 117 110 100 101 102 zw 5 117 110 100 101 102
 zw 5 117 110 100 101 102 zw 5 117 110 100 101 102 zw 5 117 110
 100 101 102 zw 5 117 110 100 101 102 zw 5 117 110 100 101 102
 zw 5 117 110 100 101 102 zw 5 117 110 100 101 102 zw 5 117 110
 100 101 102 zw 5 117 110 100 101 102 zw 5 117 110 100 101 102
 zw 5 117 110 100 101 102 zw 5 117 110 100 101 102 zw 5 117 110
 100 101 102 zw 5 117 110 100 101 102 zw 5 117 110 100 101 102
 zw 5 117 110 100 101 102 zw 5 117 110 100 101 102 zw 5 117 110
 100 101 102 zw 5 117 110 100 101 102 zw 5 117 110 100 101 102
 zw 5 117 110 100 101 102 zw 5 117 110 100 101 102 zw 5 117 110
 100 101 102 zw 5 117 110 100 101 102 zw 5 117 110 100 101 102
 zw 5 117 110 100 101 102 zw 5 117 110 100 101 102 zw 5 117 110
 100 101 102 zw 5 117 110 100 101 102 zw 5 117 110 100 101 102
 zw 5 117 110 100 101 102 zw 5 117 110 100 101 102 zw 5 117 110
 100 101 102 zw 5 117 110 100 101 102 zw 5 117 110 100 101 102
 zw 5 117 110 100 101 102 zw 5 117 110 100 101 102 zw 5 117 110
 100 101 102 zw 5 117 110 100 101 102 zw 5 117 110 100 101 102
 zw 5 117 110 100 101 102 zw 5 117 110 100 101 102 zw 5 117 110
 100 101 102 zw 5 117 110 100 101 102 zw 5 117 110 100 101 102
 zw 5 117 110 100 101 102 zw 5 117 110 100 101 102 zw 5 117 110
 100 101 102 zw 5 117 110 100 101 102 zw 5 117 110 100 101 102
 zw 5 117 110 100 101 102 zw 5 117 110 100 101 102 zw 5 117 110
 100 101 102 zw 5 117 110 100 101 102 zw 5 117 110 100 101 102
 zw 5 117 110 100 101 102 zw 5 117 110 100 101 102 zw 5 117 110
 100 101 102 zw 5 117 110 100 101 102 zw 5 117 110 100 101 102
 zw 5 117 110 100 101 102 zw 5 117 110 100 101 102 zw 5 117 110
 100 101 102 zw 5 117 110 100 101 102 zw 5 117 110 100 101 102
 zw 5 117 110 100 101 102 zw 5 117 110 100 101 102 zw 5 117 110
 100 101 102 zw 5 117 110 100 101 102 zw 5 117 110 100 101 102
 zw 5 117 110 100 101 102 zw 5 117 110 100 101 102 zw 5 117 110
 100 101 102 zw 5 117 110 100 101 102 zw 5 117 110 100 101 102
 zw 5 117 110 100 101 102 zw 5 117 110 100 101 102 zw 5 117 110
 100 101 102 zw 5 117 110 100 101 102 zw 5 117 110 100 101 102
 zw 5 117 110 100 101 102 zw 5 117 110 100 101 102 zw 5 117 110
 100 101 102 zw 5 117 110 100 101 102 zw 5 117 110 100 101 102
 zw 5 117 110 100 101 102 zw 5 117 110 100 101 102 zw 5 117 110
 100 101 102 zw 5 117 110 100 101 102 zw 5 117 110 100 101 102
 zw 5 117 110 100 101 102 zw 5 117 110 100 101 102 zw 5 117 110
 100 101 102 zw 5 117 110 100 101 102 zw 5 117 110 100 101 102
 zw 5 117 110 100 101 102 zw 5 117 110 100 101 102 zw 5 117 110
 100 101 102 zw 5 117 110 100 101 102 zw 5 117 110 100 101 102
 zw 5 117 110 100 101 102 zw 5 117 110 100 101 102 zw 5 117 110
 100 101 102 zw 5 117 110 100 101 102 zw 5 117 110 100 101 102
 zw 5 117 110 100 101 102 zw 5 117 110 100 101 102 zw 5 117 110
 100 101 102 zw 5 117 110 100 101 102 zw 5 117 110 100 101 102
 zw 5 117 110 100 101 102 zw 5 117 110 100 101 102 zw 5 117 110
 100 101 102 zw 5 117 110 100 101 102 zw 5 117 110 100 101 102
 zw 5 117 110 100 101 102 zw 5 117 110 100 101 102 zw 5 117 110
 100 101 102 zw 5 117 110 100 101 102 zw 5 117 110 100 101 102
 zw 5 117 110 100 101 102 zw 5 117 110 100 101 102 zw 5 117 110
 100 101 102 zw 5 117 110 100 101 102 zw 5 117 110 100 101 102
 zw 5 117 110 100 101 102 zw 5 117 110 100 101 102 zw 5 117 110
 100 101 102 zw 5 117 110 100 101 102 zw 5 117 110 100 101 102
 zw 5 117 110 100 101 102 zw 5 117 110 100 101 102 zw 5 117 110
 100 101 102 zw 5 117 110 100 101 102 zw 5 117 110 100 101 102
 zw 5 117 110 100 101 102 zw 5 117 110 100 101 102 zw 5 117 110
 100 101 102 zw 5 117 110 100 101 102 zw 5 117 110 100 101 102
 zw 5 117 110 100 101 102 zw 5 117 110 100 101 102 zw 5 117 110
 100 101 102 zw 5 117 110 100 101 102 zw 5 117 110 100 101 102
 zw 5 117 110 100 101 102 zw 5 117 110 100 101 102 zw 5 117 110
 100 101 102 zw 5 117 110 100 101 102 zw 5 117 110 100 101 102
 zw 5 117 110 100 101 102 zw 5 117 110 100 101 102 zw 5 117 110
 100 101 102 zw 5 117 110 100 101 102 zw 5 117 110 100 101 102
 zw 5 117 110 100 101 102 zw 5 117 110 100 101 102 zw 5 117 110
 100 101 102 zw 5 117 110 100 101 102 zw 5 117 110 100 101 102
 zw 5 117 110 100 101 102 zw 5 117 110 100 101 102 zw 5 117 110
 100 101 102 zw 5 117 110 100 101 102 zw 5 117 110 100 101 102
 zw 5 117 110 100 101 102 zw 5 117 110 100 101 102 zw 5 117 110
 100 101 102 zw 5 117 110 100 101 102 zw 5 117 110 100 101 102
 zw 5 117 110 100 101 102 zw 5 117 110 100 101 102 za zl 4 0 42
 0 4 42 42 42 42 42 42 42 42 42 42 42 42 42 42 42 42 42 42 42
 42 42 42 42 42 42 42 42 42 42 42 42 42 42 42 42 42 42 42 42 42
 42 42 42 42 32 32 32 32 32 32 32 32 32 32 32 32 32 32 32 32 32
 32 32 32 32 43 32 32 32 32 32 119 32 32 32 32 32 43 32 32 32
 32 43 32 32 42 42 32 32 32 32 32 32 43 32 43 32 32 43 32 32 43
 32 32 43 32 32 32 32 32 32 32 32 43 32 32 32 32 119 32 32 32
 32 119 32 32 32 32 42 42 32 32 32 32 32 32 119 32 32 32 119 32
 43 119 32 32 32 119 32 32 32 119 32 32 32 43 32 32 119 32 32
 32 43 32 32 119 32 32 32 32 32 42 42 42 42 42 42 42 42 42 42
 42 42 42 42 42 42 42 42 42 42 42 42 42 42 42 42 42 42 42 42 42
 42 42 42 42 42 42 42 42 42 42 42 42 42 zw 5 117 110 100 101 102
 zw 5 117 110 100 101 102 zw 5 117 110 100 101 102 zw 5 117 110
 100 101 102 zl 0 0 0
 100 101 102 zw 5 117 110 100
 101 102 zw 5 117 110 100 101 102 zw 5 117 110 100 101 102 zw 5
 117 110 100 101 102 zw 5 117 110 100 101 102 zw 5 117 110 100
 101 102 zw 5 117 110 100 101 102 zw 5 117 110 100 101 102 zw 5
psworld4                                                                                            100705  017064  000205  00000000324 05427665631 007063  0                                                                                                     47426                                                                                    1  0                                                                                                                                                                 !  PSWORLD4

pb_objects 500 east
        ***********
        *         *
        *  B +  + *
        *         ***************
        *      +             +  *
        *************************
zw 5 117 110 100 101 102 zw 5 117 110 100 101 102 zw 5
 117 110 100 101 102 zw 5 117 110 100 101 102 zw 5 117 110 100
 101 102 zw 5 117 110 100 101 102 zw 5 117 110 100 101 102 zw 5
 117 110 100 101 102 zw 5 117 110 100 101 102 zw 5 117 110 100
 101 102 zw 5 117 110 100 101 102 zw 5 117 110 100 101 102 zw 5
 117 110psworld4.w                                                                                          100705  017064  000205  00000002474 05427665632 007341  0                                                                                                     47426                                                                                    1  0                                                                                                                                                                  zc world 25 6 zv 6 zs 25 42 42 42 42 42 42 42 42 42 42 42 42
 42 42 42 42 42 42 42 42 42 42 42 42 42 zs 25 42 32 32 32 32 32
 32 43 32 32 32 32 32 32 32 32 32 32 32 32 32 43 32 32 42 zs 25
 42 32 32 32 32 32 32 32 32 32 42 42 42 42 42 42 42 42 42 42 42
 42 42 42 42 zs 25 42 32 32 32 32 43 32 32 43 32 42 32 32 32 32
 32 32 32 32 32 32 32 32 32 32 zs 25 42 32 32 32 32 32 32 32 32
 32 42 32 32 32 32 32 32 32 32 32 32 32 32 32 32 zs 25 42 42 42
 42 42 42 42 42 42 42 42 32 32 32 32 32 32 32 32 32 32 32 32 32
 32 7 1 zs 12 112 98 95 111 98 106 101 99 116 115 46 112 zv 6
 zs 25 42 42 42 42 42 42 42 42 42 42 42 42 42 42 42 42 42 42 42
 42 42 42 42 42 42 zs 25 42 32 32 32 32 32 32 43 32 32 32 32 32
 32 32 32 32 32 32 32 32 43 32 32 42 zs 25 42 32 32 32 32 32 32
 32 32 32 42 42 42 42 42 42 42 42 42 42 42 42 42 42 42 zs 25 42
 32 32 32 32 43 32 32 43 32 42 32 32 32 32 32 32 32 32 32 32 32
 32 32 32 zs 25 42 32 32 32 32 32 32 32 32 32 42 32 32 32 32 32
 32 32 32 32 32 32 32 32 32 zs 25 42 42 42 42 42 42 42 42 42 42
 42 32 32 32 32 32 32 32 32 32 32 32 32 32 32 7 1 zv 1 zc bug
 5 7 3 2 zc retina za zl 4 1 5 1 7 32 32 32 32 32 32 32 32 32
 32 32 32 32 32 32 32 32 32 32 32 32 32 32 32 32 32 32 32 32 32
 32 32 32 32 32 undef zl 0 zl 0 32 500 500 undef 3 3 east zl 2
 1 0 zl 2 0 -1 3 3 east 1 1
                                                                        1  0                                                                                                                                                                 psworld5                                                                                            100705  017064  000205  00000000252 05427665632 007065  0                                                                                                     47426                                                                                    1  0                                                                                                                                                                 !  PSWORLD5

pb_objects 500 east
        ***********
        *         *
        *  B   F  *
        *     S   *
        *+        *
        ***********
 102 43 5 za zl 4 0 42 0 4 zw 5 117 110
 100 101 102 zw 5 117 110 100 101 102 zw 5 117 110 100 101 102
 zw 5 117 110 100 101 102 zw 5 117 110 100 101 102 zw 5 117 110
 100 101 102 zw 5 117 110 100 101 102 zw 5 117 110 100 101 102
 zw 5 117 110 100 101 102 zw 5 117 110 100 101 102 zw 5 117 110
 100 101 102 zw 5 117 110 100 101 102 zw 5 117 110 100 101 102
 zpsworld5.w                                                                                          100705  017064  000205  00000001452 05427665632 007335  0                                                                                                     47426                                                                                    1  0                                                                                                                                                                  zc world 11 6 zv 6 zs 11 42 42 42 42 42 42 42 42 42 42 42 zs 11
 42 43 32 32 32 32 32 32 32 32 42 zs 11 42 32 32 32 32 32 83 32
 32 32 42 zs 11 42 32 32 32 32 32 32 70 32 32 42 zs 11 42 32 32
 32 32 32 32 32 32 32 42 zs 11 42 42 42 42 42 42 42 42 42 42 42
 1 1 zs 12 112 98 95 111 98 106 101 99 116 115 46 112 zv 6 zs 11
 42 42 42 42 42 42 42 42 42 42 42 zs 11 42 43 32 32 32 32 32 32
 32 32 42 zs 11 42 32 32 32 32 32 83 32 32 32 42 zs 11 42 32 32
 32 32 32 32 70 32 32 42 zs 11 42 32 32 32 32 32 32 32 32 32 42
 zs 11 42 42 42 42 42 42 42 42 42 42 42 1 1 zv 1 zc bug 5 7 3
 2 zc retina za zl 4 1 5 1 7 32 32 32 32 32 32 32 32 32 32 32
 32 32 32 32 32 32 32 32 32 32 32 32 32 32 32 32 32 32 32 32 32
 32 32 32 undef zl 0 zl 0 32 500 500 undef 3 3 east zl 2 1 0 zl 2
 0 -1 3 3 east 1 1
117 110 100 101 102 zw 5 117 110
 100 101 102 zw 5 117 110 100 101 102 zw 5 117 110 100 101 102
 zw 5 117 110 100 101 102 zw 5 117 110 100 101 102 zw 5 117 110
 100 101 102 zw 5 117 110 100 101 102 zw 5 117 110 100 101 102
 zw 5 117 110 psworld6                                                                                            100705  017064  000205  00000000526 05427665633 007073  0                                                                                                     47426                                                                                    1  0                                                                                                                                                                 !  PSWORLD6

pb_objects 500 east
        ****************************
        *                          *
        *          k               *
        *  B ^  1                  *
        *         @                *
        *                          *
        *+                         *
        ****************************
 101 102 zw 5 117 110 100 101 102
 zw 5 117 110 100 101 102 zw 5 117 110 100 101 102 zw 5 117 110
 100 101 102 zw 5 117 110 100 101 102 zw 5 117 110 100 101 102
 zw 5 117 110 100 101 psworld6.w                                                                                          100705  017064  000205  00000003444 05427665633 007342  0                                                                                                     47426                                                                                    1  0                                                                                                                                                                  zc world 28 8 zv 8 zs 28 42 42 42 42 42 42 42 42 42 42 42 42
 42 42 42 42 42 42 42 42 42 42 42 42 42 42 42 42 zs 28 42 43 32
 32 32 32 32 32 32 32 32 32 32 32 32 32 32 32 32 32 32 32 32 32
 32 32 32 42 zs 28 42 32 32 32 32 32 32 32 32 32 32 32 32 32 32
 32 32 32 32 32 32 32 32 32 32 32 32 42 zs 28 42 32 32 32 32 32
 32 32 32 32 64 32 32 32 32 32 32 32 32 32 32 32 32 32 32 32 32
 42 zs 28 42 32 32 32 32 94 32 32 49 32 32 32 32 32 32 32 32 32
 32 32 32 32 32 32 32 32 32 42 zs 28 42 32 32 32 32 32 32 32 32
 32 32 107 32 32 32 32 32 32 32 32 32 32 32 32 32 32 32 42 zs 28
 42 32 32 32 32 32 32 32 32 32 32 32 32 32 32 32 32 32 32 32 32
 32 32 32 32 32 32 42 zs 28 42 42 42 42 42 42 42 42 42 42 42 42
 42 42 42 42 42 42 42 42 42 42 42 42 42 42 42 42 1 1 zs 12 112
 98 95 111 98 106 101 99 116 115 46 112 zv 8 zs 28 42 42 42 42
 42 42 42 42 42 42 42 42 42 42 42 42 42 42 42 42 42 42 42 42 42
 42 42 42 zs 28 42 43 32 32 32 32 32 32 32 32 32 32 32 32 32 32
 32 32 32 32 32 32 32 32 32 32 32 42 zs 28 42 32 32 32 32 32 32
 32 32 32 32 32 32 32 32 32 32 32 32 32 32 32 32 32 32 32 32 42
 zs 28 42 32 32 32 32 32 32 32 32 32 64 32 32 32 32 32 32 32 32
 32 32 32 32 32 32 32 32 42 zs 28 42 32 32 32 32 94 32 32 49 32
 32 32 32 32 32 32 32 32 32 32 32 32 32 32 32 32 32 42 zs 28 42
 32 32 32 32 32 32 32 32 32 32 107 32 32 32 32 32 32 32 32 32
 32 32 32 32 32 32 42 zs 28 42 32 32 32 32 32 32 32 32 32 32 32
 32 32 32 32 32 32 32 32 32 32 32 32 32 32 32 42 zs 28 42 42 42
 42 42 42 42 42 42 42 42 42 42 42 42 42 42 42 42 42 42 42 42 42
 42 42 42 42 1 1 zv 1 zc bug 5 7 3 2 zc retina za zl 4 1 5 1 7
 32 32 32 32 32 32 32 32 32 32 32 32 32 32 32 32 32 32 32 32 32
 32 32 32 32 32 32 32 32 32 32 32 32 32 32 undef zl 0 zl 0 32
 500 500 undef 3 4 east zl 2 1 0 zl 2 0 -1 3 4 east 1 1
2 zw 5 117 110 100 101 102 zw 5 117 110
 100 101 102 zw 5 117 110 100 101 102 zw 5 117 110 100 101 102
 zw 5 117 110 100 101 102 zw 5 117 110 100 101 102 zw 5 117 110
 100 101 102 zw 5 117 110 100 101 102 zw 5 117 110 100 101 102
 zw 5 117 110 100 101 102 zw 5 117 110 100psworld7                                                                                            100705  017064  000205  00000001306 05427665634 007072  0                                                                                                     47426                                                                                    1  0                                                                                                                                                                        ***********                   *******          *****   *
*******+          ********      *****       **********    *  *
*  F                      ******                          ***
 *
 *    S
  *                      s
  *****                 ss
      *                ssss
 ******                 s                              ss
 *                                                      s
*  s           A                                        s
* ssss
* sss
 *  s
 *                                                            sss s
 *                                                              ss
  **
    **
    *       ssss
    *       s ss
   *          s
  *
                                                                                              47426                                                                                    1  0                                                                                                                                                                 random.pl                                                                                           100705  017064  000205  00000006300 05427700017 007163  0                                                                                                     47426                                                                                    1  0                                                                                                                                                                 /*  RANDOM.PL  */
 
 
/*
This module exports a random-number generator needed by "spin".
*/
 
 
:- module random.
 
 
:- public random/2,
          randomise/0,
          randomise/1,
          random_element/3,
          random_element/2,
          random_permutation/2.
 
 
/*
SPECIFICATION
-------------
 
 
PUBLIC random( N+, I? ):
 
Given an integer N >= 1, random(N, I) unifies I with a random integer
between 0 and N - 1.
 
 
PUBLIC randomise:
Restart the random sequence from the beginning
 
 
PUBLIC randomise( Seed+ ):
 
Instantiate the seeds to your own favourite value
 
 
PUBLIC random_element( List+, Elem?, Rest? ):
 
Given an non-empty List, unifies Elem with a random element of List and
Rest with the other elements.
 
 
PUBLIC random_element( List+, Elem? ):
 
Equivalent to random_element( List, Elem, _ ).
 
 
PUBLIC random_permutation( List+, Perm? ):
 
Unifies Perm with a random permutation of List. What good this may be
I'm not sure, and there's bound to be a more efficient way of doing it.
Oh well.
*/
 
 
/*
IMPLEMENTATION
--------------
 
I have adapted this file from RANDOM.PL in the DEC-10 public-domain
library. The original heading was
Author : R.A.O'Keefe
Updated: 1 October 1984
NIP version: 13 May 1987
Purpose: Random number generator.
 
The code should be portable (I don't know if there are any dependencies
on word size), except that you will need to change 'intof' as a right
operand of 'is' in 'random' to whatever your system uses for converting
reals to integers with truncation towards zero.
*/
 
 
:- dynamic '$random_seed'/1.
 
 
:- needs
   bug / 2,
   length / 2,
   nth1 / 4.
 
 
random( N, I ) :-
    (
        '$random_seed'( [A0,A1,A2] )
    ->
        retractall( '$random_seed'(_) )
    ;
        A0 = 3172, A1 = 9814, A2 = 20125
    ),
    B0 is (A0*171) mod 30269,
    B1 is (A1*172) mod 30307,
    B2 is (A2*170) mod 30323,
    asserta( '$random_seed'([B0,B1,B2]) ),
    R is A0/30269 + A1/30307 + A2/30323,
    I is intof((R - intof(R)) * N).
 
 
/*
The next bit: K R Johnson, 13-5-87
*/
randomise :-
    (
        '$random_seed'( _ )
    ->
        retractall( '$random_seed'(_) )
    ;
        true
    ),
    asserta( '$random_seed'([3172,9814,20125]) ).
 
 
randomise(Seed) :-
    integer(Seed),
    Seed > 0,
    !,
    (
        '$random_seed'(_)
    ->
        retractall( '$random_seed'(_) )
    ;
        true
    ),
    S0 is Seed mod 30269,
    S1 is Seed mod 30307,
    S2 is Seed mod 30323,
    asserta( '$random_seed'([S0,S1,S2]) ).

randomise( Seed ) :-
    bug( 'randomise: Seed must be a positive integer', [Seed] ).


random_element( [E], E, [] ) :- !.

random_element( List, Elem, Rest ) :-
    length( List, N ),
    N > 0,
    random( N, I ),
    I_ is I + 1,
    nth1( I_, List, Elem, Rest ).
 
 
random_element( List, Elem ) :-
    random_element( List, Elem, _ ).
 
 
random_permutation([], []).
random_permutation([H1|T1], [H2|T2]) :-
    random_element([H1|T1], H2, T3),
    random_permutation(T3, T2).
 
 
:- endmodule.
100 101 102 zw 5 117 110 100 101 102 zw 5 117 110 100 101 102
 zrestart.com                                                                                         100705  017064  000205  00000000336 05427665642 007553  0                                                                                                     47426                                                                                    1  0                                                                                                                                                                 $ sd [popx.eden]
$ oxtime 800
$ pop11
load eden.p;
load generate.p;
load ga.p;
"batch" -> mode;
"ga_save" -> save_file;
50 -> start_energy;
300 -> population;
restart( 'tw1', 100 );
sysexit();
$ tf restart
32 32 32 42 zs 11 42 42 42 42 42 42 42 42 42 42 42
 1 1 zs 12 112 98 95 111 98 106 101 99 116 115 46 112 zv 6 zs 11
 42 42 42 42 42 42 42 42 42 42 42 zs 11 42 43 32 32 32 32 32 32
 32 32 42 zs 11 42 32 32 32 32 32 83 32 32 32 42 zs 11 42 32 32
 32 32 32 32 70 32 32 42 zs 11 42 32 32 32 32 32 32 32 32 32 4restart1.com                                                                                        100705  017064  000205  00000000340 05427665642 007627  0                                                                                                     47426                                                                                    1  0                                                                                                                                                                 $ sd [popx.eden]
$ oxtime 800
$ pop11
load eden.p;
load generate.p;
load ga.p;
"batch" -> mode;
"ga1_save" -> save_file;
50 -> start_energy;
300 -> population;
restart( 'tw3', 100 );
sysexit();
$ tf restart1
                                                  47426                                                                                    1  0                                                                                                                                                                 retina.p                                                                                            100705  017064  000205  00000015016 05427665643 007034  0                                                                                                     47426                                                                                    1  0                                                                                                                                                                 /*  RETINA.P  */


section $-retina => new_retina
                    retina_bounds
                    ved_retina;


/*
SPECIFICATION
-------------

This module defines the data structure that makes up a bug's retina, and
a routine for creating retinal images from Ved buffers.


Externally, a retina looks like a 2-D array. Create one by calling
    new_retina( width, height ).

Access it by subscripting:
    retina(3,4).
    `#` -> retina(x,y).
Retinas are mapped onto strings, so you'll get an error if you try to
store anything other than a character in them. In fact, there's
an extra check that this character is printable.

Their class_print is set to a line-by-line display routine, so the
print-arrow will automatically print the contents.


PUBLIC new_retina( width, height ):

Returns a new retina, contents all spaces, of the specified width and
height.


PUBLIC retina_bounds( retina ):

Returns the retina's x and y upper bounds, in the order
    xmax ymax.


PUBLIC retina(x,y): (subscripting)

Returns the (x,y)th element of retina, as a character. The origin is
(1,1).


PUBLIC c -> retina(x,y): (updater via subscripting)

Sets the (x,y)th element of retina to character c.


PUBLIC ved_retina():

Defines the Ved command 'retina', which copies the contents of the
current file into a retina.

The command can have the following forms
    retina
    retina name
    retina xmax ymax
    retina name xmax ymax

These commands create a new retina and assign it to valof(name). If name
is omitted, it defaults to "retina".

If xmax and ymax are specified, then they act as the retina's upper
bounds. The retinal coordinate system runs with Y upwards, so the Ved
line ymax becomes retinal line 1: that is, retinal point (1,1)
corresponds to Ved point (1,ymax), and retinal point (1,ymax)
corresponds to Ved point (1,1). No prizes to whoever decided to invert
the Ved coordinate system.

If xmax and ymax are omitted, they default to the rightmost occupied
column, and to the highest-numbered occupied line.
*/


/*
IMPLEMENTATION
--------------

We represent a retina as a one-element record, whose single field is an
array. We define the record's class_apply routine so that subscripting
it accesses this array, and we modify its class_print routine so that
printing it displays the retina a line at a time.

The array is mapped onto a string by newanyarray. I originally did this
just because I wanted to be able to give newanyarray a second
(initialising) argument, and you can't do that without giving it a third
one too. (The documentation suggests you can, but it doesn't work.)
However, using strings is useful because it stops people putting
non-characters in the array.

ved_retina depends on getvedargs and vedbounds, from utils.


Portability
-----------

The check in the subscripting updater for retinas assumes that characters
are represented in ASCII, when checking that object symbols are in range.
*/


needs utils;
needs fault;


recordclass retina
    retina_chars;
    ;;; The contents.


define global new_retina( width, height );
    lvars width, height;
    consretina( newanyarray( [% 1, width, 1, height %], ` `, key_of_dataword("string") ) );
enddefine;


/*  Retina subscripting.  */
procedure( x, y, retina );
    lvars x, y, retina;
    (retina.retina_chars)(x,y);
endprocedure -> class_apply( key_of_dataword("retina") );


/*  Updater for subscripting.  */
procedure( c, x, y, retina );
    lvars c, x, y, retina;

    if c < ` ` or c > 127 then
        FAULT( 'updating retina: character out of range', [%c,x,y,retina%] );
    endif;

    c -> (retina.retina_chars)(x,y);
endprocedure -> updater( class_apply( key_of_dataword("retina") ) );


/*  Print routine.  */                     
procedure( retina );
    lvars retina;
    lvars i, j, width, height;

    explode( boundslist(retina.retina_chars) ) -> height -> () -> width -> ();

    printf( 'retina: height: %p;  width: %p\n', [% height, width %] );
    for j from height by -1 to 1 do
        for i to width do
            cucharout( retina(i,j) );
        endfor;
        1.nl;
    endfor;
    1.nl;
endprocedure -> class_print( key_of_dataword("retina") );


define global retina_bounds( retina );
    lvars retina;
    lvars bounds;
    boundslist(retina.retina_chars) -> bounds;
    bounds(2); bounds(4);
enddefine;


vars vedretina;  /*forward*/


define global ved_retina();
    vedretina(
        procedure(retina,varname);
            lvars retina,varname;
            retina -> valof(varname)
        endprocedure
    );
enddefine;


/*  vedretina( proc ):
        Reads the retinal image from the current Ved buffer, converts it
        to a retina record r, and calls
            proc( r, name )
        where name is the argument given to the Ved command.

        When using Pop-11, proc just assigns r to valof(name). However,
        we can also call vedretina from Prolog. Since Prolog users
        don't like accessing Pop-11 global variables, I supply _them_
        with a ved command for putting retinas into the database.
        This requires encapsulating r differently, i.e. a different
        proc argument to vedretina.

        Note: there is a comment under 'vedworld' in WORLDS.P that
        refers to this one.
*/
define vedretina( p );
    lvars p;
    lvars i, j, x_min, x_max, line_min, line_max;
    lvars varname, width, height, retina, args, len;          

    if vedargument = '' then
        vedbounds() -> line_max -> line_min -> x_max -> x_min;
        x_max -> width;
        line_max -> height;
        "retina" -> varname;
    else getvedargs( [1,2,3]) -> args -> len;
        if len = 1 then
            vedbounds() -> line_max -> line_min -> x_max -> x_min;
            x_max -> width;
            line_max -> height;
            args(1).consword -> varname;
        elseif len = 2 then
            "retina" -> varname;
            args(1) -> width;
            args(2) -> height;
        elseif len = 3 then
            args(1).consword -> varname;
            args(2) -> width;
            args(3) -> height;
        endif
    endif;

    new_retina( width, height ) -> retina;

    for j to height do
        for i to width do
            vedjumpto(j,i);
            vedcurrentchar() -> retina(i,height-j+1);
        endfor;
    endfor;

    p( retina, varname );

enddefine;


endsection;
 ;
        A0 = 3172, A1 = 9814, A2 = 20125
    ),
    B0 is (A0*171) mod 30269,
    B1 is (A1*172) mod 30307,
    B2 is (A2*170) mod 30323,
    asserta( '$random_seed'([B0,B1,B2]) ),
    R is A0/30269 + A1/30307 + A2/30323,
    I is intof((R - intof(R)) * N).
 
 
/*
The next bit: K R Johnson, 13-5-87
*/retina_path.p                                                                                       100705  017064  000205  00000004056 05427665643 010052  0                                                                                                     47426                                                                                    1  0                                                                                                                                                                 /*  RETINA_PATH.P  */


section retina_path => retina_path;


/*
SPECIFICATION
-------------


This module finds a path within an retina, using hill-climbing search. A
``retina'' is a ....
of its world. For a description of RETINAs and the operations on them, see
HELP RETINA.

The module defines one routine, retina_path:


PUBLIC retina_path( retina, start, goal, safe ):

Searches for a path from start to goal within retina. The procedure safe
determines which points can be traversed and which are treated as
obstacles. The path is returned as a list of points whose first element
is start and whose final element is goal. Each point is represented as a
two-element list [%x,%y]. If there is no path, the procedure returns
false.

safe must be a procedure of three arguments, safe(retina,x,y) returning
true or false. It returns true if retina(x,y) is passable, and false if
it is an obstacle. You will usually want to define it as
    define safe(retina,x,y);
        lvars retina, x, y;
        retina(x,y) = ` `
    enddefine;


See HELP AWM_PATH for a description of the search method.
*/


/*
IMPLEMENTATION
--------------
...
*/


needs utils;
needs vec;
needs retina;
needs search;
needs awm;
needs awm_path;


define global retina_path( retina, start, goal, safe );
    lvars retina, start, goal, safe;

    lvars awm, awm_start, awm_goal, path, loc;

    new_awm(`?`) -> awm;
    awm_merge_retina( awm, retina );
    awm_retina_coords_to_awm_coords( awm, start ) -> awm_start;
    awm_retina_coords_to_awm_coords( awm, goal ) -> awm_goal;
    awm_path( awm, awm_start, awm_goal, safe ) -> path;
    if path /= false then
        [%
            for loc in path do
                awm_awm_coords_to_retina_coords( awm, loc );
            endfor;
        %]
    else
        path
    endif;
enddefine;


define test();
    define safe(awm,x,y);
        lvars awm, x, y;
        true
    enddefine;
    retina_path( retina(), [3 1], [3 3], safe );
enddefine;


endsection;
                                                                 retina_pl.p                                                                                         100705  017064  000205  00000000646 05427665643 007532  0                                                                                                     47426                                                                                    1  0                                                                                                                                                                 section retina => ved_pretina;


define ved_pretina();
    vedretina(
        procedure( retina, varname );
            lvars retina, varname;
            lvars assertion, goal;
            prolog_maketerm( retina, varname, 1 ) -> assertion;
            prolog_maketerm( assertion, "asserta", 1 ) -> goal;
            prolog_invoke( goal ).erase;
        endprocedure
    );
enddefine;


endsection;
                                                                                                                s2w1.w                                                                                              100705  017064  000205  00000007526 05427665645 006366  0                                                                                                     47426                                                                                    1  0                                                                                                                                                                  zc world 56 19 zv 19 undef undef undef undef undef undef undef
 undef undef undef undef undef undef undef undef undef undef undef
 undef undef undef undef undef undef undef undef zs 16 100 101
 102 97 117 108 116 111 98 106 101 99 116 115 46 112 500 zv 19
 zs 56 42 42 42 42 42 42 42 42 42 42 42 42 42 42 42 42 42 42 42
 42 42 42 42 42 42 42 42 42 42 42 42 42 42 42 42 42 42 42 42 42
 42 42 42 42 42 42 42 42 42 42 42 42 42 42 42 42 zs 56 42 32 32
 32 32 32 32 32 32 32 32 32 32 32 32 32 32 32 32 32 32 32 32 32
 32 32 32 32 32 32 32 32 32 32 32 32 32 32 32 32 32 32 32 32 32
 32 32 32 32 32 32 32 32 32 32 42 zs 56 42 32 32 32 32 32 32 32
 32 32 32 32 32 32 32 32 32 32 32 32 32 32 32 32 32 32 32 32 32
 32 32 32 32 32 32 32 32 32 32 32 32 32 32 32 32 32 32 32 32 32
 32 32 32 32 32 42 zs 56 42 32 32 32 32 32 32 32 32 32 32 32 32
 32 32 32 32 32 32 32 32 32 32 32 32 32 32 32 32 32 32 32 32 32
 32 32 32 32 32 32 32 32 32 32 32 32 32 32 32 32 32 32 32 32 32
 42 zs 56 42 42 42 42 42 42 42 42 42 42 42 42 42 42 42 42 42 42
 42 42 42 42 42 32 32 32 32 42 42 42 42 42 42 42 42 42 42 42 42
 42 42 42 42 42 42 42 42 42 42 42 42 42 42 42 42 42 zs 56 42 32
 32 32 32 32 32 32 32 32 42 32 32 32 32 32 32 32 32 32 32 32 42
 32 32 32 32 42 32 32 32 32 32 32 32 32 32 32 32 32 32 32 32 32
 32 32 32 32 32 32 32 32 32 32 32 42 zs 56 42 32 32 32 32 32 32
 42 32 32 42 32 32 42 42 42 42 32 32 32 32 32 42 32 32 32 32 42
 32 32 32 32 32 32 32 32 32 32 32 32 32 32 32 42 32 32 32 32 32
 32 32 32 32 32 32 42 zs 56 42 32 32 32 32 32 32 42 32 32 42 32
 32 42 32 32 32 32 32 32 32 32 42 32 32 32 32 42 32 32 32 32 32
 32 32 32 32 32 32 32 32 32 32 42 32 32 32 32 32 32 32 32 32 32
 32 42 zs 56 42 32 32 32 32 32 32 42 42 42 42 32 32 42 42 42 42
 42 42 42 42 42 42 32 32 32 32 42 42 42 42 42 42 42 42 42 42 42
 42 42 42 42 42 42 32 32 32 32 32 32 32 32 32 32 32 42 zs 56 42
 32 32 32 32 32 32 32 32 32 32 32 32 32 32 32 32 32 32 32 32 32
 32 32 32 32 32 32 32 32 32 32 32 32 32 32 32 32 32 32 32 32 32
 32 32 32 32 32 32 32 32 32 32 32 32 42 zs 56 42 32 32 32 32 32
 32 32 32 32 32 32 32 32 32 32 32 32 32 32 32 32 32 32 32 32 32
 32 32 32 32 32 32 32 32 32 32 32 32 32 32 32 32 32 32 32 32 32
 32 32 32 32 32 32 32 42 zs 56 42 32 32 32 32 32 32 42 42 42 42
 42 42 42 42 42 42 42 42 42 42 42 42 42 42 42 42 42 42 42 42 42
 42 42 42 42 42 42 42 42 42 42 42 42 32 32 32 32 32 32 32 32 32
 32 32 42 zs 56 42 32 32 32 32 32 32 42 32 32 32 32 32 32 32 32
 32 32 32 32 32 32 32 32 32 32 32 32 32 32 32 32 32 32 32 32 32
 32 32 32 32 32 32 42 32 32 32 32 32 32 32 32 32 32 32 42 zs 56
 42 32 32 32 32 32 32 42 32 43 32 32 32 32 32 32 32 32 32 32 32
 32 32 32 32 32 32 32 32 32 32 32 32 32 32 32 32 32 32 32 32 32
 32 42 32 32 32 32 32 32 32 32 32 32 32 42 zs 56 42 32 32 32 32
 32 32 42 42 42 42 42 42 42 42 42 42 42 42 42 42 42 42 42 42 42
 42 42 42 32 32 32 42 42 42 42 42 42 42 42 42 42 42 42 32 32 32
 32 32 32 32 32 32 32 32 42 zs 56 42 32 32 32 32 32 32 32 32 32
 32 32 32 32 32 32 32 32 32 32 32 32 32 32 32 32 32 32 32 32 32
 32 42 32 32 32 32 32 32 32 32 32 32 32 32 32 32 32 32 32 32 32
 32 32 32 42 zs 56 42 32 32 32 32 32 32 32 32 32 32 32 32 32 32
 32 32 32 32 32 32 32 32 32 32 32 32 32 32 32 32 32 42 32 32 32
 32 32 32 32 32 32 32 32 32 32 32 32 32 32 32 32 32 32 32 42 zs 56
 42 32 32 32 32 32 32 32 32 32 32 32 32 32 32 32 32 32 32 32 32
 32 32 32 32 32 32 32 32 32 32 32 42 32 32 32 32 32 32 32 32 32
 32 32 32 32 32 32 32 32 32 32 32 32 32 42 zs 56 42 42 42 42 42
 42 42 42 42 42 42 42 42 42 42 42 42 42 42 42 42 42 42 42 42 42
 42 42 42 42 42 42 42 42 42 42 42 42 42 42 42 42 42 42 42 42 42
 42 42 42 42 42 42 42 42 42 3 2 east 9 13 zc bug 5 7 3 2 zc retina
 za zl 4 1 5 1 7 32 32 32 32 32 32 32 32 32 32 32 32 32 32 32
 32 32 32 32 32 32 32 32 32 32 32 32 32 32 32 32 32 32 32 32 undef
 zl 0 zl 0 undef undef undef
ne;


vars vedretina;  /*forward*/


define global ved_retina();
    vedretina(
        procedure(retina,varname);
            lvars retina,varname;
            retina -> valof(varname)
        endprocedure
    );
enddefine;


/*  vedretina( proc ):
        Reads the retinal image fsearch.p                                                                                            100705  017064  000205  00000031004 05427665647 007016  0                                                                                                     47426                                                                                    1  0                                                                                                                                                                 /*  SEARCH.P  */


section $-search => search,
                    path_search,
                    trace_search,
                    untrace_search,
                    df_insert,
                    bf_insert,
                    eval_insert,
                    df_path_insert,
                    bf_path_insert,
                    eval_path_insert;


/*
SPECIFICATION
-------------

This module defines general routines for searching. They are very
general: by changing the arguments, you can configure them to do
depth-first, breadth-first, hill-climbing and many other types of
search.

To understand how, you have to know how the search is implemented.
Each search routine maintain a "queue": a list of those points which
have been marked for examination but not yet examined. The routine works
in a cycle, thus:

    1)  Take the first element off the queue. If there is none,
        the search has failed: return false. Otherwise, this is
        the next point to be explored.

    2)  If this point is the goal, return true.

    3)  Find all the neighbours of this point, eliminating any
        which have already been explored. Add the others to the
        queue, making sure that if a neighbour is generated more than
        once, only one copy gets added.

    4)  Go back to 1.

By altering the way that stage 3 adds neighbours to the queue, we can
determine the type of search. For example, if each neighbour is added to
the front of the queue, we get depth-first; the final neighbour added
will be the first to be explored. If each neighbour is added to the end
of the queue, we get breadth-first. If we sort the queue in order of
estimated distance from the goal, so that the nearest point is the first
to be explored, we get hill-climbing. This is explained in many
references, for example in the chapter on Search in "Artificial
Intelligence" by Winston. Those unfamiliar with the idea will find TEACH
SEARCHING useful: note how the 'insert' procedure is used.


PUBLIC search( here, is_goal, next_from, insert ):

The arguments are as follows:
here        : the initial point to search from.
is_goal     : a function
                  is_goal(point)
              which returns true if point is a goal, and false
              otherwise.
next_from   : a function
                  next_from(point)
              which returns a list of all the neighbours to be
              explored.
insert      : a function
                  insert(point, queue)
              which inserts point into queue returning a new queue.

'search' searches for a goal point from 'here' as described above,
returning true if it finds one and false otherwise.

'search' keeps track of the points which have already been visited, so
as to avoid getting into loops. You can therefore safely use it for
depth-first search, even if you suspect loops in the search tree.

It also (as mentioned above) avoids adding the same neighbour to the
queue more than once, if next_from returns several copies. However, for
efficiency, it's as well to write a generator that doesn't do so.


PUBLIC path_search( here, is_goal, next_from, insert ):

'path_search' is used when you want to know the path to the goal. If
one can be found, it returns this as a list of points: the first
element is 'here', the final one is the goal, and the others are the
points in between. If one can't be found, it returns false.

The arguments are the same as for 'search' with the exception of
'insert'. This is now a function
    insert( here, path, queue )
which returns a new queue. The queue is now a list of _lists_, each
of the form
    [% point, path_to_point %]

When examining an element, you must therefore get its head to get the
point. When constructing the element for 'here', its second element must
be 'path'. See the supplied insert functions below for examples.


PUBLIC trace_search():

Turns on tracing. When this is on, the routines make the following calls
in each cycle:
    printf('q %p\n', [%queue%] )
    printf('here %p\n', [%here%] )
    printf('neighbours %p\n', [%neighbours%] )
    printf('inserting %p\n', [%neighbour%] )
showing the queue, point being explored, neighbours (result of
next_from), and each neighbour being inserted.


PUBLIC untrace_search():

Turns off tracing.


PUBLIC df_insert( point, q ):

An insert routine for 'search' for implementing depth-first search.
Defined as
    define df_insert( point, q );
        lvars point, q;
        [ ^point ^^q ]
    enddefine;


PUBLIC bf_insert( point, q ):

An insert routine for 'search' for implementing breadth-first search.
Defined as
    define bf_insert( point, q );
        lvars point, q;
        [ ^^q ^point ]
    enddefine;


PUBLIC eval_insert( point, q, eval ):

An insert routine for 'search' for implementing evaluation-guided
search. 'eval' is a function eval(point)->number which maps a point to
an evaluation. The higher the evaluation, the better the point, so the
further forward in the queue it will go. Defined as
    define eval_insert( point, q, eval );
        lvars point, q, eval;
        if eval(point) > eval(hd(q)) then
            [ ^point ^^q ]
        else
            [ ^(hd(q)) ^^(eval_path_insert(point,tl(q),eval)) ]
        endif;
    enddefine;

Note: this may evaluate the same point several times. If evaluation is
expensive, store your evaluation in a property (or somewhere) and re-use
it.


PUBLIC df_path_insert( point, path, q ):

An insert routine for 'path_search' for implementing depth-first search.
Defined as
    define df_path_insert( point, path, q ):
        lvars point, path, q;
        [ [^point ^path] ^^q ]
    enddefine;


PUBLIC bf_path_insert( point, path, q ):

An insert routine for 'path_search' for implementing breadth-first
search. Defined as
    define bf_path_insert( point, path, q ):
        lvars point, path, q;
        [ ^^q [^point ^path] ]
    enddefine;


PUBLIC eval_path_insert( point, path, q, eval ):

An insert routine for 'path_search' for implementing evaluation-guided
search. 'eval' is a function eval(point)->number which maps a point to
an evaluation. The higher the evaluation, the better the point, so the
further forward in the queue it will go. Defined as
    define eval_path_insert( point, path, q, eval );
        lvars point, path, q, eval;
        if eval(point) > eval(hd(hd(q))) then
            [ [^point ^path] ^^q ]
        else
            [ ^(hd(q)) ^^(eval_path_insert(point,path,tl(q),eval)) ]
        endif;
    enddefine;


NB: both search routines compare two points for equality by using =. If
your representation of points is such that different structures can
denote the same point, this won't work. */


/*
IMPLEMENTATION
--------------

The idea of parameterising search by altering the way elements are added
to a queue is well-known, see (e.g.) the chapter on Search in
"Artificial Intelligence" by Winston. The code in this module is based
on that in TEACH SEARCHING. Originally, I used matching to extract
elements from the queue, because it was easy to write, and easy for
novices to compare with TEACH SEARCHING.

However, when I introduced sections, I had to change this, because
the matching operators ? and ?? don't work properly inside sections.
This is a shame - if we ever get a matcher that does, restore the
original code.

'path_search' works in the same way as 'search', except for the
structure of the queue. In 'search', this is a list of points to be
explored. In 'path_search', each element is itself a list. The first
element of this list is the point to be explored; the second element is
the path to it from the start point. Although much of the rest of the code
is duplicated, it seemed neater to have two different routines than to
try parameterising one.

The 'eval_insert' routine is inefficient unless you use memo-functions
or an equivalent such as properties, because it may evaluate a point
several times. What's a neat way to circumvent that without spoiling the
interface?
*/


vars tracing = false;


define global trace_search();
    true -> tracing;
enddefine;


define global untrace_search();
    false -> tracing;
enddefine;


define global search( here, is_goal, next_from, insert );              
    lvars here, is_goal, next_from, insert;
    lvars neighbours, visited, q;

    /*
    q      : points that are waiting to be explored.
    visited: all points that have been explored.
    q and visited are disjoint.
    */

    [% here %] -> q;
    [] -> visited;

    repeat forever
        if tracing then printf('q %p\n', [%q%] ) endif;

        if q = [] then return(false) else dest(q) -> q -> here endif;
        if is_goal(here) then return(true) endif;

        if tracing then printf('here %p\n', [%here%] ) endif;

        [^here ^^visited] -> visited;
        next_from(here) -> neighbours;
        if tracing then printf('neighbours %p\n', [%neighbours%] ) endif;

        /*
        Insert into q all those neighbours which we haven't already
        visited, and which are not already in it. The second check frees
        next_from from the need not to return the same point more than
        once (though for efficiency, it's a good idea for it not to).
        */
        while neighbours /= [] do
            dest(neighbours) -> neighbours -> here;
            unless member(here, visited) or member(here, q ) then
                if tracing then printf('here %p\n', [%here%] ) endif;
                insert(here, q) -> q
            endunless;
        endwhile;
    endrepeat;

enddefine;


vars inq;/*forward*/


define global path_search( here, is_goal, next_from, insert );
    lvars here, is_goal, next_from, insert;
    lvars neighbours, first, visited, q, path;

    /*
    The variables have the same meaning as in 'search', except for
    q. Each element is a list [% p, path %], where p is a point to
    be explored, and path is the path from the initial value of 'here'
    (root of the search tree) to p. This path includes its endpoints.
    */
    [% [% here, [%here%] %] %] -> q;
    [] -> visited;

    repeat forever
        if tracing then printf('q %p\n', [%q%] ) endif;

        if q = [] then
            return(false)
        else
            dest(q) -> q -> first;
            first(1) -> here;
            first(2) -> path;
        endif;
        if is_goal(here) then return(path) endif;

        if tracing then printf('here %p\n', [%here%] ) endif;

        [^here ^^visited] -> visited;

        next_from(here) -> neighbours;
        if tracing then printf('neighbours %p\n', [%neighbours%] ) endif;

        while neighbours /= [] do
            dest( neighbours ) -> neighbours -> here;
            if not(member(here, visited)) and not(inq(here, q)) then
                if tracing then printf('inserting %p\n', [%here%] ) endif;
                insert( here, [^^path ^here], q ) -> q
            endif;
        endwhile;
    endrepeat;

enddefine;


/*  inq( point, queue ):
        True if 'point' is in 'queue', where 'queue' is used by
        path_search. We can't use 'member' for this test, because
        each element of the queue is not a point, but a point and
        a partial path.       
*/
define inq( here, q );
    lvars here, q;
    lvars p;
    for p in q do
        if here = p(1) then return(true) endif;
    endfor;
    return(false);
enddefine;


define global df_insert( point, q );
    lvars point, q;
    [ ^point ^^q ]
enddefine;


define global bf_insert( point, q );
    lvars point, q;
    [ ^^q ^point ]
enddefine;


vars eval_path_insert;/*forward*/


define global eval_insert( point, q, eval );
    lvars point, q, eval;
    if eval(point) > eval(hd(q)) then
        [ ^point ^^q ]
    else
        [ ^(hd(q)) ^^(eval_path_insert(point,tl(q),eval)) ]
    endif;
enddefine;


define global df_path_insert( point, path, q );
    lvars point, path, q;
    [ [^point ^path] ^^q ]
enddefine;


define global bf_path_insert( point, path, q );
    lvars point, path, q;
    [ ^^q [^point ^path] ]
enddefine;


define global eval_path_insert( point, path, q, eval );
    lvars point, path, q, eval;
    if eval(point) > eval(hd(hd(q))) then
        [ [^point ^path] ^^q ]
    else
        [ ^(hd(q)) ^^(eval_path_insert(point,path,tl(q),eval)) ]
    endif;
enddefine;


endsection;
e ar                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                skier.pl                                                                                            100705  017064  000205  00000001632 05427665651 007041  0                                                                                                     47426                                                                                    1  0                                                                                                                                                                 /*  SKIER.PL  */


resolve [r].


stm [ wants(eddie,fun),
      had_lessons(eddie,178),
      max_pressups(eddie,50)
    ].


stm_predicates all.


is_a(Skier, beginner), wants(Skier, fun)
=>
suits(Skier, st_sartre).

is_a(Skier, beginner), wants(Skier, serious)
=>
suits(Skier, schloss_heidegger).

is_a(Skier, advanced), wants(Skier, serious)
=>
suits(Skier, chateau_derrida).

is_a(Skier, advanced), wants(Skier, fun)
=>
suits(Skier, wittgenstein_gladbach).

had_lessons(Skier, L), L < 30
=>
is_a(Skier, beginner).

had_lessons(Skier, L), L >= 30, has_fitness(Skier, poor)
=>
is_a(Skier, beginner).

had_lessons(Skier, L), L >= 30, has_fitness(Skier, good)
=>
is_a(Skier, advanced).

max_pressups(Skier, P), P < 10
=>
has_fitness(Skier, poor).

max_pressups(Skier, P), P >= 10
=>
has_fitness(Skier, good).

suits( _, _ ) => exec( [forward] ), exec( [right] ).
t, q;
        [ ^point ^^q ]
    enddefine;


PUBLIC bf_insert( point, q ):

An insert routine for 'search' for implementing breadth-first search.
Defined as
   stow.p                                                                                              100705  017064  000205  00000012340 05427665653 006544  0                                                                                                     47426                                                                                    1  0                                                                                                                                                                 /*  STOW.P  */


section $-stow =>
        stow_to,
        unstow_from;


/*
SPECIFICATION
-------------


This file defines procedures for saving data to, and reading from,
files. They are based on the same idea as LIB DATAFILE (from which
I built them).

The idea is that you open a file by calling (for example):
    stow_to( filename ) -> c;

You can then save arbitrary data items to this file by doing, e.g.,
    c( a );
    c( [% p, q, 1 %] );
    c( retina );
Conceptually, each data item is stored on a new ``line'', and can be
read back without getting mixed up with any of the others.

When your file is complete, call
    c( termin );
to close it.

You can then read back the data items, in order, by reversing this
process:
    unstow_from( filename ) -> r;
    r()=>
    r()=>
    r()=>

The successive calls of 'r' will return the data items saved; when there
are no more left, 'r' will return termin.


PUBLIC stow_to( filename );

Filename must be a string. stow_to returns a consumer, c. Every time c
is called, it will save its argument to the named file. To close
the file, call c(termin).

Example:
    stow_to( 'mydata.' ) -> keep;
    keep(1);
    keep(2);
    keep( { [a b 1.2 3 {4} ] } );
    keep(termin);


PUBLIC unstow_from( filename );

unstow_from returns a repeater, r. Every time r is called, it will
return the next piece of data in the file. If there is none left,
it will return termin; sunsequent calls will provoke an error.

Example:
    unstow_from( 'mydata.' ) -> get;

Calls of get() will return the data written by keep.
*/


/*
IMPLEMENTATION
--------------

This is based on LIB DATAFILE. stow_to(f) returns stow(%C%), where
C is a character consumer to f; unstow_from(f) returns unstow(%R%),
where R is an item repeater for f.

stow and unstow are the main writing routines; they perform
initialisations, and then call fwrite and fread respectively.

This library comes with a HELP file, HELP STOW. Make sure the two are
kept in step.
*/


vars stow, unstow, fread, fwrite; /*forward*/


define global stow_to( filename );
    lvars filename;
    stow(% discout( filename ) %);
enddefine;


define global unstow_from( filename );
    lvars filename;
    unstow(% incharitem(discin(filename)) %);
enddefine;


define stow( _x, consumer );
    lvars _x, consumer;

    lvars saved_cucharout;
    cucharout -> saved_cucharout;

    vars charsonline=0;

    procedure(c,consumer);
        lvars c, consumer;
        consumer(c);
        1 + charsonline -> charsonline;
    endprocedure(% consumer %) -> cucharout;

    if _x = termin then
        pr(_x);
    else
        fwrite( _x );
        nl(1);
    endif;

    saved_cucharout -> cucharout;
enddefine;


define fwrite( _x );
    lvars x;

    if charsonline > 60 then nl(1); 0 -> charsonline endif;
    sp(1);
    if _x.isnumber or _x.isword then             
        pr(_x);
    elseif _x.islist then
        spr("zl"); pr(length(_x));
        applist(_x,fwrite);
    elseif _x.isstring then
        spr("zs"); pr(datalength(_x));
        appdata(_x,fwrite);
    elseif _x.isvector then
        spr("zv"); pr(datalength(_x));
        appdata(_x,fwrite);
    elseif _x.isprocedure then
        pr("za"); fwrite(boundslist(_x)); appdata(arrayvector(_x),fwrite);
    elseif _x.isref then
        pr("zr"); fwrite(cont(_x));
    elseif _x.isboolean then
        spr("zb");
        if _x then pr("true"); else pr("false"); endif;
    else
        spr("zc"); pr(dataword(_x)); appdata(_x,fwrite);
    endif;
enddefine;


define unstow( repeater );
    lvars repeater;

    vars rditem;
    repeater -> rditem;
    fread();
enddefine;


define fread();
    lvars _x, _t _n key;

    rditem() -> _x;

    if _x == "zl" then
        .rditem -> _t;
        nil -> _x;
        repeat _t times
            cons(.fread,_x) -> _x;
        endrepeat;
        rev(_x) -> _x;
        elseif _x == "zp" then
        conspair(.fread,.fread) -> _x;
    elseif _x == "zs" then
        .rditem -> _t;
        inits(_t) -> _x;
        for _n from 1 to _t do
            .fread -> fast_subscrs(_n,_x);
        endfor;
    elseif _x == "zv" then
        .rditem -> _t;
        initv(_t) -> _x;
        for _n from 1 to _t do
            .fread -> fast_subscrv(_n,_x);
        endfor;
    elseif _x == "za" then
        newarray(fread()) -> _x;
        datalength(arrayvector(_x)) -> _t;
        for _n from 1 to _t do
            .fread -> fast_subscrv(_n,arrayvector(_x));
        endfor;
    elseif _x == "zr" then
        consref(.fread) -> _x;
    elseif _x == "zb" then
        valof(.fread) -> _x;
    elseif _x == "zc" then
        ;;; get dataword and check for valid key - R. Evans Jan 83
        fread() -> _t;
        key_of_dataword(_t) -> key;
        unless key then
            mishap('Unknown dataword encountered in datafile\n' ><
                   ';;;          (recordclass declaration not loaded?)', [^(_t)]);
        endunless;
        repeat length(class_spec(key)) times .fread endrepeat;
        apply(class_cons(key)) -> _x
    endif;
    _x;
enddefine;


endsection;
  else
            dest(q) -> q -> first;
         sw1.w                                                                                               100705  017064  000205  00000000314 05427665656 006272  0                                                                                                     47426                                                                                    1  0                                                                                                                                                                  zc world 6 4 zv 4 zs 6 42 42 42 42 42 42 zs 6 42 32 32 43 32
 42 zs 6 42 32 32 32 32 42 zs 6 42 42 42 42 42 42 2 2 3 1 zs 16
 100 101 102 97 117 108 116 111 98 106 101 99 116 115 46 112 500
 east
:
        True if 'point' is in 'queue', where 'queue' is used by
        path_search. We can't use 'member' for this test, because
        each element of the queue is not a point, but a point and
        a partial path.       
*/
define inq( here, q );
    lvars here, q;
    lvars p;
    for p in q do
        ifterms.pl                                                                                            100705  017064  000205  00000000454 05427665661 007060  0                                                                                                     47426                                                                                    1  0                                                                                                                                                                 /*  TERMS.PL  */


:- library(record).


% copy(+Old,-New)
% Makes a fresh copy of the term Old. A bit hacky...

copy(Old, New) :-           % Altered to use data base
    recorda(copy,Old,Key),       % KJ  21-5-87
    recorded(copy,Mid,Key),
    erase(Key),
    !,
    New = Mid.
 q, eval );
    lvars point, path, q, eval;
    if eval(point) > eval(hd(hd(q))) then
        [ [^point ^path] ^^q ]
    else
        [ ^(hd(q)) ^^(eval_path_insert(point,path,tl(q),eval)) ]
    endif;
enddefine;


endsection;
e aruseful.p                                                                                            100705  017064  000205  00000000662 05427677751 007061  0                                                                                                     47426                                                                                    1  0                                                                                                                                                                 /*  USEFUL.P  */
 
 
/* This is the Pop component of USEFUL.PL. See it for an explanation. */
 
 
define set_prompt( P );
    P><'' -> prolog_read_prompt;
    /*  Convert it to a string before assigning.  */
enddefine;
 
 
define get_prompt();
    if prolog_read_prompt.isstring then
        prolog_read_prompt.consword
    else
        prolog_read_prompt
    endif
enddefine;
 
 
vars ^ = nonop **;
                                                                                                                useful.pl                                                                                           100705  017064  000205  00000017456 05427677716 007247  0                                                                                                     47426                                                                                    1  0                                                                                                                                                                 /*  USEFUL.PL  */


:- module useful.


:- public real/1,
          numeric/1,
          max/3,
          min/3,
          abolish/2,
          clause_vs_head_tail_pred_arity/5,
          clause_vs_head_tail/3,
          clause_vs_pred_arity/3,
          conj_vs_list/2,
          round_term_vs_list/4,
          is_system_pred/2,
          is_system_goal/1,
          get_prompt/1,
          set_prompt/1,
          add_portray/1,
          del_portray/1.
 
 
/*
SPECIFICATION
-------------
 
This module exports a few generally useful predicates.
 
The first two predicates, 'real' and 'numeric' provide type-tests that
ought to exist in Poplog Prolog (or any other implementation with real
numbers) but are unaccountably absent.
 
'abolish' ought also to exist in your Prolog, as it does in mine. If it
isn't there, use the definition below.
 
'max' and 'min' do what you'd expect, as do 'set/get_prompt' and
'is_system_pred/goal'.
 
'head_tail_arity_pred' is useful for taking clauses apart and
decomposing their heads, as are its relatives.
 
'conj_vs_list' converts between "round lists" (conjunctions of goals)
and lists.

'round_term_vs_list' does the same, but the operator need not be comma.
So it can convert between, e.g. (a+b+c+d) and [a,b,c,d].

'add/del_portray' make it easy to add and delete clauses for portray.

The module also defines ^ as the exponentiation operator. In Poplog, for
some reason, although ^ has been defined as an operator (xfy with
precedence 10), it is not recognised by "is", which expects **.


PUBLIC real( X+ ):
"X is a real number". You may have this built-in, possibly under the
name of "float".


PUBLIC numeric( X+ ):
"X is an integer or real". You may have this built-in, possibly under
the name of "number".

 
PUBLIC max( A+, B+, C? ):
"C is the maximum of A and B".
 
 
PUBLIC min( A+, B+, C? ):
"C is the minimum of A and B".
 
 
PUBLIC clause_vs_head_tail_pred_arity( Clause?, H?, T?, F?, A? ):
"Clause has head H with functor F and arity A, and tail T".
 
If Clause is instantiated, and is not of the form _:-_, then T is
unified with 'true', and H with Clause.
Going in the reverse direction, if T is 'true', Clause is unified with H
and not with H:-true.
 
 
PUBLIC clause_vs_head_tail( Clause?, H?, T? ):
"Clause has head H and tail T".
 
 
PUBLIC clause_vs_pred_arity( Clause?, P?, A? ):
"Clause's head has predicate P and arity A".
 
 
PUBLIC conj_vs_list( Goals?, List? ):
"The list of goals corresponding to Goals is List".

E.g.
    conj_vs_list( (a,b,c), L )  -  L = [a,b,c]
    conj_vs_list( G, [a,b,c] )  -  G = (a,b,c)

If a goal is 'true', it will be omitted from the list:
    conj_vs_list( (true,a,b,true,c,true), L )  -  L = [a,b,c]


PUBLIC round_term_vs_list( Term?, List?, Op+, Ident+ ):

This does the same as conj_vs_list, but can accept operators other
than comma.
E.g.
    round_term_vs_list( (a+b+c), L, +, '' ).
    - gives L = [a,b,c]
    round_term_vs_list( G, [a,b,c], +, '' ).
    - gives G = a+(b+c)

If one of the subterms of Term is Ident, it will be omitted from the
list. This is a generalisation of what conj_vs_list does with 'true'.
Thus:
    round_term_vs_list( (0+a+b+0+c+0), L, +, 0 ).
    - gives L = [a,b,c]


PUBLIC abolish( P+, A+ ):
"There are no clauses for P/A".

Removes all clauses with head predicate P, arity A.
 
 
PUBLIC is_system_pred( P+, A+ ):
True if P/A is a system predicate.
 
 
PUBLIC is_system_goal( G+ ):
True if G calls a system predicate.
 
 
PUBLIC get_prompt( P? ):
Unifies the current prompt used when reading characters or terms
interactively to P (as an atom).
 
 
PUBLIC set_prompt( P+ ):
Sets the current prompt used when reading characters or terms
interactively to P (as an atom).
 
 
PUBLIC add_portray( P+ ):
"The clause
    portray(X) :- P(X)
has been asserted".
 
If there is no such clause, assert one.
 
 
PUBLIC del_portray( P+ ):
"The clause
    portray(X) :- P(X)
has been deleted".
 
If there is such a clause, delete it.
*/
 
 
/*
IMPLEMENTATION
--------------
 
'real' is missing from Poplog Prolog. It can be implemented easily by
calling the built-in routine dataword which tells us what type its
argument is. If it's real, dataword will return either 'decimal' or
'ddecimal' (the latter for double-precision reals. If your system lacks
such a predicate, but has real numbers, then you can probably do
    real(X) :- atomic(X), not( integer(X) ), not( atom(X) ).
 
The prompt predicates reset or examine the Poplog system variable
prolog_read_prompt which contains the current prompt. If you can't
change your read prompt (perhaps by calling a foreign routine and
overwriting it), you'll just have to alter the scripts to fit what your
system imposes.
 
'is_system_pred' calls the Poplog predicate 'prolog_system_predicate'.
If you don't have such a predicate, you could make a look-up table of
all your system predicates (with arities) and check against that.
 
The definition of 'abolish' is commented out because my system has it.
 
'add/del_portray' call add/del_linking_clause from LIB.PL.
 
Making ^ do exponentiation relies on the fact that in Poplog, the right
hand side of "is" can evaluate any functor that's a Pop-11 function
name. So all we need do is, in USEFUL.P, to make ^ a function with the
same effect as **. ^ is already defined as an operator of the correct
fix and precedence. Note that exponentiation is referred to in the
lesson on arithmetic; if you don't have ^ as exponentiation, and can't
make it, you'll need to change the script. The same goes for "mod"
incidentally.
*/
 
 
:- needs    add_linking_clause / 3,
            bug / 2,
            del_linking_clause / 3.
 
 
/*  USEFUL.P is needed for the prompt.  */
:- pop_compile( 'useful.p' ).
 
 
real(R) :-
    prolog_eval( dataword(quote(R)), D ),
    ( D = decimal ; D = ddecimal ), !.
 
 
numeric(N) :- integer(N), !.
numeric(N) :- real(N).
 
 
max( A, B, C ) :- A >= B, !, C=A.
max( A, B, B ).
 
min( A, B, C ) :- A >= B, !, C=B.
min( A, B, A ).
 
 
/*
abolish( P, A ) :-
    functor( Head, P, A ),
    retractall( Head ).
*/
 
 
clause_vs_head_tail_pred_arity( H, H, true, F, A ) :-
    H \= ( _ :- _ ),
    !,
    functor( H, F, A ).
 
clause_vs_head_tail_pred_arity( (H:-T), H, T, F, A ) :-
    functor( H, F, A ).
 
 
clause_vs_head_tail( Clause, H, T ) :-
    clause_vs_head_tail_pred_arity( Clause, H, T, _, _ ).
 

clause_vs_pred_arity( Clause, P, A ) :-
    clause_vs_head_tail_pred_arity( Clause, _, _, P, A ).


conj_vs_list( C, L ) :-
    round_term_vs_list( C, L, ',', true ).


round_term_vs_list( C, L, Op, Ident ) :-
    round_term_vs_list( C, [], L, Op, Ident ).


round_term_vs_list( G, L0, [G|L0], Op, Ident ) :-
    functor( Form, Op, 2 ),
    G \= Form,
    G \= Ident,
    !.

round_term_vs_list( Ident, L, L, _, Ident ) :- !.

round_term_vs_list( Term, L0, L, Op, Ident ) :-
    functor( Form, Op, 2 ),
    arg( 1, Form, A ),
    arg( 2, Form, B ),
    Term = Form,
    round_term_vs_list( A, L1, L, Op, Ident ),
    round_term_vs_list( B, L0, L1, Op, Ident ).


is_system_pred( P, A ) :-
    prolog_system_predicate( P, A ).

 
is_system_goal( G ) :-
    functor( G, P, A ),
    is_system_pred( P, A ).
 
 
get_prompt( P ) :-
    prolog_eval( apply(valof(get_prompt)), P ).
 
 
set_prompt( P ) :-
    not( atom(P) ),
    bug( 'set_prompt: not an atom', P ).
 
set_prompt( P ) :-
    prolog_eval( set_prompt(P) ).
 
 
add_portray(P) :-
    add_linking_clause( portray, P, 1 ).
 
 
del_portray(P) :-
    del_linking_clause( portray, P, 1 ).
 
 
:- endmodule.
h element of the queue is not a point, but a point and
        a partial path.       
*/
define inq( here, q );
    lvars here, q;
    lvars p;
    for p in q do
        ifutils.p                                                                                             100705  017064  000205  00000014412 05427665721 006706  0                                                                                                     47426                                                                                    1  0                                                                                                                                                                 /*  UTILS.P  */


section $-utils => vedbounds
                   getvedargs
                   first_non_space_pos
                   last_non_space_pos
                   starts_with
                   vedformat_print
                   vedpause
                   distance
                   pr_property
                   wait
                   expand
                   trunc;


/*
SPECIFICATION
-------------

This file defines some miscellaneous library routines.


PUBLIC vedbounds():

This is to be called when a file is being edited. It finds the first and
last non-blank line, and the leftmost and rightmost occupied column.
These values are returned, in the order
    x_min, x_max, line_min, line_max.


PUBLIC getvedargs( lengths ):

This helps write Ved commands with varying numbers of arguments.

lengths must be a list of integers.

getvedargs truncs vedargument into successive items delimited by commas
or spaces, and gives an error if the number of items is not a member of
lengths.

It returns the number of items, and the items as a list, in the order
    number list.


PUBLIC vedformat_print( format, args, y ):

Used for formatted output to a Ved buffer. Jumps to ved position (1,y),
clears the line, and then calls format_print(format,args), writing the
result to the line.


PUBLIC vedpause( thing ):

This is useful for writing diagnostics from inside Ved. It prints
'thing' on the status line, and then waits for you to hit any key before
continuing.


PUBLIC first_non_space_pos( s ):

Returns the position of the first non-space in s. Undefined if s is
entirely spaces, or empty.


PUBLIC last_non_space_pos( s ):

Returns the position of the last non-space in s. Undefined if s is
entirely spaces, or empty.


PUBLIC starts_with( s, c ):

True if the first non-space in string s is character c.


PUBLIC distance( x1, x2, y1, y2 ):

Returns the Euclidean distance between (x1,y1) and (x2,y2).


PUBLIC pr_property( property ):

Prints the property, one pair per line. Intended for debugging.


PUBLIC wait( n ):

Waits for approximately n seconds.


PUBLIC expand( lv, n ):

lv is either a list or a vector. This procedure returns a list or vector
padded to length n, whose first length(lv) elements are the same as
lv's, and whose remaining ones are undef.


PUBLIC trunc( s, n ):

s is any object. trunc converts it to a string and then returns that,
truncated on the right so that it is no more than n characters wide.
*/


/*
IMPLEMENTATION
--------------

I suspect that I pinched at least part of getvedargs from some system
library, but I can't remember which. It uses sysparse_string to trunc up
vedargument and extract the items, after replacing commas by spaces.
*/


/*
Distance
--------
*/


define global distance( x1, y1, x2, y2 );
    lvars x1, y1, x2, y2;
    sqrt( (x1-x2)**2 + (y1-y2)**2 )
enddefine;


/*
Strings.
--------
*/


define global first_non_space_pos( s );
    lvars s;
    skipchar( ` `, 1, s )
enddefine;


define global last_non_space_pos( s );
    lvars s;
    lvars i;
    for i from datalength(s) by -1 to 1 do
        if i /= ` ` then return(i) endif
    endfor;
enddefine;


define global starts_with(s,c);
    lvars s, c;
    lvars m;
    ( locchar( c, 1, s ) ->> m ) /= false and skipchar( ` `, 1, s ) = m
enddefine;


define global trunc( s, n );
    lvars s, n;
    lvars i;
    '' >< s -> s;
    for i to min(n,s.datalength) do
        s(i)
    endfor;
    consstring(min(n,s.datalength))
enddefine;


/*
Ved things.
-----------
*/


define global vedbounds();
    lvars i, x_min, x_max, line_min, line_max;

    /*  Find first non-blank line.  */
    1 -> i;
    while ( vedjumpto(i,1); vedtrimline(); vvedlinesize = 0 ) do
        1 + i -> i;
    endwhile;
    i -> line_min;

    /*  Find last non-blank line.  */
    vvedbuffersize -> i;
    while ( vedjumpto(i,1); vedtrimline(); vvedlinesize = 0 ) do
        i - 1 -> i;
    endwhile;
    i -> line_max;

    /*  Find first and last column.  */
    999 -> x_min;
    1 -> x_max;
    for i from line_min to line_max do
        vedjumpto(i,1);
        vedtrimline();
        if vedthisline() /= '' then
            min( x_min, first_non_space_pos(vedthisline()) ) -> x_min;
            max( x_max, last_non_space_pos(vedthisline()) ) -> x_max;
        endif;
    endfor;

    x_min; x_max; line_min; line_max;
enddefine;


define global getvedargs( nlist ) -> args -> len;
    lvars m, args, len, nlist;

    ;;; Replace commas with spaces
    while strmember(`,`,vedargument)->> m do
        `\s` -> fast_subscrs(m,vedargument);
    endwhile;

    listlength(sysparse_string(vedargument) ->> args) -> len;

    unless member(len,nlist) then
        vederror('ONE OF '><nlist><' ARGUMENTS NEEDED');
    endunless

enddefine;


define global vedformat_print( format, args, y );
    lvars format, args, y;
    lvars saved_cucharout;
    cucharout -> saved_cucharout;
    vedcharinsert -> cucharout;
    vedjumpto( y, 1 );
    vedcleartail();
    format_print( format, args );
    saved_cucharout -> cucharout;
enddefine;


define global vedpause( thing );
    lvars thing;
    vedputmessage( thing><'' );
    rawcharin().erase;
enddefine;


/*
Printing properties
-------------------
*/


define global pr_property( p );
    lvars p;
    appproperty( p, procedure(key,value);
                        lvars key, value;
                        printf( 'key: %p  value: %p\n', [% key, value %] )
                    endprocedure
               );
enddefine;


/*
Wait
----
*/


define global wait( secs );
    lvars secs;
    lvars done=false;

    syssettimer( intof(secs*100), procedure(); true->done; endprocedure );
    until done do ; enduntil;
enddefine;


/*
Expanding lists
---------------
*/


define global expand( l, n );
    lvars l, n;
    if n > length(l) then
        if islist(l) then
            [ ^^l ^^([%repeat n-length(l) times undef endrepeat %]) ]
        else
            l <> initv(n-length(l))
        endif
    else
        l
    endif;
enddefine;



endsection;
/*
IMPLEMENTATION
--------------
 
'real' is missing from Poplog Prolog. It can be implemented easily by
calling the built-in rouvec.p                                                                                               100705  017064  000205  00000010612 05427665722 006322  0                                                                                                     47426                                                                                    1  0                                                                                                                                                                 /*  VEC.P  */


section $-vec => consvec vec_x vec_y
                 vec_sub --
                 vec_add ++
                 vec_smult ***
                 turn2 turn3;


/*
SPECIFICATION
-------------

This module exports some routines for handling vectors.


PUBLIC consvec( x, y ):

Builds the vector (x,y).


PUBLIC vec_x( v ):
PUBLIC vec_y( v ):

Return v's x and y components.


PUBLIC vec_add( v1, v2 ):
PUBLIC vec_sub( v1, v2 ):
PUBLIC 5 v1 ++ v2:
PUBLIC 5 v1 -- v2:

Return vectors corresponding to v1+v2 and v1-v2. You can also use the
infix operators ++ and -- as synonyms.


PUBLIC vec_smult( s, v ):
PUBLIC 4 s *** v:

Returns the vector sv, where s is a scalar.


PUBLIC turn2( v1, v2 ):

Indicates how v1 must be rotated to get v2. It returns a word
which is
    "forward" if v1 and v2 are colinear and point in the same
        direction;
    "back" if colinear and in opposite directions;
    "right" if v2 is the result of rotating v1 to the right;
    "left" if v2 is the result of rotating v1 to the left.

This routine is useful when calculating how a bug must turn, given
an existing bearing (forwardvector) v1 and a new one v2.


PUBLIC turn3( p0, p1, p2 ):

This is equivalent to
    turn2( p1--p0, p2--p1 )

This routine is useful when calculating how a bug must turn, given
three successive points p0, p1, p2 on its path.
*/


/*
IMPLEMENTATION
--------------

I have implemented vectors as lists so that they can be passed to
Prolog. Many bug-writers will use that, and I didn't want to proliferate
representations. However, having explicit constructors and selectors
makes it clearer that these lists are in fact vectors.

This library comes with the file HELP VEC. Please keep the two in step.
HELP PATH_TO_MOVES also refers to vectors.

What's the overhead of returning intermediate results, e.g. in
v1++v2--v3? Is there an efficient way to avoid this while keeping to the
same syntax? Also, can it be arranged for + and - and other familiar
operators to work on vectors as well. Also also, is there an efficient,
public-domain, library of vector and matrix operations? Answer if you
can.
*/


global vars consvec = (cons <> cons)(% [] %);
/*  Nifty functional, but obscure, way of building a constructor
    for [%x,y%].
*/

global vars vec_x = hd;

global vars vec_y = (tl<>hd);


define global 5 V1 -- V2;
    consvec( V1.vec_x-V2.vec_x, V1.vec_y-V2.vec_y );
enddefine;

global vars procedure vec_sub = (nonop --);


define global 5 V1 ++ V2;
    consvec( V1.vec_x+V2.vec_x, V1.vec_y+V2.vec_y );
enddefine;

global vars procedure vec_add = (nonop ++);


define global 4 S *** V;
    consvec( S*V.vec_x, S*V.vec_y );
enddefine;

global vars procedure vec_smult = (nonop ***);


/*  cross( V1, V2 ):
        Gives the length of the "cross-product" of 2-D vectors.

        Useful properties of cross are:
            A x A = 0;
            A x nA = 0;
            A x nB = nA x B;
            A x B > 0 if B is the result of rotating A left,
                with an angle >= 0 and <= 180;
            A x B < 0 if B is the result of rotating A right,
                with an angle >= 0 and <= 180.
        The last two are why we use it for calculating bug paths.
*/
define cross( V1, V2 );
    V1.vec_x*V2.vec_y - V2.vec_x*V1.vec_y;
enddefine;


vars turn2, turn_1;  /*forward*/


define global turn3( P0, P1, P2 );
    turn2( vec_sub( P1, P0 ), vec_sub( P2, P1 ) );
enddefine;


define global turn2( A, B );
    turn_1( cross(A,B), A, B );
enddefine;


/*  turn_1( AxB, A, B ):
        AxB is cross(A,B).
        'turn_1' returns:
            "forward" if A and B are colinear and point in the same
                direction;
            "back" if colinear and in opposite directions;
            "right" if B is the result of rotating A to the right;
            "left" if B is the result of rotating A to the left.
*/
define turn_1( AxB, A, B );
    lvars AxB, A, B;

    if AxB = 0 and
       sign(A.vec_x) = sign(B.vec_x) and
       sign(A.vec_y) = sign(B.vec_y) then
        "forward"
        /*  We needed a test on both components because one might be
            zero.
        */
    elseif AxB = 0 then
        "back"
    elseif AxB < 0 then
        "right"
    else
        "left"
    endif;
enddefine;


endsection;
    x_min, x_max, line_min, line_max.


PUBLIC getvedargs( lengths ):

This helps write Ved commands with varying numbers of arguments.

lengths must be a list of integers.

getvedargs truncs vedargument into successive items delimited by commas
or spaces, and gives an error if the number of items is not a member of
lengths.

It returns the numbvedinit.p                                                                                           100705  017064  000205  00000003074 05427665722 007213  0                                                                                                     47426                                                                                    1  0                                                                                                                                                                 ;;; '400' -> vedargument; ved_autowrite();


section print => vedprint;


define vedprint( pre, post );
    lvars pre post;
    vars vedcurrent vedwriteable _x;

    if vedchanged then
        if vedwriteable then ved_w1();
        else
            'printtmp.lis' -> vedcurrent;
            true -> vedwriteable;
            ved_w1(); true -> vedchanged;
            vedputmessage('TEMPORARY FILE WRITTEN');
        endif
    endif;
    ;;; Check if there's a dot in file name.
    ;;; If not stupid VMS tries to stick '.LIS' on end.
    locchar(`]`,1,vedcurrent) -> _x;
    locchar(`.`, if _x then _x else 1 endif, vedcurrent) -> _x;
     ;;; put a dot on end of file name if necessary
     unless _x then vedcurrent >< '.' -> vedcurrent endunless;
    pr('GIVING PRINT COMMAND');

    sysobey( pre >< vedcurrent >< post );
enddefine;


endsection;


;;; Print current file at CTC.
;;;
define ved_ctcprint;
    vedprint( 'LF ', ' /PRINTER=CTC' );
enddefine;


;;; Print current file at Social Studies.
;;;
define ved_ssprint;
    vedprint( 'LF ', ' /PRINTER=SOCSTUD' );
enddefine;


;;; Print current file at Experimental Psychology.
;;;
define ved_epprint;
    vedprint( 'LF ', ' /PRINTER=PSYZOO' );
enddefine;


;;;  Access VAX logical name to find out how called,
;;;  for Ved setup.
systranslate('pop_on_pc') -> pop_on_pc;
if pop_on_pc = 1 then
    compile( 'fs21:[aisoc.sysfiles]vedpcinit1.p' );
elseif pop_on_pc = 2 then
    compile( 'fs21:[aisoc.sysfiles]vedpcinit2.p' );
endif;
cancel pop_on_pc;
for i from datalength(s) by -1 vedreadlinechars.p                                                                                  100705  017064  000205  00000005612 05427665723 011055  0                                                                                                     47426                                                                                    1  0                                                                                                                                                                 /*  VEDREADLINECHARS.P  */


section $-vedreadlinechars => vedreadlinechars;


/*
SPECIFICATION
-------------

This module exports a routine for reading a line from inside Ved, as
a list of characters.

PUBLIC vedreadlinechars( message, prompt ):

This procedure behaves like vedreadline (see HELP vedreadline), but
returns a list of characters. It should only be called when editing a
file. It does a vedputmessage(message), displaying it on the status
line, then jumps to the current Ved line, and inserts 'prompt'. It then
allows the user to edit that line, returning when he types RETURN or
ENTER. The result is returned as a list of characters, omitting leading
spaces and trailing spaces and newlines.
*/


/*
IMPLEMENTATION
--------------

I adapted this from lib vedreadline. It's a shame that the Pop
implementors have chosen to hide the source of readline, because that is
apparently better. Not helpful.
*/


define global vedreadlinechars( message, prompt );
    lvars message, prompt;
    vars vedbreak = false;
    lvars char proc plen, done = false;

    vedputmessage(message);

start:
    datalength(prompt) fi_+ 1 -> plen;
    vedinsertstring(prompt);
    vedcleartail();
    vedscreenbell();

    until done do
        max(plen, vedcolumn) -> vedcolumn;
        vedcheck();
        vedcursorset() ->;
        vedinascii() -> char;
        if char == `\r` or char == `\^D` then
            true -> done
        elseif (vedgetproctable(char) ->> proc) == vedinsertvedchar
                or proc == vedcharmiddle or proc == vedtextright
                or proc == vedrefresh
        then proc()
        elseif (proc == vedchardelete or proc == vedwordleft
                    or proc == vedcharleft or proc == vedwordleftdelete)
                and vedcolumn fi_> plen
        then
            proc()
        elseif (proc == vedcharright or proc == vedwordright
                    or proc == veddotdelete or proc == vedwordrightdelete
                    or proc == vedcleartail or proc == vedchangecase)
                and vedcolumn fi_<= vvedlinesize
        then proc()
        elseif proc == vedenter then true -> done
        elseif proc == vedscreenleft or proc == vedtextleft then
            plen -> vedcolumn;
        elseif proc == vedclearhead then
            vedclearhead(); goto start
        elseif proc == vedlinedelete then
            vedclearhead(); vedcleartail(); goto start
        elseif proc == vedcleartail then
            vedcleartail();
        else vedscreenbell()
        endif;
        vedsetlinesize();
    enduntil;

    ;;; now create the list of text
    vedtrimline();
    copy(vedthisline()) -> proc;
    stringin(proc) -> proc;
    repeat plen fi_- 1 times erase(proc()) endrepeat;
    [% until (proc() ->> char) == termin do char enduntil %];
enddefine;


endsection;
                                                                                 1  0                                                                                                                                                                 wander.pl                                                                                           100705  017064  000205  00000000322 05427665726 007202  0                                                                                                     47426                                                                                    1  0                                                                                                                                                                 wander :-
    random_element( [[[left]],[[forward],[forward],[forward],[forward]]], E ),
    exec_list( E ).


exec_list( [] ) :- !.

exec_list( [A1|An] ) :-
    exec( A1 ),
    exec_list( An ).
icates how v1 must be rotated to get v2. It returns a word
which is
    "forward" if v1 and v2 are colinear and point in the same
        direction;
    "back" if colinear and in opposite directions;
    "right" if v2 is the result of rotating v1 to the right;
    "left" if v2 is the result of rotating v1 to the lefworlds.p                                                                                            100705  017064  000205  00000124104 05427665732 007062  0                                                                                                     47426                                                                                    1  0                                                                                                                                                                 /*  WORLDS.P  */


section $-worlds =>
         bw_reset
         define_object
         trace_objects
         untrace_objects
         bw_object_name
         bw_objects_file
         bw_new_object
         bw_place_object
         bw_move_object
         bw_destroy_object
         bw_set_display_routines
         bw_new_bug
         bw_initialise_bug
         bw_set_retina_size
         bw_resume_bug
         exec
         bw_select_bug
         bw_current_bug
         bw_act
         bw_left
         bw_right
         bw_forward
         bw_back
         bw_move_bug_to
         bw_grab
         bw_drop
         bw_update_vision
         bw_say
         bw_user_say
         bw_clear_sentences
         bw_heard_from
         bw_heard_by_user_from
         bw_bug_xW
         bw_bug_yW
         bw_forwardvector
         bw_rightvector
         bw_direction
         bw_retina
         bw_display_retina
         bw_retina_to_list
         bw_bearing
         bw_xV, bw_yV
         bw_inventory
         bw_rel_forward
         bw_rel_right
         bw_kill_bug
         bw_bug_is_dead
         bw_world_width
         bw_world_height
         ved_world
         ved_saveworld
         textfile_to_world
         textfile_to_worldfile
         worldfile_to_world
         define_action;


/*
SPECIFICATION
-------------

This module defines the lowest level of the world/bug simulation used by
Eden.

For a detailed description of Eden, see HELP EDEN. The idea is that the
world is a two-dimensional grid of squares. One or more squares contain
bugs. Each square can contain in addition either an object (symbolised
by a non-blank character) or no object (symbolised by ` `). You can't
have more than one non-bug object in a square.

A world is implemented as a record datatype. However, you can treat it as
a 2-D array, and subscript it to examine or change objects:
    w( 3, 4 ) =>
    `+` -> w( 4, 5 );
You can also find out its width and height. Subscripting does not tell
you about the bugs. For this, you have various other routines.

A world's class_print is set to a line-by-line display routine, so the
print-arrow will automatically print the contents:
    w =>

The bugs have a position defined by x and y co-ordinates. They also have
a direction ("north", "east", "south", or "west"). Both these can be
interrogated by appropriate access routines. For convenience in
transforming from bug- to world-relative coordinates, you can also get
the value of the unit vectors defining a bug's current coordinate system
(its righvector and forwardvector).

The world's coordinate system is defined as you would expect. Y points
upwards ("north"); X points to the right ("east"). The world's origin is
(0,0): any attempt to access squares with negative coordinates will
cause an error, as will accessing beyond the width and height.

A world is usually created by drawing it in Ved. This module contains
routines for doing that, and also for saving worlds to file, and
restoring them from file.

A world can be updated by various routines, which the Eden simulator
uses when running. However, it always contains its initial state, and
can be reset to this at any time.

This initial state defines:
    the bugs' initial positions;
    their initial directions;
    their initial energies;
    the initial contents of the world, i.e. the object in each square.

How objects behave when a bug interacts with them is determined by their
definition file - essentially, this maps the character defining the
object to a function (Bug action -> behaviour). The current module does
not deal with this level of behaviour. Instead, it deals with the world
underlying it, by exporting routines such as bw_drop() - make the bug drop
what it's holding - and bw_left() - make it turn left.

Note that the routine bw_left (for example) _actually_ turns the
Bug left, even if the object in its square would not permit this. It is
the job of the person writing Eden to ensure that the routines exported
from this one are called correctly when implementing objects.

This module also defines routines for updating a bug's perceptions so as
to match the new state of the world. For efficiency, this updating is
not automatically done when the state changes.


PUBLIC world(xW,yW): (subscripting)

Subscripting a world yields a character, denoting the object at that
square. If the square is empty, the result is ` `. Subscripting a bug's
current square does not yield a `B`, but whatever object is in the
square with the bug (` ` if none). Undefined if location (xW,yW) is out
of range.


PUBLIC bw_reset( world ):

This resets world and bugs to their initial state.


PUBLIC bw_select_bug( world, n ):

This ``selects'' bug number n. All bug-specific routines will affect or
interrogate this bug until another one is selected.


PUBLIC current_bug():

Returns the number of the bug currently selected.


PUBLIC bw_left( world ):
PUBLIC bw_right( world ):

Causes the currently selected bug to turn left or right.


PUBLIC bw_move_bug_to( world, xW, yW ):

Moves the currently selected bug to (xW,yW). Undefined if (xW,yW) is
out of range.


PUBLIC bw_grab( world ):
PUBLIC bw_drop( world ):

Causes the currently selected bug to grab the object in its square, or
drop the object it's holding. Undefined if (for grab) no object is
there; or (for drop) the bug is not holding an object.


PUBLIC bw_new_bug( world, id, p ):

Creates a new bug with id, and sets its brain to be a process made from
procedure p. Leaves this bug selected in world.


PUBLIC bw_resume_bug( world ):

Causes the currently selected bug to "think" by invoking its brain.
This runs the bug until it obeys a call of -exec-, whose argument
will be returned as the result.


PUBLIC bw_update_vision():

Updates the retina of the currently selected bug so as to be consistent
with its current surroundings.


PUBLIC bw_user_say( world, other, list ):

Called by the user to "say" a sentence to -other-.


PUBLIC bw_say( world, other, list ):

This is called by the currently selected bug to "say" a sentence to
-other-. -other- can be "user" or a bug id.


PUBLIC bw_heard_from( world, other ):

The last thing the currently selected bug has "heard" from -other-.


PUBLIC bw_heard_by_user_from( world, other ):

The last thing the user has "heard" from -other-.


PUBLIC bw_bug_xW( world ):
PUBLIC bw_bug_yW( world ):

Return the x and y world-coordinates of the currently selected bug.


PUBLIC bw_forwardvector( world ):
PUBLIC bw_rightvector( world ):

Return the forward- or right-vector of the currently selected bug.


PUBLIC bw_direction( world ):

Returns the direction in which the currently selected bug is facing, as
one of "north", "east", "south", "west".


PUBLIC bw_retina( world ):

Returns the retinal array of the currently selected bug. Note: this is
not a copy, but the data structure itself, so you can update it. This is
not recommended, and I may prohibit you from doing so in later versions
of this software. Also, note that this assumes that only one bug is
present. There is as yet no way for one bug to perceive another.


PUBLIC bw_display_retina( world ):

Displays the retina of the currently selected bug, line by line, tty
mode. The bug is shown as a B, obscuring any object thereunder. As
above, this routine only works for worlds with one bug.


PUBLIC bw_retina_to_list( world, f ):

Returns a list corresponding to the retina of the currently selected
bug. f must be a procedure of three arguments:
    f( xB, yB, object ).

The list is formed by iterating through the bug's retina, visiting every
point once (order undefined). For every point where there is an object
(i.e. every point where the world is not ` `), f is called, and its
result is inserted into the list.

xB and yB are the position of the point in the retina, relative to the
bug. If the point's position relative to retinal origin=(1,1) is (i,j),
then xB=i-xV, and yB=j-yV, where the bug occupies location (xV,yV) in
its retina.

object is the object.

For the point (xB=0,yB=0), i.e. that on which the bug is standing, object
is the object (if any) under the bug, not the bug itself.


PUBLIC bw_xV( world ):
PUBLIC bw_yV( world ):

The position of the currently selected bug within its visual array. The
left-hand bottom corner of this array is (1,1). Note: this position is
set when the bug is created, and does not change as it moves.


PUBLIC bw_inventory( world ):

The inventory of the currently selected bug, i.e. the object it is
holding. ` ` if not holding anything.


PUBLIC bw_rel_forward( world, xW, yW, rel ):
PUBLIC bw_rel_right( world, xW, yW, rel ):

The result of moving rel units along the currently selected bug's
forward- or right-vector from (xW,yW) in world. In both cases, the
result is two values on the stack: (x coordinate); (y coordinate).


PUBLIC bw_world_width( world ):
PUBLIC bw_world_height( world ):

The width and height of world. Since the world's origin is (0,0),
its highest x and y coordinates are width-1 and height-1.


PUBLIC ved_world():

Defines the Ved command 'world', which copies the contents of the
current buffer into a world.

The command can have the following forms
    world
    world name

These create a new world and assign it to valof(name). If name is
omitted, it defaults to "world".

Your buffer should start with a header, which is a sequence of blank
and/or comment lines. Comments start with a !. It's a good idea to have
one comment which specifies the world's name.

Following the header, you need a line (uncommented) specifying the
objects, initial energy, and initial direction. This has the form
    F E D
where F is the name of a Pop-11 source file (without the .P extension),
E is the energy as an integer, and D is one of north, east, west or
south. 'saveworld' will assume the first line that isn't blank or a
comment to be this specification, and report an error if it has the
wrong format. F should name a file containing object definitions.

Everything following this line is taken to be the world. 'world'
automatically works out its height and width by looking for the leftmost
and rightmost occupied columns and the end of the buffer. See HELP EDEN
for more details.

The world is created with its initial state given by the buffer
contents, and reset to that state.


PUBLIC ved_saveworld():

Defines the Ved command 'saveworld' which saves the current buffer as a
world file in a form readable by worldfile_to_world. The command has the
forms
    saveworld
    saveworld filename
and writes into filename. If filename doesn't have an extension, .W is
added. If filename is omitted, the name of the file being edited is
used, with an extension of .W added. The buffer must be in the same form
as for the 'world' command.


PUBLIC worldfile_to_world( filename ):

Loads a world from filename (no defaults) and returns it.


PUBLIC textfile_to_world( textfile ):

This converts a textfile into a world. The file must have the same format
as for the Ved 'world' command.


PUBLIC textfile_to_worldfile( textfile, worldfile ):

As for 'textfile_to_world', but saves the world into worldfile. The
worldfile extension defaults to .W.
*/


/*
IMPLEMENTATION
--------------

See the individual sections below.
*/


needs fault;
needs vec;
needs retina;
needs utils;
needs add_file_defaults;
needs smatch;


/*
World primitive operations.
---------------------------


Records.
--------

We define two records, one for a world, and one for its bug.

In the first version, I stored the bug's coordinates in the world one
rather than the bug one. Though I don't think this is what most people
would do, it seemed better model to me: after all, the bug might in some
circumstances find itself placed in a space of some other number of
dimensions. The number of coordinates would then change, so it can't be
an intrinsic property of the bug. However, this is inconvenient for
multiple bugs, so I now store coordinates in the bug records. But I
still think this is the wrong approach. Comments?

In the present implementation, the size of the bug's retina and its
position therein are fixed. You can change them by altering the call
to new_bug from new_world.

Note that we define the class_apply of a world to be a procedure which
accesses the elements of its character array. See REF KEYS.

Note that the world_contents only contains the background, not the bug.
I.e. there is no letter B in it. We use the bug_xW,yW fields to give its
location.


Portability
-----------

The check in the subscripting updater for worlds assumes that characters
are represented in ASCII, when checking that object symbols are in range.
*/


/*
Primitives
----------
*/


recordclass world
    world_user_heards,
    ;;; Replies directed from bugs to user.

    world_buglist,
    ;;; List of bug data created when saving world.

    world_objects,
    ;;; Object procedures.

    world_objects_file,
    ;;; Object file.

    world_ved_move_bug_to,
    world_ved_place_object_at,
    ;;; Display routines.

    world_width,
    ;;; Wdith.

    world_height,
    ;;; Height.

    world_contents,
    ;;; Contents, is changed as the simulation runs.

    world_initial_chars,
    ;;; Initial contents.

    world_retina_width,
    world_retina_height,
    world_xV,
    world_yV
    ;;; Retina size and position

    world_bugs,
    ;;; Array of bugs.

    world_max_bugs,
    ;;; This array runs from 1..max_bugs.

    world_selected_bug;
    ;;; Number of current bug, between 1..max_bugs.


recordclass bug
    bug_retina_width,
    ;;; Width of retina, whose X index runs from 1..width.

    bug_retina_height,
    ;;; Height, whose Y index runs from 1..height.

    bug_xV, bug_yV,
    ;;; Position of bug in its retina. Is constant over any one bug.

    bug_retina,
    ;;; The retina, datatype 'retina' - see HELP RETINA. Is updated
    ;;; by bw_update_vision().

    bug_heards,
    ;;; The sentences heard. A list of the form
    ;;;     [ from_id list from_id list ... ]

    bug_inventory,
    ;;; The inventory, as a character.

    bug_brain,
    bug_process,
    ;;; The ``think'' procedure, and the process made therefrom.

    bug_is_dead
    ;;; True if it is.

    bug_xW,
    bug_yW,
    ;;; The bug's coordinates.

    bug_direction_,
    ;;; The bug's direction, one of "east", "north", "west", "south".
    ;;; Use bug_direction() as the access routine: this updates the
    ;;; direction vectors as well.

    bug_forwardvector,
    ;;; Unit vector along bug's Y axis.

    bug_rightvector,
    ;;; Unit vector along bug's X axis.

    bug_initial_xW,
    bug_initial_yW,
    bug_initial_direction;
    ;;; Initial direction and location.


/*
Actions
-------
*/


vars actions;
[] -> actions;


define global define_action( name );
    lvars name;
    if not(member(name,actions)) then
        name :: actions -> actions;
    endif;
enddefine;


/*
Objects
-------
*/


vars char_to_name, char_to_proc,
     id_to_char;


vars tracing_objects = false;


define global trace_objects();
    true -> tracing_objects;
enddefine;


define global untrace_objects();
    false -> tracing_objects;
enddefine;


define global define_object();
    lvars name, proc, char, attrs;
    lvars attr;

    if ().dup.islist then
        () -> attrs; () -> char; () -> proc; () -> name
    else
        [] -> attrs; () -> char; () -> proc; () -> name
    endif;

    procedure (action,id,xW,yW,proc,name,char);
        lvars proc, name, char, id, xW, yW;
        if tracing_objects then
            printf('About to call object %p (%p) with action=%p, id=%p, (xW,yW)=(%p,%p)\n',
                   [%name,char,action,id,xW,yW%]
                  )
        endif;
        proc(action,id,xW,yW);
        if tracing_objects then
            printf('Returned from object %p\n', [%name%] );
        endif;
    endprocedure(%proc,name,char%) -> proc;

    if char_to_proc.isundef then
        newproperty( [], 30, undef, true ) -> char_to_proc;
        newproperty( [], 30, undef, true ) -> char_to_name;
    endif;
    proc -> char_to_proc(char);
    name -> char_to_name(char);
    for attr in attrs do
        newproperty( [], 10, undef, true ) -> valof(attr);
    endfor;
enddefine;


define global bw_act( world, action );
    lvars world, action;
    lvars xW=bw_bug_xW(world), yW=bw_bug_yW(world);
    lvars id;

    if action = [forward] then
        bw_rel_forward(world,xW,yW,1) -> yW -> xW;
        (world.world_contents)(xW,yW) -> id;
    elseif action = [back] then
        bw_rel_forward(world,xW,yW,-1) -> yW -> xW;
        (world.world_contents)(xW,yW) -> id;
    elseif action = [drop] then
        world.current_bug.bug_inventory -> id;
    elseif action = [use] then
        if bw_inventory(world) = ` ` then
            (world.world_contents)(xW,yW) -> id;
        else
            world.current_bug.bug_inventory -> id;
        endif
    else
        (world.world_contents)(xW,yW) -> id;
    endif;
    message( action, id, xW, yW )
enddefine;


define message( action, id, xW, yW );
    lvars action, id, xW, yW;
    id_to_proc(id)(action,id,xW,yW);
enddefine;


define id_to_proc(id);
    lvars id;
    char_to_proc(id_to_char(id))
enddefine;


vars instance_count, id_to_char, id_to_location;


define global bw_new_object( world, name_or_char ) -> id;
    lvars world, name_or_char, id;
    lvars char;
    1 + instance_count -> instance_count;
    instance_count -> id;
    if name_or_char.isword then
        name_to_char(name_or_char) -> char;
    else
        name_or_char -> char;
    endif;
    char -> id_to_char(instance_count);

    message( [new], id, undef, undef );
enddefine;


vars display_object_changes;


define global bw_place_object( world, id, loc );
    lvars world, id, loc;
    lvars bug = world.current_bug;

    loc -> id_to_location(id);
    if loc = "inventory" then
        id -> bug.bug_inventory
    else
        id -> (world.world_contents)(loc(1),loc(2));
        unless loc(1) = bug.bug_xW and loc(2) = bug.bug_yW then
            if display_object_changes then
                world_ved_place_object_at( world )( id.id_to_char, loc(1), loc(2) );
            endif;
        endunless;
    endif;
enddefine;


define global bw_move_object( world, id, loc );
    lvars world, id, loc;
    lvars oldloc;
    id_to_location(id) -> oldloc;
    bw_place_object( world, bw_new_object( world, ` ` ), oldloc );
    bw_place_object( world, id, loc );
enddefine;


define global bw_destroy_object( world, id_or_loc );
    lvars world, id_or_loc;
    lvars loc, id;

    if id_or_loc.islist then
        id_or_loc -> loc;
        (world.world_contents)(loc(1),loc(2)) -> id;
    else
        id_to_location(id_or_loc) -> loc;
        id_or_loc -> id;
    endif;

    bw_place_object( world, bw_new_object(world,` `), loc );
    undef ->> id_to_location(id) -> id_to_char(id);
enddefine;


define global bw_objects_file( world );
    lvars world;
    world.world_objects_file;
enddefine;


define global bw_object_name(world,char);
    lvars world, char;
    char_to_name(char);
enddefine;


/*
Basic world access
------------------
*/


vars new_bug;/*forward*/


/*  new_world( width, height ):
        Create a new world running from (0,0) to (width-1,height-1).
        This world has one bug, with retina size and location as
        specified.
*/
define new_world( width, height );
    lvars width, height;
    lvars world;
    consworld( explode(initv(datalength(key_of_dataword("world")))) ) -> world;
    [] -> world_buglist(world);
    width -> world_width(world);
    height -> world_height(world);
    newanyarray( [% 0, width-1, 0, height-1 %], ` `, key_of_dataword("string") ) -> world_initial_chars(world);
    newarray( [% 0, width-1, 0, height-1 %] ) -> world_contents(world);
    [] -> world_bugs(world);
    0 -> world_selected_bug(world);
    0 -> world_max_bugs(world);
    [] -> world_user_heards(world);

    world;
enddefine;


/*  copy_world( w ):
        Make a new world which is a copy of w. We have to take care with
        the character array: if we don't copy each string explicitly,
        we'll end up sharing the original one in w.

        The bugs in this world are the same ones as in w, not copies.
*/
define copy_world( w ) -> the_copy;
    lvars w, the_copy;
    lvars j;
    copy( w ) -> the_copy;
    copy(world_initial_chars(world)) -> world_initial_chars(the_copy);
    copy(world_contents(world)) -> world_contents(the_copy);
enddefine;


/*  World-subscripting.  */
procedure( xW, yW, world );
    lvars xW, yW, world;
    (world.world_contents)( xW, yW ).id_to_char;
endprocedure -> class_apply( key_of_dataword("world") );


vars current_bug;/*forward*/


/*
*/
define global bw_new_bug( world, id, proc );
    lvars world, id, proc;
    lvars bug;

    consbug( explode(initv(datalength(key_of_dataword("bug")))) ) -> bug;

    world.world_retina_width -> bug_retina_width(bug);
    world.world_retina_height -> bug_retina_height(bug);
    world.world_xV -> bug_xV(bug);
    world.world_yV -> bug_yV(bug);
    new_retina(world.world_retina_width,world.world_retina_height) -> bug_retina(bug);
    [] -> bug_heards(bug);
    proc -> bug_brain(bug);
    false -> bug_is_dead(bug);

    if id > world.world_max_bugs then
        expand( world.world_bugs, id ) -> world.world_bugs;
        id -> world.world_max_bugs;
    endif;
    bug -> (world.world_bugs)(id);
    id -> world.world_selected_bug;
enddefine;


define global bw_initialise_bug( world, direction );
    lvars world, direction;
    lvars buginfo, xW, yW, bug = world.current_bug;
    lvars buglist = world.world_buglist, index;

    min( length(buglist), world.bw_current_bug ) -> index;
    buglist(index) -> buginfo;
    buginfo(1) -> xW;
    buginfo(2) -> yW;
    xW -> bug.bug_initial_xW;
    yW -> bug.bug_initial_yW;
    direction -> bug.bug_initial_direction;
enddefine;


define global bw_select_bug( world, n );
    lvars world, n;

    if n < 1 or n > world.world_max_bugs then
        FAULT( 'bw_select_bug: n out of range', [%world,n%] );
    endif;

    n -> world.world_selected_bug;
enddefine;


define global bw_current_bug( world );
    lvars world;
    world.world_selected_bug;
enddefine;


define current_bug( world );
    lvars world;
    (world.world_bugs)( world.world_selected_bug );
enddefine;


define global bw_set_retina_size( world, rw, rh, xV, yV );
    lvars rw, rh, xV, yV;
    rw -> world_retina_width(world);
    rh -> world_retina_height(world);
    xV -> world_xV(world);
    yV -> world_yV(world);
enddefine;


/*
Maintaining direction vectors.
------------------------------

We ensure that the bug_direction field of a bug, if updated,
automatically changes the bug's forward and rightvector. Maintaining
these was Simon's idea; it's a nice trick for converting from bug to
world coordinates.
*/


define bug_direction( bug );
    lvars bug;
    bug.bug_direction_;
enddefine;


define updaterof bug_direction( dir, bug );
    lvars dir, bug;

    dir -> bug.bug_direction_;

    switchon dir
    case = "north" then
        consvec( 0, 1 ) -> bug.bug_forwardvector;
        consvec( 1, 0 ) -> bug.bug_rightvector;
    case = "east" then
        consvec( 1, 0 ) -> bug.bug_forwardvector;
        consvec( 0, -1 ) -> bug.bug_rightvector;
    case = "south" then
        consvec( 0, -1 ) -> bug.bug_forwardvector;
        consvec( -1, 0 ) -> bug.bug_rightvector;
    case = "west" then
        consvec( -1, 0 ) -> bug.bug_forwardvector;
        consvec( 0, 1 ) -> bug.bug_rightvector;
    else
        FAULT( 'bug_direction: bad direction', [%dir, bug%] );
    endswitchon
enddefine;


/*
Resetting the world.
--------------------

We copy the initial state into the working state.
*/


vars message;/*forward*/


define global bw_reset( world );
    lvars world;
    lvars i, j;
    lvars bug, id;

    for i to world.world_max_bugs do
        bw_select_bug( world, i );
        current_bug( world ) -> bug;
        bug.bug_initial_direction -> bug.bug_direction;
        bug.bug_initial_xW -> bug.bug_xW;
        bug.bug_initial_yW -> bug.bug_yW;
        [] -> bug.bug_heards;
        consproc(0,bug.bug_brain) -> bug.bug_process;
    endfor;

    0 -> instance_count;
    newproperty( [], 100, undef, true ) -> id_to_char;
    newproperty( [], 100, undef, true ) -> id_to_location;

    false -> display_object_changes;

    for i from 0 to world.world_width-1 do
        for j from 0 to world.world_height-1 do
            bw_new_object( world, (world.world_initial_chars)(i,j) ) -> id;
            bw_place_object( world, id, [%i,j%] );
        endfor;
    endfor;

    bw_place_object( world, bw_new_object(world,` `), "inventory" );

    [] -> world_user_heards(world);

    true -> display_object_changes;
enddefine;


/*
Display interface
-----------------
*/


define global bw_set_display_routines( world, move_bug, place_object );
    lvars world, move_bug, place_object;
    move_bug -> world.world_ved_move_bug_to;
    place_object -> world.world_ved_place_object_at;
enddefine;


/*
Movement primitives.
--------------------
*/


define global bw_left( world );
    lvars world;
    lvars bug = world.current_bug;
    switchon bug.bug_direction
    case = "north" then "west"
    case = "west"  then "south"
    case = "south" then "east"
    case = "east"  then "north"
    endswitchon -> bug.bug_direction
enddefine;


define global bw_right( world );
    lvars world;
    lvars bug = world.current_bug;
    switchon bug.bug_direction
    case = "north" then "east"
    case = "west"  then "north"
    case = "south" then "west"
    case = "east"  then "south"
    endswitchon -> bug.bug_direction
enddefine;


define global bw_move_bug_to( world, xW, yW );
    lvars world, xW, yW;
    lvars bug = world.current_bug;
    lvars old_xW = bug.bug_xW, old_yW = bug.bug_yW;

    if xW < 0 or xW > world.world_width-1 then
        FAULT( 'bw_move_bug_to: xW out of range', [%world,xW,yW%] )
    endif;

    if yW < 0 or yW > world.world_height-1 then
        FAULT( 'bw_move_bug_to: yW out of range', [%world,xW,yW%] )
    endif;

    xW -> bug.bug_xW;
    yW -> bug.bug_yW;

    world_ved_move_bug_to( world )( old_xW, old_yW );
enddefine;


define global bw_forward( world );
    lvars world;
    lvars bug = world.current_bug;
    bw_move_bug_to( world, bw_rel_forward(world,bug.bug_xW,bug.bug_yW,1) );
enddefine;


define global bw_back( world );
    lvars world;
    lvars bug = world.current_bug;
    bw_move_bug_to( world, bw_rel_forward(world,bug.bug_xW,bug.bug_yW,-1) );
enddefine;


/*
Dropping and grasping.
----------------------
*/


define global bw_grab( world );
    lvars world;
    lvars bug = world.current_bug, id;
    (world.world_contents)( bug.bug_xW, bug.bug_yW ) -> id;

    if bug.bug_inventory.id_to_char = ` ` then
        bw_move_object( world, id, "inventory" );
        ;;; Don't draw the object, as it would overwrite the bug.
    endif;
enddefine;


define global bw_drop( world );
    lvars world;
    lvars bug = world.current_bug;
    lvars id = bug.bug_inventory;

    if world(bug.bug_xW, bug.bug_yW) = ` ` then
        bw_move_object( world, id, [%bug.bug_xW, bug.bug_yW%] );
    endif;
enddefine;


/*
Thinking.
---------
*/


define global bw_resume_bug( world );
    lvars world;
    runproc( 0, world.current_bug.bug_process );
enddefine;


define global exec(action);
    suspend( action, 1 );
enddefine;


/*
Updating perceptions.
---------------------
*/


/*  bw_bearing( world, xW, yW ):
        Returns the bearing of (xW,yW) relative to the bug in world.
*/
define global bw_bearing( world, xW, yW );
    lvars xW, yW;
    lvars xdiff,ydiff,forwarddiff,rightdiff;
    lvars bug = world.current_bug;
    lvars forwardvector=bug.bug_forwardvector,
          rightvector=bug.bug_rightvector;

    xW-bug.bug_xW -> xdiff;
    yW-bug.bug_yW -> ydiff;

    if xdiff=0 and ydiff=0 then
        FAULT( 'bw_bearing: xdiff=ydiff=0' )
    endif;

    forwardvector.vec_x*xdiff+forwardvector.vec_y*ydiff -> forwarddiff;
    rightvector.vec_x*xdiff+rightvector.vec_y*ydiff -> rightdiff;

    if abs(rightdiff)>abs(forwarddiff) then
        if rightdiff>0 then
            "right"
        else
            "left"
        endif;
    else
        if forwarddiff>0 then
            "forward"
        else
            "back"
        endif;
    endif;
enddefine;


/*  B_to_W( world, xB, yB ):
        Returns the co-ordinates in the world system of a point
        expressed in the bug's system.
*/
define B_to_W( world, xB, yB );
    lvars world, xB, yB;
    lvars xW, yW;
    lvars bug = world.current_bug;
    lvars forwardvector=bug.bug_forwardvector,
          rightvector=bug.bug_rightvector,
          bugxW = bug.bug_xW,
          bugyW = bug.bug_yW;

    bugxW + forwardvector.vec_x*yB + rightvector.vec_x*xB -> xW;
    bugyW + forwardvector.vec_y*yB + rightvector.vec_y*xB -> yW;

    xW; yW;
enddefine;


vars edgecheck;/*forward*/


define global bw_update_vision( world );
    lvars world;
    lvars xW, yW, i, j;

    lvars bug = world.current_bug;
    lvars forwardvector=bug.bug_forwardvector,
          rightvector=bug.bug_rightvector;
    lvars xV = bug.bug_xV,
          yV = bug.bug_yV;

    for i to bug.bug_retina_width do
        for j to bug.bug_retina_height do
            B_to_W( world, i-xV, j-yV ) -> yW -> xW;
            if edgecheck( world, xW, yW ) then
                world( xW, yW )
            else
                ` `
            endif -> (bug.bug_retina)(i,j);
        endfor;
    endfor;
enddefine;


/*  edgecheck( world, xW, yW ):
        Returns true if xW,yW are within world, false otherwise.
*/
define edgecheck( world, xW, yW );
    lvars world, xW, yW;
    xW>=0 and xW<=world.world_width-1 and
    yW>=0 and yW<=world.world_height-1;
enddefine;


define global bw_say( world, other_id, list );
    lvars world, other_id, list;
    lvars bug_id = world.bw_current_bug;
    put_sentence( world, bug_id, other_id, list );
enddefine;


define global bw_user_say( world, other_id, list );
    lvars world, other_id, list;
    put_sentence( world, "user", other_id, list );
enddefine;


define put_sentence( world, from_id, to_id, list );
    lvars world, from_id, to_id, list;
    lvars to_s;
    vars pre, post;
    if to_id = "user" then
        world.world_user_heards
    else
        ((world.world_bugs)(to_id)).bug_heards
    endif -> to_s;
    if to_s matches [ ?? ^ !pre ^from_id = ?? ^ !post ] then
        [ ^^pre ^from_id ^list ^^post ]
    else
        [ ^from_id ^list ^^(to_s) ]
    endif -> to_s;
    if to_id = "user" then
        to_s -> world.world_user_heards
    else
        to_s -> ((world.world_bugs)(to_id)).bug_heards
    endif;
enddefine;


define global bw_clear_sentences( world );
    lvars world;
    lvars i;
    [] -> world.world_user_heards;
    for i to world.world_max_bugs do
        [] -> ((world.world_bugs)(i)).bug_heards;
    endfor;
enddefine;


/*
Bug state access.
-----------------
*/


define global bw_bug_xW( world );
    lvars world;
    lvars bug = world.current_bug;
    bug.bug_xW;
enddefine;


define global bw_bug_yW( world );
    lvars world;
    lvars bug = world.current_bug;
    bug.bug_yW;
enddefine;


define global bw_forwardvector( world );
    lvars world;
    lvars bug = world.current_bug;
    bug.bug_forwardvector;
enddefine;


define global bw_rightvector( world );
    lvars world;
    lvars bug = world.current_bug;
    bug.bug_rightvector;
enddefine;


define global bw_direction( world );
    lvars world;
    lvars bug = world.current_bug;
    bug.bug_direction;
enddefine;


define global bw_retina( world );
    lvars world;
    lvars bug = world.current_bug;
    bug.bug_retina;
enddefine;


define global bw_display_retina( world );
    lvars world;
    lvars bug = world.current_bug;
    lvars i, j;
    for j from bug.bug_retina_height by -1 to 1 do
        for i to bug.bug_retina_width do
            if i=bug.bug_xV and j=bug.bug_yV then
                cucharout( `B` )
            else
                cucharout( (bug.bug_retina)(i,j) );
            endif;
        endfor;
        1.nl;
    endfor;
    1.nl;
enddefine;


define global bw_retina_to_list( world, f );
    lvars world, f;
    lvars i, j;
    lvars bug = world.current_bug;
    lvars xV=bug.bug_xV, yV=bug.bug_yV;

    [%  for i to bug.bug_retina_width do
            for j to bug.bug_retina_height do
                f( i-xV, j-yV,
                   (bug.bug_retina)(i,j)
                 );
            endfor;
        endfor;
    %]
enddefine;


define global bw_xV( world );
    lvars world;
    lvars bug = world.current_bug;
    bug.bug_xV;
enddefine;


define global bw_yV( world );
    lvars world;
    lvars bug = world.current_bug;
    bug.bug_yV;
enddefine;


define global bw_heard_from( world, id );
    lvars world;
    lvars bug = world.current_bug;
    lvars heards = bug.bug_heards;
    vars sentence;

    if heards matches [ == ^id ? ^ !sentence == ] then
        sentence
    else
        []
    endif;
enddefine;


define global bw_heard_by_user_from( world, id );
    lvars world;
    lvars bug = world.current_bug;
    vars sentence;

    if world.world_user_heards matches [ == ^id ? ^ !sentence ] then
        sentence
    else
        []
    endif;
enddefine;


define global bw_inventory( world );
    lvars world;
    lvars bug = world.current_bug;
    bug.bug_inventory.id_to_char;
enddefine;


define global bw_rel_forward( world, xW, yW, rel );
    lvars world, xW, yW, rel;
    lvars bug = world.current_bug;
    xW + (bug.bug_forwardvector.vec_x)*rel;
    yW + (bug.bug_forwardvector.vec_y)*rel;
enddefine;


define global bw_rel_right( world, xW, yW, rel );
    lvars world, xW, yW, rel;
    lvars bug = world.current_bug;
    xW + (bug.bug_rightvector.vec_x)*rel;
    yW + (bug.bug_rightvector.vec_y)*rel;
enddefine;


define global bw_kill_bug( world );
    lvars world;
    lvars bug = world.current_bug;
    true -> bug_is_dead(bug);
enddefine;


define global bw_bug_is_dead( world );
    lvars world;
    lvars bug = world.current_bug;
    bug_is_dead(bug);
enddefine;


/*
World state access.
-------------------
*/


define global bw_world_width( world );
    lvars world;
    world.world_width;
enddefine;


define global bw_world_height( world );
    lvars world;
    world.world_height;
enddefine;


/*
Creating worlds in Ved.
-----------------------
*/


vars fit;            /*forward*/
vars locate_in_world;/*forward*/


/*  vedworld():
        Scans the current Ved buffer and if no errors are detected,
        returns a world record for it. It works by looking for the
        bounds of the buffer, skipping header lines, reading and
        checking the specification line, and copying everything
        below it into the world's character array. It also checks
        for the presence of the Bug and food, and works out their
        coordinates.

        At the moment, it works for worlds with one bug only.
*/
define vedworld() -> result;
    lvars result;
    lvars i, j, yVED_min, yVED_max, xVED_min, xVED_max;
    lvars first_non_blank;
    lvars bug_xW, bug_yW, food_xW, food_yW;
    lvars objects_file;
    lvars line, c, bug_id;

    /*  Find first non-blank line.  */
    1 -> i;
    while ( vedjumpto(i,1); vedtrimline();
            vvedlinesize = 0 or starts_with(vedthisline(), `!` )
          ) do
        1 + i -> i;
    endwhile;
    i -> first_non_blank;

    /*  Get name of objects file.  */
    vedjumpto( first_non_blank, 1 );
    vedmoveitem() -> objects_file;
    if vedline /= first_non_blank then
        vederror( 'Missing objects-file' );
    endif;
    if not(objects_file.isword) then
        vederror( 'Objects-filename not a name' );
    endif;
    objects_file >< '.p' -> objects_file;

    /*  Get top line of world.  */
    first_non_blank + 1 -> yVED_min;

    /*  Get bottom line of world.  */
    vvedbuffersize -> i;
    while ( vedjumpto(i,1); vedtrimline(); vvedlinesize = 0 ) do
        i - 1 -> i;
    endwhile;
    i -> yVED_max;

    /*  Find first and last column.  */
    999 -> xVED_min;
    1 -> xVED_max;
    for i from yVED_min to yVED_max do
        vedjumpto(i,1);
        vedtrimline();
        min( xVED_min, first_non_space_pos(vedthisline()) ) -> xVED_min;
        max( xVED_max, last_non_space_pos(vedthisline()) ) -> xVED_max;
    endfor;
    new_world( xVED_max-xVED_min+1, yVED_max-yVED_min+1 ) -> result;

    /*  Copy world from buffer.  */
    for j from yVED_min to yVED_max do
        vedjumpto(j,1);
        vedtrimline();
        fit( vedthisline(), xVED_min, xVED_max ) -> line;
        for i from 1 to xVED_max-xVED_min+1 do
            line(i) -> c;
            if c = `B` or c = `C` then
                c-`B`+1 -> bug_id;
                i-1 -> bug_xW;
                yVED_max-j -> bug_yW;
                expand( result.world_buglist, bug_id ) -> result.world_buglist;
                [% bug_xW, bug_yW %] -> (result.world_buglist)(bug_id);
                ` ` -> c;
            endif;
            c -> (result.world_initial_chars)( i-1, yVED_max-j );
        endfor;
    endfor;

    /*  Locate food.  */
    if ( locate_in_world( result.world_initial_chars, `+` ) ->> food_yW ) = false then
;;;        vederror( 'No food in world' )
        ;
    else
        () -> food_xW;
    endif;

    objects_file -> result.world_objects_file;
enddefine;


/*  vedmakeworld( proc ):
        Reads world from the current Ved buffer, converts it
        to a world record w, and calls
            proc( w, name )
        where name is the argument given to the Ved command.

        When using Pop-11, proc just assigns w to valof(name). However,
        we might want to use 'vedsetworld' in other contexts. See
        comment in RETINA.P under vedretina.
*/
define vedmakeworld( proc );
    lvars proc;
    lvars varname, world, args, len;

    if vedargument = '' then
        "world" -> varname;
    else getvedargs( [1] ) -> args -> len;
        if len = 1 then
            args(1).consword -> varname;
        endif;
    endif;

    vedworld() -> world;

    proc( world, varname );

enddefine;


define global ved_world();
    vedmakeworld(
        procedure(world,varname);
            lvars world,varname;
            world -> valof(varname)
        endprocedure
    );
enddefine;


/*
Saving worlds to file.
----------------------
*/


define ved_saveworld();
    lvars the_world, file;

    if vedargument = '' then
        sysfilename(vedcurrent)
    else
        vedargument
    endif -> file;
    add_file_defaults( '', file, '.w' ) -> file;

    vedputmessage( 'Copying world' );
    vedworld() -> the_world;
    vedputmessage( 'Saving world' );
    the_world -> datafile( file><'' );
    vedputmessage( 'World saved in '><file );

    ;;; Have to catenate '' with -file- to convert to a string. If it's
    ;;; a word, then datafile will add an extension - see HELP DISCOUT.
enddefine;


define textfile_to_world( textfile );
    lvars textfile;

    vedopen( textfile ).erase;
    vedworld();
    /*  This relies on the fact that when you 'vedopen' a file,
        it apparently becomes the current Ved buffer, even though
        it isn't displayed on screen. Hence 'vedworld' can
        operate on it.
    */
enddefine;


/*
Loading worlds from file.
-------------------------
*/


define textfile_to_worldfile( textfile, worldfile );
    lvars textfile, worldfile;
    lvars the_world;

    pr( 'Copying world\n' );
    textfile_to_world( textfile ) -> the_world;

    add_file_defaults( '', worldfile, '.w' ) -> worldfile;

    pr( 'Saving world\n' );
    the_world -> datafile( worldfile );

    pr( 'World saved in '><worldfile><'\n' );
enddefine;


define global worldfile_to_world( wf );
    lvars wf;
    datafile( wf )
enddefine;


/*
String operations for world-building.
-------------------------------------

We use these when searching Ved buffers, looking for the bug, and
so on.
*/


/*  locate_in_world( chars, c ):
        Returns the world coordinates of character c in chars (a world's
        initial character array. If there's more than one occurrence,
        which one it finds is undefined. If c not found, returns false.
*/
define locate_in_world( chars, c );
    lvars chars, c;
    lvars i, j, bounds=boundslist(chars);
    for i from bounds(1) to bounds(2) do
        for j from bounds(3) to bounds(4) do
            if chars(i,j) = c then
                return( i, j );
            endif;
        endfor;
    endfor;
    false;
enddefine;


/*  fit( s, low, high ):
        That substring of s which begins at low, and extends to high.
        If s is not that long, the result is padded with spaces.
        Not world-specific at all: could be put in a general-purpose
        library.
*/
define fit( s, low, high );
    lvars s, low, high;
    lvars i, len=datalength(s);
    for i from low to high do
        if i > len then ` ` else s(i) endif;
    endfor;
    consstring( high-low+1 );
enddefine;


endsection;
nces( world );
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                   worlds.tex                                                                                          100705  017064  000205  00000035360 05427665732 007430  0                                                                                                     47426                                                                                    1  0                                                                                                                                                                 \documentstyle[a4,epsf,alltt]{article}
\begin{document}


\include{commands}


\title{Creating your own worlds}
\author{Jocelyn Paine}
\maketitle


This handout shows you how to construct your own production system
programs. I assume that you've already read the notes on {\it
Introduction to the editor}, and that you know how to run Eden,
including the world-editor.

There are three aspects to creating your own world. These are: defining
new objects; defining new bug senses; and creating new arrangements of
existing objects. The latter is simplest, so I'll talk about it first.


\section{New arrangements of existing objects}

You can do this entirely via the editor. The simplest way to start is by
modifying an existing world. Let's suppose you choose to modify
\verb/psworld2/. Then you would start by giving, from Prolog, the command
\begin{verbatim}
help psworld2
\end{verbatim}
This will give you a display like that of figure~\ref{worlds:psworld2},
below.
\vfigstart
\begin{verbatim}
!  PSWORLD2

pb_objects
        ***********
        *         *
        *  B   S  *
        *         *
        *+     1  *
        ***********

\end{verbatim}
\vfigend{worlds:psworld2}{The contents of {\tt psworld2}}

In this display, the bottom part will already be familiar to you. What
about the rest? The first line is a {\it comment}. This has no function
as far as Eden is concerned, and its only purpose is to convey
information to a human reader. In this case, it just gives the name of
the file, in case I forget while editing. In world definitions, comments
always begin with a \verb/!/, placed right at the start of a line.

The second line is left blank. You can have as many or as few blank
lines as you want: I usually leave one, for readability.

The third line contains the name of the {\it objects file}. This file
contains some small Pop-11 programs defining how objects respond to
various ``forces'', and links the symbols for objects to these programs.
Thus it tells Eden that boulders have the symbol verb/*/, and are
impassable; that food has the symbol \verb/+/, and can be grabbed and
used; and so on.

Finally, the world itself must start on the line below the objects
file's name.

Once you have done the \verb/help/ command and got this display, use
\verb/name/ to make it into one of your own files. Thus you could do
\begin{verbatim}
ENTER name myworld RETURN
\end{verbatim}
to create a world-file called \verb/MYWORLD/. The handout on
{\it Editing your own programs} shows another use for the \verb/name/
command.

You can now edit this file, making changes as described in the next
section. The best plan here is just to change the world itself. If you
are keen, it would be nice to change the first line so it reflects your
own filename, but Eden won't care if you don't. Do not change the third
line. You don't know enough to create your own objects files, so you will
have to stick with those I supply.


\subsection{Making small changes, and saving the world}

The easiest type of change is just --- say --- to add a new piece of
food, or delete a coin. You do this by using the edit keys in the usual
way. You will need to take care to keep objects on the right of your
change lined up, and you may have to add or delete some spaces to do so.

Note: you will see that the original file contains a \verb/B/. This
symbolises the starting position of the bug. You can move this, but you
must have it somewhere inside the world. If not, you won't be allowed to
save the world. Do not have more than one bug! You can't change the
bug's initial direction: Eden assumes it is always facing east.

Once you have made your change, you can then save it. To do so, use the
Ved command \verb/saveworld/. Thus:
\begin{verbatim}
ENTER saveworld RETURN
\end{verbatim}
This will save the new world, in your own directory or work area, under
the name you gave when using the \verb/name/ command.

Then exit the edit, by doing
\begin{verbatim}
ENTER x RETURN
\end{verbatim}
If you don't do this, you will lose the diagram of the world, and will
have to create it again next time.

To run a bug in the new world, just use its name as the second argument
to \verb/eps/. Thus:
\begin{verbatim}
eps( psbug2, myworld ).
\end{verbatim}

Note: you must do a \verb/saveworld/ before running a bug in your world.
Worlds are stored in two forms: as their picture, and as a specially
encoded or ``compiled'' form used by \verb/eps/. When you do the ENTER
\verb/x/ RETURN, it saves the picture. When you do the \verb/saveworld/,
it saves the compiled form. \verb/eps/ needs the latter, because it
can't work directly off the picture.


\subsection{Another world}

You may find it helpful to practice my making another world, this time
from \verb/psworld1/. Remember, the sequence is:
\begin{enumerate}
\item From Prolog, do a \verb/help/, e.g. \verb/help psworld1/. This
displays the original world file which I wrote.

\item Do a \verb/name/, e.g. \verb/ENTER name nextworld RETURN/. This
copies my original into your file.

\item Edit that, leaving the name of the objects file intact. Make sure
your world contains a \verb/B/, to show where the bug starts off. The
bug will be assumed to face east.            

\item Save the world in an \verb/eps/-useable form, i.e. \verb/ENTER
saveworld RETURN/.

\item Save the picture, i.e. \verb/ENTER x RETURN/.

\item Run a bug in the new world, e.g. \verb/eps(psbug2,nextworld)./.
\end{enumerate}


\subsection{Making bigger changes, and using static mode}

These may entail deleting and retyping several lines. If so, you will
find the commands in the TEACH file \verb/ved3/ useful, particularly
mark and delete.

One of the problems I mentioned earlier was that if you add or delete an
object, the objects to its right are pushed out of line. You can avoid
that by putting the editor into {\it static} mode. To do so, give the
Ved command
\begin{verbatim}
ENTER static RETURN
\end{verbatim}
Once you have done this, typing a character will overwrite what's
underneath rather than moving it. This is the same mode that the editor
is in when you use the Eden control command \verb/e/.

It's a good idea to get out of static mode before editing other files.
If you don't, you may get confused. To do so, just give the
\verb/static/ command again. This command is like a toggle-switch: it
turns the mode on, then off, then on, \ldots


\subsection{The drawing commands}

There are two Ved commands you can use to draw lines. They are most
useful for drawing walls of boulders, but you can use them for other
things too.

To demonstrate them, start editing a file. Any file will do; it doesn't
have to be a world file. Move the cursor somewhere, and then give the
command
\begin{verbatim}
ENTER point RETURN
\end{verbatim}

Then move the cursor somewhere else, and give the command
\begin{verbatim}
ENTER draw RETURN
\end{verbatim}
You will see a line of \verb/*/ characters appear. Because of the way
characters are displayed, this works best when the lines are vertical,
horizontal, or at 45 degrees.

You can use \verb/draw/ commands one after the other. Move the cursor to
yet another place and type ENTER \verb/draw/ RETURN again. This will
draw another line from the end of the first one. You can continue doing
this for as long as you want. If you want to change the starting point,
you can always do another \verb/point/.

To draw lines of some other character, put a different symbol after
\verb/draw/. Thus
\begin{verbatim}
draw +
\end{verbatim}
will draw a line of \verb/+/ characters.


\section{Defining new objects}

This can be done, but not by you, since it requires knowledge of the
Pop-11 programming language and of how Eden works. If you want to
experiment with different objects, ask me, and I'll be able to define
them fairly quickly.

There are a lot of suggestions below, but they're all quite rough. Some
worlds are better for investigating AI in than others, but current
Departmental resources don't allow me to do any further work on this. 

Here are some possibilities:
\begin{itemize}

\item Some objects allow the bug to share a square with them, others
don't. You can regard the first type as impassable, such as boulders.
I usually think of the second type as objects which are small enough to
be walked over or past, such as keys and food.

You could have an object which is impassable unless the bug is carrying
some object. It might require the bug to use this object first, as doors
do a key; or it might just be passable if the bug is holding something
which gives it access. You could also have objects which react to some
other characteristic of the bug, such as its energy; or which remain
impassable for a given number of moves and then vanish; or which remain
passable for a given number of moves and then become impassable (shrubs
growing into trees, perhaps).

You could also have an object which is {\it passable} unless the bug is
carrying something, such as the ``narrows'' mentioned in the table at
the end of {\it How to run Eden}.

\item Some objects can be picked up, others can't. Usually, those that
can't are the impassable ones, but this doesn't have to be so.

It is possible to make objects which when picked up, would leave another
one behind. I'm not sure what use this would be.

\item Most objects you've seen are static, and don't move unless the bug
touches them. However, it's possible to have autonomous objects, such as
``mice'' that move away from a persuing bug. If there's time, I may be
able to define such things.                 

\item Most of the objects also have no internal state, meaning they
react the same way every time something happens. But again, this need
not be so. For example, it's possible to make a slot machine which
counts the coins put into it and only dispenses food when a certain
total is reached. As another example, one of my worlds contains a
``factory'' object which dispenses a coin after the bug has used it a
certain number of times. I use this in conjunction with the slot
machine; if the bug can't find food or coins, then it has to work for
its living.

\item Objects could disappear, generate new objects, or change into new
objects, either spontaneously or when touched.

\item It's not possible directly to have objects with internal parts.
However, this can be imitated. For example, the bug could be set a task
of gathering the parts of a ``key of power''. When it puts these in
adjacent squares and uses one of them, the parts disappear and are
replaced by the key. This kind of setup can be used in a number of
planning puzzles.

\item Objects can affect the bug in various ways. For example, they
could kill it or reduce its energy: either when it just passes near
them, or when it enters the same square, or when it does something with
them.

\item Objects need not be deterministic. Their effect could depend on a
random-number generator. For example, the slot machine does not need to
drop its food in the same place each time. Non-deterministic objects are
a good way of demonstrating how flexible various AI techniques are.

\item Objects can affect the way the bug moves. For example, you could
have a ``teleporter'' which transports the bug to a distant location.
This location might depend on what the bug is carrying, or on its last
action. You can also have ``roads'' or ``tracks'' which confine the bug
to move along them until it reaches a junction. This is a good way to
experiment with path-finding techniques. In this connection, see also
the comment about new actions, below.        

\end{itemize}


\section{Defining new bugs}

The existing bug has one sense, vision. It's possible to define new
senses, and to make them depend on the objects. For example, one can
have a sense of smell. This might just give the general direction ---
rigght, left, forward or back --- of the nearest piece of food, or of
all the pieces of food. If the latter, then it could just give the
average direction, or it could give a list of directions, one for each
piece.

A sense of hearing could be added, so that the bug hears a ```bang''
when an object explodes, or squeaks from the mouse.

The sense of vision could be changed by making it less precise, or by
increasing its range.

As well as senses, one can alter the bug's ``physiology''. For example,
one can give the bug a measure of energy. As it moves, this energy
steadily decreases; it is replenished whenever the bug eats a piece of
food.

More interesting is to have competing physiological requirements which
force the bug to choose between goals. For an example of this, try
\begin{verbatim}
eps( psbug3, psworld3 ).
\end{verbatim}
\verb/psworld3/ defines a bug which has an energy which decreases with
each turn but increases when it feeds. The bug also has a thirst, which
increases exponentially with time. Finally, the bug can smell food
around it, as a list of directions, one for each piece of food. These
three quantities are given in the \verb/ETS/ part of the second status
line, on the right of the display.

The rules in \verb/psbug3/ are a simple attempt at dealing with these
requirements. Two of these rules involve {\it variables} --- the
\verb/T/ in \verb/thirst(T)/) yet. Each condition makes sure that the
rule isn't triggered unless the bug's thirst is greater than 20.
However, these rules also have higher priorities than the other three
rules, meaning that resolution-by-priority will choose them in
preference. So once the bug does realise that it needs to find water, it
will do so immediately, without breaking for food.

The world contains water objects, \verb/w/. The bug can get over these,
and then use them. This is drinking and reduces the thirst.


\section{Defining new actions}

It's also possible to give the bug a wider repertoire of actions. As it
stands, Eden has one general-purpose manipulate action, ``use''.
However, one could add more specific actions.

As one example, there could be a special ``jump'' action, which is used
when the bug enters a teleporter. The bug would have to supply an
auxiliary piece of data giving its desired destination.

As another example, it's possible to associate other sensory qualities
with objects. For example, one piece of food might have the colour red,
and another the colour yellow. These would not (unlike the symbol
\verb/+/) be sensed automatically by the bug's vision. Instead, it would
have to direct its attention to a specific place in its visual field,
and issue an \verb/examine/ action. This would then dump the colour
into some kind of short-term memory.


\end{document}
 as their picture, and as a specially
encoded or ``compiled'' form used by \verb/eps/. When you do the ENTER
\verb/x/ RETURN, it saves the picture. When you do the \verb/saveworld/,
it saves the compiled form. \verb/eps/ needs the latter, because it
can't                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                 good idea to get out of static mode before editing other files.
If you don't, you may get confused. To do so, just give the
\verb/static/ command again. This command is like a toggle-switch: it
turns the mode on, then off, then on, \ldots


\subsection{The drawing commands}

There are two Ved commands you can use to draw lines. They are most
useful for drawing walls of boulders, but you can use them for other
things too.

To demonstrate them, start editing a file. Any file will do; it doesn't
have to be a world file. Move the cursor somewhere, and then give the
command
\begin{verbatim}
ENTER point RETURN
\end{verbatim}

Then move the cursor somewhere else, and give the command
\begin{verbatim}
ENTER draw RETURN
\end{verbatim}
You will see a line of \verb/*/ characters appear. Because of the way
characters are displayed, this works best when the lines are vertical,
horizontal, or at 45 degrees.

You can use \verb/draw/ commands one after the other. Move the cursor to
yet another place and type ENTER \verb/draw/ RETURN again. This will
draw another line from the end of the first one. You can continue doing
this for as long as you want. If you want to change the starting point,
you can always do another \verb/point/.

To draw lines of some other character, put a different symbol after
\verb/draw/. Thus
\begin{verbatim}
draw +
\end{verbatim}
will draw a line of \verb/+/ characters.


\section{Defining new objects}

This can be done, but not by you, since it requires knowledge of the
Pop-11 programming language and of how Eden works. If you want to
experiment with different objects, ask me, and I'll be able to define
them fairly quickly.

There are a lot of suggestions below, but they're all quite rough. Some
worlds are better for investigating AI in than others, but current
Departmental resources don't allow me to do any further work on this. 

Here are some possibilities:
\begin{itemize}

\item Some objects allow the bug to share a square with them, others
don't. You can regard the first type as impassable, such as boulders.
I usually think of the second type as objects which are small enough to
be walked over or past, such as keys and food.

You could have an object which is impassable unless the bug is carrying
some object. It might require the bug to use this object first, as doors
do a key; or it might just be passable if the bug is holding something
which gives it access. You could also have objects which react to some
other characteristic of the bug, such as its energy; or which remain
impassable for a given number of moves and then vanish; or which remain
passable for a given number of moves and then become impassable (shrubs
growing into trees, perhaps).

You could also have an object which is {\it passable} unless the bug is
carrying something, such as the ``narrows'' mentioned in the table at
the end of {\it How to run Eden}.

\item Some objects can be picked up, others can't. Usually, those that
can't are the impassable ones, but this doesn't have to be so.

It is possible to make objects which when picked up, would leave another
one behind. I'm not sure what use this would be.

\item Most objects you've seen are static, and don't move unless the bug
touches them. However, it's possible to have autonomous objects, such as
``mice'' that move away from a persuing bug. If there's time, I may be
able to define such things.                 

\item Most of the objects also have no internal state, meaning they
react the same way every time something happens. But again, this need
not be so. For example, it's possible to make a slot machine which
counts the coins put into it and only dispenses food when a certain
total is reached. As another example, one of my worlds contains a
``factory'' object which dispenses a coin after the bug has used it a
certain number of times. I use this in conjunction with the slot
machine; if the bug can't find food or coins, then it has to work for
its living.

\item Objects could disappear, generate new objects, or change into new
objects, either spontaneously or when touched.

\item It's not possible directly to have objects with internal parts.
However, this can be imitated. For example, the bug could be set a task
of gathering the parts of a ``key of power''. When it puts these in
adjacent squares and uses one of them, the parts disappear and are
replaced by the key. This kind of setup can be used in a number of
planning puzzles.

\item Objects can affect the bug in various ways. For example, they
could kill it or reduce its energy: either when it just passes near
them, or when it enters the same square, or when it does something with
them.

\item Objects need not be deterministic. Their effect could depend on a
random-number generator. For example, the slot machine does not need to
drop its food in the same place each time. Non-deterministic objects are
a good way of demonstrating how flexible various AI techniques are.

\item Objects can affect the way the bug moves. For example, you could
have a ``teleporter'' which transports the bug to a distant location.
This location might depend on w