/*  VEDREADLINECHARS.P  */


section $-vedreadlinechars => vedreadlinechars;


/*
SPECIFICATION
-------------

This module exports a routine for reading a line from inside Ved, as
a list of characters.

PUBLIC vedreadlinechars( message, prompt ):

This procedure behaves like vedreadline (see HELP vedreadline), but
returns a list of characters. It should only be called when editing a
file. It does a vedputmessage(message), displaying it on the status
line, then jumps to the current Ved line, and inserts 'prompt'. It then
allows the user to edit that line, returning when he types RETURN or
ENTER. The result is returned as a list of characters, omitting leading
spaces and trailing spaces and newlines.
*/


/*
IMPLEMENTATION
--------------

I adapted this from lib vedreadline. It's a shame that the Pop
implementors have chosen to hide the source of readline, because that is
apparently better. Not helpful.
*/


define global vedreadlinechars( message, prompt );
    lvars message, prompt;
    vars vedbreak = false;
    lvars char proc plen, done = false;

    vedputmessage(message);

start:
    datalength(prompt) fi_+ 1 -> plen;
    vedinsertstring(prompt);
    vedcleartail();
    vedscreenbell();

    until done do
        max(plen, vedcolumn) -> vedcolumn;
        vedcheck();
        vedcursorset() ->;
        vedinascii() -> char;
        if char == `\r` or char == `\^D` then
            true -> done
        elseif (vedgetproctable(char) ->> proc) == vedinsertvedchar
                or proc == vedcharmiddle or proc == vedtextright
                or proc == vedrefresh
        then proc()
        elseif (proc == vedchardelete or proc == vedwordleft
                    or proc == vedcharleft or proc == vedwordleftdelete)
                and vedcolumn fi_> plen
        then
            proc()
        elseif (proc == vedcharright or proc == vedwordright
                    or proc == veddotdelete or proc == vedwordrightdelete
                    or proc == vedcleartail or proc == vedchangecase)
                and vedcolumn fi_<= vvedlinesize
        then proc()
        elseif proc == vedenter then true -> done
        elseif proc == vedscreenleft or proc == vedtextleft then
            plen -> vedcolumn;
        elseif proc == vedclearhead then
            vedclearhead(); goto start
        elseif proc == vedlinedelete then
            vedclearhead(); vedcleartail(); goto start
        elseif proc == vedcleartail then
            vedcleartail();
        else vedscreenbell()
        endif;
        vedsetlinesize();
    enduntil;

    ;;; now create the list of text
    vedtrimline();
    copy(vedthisline()) -> proc;
    stringin(proc) -> proc;
    repeat plen fi_- 1 times erase(proc()) endrepeat;
    [% until (proc() ->> char) == termin do char enduntil %];
enddefine;


endsection;
